package discovery

type Game struct {
	Name        string `json:"name"`
	ID          int    `json:"id"`
	GiantbombID int    `json:"giantbombId"`
	Images      struct {
		IconURL   string `json:"icon_url"`
		MediumURL string `json:"medium_url"`
		ScreenURL string `json:"screen_url"`
		SmallURL  string `json:"small_url"`
		SuperURL  string `json:"super_url"`
		ThumbURL  string `json:"thumb_url"`
		TinyURL   string `json:"tiny_url"`
	} `json:"images"`
	Popularity int `json:"popularity"`
	Properties struct {
		XboxTitleID    string `json:"xbox_title_id"`
		XboxoneTitleID string `json:"xboxone_titleid"`
	} `json:"properties"`
	BoxArt struct {
		Large    string `json:"large"`
		Medium   string `json:"medium"`
		Small    string `json:"small"`
		Template string `json:"template"`
	} `json:"boxArt"`
	LogoArt struct {
		Large    string `json:"large"`
		Medium   string `json:"medium"`
		Small    string `json:"small"`
		Template string `json:"template"`
	} `json:"logoArt"`
	ExtendedProperties *ExtendedGameProperties `json:"extended_properties,omitempty"`
}

type Aliases struct {
	Aliases []string `json:"aliases"`
}

type LocalizedGame struct {
	Game
	Locale                 string `json:"locale"`
	LocalizedName          string `json:"localized_name"`
	LocalizedGameBannerURL string `json:"localized_game_banner_url"`
}

type Localizations struct {
	GameID         int               `json:"game_id"`
	LocalizedNames map[string]string `json:"localizations"`
}

type LiveGame struct {
	Channels int  `json:"channels"`
	Viewers  int  `json:"viewers"`
	Game     Game `json:"game"`
}

type LiveGames struct {
	Games []LiveGame `json:"games"`
	Total int        `json:"total"`
}

type TopParams struct {
	Limit  *int
	Offset *int
	IDs    []string
}

type SuggestParams struct {
	Live bool
}

type ExtendedGameProperties struct {
	Developers          []string `json:"developers,omitempty"`
	Publishers          []string `json:"publishers,omitempty"`
	Themes              []string `json:"themes,omitempty"`
	Concepts            []string `json:"concepts,omitempty"`
	Franchises          []string `json:"franchises,omitempty"`
	SimilarGames        []string `json:"similar_games,omitempty"`
	Platforms           []string `json:"platforms,omitempty"`
	Genres              []string `json:"genres,omitempty"`
	Aliases             []string `json:"aliases,omitempty"`
	OriginalReleaseDate string   `json:"original_release_date,omitempty"`
}
