import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
import { Config } from './config';

export interface BastionSecurityGroupStackProps {
  vpc: ec2.Vpc;
}

/**
 * This stack only contains the Bastion's security group, to avoid a cyclic reference issue.
 * Do not add anything else to it.
 */
export class BastionSecurityGroupStack extends cdk.Stack {
  securityGroup: ec2.SecurityGroup;

  constructor(scope: cdk.Construct, config: Config, props: BastionSecurityGroupStackProps) {
    super(scope, config.prefix + 'BastionSecurityGroup', { env: config.env });

    this.securityGroup = new ec2.SecurityGroup(this, 'BastionSg', { vpc: props.vpc });
  }
}
