import * as cdk from '@aws-cdk/core';
import * as ecr from '@aws-cdk/aws-ecr';
import { Config } from './config';

export class ClamAvDataStack extends cdk.Stack {
  ecrRepo: ecr.Repository;

  constructor(scope: cdk.Construct, config: Config) {
    super(scope, config.prefix + 'ClamAvData', { env: config.env });

    this.ecrRepo = new ecr.Repository(this, 'ClamAV');
  }
}
