import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as efs from '@aws-cdk/aws-efs';
import * as ecr from '@aws-cdk/aws-ecr';
import { Config } from './config';
import { CommonComputeStack } from './common-compute-stack';

interface RepoHostDataStackProps {
  vpc: ec2.Vpc;
  commonComputeStack: CommonComputeStack;
}
/**
 * Repo Host - Data
 */
export class RepoHostDataStack extends cdk.Stack {
  ecrRepoHost: ecr.Repository;
  efsRepoHost: efs.FileSystem;

  constructor(scope: cdk.Construct, config: Config, props: RepoHostDataStackProps) {
    super(scope, config.prefix + 'RepoHostData', { env: config.env });

    this.ecrRepoHost = new ecr.Repository(this, 'repo_host', {
      repositoryName: 'repo_host',
    });

    // File Storage
    this.efsRepoHost = new efs.FileSystem(this, 'FileSystem', {
      vpc: props.vpc,
      encrypted: true,
    });

    this.efsRepoHost.connections.allowDefaultPortFrom(
      ec2.SecurityGroup.fromSecurityGroupId(this, 'DataSyncSecurityGroup', config.dataSyncSecurityGroup)
    );

    this.efsRepoHost.connections.allowDefaultPortFrom(props.commonComputeStack.cluster);
  }
}
