import * as ec2 from '@aws-cdk/aws-ec2';

export class Helper {
  public static addDefaultPortIngress(input: ec2.Connections, peer: ec2.IPeer, description?: string) {
    for (const sg of input.securityGroups) {
      sg.addIngressRule(peer, input.defaultPort!, description, true);
    }
  }

  public static addP2PDefaultPortIngress(
    input: ec2.Connections,
    peer: ec2.Connections,
    description?: string,
    remote: boolean = true
  ) {
    for (const sg of input.securityGroups) {
      for (const peerSg of peer.securityGroups) {
        sg.addIngressRule(peerSg, input.defaultPort!, description, remote);
      }
    }
  }

  public static addP2PPortIngress(
    input: ec2.Connections,
    peer: ec2.Connections,
    port: ec2.Port,
    description?: string
  ) {
    for (const sg of input.securityGroups) {
      for (const peerSg of peer.securityGroups) {
        sg.addIngressRule(peerSg, port, description, true);
      }
    }
  }
}
