import * as sqs from '@aws-cdk/aws-sqs';
import * as cdk from '@aws-cdk/core';

export class ExpandedQueue extends sqs.Queue {
  constructor(scope: cdk.Construct, name: string, deadLetterRetries: number = 3, props?: sqs.QueueProps) {
    super(scope, name, {
      deadLetterQueue:
        deadLetterRetries && deadLetterRetries >= 0
          ? {
              maxReceiveCount: deadLetterRetries,
              queue: new sqs.Queue(scope, name + 'DeadLetter'),
            }
          : undefined,
      ...props,
    });
  }
}
