package api

import (
	"github.com/kelseyhightower/envconfig"
)

// ParseConfig reads program args and environment variables
func ParseConfig() Config {
	conf := Config{}
	envconfig.MustProcess("", &conf)
	return conf
}

// Config contains values from environment variables.
// Default values are used for local development.
type Config struct {
	ENVNAME               string `default:"local" desc:"Current environment: local|dev|prod"`
	PORT                  int    `default:"8080" desc:"Port to run the service"`
	RBAC_HOST             string `default:"http://localhost:9000" desc:"RBAC service host URL"`
	E2_INGEST_HTTP_LAMBDA string `default:"arn:aws:lambda:us-west-2:597731042549:function:TwitchE2IngestHTTPLambda-LambdaFunction-12NOYMNGIBWTJ:live" desc:"e2-http service lambda name"`

	STATIC_ASSETS_DIR   string `default:"dist" desc:"Directory to serve static assets from"`
	STATIC_ASSETS_INDEX string `default:"index.html" desc:"Default content to be served if no file name matches the request path in the directory"`
}

func (conf Config) IsLocal() bool {
	return conf.ENVNAME == "local"
}

func (conf Config) PrintUsage() {
	if err := envconfig.Usage("", &conf); err != nil {
		panic(err)
	}
}
