# Welcome to your CDK TypeScript project!

This is a blank project for TypeScript development with CDK.

The `cdk.json` file tells the CDK Toolkit how to execute your app.

## Useful commands

 * `npm run build`   compile typescript to js
 * `npm run watch`   watch for changes and compile
 * `npm run test`    perform the jest unit tests
 * `cdk deploy`      deploy this stack to your default AWS account/region
 * `cdk diff`        compare deployed stack with current state
 * `cdk synth`       emits the synthesized CloudFormation template


# Vienna CDK

[AWS CDK](https://docs.aws.amazon.com/cdk/latest/guide/getting_started.html#getting_started_install) project to define the infrastructure on the AWS accounts.

## Requirements

- [Node.js](https://nodejs.org/): Using [nodenv](https://github.com/nodenv/nodenv) is recommended, and will automatically use the correct version of Node. If `nodenv` is not available, use the version of Node specified in `.node-version`.
- `mwinit`: to authenticate with Isengard. See https://wiki.twitch.com/display/AD/Using+Isengard+from+the+command+line+or+programatically for details.
- cd into this folder to run NPM and CDK commands.

### NPM commands

- `npm install`: Install and upgrade dependencies. Run this to install dependencies.
- `npm install @aws-cdk/aws-ecs`: Add a new dependency.

### CDK commands

You must execute CDK using `npx cdk` to use the project-local version. Do not use any globally installed version of `cdk`.

- `npx cdk ls`: List stacks.
- `npx cdk diff [<Stack>...]`: Compare changes with deployed stacks.
- `npx cdk synth [<Stack>...]`: Emit the synthesized CloudFormation template.
- `npx cdk deploy [<Stack>...]`: Deploy updated stacks.
