import * as ecr from '@aws-cdk/aws-ecr';
import * as cdk from '@aws-cdk/core';

interface EcrRepositoryStackProps extends cdk.StackProps {
  repositoryName: string;
}

export class EcrRepositoryStack extends cdk.Stack {
  public readonly ecrRepo: ecr.IRepository;

  constructor(scope: cdk.Construct, id: string, props: EcrRepositoryStackProps) {
    super(scope, id, props);

    // create ECR image repository
    const repo = new ecr.Repository(this, 'ECRRepo', {
      removalPolicy: cdk.RemovalPolicy.DESTROY,
      repositoryName: props.repositoryName,
    });
    repo.addLifecycleRule({ maxImageCount: 10 });
    this.ecrRepo = repo;
  }
}
