import * as cdk from '@aws-cdk/core';
import * as r53 from '@aws-cdk/aws-route53';
import { IVpc } from '@aws-cdk/aws-ec2';

export interface Route53StackProps extends cdk.StackProps {
  vpc: IVpc;
  vienna: string;
}

export class Route53Stack extends cdk.Stack {
  public readonly viennaZone: r53.IHostedZone;

  constructor(scope: cdk.Construct, id: string, props: Route53StackProps) {
    super(scope, id, props);

    this.viennaZone = new r53.PublicHostedZone(this, 'vienna-xarth', {
      zoneName: props.vienna,
    });
  }
}
