export type ViennaFormConfig = ViennaFormField[][];
export type ViennaFormValues = Record<string, string | number | boolean>;

export interface ViennaFormField {
  type: ViennaFormValueType;
  name: string;
  displayName: string;
  initialValue: string | boolean | number;
  selectOptions?: ViennaSelectOptions[];
}

interface ViennaSelectOptions {
  value: string | number;
  display: string;
}

export enum ViennaFormValueType {
  Bool = 'bool',
  String = 'string',
  Select = 'select',
}

export function getInitialValues<T extends ViennaFormValues>(formConfig: ViennaFormConfig): T {
  const values: ViennaFormValues = {};

  for (let fields of formConfig) {
    for (let field of fields) {
      values[field.name] = field.initialValue;
    }
  }

  return values as T;
}
