export type Maybe<T> = T | null;
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string;
  String: string;
  Boolean: boolean;
  Int: number;
  Float: number;
  Cursor: any;
  Time: any;
  Duration: any;
};

export type AcceptFriendRequestInput = {
  /** The authenticated user will accept the friend request sent by the user with an ID equal to targetID. */
  targetID: Scalars['ID'];
};

export type AcceptFriendRequestPayload = {
   __typename?: 'AcceptFriendRequestPayload';
  /** The user whose friend request was just accepted. */
  user?: Maybe<User>;
};

/** Enumerates possible errors when accepting a program agreement. */
export enum AcceptProgramAgreementError {
  /** Must have auth credentials to agree to a program agreement. */
  Unauthenticated = 'UNAUTHENTICATED',
  /** User does not have permission to agree to the program agreement for the targeted user. */
  Forbidden = 'FORBIDDEN',
  /** Version of the agreement provided in the input is not valid. */
  InvalidAgreementVersion = 'INVALID_AGREEMENT_VERSION',
  /** An internal error has occurred. */
  InternalError = 'INTERNAL_ERROR'
}

/** AcceptProgramAgreementInput is the input required when accepting a program agreement. */
export type AcceptProgramAgreementInput = {
  /** TargetUserID is the ID of the user whose program agreement will be accepted. */
  targetUserID: Scalars['ID'];
  /** Agreement type being accepted for payout onboarding. */
  type: PayoutOnboardingCategory;
  /** Version of agreement (e.g. "v1"). */
  version: Scalars['String'];
};

/** AcceptProgramAgreementPayload is the payload returned after accepting a program agreement. */
export type AcceptProgramAgreementPayload = {
   __typename?: 'AcceptProgramAgreementPayload';
  /** Describes error that occured while accepting a program agreement. */
  error?: Maybe<AcceptProgramAgreementError>;
  /** New workflow state. */
  workflow?: Maybe<PayoutOnboardingWorkflow>;
};

/** Errors from acceptSquadStreamInvitation mutation. */
export type AcceptSquadStreamInvitationError = {
   __typename?: 'AcceptSquadStreamInvitationError';
  /** Error from request to accept invitation. */
  code: AcceptSquadStreamInvitationErrorCode;
};

/** Possible errors from this mutation. */
export enum AcceptSquadStreamInvitationErrorCode {
  /** Invitation to be accepted does not exist. */
  InvitationNotFound = 'INVITATION_NOT_FOUND',
  /** Squad associated with the invitation does not exist. */
  SquadNotFound = 'SQUAD_NOT_FOUND',
  /** User does not have permissions to accept invitation. */
  Unauthorized = 'UNAUTHORIZED',
  /** Invitation not in pending state cannot be accepted. */
  InvitationCannotBeAccepted = 'INVITATION_CANNOT_BE_ACCEPTED',
  /** The recipient does not have access to squad streams. */
  UserCannotAccessSquads = 'USER_CANNOT_ACCESS_SQUADS'
}

/** Inputs to the acceptSquadStreamInvitation mutation. */
export type AcceptSquadStreamInvitationInput = {
  /** ID of the invitation to be accepted. */
  invitationID: Scalars['ID'];
};

/** Outputs from the acceptSquadStreamInvitation mutation. */
export type AcceptSquadStreamInvitationPayload = {
   __typename?: 'AcceptSquadStreamInvitationPayload';
  /** Error from mutation if exists. */
  error?: Maybe<AcceptSquadStreamInvitationError>;
  /** The accepted invitation. */
  invitation?: Maybe<SquadStreamInvitation>;
};

/** The information about all of a user's connected accounts. */
export type AccountConnectionSet = {
   __typename?: 'AccountConnectionSet';
  /** Connection information about a user's Blizzard account. */
  blizzard?: Maybe<UserBlizzardConnectionLink>;
  /** Connection infromation about a user's Facebook account. */
  facebook?: Maybe<UserFacebookConnectionLink>;
  /** Whether or not the user has a linked amazon account. */
  hasConnectedAmazon?: Maybe<Scalars['Boolean']>;
  /** Connection information about a user's Riot account. */
  riot?: Maybe<UserRiotConnectionLink>;
  /** Connection information about a user's Steam account. */
  steam?: Maybe<UserSteamConnectionLink>;
  /** Connection information about a user's Twitter account. */
  twitter?: Maybe<UserTwitterConnectionLink>;
  /** Connection information about a user's Youtube account. */
  youtube?: Maybe<UserYoutubeConnectionLink>;
};

/** AcknowledgeSubscriptionStateInput updates the state of the given subscription to aknowledged. */
export type AcknowledgeSubscriptionStateInput = {
  /** ID of the subscription being updated. */
  subscriptionID: Scalars['ID'];
};

/** AcknowledgeSubscriptionStatePayload returns the state of the subscription. */
export type AcknowledgeSubscriptionStatePayload = {
   __typename?: 'AcknowledgeSubscriptionStatePayload';
  /** The current state of the subscription. One of "active", "will_not_renew", or "canceled". */
  state?: Maybe<UnacknowledgedSubscriptionEventState>;
};

/** The input to be provided to the activateExtension mutation. */
export type ActivateExtensionInput = {
  /** The anchor the extension is getting activated into. */
  anchor: ExtensionAnchor;
  /** The composite ID of an extension installation <extensionID:version:channelID>. */
  extensionInstallationID: Scalars['ID'];
  /** The slot the extension is getting activated into. */
  slot: Scalars['String'];
};

/** The result of an activateExtension mutation. */
export type ActivateExtensionPayload = {
   __typename?: 'ActivateExtensionPayload';
  /** The resulting list of installed extensions after the activation. */
  installedExtensions: Array<ExtensionInstallation>;
};

/** ActivationState contains possible activation states found in the ActivationConfig. */
export enum ActivationState {
  /** The extension is activated into a slot on the channel. */
  Active = 'ACTIVE',
  /**
   * The extension has not been activated into a slot or required permsissions/config
   * is not set up yet.
   */
  Inactive = 'INACTIVE',
  /** The user rejected the permissions required for the extension to be activated. */
  RejectedPermissions = 'REJECTED_PERMISSIONS'
}

/** An action (and metadata about the action) which a user or session is performing. */
export type Activity = {
  /** The type of activity. */
  type?: Maybe<ActivityType>;
};

/**
 * ActivityInput represents what the user is doing right now.
 * 
 * If type is WATCHING, userID must be supplied.
 * 
 * If type is PLAYING, gameID must be supplied.
 */
export type ActivityInput = {
  gameID?: Maybe<Scalars['String']>;
  type?: Maybe<ActivityType>;
  userID?: Maybe<Scalars['String']>;
};

/** The categories of activities which users can engage in. */
export enum ActivityType {
  Playing = 'PLAYING',
  Streaming = 'STREAMING',
  Watching = 'WATCHING'
}

/** Amazon Digital Ad Service Properties. */
export type AdasProperties = {
   __typename?: 'ADASProperties';
  /**
   * The media partner that should be used for the ad break.
   * @deprecated No longer needed.
   */
  partner?: Maybe<Scalars['String']>;
  /**
   * The id for selecting the amazon ad campaign or program.
   * @deprecated No longer needed.
   */
  programID?: Maybe<Scalars['ID']>;
};

/** The context returned for the current ad request. */
export type AdContext = {
   __typename?: 'AdContext';
  /** The decline status for this ad request. */
  declineState: AdContextDeclineState;
  /** The id of the ad session this context applies to. */
  id: Scalars['ID'];
  /** The RAd service token used to validate subsequent ad event mutations. */
  radToken: Scalars['String'];
};

/** The decline state for the context. */
export type AdContextDeclineState = {
   __typename?: 'AdContextDeclineState';
  /** The reason the ad request was declined if it was declined. */
  reason?: Maybe<Scalars['String']>;
  /** Whether or not the client will request an ad. */
  shouldDecline: Scalars['Boolean'];
};

/** Advertising creative. */
export type AdCreative = {
   __typename?: 'AdCreative';
  /** The AdCreative's unique identifier. */
  id: Scalars['ID'];
  /** Integrated loudness value for this AdCreative. */
  integratedLoudness?: Maybe<Scalars['Float']>;
};

/** AddAutohostChannelsInput append channelIDs to a user's list to autohost. */
export type AddAutohostChannelsInput = {
  /** ChannelIDs that will be added to the list to autohost. */
  channelIDs: Array<Scalars['ID']>;
  /** UserID to update autohost list for. */
  userID: Scalars['ID'];
};

/** AddAutohostChannelsPayload returns the user whose autohostChannels field had been updated. */
export type AddAutohostChannelsPayload = {
   __typename?: 'AddAutohostChannelsPayload';
  /** User whose autohostChannels field had been updated. */
  user?: Maybe<User>;
};

export type AddBrowserPushSubscriptionInput = {
  /** An authentication secret. It must be a non-blank string. */
  auth: Scalars['String'];
  /**
   * A custom URL pointing to a push server, which can be used to send a push message to the
   * particular service worker instance that subscribed to the push service. It must be a
   * non-blank string.
   */
  endpoint: Scalars['String'];
  /** An Elliptic curve Diffie–Hellman public key on the P-256 curve. It must be a non-blank string. */
  p256DH: Scalars['String'];
};

export type AddBrowserPushSubscriptionPayload = {
   __typename?: 'AddBrowserPushSubscriptionPayload';
  /**
   * The opaque ID of the push subscription. The entire push subscription is not returned because
   * there is no product use for it. Also, there is no existing query or mutation that can use this ID,
   * but it could be used for future functionality.
   */
  browserPushSubscriptionID?: Maybe<Scalars['ID']>;
};

/** Possible errors that this resolver returns. */
export enum AddChannelBlockedTermError {
  /** User does not have permission to add blocked term in channel. */
  NoPermissions = 'NO_PERMISSIONS',
  /** Duration provided was invalid. */
  DurationInvalid = 'DURATION_INVALID'
}

/** AddChannelBlockedTermInput takes in the channel, phrases, and if the term should be editable by mods. */
export type AddChannelBlockedTermInput = {
  /** channelID is the channelID owner of terms. */
  channelID: Scalars['ID'];
  /** isModEditable is if the term is viewable or editable by mods. */
  isModEditable: Scalars['Boolean'];
  /** phrases is the strings that are blocked. */
  phrases: Array<Scalars['String']>;
};

/** The returned data from the mutation. */
export type AddChannelBlockedTermPayload = {
   __typename?: 'AddChannelBlockedTermPayload';
  /** The time term was added. */
  addedAt?: Maybe<Scalars['Time']>;
  /** Mutation error caused by the user input. */
  error?: Maybe<AddChannelBlockedTermError>;
  /** The phrases that were added. */
  phrases: Array<Scalars['String']>;
};

/** Possible errors that this resolver returns. */
export enum AddChannelPermittedTermError {
  /** User does not have permission to add Permitted term in channel. */
  NoPermissions = 'NO_PERMISSIONS',
  /** Duration provided was invalid. */
  DurationInvalid = 'DURATION_INVALID'
}

/** AddChannelPermittedTermInput takes in the channel, phrases, and if the term should be editable by mods. */
export type AddChannelPermittedTermInput = {
  /** channelID is the owner of the permitted terms. */
  channelID: Scalars['ID'];
  /** phrases are the strings that are permitted in a channel. */
  phrases: Array<Scalars['String']>;
};

/** The returned payload from the mutation. */
export type AddChannelPermittedTermPayload = {
   __typename?: 'AddChannelPermittedTermPayload';
  /** The time term was added. */
  addedAt?: Maybe<Scalars['Time']>;
  /** Mutation error caused by the user input. */
  error?: Maybe<AddChannelPermittedTermError>;
  /** The phrases that were added. */
  phrases: Array<Scalars['String']>;
};

/** AddCollectionItemInput accepts a collectionID and item ID and parameters to add the item to a collection. */
export type AddCollectionItemInput = {
  /** The id of the collection. */
  collectionID: Scalars['ID'];
  /** The id of the item of which will be added to the collection. */
  itemID: Scalars['ID'];
  /** The type of item ie. video. */
  itemType: Scalars['String'];
};

/** The response from adding an item to a collection. */
export type AddCollectionItemPayload = {
   __typename?: 'AddCollectionItemPayload';
  /** The newly updated collection. */
  collection?: Maybe<Collection>;
};

/** Add a Phase to a Competition. */
export type AddCompetitionPhaseInput = {
  /** Unique Competition ID. */
  competitionID: Scalars['ID'];
};

/** Data that was mutated after the Phase was created. */
export type AddCompetitionPhasePayload = {
   __typename?: 'AddCompetitionPhasePayload';
  /** The competition is returned with any side effects adding a phase has caused. */
  competition?: Maybe<Competition>;
};

/** Add a User as a player to a Competition. */
export type AddCompetitionPlayerInput = {
  /** Unique Competition ID. */
  competitionID: Scalars['ID'];
  /** The player's Discord username. */
  discordUsername?: Maybe<Scalars['String']>;
  /** The player's in-game username. */
  inGameUsername?: Maybe<Scalars['String']>;
  /** The state the player in. Defaults to INVITED if not specified. */
  state?: Maybe<CompetitionPlayerInitialState>;
  /** Twitch user id of the player. */
  userID: Scalars['ID'];
};

/** Data that was mutated after the player was created. */
export type AddCompetitionPlayerPayload = {
   __typename?: 'AddCompetitionPlayerPayload';
  /** The new state of competition after adding a competition player to the competition. */
  competition?: Maybe<Competition>;
};

/** Inputs adding a competition team to a competition. */
export type AddCompetitionTeamInput = {
  /** ID of the competition team captain. */
  captainID?: Maybe<Scalars['ID']>;
  /** ID of the competition. */
  competitionID: Scalars['ID'];
  /** The user ids of the team members. */
  members?: Maybe<Array<Scalars['ID']>>;
  /** The name of the team. */
  name: Scalars['String'];
};

/** AddCompetitionTeamPayload is the success response adding a competition team to the competition. */
export type AddCompetitionTeamPayload = {
   __typename?: 'AddCompetitionTeamPayload';
  /** The new state of competition after adding a competition team to the competition. */
  competition?: Maybe<Competition>;
};

/** AddDeviceTokenInput accepts a token and other parameters to add a device token to a given user. */
export type AddDeviceTokenInput = {
  /** App build number of the current device. */
  appBuild?: Maybe<Scalars['String']>;
  /**
   * Unique identifier of the current device.
   * Note: deprecated field -- the deviceID now comess of the X-Device-Id header...
   */
  deviceID?: Maybe<Scalars['ID']>;
  /** Arbitrary name associated with the device. */
  deviceName?: Maybe<Scalars['String']>;
  /** The ID of the new token. */
  deviceToken: Scalars['ID'];
  /** Notification capabilities of the current device. */
  notificationCapabilitiesTypes?: Maybe<Array<Scalars['String']>>;
  /** Onsite notification capabilities of the current device. */
  onsiteCapabilitiesTypes?: Maybe<Array<Scalars['String']>>;
  /** The platform the token is associated with, i.e. 'android' or 'ios'. */
  platform: Scalars['String'];
  /**
   * ID for the user associated with the new device token.
   * Note: deprecated field -- the userID now comes off the authenticated user.
   */
  userID?: Maybe<Scalars['ID']>;
};

/** The response from adding a push notification token to a user. */
export type AddDeviceTokenPayload = {
   __typename?: 'AddDeviceTokenPayload';
  /** The ID of the new token. */
  deviceToken: Scalars['ID'];
};

/** AddEditorError contains details about a client error that occurred. */
export type AddEditorError = {
   __typename?: 'AddEditorError';
  /** The type of error that occurred when adding an editor. */
  code: AddEditorErrorCode;
};

/** AddEditorErrorCode defines a client error that occurred while adding an editor. */
export enum AddEditorErrorCode {
  /** The channel does not exist. */
  ChannelNotFound = 'CHANNEL_NOT_FOUND',
  /** The user who is to become an editor is already an editor. */
  TargetUserAlreadyEditor = 'TARGET_USER_ALREADY_EDITOR',
  /** The user who is to become an editor does not exist. */
  TargetUserNotFound = 'TARGET_USER_NOT_FOUND'
}

/** AddEditorInput contains the parameters to add an editor. */
export type AddEditorInput = {
  /** The channel for which the target user will become an editor. */
  channelID: Scalars['ID'];
  /**
   * The ID of the user who will become an editor.
   * Either targetUserID or targetUserLogin must be provided.
   */
  targetUserID?: Maybe<Scalars['ID']>;
  /**
   * The login of the user who will become an editor.
   * Either targetUserID or targetUserLogin must be provided.
   */
  targetUserLogin?: Maybe<Scalars['String']>;
};

/** AddEditorPayload is the response after attemping to add an editor. */
export type AddEditorPayload = {
   __typename?: 'AddEditorPayload';
  /** The channel for which the target user will become an editor. */
  channel?: Maybe<User>;
  /**
   * The client error that has occurred.
   * Null if the operation is successful.
   */
  error?: Maybe<AddEditorError>;
  /** The user who became an editor. */
  targetUser?: Maybe<User>;
};

export type AddReactionInput = {
  emoteID: Scalars['ID'];
  entityID: Scalars['ID'];
};

export type AddReactionPayload = {
   __typename?: 'AddReactionPayload';
  content: ReactableContent;
};

/** Data required to add recommendation feedback. */
export type AddRecommendationFeedbackInput = {
  /** Reason for the feedback (ie. Not interested, offensive, etc). */
  category: RecommendationFeedbackCategory;
  /** The id of the item (channelID, gameID, etc). */
  itemID: Scalars['ID'];
  /** One of CHANNEL, GAME, SHELF, VOD. */
  itemType: RecommendationFeedbackType;
  /** The page this event was fired from. */
  sourceItemPage: Scalars['String'];
  /** The unique id given to this request. */
  sourceItemRequestID: Scalars['ID'];
  /** The tracking id of the shelf / shelf card. */
  sourceItemTrackingID: Scalars['ID'];
};

/** Returns the created feedback item back to the client. */
export type AddRecommendationFeedbackPayload = {
   __typename?: 'AddRecommendationFeedbackPayload';
  /** Feedback item. */
  recommendationFeedback?: Maybe<RecommendationFeedback>;
};

/** Error that may be returned by the AddStreamAuthorizedUser mutation. */
export type AddStreamAuthorizedUserError = {
   __typename?: 'AddStreamAuthorizedUserError';
  /** Type of mutation error. */
  code: AddStreamAuthorizedUserErrorCode;
};

/** AddStreamAuthorizedUserErrorCode is the client error type that occurred during the AddStreamAuthorizedUser mutation. */
export enum AddStreamAuthorizedUserErrorCode {
  /** Unable to assign the Targeted user to stream on behalf of the broadcaster. */
  TargetUserUnreturnable = 'TARGET_USER_UNRETURNABLE',
  /** The broadcaster is not found. */
  ChannelNotFound = 'CHANNEL_NOT_FOUND',
  /** Maximum limit for adding authorized user is reached. */
  MaxAccountLimit = 'MAX_ACCOUNT_LIMIT',
  /** Permission denied to add an authorized user. */
  PermissionDenied = 'PERMISSION_DENIED',
  /** Invalid argument to add an authorized user. */
  InvalidArgument = 'INVALID_ARGUMENT'
}

/** AddStreamAuthorizedUserInput contains the channelID for the broadcaster and the authorized userID. */
export type AddStreamAuthorizedUserInput = {
  /** authorizedUserID for an authorized user who is allow to stream on behalf of broadcaster. */
  authorizedUserID: Scalars['ID'];
  /** channelID of the broadcaster. */
  channelID: Scalars['ID'];
};

/** AddStreamAuthorizedUserPayload contains the VideoStreamSettings with updated authorized users. */
export type AddStreamAuthorizedUserPayload = {
   __typename?: 'AddStreamAuthorizedUserPayload';
  /** The updated channel of broadcaster. */
  channel?: Maybe<Channel>;
  /** Error code. */
  error?: Maybe<AddStreamAuthorizedUserError>;
};

/** Ad Properties is an object that defines ad properties for a channel. */
export type AdProperties = {
   __typename?: 'AdProperties';
  /**
   * Deprecated.
   * @deprecated Should use adServerDefault instead
   */
  adServer?: Maybe<Scalars['String']>;
  /** Which adserver to send requests to. */
  adServerDefault?: Maybe<Scalars['String']>;
  /**
   * Amazon Digital Ad Service (ADAS) specific Properties for this channel.
   * Properties should only be nested if it is ADAS specific.
   */
  adasProperties?: Maybe<AdasProperties>;
  /** Which ids are costreamers for this channel. */
  costreamers?: Maybe<Array<Maybe<User>>>;
  /** Contains properties used by channel's disable prerolls feature. */
  disablePrerollsAbility?: Maybe<DisablePrerollsAbility>;
  /** Get the ad experiment treatment group for a specified experiment bucket. */
  experimentTreatment?: Maybe<Scalars['String']>;
  /** How often ad breaks can be run on this channel. */
  frequency?: Maybe<Scalars['Int']>;
  /** If postrolls are disabled on this channel. */
  hasPostrollsDisabled?: Maybe<Scalars['Boolean']>;
  /** If prerolls are disabled on this channel. */
  hasPrerollsDisabled?: Maybe<Scalars['Boolean']>;
  /** If Turbo benefit is disabled on this channel. */
  hasTurboDisabled?: Maybe<Scalars['Boolean']>;
  /** If vod ads are enabled on this channel. */
  hasVodAdsEnabled?: Maybe<Scalars['Boolean']>;
  /** If multiplayer ads are enabled for subscribers on this channel. */
  isMultiplayerAdsForSubsEnabled?: Maybe<Scalars['Boolean']>;
  /** A bool that represents a streamer's eligibility to run a picture by picture ad. */
  isPictureByPictureAdEligible?: Maybe<Scalars['Boolean']>;
  /** Maximum length for an ad break on this channel. */
  maxAdBreakLength?: Maybe<Scalars['Int']>;
  /** Current multiplayer ad offers on the channel. */
  multiplayerAdOffers?: Maybe<Array<MultiplayerAdOffer>>;
  /** The stream has the required age gate enabled if greater than 0. */
  requiredAge?: Maybe<Scalars['Int']>;
  /** Tracking pixels that channel pages should fire at certain intervals. */
  trackingPixels?: Maybe<Array<TrackingPixel>>;
  /** Setting for vod archive midrolls on this channel. Can be 'broadcaster', 'inserted', or 'off'. */
  vodArchiveMidrolls?: Maybe<Scalars['String']>;
  /** Ad break length for VOD archive midrolls on this channel. */
  vodArchiveMidrollsBreakLength?: Maybe<Scalars['Int']>;
  /** Frequency for VOD archive midrolls on this channel. */
  vodArchiveMidrollsFrequency?: Maybe<Scalars['Int']>;
};


/** Ad Properties is an object that defines ad properties for a channel. */
export type AdPropertiesExperimentTreatmentArgs = {
  bucket: Scalars['String'];
};


/** Ad Properties is an object that defines ad properties for a channel. */
export type AdPropertiesTrackingPixelsArgs = {
  consent?: Maybe<GdprConsent>;
};

/** The context of the Client when the ad request is about to be made. */
export type AdRequestClientContext = {
  /** If the client is in audio only mode. */
  isAudioOnly: Scalars['Boolean'];
  /** If the client is in mini theater mode. */
  isMiniTheater: Scalars['Boolean'];
  /** If the client is in Picture in Picture mode. */
  isPIP: Scalars['Boolean'];
  /** If the client is broadcasting to an external device (i.e. Chromecast, Airplay). */
  isUsingExternalPlayback: Scalars['Boolean'];
};

/** The type of content playing when the ad was requested. */
export enum AdRequestContentType {
  /** Live streams. */
  Live = 'LIVE',
  /** VOD playback. */
  Vod = 'VOD'
}

/** The context of an upcoming ad request. */
export type AdRequestContext = {
  /** The ID generated for the ad Session. */
  adSessionID: Scalars['ID'];
  /** The context of the client at the time the ad is requested. */
  clientContext: AdRequestClientContext;
  /** The duration of the ad break in seconds. */
  duration: Scalars['Int'];
  /** The context of the player at the time the ad is requested. */
  playerContext: AdRequestPlayerContext;
  /** The type of ad request being made. */
  rollType: AdrollType;
};

/** The context of the Player when the ad request is about to be made. */
export type AdRequestPlayerContext = {
  /** The type of content being watched. */
  contentType: AdRequestContentType;
  /** If the session was initiated by playing automatically. */
  isAutoPlay: Scalars['Boolean'];
  /** The signature for the access token for the current video session. */
  nauthSig: Scalars['String'];
  /** The access token for the current video session. */
  nauthToken: Scalars['String'];
};

/** The type of ad break being requested. */
export enum AdrollType {
  /** Ad that runs prior to seeing a stream/vod. */
  Preroll = 'PREROLL',
  /** Ad that runs in the middle of a stream/vod. */
  Midroll = 'MIDROLL',
  /** Ad that runs after a stream/vod. */
  Postroll = 'POSTROLL'
}

/** AdSession is the response object from an Ad Request. */
export type AdSession = {
   __typename?: 'AdSession';
  /** id is the id of the ad. */
  id: Scalars['ID'];
  /** lengthSeconds is the length of the ad being requested in seconds. */
  lengthSeconds: Scalars['Int'];
  /** retryAfterSeconds is the amount of time in seconds remaining for a user to run another ad. */
  retryAfterSeconds: Scalars['Int'];
};

/** Grouping of referral sources with name and count -- e.g. ("UK", 1437). */
export type AggregatedReferrals = {
   __typename?: 'AggregatedReferrals';
  /** Count of the referrals from the named source (1437). */
  count: Scalars['Int'];
  /** Name of the referral source ("UK"). */
  name: Scalars['String'];
};

/** Error from the mutation. */
export type AllocateKeysForBountyError = {
   __typename?: 'AllocateKeysForBountyError';
  /** Error code from the mutation. */
  code: AllocateKeysForBountyErrorCode;
};

/** Possible errors from the mutation. */
export enum AllocateKeysForBountyErrorCode {
  /** The provided input is invalid. */
  InvalidArgument = 'INVALID_ARGUMENT',
  /** The bounty or required key metadata was not found. */
  NotFound = 'NOT_FOUND',
  /** Unknown error being returned from service. */
  UnknownError = 'UNKNOWN_ERROR'
}

/** Input required to allocate keys for the bounty. */
export type AllocateKeysForBountyInput = {
  /** Unique Identifier for the bounty. */
  bountyID: Scalars['ID'];
  /** UserID that is allocating keys for the bounty. */
  userID: Scalars['ID'];
};

/** Payload from the mutation. */
export type AllocateKeysForBountyPayload = {
   __typename?: 'AllocateKeysForBountyPayload';
  /** The bounty with allocated keys. */
  bounty?: Maybe<Bounty>;
  /** The possible error returned from the service. */
  error?: Maybe<AllocateKeysForBountyError>;
};

export type AllowRejectedChatMessageInput = {
  id: Scalars['ID'];
};

export type AllowRejectedChatMessagePayload = {
   __typename?: 'AllowRejectedChatMessagePayload';
  message?: Maybe<RejectedChatMessage>;
};

/** Input to the allowRejectedCheer mutation. */
export type AllowRejectedCheerInput = {
  /**
   * Client-generated unique ID used to prevent a cheer from being re-sent (thus spending double bits).
   * The server will reject any request with an ID that has already been used.
   */
  id: Scalars['ID'];
  /** ID of the user whose message is automodded. */
  targetUserID: Scalars['ID'];
};

/** Payload from the allowRejectedCheer mutation. */
export type AllowRejectedCheerPayload = {
   __typename?: 'AllowRejectedCheerPayload';
  /**
   * Client-generated unique ID used to prevent a cheer from being re-sent (thus spending double bits).
   * The server will reject any request with an ID that has already been used.
   */
  id: Scalars['ID'];
};

/** A mapping of extension type to list of activation configs. */
export type ApplyExtensionActivationsInput = {
  /** A list of activations to apply to the given channelID. */
  activations: Array<ExtensionActivationInput>;
  /** The ID of the channel the activations are being performed on. */
  channelID: Scalars['ID'];
};

/** A list of all installed extensions on the channel after an applyExtensionActivations mutation. */
export type ApplyExtensionActivationsPayload = {
   __typename?: 'ApplyExtensionActivationsPayload';
  /**
   * The list of all installed extensions on the channel after an applyExtensionActivations mutation
   * with their new activation state.
   */
  installedExtensions: Array<ExtensionInstallation>;
};

/** ArchiveChanletInput archives a chanlet by chanlet ID. */
export type ArchiveChanletInput = {
  /** The ID of the chanlet being archived. */
  chanletID: Scalars['ID'];
};

/** ArchiveChanletPayload returns the Chanlet that was archived. */
export type ArchiveChanletPayload = {
   __typename?: 'ArchiveChanletPayload';
  /** The chanlet archived. */
  chanlet: Channel;
};

/** Inputs for archiving a poll. */
export type ArchivePollInChannelInput = {
  /** The id of the channel that contains the poll to archive. */
  channelID: Scalars['ID'];
};

/** Outputs from the archive poll mutation. */
export type ArchivePollInChannelPayload = {
   __typename?: 'ArchivePollInChannelPayload';
  /** The archived poll. */
  poll?: Maybe<Poll>;
};

/** Inputs for archiving a poll. */
export type ArchivePollInput = {
  /** The id of the poll to archive. */
  pollID: Scalars['ID'];
};

/** Outputs from the create poll mutation. */
export type ArchivePollPayload = {
   __typename?: 'ArchivePollPayload';
  /** The created poll. */
  poll?: Maybe<Poll>;
};

/** Possible errors from the mutation. */
export enum ArkoseEndpointVersion {
  /** Version 1 endpoint. */
  V1 = 'V1',
  /** Version 2 endpoint. */
  V2 = 'V2'
}

/** AssignExtensionBillingManagerError is the error associated with AssignExtensionBillingManager. */
export type AssignExtensionBillingManagerError = {
   __typename?: 'AssignExtensionBillingManagerError';
  /** The associated error code. */
  code: AssignExtensionBillingManagerErrorCode;
};

/** Enums for the difference error codes which can be returned. */
export enum AssignExtensionBillingManagerErrorCode {
  /** Extension does not belong to the same organization as the assigned billing manager member. */
  FailedPrecondition = 'FAILED_PRECONDITION',
  /**
   * The user doesn't meet the requirements to be the assigned billing manager.
   * For example, doesn't have a valid role or did not complete Extension Monetization (TIMs).
   */
  MemberIneligible = 'MEMBER_INELIGIBLE',
  /** User does not have permission to perform action. */
  PermissionDenied = 'PERMISSION_DENIED'
}

/** Inputs to the SetExtensionBillingManager mutation. */
export type AssignExtensionBillingManagerInput = {
  /** The ID of the extensions. */
  extensionID: Scalars['ID'];
  /** The twitch ID of the organization member. */
  userID: Scalars['ID'];
};

/** Payload retuned from the mutation. */
export type AssignExtensionBillingManagerPayload = {
   __typename?: 'AssignExtensionBillingManagerPayload';
  /** The possible error returned from the service. */
  error?: Maybe<AssignExtensionBillingManagerError>;
  /** The updated extension. */
  extensionClient?: Maybe<ExtensionClient>;
};

/** Information regarding an Amazon Associates store. */
export type AssociatesStore = {
   __typename?: 'AssociatesStore';
  ID: Scalars['ID'];
  /** Whether the owner of this store is enabled to recieve payments. */
  isPayoutEnabled?: Maybe<Scalars['Boolean']>;
  /** The store ID tag. */
  storeID?: Maybe<Scalars['String']>;
};

/** Authenticated Twitch session. */
export type AuthenticatedSession = {
   __typename?: 'AuthenticatedSession';
  /** ID of the client the user authenticated from. */
  clientID: Scalars['ID'];
  /** Creation date of the session. */
  createdAt?: Maybe<Scalars['Time']>;
  /**
   * Date of invalidation of the session.
   * Can be null if the session hasn't been deleted.
   */
  deletedAt?: Maybe<Scalars['Time']>;
  /** Geolocation during authentication, determined by IP. */
  location?: Maybe<Scalars['String']>;
  /** User agent used during authentication. */
  userAgent?: Maybe<Scalars['String']>;
  /** Twitch User ID. */
  userID: Scalars['ID'];
};

/**
 * A list of configured autohost channels
 * 
 * A relay connection type that does not yet support pagination.
 */
export type AutohostChannelConnection = {
   __typename?: 'AutohostChannelConnection';
  /** The channels. */
  nodes?: Maybe<Array<User>>;
};

/**
 * A list of channels that are autohosting the channel
 * 
 * A relay connection type that does not yet support pagination.
 */
export type AutohostedByChannelConnection = {
   __typename?: 'AutohostedByChannelConnection';
  /** The channels. */
  nodes?: Maybe<Array<User>>;
};

/** A user's autohosting settings. */
export type AutohostSettings = {
   __typename?: 'AutohostSettings';
  /** True if this channels prefers autohost over vodcast. */
  deprioritizeVodcast: Scalars['Boolean'];
  /** True if this channel has the autohost feature turned on. */
  enabled: Scalars['Boolean'];
  /**
   * Determines what other channels can raid this channel.
   * @deprecated Use User.raidSettings.incomingRaidsPolicy instead.
   */
  incomingRaidsPolicy: AutohostSettingsIncomingRaidsPolicy;
  /** The strategy to use when choosing channels to autohost. */
  strategy: AutohostSettingsStrategy;
  /** True if this user autohosts their team members. */
  teamHost: Scalars['Boolean'];
};

/**
 * DEPRECATED: to be replaced by IncomingRaidsPolicy.
 * Determines what other channels can raid this channel.
 */
export enum AutohostSettingsIncomingRaidsPolicy {
  /** This user cannot be radied by anyone. */
  None = 'NONE',
  /** This user can be raided by other people in their network. */
  Network = 'NETWORK',
  /** This user can be raded by anyone. */
  All = 'ALL'
}

/** The strategy to use when choosing channels to autohost. */
export enum AutohostSettingsStrategy {
  /** Picks channels in the order defined by the user. */
  Ordered = 'ORDERED',
  /** Picks channels at random. */
  Random = 'RANDOM'
}

/**
 * An automod fragment type, which is text that is flagged by AutoModeration.
 * It contains a list of topics which contain reasons why AutoModeration flagged the text.
 */
export type AutoMod = {
   __typename?: 'AutoMod';
  /** The topics that were flagged by AutoModeration. */
  topics: Array<AutoModTopic>;
};

/** A message rejected by automod. */
export type AutoModCaughtMessage = {
   __typename?: 'AutoModCaughtMessage';
  /** Reason why the message was flagged and/or rejected. */
  category: AutoModCaughtMessageCategory;
  /** id contains the UUID of the AutoModCaughtMessage. */
  id: Scalars['ID'];
  /** The contents of the message itself, including its content, sender, sentAt timestamp, etc. */
  modLogsMessage: ModLogsMessage;
  /** Time when a moderator allowed or denied a flagged message. */
  resolvedAt?: Maybe<Scalars['Time']>;
  /** The user (mod) who approve/denied the flagged message. */
  resolver?: Maybe<User>;
  /** The approval status of the caught message. */
  status: AutoModCaughtMessageStatus;
};

/** Reason why a message is flagged and/or rejected. */
export enum AutoModCaughtMessageCategory {
  /** Message contained words that were aggressive. */
  Aggressive = 'AGGRESSIVE',
  /** Message contained identity details. */
  Identity = 'IDENTITY',
  /** Message contained words that were vulgar. */
  Profanity = 'PROFANITY',
  /** Message contained words that were sexual. */
  Sexual = 'SEXUAL'
}

/** Describes a flagged message's posting status. */
export enum AutoModCaughtMessageStatus {
  /** The message has not received a decision from a mod, and may be expired. Check sentAt date to confirm. */
  Pending = 'PENDING',
  /** The message was approved by a channel moderator or the broadcaster. */
  Approved = 'APPROVED',
  /** The message was denied by a channel moderator or the broadcaster. */
  Denied = 'DENIED'
}

/** AutomodContentResponse is the automod response for the text evaulated. */
export type AutomodContentResponse = {
   __typename?: 'AutomodContentResponse';
  /** content are pieces of the content evaulated by automod. */
  content?: Maybe<RoomMessageContent>;
  /** text is the original raw string evaluated by automod. */
  text: Scalars['String'];
};

export type AutoModProperties = {
   __typename?: 'AutoModProperties';
  /** These are integers between 0 and 4, inclusive. */
  aggressiveLevel: Scalars['Int'];
  identityLevel: Scalars['Int'];
  profanityLevel: Scalars['Int'];
  sexualLevel: Scalars['Int'];
};

/** An auto moderation topic with value. */
export type AutoModTopic = {
   __typename?: 'AutoModTopic';
  /** The topic type, defined by Zuma. */
  type: Scalars['String'];
  /** The weight assigned to the topic. */
  weight: Scalars['Int'];
};

/** Contains all auto refill profiles, will have auto refill metadata in the future. */
export type AutoRefill = {
   __typename?: 'AutoRefill';
  /** Lists actions to execute during an auto refill setup session. */
  actions: Array<CheckoutAction>;
  /** The list of auto refill profiles. */
  profiles: Array<AutoRefillProfile>;
  /**
   * A list of active xsolla payment methods that a user has available. This field
   * is intended to be replaced by the User.PaymentMethods query.
   */
  xsollaPaymentMethods?: Maybe<Array<PaymentMethod>>;
};


/** Contains all auto refill profiles, will have auto refill metadata in the future. */
export type AutoRefillActionsArgs = {
  paymentProvider: PaymentProvider;
};

/** Auto Refill profile information. */
export type AutoRefillProfile = {
   __typename?: 'AutoRefillProfile';
  /** The charge instrument information for starting a purchase. */
  chargeInstrument?: Maybe<ChargeInstrument>;
  /** Unique ID assigned to this profile. */
  id: Scalars['ID'];
  /** Indicates if this profile is active. */
  isEnabled: Scalars['Boolean'];
  /** The offerID that maps to the ability to purchase the intended product. */
  offerID?: Maybe<Scalars['ID']>;
  /** The threshold amount a balance must go below to trigger a reload. */
  threshold: Scalars['Int'];
};

/** The possible computed states for a user or session. */
export enum Availability {
  Away = 'AWAY',
  Busy = 'BUSY',
  Idle = 'IDLE',
  Offline = 'OFFLINE',
  Online = 'ONLINE'
}

export enum AvailabilityInput {
  Online = 'ONLINE',
  Idle = 'IDLE',
  Offline = 'OFFLINE'
}

/** AVC profiles for streams. */
export enum AvcProfile {
  /** Low level. */
  Baseline = 'BASELINE',
  /** Regular level. */
  Main = 'MAIN',
  /** High level. */
  High = 'HIGH'
}

/** BackupIngestSession is session metadata related to broadcaster's backup session. */
export type BackupIngestSession = {
   __typename?: 'BackupIngestSession';
  /** The session where the current session was stitched from. */
  stitchedFrom?: Maybe<Array<BackupStreamSession>>;
  /** The session where the current session was stitched to. */
  stitchedTo?: Maybe<Array<BackupStreamSession>>;
};

/** BackupStreamSession identifies the backup stream session. */
export type BackupStreamSession = {
   __typename?: 'BackupStreamSession';
  /** Type of live stream. */
  broadcastFormat: BroadcastFormat;
  /** The ID of backup session. */
  id: Scalars['ID'];
  /** Time when the backup stream was stitched as primary session. */
  stitchedTimeAt: Scalars['Time'];
};

/** Communicates a user's status in chat. */
export type Badge = {
   __typename?: 'Badge';
  /**
   * Identifies an action to trigger when this badge is clicked.
   * @deprecated Should use onClickAction instead
   */
  clickAction?: Maybe<BadgeClickAction>;
  /** The URL to redirect to if the badge's onClickAction is VISIT_URL. */
  clickURL?: Maybe<Scalars['String']>;
  /**
   * A localized, human-friendly description of the badge.
   * Defaults to English if no translation exists for the requested locale.
   */
  description: Scalars['String'];
  /** The badge's unique identifier. */
  id: Scalars['ID'];
  /** A URL to the badge's image. */
  imageURL: Scalars['String'];
  /** Identifies an action to trigger when this badge is clicked. */
  onClickAction?: Maybe<BadgeClickAction>;
  /** The identifier of the set which this badge belongs (e.g. "subscriber"). */
  setID: Scalars['ID'];
  /**
   * A localized, human-friendly title for the badge.
   * Defaults to English if no translation exists for the requested locale.
   */
  title: Scalars['String'];
  /**
   * The badge's associated broadcaster.
   * Returns null if this is a global badge.
   */
  user?: Maybe<User>;
  /** The badge's version (e.g. "1mo"). */
  version: Scalars['String'];
};


/** Communicates a user's status in chat. */
export type BadgeImageUrlArgs = {
  size?: Maybe<BadgeImageSize>;
};

/** Enumerates possible badge click actions. */
export enum BadgeClickAction {
  /** Go to the user's subscription page. */
  Subscribe = 'SUBSCRIBE',
  /** Go to the Twitch Turbo purchasing page. */
  GetTurbo = 'GET_TURBO',
  /** Go to the Bits purchasing page. */
  GetBits = 'GET_BITS',
  /** Redirect the user to the badge click URL. */
  VisitUrl = 'VISIT_URL'
}

/** Deprecated: Domains that badges belong to. */
export enum BadgeDomain {
  /** Badges that were granted via Twitch crates. */
  Crate = 'CRATE'
}

/** Enumerates valid badge image sizes. */
export enum BadgeImageSize {
  /** The base badge image size: 18x18. */
  Normal = 'NORMAL',
  /** Double the normal badge image size: 36x36. */
  Double = 'DOUBLE',
  /** Quadruple the normal badge image size: 72x72. */
  Quadruple = 'QUADRUPLE'
}

/** A filter for controlling which Bits Badge Tier Emotes to return. */
export enum BadgeTierEmotesFilter {
  /** Returns all bits badge tier emotes for this channel. */
  All = 'ALL',
  /** Returns all locked bits badge tier emotes for this user in this channel. */
  Locked = 'LOCKED',
  /**
   * Returns a few of the locked bits badge tier emotes for this user in this channel.
   * Which emotes and the exact number are determined by the back-end.
   */
  LockedPreview = 'LOCKED_PREVIEW',
  /** Returns all unlocked bits badge tier emotes for this user in this channel. */
  Unlocked = 'UNLOCKED'
}

/**
 * Balance for a Twitch User Account in a FIAT currency. Can be used to purchase
 * product on the Twitch Platform.
 */
export type Balance = {
   __typename?: 'Balance';
  /** Amount in the smallest unit of subcurrency. */
  amount: Scalars['Int'];
  /** ISO-4217 currency code of a user's balance. */
  currency: Currency;
  /** Number of digits after the decimal separator. */
  exponent: Scalars['Int'];
};

export type BanUserFromChatRoomError = {
   __typename?: 'BanUserFromChatRoomError';
  code: BanUserFromChatRoomErrorCode;
  /** On DURATION_INVALID, maximum number of seconds a user can be timed out for. */
  maxTimeoutDurationSeconds?: Maybe<Scalars['Int']>;
  /** On DURATION_INVALID, minimum number of seconds a user can be timed out for. */
  minTimeoutDurationSeconds?: Maybe<Scalars['Int']>;
};

export enum BanUserFromChatRoomErrorCode {
  /** User does not have permission to ban in channel. */
  Forbidden = 'FORBIDDEN',
  /** Target does not exist. */
  TargetNotFound = 'TARGET_NOT_FOUND',
  /** User tried to ban themselves. */
  TargetIsSelf = 'TARGET_IS_SELF',
  /** User tried to ban anonymous user. */
  TargetIsAnonymous = 'TARGET_IS_ANONYMOUS',
  /** User tried to ban a moderator without permission. */
  TargetIsMod = 'TARGET_IS_MOD',
  /** DEPRECATED: no longer returned. */
  TargetIsVip = 'TARGET_IS_VIP',
  /** User tried to ban broadcaster. */
  TargetIsBroadcaster = 'TARGET_IS_BROADCASTER',
  /** User tried to ban staff. */
  TargetIsStaff = 'TARGET_IS_STAFF',
  /** User tried to ban admin. */
  TargetIsAdmin = 'TARGET_IS_ADMIN',
  /** User tried to ban global mod. */
  TargetIsGlobalMod = 'TARGET_IS_GLOBAL_MOD',
  /** User tried to ban already banned user. */
  TargetAlreadyBanned = 'TARGET_ALREADY_BANNED',
  /** Duration provided was too short or too long. */
  DurationInvalid = 'DURATION_INVALID'
}

export type BanUserFromChatRoomInput = {
  bannedUserLogin: Scalars['String'];
  channelID: Scalars['ID'];
  /**
   * This argument accepts a string specifying a duration.
   * It takes a succession of a number (positive integer) and a time unit, one of:
   * s[econd[s]], m[inute[s]], h[our[s]], d[ay[s]], w[eek[s]], mo[nth[s]].
   * Number/unit pairs can be contiguous or separated by spaces.
   * Valid examples: "3d4h" "11 minutes" "2month", "1s", "12 second"
   * If not provided, target is banned permanently.
   */
  expiresIn?: Maybe<Scalars['String']>;
  /** The reason that the user has been banned or timed out. */
  reason?: Maybe<Scalars['String']>;
};

export type BanUserFromChatRoomPayload = {
   __typename?: 'BanUserFromChatRoomPayload';
  /** The new ban status of this user regarding the specified channel. */
  ban?: Maybe<ChatRoomBanStatus>;
  /** Mutation error caused by the user input. */
  error?: Maybe<BanUserFromChatRoomError>;
};

export type BanVideoCommenterInput = {
  /** The id of the channel from where to ban commenter from. */
  channelID: Scalars['ID'];
  /** The id of the commenter to ban. */
  commenterID: Scalars['ID'];
};

export type BanVideoCommenterPayload = {
   __typename?: 'BanVideoCommenterPayload';
  user?: Maybe<User>;
};

/** BillingAuthInfo holds data to facilitate the Fraud analysis. */
export type BillingAuthInfo = {
  /** Fraud Session ID. */
  recurlyFraudSessionID?: Maybe<Scalars['ID']>;
  /**
   * Token generated after completing a 3-D Secure device fingerprinting or 
   * authentication challenge.
   */
  threeDSecureActionResultTokenID?: Maybe<Scalars['ID']>;
};

/** BitsAdOffer is an offer to earn bits by watching an ad or interacting with an engagement. */
export type BitsAdOffer = BitsOffer & {
   __typename?: 'BitsAdOffer';
  /**
   * bits is the minimum number of bits received from watching an ad.
   * Some ads may reward more, but this is the number displayed to the user before choosing to watch an ad for bits.
   */
  bits: Scalars['Int'];
  id: Scalars['ID'];
  /** type is `BitsOfferType.AD`. */
  type: BitsOfferType;
};

/** Bits Badges with their associated settings. */
export type BitsBadgeTier = {
   __typename?: 'BitsBadgeTier';
  /** The badge for this tier. */
  badge?: Maybe<Badge>;
  /** Whether the broadcaster can upload emoticons for this tier. */
  canUploadEmoticons: Scalars['Boolean'];
  /** The emoticon configurations for emoticons that are currently in the process of being uploaded for this tier. */
  emoticonUploadConfigurations: Array<Maybe<EmoteUploadConfiguration>>;
  /** The emoticons that are associated with this tier. */
  emoticons: Array<Maybe<Emote>>;
  /** Whether the badge is enabled for this threshold. */
  isEnabled: Scalars['Boolean'];
  /** Time when this badge tier was last updated. */
  lastUpdated?: Maybe<Scalars['Time']>;
  /** The amount of bits a user must cheer to achieve this tier. */
  threshold: Scalars['Int'];
  /** The number of users who have unlocked this badge tier. */
  unlockedUsersCount: Scalars['Int'];
};

/** BadgeTier Emoticon data to modify. */
export type BitsBadgeTierEmoticonSetting = {
  /**
   * The text representation that will allow a user to invoke the emoticon in chat.
   * Usually consists of: a creator's emoticon prefix + a codeSuffix.
   */
  code: Scalars['String'];
  /**
   * The creator-defined suffix that differentiates this emoticon from other emoticons in the channel.
   * Usually begins with either a capital letter or a number.
   */
  codeSuffix: Scalars['String'];
};

/** BadgeTier metadata to modify. */
export type BitsBadgeTierInput = {
  /** Whether to reset the images to the default images. */
  deleteImage?: Maybe<Scalars['Boolean']>;
  /** Wether to reset the badge title to the default title. */
  deleteTitle?: Maybe<Scalars['Boolean']>;
  /** A list of emoticons to modify. */
  emoticonSettings?: Maybe<Array<BitsBadgeTierEmoticonSetting>>;
  /** Base64 encoded binary data of the 18x18px badge ("1x") image asset. */
  imageData1x?: Maybe<Scalars['String']>;
  /** Base64 encoded binary data of the 36x36px badge ("2x") image asset. */
  imageData2x?: Maybe<Scalars['String']>;
  /** Base64 encoded binary data of the 72x72px badge ("4x") image asset. */
  imageData4x?: Maybe<Scalars['String']>;
  /** Whether the badge is enabled for this threshold. */
  isEnabled?: Maybe<Scalars['Boolean']>;
  /** The threshold to modify. */
  threshold: Scalars['Int'];
  /** Badge title as string. */
  title?: Maybe<Scalars['String']>;
};

/** A notification about achieving a new bits badge tier. Used to send a special message. */
export type BitsBadgeTierNotification = {
   __typename?: 'BitsBadgeTierNotification';
  /** Whether or not the notification can be shared with chat. */
  canShare: Scalars['Boolean'];
  /** UUID for notification. */
  id: Scalars['ID'];
  /** Represents the badge tier threshold reached by the user on a channel (e.g. 100, 1000, etc). */
  threshold: Scalars['Int'];
  /** The list of bits badge tier emoticons that were obtained as part of achieving this notification's bits badge tier. */
  unlockedEmoticons: Array<Maybe<Emote>>;
};

/** Represents the state of the notification. */
export enum BitsBadgeTierNotificationState {
  /** User dismissed the notification. */
  Skipped = 'SKIPPED',
  /** User shared the notification with chat. */
  Shared = 'SHARED',
  /** Notification should be shown to user. */
  Show = 'SHOW'
}

/** BitsBundleOffer is an offer to purchase a number of bits for a certain price. */
export type BitsBundleOffer = BitsOffer & {
   __typename?: 'BitsBundleOffer';
  /** amount is the numerical cost of this offer (ex: 20.00). */
  amount: Scalars['Float'];
  /** asin is the Amazon Standard Identification Number for this offer. */
  asin: Scalars['ID'];
  /** bits is the number of bits this offer provides. */
  bits: Scalars['Int'];
  /** Currency code that the price and amount are displayed in (USD, CAD, etc.). */
  currencyCode: Scalars['String'];
  /** discount is the bulk discount this offer provides compared to the base offer [0.0-1.0). */
  discount: Scalars['Float'];
  id: Scalars['ID'];
  /**
   * includesVAT is a boolean flag to indicate that the Value Added Tax (VAT)
   * is included in the price of a Bits product. This is important for Bits prices 
   * in EU.
   */
  includesVAT: Scalars['Boolean'];
  /**
   * isPromo is a flag that signifies if the offer is a promotional offer. This is for clients that
   * need to display promotional offers differently.
   */
  isPromo: Scalars['Boolean'];
  /**
   * price is the formatted currency cost of this offer to be displayed to the user.
   * @deprecated Use the 'amount' field and localize it yourself in conjunction with the 'currencyCode' field
   */
  price: Scalars['String'];
  /**
   * promotion contains information about this bits offer if it is a promotional
   * offer. Is null if the offer is not promotional.
   */
  promotion?: Maybe<BitsPromotion>;
  /** type is `BitsOfferType.BUNDLE`. */
  type: BitsOfferType;
  /**
   * url is the purchase URL to use for this offer.
   * The url contains a `{channelID}` token which should be replaced by the
   * `User.id` of the channel bits are being purchased from.
   */
  url: Scalars['String'];
};

/**
 * BitsChallengeConditionPoolRecipientWeightedShare represents the weighted share of the total bits pool
 * that a recipient user is entitled to upon condition satisfaction.
 */
export type BitsChallengeConditionPoolRecipientWeightedShare = {
  /** TUID of the bits recipient. */
  recipientUserID: Scalars['ID'];
  /**
   * The weight of the recipient's share from the total bits pool. The sum of all the recipients' weights
   * dictates the proportion that a particular recipient receives from the pool
   * (shareWeight/totalShareWeight * totalBitsAmountInPool).
   */
  weight: Scalars['Int'];
};

/** Each Bits gem notification data. */
export type BitsGemNotification = {
   __typename?: 'BitsGemNotification';
  /** The date when this notification was created. */
  createdAt: Scalars['String'];
  /** Description of this notification. */
  description: Scalars['String'];
  /** The unique id that identifies this notification. */
  id: Scalars['ID'];
  /** Dictates if the user has already explicitly checked this notification. */
  isChecked: Scalars['Boolean'];
  /** The title of this notification. */
  title: Scalars['String'];
};

/** A list of hashtags to use in chat while using bits. */
export type BitsHashtagConnection = {
   __typename?: 'BitsHashtagConnection';
  /** The list of BitsHashtagEdges. */
  edges?: Maybe<Array<BitsHashtagEdge>>;
};

/** BitsHashtagEdge contains. */
export type BitsHashtagEdge = {
   __typename?: 'BitsHashtagEdge';
  /** The cursor of the record. This will be the BitsHashtagEdge ID. */
  cursor: Scalars['Cursor'];
  /** The node of the edge contains all information about the hashtag. */
  node: BitsHashtagEntry;
};

/** BitsHashtagEntry contains information about a hashtag, sucn as the description and image URL for display. */
export type BitsHashtagEntry = {
   __typename?: 'BitsHashtagEntry';
  /** description text. */
  description?: Maybe<Scalars['String']>;
  /** The ID, which would be the hashtag value. */
  id: Scalars['ID'];
  /** An image to display in autocomplete. */
  imageURL?: Maybe<Scalars['String']>;
};

/** The Bits Key Code that can be claimed to add bits to a user's account. */
export type BitsKeyCode = Claimable & {
   __typename?: 'BitsKeyCode';
  /** A description of what is claimable for the bits key code. */
  description: Scalars['String'];
  /** The ID of the bits key code. */
  id: Scalars['ID'];
  /** The field that gives us claim information for the logged in user. */
  self?: Maybe<SelfClaimEdge>;
  /** The type is `ClaimableType.BITS_KEY_CODE`. */
  type: ClaimableType;
};

/** User edge relating the key's status to the user. */
export type BitsKeyCodeSelfClaimEdge = SelfClaimEdge & {
   __typename?: 'BitsKeyCodeSelfClaimEdge';
  /** If the user is eligible to claim the key code. */
  canClaim: Scalars['Boolean'];
  /** Nullable field for the country where the user redeemed the claimable. */
  countryOfResidence?: Maybe<Scalars['String']>;
  /** The user ID that is claiming the code. */
  id: Scalars['ID'];
  /** Nullable status code for if the user cannot claim the key code. */
  statusCode?: Maybe<Scalars['String']>;
};

/** BitsLeaderboard contains the leaderboard for a specified channel. */
export type BitsLeaderboard = {
   __typename?: 'BitsLeaderboard';
  /**
   * entries is the list of users in the leaderboard ordered by the number of bits cheered.
   * @deprecated the ID field is not unique between leaderboards on leaderboard entries. Use leaderboard item.
   */
  entries: BitsLeaderboardConnection;
  /** id is the id of this leaderboard. */
  id: Scalars['ID'];
  /** items is the list of users in the leaderboard ordered by the number of bits cheered. */
  items: BitsLeaderboardItemConnection;
  /** SecondsRemaining is the number of seconds left before the leaderboard expires (or zero for all-time). */
  secondsRemaining: Scalars['Int'];
};

/** Bits leaderboard connection is used to show the various leaderboard entries. */
export type BitsLeaderboardConnection = {
   __typename?: 'BitsLeaderboardConnection';
  edges: Array<Maybe<BitsLeaderboardEdge>>;
};

/** BitsLeaderboardEdge describes an edge in a bits leaderboard. */
export type BitsLeaderboardEdge = {
   __typename?: 'BitsLeaderboardEdge';
  /** The cursor for this leaderboard edge. */
  cursor: Scalars['String'];
  /** The leaderboard entry at this edge. */
  node?: Maybe<BitsLeaderboardEntry>;
};

/** Leaderboard entry at a specific node in a leaderboard connection. */
export type BitsLeaderboardEntry = {
   __typename?: 'BitsLeaderboardEntry';
  /** id the id of this leaderboard entry. */
  id: Scalars['ID'];
  /** rank the ordinal rank of this leaderboard entry. */
  rank: Scalars['Int'];
  /** score the number of bits cheered by this leaderboard entry. */
  score: Scalars['Int'];
};

/** Leaderboard item at a specific node in a leaderboard connection. */
export type BitsLeaderboardItem = {
   __typename?: 'BitsLeaderboardItem';
  /** entryKey the key of this leaderboard item. */
  entryKey: Scalars['String'];
  /** id the id of this leaderboard item. */
  id: Scalars['ID'];
  /** rank the ordinal rank of this leaderboard item. */
  rank: Scalars['Int'];
  /** score the number of bits cheered by this leaderboard entry. */
  score: Scalars['Int'];
};

/** Bits leaderboard connection is used to show the various leaderboard items. */
export type BitsLeaderboardItemConnection = {
   __typename?: 'BitsLeaderboardItemConnection';
  /** edges ... */
  edges?: Maybe<Array<Maybe<BitsLeaderboardItemEdge>>>;
  /** pageInfo ... */
  pageInfo: PageInfo;
  /** totalCount ... */
  totalCount?: Maybe<Scalars['Int']>;
};

/** BitsLeaderboardItemEdge describes an edge in a bits leaderboard. */
export type BitsLeaderboardItemEdge = {
   __typename?: 'BitsLeaderboardItemEdge';
  /** The cursor for this leaderboard edge. */
  cursor: Scalars['Cursor'];
  /** The leaderboard entry at this edge. */
  node?: Maybe<BitsLeaderboardItem>;
};

/** BitsLeaderboardSettings are channel-specific settings related to Bits Leaderboards. */
export type BitsLeaderboardSettings = {
   __typename?: 'BitsLeaderboardSettings';
  /** isEnabled indicates if the Bits leaderboard is pinned in this channel. */
  isEnabled: Scalars['Boolean'];
  /** timePeriodType indicates whether the leaderboard type is of WEEKLY, ALL-TIME, etc. */
  timePeriodType?: Maybe<LeaderboardTimePeriodType>;
};

/** BitsOffer is a way to obtain more bits. */
export type BitsOffer = {
  /** bits is the number of bits this offer grants. */
  bits: Scalars['Int'];
  id: Scalars['ID'];
  /** type is the kind of offer object. */
  type: BitsOfferType;
};

/** BitsOfferType is the kind of offer. */
export enum BitsOfferType {
  /** AD is an advertisement or other engagement that can be watched to earn bits. */
  Ad = 'AD',
  /** BUNDLE is a standard package of bits that can be purchased for a price. */
  Bundle = 'BUNDLE'
}

/** The type used when checking which payment methods a user can use. */
export type BitsPaymentMethods = {
   __typename?: 'BitsPaymentMethods';
  /** A list of the valid bits payment methods for a user. */
  paymentMethods?: Maybe<Array<BitsPaymentMethodType>>;
};

/** Enum of payment method types. */
export enum BitsPaymentMethodType {
  /** Paypal. */
  Paypal = 'PAYPAL',
  /** Amazon Pay. */
  AmazonPay = 'AMAZON_PAY',
  /** Xsolla. */
  Xsolla = 'XSOLLA'
}

/** A product for bits that contains all information about a product, except for the pricing. */
export type BitsProduct = {
   __typename?: 'BitsProduct';
  /** The amount of bits the product is for. */
  amount: Scalars['Int'];
  /** The product ID. */
  id: Scalars['ID'];
  /** The maximum quantity a user can purchase at once. */
  maxQuantity: Scalars['Int'];
  /** The offer id associated with this product's id (if available). */
  offerID?: Maybe<Scalars['ID']>;
  /** A field that contains promotional information about the product. */
  promo?: Maybe<BitsProductPromotion>;
  /** The relation of the product to the user. */
  self?: Maybe<BitsProductSelfEdge>;
  /** The product type, which right now is only "purchase". */
  type: BitsProductType;
};

/** The type used when checking bits product eligibility for a user. */
export type BitsProductEligibility = {
   __typename?: 'BitsProductEligibility';
  /** A boolean that is true when the user is eligible for the product. */
  canPurchase: Scalars['Boolean'];
  /**
   * If the user is ineligible for the product, then this code is set
   * as the reason why the user is ineligible for the product.
   */
  reasonCode?: Maybe<Scalars['String']>;
};

/** Promotional information about bits products. */
export type BitsProductPromotion = {
   __typename?: 'BitsProductPromotion';
  /** The unique ID of the bits product promo. */
  id: Scalars['ID'];
  /** The localized title of the promo product. */
  title: Scalars['String'];
  /** The type of promotion the product is associated with. This type is not enumerable since it is very dynamic. */
  type: Scalars['String'];
};

/** An enumerable that identifies the checkout provider the customer is using. */
export enum BitsProductProvider {
  /** Amazon checkout. */
  Amazon = 'AMAZON',
  /** Android IAP. */
  Android = 'ANDROID',
  /** iOS IAP. */
  Ios = 'IOS',
  /** Paypal checkout. */
  Paypal = 'PAYPAL',
  /** Xsolla checkout. */
  Xsolla = 'XSOLLA'
}

/** Contains the Bits product's preview price and tax info for a Bits purchase, and error if a preview cannot be created. */
export type BitsProductPurchaseInfo = {
   __typename?: 'BitsProductPurchaseInfo';
  /** Lists any additional actions for a bits checkout session. */
  actions: Array<CheckoutAction>;
  /** The error is present if purchase info failed to be retrieved. */
  error?: Maybe<BitsProductPurchaseInfoError>;
  /** Gets the preview price and tax info for the Bits purchase. */
  previewPriceInfo?: Maybe<PriceInfo>;
};

/** Error information shown when priceInfo could not be retrieved for Bits Product. */
export type BitsProductPurchaseInfoError = {
   __typename?: 'BitsProductPurchaseInfoError';
  /** The descriptive error code. */
  code: BitsProductPurchaseInfoErrorCode;
};

/** Possible errors when retrieving bits product purchase info. */
export enum BitsProductPurchaseInfoErrorCode {
  /** An unexpected internal server error occurred. */
  InternalServerError = 'INTERNAL_SERVER_ERROR',
  /** The user is unauthorized to view purchase info. */
  UserUnauthorized = 'USER_UNAUTHORIZED',
  /** The Pricing ID is not found (404). */
  PricingIdNotFound = 'PRICING_ID_NOT_FOUND',
  /**
   * Cannot determine User Residence. Either billing address and IP doesn't match or
   * user doesn't have country of resident declared (409).
   */
  UnknownUserResidence = 'UNKNOWN_USER_RESIDENCE',
  /** The billing info could not be found for the user and provider (410). */
  BillingInfoNotFound = 'BILLING_INFO_NOT_FOUND',
  /** User is not eligible to purchase bits in this region (422). */
  PurchaseIneligible = 'PURCHASE_INELIGIBLE'
}

/** The relation of a Bits product to a user. */
export type BitsProductSelfEdge = {
   __typename?: 'BitsProductSelfEdge';
  /** Holds configuration necessary to start bits purchase checkout flow for this product for current user. */
  checkoutConfiguration?: Maybe<CheckoutConfiguration>;
  /** Is the user eligible to claim the product at the given quantity. */
  eligibility: BitsProductEligibility;
  /** Gets the preview price and tax info for the Bits purchase, or error if that failed. */
  purchaseInfo: BitsProductPurchaseInfo;
};


/** The relation of a Bits product to a user. */
export type BitsProductSelfEdgeEligibilityArgs = {
  quantity: Scalars['Int'];
};


/** The relation of a Bits product to a user. */
export type BitsProductSelfEdgePurchaseInfoArgs = {
  quantity: Scalars['Int'];
  paymentSession?: Maybe<PaymentSession>;
};

/** An enumerable that identifies bits product types. */
export enum BitsProductType {
  /** A product that has to be purchased. */
  PurchasedProduct = 'PURCHASED_PRODUCT',
  /** An unknown product type. */
  Unknown = 'UNKNOWN'
}

export type BitsPromotion = {
   __typename?: 'BitsPromotion';
  /** id indicates the particular promo that this offer is associated with. */
  id: Scalars['ID'];
  /** PromoType indicates the type of promo that the offer represents i.e First time purchase, single purchase, etc... */
  type: Scalars['String'];
};

/** Settings tied to a bits user. */
export type BitsUserSettings = {
   __typename?: 'BitsUserSettings';
  /** Settings specific to the first cheer tutorial. */
  firstCheerTutorial?: Maybe<FirstCheerTutorial>;
};

/** An enumerable that dictates user's Bits usage state. */
export enum BitsUserState {
  /** The user has never used or acquired Bits. */
  NewUser = 'NEW_USER',
  /** The user has acquired Bits (purchased, watched ads, etc.) but has never used it. */
  Acquired = 'ACQUIRED',
  /** The user has never used or acquired Bits, but clicked "Skip" button to skip the first user experience. */
  Skipped = 'SKIPPED',
  /** The user has cheered before. */
  Cheered = 'CHEERED',
  /** The user state is unknown. */
  Unknown = 'UNKNOWN'
}

/** Information regarding a Blizzard account that is linked to Twitch. */
export type BlizzardUser = {
   __typename?: 'BlizzardUser';
  /** The BattleTag that is stored for the user. */
  battleTag: Scalars['String'];
  /** The Blizzard ID that is stored for the user. */
  id: Scalars['ID'];
  /** The region the Blizzard account is from. */
  region: Scalars['String'];
};

/**
 * Location from where the current user blocked target user.
 * NOTE: it is onlyl used from the block_user mutation, this enum should have been
 * named BlockUserContext and be placed in the same mutation file.
 */
export enum BlockContext {
  Whisper = 'WHISPER',
  Chat = 'CHAT'
}

export type BlockUserInput = {
  /** Reason the user is being blocked. */
  reason?: Maybe<Scalars['String']>;
  sourceContext: BlockContext;
  /** ID of user to block. */
  targetUserID: Scalars['ID'];
};

export type BlockUserPayload = {
   __typename?: 'BlockUserPayload';
  /** User that was blocked. */
  targetUser: User;
};

/** A bounty is a task that a user can complete for a payout. */
export type Bounty = {
   __typename?: 'Bounty';
  /** The campaign that this bounty belongs to. */
  campaign: BountyCampaign;
  /** The chat Call to Action that will be display during the bounty. */
  chatCTA?: Maybe<BountyChatCta>;
  /**
   * When the bounty was claimed by the user.
   * @deprecated Replacing with 'claimedAt' for consistency with 'At' suffix
   */
  claimTime?: Maybe<Scalars['Time']>;
  /** When the bounty was claimed by the user. */
  claimedAt?: Maybe<Scalars['Time']>;
  /**
   * When the bounty expires.
   * @deprecated Replacing with 'expiresAt' as that is a more descriptive property name for the value.
   */
  endAt?: Maybe<Scalars['Time']>;
  /**
   * When the the user stops tracking.
   * @deprecated Replacing with 'trackingStoppedAt' as that is a more descriptive property name for the value.
   */
  endTime?: Maybe<Scalars['Time']>;
  /** When the bounty expires. */
  expiresAt?: Maybe<Scalars['Time']>;
  /** The bounty's unique identifier. */
  id: Scalars['ID'];
  /** The product keys for the bounty. */
  keys?: Maybe<Array<BountyProductKey>>;
  /** When the bounty was last modified. */
  lastModifiedAt?: Maybe<Scalars['Time']>;
  /** The number of concurrent users (CCU) required to hit the maximum payout for the bounty. */
  maximumPayoutCCU?: Maybe<Scalars['Int']>;
  /** The maximum payout for completing this bounty in USD cents. */
  maximumPayoutCents: Scalars['Int'];
  /** The number of concurrent users (CCU) required to earn a payout for the bounty. */
  minimumPayoutCCU?: Maybe<Scalars['Int']>;
  /** The node includes all bounty moderation metadata. */
  moderationMetadata?: Maybe<BountyModerationMetadata>;
  /**
   * The moderation status of the bounty.
   * @deprecated Replacing with 'status' within moderationMetadata.
   */
  moderationStatus?: Maybe<BountyModerationStatus>;
  /** The actual payout for completing this bounty in USD cents. */
  payoutCents?: Maybe<Scalars['Int']>;
  /** The platform on which the user will play the game for this bounty (ie. PC). */
  platform?: Maybe<Scalars['String']>;
  /** The region that the broadcaster has selected for this bounty (as defined by BountyCampaignKeyDescriptor). */
  region?: Maybe<Scalars['String']>;
  /** Restrictions for this bounty. */
  restriction?: Maybe<BountyRestriction>;
  /**
   * When the bounty was claimed by the user.
   * @deprecated Replacing with 'claimTime' as that is a more descriptive property name for the value.
   */
  startAt?: Maybe<Scalars['Time']>;
  /**
   * When the bounty was started by the user.
   * @deprecated Replacing with 'trackingStartedAt' as that is a more descriptive property name for the value.
   */
  startTime?: Maybe<Scalars['Time']>;
  /** The status of the bounty. */
  status: BountyStatus;
  /** When the user starts tracking the bounty. */
  trackingStartedAt?: Maybe<Scalars['Time']>;
  /** When the user stops tracking the bounty. */
  trackingStoppedAt?: Maybe<Scalars['Time']>;
  /** The videos for this bounty. */
  videos?: Maybe<Array<BountyVideo>>;
};

/** Bounty board settings configure how a user can interact with the Bounty Boards feature. */
export type BountyBoardSettings = {
   __typename?: 'BountyBoardSettings';
  /** This determines whether or not a user has a bounty board notification. */
  hasNotification: Scalars['Boolean'];
  /**
   * This determines whether the user has the Bounty Boards feature enabled.
   * @deprecated Use 'status' instead.
   */
  isEnabled: Scalars['Boolean'];
  /** The user's status on Bounty Board. */
  status: BountyBoardUserStatus;
};

/** Represents the user's status on Bounty Board. */
export enum BountyBoardUserStatus {
  /** The user has been invited to join the Bounty Board program but cannot participate in bounties yet. */
  Invited = 'INVITED',
  /** The user has been accepted into the Bounty Board program and can participate in bounties. */
  Accepted = 'ACCEPTED',
  /** The user has been banned from the Bounty Board program. */
  Banned = 'BANNED',
  /** The user is not part of the Bounty Board program. */
  None = 'NONE'
}

/** A campaign defines the requirements and parameters for a set of bounties. */
export type BountyCampaign = {
   __typename?: 'BountyCampaign';
  /** The list of games that if isAllowAllGames is false, the bounty must use. */
  allowedGames?: Maybe<Array<Game>>;
  /** The platforms on which users can play this campaign's game (ie. PC, PS4, Switch). */
  availablePlatforms?: Maybe<Array<Scalars['String']>>;
  /** The length of this campaign's bounties (in days). */
  bountyLengthDays: Scalars['Int'];
  /** Override Box Art URL only for campaign shown on Bounty Board Dashboard, unrelated to game. */
  boxArtURL?: Maybe<Scalars['String']>;
  /** Details about the campaign that only the sponsoring brand should see. */
  brandDetails?: Maybe<BountyCampaignBrandDetails>;
  /** Override Cover URL only for campaign shown on Bounty Board Dashboard, unrelated to game. */
  coverURL?: Maybe<Scalars['String']>;
  /** Details for this campaign. */
  details: Scalars['String'];
  /** Override Display name only for campaign shown on Bounty Board Dashboard, unrelated to game. */
  displayName?: Maybe<Scalars['String']>;
  /**
   * When the campaign expires.
   * @deprecated Replacing with 'endTime' as that is a more descriptive property name for the value.
   */
  endAt: Scalars['Time'];
  /** When the campaign expires. */
  endTime: Scalars['Time'];
  /**
   * The game identifier that is related to this campaign.
   * @deprecated Replacing with 'allowedGames' as this provides a set of available games instead of a single game
   */
  game?: Maybe<Game>;
  /** The campaign's unique identifier. */
  id: Scalars['ID'];
  /** If the campaing is a promotional campaign. */
  isPromotionEligible?: Maybe<Scalars['Boolean']>;
  /** The information about keys for the campaigns. */
  keyDescriptors?: Maybe<Array<BountyCampaignKeyDescriptor>>;
  /**
   * Why the campaign was rejected.
   * @deprecated Use 'rejectionReason' in 'brandDetails' instead.
   */
  rejectionReason?: Maybe<Scalars['String']>;
  /** If a campaign allows any game to be played. */
  shouldAllowAllGames?: Maybe<Scalars['Boolean']>;
  /** The sponsor that is funding this campaign (ie. Amazon Game Studios). */
  sponsor: Scalars['String'];
  /**
   * When the campaign starts.
   * @deprecated Replacing with 'startTime' as that is a more descriptive property name for the value.
   */
  startAt: Scalars['Time'];
  /** When the campaign starts. */
  startTime: Scalars['Time'];
  /**
   * The status of the campaign.
   * @deprecated Use 'status' in 'brandDetails' instead.
   */
  status?: Maybe<BountyCampaignStatus>;
  /** How many seconds a bounty for this campaign must be streamed to complete the bounty. */
  streamLengthSeconds?: Maybe<Scalars['Int']>;
  /** The click target of the campaign if it is a promotional campaign. */
  targetPromotionalVideoClicks?: Maybe<Scalars['Int']>;
  /** The URL for the terms and conditions page. */
  termsAndConditionsURL?: Maybe<Scalars['String']>;
  /** The title of the campaign (ie. Stream Breakaway for 1 hour). */
  title: Scalars['String'];
  /** The tracking URLs for this campaign. */
  trackingPixels?: Maybe<Array<TrackingPixel>>;
  /** The type of the campaign (ie. PAY_TO_STREAM). */
  type: BountyCampaignType;
  /**
   * The URL of the video for this campaign.
   * @deprecated Use 'videos' instead.
   */
  videoURL?: Maybe<Scalars['String']>;
  /** The video URLS for the campaign. */
  videos?: Maybe<Array<BountyCampaignVideo>>;
};

/** Details about a bounty campaign that only the sponsoring brand should see. */
export type BountyCampaignBrandDetails = {
   __typename?: 'BountyCampaignBrandDetails';
  /** The list of users (if any) blacklisted for the campaign. */
  blacklistedBroadcasters?: Maybe<Array<User>>;
  /** The multiplier for the broadcaster payout rate. */
  broadcasterMultiplier?: Maybe<Scalars['Float']>;
  /** Reporting data for the campaign. */
  campaignReporting?: Maybe<BountyCampaignReporting>;
  /** The chat Calls to Action for the campaign. */
  chatCTAs?: Maybe<Array<BountyChatCta>>;
  /**
   * The total number of broadcasters who have claimed the bounty.
   * @deprecated Use 'claimedBountyCount' in 'campaignReporting' instead.
   */
  claimedBountyCount?: Maybe<Scalars['Int']>;
  /**
   * How much of the budget has been claimed (in cents).
   * @deprecated Use 'claimedBudgetCents' in 'campaignReporting' instead.
   */
  claimedBudgetCents?: Maybe<Scalars['Int']>;
  /**
   * The total number of broadcasters who have completed the bounty.
   * @deprecated Use 'completedBountyCount' in 'campaignReporting' instead.
   */
  completedBountyCount?: Maybe<Scalars['Int']>;
  /**
   * The total number of broadcasters who have expanded the bounty.
   * @deprecated Use 'expandedBountyCount' in 'campaignReporting' instead.
   */
  expandedBountyCount?: Maybe<Scalars['Int']>;
  /** If all broadcasters are targeted for the campaign. */
  includesAllBroadcasters?: Maybe<Scalars['Boolean']>;
  /** If all countries are targeted for the campaign. */
  includesAllCountries: Scalars['Boolean'];
  /** If all games are targeted for the campaign. */
  includesAllGames: Scalars['Boolean'];
  /** If variety broadcasters are targeted for the campaign. */
  includesVarietyBroadcasters: Scalars['Boolean'];
  /**
   * Detailed performance metrics for this campaign.
   * @deprecated Use 'performanceMetrics' in 'campaignReporting' instead.
   */
  performanceMetrics?: Maybe<Array<BountyCampaignPerformanceMetric>>;
  /** Why the campaign was rejected. */
  rejectionReason?: Maybe<Scalars['String']>;
  /** How much of the budget has been spent (completed bounties) (in cents). */
  spentBudgetCents?: Maybe<Scalars['Int']>;
  /** The status of the campaign. */
  status?: Maybe<BountyCampaignStatus>;
  /** Targeted countries for the campaign (represented by ISO 3166-1 alpha-2). */
  targetedCountries?: Maybe<Array<Scalars['String']>>;
  /** Targeted Games for the campaign. */
  targetedGames?: Maybe<Array<Game>>;
  /** The total budget for the campaign (in cents). */
  totalBudgetCents?: Maybe<Scalars['Int']>;
  /**
   * The number of broadcasters who have viewed the bounty.
   * @deprecated Use 'viewedBountyCount' in 'campaignReporting' instead.
   */
  viewedBountyCount?: Maybe<Scalars['Int']>;
};

/** The chat Call to Action (CTA) that will be created as part of this campaign. */
export type BountyCampaignChatCtaInput = {
  /** The country that the chat CTA is targeted for (represented by ISO 3166-1 alpha-2). */
  countryCode: Scalars['String'];
  /** The title for the chat CTA. */
  title: Scalars['String'];
  /** The URL for the chat CTA. */
  url: Scalars['String'];
};

/** A list of bounty campaigns related to the subject. */
export type BountyCampaignConnection = {
   __typename?: 'BountyCampaignConnection';
  /** The campaigns. */
  edges?: Maybe<Array<Maybe<BountyCampaignEdge>>>;
  /** Information about pagination in this connection. */
  pageInfo: PageInfo;
};

/**
 * Information about the relationship to the bounty campaign and the subject.
 * Also includes the campaign itself.
 */
export type BountyCampaignEdge = {
   __typename?: 'BountyCampaignEdge';
  /** Uniquely identifies this campaign's position in a connection. */
  cursor: Scalars['Cursor'];
  /** The campaign. */
  node?: Maybe<BountyCampaign>;
};

/** A descriptor for a product key. */
export type BountyCampaignKeyDescriptor = {
   __typename?: 'BountyCampaignKeyDescriptor';
  /** The platform for the key. */
  platform: Scalars['String'];
  /** The region for the key. */
  region: Scalars['String'];
};

/** Metric containing details about how a campaign performed over a time period. */
export type BountyCampaignPerformanceMetric = {
   __typename?: 'BountyCampaignPerformanceMetric';
  /** The number of click-throughs from the Chat CTAs of the campaign. */
  chatCTAClickThroughCount?: Maybe<Scalars['Int']>;
  /** The total number of bounties that were completed. */
  completedBountyCount: Scalars['Int'];
  /** The end time of this metric. */
  endTime: Scalars['Time'];
  /** The total number of minutes watched. */
  minutesWatched: Scalars['Int'];
  /** The start time of this metric. */
  startTime: Scalars['Time'];
  /** The number of viewers that watched at least thirty seconds of the campaign's content. */
  thirtySecondViewerCount: Scalars['Int'];
  /** The total number of viewers that watched the campaign's content. */
  totalViewerCount: Scalars['Int'];
  /** The number of viewers that watched at least two minutes of the campaign's content. */
  twoMinuteViewerCount: Scalars['Int'];
};

/** Details about a bounty campaign reporting that only the sponsoring brand should see. */
export type BountyCampaignReporting = {
   __typename?: 'BountyCampaignReporting';
  /** The total number of clicks from chat CTAs from every bounty. */
  chatCTAsClicks?: Maybe<Scalars['Int']>;
  /** The total number of impressions from chat CTAs from every bounty. */
  chatCTAsImpressions?: Maybe<Scalars['Int']>;
  /** The total number of broadcasters who have claimed the bounty. */
  claimedBountyCount?: Maybe<Scalars['Int']>;
  /** How much of the budget has been claimed (live bounties) (in cents). */
  claimedBudgetCents?: Maybe<Scalars['Int']>;
  /** The total number of broadcasters who have completed the bounty. */
  completedBountyCount?: Maybe<Scalars['Int']>;
  /** The total number of broadcasters who have expanded the bounty. */
  expandedBountyCount?: Maybe<Scalars['Int']>;
  /** Detailed performance metrics for this campaign. */
  performanceMetrics?: Maybe<Array<BountyCampaignPerformanceMetric>>;
  /** How much of the budget has been spent (completed bounties) (in cents). */
  spentBudgetCents?: Maybe<Scalars['Int']>;
  /** The number of broadcasters who have viewed the bounty. */
  viewedBountyCount?: Maybe<Scalars['Int']>;
};

/** The status of a bounty campaign. */
export enum BountyCampaignStatus {
  /** The campaign is pending approval. */
  Pending = 'PENDING',
  /** The campaign has been approved. */
  Approved = 'APPROVED',
  /** The campaign has been rejected. */
  Rejected = 'REJECTED',
  /** The campaign is live. */
  Live = 'LIVE',
  /** The campaign is done. */
  Completed = 'COMPLETED'
}

/** Represents the type of the campaign. */
export enum BountyCampaignType {
  /** A user is paid to stream themselves playing a game. */
  PayToStream = 'PAY_TO_STREAM',
  /** A user is paid to stream a game trailer. */
  GameTrailer = 'GAME_TRAILER',
  /** A user is paid to stream a non-game trailer (ie. a movie trailer). */
  MiscTrailer = 'MISC_TRAILER'
}

/** Possible upload types for bounty campaigns. */
export enum BountyCampaignUploadType {
  /** Upload type related to the box art image. */
  BoxArt = 'BOX_ART',
  /** Upload type related to the cover image. */
  Cover = 'COVER'
}

/** A video for a bounty board campaign. */
export type BountyCampaignVideo = {
   __typename?: 'BountyCampaignVideo';
  /** The country that the video is targeted for (represented by ISO 3166-1 alpha-2). */
  country: Scalars['String'];
  /** The title of the video. */
  title: Scalars['String'];
  /** The URL of the video. */
  url: Scalars['String'];
};

/** The video that will be created as part of this campaign. */
export type BountyCampaignVideoInput = {
  /** The country that the video is targeted for (represented by ISO 3166-1 alpha-2). */
  country: Scalars['String'];
  /** The title of the video. */
  title: Scalars['String'];
  /** The URL of the video. */
  url: Scalars['String'];
};

/** A chat Call to Action (CTA) that will be trigger in the broadcaster chat while doing the bounty. */
export type BountyChatCta = {
   __typename?: 'BountyChatCTA';
  /** The country targeted for the chat CTA (represented by ISO 3166-1 alpha-2). */
  countryCode: Scalars['String'];
  /** The time (in seconds) between each appearance of the chat CTA. */
  frequencySeconds: Scalars['Int'];
  /** The initial delay (in seconds) before the first chat CTA. */
  initialDelaySeconds: Scalars['Int'];
  /** The title of the chat CTA. */
  title: Scalars['String'];
  /** The URL of the chat CTA. */
  url: Scalars['String'];
};

/** A list of bounty related to the subject. */
export type BountyConnection = {
   __typename?: 'BountyConnection';
  /** The bounties. */
  edges?: Maybe<Array<BountyEdge>>;
  /** Information about pagination in this connection. */
  pageInfo: PageInfo;
};

/**
 * Information about the relationship to the bounty and the subject.
 * Also includes the bounty itself.
 */
export type BountyEdge = {
   __typename?: 'BountyEdge';
  /** Uniquely identifies this bounty's position in a connection. */
  cursor: Scalars['Cursor'];
  /** The bounty. */
  node?: Maybe<Bounty>;
};

/** Represents all the currently possible key product types. */
export enum BountyKeyProductType {
  /** The key is a coupon code. */
  Coupon = 'COUPON',
  /** The key is for downloadable content or a game expansion. */
  Dlc = 'DLC',
  /** The key is a game code. */
  Game = 'GAME',
  /** The key is for a gift card. */
  Giftcard = 'GIFTCARD',
  /** The key is a code for a giveaway. */
  Giveaway = 'GIVEAWAY',
  /** The key is for in game content - character skins, customization, etc. */
  Igc = 'IGC',
  /** The key is for something else. */
  Other = 'OTHER'
}

/** The reason why bounty failed moderation. */
export enum BountyModerationFailReason {
  /** Moderation failed because broadcast does not meet minimal stream length requirement. */
  MinimumTimeNotMet = 'MINIMUM_TIME_NOT_MET',
  /** Moderation failed because broadcast is not with required content. */
  IncorrectContent = 'INCORRECT_CONTENT',
  /** Moderation failed because broadcaster did badmouthing during stream. */
  Badmouthing = 'BADMOUTHING',
  /** Moderation failed because other content layered over/under required content. */
  OtherContentVisible = 'OTHER_CONTENT_VISIBLE',
  /** Moderation failed because broadcaster had exessive idle time during sponsored stream. */
  Idle = 'IDLE',
  /** Moderation failed because missing sponsored stream VOD. */
  NoVod = 'NO_VOD',
  /** Other reason caused moderation failed. */
  Other = 'OTHER'
}

/** Bounty Moderation metadata includes moderation metadata for a specific bounty. */
export type BountyModerationMetadata = {
   __typename?: 'BountyModerationMetadata';
  /** The moderation fail reason of the bounty. */
  reason?: Maybe<BountyModerationFailReason>;
  /** The moderation status of the bounty. */
  status?: Maybe<BountyModerationStatus>;
  /** When the bounty was last moderated. */
  updatedAt?: Maybe<Scalars['Time']>;
};

/** The moderation status of the bounty. */
export enum BountyModerationStatus {
  /** The bounty has passed the moderation check. */
  Pass = 'PASS',
  /** The bounty has failed the moderation check. */
  Fail = 'FAIL'
}

/** A key that can be redeemed for a product. */
export type BountyProductKey = {
   __typename?: 'BountyProductKey';
  /** The code that is used to redeem the product. */
  code: Scalars['String'];
  /** The platform where the code is redeemed. */
  platform?: Maybe<Scalars['String']>;
  /** The product type of the key - GAME, DLC, GIVEAWAY, GIFTCARD, etc. */
  productType?: Maybe<BountyKeyProductType>;
  /**
   * The region where the code can be redeemed. The format and granularity of this field varies
   * depending on the product key vendor.
   */
  region?: Maybe<Scalars['String']>;
};

/** Defines the restrictions that are placed on a bounty. */
export type BountyRestriction = {
   __typename?: 'BountyRestriction';
  /**
   * The days of the week that a bounty can be completed on. The values are from 0
   * to 6, representing day of the week from Monday to Sunday.
   */
  days?: Maybe<Array<Scalars['Int']>>;
  /** The end of the time period that a bounty can be completed in. This is in 24-hour clock notation, so 2100 means 9 PM UTC. */
  endTime?: Maybe<Scalars['Int']>;
  /**
   * The start of the time period that a bounty can be completed in. This is in
   * 24-hour clock notation, so 1000 means 10 AM UTC.
   */
  startTime?: Maybe<Scalars['Int']>;
};

/** Represents all the possible bounty statuses. */
export enum BountyStatus {
  /** The bounty can be claimed by the user. */
  Available = 'AVAILABLE',
  /** The bounty has been claimed by the user and is in progress. */
  Live = 'LIVE',
  /** The bounty was completed successfully. */
  Completed = 'COMPLETED',
  /** The bounty was cancelled before it was completed. */
  Cancelled = 'CANCELLED'
}

/** A video that the broadcaster must play on stream to complete the bounty. */
export type BountyVideo = {
   __typename?: 'BountyVideo';
  /** The title of the video. */
  title: Scalars['String'];
  /** The URL of the video. */
  url: Scalars['String'];
};

/** Brand portal settings configure how a company can interact with the brand portal. */
export type BrandPortalSettings = {
   __typename?: 'BrandPortalSettings';
  /** This determines whether or not a company can access all games in brand portal. */
  canAccessAllGames: Scalars['Boolean'];
  /** This determines whether or not a company can access the Brand Portal. */
  isEnabled: Scalars['Boolean'];
};

/** A historical representation of a live stream. */
export type Broadcast = {
   __typename?: 'Broadcast';
  /** The game which was last streamed during the broadcast. */
  game?: Maybe<Game>;
  /** The broadcast's unique identifier. */
  id?: Maybe<Scalars['ID']>;
  /** When the broadcast started. */
  startedAt?: Maybe<Scalars['Time']>;
  /** The title of the broadcast. */
  title?: Maybe<Scalars['String']>;
};

/** An indicator of the viewer reach for a pool of a broadcasters. */
export type BroadcasterViewerReach = {
   __typename?: 'BroadcasterViewerReach';
  /** Range of the number of broadcasters in the pool. */
  broadcasterPool: Range;
  /** Range of minutes watched for this bounty campaign. */
  minutesWatched: Range;
  /** Range of total viewers across the broadcaster pool. */
  viewerPool: Range;
};

/** BroadcastFormat is type of ingest live sessions. */
export enum BroadcastFormat {
  /** Default live stream. Primary session for the backup session will be shown as live. */
  Live = 'LIVE',
  /** Stream with intentional delays requested by the broadcaster. */
  Delay = 'DELAY',
  /** Primary session which backup session was stitched back to. */
  Backup_000 = 'BACKUP_000',
  /** First backup session. */
  Backup_001 = 'BACKUP_001',
  /** Second backup session. */
  Backup_002 = 'BACKUP_002',
  /** Third backup session. */
  Backup_003 = 'BACKUP_003'
}

/** Settings for a User's broadcast that persist between streams. */
export type BroadcastSettings = {
   __typename?: 'BroadcastSettings';
  /**
   * The game that the user has set as their current game. This will influence what
   * the game field on a Streams object is when the User starts streaming.
   */
  game?: Maybe<Game>;
  /**
   * The broadcast setting's unique identifier.
   * This happens to be the same as the User's ID, but should not be assumed to have any meaning.
   */
  id: Scalars['ID'];
  /** A flag indicating if the user's broadcast is intended for mature audiences only. */
  isMature: Scalars['Boolean'];
  /**
   * The primary language that the user has configured for their broadcasts. The
   * default value is "", when the user has not indicated a primary language.
   */
  language: Language;
  /**
   * The text that will be in the notification that sends when the user starts broadcasting.
   * The default value is "<user> went live!", when the user has not set a custom value.
   * @deprecated Use liveUpNotificationInfo instead.
   */
  liveUpNotification?: Maybe<Scalars['String']>;
  /** The information about the live up notification of a user. */
  liveUpNotificationInfo?: Maybe<LiveUpNotificationInfo>;
  /** The title of the user's broadcast. The default value is "", when the user has not indicated a title. */
  title: Scalars['String'];
};

/**
 * Describes from which source the video originated.
 * NOTE: Should have been named VideoBroadcastType.
 */
export enum BroadcastType {
  /** If the video is of a past broadcast, it's an ARCHIVE. */
  Archive = 'ARCHIVE',
  /** When the video is a subsection of a past broadcast, it's a HIGHLIGHT. */
  Highlight = 'HIGHLIGHT',
  /** (Legacy) When the video is directly uploaded to Twitch via the upload tool, it's an UPLOAD. */
  Upload = 'UPLOAD',
  /** When the video is directly uploaded to Twitch via the video manager, it's an PREMIERE_UPLOAD. */
  PremiereUpload = 'PREMIERE_UPLOAD',
  /** When a video has been premiered on Twitch and is saved, it's a PAST_PREMIERE. */
  PastPremiere = 'PAST_PREMIERE'
}

/** A visible campaign on a given user's channel. */
export type Campaign = {
   __typename?: 'Campaign';
  /** The domain that campaign belongs to. */
  domain: Scalars['String'];
  /** The time the campaign ends being active. */
  endDate: Scalars['Time'];
  /** Unique identifier for the campaign. */
  id: Scalars['ID'];
  /** The objectives users can progress in within this campaign. */
  objectives: Array<CampaignObjective>;
  /** The time the campaign becomes active. */
  startDate: Scalars['Time'];
};

/**
 * This type holds the information about the grouping of objectives. Each group has
 * a list of cheermotes that progress objectives in this particular group.
 */
export type CampaignCheergroup = {
   __typename?: 'CampaignCheergroup';
  /** A list of upper cased cheermotes that can advance objectives belonging to this group. */
  cheerCodes: Array<Scalars['String']>;
  /** An a parent group this cheer group belongs to (e.g. "North America"). */
  division?: Maybe<Scalars['String']>;
  /** A url to the image representing this group (e.g. team icon in esports context). */
  imageUrl: Scalars['String'];
  /** A name representing this group (e.g. team name in esports context). */
  name: Scalars['String'];
};

/** CampaignDiscoveryEventType contains the different types of discovery events that campaign objectives can track. */
export enum CampaignDiscoveryEventType {
  /** An event describing a user's interaction with the command center. */
  EngageCommandCenter = 'ENGAGE_COMMAND_CENTER',
  /** An event describing a user's interaction with a stream. */
  EngageStream = 'ENGAGE_STREAM'
}

/**
 * This type holds information about a campaign objective, which belongs to a campaign.
 * An objective can hold multiple milestones which users can hit and get rewards.
 * An objective can hold a cheer group.
 */
export type CampaignObjective = {
   __typename?: 'CampaignObjective';
  /** Cheergroup this objective might belong to. */
  cheergroup?: Maybe<CampaignCheergroup>;
  /** Short description about the objective. */
  description: Scalars['String'];
  /** Unique identifier for the objective. */
  id: Scalars['ID'];
  /** If the objective belongs to an active parent campaign. */
  isActive: Scalars['Boolean'];
  /** Milestones users can hit by advancing this objective. */
  milestones?: Maybe<Array<Milestone>>;
  /** User's participation towards the objective. */
  participation: Scalars['Int'];
  /** Global progress for the objective. */
  progress: Scalars['Int'];
  /** The type of objective this is for. It can be either INDIVIDUAL or GLOBAL (TEAM is deprecated). */
  tag: Scalars['String'];
  /** Short title for the objective. */
  title: Scalars['String'];
};

/** All Campaign properties that are running for a given user. */
export type CampaignProperties = {
   __typename?: 'CampaignProperties';
  /** All the current active campaigns for a given user. */
  activeCampaigns?: Maybe<Array<Scalars['String']>>;
  /** All the current domains a user is participating in. */
  domains?: Maybe<Array<Scalars['String']>>;
  /** Determines whether or not a user has a pass they can sell on their channel. */
  hasPass: Scalars['Boolean'];
  /** Objectives users can progress within all the active campaigns for the first domain. */
  objectives?: Maybe<Array<CampaignObjective>>;
  /** Triggers users can activate to get / give rewards within this campaign. */
  triggers?: Maybe<Array<CampaignTrigger>>;
};

/** Metadata for the reward that only impacts how the rewards are rendered on the front end apps. */
export type CampaignRewardMetadata = {
   __typename?: 'CampaignRewardMetadata';
  /**
   * Whether the reward is initially unavailable upon redeeming.
   * @deprecated Field no longer supported
   */
  isPending: Scalars['Boolean'];
  /**
   * Reward subtype usually specific to the game the campaign belongs to (e.g. skin, spray, etc).
   * @deprecated Field no longer supported
   */
  subType?: Maybe<Scalars['String']>;
};

/**
 * This type holds information about a campaign trigger, which belongs to a campaign.
 * A trigger has a list of rewards that can be earned by various one time events.
 */
export type CampaignTrigger = {
   __typename?: 'CampaignTrigger';
  /** Short description about the trigger. */
  description: Scalars['String'];
  /** Unique identifier for the trigger. */
  id: Scalars['ID'];
  /** Whether the trigger is currently active. */
  isActive: Scalars['Boolean'];
  /** List of rewards attached to this trigger. */
  rewards?: Maybe<Array<TournamentReward>>;
  /** Short title for the trigger. */
  title: Scalars['String'];
  /** Maximum amount of trigger quantity required for the trigger (e.g. # of bits in cheer). */
  triggerAmountMax: Scalars['Int'];
  /** Minimum amount of trigger quantity required for the trigger (e.g. # of bits in cheer). */
  triggerAmountMin: Scalars['Int'];
  /** String defining the trigger type (e.g. CHEER). */
  triggerType: TriggerType;
};

/** Error code for an error that occurs while canceling the bounty. */
export type CancelBountyError = {
   __typename?: 'CancelBountyError';
  /** Error code for error that occurred while canceling the bounty. */
  code: CancelBountyErrorCode;
};

/** Error types recognized. */
export enum CancelBountyErrorCode {
  /** Invalid parameter in the request. */
  InvalidParameter = 'INVALID_PARAMETER',
  /** Bounty isn't live, thus cannot be canceled. */
  BountyNotLive = 'BOUNTY_NOT_LIVE',
  /** Unknown error being returned from service. */
  UnknownError = 'UNKNOWN_ERROR'
}

/** CancelBountyInput includes the bounty a user is trying to cancel. */
export type CancelBountyInput = {
  /** Unique Identifier for the bounty. */
  bountyID: Scalars['ID'];
  /** Reason that the user canceled the bounty. */
  reason?: Maybe<Scalars['String']>;
  /** UserID of the user that will cancel the bounty. */
  userID: Scalars['ID'];
};

/** Data that was mutated after canceling the bounty. */
export type CancelBountyPayload = {
   __typename?: 'CancelBountyPayload';
  /** The canceled bounty with the updated status. */
  bounty?: Maybe<Bounty>;
  /** The possible error returned from the service. */
  error?: Maybe<CancelBountyError>;
  /** The user that now has the canceled bounty. */
  user?: Maybe<User>;
};

export type CancelFriendRequestInput = {
  /** The authenticated user will cancel the friend request sent to the user with an ID equal to targetID. */
  targetID: Scalars['ID'];
};

export type CancelFriendRequestPayload = {
   __typename?: 'CancelFriendRequestPayload';
  /** The user whose friend request was just cancelled. */
  user?: Maybe<User>;
};

/** Describes the conditions around a user's cancellation of their purchase (e.g. refund policy). */
export enum CancellationPolicyType {
  /** The product is not refundable. */
  NonRefundable = 'NON_REFUNDABLE',
  /** The product is refundable. */
  Refundable = 'REFUNDABLE'
}

/** CancelPayoutOnboardingWorkflowInput returns the required input when starting a new workflow for payout onboarding. */
export type CancelPayoutOnboardingWorkflowInput = {
  /** TargetUserID is the ID of the user whose workflow will be started. */
  targetUserID: Scalars['ID'];
};

/** CancelPayoutOnboardingWorkflowPayload is the payload returned after canceling a payout onboarding workflow. */
export type CancelPayoutOnboardingWorkflowPayload = {
   __typename?: 'CancelPayoutOnboardingWorkflowPayload';
  /** A new workflow status. */
  workflow?: Maybe<PayoutOnboardingWorkflow>;
};

/** CancelRaidError is the error associated with a cancelRaid. */
export type CancelRaidError = {
   __typename?: 'CancelRaidError';
  /** The associated error code. */
  code: CancelRaidErrorCode;
};

/** CancelRaidErrorCode are the possible errors that this mutation returns. */
export enum CancelRaidErrorCode {
  /** The a raid does not exist. */
  RaidDoesNotExist = 'RAID_DOES_NOT_EXIST',
  /** The request is missing valid channel parameters. */
  InvalidChannel = 'INVALID_CHANNEL',
  /** The user tries to unraid without an active raid. */
  NoActiveRaid = 'NO_ACTIVE_RAID'
}

/** Inputs to the cancelRaid mutation. */
export type CancelRaidInput = {
  /** Source ID. */
  sourceID: Scalars['ID'];
};

/** Outputs from the cancelRaid mutation. */
export type CancelRaidPayload = {
   __typename?: 'CancelRaidPayload';
  /** The possible error returned from the service. */
  error?: Maybe<CancelRaidError>;
  /** The cancelled raid. */
  raid?: Maybe<Raid>;
};

/** Inputs for the mutation. Gift to be canceled by productID and originID. */
export type CancelSubscriptionGiftInput = {
  /** originID is the origin id created during the gift purchase. */
  originID: Scalars['ID'];
  /** productID is the ticket product id for this gift. */
  productID: Scalars['ID'];
};

/** The returned payload from the mutation for canceling a Subscription Gift. */
export type CancelSubscriptionGiftPayload = {
   __typename?: 'CancelSubscriptionGiftPayload';
  /** SubscriptionGift object that was deleted. */
  gift?: Maybe<SubscriptionGift>;
};

/**
 * Celebration is a configuration that denotes when a celebration is triggerd and
 * when sort of celebration will show when it triggers.
 */
export type Celebration = {
   __typename?: 'Celebration';
  /** Area of the channel page in which the celebration will appear. */
  area: CelebrationArea;
  /** Duration which the celebration will play. */
  durationMilliseconds: Scalars['Int'];
  /** Effect which will be shown when then celebration is triggered. */
  effect: CelebrationEffect;
  /**
   * Amount that needs to be met in order to trigger this celebration.
   * For example, when the event type is subscription gift, this value will
   * determine how many gifts must be given at a single time to trigger the 
   * celebration.
   */
  eventThreshold: Scalars['Int'];
  /** Type of event which will trigger this celebration. */
  eventType: CelebrationEventType;
  /** Unique identifier for the celebration. */
  id: Scalars['ID'];
  /**
   * Intensity of the celebration.
   * Should be bounded (TBA) value which will determine the spectacle of the celebration.
   */
  intensity: Scalars['Int'];
  /** If true, the celebration is enabled. */
  isEnabled: Scalars['Boolean'];
};

/** Area in which the celebration will show. */
export enum CelebrationArea {
  /** Celebration will show everywhere over the channel page. */
  Everywhere = 'EVERYWHERE',
  /** Celebration will show only over the video. */
  VideoOnly = 'VIDEO_ONLY',
  /** Celebration will show over the video and panel. */
  VideoAndPanel = 'VIDEO_AND_PANEL',
  /** Unknown celebration area. */
  Unknown = 'UNKNOWN'
}

/** The channels configuration of celebrations. */
export type CelebrationConfig = {
   __typename?: 'CelebrationConfig';
  /** List of celebrations for this channel. */
  celebrations: Array<Celebration>;
  /** The identifier for the celebration config. */
  id: Scalars['ID'];
  /** If celebrations are enabled on this channel. */
  isEnabled: Scalars['Boolean'];
};

/** Type of effect that can show during a celebration. */
export enum CelebrationEffect {
  /** Will show fireworks when the celebration triggers. */
  Fireworks = 'FIREWORKS',
  /** Will show an emote rain when the celebration triggers. */
  Rain = 'RAIN',
  /** Will show an flamethrowers when the celebration triggers. */
  Flamethrowers = 'FLAMETHROWERS',
  /** Unknown effect. */
  Unknown = 'UNKNOWN'
}

/** Celebration error. */
export type CelebrationError = {
   __typename?: 'CelebrationError';
  /** Code describing the error. */
  code: CelebrationErrorCode;
};

/** Vote in celebration error code. */
export enum CelebrationErrorCode {
  /** Attempted to preform operation on celebration that does not exist. */
  CelebrationNotFound = 'CELEBRATION_NOT_FOUND',
  /** A celebration with that same event type and threshold already exists. */
  CelebrationAlreadyExists = 'CELEBRATION_ALREADY_EXISTS',
  /** Requesting user does not have permission. */
  PermissionDenied = 'PERMISSION_DENIED',
  /** The user has reached the limit (20) of celebrations they can have. */
  OverCelebrationLimit = 'OVER_CELEBRATION_LIMIT',
  /** An unknown error occurred. */
  Unknown = 'UNKNOWN'
}

/** Type of event that can trigger a celebration. */
export enum CelebrationEventType {
  /** Cheering with bits. */
  BitsCheer = 'BITS_CHEER',
  /** Gifting subscriptions to other users. */
  SubscriptionGift = 'SUBSCRIPTION_GIFT',
  /** Unknown event type. */
  Unknown = 'UNKNOWN'
}

/** A condition to be satisfied by a specific owner. */
export type ChallengeCondition = {
   __typename?: 'ChallengeCondition';
  /** When the condition was created. */
  createdAt?: Maybe<Scalars['Time']>;
  /** Settings that define how the effects of the condition participants associated with this condition will be processed. */
  effectSettings?: Maybe<Array<ChallengeEffectSettings>>;
  /** Unique ID of the condition. */
  id: Scalars['ID'];
  /** The name of the condition. */
  name: Scalars['String'];
  /** The user who creates and owns the condition. */
  owner?: Maybe<User>;
  /** A summary of condition participants attached to the condition. */
  participantSummary?: Maybe<ChallengeConditionParticipantSummaryByState>;
  /** The current state of the condition. */
  state: ChallengeConditionState;
  /** The list of effect types supported by this condition. */
  supportedEffects: Array<ChallengeEffectType>;
  /** When the condition times out. */
  timeoutAt?: Maybe<Scalars['Time']>;
  /** When the condition was last modified. */
  updatedAt?: Maybe<Scalars['Time']>;
  /** Whether the condition becomes inactive once it has been satisfied. */
  willDisableWhenSatisfied: Scalars['Boolean'];
};

/** A condition participant action that will be taken if an associated condition is satisfied. */
export type ChallengeConditionParticipant = {
   __typename?: 'ChallengeConditionParticipant';
  /** The associated condition. */
  condition?: Maybe<ChallengeCondition>;
  /** The effect that will occur if the condition participant is satisfied. */
  effect: ChallengeEffect;
  /** Final state of the condition participant. */
  endState: ChallengeConditionParticipantEndState;
  /** Unique ID of the condition participant. */
  id: Scalars['ID'];
  /** The user who creates and owns the condition participant. */
  owner?: Maybe<User>;
  /** Whether or not the condition participant was successfully processed upon condition completion. */
  processingState: ChallengeConditionParticipantProcessingState;
};

/** Final state of the condition participant. */
export enum ChallengeConditionParticipantEndState {
  /** Pending completion of associated condition. */
  Pending = 'PENDING',
  /** Associated condition expired. */
  ConditionExpired = 'CONDITION_EXPIRED',
  /** Associated condition was canceled. */
  ConditionCanceled = 'CONDITION_CANCELED',
  /** Associated condition was satisfied. */
  ConditionSatisfied = 'CONDITION_SATISFIED',
  /** Condition participant expired before associated condition could be satisfied. */
  Expired = 'EXPIRED',
  /** Condition participant was canceled. */
  Canceled = 'CANCELED',
  /** Condition participant failed validation prior to being processed. */
  FailedValidation = 'FAILED_VALIDATION',
  /** Unknown state. */
  Unknown = 'UNKNOWN'
}

/** Whether or not the condition participant was successfully processed upon condition completion. */
export enum ChallengeConditionParticipantProcessingState {
  /** Pending completion of associated condition. */
  Pending = 'PENDING',
  /** Condition participant processed successfully. */
  Success = 'SUCCESS',
  /** Error processing condition participant. */
  Error = 'ERROR',
  /** Unknown state. */
  Unknown = 'UNKNOWN'
}

/** A summary of participants attached to a particular condition in a particular state. */
export type ChallengeConditionParticipantSummary = {
   __typename?: 'ChallengeConditionParticipantSummary';
  /** Summary of participant effects attached to a particular condition in a particular state. */
  effects?: Maybe<ChallengeEffectSummary>;
  /** Total count of participants attached to a particular condition in a particular state. */
  total: Scalars['Int'];
};

/** A summary of condition participants attached to a particular condition, grouped by state. */
export type ChallengeConditionParticipantSummaryByState = {
   __typename?: 'ChallengeConditionParticipantSummaryByState';
  /** Summary of participants attached to a particular condition in the CANCELED state. */
  canceled?: Maybe<ChallengeConditionParticipantSummary>;
  /** Summary of participants attached to a particular condition in the CONDITION_CANCELED state. */
  conditionCanceled?: Maybe<ChallengeConditionParticipantSummary>;
  /** Summary of participants attached to a particular condition in the CONDITION_TIMEOUT state. */
  conditionTimeout?: Maybe<ChallengeConditionParticipantSummary>;
  /** Summary of participants attached to a particular condition in the FAILED_VALIDATION state. */
  failedValidation?: Maybe<ChallengeConditionParticipantSummary>;
  /** Summary of participants attached to a particular condition in the PENDING state. */
  pending?: Maybe<ChallengeConditionParticipantSummary>;
  /** Summary of participants attached to a particular condition in the SATISFIED state. */
  satisfied?: Maybe<ChallengeConditionParticipantSummary>;
  /** Summary of participants attached to a particular condition in the TIMEOUT state. */
  timeout?: Maybe<ChallengeConditionParticipantSummary>;
  /** Total count of participants attached to a particular condition. */
  total: Scalars['Int'];
};

/** The current state of the condition. */
export enum ChallengeConditionState {
  /** New condition participants can be associated with this condition. */
  Active = 'ACTIVE',
  /** Condition was manually terminated. New condition participants cannot be associated. */
  Canceled = 'CANCELED',
  /** Condition was satisfied for the final time. New condition participants cannot be associated with this condition. */
  Inactive = 'INACTIVE',
  /** Condition was automatically terminated. New condition participants cannot be associated. */
  Expired = 'EXPIRED',
  /** Unknown state. */
  Unknown = 'UNKNOWN'
}

/** An effect that will occur if a challenge condition participant is satisfied. */
export type ChallengeEffect = {
   __typename?: 'ChallengeEffect';
  /** Details of the effect. */
  details: ChallengeEffectDetails;
  /** The type of effect. */
  type: ChallengeEffectType;
};

/** Details of the effect. */
export type ChallengeEffectDetails = ChallengeUseBitsEffectDetails;

/** Settings that define how effects will be processed when a condition is satisfied. */
export type ChallengeEffectSettings = {
   __typename?: 'ChallengeEffectSettings';
  /** Details of the effect settings. */
  details: ChallengeEffectSettingsDetails;
  /** The type of effect. */
  type: ChallengeEffectType;
};

/** Details of the effect settings. */
export type ChallengeEffectSettingsDetails = ChallengeUseBitsEffectSettingsDetails;

/** A summary of effects attached to a particular condition in a particular state. Keys correspond to ChallengeEffectType enum. */
export type ChallengeEffectSummary = {
   __typename?: 'ChallengeEffectSummary';
  /** USE_BITS effects. */
  useBits?: Maybe<ChallengeUseBitsEffectSummary>;
};

/** The type of effect. */
export enum ChallengeEffectType {
  /** Type of effect that results in using a user's bits. */
  UseBits = 'USE_BITS',
  /** Unknown type. */
  Unknown = 'UNKNOWN'
}

/** Details of the UseBits effect. */
export type ChallengeUseBitsEffectDetails = {
   __typename?: 'ChallengeUseBitsEffectDetails';
  /** The user who uses the bits. */
  benefactor?: Maybe<User>;
  /** The amount of bits to be used. */
  bitsAmount: Scalars['Int'];
};

/** Details of the UseBits effect settings. */
export type ChallengeUseBitsEffectSettingsDetails = {
   __typename?: 'ChallengeUseBitsEffectSettingsDetails';
  /** A list of the different bits recipients and their weighted share of the total bits pool once the condition is satisfied. */
  bitsRecipientWeightedShares: Array<ChallengeUseBitsPoolRecipientWeightedShare>;
};

/** A summary of USE_BITS effects attached to a particular condition in a particular state. */
export type ChallengeUseBitsEffectSummary = {
   __typename?: 'ChallengeUseBitsEffectSummary';
  /** Sum of Bits rolling up to a particular condition in a particular state. */
  totalBitsAmount: Scalars['Int'];
  /** Total count of USE_BITS effects rolling up to a particular condition in a particular state. */
  totalEffects: Scalars['Int'];
};

/**
 * ChallengeUseBitsPoolRecipientWeightedShare represents the weighted share of the total bits pool
 * that a recipient user is entitled to upon condition satisfaction.
 */
export type ChallengeUseBitsPoolRecipientWeightedShare = {
   __typename?: 'ChallengeUseBitsPoolRecipientWeightedShare';
  /** The bits recipient user. */
  recipient?: Maybe<User>;
  /**
   * The weight of the recipient's share from the total bits pool. The sum of all the recipients' weights
   * dictates the proportion that a particular recipient receives from the pool
   * (shareWeight/totalShareWeight * totalBitsAmountInPool).
   */
  weight: Scalars['Int'];
};

/** ChangelogEntry is an entry that displays new items and notifications in the creator homepage changelog. */
export type ChangelogEntry = {
   __typename?: 'ChangelogEntry';
  /** content is localized text content for the changelog entry. */
  content: Scalars['String'];
  /** iconURL is the url for the entry's icon image. */
  iconURL: Scalars['String'];
  /** id is a unique human readable slug for the entry e.g. "squad-stream". */
  id: Scalars['ID'];
  /** linkText is the text that the linkURL should display. */
  linkText?: Maybe<Scalars['String']>;
  /** linkURL is an optional link for more content for this changelog entry. */
  linkURL?: Maybe<Scalars['String']>;
  /** position is where entry should be located within changelog entries of the same date. */
  position: Scalars['Int'];
  /** publishedAt is the timestamp that the changelog entry was published. */
  publishedAt?: Maybe<Scalars['Time']>;
  /** title is the localized title of the changelog entry. */
  title: Scalars['String'];
};

/** ChanletSort indicates the desired order of chanlets in the list returned by LoadChanletsByUserID. */
export enum ChanletSort {
  /**
   * ChanletSortNone indicates that the order of chanlets returned is insignificant
   * to the client and is allowed to be arbitrary.
   */
  None = 'NONE',
  /** ChanletSortViewerCount indicates chanlets should return sorted by viewer counts, descending. */
  ViewerCount = 'VIEWER_COUNT'
}

export type Channel = {
   __typename?: 'Channel';
  /**
   * A list of content attributes created for the channel, that can be associated
   * with the chanlets, to augment the multi-view experience.
   */
  availableContentAttributes?: Maybe<Array<MultiviewContentAttribute>>;
  /** A list of available Drops that viewers of this channel can claim when certain game events are met. */
  availableDrops?: Maybe<Array<Maybe<DropObject>>>;
  /** A list of all available Drops that a channel is eligible to participate in. */
  availableDropsDashboard?: Maybe<Array<Maybe<DropObject>>>;
  /** A paginated list of users who are banned from this channel. */
  bannedUsers?: Maybe<ChannelBannedUserConnection>;
  /**
   * The language the broadcaster has chosen to stream in.
   * @deprecated Use stream.language instead.
   */
  broadcasterLanguage: Scalars['String'];
  /**
   * The celebration configuration for the channel, which contains if celebrations
   * are enabled and a list of configured celebrations.
   */
  celebrations?: Maybe<CelebrationConfig>;
  /**
   * The stream key for this channel if it is a multi-view chanlet. The requesting
   * user must "own" this chanlet to be authorized to see this.
   */
  chanletStreamKey?: Maybe<Scalars['String']>;
  /** A list of the channel's chanlets (sub-channels) in a multi-view experience. */
  chanlets?: Maybe<Array<Channel>>;
  /** Get a single community points custom reward redemption by its ID. */
  communityPointsCustomRewardRedemption?: Maybe<CommunityPointsCustomRewardRedemption>;
  /** The queue of community points custom reward redemptions in this channel. */
  communityPointsRedemptionQueue?: Maybe<CommunityPointsCustomRewardRedemptionConnection>;
  /** Details about community points in the channel. */
  communityPointsSettings?: Maybe<CommunityPointsChannelSettings>;
  /** For a multi-view chanlet, this is the list of content attributes that have been associated with the given chanlet. */
  contentAttributes?: Maybe<Array<MultiviewContentAttribute>>;
  /** The channel's name, with user-specified formatting. */
  displayName?: Maybe<Scalars['String']>;
  /**
   * The name of the last game played on this channel.
   * @deprecated Use user.lastBroadcast.game.name instead.
   */
  game: Scalars['String'];
  /** The Home of a channel. */
  home?: Maybe<ChannelHome>;
  /** The structure that contains information about the channel's Hype Train execution and config. */
  hypeTrain: HypeTrain;
  /** The channel's unique identfier. */
  id: Scalars['ID'];
  /**
   * Whether or not the channel is a hidden multi-view chanlet that is only meant
   * to be accessible through another channel and not exist as a completely
   * independent channel.
   */
  isHiddenChanlet: Scalars['Boolean'];
  /**
   * Whether the broadcaster has designated the channel's broadcast for mature audiences only.
   * @deprecated Use stream.isMature instead.
   */
  isMature: Scalars['Boolean'];
  /** Whether or not to display the social media panel. */
  isSocialMediaPanelEnabled: Scalars['Boolean'];
  /** leaderboardSet contains the set of leaderboards that are active on this channel. */
  leaderboardSet?: Maybe<LeaderboardSet>;
  /** leaderboardTimePeriod indicates whether the leaderboard type is of WEEKLY, ALL-TIME, etc. */
  leaderboardTimePeriod?: Maybe<LeaderboardTimePeriodType>;
  /** A drop object including benefit information as well as personal settings. */
  metadataDropObject?: Maybe<MetadataDropObject>;
  /** The channel's name. */
  name: Scalars['String'];
  /** The user who owns this channel. */
  owner?: Maybe<User>;
  /** Configurations for chanlets this channel owns. */
  ownerChanletAttributes?: Maybe<OwnerChanletAttributes>;
  /** The restriction that is currently active on the channel for restricting a user's access to it. */
  restriction?: Maybe<ResourceRestriction>;
  /**
   * The stream schedule of the user.
   * Returns null when the user has not set a schedule.
   */
  schedule?: Maybe<Schedule>;
  /** The requesting user's relationship with the channel. */
  self?: Maybe<ChannelSelfEdge>;
  /** The channel's social media links and favicons. */
  socialMedias?: Maybe<Array<SocialMedia>>;
  /**
   * A user-defined status message.
   * @deprecated Use user.lastBroadcast.title instead.
   */
  status: Scalars['String'];
  /**
   * The live broadcast associated with this channel, if currently broadcasting.
   * @deprecated Use user.stream instead.
   */
  stream?: Maybe<Stream>;
  /** A list of streams for a given channel for multi-view. */
  streams?: Maybe<Array<Stream>>;
  /** Channel trailer for this channel. */
  trailer?: Maybe<Trailer>;
  /** The URL to view the channel in a browser. */
  url: Scalars['String'];
  /** Video stream settings for ingesting a stream such as stream key, latency mode, or vod save preference. */
  videoStreamSettings?: Maybe<VideoStreamSettings>;
};


export type ChannelBannedUsersArgs = {
  after?: Maybe<Scalars['Cursor']>;
  first?: Maybe<Scalars['Int']>;
};


export type ChannelChanletsArgs = {
  sort?: Maybe<ChanletSort>;
  bypassDisableFlag?: Maybe<Scalars['Boolean']>;
};


export type ChannelCommunityPointsCustomRewardRedemptionArgs = {
  id: Scalars['ID'];
};


export type ChannelCommunityPointsRedemptionQueueArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  options?: Maybe<CommunityPointsRedemptionQueueOptions>;
};


export type ChannelLeaderboardSetArgs = {
  first?: Maybe<Scalars['Int']>;
};


export type ChannelMetadataDropObjectArgs = {
  dropID: Scalars['ID'];
};

/** Analytics around what other content my viewers watch. */
export type ChannelAnalyticsContentOverlap = {
   __typename?: 'ChannelAnalyticsContentOverlap';
  /** Other channels that my viewers like to watch. */
  channels?: Maybe<Array<ChannelOverlap>>;
  /** Games that my viewers like to watch. */
  games?: Maybe<Array<GameOverlap>>;
};

/** ChannelBannedUser is an object that defines metadata about a channel ban. */
export type ChannelBannedUser = {
   __typename?: 'ChannelBannedUser';
  /** When the ban was created. */
  bannedAt: Scalars['Time'];
  /** Representation of the banned user. */
  bannedUser?: Maybe<User>;
  /** Representation of the mod that banned the user. */
  modUser?: Maybe<User>;
};

/** Paginated list of users banned from a channel. */
export type ChannelBannedUserConnection = {
   __typename?: 'ChannelBannedUserConnection';
  /** The elements of the list. */
  edges?: Maybe<Array<ChannelBannedUserEdge>>;
  /** Information about this page of banned users. */
  pageInfo: PageInfo;
};

/** Element in a list of users banned from a channel. */
export type ChannelBannedUserEdge = {
   __typename?: 'ChannelBannedUserEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** A ban record for a user banned from a channel. */
  node?: Maybe<ChannelBannedUser>;
};

/** ChannelBlockedTerm is an object that defines things that automod should permit in a channel. */
export type ChannelBlockedTerm = {
   __typename?: 'ChannelBlockedTerm';
  /** If the term is permitted or banned type. */
  category: Scalars['String'];
  /** When the term was created. */
  createdAt?: Maybe<Scalars['Time']>;
  /** When the term expires at. */
  expiresAt?: Maybe<Scalars['Time']>;
  /** If mods should be able to see and edit this term. */
  isModEditable: Scalars['Boolean'];
  /** phrases are the string representation of a term. */
  phrases: Array<Scalars['String']>;
  /** Where the term came from, usually a mod user ID. */
  source?: Maybe<Scalars['String']>;
  /** When the term was last updated. */
  updatedAt?: Maybe<Scalars['Time']>;
};

/** The Home of a channel. */
export type ChannelHome = {
   __typename?: 'ChannelHome';
  /** The preferences that power a channel's home page. */
  preferences?: Maybe<ChannelHomePreferences>;
  /** The shelves that are shown on a channel's home page. */
  shelves?: Maybe<ChannelHomeShelves>;
};

/** A list of categories displayed on a channel home's Category Shelf. */
export type ChannelHomeCategoryShelf = {
   __typename?: 'ChannelHomeCategoryShelf';
  /** The list of categories to display in the shelf. */
  edges: Array<ChannelHomeCategoryShelfEdge>;
};

/** The edges of the channel home category shelf. */
export type ChannelHomeCategoryShelfEdge = {
   __typename?: 'ChannelHomeCategoryShelfEdge';
  /** The category to display in the shelf. */
  node?: Maybe<Game>;
};

/** A list of categories displayed on a channel home's Category Shelf. */
export type ChannelHomeCategorySuggestionsShelf = {
   __typename?: 'ChannelHomeCategorySuggestionsShelf';
  /** The list of categories to display in the shelf. */
  edges: Array<ChannelHomeCategorySuggestionsShelfEdge>;
};

/**
 * Contains a category and a boolean to denote whether the user has chosen to hide
 * that category from their channel home page's category shelf.
 */
export type ChannelHomeCategorySuggestionsShelfEdge = {
   __typename?: 'ChannelHomeCategorySuggestionsShelfEdge';
  /** This is true if the user has chosen to hide this category from their category shelf. */
  isHidden: Scalars['Boolean'];
  /** The category. */
  node?: Maybe<Game>;
};

/** The streamer's channel home preferences. */
export type ChannelHomePreferences = {
   __typename?: 'ChannelHomePreferences';
  /** The hero preset. */
  heroPreset: HeroPreset;
  /** The type of streamer shelf to display. */
  streamerShelfType: StreamerShelfType;
};

/** The shelves that are shown on a channel's home page. */
export type ChannelHomeShelves = {
   __typename?: 'ChannelHomeShelves';
  /** A list of categories displayed on a channel home's Category Shelf. */
  categoryShelf?: Maybe<ChannelHomeCategoryShelf>;
  /** A list of suggested categories to display on a channel home's Category Shelf. */
  categoryShelfSuggestions?: Maybe<ChannelHomeCategorySuggestionsShelf>;
  /** The type and, if applicable, the list of users displayed in a channel home's Streamer Shelf. */
  streamerShelf?: Maybe<ChannelHomeStreamerShelf>;
};


/** The shelves that are shown on a channel's home page. */
export type ChannelHomeShelvesCategoryShelfArgs = {
  first?: Maybe<Scalars['Int']>;
};


/** The shelves that are shown on a channel's home page. */
export type ChannelHomeShelvesCategoryShelfSuggestionsArgs = {
  first?: Maybe<Scalars['Int']>;
};


/** The shelves that are shown on a channel's home page. */
export type ChannelHomeShelvesStreamerShelfArgs = {
  first?: Maybe<Scalars['Int']>;
};

/** The list of users displayed in a channel home's Streamer Shelf. */
export type ChannelHomeStreamerShelf = {
   __typename?: 'ChannelHomeStreamerShelf';
  /** The list of users to display in the shelf. */
  edges: Array<ChannelHomeStreamerShelfEdge>;
  /** The type of streamer shelf to display (Autohost, Team, or Disabled). */
  type: StreamerShelfType;
};

/** The edges of the channel home streamer shelf. */
export type ChannelHomeStreamerShelfEdge = {
   __typename?: 'ChannelHomeStreamerShelfEdge';
  /** The user to display in the shelf. */
  node?: Maybe<User>;
};

export type ChannelNotificationSetting = {
   __typename?: 'ChannelNotificationSetting';
  /** The setting category. */
  category: Scalars['String'];
  /** Whether this setting is on or off for the given event. */
  isEnabled: Scalars['Boolean'];
  /** The exact state of the setting. ("on", "off", "friends_only", etc). */
  settingState: Scalars['String'];
};

/** Data about notification settings for a follow relationship. */
export type ChannelNotificationSettings = {
   __typename?: 'ChannelNotificationSettings';
  /**
   * If true, enabled notifications will be send. If false, all notifications are
   * disabled, even if their individual setting is enabled.
   */
  isEnabled: Scalars['Boolean'];
  /** A list of channel notification settings. */
  nodes: Array<ChannelNotificationSetting>;
};

/** Channel that my viewers also like to watch. */
export type ChannelOverlap = {
   __typename?: 'ChannelOverlap';
  /** Channel that my viewers also like to watch. */
  channel: User;
  /** How much my viewers like to watch this channel. */
  score: Scalars['Float'];
};

/** An enumeration of permissions a user can have on a channel. */
export enum ChannelPermission {
  /** Permission to manage Chanlets, which represent sub-streams in a multiview mode. */
  MultiviewAdmin = 'MULTIVIEW_ADMIN',
  /** Permission to create restrictions on the channel. */
  SetChannelRestriction = 'SET_CHANNEL_RESTRICTION'
}

/** ChannelPermittedTerm is an object that defines things that automod should permit in a channel. */
export type ChannelPermittedTerm = {
   __typename?: 'ChannelPermittedTerm';
  /** If the term is permitted or banned type. */
  category: Scalars['String'];
  /** When the term was created. */
  createdAt?: Maybe<Scalars['Time']>;
  /** When the term expires at. */
  expiresAt?: Maybe<Scalars['Time']>;
  /** If mods should be able to see and edit this term. */
  isModEditable: Scalars['Boolean'];
  /** phrases are the string representation of a term. */
  phrases: Array<Scalars['String']>;
  /** Where the term came from, usually a mod user ID. */
  source?: Maybe<Scalars['String']>;
  /** When the term was last updated. */
  updatedAt?: Maybe<Scalars['Time']>;
};

/** A restriction for a specific channel. */
export type ChannelRestriction = {
   __typename?: 'ChannelRestriction';
  /** The time that the restriction is no longer active. */
  endsAt?: Maybe<Scalars['Time']>;
  /**
   * Information about being exempt from the restriction.
   * @deprecated Use resourceRestriction.exemptions instead.
   */
  exemptionInfo: ChannelRestrictionExemptionInfo;
  /** The ID of the channel restriction. */
  id: Scalars['ID'];
  /** The time that the restriction becomes active. */
  startsAt?: Maybe<Scalars['Time']>;
  /** The type of restriction on this channel. */
  type: ChannelRestrictionType;
};

/** Exemption information for a specific channel restriction. */
export type ChannelRestrictionExemptionInfo = {
   __typename?: 'ChannelRestrictionExemptionInfo';
  /**
   * The type of exemption.
   * @deprecated Use channelRestriction.type instead.
   */
  exemptionType: Scalars['String'];
};

/** An enumeration of the different restriction types. */
export enum ChannelRestrictionType {
  /** The resource is restricted for an unknown reason. */
  Unknown = 'UNKNOWN',
  /** The channel is restricted by a subscription. */
  SubOnlyLive = 'SUB_ONLY_LIVE',
  /** The channel is restricted by the All-Access Pass. */
  AllAccessPass = 'ALL_ACCESS_PASS'
}

/** Information about the requesting user with respect to a channel. */
export type ChannelSelfEdge = {
   __typename?: 'ChannelSelfEdge';
  /**
   * Properties relating to the authenticated user's community points in a channel.
   * Null if community points are not enabled in the channel.
   */
  communityPoints?: Maybe<CommunityPointsProperties>;
  /** Whether or not the requesting user is authorized to view the channel's content in a channel restrictions context. */
  isAuthorized: Scalars['Boolean'];
  /** Whether or not the resource is restricted for the requesting user. */
  isResourceRestricted: Scalars['Boolean'];
  /** List of channel feature permissions the logged in user has on the channel. */
  permissions: Array<ChannelPermission>;
  /** Channel's layout of quick actions on stream manager page. */
  quickActionLayout?: Maybe<QuickActionLayout>;
  /** Channel's store of quick actions on stream manager page. */
  quickActionStore?: Maybe<QuickActionStore>;
  /** If restricted, how the resource is restricted. */
  restrictionType?: Maybe<ResourceRestrictionType>;
};

/** The possible user roles within a channel. */
export enum ChannelUserRole {
  /** The channel owner. */
  Broadcaster = 'BROADCASTER',
  /** An editor for the channel. */
  Editor = 'EDITOR',
  /** A moderator for the channel. */
  Moderator = 'MODERATOR',
  /** A subscriber of the channel. */
  Subscriber = 'SUBSCRIBER',
  /** A user with no roles. */
  Regular = 'REGULAR'
}

/** Information about the intended device for making a refill purchase for a user. */
export type ChargeInstrument = {
   __typename?: 'ChargeInstrument';
  /** A charge instrument Id. */
  id: Scalars['ID'];
};

/** Input charge instrument information. */
export type ChargeInstrumentInput = {
  /** A charge instrument Id. */
  id: Scalars['ID'];
};

/**
 * ChargeModel describes the model used for charging the user. Will only contain
 * one credit model, one external model, or one internal model.
 */
export type ChargeModel = {
   __typename?: 'ChargeModel';
  /** A charge model in which a user is charged using credits purchased or earned on Twitch. */
  credit?: Maybe<CreditChargeModel>;
  /** A charge model in which a user is charged via a third-party in a fiat currency. */
  external?: Maybe<ExternalChargeModel>;
  /** A charge model in which a user is charged by Twitch in a fiat currency. */
  internal?: Maybe<InternalChargeModel>;
};

/** ChargeModelPlan defines the payment plan of the charge model. */
export type ChargeModelPlan = {
   __typename?: 'ChargeModelPlan';
  /** The time interval for the charge model. */
  interval: ChargeModelPlanInterval;
  /** The renewal policy for the charge model. */
  renewalPolicy: RenewalPolicy;
};

/** ChargeModelPlanInterval is the time interval for the charge model. */
export type ChargeModelPlanInterval = {
   __typename?: 'ChargeModelPlanInterval';
  /** The duration of the charge model interval (used with the unit). */
  duration: Scalars['Int'];
  /** The unit of the charge model interval. */
  unit: ChargeModelPlanIntervalUnit;
};

/** ChargeModelPlanIntervalUnit defines the unit of the charge model interval. */
export enum ChargeModelPlanIntervalUnit {
  /** Interval unit of Days. */
  Days = 'DAYS',
  /** Interval unit of Months. */
  Months = 'MONTHS',
  /** Unknown interval unit. */
  Unknown = 'UNKNOWN'
}

/** Cheer is a chat message that uses bits to include cheermotes. */
export type ChatMessage = {
   __typename?: 'ChatMessage';
  /** author is the `User` who sent this message. */
  author?: Maybe<User>;
  /** authorColor is the sender's preferred display name color at the time the message was sent. */
  authorColor: Scalars['String'];
  /** authorName is the historical value of `author.displayName` at the time the message was sent. */
  authorName: Scalars['String'];
  /** badges is the list of `Badge` to display on this message. */
  badges: Array<Maybe<Badge>>;
  /** bitsUsed is the number of bits used in this message. */
  bitsUsed: Scalars['Int'];
  /** body is the message content and embedded emote info. */
  body?: Maybe<MessageBody>;
  /** createdAt is the time this message was sent. */
  createdAt?: Maybe<Scalars['Time']>;
  /** id is the unique message identifier. */
  id: Scalars['ID'];
};

/** ChatPauseSetting represents the possible settings for the user's preferred way to pause chat when moderating. */
export enum ChatPauseSetting {
  /** SCROLL_ONLY is the default behavior and pauses chat every time the users scrolls over the chat list. */
  ScrollOnly = 'SCROLL_ONLY',
  /**
   * MOUSEOVER pauses chat whenever a user's mouse hovers over the list, unpauses
   * automatically after 5 seconds if no scroll is performed.
   */
  Mouseover = 'MOUSEOVER',
  /** ALTKEY pauses chat when the user presses the alt key (option for mac users). It unpauses when the key is released. */
  Altkey = 'ALTKEY',
  /** MOUSEOVER_ALTKEY pauses chat on mouse hover and hitting the alt key. */
  MouseoverAltkey = 'MOUSEOVER_ALTKEY'
}

/** Reasons that a user might not be allowed to chat in a specific channel. */
export enum ChatRestrictedReason {
  /**
   * The user is prevented from chatting by subscribers-only mode. They should
   * subscribe to the channel to chat.
   */
  SubscribersOnly = 'SUBSCRIBERS_ONLY',
  /**
   * The user is prevented from chatting by followers-only mode. They should
   * either follow the channel, or wait longer to satisfy the required time.
   * See user.self.follower.followedAt for when the user followed, and
   * user.self.chatSettings.followersOnlyDurationMinutes for the minimum
   * required follow time.
   */
  FollowersOnly = 'FOLLOWERS_ONLY',
  /**
   * The user is prevented from chatting by verified-only mode. They should
   * verify their account to chat.
   */
  VerifiedOnly = 'VERIFIED_ONLY',
  /**
   * The user can't chat because they've chatted too recently. See
   * user.self.lastRecentChatMessageAt to calculate how much time is remaining
   * before they can chat again.
   */
  SlowMode = 'SLOW_MODE'
}

export type ChatRoomBanStatus = {
   __typename?: 'ChatRoomBanStatus';
  /** The user being banned of this chat. */
  bannedUser?: Maybe<User>;
  /** The time the ban was imposed. */
  createdAt: Scalars['Time'];
  /** The time at which the ban will automatically expire. */
  expiresAt?: Maybe<Scalars['Time']>;
  /** Conveys if the ban is permanent. */
  isPermanent: Scalars['Boolean'];
  /** The moderator that carried out the action. */
  moderator?: Maybe<User>;
  /** The entity representing the users channel or chat room. */
  roomOwner?: Maybe<User>;
};

/** ChatSettings are settings and rules for chatting in a channel. */
export type ChatSettings = {
   __typename?: 'ChatSettings';
  /**
   * autoModLevel is an integer from 0-4 representing the level of automoderation of chat
   * 0 is off, 4 is the highest level of moderation.
   * @deprecated No longer used.
   */
  autoModLevel: Scalars['Int'];
  /** blockLinks indicates if links should be deleted from non-mod messages. */
  blockLinks: Scalars['Boolean'];
  /** chatDelayMs is the delay before non-mods see a message. */
  chatDelayMs: Scalars['Int'];
  /**
   * The number of minutes a user must be following the broadcaster in order to chat
   * If value is null, followers only mode is not enabled.
   */
  followersOnlyDurationMinutes?: Maybe<Scalars['Int']>;
  /**
   * isBroadcasterLanguageModeEnabled indicates if the broadcaster requires chat messages to
   * match their language.
   * @deprecated No longer used.
   */
  isBroadcasterLanguageModeEnabled: Scalars['Boolean'];
  /** Indicates whether chat is currently enforcing that messages may only contain emotes. */
  isEmoteOnlyModeEnabled: Scalars['Boolean'];
  /** Indicates whether subscribers are allowed to bypass slowmode. */
  isFastSubsModeEnabled: Scalars['Boolean'];
  /**
   * If isOptedOutOfGlobalBannedWordsList is true, the legacy twitch banned words list will
   * be inserted into automod if the channel has automod enabled.
   * @deprecated No longer used.
   */
  isOptedOutOfGlobalBannedWordsList: Scalars['Boolean'];
  /** Indicates whether chat is currently restricted to subscribers only. */
  isSubscribersOnlyModeEnabled: Scalars['Boolean'];
  /**
   * Indicates whether chat is currently enforcing that messages must be reasonably unique
   * from recent messages. Previously known as "r9k mode".
   */
  isUniqueChatModeEnabled: Scalars['Boolean'];
  /** requireVerifiedAccount indicates if users must be verified to chat. */
  requireVerifiedAccount: Scalars['Boolean'];
  /** rules is a list of rules to display to users when joining a chat channel. */
  rules: Array<Scalars['String']>;
  /**
   * The number of seconds a user must wait in between sending chat messages
   * If value is null, slow mode is not enabled.
   */
  slowModeDurationSeconds?: Maybe<Scalars['Int']>;
};

/**
 * ChatTheme is a client-side UI theme.
 * It can be used to provide different images based on the dominant background color they are designed to display on.
 */
export enum ChatTheme {
  Dark = 'DARK',
  Light = 'LIGHT'
}

/** Various user specific settings on how to render chat. */
export type ChatUiSettings = {
   __typename?: 'ChatUISettings';
  /** Setting to store the user's preferred way to pause chat when moderating. */
  chatPauseSetting?: Maybe<ChatPauseSetting>;
  /** Setting for how deleted messages should be displayed for channel broadcaster or moderator. */
  deletedMessageDisplaySetting?: Maybe<DeletedMessageDisplaySetting>;
  /** Whether readable chat colors are enabled. */
  isReadableChatColorsEnabled?: Maybe<Scalars['Boolean']>;
};

/** Input to the checkGemNotification mutation. */
export type CheckGemNotificationInput = {
  /** The id of the gem notification to be marked as checked. */
  notificationID: Scalars['ID'];
};

/** Payload from the checkGemNotification mutation. */
export type CheckGemNotificationPayload = {
   __typename?: 'CheckGemNotificationPayload';
  /** The gem notification that was successfully checked. */
  updatedNotification?: Maybe<BitsGemNotification>;
};

/** Actions required when initiating a checkout flow. */
export enum CheckoutAction {
  /** Action to block saved payment methods. */
  BlockSavedPaymentMethod = 'BLOCK_SAVED_PAYMENT_METHOD',
  /** Action to show velocity limit CTA. */
  ExceededVelocityLimits = 'EXCEEDED_VELOCITY_LIMITS',
  /** Action to show the user enabled 2FA before saving their payment method. */
  VerifiedSavedPaymentMethod = 'VERIFIED_SAVED_PAYMENT_METHOD',
  /** Action to disable new credit cards from being added on purchases. */
  DisableNewCreditCard = 'DISABLE_NEW_CREDIT_CARD',
  /** Action to indicate this user is authorized to make purchases. */
  AuthorizedUser = 'AUTHORIZED_USER'
}

/** Configs that help initiate the bits checkout flow. */
export type CheckoutConfiguration = {
   __typename?: 'CheckoutConfiguration';
  /** Contains configuration (e.g. iFrameURL) to enable completing purchases via Xsolla, a payment provider. */
  xsolla?: Maybe<Xsolla>;
};


/** Configs that help initiate the bits checkout flow. */
export type CheckoutConfigurationXsollaArgs = {
  productType?: Maybe<PurchaseableProductType>;
  productID?: Maybe<Scalars['ID']>;
  offerTagBindings?: Maybe<Array<OfferTagBindingInput>>;
  quantity?: Maybe<Scalars['Int']>;
  giftRecipientIDs?: Maybe<Array<Scalars['ID']>>;
  tenantTracking?: Maybe<Scalars['String']>;
  paymentSession?: Maybe<PaymentSession>;
};

/** Inputs for checkoutConfiguration. */
export type CheckoutConfigurationInput = {
  /** Whether the gift is anonymous. */
  isAnonymous?: Maybe<Scalars['Boolean']>;
  /** Whether the purchase is a gift. */
  isGift: Scalars['Boolean'];
  /** Whether the user is reactivating their subscription with a recurring or non-recurring payment plan. */
  isReactivateRecurring?: Maybe<Scalars['Boolean']>;
  /** The number of gifts being purchased. */
  mysteryGiftCount?: Maybe<Scalars['Int']>;
  /** Payment's session tracking. */
  paymentSession?: Maybe<PaymentSession>;
  /** The ID of the gift recipient. */
  recipientID?: Maybe<Scalars['ID']>;
  /** The country code for tax purposes. */
  taxCountryCode?: Maybe<Scalars['String']>;
};

/** Price information about an item in the checkout process. */
export type CheckoutPriceSummary = {
   __typename?: 'CheckoutPriceSummary';
  /** The currency associated with the price of a subscription product. */
  currency: Currency;
  /** The description associated with pricing information. */
  description: Scalars['String'];
  /** The discounted total with breakdown by discounted price and tax. */
  discount?: Maybe<DiscountBreakdown>;
  /** The ISO-4217 wording of deriving price. */
  exponent: Scalars['Int'];
  /** Identifier used for caching. */
  id: Scalars['ID'];
  /** If the tax is already included in price. */
  isTaxInclusive: Scalars['Boolean'];
  /** The numerical price of a subscription product. */
  price: Scalars['Int'];
  /** Pricing identifier of the item being purchased. */
  pricingIdentifier: Scalars['String'];
  /** The tax rate of localized product. */
  tax: Scalars['Int'];
  /** The total price given price and tax. */
  total: Scalars['Int'];
};

/** CheerInfo is the channel-specific bits/cheer settings and current state. */
export type CheerInfo = {
   __typename?: 'CheerInfo';
  /** Gets the list of available bits badges the user offers. */
  availableBadges?: Maybe<Array<Badge>>;
  /**
   * Badge tier emotes are the emotes in this channel that are unlocked when a user unlocks a Bits badge tier.
   * Filter determines which emotes are returned.
   */
  badgeTierEmotes: Array<Maybe<Emote>>;
  /** cheerGroups contain all of the channel-specific Cheermotes, grouped by type. */
  cheerGroups: Array<CheermoteGroup>;
  /**
   * emotes are the metadata about the different cheermotes that can be use to cheer in this channel.
   * This can optionally be filtered to return only certain cheermotes by either prefix and/or emote types.
   * If `prefixes` is null or empty all available cheermotes will be returned, and then `type` filter
   * will be applied to the result unless it's null or empty.
   * If includeUpperTiers is true, the upper tiers of the cheermotes will be returned.
   * @deprecated Scheduled to be removed. Use cheerGroups instead
   */
  emotes: Array<Maybe<Cheermote>>;
  /**
   * hashtags for augmenting cheering with different actions, such as #charity will donate bits to
   * charity, or like #eddie to cheer and support Eddie.
   */
  hashtags?: Maybe<BitsHashtagConnection>;
  id: Scalars['ID'];
  /** leaderboard contains the top users by number of bits cheered for the channel. */
  leaderboard?: Maybe<BitsLeaderboard>;
  /**
   * recent is the currently pinned recent cheer.
   * This feature is deprecated and will always return null.
   * @deprecated Recent cheer is a removed feature, this functionality shouldn't be used anymore.
   */
  recent?: Maybe<ChatMessage>;
  /**
   * recentTimeoutMs is the remaining duration the recent message will be pinned for.
   * This feature is deprecated and will always return 0.
   * @deprecated Recent cheer is a a removed feature, this functionality shouldn't be used anymore.
   */
  recentTimeoutMs: Scalars['Int'];
  /** settings are the channel-specific cheer settings. */
  settings: CheerSettings;
  /**
   * top is the currently pinned top cheer.
   * This feature is deprecated and will always returns null.
   * @deprecated Use CheerInfo.leaderboard for current top cheer implementation (contains top 10, instead of single).
   */
  top?: Maybe<ChatMessage>;
};


/** CheerInfo is the channel-specific bits/cheer settings and current state. */
export type CheerInfoBadgeTierEmotesArgs = {
  filter: BadgeTierEmotesFilter;
};


/** CheerInfo is the channel-specific bits/cheer settings and current state. */
export type CheerInfoEmotesArgs = {
  prefixes?: Maybe<Array<Scalars['String']>>;
  type?: Maybe<Array<CheermoteType>>;
  includeUpperTiers?: Maybe<Scalars['Boolean']>;
  includeSponsored?: Maybe<Scalars['Boolean']>;
};


/** CheerInfo is the channel-specific bits/cheer settings and current state. */
export type CheerInfoHashtagsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['String']>;
};


/** CheerInfo is the channel-specific bits/cheer settings and current state. */
export type CheerInfoLeaderboardArgs = {
  first: Scalars['Int'];
};

/** Cheermote is the metadata about different variations of a single cheermote that can be use to cheer in this channel. */
export type Cheermote = {
   __typename?: 'Cheermote';
  /**
   * A nullable campaign associated with the cheermote. This would only be attached to
   * cheermotes that are of the CheermoteType.SPONSORED.
   */
  campaign?: Maybe<CheermoteCampaign>;
  /** The ID of the cheermote. */
  id: Scalars['ID'];
  /**
   * prefix for this cheering action (Kappa, cheer, Kreygasm, etc).
   * Any case-insensitive match of this prefix directly followed by a number
   * (Kappa100, kappa100, kApPa100, etc) is to be considered a cheering message.
   */
  prefix: Scalars['String'];
  /** tiers are bits breakpoints for different images for this cheermote. */
  tiers: Array<CheermoteTier>;
  /** type is the kind of cheermote (custom vs 1st- or 3rd-party global). */
  type: CheermoteType;
};

/**
 * A campaign that is in association with a cheermote. Like, Old Spice could have a cheermote with
 * Terry Crew's head that they will sponsor X Bits that get added on to cheers that use their cheermote.
 */
export type CheermoteCampaign = {
   __typename?: 'CheermoteCampaign';
  /** The percentage of remaining bits that can be added to cheers. */
  bitsPercentageRemaining: Scalars['Float'];
  /** An optional field that shows the user how many bits are being used to sponsor the campaign. */
  bitsTotal?: Maybe<Scalars['Int']>;
  /** An optional field that shows the user how many bits have been used out of the sponsored pool. */
  bitsUsed?: Maybe<Scalars['Int']>;
  /** Image url for the brand image. */
  brandImageURL: Scalars['String'];
  /** The name of the brand, used in strings. */
  brandName: Scalars['String'];
  /** The cheermote campaign ID. This is unique. */
  id: Scalars['ID'];
  /** The minimum bits amount to make a cheer add bits from the sponsored campaign. */
  minimumBitsAmount: Scalars['Int'];
  /** The nullable edge that relates the user to the campaign. */
  self?: Maybe<CheermoteCampaignSelfEdge>;
  /** Thresholds for matching on sponsored cheering. */
  thresholds: Array<CheermoteCampaignThreshold>;
  /** Amount of bits that an individual user can contribute. */
  userLimit: Scalars['Int'];
};

/** Edge that relates a cheermote campaign to the logged in user. */
export type CheermoteCampaignSelfEdge = {
   __typename?: 'CheermoteCampaignSelfEdge';
  /** The total bits used by the user in the campaign. */
  bitsUsed: Scalars['Int'];
  /** Eligibility for the user to cheer with the sponsored bits in the campaign. */
  canBeSponsored: Scalars['Boolean'];
  /** The ID is comprised of the campaign ID and the user ID. */
  id: Scalars['ID'];
};

/** Threshold for sponsored cheermote campaign matching. */
export type CheermoteCampaignThreshold = {
   __typename?: 'CheermoteCampaignThreshold';
  /** Id for threshold, generated using the campaign id and the minimum bits field. */
  id: Scalars['ID'];
  /** Percentage for matching. */
  matchedPercent: Scalars['Float'];
  /** Minimum number of bits to get this level of matching. */
  minimumBits: Scalars['Int'];
};

/** The color that should be used to display each cheer amount. */
export type CheermoteColorConfig = {
   __typename?: 'CheermoteColorConfig';
  /**
   * bits is the minimum number of bits that are required to render this tier.
   * To render at this tier the cheemote must have used >= this minimum but < the next smallest tier.
   */
  bits: Scalars['Int'];
  /** color is the hex color used to render the number of bits for this tier. */
  color: Scalars['String'];
};

/**
 * The CheermoteDisplayConfig provides information about how Cheermotes can be displayed
 * This includes things like the possible sizes, colors, backgrounds, and display order.
 */
export type CheermoteDisplayConfig = {
   __typename?: 'CheermoteDisplayConfig';
  /**
   * A list of the backgrounds that a Cheermote can be rendered at. For example, ["light", "dark"]
   * Although this is probably more accurately represented as an emum, these strings are going to have to be used
   * when creating the full URL for a Cheermote from the template URL. Rather than forcing each client to create the
   * same enum -> string mapping, we will just pass these directly as strings.
   */
  backgrounds: Array<Scalars['String']>;
  /** A list of the colors that should be used to display text for each Cheer amount. */
  colors: Array<CheermoteColorConfig>;
  /** A list of the order in which CheermoteTypes should be displayed. */
  order: Array<CheermoteType>;
  /**
   * A list of the scales that a Cheermote can be rendered at. For example,  ["1", "1.5", "2", "3", "4"]
   * Although this is probably more accurately represented as an emum, these strings are going to have to be used
   * when creating the full URL for a Cheermote from the template URL. Rather than forcing each client to create the
   * same enum -> string mapping, we will just pass these directly as strings.
   */
  scales: Array<Scalars['String']>;
  /** A list of the display types available for Cheermotes. */
  types: Array<CheermoteDisplayType>;
};

/** Information about the methods to display a Cheermote. */
export type CheermoteDisplayType = {
   __typename?: 'CheermoteDisplayType';
  /**
   * The animation style. For example, "static" or "animated"
   * Although this is probably more accurately represented as an emum, these strings are going to have to be used
   * when creating the full URL for a Cheermote from the template URL. Rather than forcing each client to create the
   * same enum -> string mapping, we will just pass these directly as strings.
   */
  animation: Scalars['String'];
  /**
   * The extension for this animation style. For example, "png" or "gif"
   * Although this is probably more accurately represented as an emum, these strings are going to have to be used
   * when creating the full URL for a Cheermote from the template URL. Rather than forcing each client to create the
   * same enum -> string mapping, we will just pass these directly as strings.
   */
  extension: Scalars['String'];
};

/** Contains a group of related Cheermotes that share the same CDN template. */
export type CheermoteGroup = {
   __typename?: 'CheermoteGroup';
  /** The Cheermotes which belong to this group. */
  nodes: Array<Cheermote>;
  /**
   * The template URL that clients can use to construct the image URL for each cheermote tier.
   * The displayConfig field on Query provides values you'll need to fill in this template,
   * so don't forget to request that as well.
   */
  templateURL: Scalars['String'];
};

/** CheermoteImage is a single image variation of a `CheermoteTier`. */
export type CheermoteImage = {
   __typename?: 'CheermoteImage';
  /**
   * dpiScale is the scale of the cheermote image.
   * Currently available scales are: 1, 1.5, 2, 3, or 4.
   * @deprecated Scheduled to be removed.
   */
  dpiScale: Scalars['Float'];
  /**
   * The ID of CheermoteImage.
   * @deprecated Scheduled to be removed.
   */
  id: Scalars['ID'];
  /**
   * isAnimated is true for animated cheermotes and false otherwise.
   * @deprecated Scheduled to be removed.
   */
  isAnimated: Scalars['Boolean'];
  /**
   * theme is the UI theme the cheermote is designed to be rendered on.
   * @deprecated Scheduled to be removed.
   */
  theme: ChatTheme;
  /**
   * url is the URL of the image asset.
   * @deprecated Scheduled to be removed.
   */
  url: Scalars['String'];
};

/** CheermoteTier has information about a single tier of a cheermote. */
export type CheermoteTier = {
   __typename?: 'CheermoteTier';
  /**
   * bits is the minimum number of bits that are required to render this tier.
   * To render at this tier the cheemote must have used >= this minimum but < the next smallest tier.
   */
  bits: Scalars['Int'];
  /**
   * Can this cheer tier be used as a cheermote.
   * @deprecated Scheduled to be removed.
   */
  canCheer: Scalars['Boolean'];
  /** Can this cheer tier be shown in the Bits card. */
  canShowInBitsCard: Scalars['Boolean'];
  /**
   * color is the hex color used to render the number of bits for this tier.
   * @deprecated Scheduled to be removed.
   */
  color: Scalars['String'];
  /** The ID of CheermoteTier. */
  id: Scalars['ID'];
  /**
   * images are urls for the cheermote that match various settings.
   * This can optionally be filtered to only certain variations or called without arguments to return all available images.
   * @deprecated Scheduled to be removed.
   */
  images: Array<Maybe<CheermoteImage>>;
  /**
   * tierID of this specific cheermote icon. For "Kappa100" this will be "100".
   * @deprecated Scheduled to be removed.
   */
  tierID: Scalars['ID'];
};


/** CheermoteTier has information about a single tier of a cheermote. */
export type CheermoteTierImagesArgs = {
  theme?: Maybe<ChatTheme>;
  isAnimated?: Maybe<Scalars['Boolean']>;
  dpiScale?: Maybe<Scalars['Float']>;
};

/** CheermoteToken is used to render a cheermote in a message. */
export type CheermoteToken = {
   __typename?: 'CheermoteToken';
  /** The number of bits in the cheermote. */
  bitsAmount: Scalars['Int'];
  /** The prefix of the cheermote (e.g. cheer in cheer100). */
  prefix: Scalars['String'];
  /**
   * The tier of the cheer used to determine which image to show for the cheermote.
   * In cheer150, this would be 100.
   */
  tier: Scalars['Int'];
};

/** CheermoteType is the kind of cheermore (custom vs 1st- or 3rd-party global). */
export enum CheermoteType {
  /** The type for the generic "Cheer" action. */
  Default = 'DEFAULT',
  /** Custom Channel Cheermotes. */
  Custom = 'CUSTOM',
  /** Sponsored Cheermotes. */
  Sponsored = 'SPONSORED',
  /** Charity Cheermotes. */
  Charity = 'CHARITY',
  /** First Party Cheermotes, like Kappa and BibleThump. */
  FirstParty = 'FIRST_PARTY',
  /** Third Party Cheermotes, like Muxy and BitBoss. */
  ThirdParty = 'THIRD_PARTY',
  /** Cheermotes for display only. The cannot be cheered, but will be rendered in Chat. */
  DisplayOnly = 'DISPLAY_ONLY',
  /** The type for the anonymous cheer action. */
  Anonymous = 'ANONYMOUS',
  /**
   * Unknown cheermote type, we only return this if we get a bad cheermote,
   * we decided this is better than erroring the whole response, the front end should treat this the same as DISPLAY_ONLY.
   */
  Unknown = 'UNKNOWN'
}

/** Bits partner settings associated with the badges. */
export type CheerPartnerBadgeSettings = {
   __typename?: 'CheerPartnerBadgeSettings';
  /** Whether or not the broadcaster is enabled to upload bits badge tier emote rewards. */
  canUploadBadgeTierEmoticons?: Maybe<Scalars['Boolean']>;
  /** A list of tiers, starting from 1 bit to as high as 5,000,000 bits. */
  tiers: Array<BitsBadgeTier>;
};

/** Bits partner settings associated with the chat message. */
export type CheerPartnerChatMessageSettings = {
   __typename?: 'CheerPartnerChatMessageSettings';
  /** The setting that controls if the user has project v enabled on their channel. */
  isOptedOutOfProjectV: Scalars['Boolean'];
  /** The minimum setting that controls the minimum bits that must be part of a cheer emote. */
  minBitsPerEmote: Scalars['Int'];
  /** The minimum setting that controls the minimum amount a user must cheer in the channel. */
  minBitsToCheer: Scalars['Int'];
};

/** Bits partner dashboard settings for the bits cheer bomb events. */
export type CheerPartnerCheerBombSettings = {
   __typename?: 'CheerPartnerCheerBombSettings';
  /** Flag that is true if the user has opted out of seasonal cheer bomb events. */
  isOptedOut: Scalars['Boolean'];
};

/** Bits partner settings for custom cheermote prefix. */
export type CheerPartnerCustomPrefixSettings = {
   __typename?: 'CheerPartnerCustomPrefixSettings';
  /** Flag that is set if the user has the custom cheermote prefix enabled. */
  isEnabled: Scalars['Boolean'];
  /** The prefix string that is used in their channel for their custom cheermote. */
  prefix: Scalars['String'];
  /** The custom prefix images that have been uploaded by the user. */
  tiers?: Maybe<Array<CheermoteTier>>;
};

/** Bits partner dashboard settings for the bits leaderboard. */
export type CheerPartnerLeaderboardSettings = {
   __typename?: 'CheerPartnerLeaderboardSettings';
  /** Flag that is true if the user has bits leaderboards turned on. */
  isEnabled: Scalars['Boolean'];
  /** The time period the user wants the leaderboard to be displayed as. */
  timePeriod: LeaderboardTimePeriodType;
};

/** Bits partner settings associated with recent cheers. */
export type CheerPartnerRecentCheerSettings = {
   __typename?: 'CheerPartnerRecentCheerSettings';
  /** Flag that when true pins the recent cheer to their channel. */
  canPin: Scalars['Boolean'];
  /** The minimum bits a user must cheer to show their cheer on the chat header. */
  minimumBits: Scalars['Int'];
  /** The amount of time a recent cheer is shown before being dismissed. */
  timeoutMilliseconds: Scalars['Int'];
};

/** Cheer settings, configured in their partner dashboard. */
export type CheerPartnerSettings = {
   __typename?: 'CheerPartnerSettings';
  /** Partner settings related to bit badges. */
  badges?: Maybe<CheerPartnerBadgeSettings>;
  /** Partner settings related to chat messages with bits. */
  chatMessage: CheerPartnerChatMessageSettings;
  /** Partner settings related to seasonal cheer bomb events. */
  cheerBomb: CheerPartnerCheerBombSettings;
  /** Partner settings related to the custom cheermote prefix. */
  customPrefix: CheerPartnerCustomPrefixSettings;
  /**
   * Flag that is set when a user has filled out the bits legal ammendement.
   * This can be true and isOnboarding false for legacy partners who onboarded before bits.
   */
  hasSignedBitsAmendment: Scalars['Boolean'];
  /** An ID used for caching purposes for Apollo. */
  id: Scalars['ID'];
  /** Flag that is set when a user has been onboarded for bits usage. */
  isOnboarded: Scalars['Boolean'];
  /**
   * Partner settings related to the bits leaderboard.
   * @deprecated Use leaderboard settings in user settings instead.
   */
  leaderboard: CheerPartnerLeaderboardSettings;
  /** Partner settings related to the recent cheer message. */
  recentCheer: CheerPartnerRecentCheerSettings;
  /** Partner settings related to sponsored cheermotes. */
  sponsoredCheermotes: CheerPartnerSponsoredCheermoteSettings;
};

/** Partner settings related to sponsored cheermotes. */
export type CheerPartnerSponsoredCheermoteSettings = {
   __typename?: 'CheerPartnerSponsoredCheermoteSettings';
  /** The sponsored cheermote channel settings that are associated with the user. */
  campaigns?: Maybe<SponsoredCheermoteChannelSettingsConnection>;
};

/** CheerSettings are the channel-specific cheer settings. */
export type CheerSettings = {
   __typename?: 'CheerSettings';
  /** cheerMinimumBits is the minimum number of bits per message (sum of all cheermotes) required to cheer in this channel. */
  cheerMinimumBits: Scalars['Int'];
  /** emoteMinimumBits is the smallest number of bits that can be spent on an individual cheermote in this channel. */
  emoteMinimumBits: Scalars['Int'];
  /**
   * event is the name of a special cheering event this channel is currently participating in.
   * If there is no current event this will return null.
   */
  event?: Maybe<Scalars['String']>;
  id: Scalars['ID'];
  /** Indicates if the bits football cheerbomb event is enabled on the channel. */
  isCheerBombEventEnabled: Scalars['Boolean'];
  /**
   * Indicates if polls is enabled.
   * @deprecated Unsupported field. Check partner or affiliate status instead of using this field
   */
  isPollsEnabled: Scalars['Boolean'];
  /**
   * isRecentEnabled indicates if recent cheers are pinned in this channel.
   * This can be used by a client to update `CheerInfo.recent` as new cheers are received.
   */
  isRecentEnabled: Scalars['Boolean'];
  /**
   * isTopEnabled indicates if top cheers are pinned in this channel.
   * This can be used by a client to update `CheerInfo.top` as new cheers are received.
   */
  isTopEnabled: Scalars['Boolean'];
  /**
   * leaderboard contains all of the Bits settings related to Bits Leaderboards for this channel.
   * @deprecated Use leaderboard settings in user settings instead.
   */
  leaderboard?: Maybe<BitsLeaderboardSettings>;
  /** recentMinimumBits is the number of bits required for a cheer to be pinned. */
  recentMinimumBits: Scalars['Int'];
  /** recentTimeoutMs is the amount of time a pinned recent message should be displayed for. */
  recentTimeoutMs: Scalars['Int'];
};

/** An interface to represent a claimable thing. */
export type Claimable = {
  /** A description of what the claimable is. */
  description: Scalars['String'];
  /** The ID of the claimable. */
  id: Scalars['ID'];
  /** A field that is populated with relevant information about claiming the object given a valid logged in user. */
  self?: Maybe<SelfClaimEdge>;
  /** The type of claimable. */
  type: ClaimableType;
};

/** The enumerated types of claimables. */
export enum ClaimableType {
  /** A key code that has a bits amount associated with it. */
  BitsKeyCode = 'BITS_KEY_CODE',
  /** A key code that has a subscription to a product associated with it. */
  SubsKeyCode = 'SUBS_KEY_CODE',
  /** A key code that has a gift card with monetary value associated with it. */
  GiftCardKeyCode = 'GIFT_CARD_KEY_CODE'
}

/** Error code for an error that occurs while claiming the bounty. */
export type ClaimBountyError = {
   __typename?: 'ClaimBountyError';
  /** Error code for error that occurred while claiming the bounty. */
  code: ClaimBountyErrorCode;
};

/** Error types recognized. */
export enum ClaimBountyErrorCode {
  /** Invalid parameter in the request. */
  InvalidParameter = 'INVALID_PARAMETER',
  /** User reached the maximum number of bounties. */
  BountyLimitReached = 'BOUNTY_LIMIT_REACHED',
  /** User already claimed that bounty. */
  BountyAlreadyClaimed = 'BOUNTY_ALREADY_CLAIMED',
  /** Unknown error being returned from service. */
  UnknownError = 'UNKNOWN_ERROR'
}

/** ClaimBountyInput includes the bounty a user is trying to claim. */
export type ClaimBountyInput = {
  /** Unique Identifier for the bounty campaign. */
  bountyCampaignID: Scalars['ID'];
  /** Unique Identifier for the bounty. */
  bountyID: Scalars['ID'];
  /** Platform selected by the user to play this bounty's game on. */
  platform?: Maybe<Scalars['String']>;
  /** Region selected by the user for the game key. */
  region?: Maybe<Scalars['String']>;
  /** UserID of the user that will claim the bounty. */
  userID: Scalars['ID'];
};

/** Data that was mutated after claiming the bounty. */
export type ClaimBountyPayload = {
   __typename?: 'ClaimBountyPayload';
  /** The claimed bounty with the updated status. */
  claimedBounty?: Maybe<Bounty>;
  /** The possible error returned from the service. */
  error?: Maybe<ClaimBountyError>;
  /** The user that now has the claimed bounty. */
  user?: Maybe<User>;
};

/** An error from claiming community points. */
export type ClaimCommunityPointsError = {
   __typename?: 'ClaimCommunityPointsError';
  /** An identifier for the error that occurred. */
  code?: Maybe<ClaimCommunityPointsErrorCode>;
};

/** The possible reasons a claim could fail. */
export enum ClaimCommunityPointsErrorCode {
  /** The point claim was not found. */
  NotFound = 'NOT_FOUND',
  /** The current user is not allowed to claim these points. */
  Forbidden = 'FORBIDDEN'
}

/** Input for claiming community points. */
export type ClaimCommunityPointsInput = {
  /** The channel ID the claim is in. */
  channelID: Scalars['ID'];
  /** The claim ID. */
  claimID: Scalars['ID'];
};

/** The response from claiming community points. */
export type ClaimCommunityPointsPayload = {
   __typename?: 'ClaimCommunityPointsPayload';
  /** The points claim that was claimed. */
  claim?: Maybe<CommunityPointsClaim>;
  /** The user's point balance in the channel, after the claim. */
  currentPoints?: Maybe<Scalars['Int']>;
  /** An error that occurred while claiming. If there is an error, the claim did not go through. */
  error?: Maybe<ClaimCommunityPointsError>;
};

/** ClaimDropRewardsInput has fields required to claim a drop. */
export type ClaimDropRewardsInput = {
  /** dropInstanceID is the unique drop instance to claim. */
  dropInstanceID: Scalars['ID'];
};

/** ClaimDropRewardsPayload returns the state of the claim. */
export type ClaimDropRewardsPayload = {
   __typename?: 'ClaimDropRewardsPayload';
  /** Summary information for the drop the reward is claimed of. */
  drop?: Maybe<DropObject>;
  /** dropInstanceID is the same as the provided input. */
  dropInstanceID?: Maybe<Scalars['ID']>;
  /** UserAccountConnected is a boolean specifying if the user has a connected account link to the game the Reward is for. */
  isUserAccountConnected?: Maybe<Scalars['Boolean']>;
  /** rewards lists the rewards that were claimed and their statuses. */
  rewards: Array<DropReward>;
  /** status is an enum specifying the status of the claim request. */
  status?: Maybe<DropInstanceEligibilityStatus>;
};

/** Error code for an error that occurs while claiming prime offer. */
export type ClaimPrimeOfferError = {
   __typename?: 'ClaimPrimeOfferError';
  /** Error code for error that occurred while claiming prime offer. */
  code: ClaimPrimeOfferErrorCode;
};

/** Error types recognized. */
export enum ClaimPrimeOfferErrorCode {
  /** Status when offer is already claimed by the current user or an associated account. */
  OfferAlreadyClaimed = 'OFFER_ALREADY_CLAIMED',
  /** Unknown error being returned from service. */
  Unknown = 'UNKNOWN'
}

export type ClaimPrimeOfferInput = {
  /** Unique Identifier for an offer. */
  offerID: Scalars['ID'];
};

/** Data that was mutated after claiming the prime offer, in this case, the entitlement. */
export type ClaimPrimeOfferPayload = {
   __typename?: 'ClaimPrimeOfferPayload';
  /** The possible error returned from the service. */
  error?: Maybe<ClaimPrimeOfferError>;
  /** The connection for whether the user is entitled to the offer. */
  self?: Maybe<PrimeOfferSelfConnection>;
};

/** ClearUnreadFriendRequestsPaylod is the payload returned by ClearUnreadFriendRequests. */
export type ClearUnreadFriendRequestsPayload = {
   __typename?: 'ClearUnreadFriendRequestsPayload';
  /** The modified user. */
  user?: Maybe<User>;
};

/** The authorization a user has provided to an OAuth client. */
export type ClientAuthorization = {
   __typename?: 'ClientAuthorization';
  /** The ID of the client. */
  clientID: Scalars['ID'];
  /** The name of the client. */
  clientName?: Maybe<Scalars['String']>;
  /** The time when the authorization was created. */
  createdAt?: Maybe<Scalars['Time']>;
};

/** A recorded, replayable part of a live broadcast. */
export type Clip = {
   __typename?: 'Clip';
  /**
   * The broadcast of the clip. This should only be used to fetch the ID of the broadcast.
   * Because not all videos have broadcasts (e.g. uploads), not all clips will have a broadcast.
   */
  broadcast?: Maybe<Broadcast>;
  /** The broadcaster from which the clip originated. */
  broadcaster?: Maybe<User>;
  /**
   * The curator's clip champ badge if it has been attained on the broadcaster's channel.
   * This will be null if the curator is not a clip champ of the broadcaster's channel.
   */
  champBadge?: Maybe<Badge>;
  /** The time when the clip was created. */
  createdAt: Scalars['Time'];
  /**
   * Different video qualities are being created in the background.
   * The creation state indicates when the source quality clip is playable
   * and transcoding of the clip in other video qualities has begun.
   */
  creationState?: Maybe<ClipCreationState>;
  /** The user who created the clip. */
  curator?: Maybe<User>;
  /** The duration of the clip, in seconds. */
  durationSeconds: Scalars['Int'];
  /** The URL used in the embed player. */
  embedURL: Scalars['String'];
  /** The game depicted in the clip. */
  game?: Maybe<Game>;
  /** The clip's unique identifier. */
  id: Scalars['ID'];
  /** Whether or not the clip has been published. */
  isPublished?: Maybe<Scalars['Boolean']>;
  /** The language of the clip. */
  language: Language;
  /** Metadata around the raw media. */
  rawMedia: ClipRawMedia;
  /** The different quality options of this clip's raw media used for editing. */
  rawVideoQualities?: Maybe<Array<ClipVideoQuality>>;
  /** The reactions associated with this clips. */
  reactions?: Maybe<Array<Maybe<Reaction>>>;
  /** Lists of related clips based on different algorithms. */
  relatedClips?: Maybe<ClipRelatedClips>;
  /** A URL-friendly identifier. */
  slug: Scalars['String'];
  /**
   * A URL to a thumbnail image.
   * Valid sizes are "86x45", "260x147", and "480x272".
   */
  thumbnailURL: Scalars['String'];
  /** The title of the clip. */
  title: Scalars['String'];
  /** A URL to the clip's page. */
  url: Scalars['String'];
  /**
   * The video of the clip. Because not all broadcasts are archived, not all clips will
   * have a video.
   */
  video?: Maybe<Video>;
  /** The number of seconds into a VOD this clip was generated from. */
  videoOffsetSeconds?: Maybe<Scalars['Int']>;
  /**
   * The different quality options of this clip available for playback.
   * The clip will first be available in the source video quality, indicated by when the
   * clipCreationState is 'CREATED'. videoQualities will gradually be added to afterwards as
   * more video quality options become playable.
   */
  videoQualities?: Maybe<Array<ClipVideoQuality>>;
  /** The number of times this clip has been viewed. */
  viewCount: Scalars['Int'];
};


/** A recorded, replayable part of a live broadcast. */
export type ClipThumbnailUrlArgs = {
  width?: Maybe<Scalars['Int']>;
  height?: Maybe<Scalars['Int']>;
};

/** A list of clips related to the subject. */
export type ClipConnection = {
   __typename?: 'ClipConnection';
  /** The clips. */
  edges?: Maybe<Array<Maybe<ClipEdge>>>;
  /** Information about pagination in this connection. */
  pageInfo?: Maybe<PageInfo>;
};

/** An enumeration on the different status strings returned by a clip status. */
export enum ClipCreationState {
  /**
   * The creating status indicates that the source quality video is still
   * undergoing processing and transcoding.
   */
  Creating = 'CREATING',
  /**
   * Clip has been successfully created in the source video quality.
   * The field videoQualities will be gradually added to with other quality options.
   */
  Created = 'CREATED',
  /**
   * Clip creation failed and will remain in this state.
   * Possible errors can happen due to problems in downloading and slicing
   * the source of the original video, clipping offline channels, transcoding, etc.
   */
  Failed = 'FAILED'
}

export type ClipEdge = {
   __typename?: 'ClipEdge';
  /** Uniquely identifies this clip's position in a connection. */
  cursor?: Maybe<Scalars['Cursor']>;
  /** The clip. */
  node?: Maybe<Clip>;
};

/** ClipRawMedia describes metadata about the clip's raw media used in clip editing. */
export type ClipRawMedia = {
   __typename?: 'ClipRawMedia';
  /** Default Offset is the seconds into the raw clip media the default clip begins at. */
  defaultClipInitialOffset: Scalars['Float'];
  /** Total duration of the raw media. */
  duration: Scalars['Float'];
  /** Total number of frames displayed in the spritesheet film strip. */
  filmStripFrames: Scalars['Int'];
  /** Seconds covered by each frame in the spritesheet film strip. */
  filmStripSecondsPerFrame: Scalars['Int'];
  /** Height of the frames displayed. */
  frameHeight: Scalars['Int'];
  /** Width of the frames displayed. */
  frameWidth: Scalars['Int'];
  /** Spritesheet displayed to user for clip editing. */
  spritesheetURL: Scalars['String'];
  /** Status of the clip's raw media. */
  status: ClipCreationState;
  /** URL link to the video mp4 containing to upwards of 90 seconds of the raw video from which the clip can be created from. */
  videoURL: Scalars['String'];
};

/**
 * There are different algorithms that return a different set of related clips.
 * They only return up to 4 clips per list.
 */
export type ClipRelatedClips = {
   __typename?: 'ClipRelatedClips';
  /** Up-to 4  randomly selected, top viewed clips from the same broadcaster created within the last 4 days. */
  broadcaster?: Maybe<Array<Clip>>;
  /**
   * Up-to 10 clips, in order, combined from the other returned clip sets.
   * Clips are included in the priority of similar, broadcaster, game, and then top.
   */
  combined?: Maybe<Array<Clip>>;
  /** Up-to 4  randomly selected, top viewed clips from the same user created within the last 4 days. */
  curator?: Maybe<Array<Clip>>;
  /** Up-to 4  randomly selected, top viewed clips from the same game created within the last 4 days. */
  game?: Maybe<Array<Clip>>;
  /** Up-to 4 similar clips, based on the recommendations service. */
  similar?: Maybe<Array<Clip>>;
  /** Up-to 4 randomly selected, top viewed clips created within the last 4 days. */
  top?: Maybe<Array<Clip>>;
};

/** ClipSegmentInput represents a single segment of a clip. */
export type ClipSegmentInput = {
  /** The number of seconds this clip segment encompasses. */
  durationSeconds: Scalars['Float'];
  /** The offset into the clip's 90 second raw media. */
  offsetSeconds: Scalars['Float'];
  /**
   * Valid input speeds are 0.25, 0.5, 1.0, 1.5, and 2.0.
   * The segment speed will be set to 1 by default if unspecified.
   */
  speed?: Maybe<Scalars['Float']>;
};

/** The set of methods to restrict clips results. */
export enum ClipsFilter {
  /** Limit results to trending clips. */
  Trending = 'TRENDING',
  /** Limit results to clips created in the period between now and the last 24 hours. */
  LastDay = 'LAST_DAY',
  /** Limit results to clips created in the period between now and the last 7 days. */
  LastWeek = 'LAST_WEEK',
  /** Limit results to clips created in the period between now and the last 30 days. */
  LastMonth = 'LAST_MONTH',
  /** No limit on clips creation period. */
  AllTime = 'ALL_TIME'
}

/**
 * An enumeration on the different time frames to filter clips results based on
 * creation time.
 */
export enum ClipsPeriod {
  /** Limit results to clips created in the period between now and the last 24 hours. */
  LastDay = 'LAST_DAY',
  /** Limit results to clips created in the period between now and the last 7 days. */
  LastWeek = 'LAST_WEEK',
  /** Limit results to clips created in the period between now and the last 30 days. */
  LastMonth = 'LAST_MONTH',
  /** No limit on when the clips were created. */
  AllTime = 'ALL_TIME'
}

/** An enumeration on the different sort orders of clips results. */
export enum ClipsSort {
  /** Sort the clips ascending by created_at. */
  CreatedAtAsc = 'CREATED_AT_ASC',
  /** Sort the clips descending by created_at. */
  CreatedAtDesc = 'CREATED_AT_DESC',
  /** Sort the clips ascending by views. */
  ViewsAsc = 'VIEWS_ASC',
  /** Sort the clips descending by views. */
  ViewsDesc = 'VIEWS_DESC',
  /** Sort the clips descending by popularity. */
  Trending = 'TRENDING'
}

/** ClipVideoQuality describes metadata about an available playback source for a clip. */
export type ClipVideoQuality = {
   __typename?: 'ClipVideoQuality';
  /**
   * Frame rate is the number of frames per second of this video.
   * This value is a 64-bit float, with a default value of 30.0,
   * and is used for supporting different playback speeds.
   * Frame rate will be empty for raw media video qualities.
   */
  frameRate?: Maybe<Scalars['Float']>;
  /**
   * Clips can have multiple playback qualities via transcoding.
   * Some examples of qualities include "1080", "720", "480", "360", and "source".
   */
  quality: Scalars['String'];
  /** The source video URL for the clip in this specific playback quality. */
  sourceURL: Scalars['String'];
};

/** CloneExtensionDiscoveryDataError is an error associated with the cloneExtensionDiscoveryData mutation. */
export enum CloneExtensionDiscoveryDataError {
  /** User is unable to clone the extension. */
  Unauthorized = 'UNAUTHORIZED',
  /** Version specified is invalid. */
  InvalidNewVersion = 'INVALID_NEW_VERSION',
  /** The Version to clone from does not exist. */
  VersionNotFound = 'VERSION_NOT_FOUND'
}

/** CloneExtensionDiscoveryData copies a given version's discovery data to another version. */
export type CloneExtensionDiscoveryDataInput = {
  /** The extension ID of the extension to clone. */
  id: Scalars['ID'];
  /** The version to clone to. */
  newVersion: Scalars['String'];
  /** The extension version to clone from. */
  version: Scalars['String'];
};

/** CloneExtensionDiscoveryDataPayload returns any errors that occur during the copying of the discovery data. */
export type CloneExtensionDiscoveryDataPayload = {
   __typename?: 'CloneExtensionDiscoveryDataPayload';
  /** The error when the mutation fails to update an extension. */
  error?: Maybe<CloneExtensionDiscoveryDataError>;
  /** The updated extension discovery data. */
  manifest?: Maybe<ExtensionVersionDiscoveryManifest>;
};

/** CloneExtensionManifestError is an error associated with the cloneExtensionManifest mutation. */
export enum CloneExtensionManifestError {
  /** User is unable to clone the extension. */
  Unauthorized = 'UNAUTHORIZED',
  /** Version specified is invalid. */
  InvalidNewVersion = 'INVALID_NEW_VERSION',
  /** The version to clone to already exists. */
  VersionAlredyExists = 'VERSION_ALREDY_EXISTS',
  /** The Version to clone from does not exist. */
  VersionNotFound = 'VERSION_NOT_FOUND'
}

/** CloneExtensionManifest copies the data in a given extension version to a new version. */
export type CloneExtensionManifestInput = {
  /** The extension ID of the extension to clone. */
  id: Scalars['ID'];
  /** The version of the clone. */
  newVersion: Scalars['String'];
  /** The extension version to clone. */
  version: Scalars['String'];
};

/** CloneExtensionManifestPayload returns any errors that occur during update and the new manifest. */
export type CloneExtensionManifestPayload = {
   __typename?: 'CloneExtensionManifestPayload';
  /** The error when the mutation fails to update an extension. */
  error?: Maybe<CloneExtensionManifestError>;
  /** The updated extension manifest. */
  manifest?: Maybe<ExtensionManifest>;
};

/** Collection (a.k.a. Playlist) is a backend concept for a list of videos. */
export type Collection = {
   __typename?: 'Collection';
  /** The user-supplied description of the collection. */
  description: Scalars['String'];
  /** The collection's identifier. */
  id: Scalars['ID'];
  /** The paginated items in the collection. At this time, they will all be VoDs. */
  items: CollectionConnection;
  /** Total length of the collection as summed from all video lengths. */
  lengthSeconds: Scalars['Int'];
  /** The owner of the collection. */
  owner?: Maybe<User>;
  /**
   * The thumbnailURL for the collection.
   * If either `height` or `width` are not given, a templated value (i.e.
   * `{height}`, `{width}`) will be present in the URL instead.
   */
  thumbnailURL?: Maybe<Scalars['String']>;
  /** The user-supplied title of the collection. */
  title: Scalars['String'];
  /** The type of collection, either a series or default collection which is ''. */
  type: CollectionType;
  /** Time when the collection was last updated. */
  updatedAt: Scalars['Time'];
  /** The total view count of a collection. */
  viewCount?: Maybe<Scalars['Int']>;
};


/** Collection (a.k.a. Playlist) is a backend concept for a list of videos. */
export type CollectionItemsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};


/** Collection (a.k.a. Playlist) is a backend concept for a list of videos. */
export type CollectionThumbnailUrlArgs = {
  height?: Maybe<Scalars['Int']>;
  width?: Maybe<Scalars['Int']>;
};

/** A paginated list of videos, and its metadata. */
export type CollectionConnection = {
   __typename?: 'CollectionConnection';
  /** The list of items in this page. */
  edges: Array<Maybe<CollectionItemEdge>>;
  /** Information about this page of videos. */
  pageInfo: PageInfo;
  /** The total number of items in the collection. */
  totalCount: Scalars['Int'];
};

/** The types of objects that can be contained in a collection. */
export type CollectionItem = Video;

/**
 * A page entry, that contains a collection item and a cursor to return
 * from the query to allow pagination.
 */
export type CollectionItemEdge = {
   __typename?: 'CollectionItemEdge';
  cursor: Scalars['Cursor'];
  node: CollectionItem;
};

/** A Collection input to set options to include all items in a collection. */
export type CollectionOptions = {
  /** Include all playlist items including private and deleted items. */
  includeAllItems?: Maybe<Scalars['Boolean']>;
};

/**
 * These two types allow clients to query for a LIST of COLLECTIONS
 * (i.e. a two-dimensional array of videos).
 */
export type CollectionsConnection = {
   __typename?: 'CollectionsConnection';
  edges: Array<Maybe<CollectionsItemEdge>>;
  pageInfo: PageInfo;
};

export type CollectionsItemEdge = {
   __typename?: 'CollectionsItemEdge';
  cursor?: Maybe<Scalars['Cursor']>;
  node: Collection;
};

/** Options for filtering collections. */
export type CollectionsOptions = {
  /** Option to include empty collections. */
  includeEmpty?: Maybe<Scalars['Boolean']>;
  /** Only return collections that include the given video ID. */
  withVideoID?: Maybe<Scalars['ID']>;
};

/** The set of different collection types. */
export enum CollectionType {
  /** Series collection type. */
  Series = 'SERIES',
  /** Default collection type. */
  Default = 'DEFAULT'
}

/** An automatic community points reward. */
export type CommunityPointsAutomaticReward = {
   __typename?: 'CommunityPointsAutomaticReward';
  /** The background color for the reward icon. */
  backgroundColor?: Maybe<Scalars['String']>;
  /** The point cost of this reward. */
  cost?: Maybe<Scalars['Int']>;
  /** The default background color for this reward. */
  defaultBackgroundColor: Scalars['String'];
  /** The default point cost of this reward. */
  defaultCost: Scalars['Int'];
  /** The default image for this reward. */
  defaultImage: CommunityPointsImage;
  /** The unique identifier of this reward in this channel. */
  id: Scalars['ID'];
  /** The custom icon for this reward, if any. */
  image?: Maybe<CommunityPointsImage>;
  /** Whether this reward is turned on or off in this channel at the moment. */
  isEnabled: Scalars['Boolean'];
  /** Whether only non-subscribers are allowed to redeem this reward in this channel. */
  isHiddenForSubs: Scalars['Boolean'];
  /** The lowest the broadcaster is allowed to set the cost of this reward. */
  minimumCost: Scalars['Int'];
  /** The type of automatic reward this is. */
  type: CommunityPointsAutomaticRewardType;
};

/** Types of CommunityPointsAutomaticRewards. */
export enum CommunityPointsAutomaticRewardType {
  /** Send a single message through sub-only mode. */
  SingleMessageBypassSubMode = 'SINGLE_MESSAGE_BYPASS_SUB_MODE',
  /** Unlock a random subscriber emote. */
  RandomSubEmoteUnlock = 'RANDOM_SUB_EMOTE_UNLOCK',
  /** Unlock a chosen subscriber emote. */
  ChosenSubEmoteUnlock = 'CHOSEN_SUB_EMOTE_UNLOCK',
  /** Send a highlighted chat message. */
  SendHighlightedMessage = 'SEND_HIGHLIGHTED_MESSAGE',
  /** Unlock a chosen modification for a subscriber emote. */
  ChosenModifiedSubEmoteUnlock = 'CHOSEN_MODIFIED_SUB_EMOTE_UNLOCK'
}

/** Information on how points are earned by viewers in a specific channel. */
export type CommunityPointsChannelEarningSettings = {
   __typename?: 'CommunityPointsChannelEarningSettings';
  /** The average number of points per hour earned by a regular (non-sub) user on this channel. */
  averagePointsPerHour: Scalars['Int'];
  /** The average number of points per hour earned by a subscriber on this channel. */
  averagePointsPerHourSubscriber: Scalars['Int'];
  /** How many points are earned for cheering in a channel. */
  cheerPoints: Scalars['Int'];
  /** How many minutes will pass in between bonus claims becoming available. */
  claimPeriodMinutes: Scalars['Int'];
  /** How many points are earned for clicking a bonus claim. */
  claimPoints: Scalars['Int'];
  /** How many points are earned for following the channel. */
  followPoints: Scalars['Int'];
  /** A unique identifier. */
  id: Scalars['ID'];
  /** How many minutes must be watched to earn points for passively watching the channel. */
  passiveWatchPeriodMinutes: Scalars['Int'];
  /** How many points are earned for passively watching the channel. */
  passiveWatchPoints: Scalars['Int'];
  /** How many points are earned for following a raid by the channel. */
  raidPoints: Scalars['Int'];
  /**
   * The earning multiplier applied to subscribers to the channel.
   * This multiplier only applies to "watch" and "claim" actions.
   */
  subscriberMultiplier: Scalars['Float'];
  /** How many points are earned for gifting a subscription in a channel. */
  subscriptionGiftPoints: Scalars['Int'];
  /**
   * How many points are earned for watching consecutive streams.
   * This list will be sorted from shortest duration to longest duration.
   * Watch streaks beyond the longest duration here will be treated the same as watch streaks of the longest duration.
   */
  watchStreakPoints: Array<CommunityPointsWatchStreakEarningSettings>;
};

/** Settings for a channel's Community Points. */
export type CommunityPointsChannelSettings = {
   __typename?: 'CommunityPointsChannelSettings';
  /** Automatic rewards for this channel. If no automatic rewards exist, will be an empty array. */
  automaticRewards?: Maybe<Array<CommunityPointsAutomaticReward>>;
  /** Single custom reward by the given id for this channel. */
  customReward?: Maybe<CommunityPointsCustomReward>;
  /** Custom rewards for this channel. If no custom rewards exist, will be an empty array. */
  customRewards?: Maybe<Array<CommunityPointsCustomReward>>;
  /** The default image for community points. */
  defaultImage: CommunityPointsImage;
  /**
   * Properties concerning the user's participation in the Channel Points early access program.
   * @deprecated Early Access period is over.
   */
  earlyAccess?: Maybe<CommunityPointsEarlyAccessSettings>;
  /** Information on how points are earned by viewers in this channel. */
  earning?: Maybe<CommunityPointsChannelEarningSettings>;
  /** A list of the emote variants (base emote + modifications) that are available for this channel. */
  emoteVariants?: Maybe<Array<CommunityPointsEmoteVariant>>;
  /** The channel's custom community points icon. Null if they have not set an icon. */
  image?: Maybe<CommunityPointsImage>;
  /** Whether the channel is allowed to turn community points on now. */
  isAvailable: Scalars['Boolean'];
  /**
   * Whether the channel will be allowed to turn community points on at full public launch.
   * @deprecated Early Access period is over.
   */
  isAvailableAtLaunch: Scalars['Boolean'];
  /** Whether the channel has community points turned on now. */
  isEnabled: Scalars['Boolean'];
  /**
   * Whether the channel will have community points turned on at full public launch.
   * @deprecated Early Access period is over.
   */
  isEnabledAtLaunch: Scalars['Boolean'];
  /** The channel's custom community points name. Null if they have not set a name. */
  name?: Maybe<Scalars['String']>;
  /**
   * The amount of points earned for participating in a raid from the channel.
   * @deprecated Should use earning.raidPoints instead
   */
  raidPointAmount: Scalars['Int'];
  /** A list of Smart Costs acknowledgements. */
  smartCostsAcknowledgements?: Maybe<Array<SmartCostsAcknowledgement>>;
  /** A summary of information about unfulfilled redemptions of each custom reward. */
  summarizedRewards?: Maybe<Array<CommunityPointsRewardSummary>>;
  /** A list of the progress for all ongoing Update Custom Reward Redemption Statuses requests. */
  updateCustomRewardRedemptionStatusesProgress?: Maybe<Array<CommunityPointsUpdateCustomRewardRedemptionStatusesProgress>>;
};


/** Settings for a channel's Community Points. */
export type CommunityPointsChannelSettingsCustomRewardArgs = {
  id: Scalars['ID'];
};

/** Points that are available for a user to click to claim in a channel. */
export type CommunityPointsClaim = {
   __typename?: 'CommunityPointsClaim';
  /** The claim's unique ID. */
  id: Scalars['ID'];
  /**
   * The multipliers that will affect this claim.
   * Multipliers start at a base of 1.0, and are additive.
   * Two multipliers of [0.2] and [0.3] will give a final multiplier of 1.5x.
   */
  multipliers: Array<CommunityPointsMultiplier>;
  /** The baseline points this claim will grant, before applying multipliers. */
  pointsEarnedBaseline: Scalars['Int'];
  /** The total points this claim will grant. */
  pointsEarnedTotal: Scalars['Int'];
};

/** A custom community points reward on a channel. */
export type CommunityPointsCustomReward = {
   __typename?: 'CommunityPointsCustomReward';
  /** The custom background color for this reward. If no background color specified, will be null. */
  backgroundColor?: Maybe<Scalars['String']>;
  /** The point cost of this reward. */
  cost: Scalars['Int'];
  /** The default image for community points custom rewards. */
  defaultImage: CommunityPointsImage;
  /** The unique identifier for this reward. */
  id: Scalars['ID'];
  /** The custom image for this reward. If no image exists, will be null. */
  image?: Maybe<CommunityPointsImage>;
  /** Whether this reward is enabled in this channel at the moment. */
  isEnabled: Scalars['Boolean'];
  /**
   * Whether this reward is in stock at the moment.
   * If the reward has already been redeemed the maximum number of times per stream, this will be false.
   */
  isInStock: Scalars['Boolean'];
  /** Whether redemptions of this reward are temporarily paused. */
  isPaused: Scalars['Boolean'];
  /** Whether only subscribers are allowed to redeem this reward in this channel. */
  isSubOnly: Scalars['Boolean'];
  /** Whether this reward requires users to enter text input. */
  isUserInputRequired: Scalars['Boolean'];
  /** The most rewards of this type that can be redeemed per stream. */
  maxPerStreamSetting: CommunityPointsCustomRewardMaxPerStreamSetting;
  /** The user-facing prompt for this reward. If no prompt exists, will be null. */
  prompt?: Maybe<Scalars['String']>;
  /**
   * Whether redemptions for this reward should skip the broadcaster's request queue and get
   * automatically fulfilled.
   */
  shouldRedemptionsSkipRequestQueue: Scalars['Boolean'];
  /** The short title displayed for this reward. */
  title: Scalars['String'];
};

/** Settings for how often a custom reward may be redeemed per stream. */
export type CommunityPointsCustomRewardMaxPerStreamSetting = {
   __typename?: 'CommunityPointsCustomRewardMaxPerStreamSetting';
  /** Whether the maximum is being enforced. */
  isEnabled: Scalars['Boolean'];
  /** The most rewards of this type that can be redeemed per stream. */
  maxPerStream: Scalars['Int'];
};

/** Input for creating and updating a Community Points custom reward's max per stream settings. */
export type CommunityPointsCustomRewardMaxPerStreamSettingInput = {
  /** Whether the maximum is being enforced. */
  isEnabled: Scalars['Boolean'];
  /** The most rewards of this type that can be redeemed per stream. */
  maxPerStream: Scalars['Int'];
};

/** A community points custom reward that has been redeemed in a channel. */
export type CommunityPointsCustomRewardRedemption = {
   __typename?: 'CommunityPointsCustomRewardRedemption';
  /** The unique ID of this redemption. */
  id: Scalars['ID'];
  /** The user-provided text input, if it exists. */
  input?: Maybe<Scalars['String']>;
  /**
   * The custom reward that was redeemed.
   * @deprecated Use the 'rewardID' and 'rewardTitle' fields instead.
   */
  reward?: Maybe<CommunityPointsCustomReward>;
  /** The unique ID of the reward that was redeemed. */
  rewardID: Scalars['ID'];
  /** The title of the custom reward that was redeemed, at the time it was redeemed. */
  rewardTitle: Scalars['String'];
  /** The status of this redemption. */
  status: CommunityPointsCustomRewardRedemptionStatus;
  /** The time that the reward was redeemed at. */
  timestamp: Scalars['Time'];
  /** The user that redeemed the reward. */
  user?: Maybe<User>;
};

/**
 * A paginated list of Community Points redemptions, and its metadata.
 * Only returns results for logged-in, authorized users, otherwise returns a nil response.
 */
export type CommunityPointsCustomRewardRedemptionConnection = {
   __typename?: 'CommunityPointsCustomRewardRedemptionConnection';
  /** The list of items in this page. */
  edges: Array<CommunityPointsCustomRewardRedemptionEdge>;
  /** Information about this page of Community Points redemptions. */
  pageInfo: PageInfo;
};

/**
 * A page entry, that contains a CommunityPointsCustomRewardRedemption item and a cursor to
 * return from the query to allow pagination.
 */
export type CommunityPointsCustomRewardRedemptionEdge = {
   __typename?: 'CommunityPointsCustomRewardRedemptionEdge';
  /** Cursor used for next query. */
  cursor: Scalars['Cursor'];
  /** The underlying Community Points redemption. */
  node: CommunityPointsCustomRewardRedemption;
};

/** Ways to sort Community Points redemptions. */
export enum CommunityPointsCustomRewardRedemptionQueueSortOrder {
  /** The oldest redemption first. */
  Oldest = 'OLDEST',
  /** The newest redemption first. */
  Newest = 'NEWEST'
}

/** Possible states for a CommunityPointsCustomRewardRedemption. */
export enum CommunityPointsCustomRewardRedemptionStatus {
  /** A redemption that has not been acted on by the broadcaster. */
  Unfulfilled = 'UNFULFILLED',
  /** A redemption that has been fulfilled by the broadcaster. */
  Fulfilled = 'FULFILLED',
  /** A redemption that has been canceled by the broadcaster. */
  Canceled = 'CANCELED',
  /** A redemption that has been reported by the broadcaster. */
  Reported = 'REPORTED'
}

/** Properties concerning the user's participation in the Community Points early access program. */
export type CommunityPointsEarlyAccessSettings = {
   __typename?: 'CommunityPointsEarlyAccessSettings';
  /** Whether the user is eligible to sign up for Community Points early access. */
  canSignUp: Scalars['Boolean'];
  /** Whether the user has signed up for Community Points early access. */
  isSignedUp: Scalars['Boolean'];
};

/** A community points emote. */
export type CommunityPointsEmote = {
   __typename?: 'CommunityPointsEmote';
  /** The emote's identifier. */
  id: Scalars['ID'];
  /** The text token of the emote. */
  token: Scalars['String'];
};

/** A community points emote modification. */
export type CommunityPointsEmoteModification = {
   __typename?: 'CommunityPointsEmoteModification';
  /** The modified emote. */
  emote: CommunityPointsEmote;
  /** The emote modification's identifier. */
  id: Scalars['ID'];
  /** The dark version of the icon to represent the modification made to the emote. */
  modifierIconDark: CommunityPointsImage;
  /** The light version of the icon to represent the modification made to the emote. */
  modifierIconLight: CommunityPointsImage;
  /** The title for the modification. */
  title: Scalars['String'];
};

/** A community points emote variant, includes base emote plus modifications. */
export type CommunityPointsEmoteVariant = {
   __typename?: 'CommunityPointsEmoteVariant';
  /** The base emote for this variant. */
  emote: CommunityPointsEmote;
  /** The emote variant's identifier. */
  id: Scalars['ID'];
  /** Whether community points can be used to unlock the base emote. */
  isUnlockable: Scalars['Boolean'];
  /** The modifications available to be unlocked for this emote. */
  modifications: Array<CommunityPointsEmoteModification>;
};

/** Image URLs of different sizes for community points rewards. */
export type CommunityPointsImage = {
   __typename?: 'CommunityPointsImage';
  /** The URL for the small size image. */
  url: Scalars['String'];
  /** The URL for the medium size image. */
  url2x: Scalars['String'];
  /** The URL for the large size image. */
  url4x: Scalars['String'];
};

/** The information required for the client to upload an image for Community Points. */
export type CommunityPointsImageUploadInfo = {
   __typename?: 'CommunityPointsImageUploadInfo';
  /** The upload ID. */
  uploadID: Scalars['ID'];
  /** The URL to upload to. */
  url: Scalars['String'];
};

/** Availability of limited earn actions for a viewer in a specific channel. */
export type CommunityPointsLimitedEarnings = {
   __typename?: 'CommunityPointsLimitedEarnings';
  /**
   * Timestamp of when points will become available for cheering on the channel.
   * This will be nil if isCheerAvailable is true and can be nil when isCheerAvailable is false
   * indicating that there is not currently a time in the future when it will become available.
   */
  cheerAvailableAt?: Maybe<Scalars['Time']>;
  /** A unique identifier. */
  id: Scalars['ID'];
  /** Can the user cheer to get points on the channel. */
  isCheerAvailable: Scalars['Boolean'];
  /** Can the user follow to get points on the channel. */
  isFollowAvailable: Scalars['Boolean'];
  /** Can the user gift a subscription in the channel to get points on the channel. */
  isSubscriptionGiftAvailable: Scalars['Boolean'];
  /**
   * Timestamp of when points will become available for gifting subscriptions on the channel.
   * This will be nil if isSubscriptionGiftAvailable is true and can be nil when isSubscriptionGiftAvailable is false
   * indicating that there is not currently a time in the future when it will become available.
   */
  subscriptionGiftAvailableAt?: Maybe<Scalars['Time']>;
};

/** A multiplier affecting the rate of community points earned for a user in a channel. */
export type CommunityPointsMultiplier = {
   __typename?: 'CommunityPointsMultiplier';
  /**
   * The multiplying factor being applied.
   * Multipliers start at a base of 1.0, and are additive.
   * Two multipliers of [0.2] and [0.3] will give a final multiplier of 1.5x.
   */
  factor: Scalars['Float'];
  /** The reason that the multiplier is being applied. */
  reasonCode: CommunityPointsMultiplierReason;
};

/** Reasons that community point earning could be multiplied for a user in a channel. */
export enum CommunityPointsMultiplierReason {
  /** Tier-1 Subscriber. */
  SubT1 = 'SUB_T1',
  /** Tier-2 Subscriber. */
  SubT2 = 'SUB_T2',
  /** Tier-3 Subscriber. */
  SubT3 = 'SUB_T3'
}

/** Properties relating to a user's community points in a channel. */
export type CommunityPointsProperties = {
   __typename?: 'CommunityPointsProperties';
  /**
   * Multipliers currently affecting the logged in user's rate of point gaining in this channel.
   * If there are no multipliers active, will be an empty array.
   */
  activeMultipliers?: Maybe<Array<CommunityPointsMultiplier>>;
  /** Points that are available for the user to click to claim in this channel. Null if there are no points available to claim. */
  availableClaim?: Maybe<CommunityPointsClaim>;
  /** The number of community points this user currently has available to use in this channel. */
  balance: Scalars['Int'];
  /**
   * Whether the user can redeem rewards on this channel for free.
   * The main example is broadcasters on their own channels.
   */
  canRedeemRewardsForFree: Scalars['Boolean'];
  /** Availability of limited earning actions for the user in this channel. */
  limitedEarnings?: Maybe<CommunityPointsLimitedEarnings>;
};

/** Optional filters that can be applied to a redemption queue query. */
export type CommunityPointsRedemptionQueueOptions = {
  /** The order of the results, either oldest first or newest first. */
  order?: Maybe<CommunityPointsCustomRewardRedemptionQueueSortOrder>;
  /** Filter results to only redemptions of this reward. */
  rewardID?: Maybe<Scalars['ID']>;
  /** Filter results to only redemptions of this status. */
  status?: Maybe<CommunityPointsCustomRewardRedemptionStatus>;
};

/**
 * A summary of information about redemptions of a given custom community points reward.
 * Only returns results for logged-in, authorized users, otherwise returns a nil response.
 */
export type CommunityPointsRewardSummary = {
   __typename?: 'CommunityPointsRewardSummary';
  /** The total number of unfulfilled redemptions of this reward on the channel. */
  count: Scalars['Int'];
  /**
   * If the count is at the max, the true count could be any number greater than or equal to the count.
   * Clients should indicate that there could be more redemptions than the number indicates.
   * For example, if count = 100 and isCountAtMaximum = true, clients could show "100+".
   */
  isCountAtMaximum: Scalars['Boolean'];
  /** The reward being summarized. */
  node: CommunityPointsCustomReward;
};

/** An error from redeeming an unlock emote Community Points reward. */
export type CommunityPointsUnlockEmoteError = {
   __typename?: 'CommunityPointsUnlockEmoteError';
  /** The error code. */
  code: CommunityPointsUnlockEmoteErrorCode;
};

/** Possible errors from redeeming an unlock emote Community Points reward. */
export enum CommunityPointsUnlockEmoteErrorCode {
  /** The emote ID provided is for the wrong channel or the wrong type of emote. */
  InvalidEmote = 'INVALID_EMOTE',
  /** The user is already entitled to the emote provided. */
  EmoteAlreadyEntitled = 'EMOTE_ALREADY_ENTITLED',
  /** The user is entitled to all emotes that would be randomly selected from. */
  NoEmotesAvailable = 'NO_EMOTES_AVAILABLE',
  /** The user does not have sufficient points to redeem the reward. */
  InsufficientPoints = 'INSUFFICIENT_POINTS',
  /** The client is retrying a redemption with a transaction id that has already been redeemed. */
  TransactionAlreadyCommitted = 'TRANSACTION_ALREADY_COMMITTED',
  /** The client is retrying a redemption with a transaction id that is currently being redeemed in another request. */
  TransactionInProgress = 'TRANSACTION_IN_PROGRESS',
  /** The reward cost has changed since the user has tried to redeem it. */
  RewardCostMismatch = 'REWARD_COST_MISMATCH',
  /** The reward is currently disabled. */
  RewardDisabled = 'REWARD_DISABLED',
  /** The user is not allowed to redeem this reward on this channel. */
  RewardForbidden = 'REWARD_FORBIDDEN',
  /** An unknown error occurred. */
  Unknown = 'UNKNOWN'
}

/** Methods for updating community points CustomReward redemption statuses. */
export enum CommunityPointsUpdateCustomRewardRedemptionStatusesMethod {
  /** Unknown method. */
  Unknown = 'UNKNOWN',
  /** Statuses for all redemptions for the channel are being updated. */
  ByChannel = 'BY_CHANNEL',
  /** Statuses for all redemptions for a reward are being updated. */
  ByReward = 'BY_REWARD',
  /** Statuses for the provided redemptions are being updated. */
  ByRedemptions = 'BY_REDEMPTIONS'
}

/** The type representing Community Points Update Custom Reward Redemption Statuses Progress. */
export type CommunityPointsUpdateCustomRewardRedemptionStatusesProgress = {
   __typename?: 'CommunityPointsUpdateCustomRewardRedemptionStatusesProgress';
  /** The channel ID the redemptions are being updated for. */
  channelID: Scalars['ID'];
  /** Unique identifier for the progress. */
  id: Scalars['ID'];
  /** The method being used to update the custom reward redemption statuses. */
  method: CommunityPointsUpdateCustomRewardRedemptionStatusesMethod;
  /** The new status the redemptions are being set to. */
  newStatus: CommunityPointsCustomRewardRedemptionStatus;
  /** The number of redemptions that have been processed so far. */
  processed: Scalars['Int'];
  /**
   * The reward ID the redemptions being updated are for.
   * Will only be set if method is BY_REWARD.
   */
  rewardID?: Maybe<Scalars['ID']>;
  /** The total number of redemptions being updated. */
  total: Scalars['Int'];
};

/** Settings for how many community points are awarded for a watch streak of a specific duration. */
export type CommunityPointsWatchStreakEarningSettings = {
   __typename?: 'CommunityPointsWatchStreakEarningSettings';
  /** How many points are awarded for a streak of this length. */
  points: Scalars['Int'];
  /** How long of a streak a user has. */
  streakLength: Scalars['Int'];
};

/** A company that is on Twitch. */
export type Company = {
   __typename?: 'Company';
  /** The bounty board campaigns that the company owns. */
  bountyCampaigns?: Maybe<BountyCampaignConnection>;
  /** The brand portal settings for the company. */
  brandPortalSettings?: Maybe<BrandPortalSettings>;
  /** ID of the Company in the CurseForge Infrastructure. */
  curseCompanyID?: Maybe<Scalars['ID']>;
  /** The estimated viewer reach for the pool of broadcasters this company is considering targeting. */
  estimatedBroadcasterViewerReach?: Maybe<BroadcasterViewerReach>;
  /**
   * The games associated with the company. Optionally include games that a company can use for Bounty Board
   * campaigns (ie. "Just Chatting" for trailer campaigns).
   */
  games?: Maybe<Array<Game>>;
  /** The company's unique identifier. */
  id: Scalars['ID'];
  /** Legacy Companies need to agree to the Drops Terms. */
  isCampaignsEnabled: Scalars['Boolean'];
  /** Legacy Companies are required to sign the Contract. */
  isContractSigned: Scalars['Boolean'];
  /** Indicates if the Company is a Legacy Company from the first iteration of the DevSite. */
  isLegacy: Scalars['Boolean'];
  /** The human-readable name of the company. */
  name: Scalars['String'];
  /** Indicates if company is a developer, publisher or other. */
  type: OrganizationType;
  /** The Company URL for their Corporate Website. */
  url: Scalars['String'];
};


/** A company that is on Twitch. */
export type CompanyBountyCampaignsArgs = {
  campaignID?: Maybe<Scalars['ID']>;
  status?: Maybe<BountyCampaignStatus>;
};


/** A company that is on Twitch. */
export type CompanyEstimatedBroadcasterViewerReachArgs = {
  gameNames: Array<Scalars['String']>;
  targetAllBroadcasters: Scalars['Boolean'];
  targetVarietyBroadcasters: Scalars['Boolean'];
  streamLengthSeconds?: Maybe<Scalars['Int']>;
  targetAllCountries?: Maybe<Scalars['Boolean']>;
  targetAllGames?: Maybe<Scalars['Boolean']>;
  countries?: Maybe<Array<Scalars['String']>>;
};


/** A company that is on Twitch. */
export type CompanyGamesArgs = {
  includeBountyBoardGames?: Maybe<Scalars['Boolean']>;
};

/** A Competition created by a competition organizer. */
export type Competition = {
   __typename?: 'Competition';
  /** This is the amount of time (in minutes) available for participants to check-in once competition startAt has passed. */
  checkInDurationMinutes: Scalars['Int'];
  /** The time the competition was created. */
  createdAt: Scalars['Time'];
  /** Long form text block description for the competition and will be converted to Markdown client-side. */
  description?: Maybe<Scalars['String']>;
  /** The time the competition is scheduled to end. */
  endAt: Scalars['Time'];
  /** The format contains the type and type metadata of the competition. (i.e. single elimination, round robin, etc.). */
  format: CompetitionFormat;
  /** The game being played in the competition. */
  game?: Maybe<Game>;
  /** Unique Competition ID. */
  id: Scalars['ID'];
  /** Primary artwork for the competition. */
  imageURL?: Maybe<Scalars['String']>;
  /** The name of the competition. */
  name: Scalars['String'];
  /** The competition organizer. */
  owner?: Maybe<User>;
  /** The participant-facing points of contact for the competition that only registered participants can see. */
  participantOnlyContactInfo?: Maybe<CompetitionContactInfo>;
  /** The type of participant for the competition. e.g. SOLO, TEAM, ... */
  participantType: CompetitionParticipantType;
  /** Paginated list of participants in the competition. */
  participants?: Maybe<CompetitionParticipantConnection>;
  /** A list of phases in the competition. */
  phases: Array<CompetitionPhase>;
  /** Paginated list of players in the competition. */
  players?: Maybe<CompetitionPlayerConnection>;
  /**
   * Long form text block description that explains the prizing for the competition
   * and will be converted to Markdown client-side.
   */
  prizeDescription?: Maybe<Scalars['String']>;
  /** The public points of contact for the competition that anyone can see. */
  publicContactInfo?: Maybe<CompetitionContactInfo>;
  /** The time the competition is scheduled to end registration. */
  registrationEndAt: Scalars['Time'];
  /** The type of a registration for the competition. e.g. OPEN, INVITATIONAL, ... */
  registrationType: RegistrationType;
  /**
   * Long form text block description that explains the rules for the competition
   * and will be converted to Markdown client-side.
   */
  rulesDescription?: Maybe<Scalars['String']>;
  /** The time the competition is scheduled to start. */
  startAt: Scalars['Time'];
  /** The state of the tournament. */
  state: CompetitionState;
  /** The number of players within a single team entity. Must be 1 for solo-type competitions. */
  teamSize: Scalars['Int'];
  /** Paginated list of teams in the competition. */
  teams?: Maybe<CompetitionTeamConnection>;
  /** Link URL to any additional terms and conditions. */
  termsURL?: Maybe<Scalars['String']>;
  /** The time the competition was last updated. */
  updatedAt: Scalars['Time'];
};


/** A Competition created by a competition organizer. */
export type CompetitionParticipantsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};


/** A Competition created by a competition organizer. */
export type CompetitionPlayersArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  state?: Maybe<CompetitionPlayerState>;
};


/** A Competition created by a competition organizer. */
export type CompetitionTeamsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};

/** Paginated list of Competitions. */
export type CompetitionConnection = {
   __typename?: 'CompetitionConnection';
  /** The elements of the list. */
  edges: Array<CompetitionEdge>;
  /** Are there more competitions in the list and what is the cursor. */
  pageInfo: PageInfo;
};

/** The contact information to contact the organizers for the competition. */
export type CompetitionContactInfo = {
   __typename?: 'CompetitionContactInfo';
  /** Link to Discord server for competition contact purposes. */
  discordURL?: Maybe<Scalars['String']>;
  /** Email address point of contact for the competition. */
  email?: Maybe<Scalars['String']>;
};

/**
 * Contains information about a Competition's relationship to a given page (connection),
 * and the Competition itself.
 */
export type CompetitionEdge = {
   __typename?: 'CompetitionEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** A competition record in the list of competitons. */
  node: Competition;
};

/** The CompetitionFormat contains the type and type metadata of the competition. (i.e. single elimination, round robin, etc.). */
export type CompetitionFormat = {
   __typename?: 'CompetitionFormat';
  /** The details of the format, currently only used for LEADERBOARD type. */
  details?: Maybe<FormatTypeDetails>;
  /** The type of the format for the competition. */
  type: FormatType;
};

/** A Lobby in a phase. */
export type CompetitionLobby = {
   __typename?: 'CompetitionLobby';
  /** Lobby ID of lobby to advance the winner to. */
  advanceNextLobby?: Maybe<Scalars['ID']>;
  /** Unique lobby ID. */
  id: Scalars['ID'];
  /** Lobby ID of lobby to advance the loser to. */
  lossNextLobby?: Maybe<Scalars['ID']>;
  /** The participants of a lobby, and their scores. */
  participants?: Maybe<Array<CompetitionLobbyParticipant>>;
  /** The count of reported scores of the lobby. */
  reportedScoreCount: Scalars['Int'];
  /** The state of the lobby. */
  state: LobbyState;
};

/** A CompetitionLobbyParticipant, and its scores, in a lobby. */
export type CompetitionLobbyParticipant = {
   __typename?: 'CompetitionLobbyParticipant';
  /** The detailed participant associated with the lobby participant, can be a Competition Player or Competition Team. */
  detailedParticipant: CompetitionParticipant;
  /** Unique ID for CompetitionLobbyParticipant. */
  id: Scalars['ID'];
  /** The score for this participant. */
  score?: Maybe<Scalars['Int']>;
};

/** A CompetitionParticipant is either a CompetitionPlayer who is playing solo or a CompetitionTeam who plays as a team. */
export type CompetitionParticipant = CompetitionPlayer | CompetitionTeam;

/** Sorted list of competition participants. */
export type CompetitionParticipantConnection = {
   __typename?: 'CompetitionParticipantConnection';
  /** The elements of the list. */
  edges: Array<CompetitionParticipantEdge>;
  /** Are there more competition participants and what is the cursor. */
  pageInfo: PageInfo;
  /** The total amount of competition participants in the competition. */
  totalCount: Scalars['Int'];
};

/**
 * Contains information about a competition participant relationship to the paginated request,
 * and the participant themselves.
 */
export type CompetitionParticipantEdge = {
   __typename?: 'CompetitionParticipantEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** A competition participant record. */
  node: CompetitionParticipant;
};

/** The participant type signifies whether the competition will be played as team or solo. */
export enum CompetitionParticipantType {
  /** Participants are represented as a team. */
  Team = 'TEAM',
  /** Participant is represented as solo. */
  Solo = 'SOLO',
  /** Unknown participant type. */
  Unknown = 'UNKNOWN'
}

/** A Phase created by a competition organizer. */
export type CompetitionPhase = {
   __typename?: 'CompetitionPhase';
  /** Unique phase ID. */
  id: Scalars['ID'];
  /** The lobbies in a phase. */
  lobbies: Array<CompetitionLobby>;
  /** The state of the phase. It is derived on whether any of the lobbies are actively playing. */
  state: PhaseState;
};

/** A player is solo participant in a Competition. */
export type CompetitionPlayer = {
   __typename?: 'CompetitionPlayer';
  /** Competition ID player is a part of. */
  competitionID: Scalars['ID'];
  /** The time the player was added. */
  createdAt: Scalars['Time'];
  /** The discord username for the player. */
  discordUsername?: Maybe<Scalars['String']>;
  /** Unique ID for competition player. */
  id: Scalars['ID'];
  /** The in game username for the player. */
  inGameUsername?: Maybe<Scalars['String']>;
  /** The state a player has in the competition. */
  state: CompetitionPlayerState;
  /** The associated team the user is part of. */
  team?: Maybe<CompetitionTeam>;
  /** The total score for the competition player. */
  totalScore: Scalars['Int'];
  /** The associated user. */
  user: User;
};

/** Paginated list of players in a Competition. */
export type CompetitionPlayerConnection = {
   __typename?: 'CompetitionPlayerConnection';
  /** The elements of the list. */
  edges: Array<CompetitionPlayerEdge>;
  /** Are there more players in the competition and what is the cursor. */
  pageInfo: PageInfo;
  /** The total amount of players in the competition. */
  totalCount: Scalars['Int'];
};

/**
 * Contains information about a Players relationship to a given page (connection),
 * and the Player themselves.
 */
export type CompetitionPlayerEdge = {
   __typename?: 'CompetitionPlayerEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** A competition record in the list of competitions. */
  node: CompetitionPlayer;
};

/** The available initial states for a Competition Player. This should be an exact subset of CompetitionPlayerState. */
export enum CompetitionPlayerInitialState {
  /** The player has been invited. */
  Invited = 'INVITED',
  /** The player has registered to compete in this competition in the future. */
  Registered = 'REGISTERED'
}

/** The states a player can have in the competition. */
export enum CompetitionPlayerState {
  /** The player has been invited. */
  Invited = 'INVITED',
  /** The player has registered to compete in this competition in the future. */
  Registered = 'REGISTERED',
  /** The player has checked in to compete now. */
  CheckedIn = 'CHECKED_IN',
  /** The player has competed in the competition. */
  Competed = 'COMPETED',
  /** The player has declined the competition. */
  Declined = 'DECLINED',
  /** The player state is unknown. */
  Unknown = 'UNKNOWN'
}

/** The State of the Competition. */
export enum CompetitionState {
  /** Upcoming competition. */
  Upcoming = 'UPCOMING',
  /** Past competition. */
  Past = 'PAST',
  /** Live competition. */
  Live = 'LIVE',
  /** A competition that's awaiting check-ins. */
  CheckIn = 'CHECK_IN',
  /** A competition that's ready to be started. */
  Ready = 'READY',
  /** Unknown state. */
  Unknown = 'UNKNOWN'
}

/** A Team is scheduled or has competed in a Competition. */
export type CompetitionTeam = {
   __typename?: 'CompetitionTeam';
  /** The captain of the team is a Competition Player. */
  captain?: Maybe<CompetitionPlayer>;
  /** CompetitionID we are a part of. */
  competitionID: Scalars['ID'];
  /** Unique ID for competition team. */
  id: Scalars['ID'];
  /** The members of the team are Competition Players. */
  members?: Maybe<Array<CompetitionPlayer>>;
  /** The name of the competition team. */
  name: Scalars['String'];
  /** The relationship between the authenticated user and the competition team. */
  self?: Maybe<CompetitionTeamSelfEdge>;
  /** The total score for the competition team. */
  totalScore: Scalars['Int'];
};

/** List of competition teams and their scores. */
export type CompetitionTeamConnection = {
   __typename?: 'CompetitionTeamConnection';
  /** The elements of the list. */
  edges: Array<CompetitionTeamEdge>;
  /** Are there more teams in the competition and what is the cursor. */
  pageInfo: PageInfo;
  /** The total amount of teams in the competition. */
  totalCount: Scalars['Int'];
};

/**
 * Contains information about a Team relationship to a given page (connection),
 * and the Team themselves.
 */
export type CompetitionTeamEdge = {
   __typename?: 'CompetitionTeamEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** A competition team record. */
  node: CompetitionTeam;
};

/** The relationship between the authenticated user and the competition Team. */
export type CompetitionTeamSelfEdge = {
   __typename?: 'CompetitionTeamSelfEdge';
  /** Whether the user is the captain. */
  isCaptain: Scalars['Boolean'];
};

/** The required configuration to activate a component extension. */
export type ComponentActivationInput = {
  /** The slot name of where the component extension should be displayed. */
  slot: Scalars['String'];
  /**
   * The horizontal positioning of the left side of the component extension from the left side
   * of the visible video space as a fixed-point percentage (ie: 5742 would represent 57.42 percent).
   */
  x?: Maybe<Scalars['Int']>;
  /**
   * The vertical positioning of the top side of the component extension from the top side
   * of the visible video space as a fixed-point percentage (ie: 5742 would represent 57.42 percent).
   */
  y?: Maybe<Scalars['Int']>;
};

/** The view configuration of an extension if the component anchor is supported. */
export type ComponentView = ExtensionView & {
   __typename?: 'ComponentView';
  /** The developer configured height of the extension as a ratio relative to it's width. */
  aspectHeight: Scalars['Int'];
  /**
   * Specifies the width of a component extension in relation to it's targetHeight and aspectRatioY.
   * 
   * NOTE:  targetHeight and aspectRatio will replace aspectHeight and aspectWidth.
   *        however, since both will be used for a short time during the rollout of the new UI,
   *        aspectWidth and aspectHeight will not be deprecated until later.
   */
  aspectRatioX: Scalars['Int'];
  /**
   * Specifies the height of a component extension in relation to it's targetHeight and aspectRatioX.
   * 
   * NOTE:  targetHeight and aspectRatio will replace aspectHeight and aspectWidth, 
   *        however, since both will be used for a short time during the rollout of the new UI, 
   *        aspectWidth and aspectHeight will not be deprecated until later.
   */
  aspectRatioY: Scalars['Int'];
  /** The developer configured width of the extension as a ratio relative to it's height. */
  aspectWidth: Scalars['Int'];
  /** Specifies whether or not the extension has the ability to link to external websites. */
  canLinkExternalContent: Scalars['Boolean'];
  /**
   * Specifies whether to automatically scale the extension iframe using css zoom as the video 
   * player dimensions change.
   */
  hasAutoscale: Scalars['Boolean'];
  /**
   * Specifies whether CSS zooming should be applied to the CE container, creating a consistent
   * size of 1024 pixels along the long edge of the component. Default: true.
   */
  hasZoom: Scalars['Boolean'];
  /**
   * If Autoscale is true, this indicates the baseline width of the extension.
   * This fields is optional, but is required if hasAutoscale is true.
   */
  scalePixels?: Maybe<Scalars['Int']>;
  /**
   * Size of the long edge of the Component Extension, relative to the length of the corresponding
   * interactable dimension of the video.
   */
  size: Scalars['Float'];
  /**
   * The percentage of the available space (0-100) (between the top and bottom player controls) 
   * that the extension aims to consume.
   * 
   * NOTE:  targetHeight and aspectRatio will replace aspectHeight and aspectWidth, 
   *        however, since both will be used for a short time during the rollout of the new UI, 
   *        aspectWidth and aspectHeight will not be deprecated until later.
   */
  targetHeight: Scalars['Int'];
  /** Relative path of the HTML file to load for this view, used by devsite to specify the layout of assets. */
  viewerPath: Scalars['String'];
  /** The URL which should be loaded in for the extension. */
  viewerURL: Scalars['String'];
  /**
   * If hasZoom is set to true, specify the effective CSS zoom to apply to the long edge of the CE.
   * Default: 1024.
   */
  zoomPixels?: Maybe<Scalars['Int']>;
};

/** The view configuration of an extension if the component anchor is supported. */
export type ComponentViewInput = {
  /** The developer configured height of the extension as a ratio relative to it's width. */
  aspectHeight: Scalars['Int'];
  /** The developer configured width of the extension as a ratio relative to it's height. */
  aspectWidth: Scalars['Int'];
  /**
   * Specifies whether CSS zooming should be applied to the CE container, creating a consistent
   * size of 1024 pixels along the long edge of the component. Default: true.
   */
  hasZoom: Scalars['Boolean'];
  /**
   * Size of the long edge of the Component Extension, relative to the length of the corresponding
   * interactable dimension of the video.
   */
  size: Scalars['Float'];
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
  /**
   * If hasZoom is set to true, specify the effective CSS zoom to apply to the long edge of the CE.
   * Default: 1024.
   */
  zoomPixels?: Maybe<Scalars['Int']>;
};

/** ConfigView holds the view configuration of an extension if the config page is supported. */
export type ConfigView = ExtensionView & {
   __typename?: 'ConfigView';
  /** Specifies whether or not the extension has the ability to link to external websites. */
  canLinkExternalContent: Scalars['Boolean'];
  /** Relative path of the HTML file to load for this view, used by devsite to specify the layout of assets. */
  viewerPath: Scalars['String'];
  /** The URL which should be loaded in for the extension. */
  viewerURL: Scalars['String'];
};

/** ConfigViewInput holds the view configuration of an extension if the config page is supported. */
export type ConfigViewInput = {
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

/** The consent status returned for the current user. */
export type Consent = {
   __typename?: 'Consent';
  /** The unique identifier of a consent status. */
  id: Scalars['ID'];
  /** Identifier to determine whether consent is denied due to user underage. */
  isDeniedUnderage: Scalars['Boolean'];
  /** Privacy law, e.g. CCPA or GDPR. */
  privacyLawName: PrivacyLawName;
  /** Identifier to determine whether should notification to the user. */
  shouldShowNotification: Scalars['Boolean'];
  /** Identifier to determine whether should show the consent settings page to the user. */
  shouldShowSettingsPage: Scalars['Boolean'];
  /** A list of vendor consent status of a user. */
  vendorStatus: Array<VendorConsentStatus>;
};

/** ConsentStatus is the flag to show user gives or denies the consent. */
export enum ConsentStatus {
  /** User gives consent. */
  Given = 'GIVEN',
  /** User denies consent. */
  Denied = 'DENIED'
}

/** An enumeration on the different content type that enable tagging. */
export enum ContentType {
  /** Clip will enable tagging in v2. */
  Clip = 'CLIP',
  /** User is enabled for tagging in v1. */
  User = 'USER',
  LiveChannel = 'LIVE_CHANNEL',
  /** VOD will enable tagging in v2. */
  Vod = 'VOD',
  /** Games and other stream categories. */
  Category = 'CATEGORY'
}

/** CreateBitsChallengeConditionForExtensionInput creates a Bits condition on behalf of a user by an extension. */
export type CreateBitsChallengeConditionForExtensionInput = {
  /**
   * A list of the different bits recipients and their weighted share of the total bits pool once the condition is satisfied.
   * If this is not defined during condition creation, it must be defined when the condition is satisfied.
   */
  bitsRecipientWeightedShares?: Maybe<Array<BitsChallengeConditionPoolRecipientWeightedShare>>;
  /** Description of the condition. */
  description?: Maybe<Scalars['String']>;
  /** Whether to disable the condition once it has been satisfied or keep it active. */
  disableWhenSatisfied: Scalars['Boolean'];
  /** ID of the extension creating the conditional. */
  extensionID: Scalars['ID'];
  /**
   * ID of the channel where the extension is installed.
   * TODO: change to required once the extension coordinator starts sending this param.
   */
  extensionInstallationChannelID?: Maybe<Scalars['ID']>;
  /** Name of the condition. */
  name: Scalars['String'];
  /** Time when the condition should time out. */
  timeoutAt?: Maybe<Scalars['Time']>;
};

/** CreateBitsChallengeConditionForExtensionPayload returns the new condition that was created. */
export type CreateBitsChallengeConditionForExtensionPayload = {
   __typename?: 'CreateBitsChallengeConditionForExtensionPayload';
  /** The newly created condition. */
  condition?: Maybe<ChallengeCondition>;
  /** If present, there was an error in the request. */
  error?: Maybe<CreateChallengeConditionError>;
};

/**
 * CreateBitsChallengeConditionParticipantForExtensionInput creates a Bits
 * condition participant on behalf of a user by an extension.
 */
export type CreateBitsChallengeConditionParticipantForExtensionInput = {
  /** Bits quantity to be held pending condition satisfaction. */
  bitsAmount: Scalars['Int'];
  /** ID of the associated condition. */
  conditionID: Scalars['ID'];
  /** TUID of condition owner. */
  conditionOwnerID: Scalars['ID'];
  /** ID of the extension creating the conditionParticipant. */
  extensionID: Scalars['ID'];
  /** Time in seconds, after which the conditionParticipant is expired and the Bits are released (range: 1-43_200). */
  ttlSeconds: Scalars['Int'];
};

/** CreateBitsChallengeConditionParticipantForExtensionPayload returns the new condition participant that was created. */
export type CreateBitsChallengeConditionParticipantForExtensionPayload = {
   __typename?: 'CreateBitsChallengeConditionParticipantForExtensionPayload';
  /** The newly created condition participant. */
  conditionParticipant?: Maybe<ChallengeConditionParticipant>;
  /** If present, there was an error in the request. */
  error?: Maybe<CreateChallengeConditionParticipantError>;
};

/** CreateBountyCampaignInput includes the campaign that is being created. */
export type CreateBountyCampaignInput = {
  /** The platforms that the campaign applies to. */
  availablePlatforms?: Maybe<Array<Scalars['String']>>;
  /** The list of broadcaster IDs to blacklist (if any) for the campaign. */
  blacklistedBroadcasters?: Maybe<Array<Scalars['ID']>>;
  /** Optional box art URL for the campaign. */
  boxArtURL?: Maybe<Scalars['String']>;
  /** The message that will be shown to the broadcaster when they view the campaign. */
  broadcasterMessage?: Maybe<Scalars['String']>;
  /** The multiplier for the broadcaster payout rate. */
  broadcasterMultiplier: Scalars['Float'];
  /** The budget for the campaign in cents. */
  budgetCents: Scalars['Int'];
  /** The chat Calls to Action for the campaign. */
  chatCTAs?: Maybe<Array<BountyCampaignChatCtaInput>>;
  /** The ID of the content that the campaign is related to. */
  contentID?: Maybe<Scalars['ID']>;
  /** Optional cover URL for the campaign. */
  coverURL?: Maybe<Scalars['String']>;
  /** Optional display for the campaign. */
  displayName?: Maybe<Scalars['String']>;
  /** When the campaign will end. */
  endAt: Scalars['Time'];
  /** If the campaing is a promotional campaign. */
  isPromotionEligible?: Maybe<Scalars['Boolean']>;
  /** If the campaign should allow any game to be played. */
  shouldAllowAllGames?: Maybe<Scalars['Boolean']>;
  /** The optional name of the sponsor of the campaign. */
  sponsor?: Maybe<Scalars['String']>;
  /** When the campaign will start. */
  startAt: Scalars['Time'];
  /** Deprecated. How long the broadcaster needs to stream the sponsored content to complete the bounty (in minutes). */
  streamLengthMinutes?: Maybe<Scalars['Int']>;
  /** How long the broadcaster needs to stream the sponsored content to complete the bounty (in seconds). */
  streamLengthSeconds?: Maybe<Scalars['Int']>;
  /** Flag to target all broadcaters for the campaign. */
  targetAllBroadcasters?: Maybe<Scalars['Boolean']>;
  /** Flag to target all countries for the campaign. */
  targetAllCountries?: Maybe<Scalars['Boolean']>;
  /** Flag to target all games for the campaign. */
  targetAllGames?: Maybe<Scalars['Boolean']>;
  /** The click target of the campaign if it is a promotional campaign. */
  targetPromotionalVideoClicks?: Maybe<Scalars['Int']>;
  /** Flag to target variety broadcaters for the campaign. */
  targetVarietyBroadcasters?: Maybe<Scalars['Boolean']>;
  /** Targeted countries for the campaign (represented by ISO 3166-1 alpha-2). */
  targetedCountries?: Maybe<Array<Scalars['String']>>;
  /** Targeted Games (game titles) for the campaign. */
  targetedGames?: Maybe<Array<Scalars['String']>>;
  /** The title of the campaign. */
  title: Scalars['String'];
  /** The tracking URLs for this campaign. */
  trackingPixels?: Maybe<Array<TrackingPixelInput>>;
  /** The type of the campaign. */
  type?: Maybe<BountyCampaignType>;
  /** Deprecated, use videos instead. The URL of the video for this campaign. */
  videoURL?: Maybe<Scalars['String']>;
  /** The video URLS for the campaign. */
  videos?: Maybe<Array<BountyCampaignVideoInput>>;
};

/** Data that was mutated after the campaign was created. */
export type CreateBountyCampaignPayload = {
   __typename?: 'CreateBountyCampaignPayload';
  /** The campaign that was created. */
  campaign?: Maybe<BountyCampaign>;
};

/** CreateBountyCampaignUploadConfigInput is the input for create bounty campaign upload configuration. */
export type CreateBountyCampaignUploadConfigInput = {
  /** The image type to be uploaded. */
  uploadType: BountyCampaignUploadType;
};

/** Returned information about image upload including URL to upload the image to. */
export type CreateBountyCampaignUploadConfigPayload = {
   __typename?: 'CreateBountyCampaignUploadConfigPayload';
  /** Unique identifier for the image. */
  imageID?: Maybe<Scalars['ID']>;
  /** Unique identifier for the generated URL. */
  uploadID?: Maybe<Scalars['ID']>;
  /** The actual URL to be used by the client to upload the image. */
  uploadURL?: Maybe<Scalars['String']>;
};

/** Inputs for creating a new celebration. */
export type CreateCelebrationInput = {
  /** Where on the channel page the celebration will show. */
  area: CelebrationArea;
  /** Channel id to create the celebration on. */
  channelID: Scalars['ID'];
  /** Length the celebration will play. */
  durationMilliseconds: Scalars['Int'];
  /** Effect which will show when the celebration triggers (ex Fireworks). */
  effect: CelebrationEffect;
  /** Threshold which will trigger the celebration (ex: Cheering 100 Bits). */
  eventThreshold: Scalars['Int'];
  /** Event type which will trigger the celebration (ex: Cheering Bits). */
  eventType: CelebrationEventType;
  /**
   * Intensity of the celebration.
   * Should be bounded (TBA) value which will determine the spectacle of the celebration.
   */
  intensity: Scalars['Int'];
  /** If true, the celebration is enabled. */
  isEnabled: Scalars['Boolean'];
};

/** Outputs from the create celebration mutation. */
export type CreateCelebrationPayload = {
   __typename?: 'CreateCelebrationPayload';
  /** The created celebration. */
  celebration?: Maybe<Celebration>;
  /** If present, there was an error with the request. */
  error?: Maybe<CelebrationError>;
};

/** Create Challenge Condition error. */
export type CreateChallengeConditionError = {
   __typename?: 'CreateChallengeConditionError';
  /** Code describing the error. */
  code: CreateChallengeConditionErrorCode;
};

/** Create Challenge Condition error code. */
export enum CreateChallengeConditionErrorCode {
  /** User tried to create a condition with a bits recipient that is ineligible to receive bits. */
  BitsRecipientIneligible = 'BITS_RECIPIENT_INELIGIBLE',
  /** An unknown error occurred. */
  Unknown = 'UNKNOWN'
}

/** Create Challenge Condition Participant error. */
export type CreateChallengeConditionParticipantError = {
   __typename?: 'CreateChallengeConditionParticipantError';
  /** Code describing the error. */
  code: CreateChallengeConditionParticipantErrorCode;
};

/** Create Challenge Condition Participant error code. */
export enum CreateChallengeConditionParticipantErrorCode {
  /** User tried to create a condition participant with a USE_BITS effect type, but they are ineligible to use bits. */
  BitsBenefactorIneligible = 'BITS_BENEFACTOR_INELIGIBLE',
  /** User tried to create a condition participant for an inactive condition. */
  ConditionNotActive = 'CONDITION_NOT_ACTIVE',
  /** User tried to create a condition participant for a non-existent condition. */
  ConditionNotFound = 'CONDITION_NOT_FOUND',
  /** User tried to create a condition participant with an effect type that is not supported by the associated condition. */
  EffectTypeUnsupportedByCondition = 'EFFECT_TYPE_UNSUPPORTED_BY_CONDITION',
  /** An unknown error occurred. */
  Unknown = 'UNKNOWN'
}

/** CreateChanletInput creates a chanlet under the given channelID. */
export type CreateChanletInput = {
  /** The ID of the channel the chanlet should belong to. */
  channelID: Scalars['ID'];
};

/** CreateChanletPayload returns the new chanlet that was created. */
export type CreateChanletPayload = {
   __typename?: 'CreateChanletPayload';
  /** The chanlet that was created. */
  chanlet: Channel;
  /** The channelID that the chanlet was created under. */
  channelID: Scalars['ID'];
};

/** CreateClipError is an error associated with the createClip mutation. */
export type CreateClipError = {
   __typename?: 'CreateClipError';
  /** The associated error code. */
  code?: Maybe<CreateClipErrorCode>;
};

/** CreateClipErrorCode contains the possible errors that can occur when creating a clip. */
export enum CreateClipErrorCode {
  /** This channel cannot be clipped. */
  ChannelNotClippable = 'CHANNEL_NOT_CLIPPABLE',
  /** The channel has been banned and cannot be clipped. */
  ChannelBanned = 'CHANNEL_BANNED',
  /** User has been banned from the channel and cannot clip. */
  UserBanned = 'USER_BANNED',
  /** User has been timed out from the channel and cannot clip. */
  UserTimedOut = 'USER_TIMED_OUT',
  /** Clip cannot be created because channel is no longer live. */
  ChannelNotLive = 'CHANNEL_NOT_LIVE',
  /** Clip cannot be created because the request is throttled. */
  RequestThrottled = 'REQUEST_THROTTLED'
}

/**
 * CreateClipInput creates a clip either from a broadcast or video. If both broadcastID
 * and videoID are set, the broadcastID will be preferred.
 */
export type CreateClipInput = {
  /** The ID of the broadcast to create a clip from. */
  broadcastID?: Maybe<Scalars['ID']>;
  /** The ID of the broadcaster that the broadcast or video belongs to. */
  broadcasterID: Scalars['ID'];
  /** The number of seconds into the broadcast or video to create the clip from. */
  offsetSeconds: Scalars['Float'];
  /** The ID of the video to create a clip from. */
  videoID?: Maybe<Scalars['ID']>;
};

/** CreateClipPayload returns the created clip or any error that prevented the clip creation. */
export type CreateClipPayload = {
   __typename?: 'CreateClipPayload';
  /** The created clip has all fields execpt for durationSeconds and viewCount. */
  clip?: Maybe<Clip>;
  /** The error when a clip fails to create. */
  error?: Maybe<CreateClipError>;
};

/** Inputs for creating a new collection. */
export type CreateCollectionInput = {
  /** A description of the collection being created. */
  description?: Maybe<Scalars['String']>;
  /** The id of the user who will own the collection. */
  ownerID: Scalars['ID'];
  /** The title of the collection being created. */
  title: Scalars['String'];
};

/** The response from creating a new collection. */
export type CreateCollectionPayload = {
   __typename?: 'CreateCollectionPayload';
  /** The newly created collection. */
  collection?: Maybe<Collection>;
};

/** An error from creating a custom Community Points reward in a channel. */
export type CreateCommunityPointsCustomRewardError = {
   __typename?: 'CreateCommunityPointsCustomRewardError';
  /** An identifier for the error that occurred. */
  code: CreateCommunityPointsCustomRewardErrorCode;
  /** On TOO_MANY_REWARDS, the most custom rewards a channel can have. */
  maxRewards?: Maybe<Scalars['Int']>;
};

/** The possible reasons creating a custom Community Points reward in a channel could fail. */
export enum CreateCommunityPointsCustomRewardErrorCode {
  /** An unexpected error occurred. */
  Unknown = 'UNKNOWN',
  /** The current user is not allowed to create a reward in this channel. */
  Forbidden = 'FORBIDDEN',
  /** The title failed AutoMod. */
  TitleAutomodFailed = 'TITLE_AUTOMOD_FAILED',
  /** The prompt failed AutoMod. */
  PromptAutomodFailed = 'PROMPT_AUTOMOD_FAILED',
  /** The cost is invalid. Costs must be greater than 0. */
  CostInvalid = 'COST_INVALID',
  /** The background color is invalid. Backgrounds must be a valid hex color, for example "FF0000". */
  BackgroundColorInvalid = 'BACKGROUND_COLOR_INVALID',
  /** The maxPerStream is invalid. maxPerStream must be greater than 0. */
  MaxPerStreamInvalid = 'MAX_PER_STREAM_INVALID',
  /** The channel has too many rewards. An existing reward must be deleted before you can create a new reward. */
  TooManyRewards = 'TOO_MANY_REWARDS',
  /** The title is invalid. Titles must not be empty and must be at most 45 characters long. */
  TitleInvalid = 'TITLE_INVALID'
}

/** Input for creating a custom Community Points reward in a channel. */
export type CreateCommunityPointsCustomRewardInput = {
  /**
   * The optional custom background color for this reward.
   * Should be a hex color string, for example "FF0000".
   */
  backgroundColor?: Maybe<Scalars['String']>;
  /** The channel ID that the reward is being created in. */
  channelID: Scalars['ID'];
  /** The point cost of this reward. */
  cost: Scalars['Int'];
  /** Whether only subscribers are allowed to redeem this reward in this channel. */
  isSubOnly: Scalars['Boolean'];
  /** Whether this reward requires users to enter text input. */
  isUserInputRequired: Scalars['Boolean'];
  /** The most rewards of this type that can be redeemed per stream. */
  maxPerStreamSetting?: Maybe<CommunityPointsCustomRewardMaxPerStreamSettingInput>;
  /** The optional user-facing prompt for this reward. */
  prompt?: Maybe<Scalars['String']>;
  /**
   * Optional boolean for whether redemptions for this reward should skip the broadcaster's
   * request queue and get automatically fulfilled. Defaults to false.
   */
  shouldRedemptionsSkipRequestQueue?: Maybe<Scalars['Boolean']>;
  /** The short title displayed for this reward. */
  title: Scalars['String'];
};

/** The response from creating a custom Community Points reward in a channel. */
export type CreateCommunityPointsCustomRewardPayload = {
   __typename?: 'CreateCommunityPointsCustomRewardPayload';
  /** An error that occurred while creating a custom Community Points reward in a channel. */
  error?: Maybe<CreateCommunityPointsCustomRewardError>;
  /** The newly created reward. */
  reward?: Maybe<CommunityPointsCustomReward>;
};

/** An error from generating upload info for Community Points images. */
export type CreateCommunityPointsImageUploadInfoError = {
   __typename?: 'CreateCommunityPointsImageUploadInfoError';
  /** An identifier for the error that occurred. */
  code?: Maybe<CreateCommunityPointsImageUploadInfoErrorCode>;
};

/** The possible reasons generating upload info for Community Points images could fail. */
export enum CreateCommunityPointsImageUploadInfoErrorCode {
  /** The current user is not allowed to upload images for this channel. */
  Forbidden = 'FORBIDDEN',
  /** More than one image type was specified in the request. */
  MoreThanOneType = 'MORE_THAN_ONE_TYPE',
  /** Your provided custom reward ID was not found. */
  CustomRewardNotFound = 'CUSTOM_REWARD_NOT_FOUND'
}

/**
 * Input for generating upload info (urls and upload IDs) for uploading Community Points images.
 * Channel ID is required. Only one of the other three fields should be set, to indicate what the image is being uploaded for.
 */
export type CreateCommunityPointsImageUploadInfoInput = {
  /** If set, this request is for uploading new images for the given automatic reward. */
  automaticRewardType?: Maybe<CommunityPointsAutomaticRewardType>;
  /** The channel ID to upload images for. */
  channelID: Scalars['ID'];
  /** If set, this request is for uploading new images for the given custom reward. */
  customRewardID?: Maybe<Scalars['ID']>;
  /** If set, this request is for uploading new images for the channel Community Points icon. */
  icon?: Maybe<Scalars['Boolean']>;
};

/** The response from generating upload info for Community Points images. */
export type CreateCommunityPointsImageUploadInfoPayload = {
   __typename?: 'CreateCommunityPointsImageUploadInfoPayload';
  /** An error that occurred retrieving upload info for Community Points. */
  error?: Maybe<CreateCommunityPointsImageUploadInfoError>;
  /** The upload info (url and upload ID) for the large version of the image. */
  uploadInfoLarge?: Maybe<CommunityPointsImageUploadInfo>;
  /** The upload info (url and upload ID) for the medium version of the image. */
  uploadInfoMedium?: Maybe<CommunityPointsImageUploadInfo>;
  /** The upload info (url and upload ID) for the small version of the image. */
  uploadInfoSmall?: Maybe<CommunityPointsImageUploadInfo>;
};

/** The competition contact info for creates. */
export type CreateCompetitionContactInfoInput = {
  /** Link to Discord server for competition contact purposes. */
  discordURL?: Maybe<Scalars['String']>;
  /** Email address point of contact for the competition. */
  email?: Maybe<Scalars['String']>;
};

/** Create a Competition. */
export type CreateCompetitionInput = {
  /** This is the amount of time (in minutes) available for participants to check-in once competition startAt has passed. */
  checkInDurationMinutes: Scalars['Int'];
  /** Long form description of the competition. */
  description?: Maybe<Scalars['String']>;
  /** The time the competition is scheduled to end. */
  endAt: Scalars['Time'];
  /** The competition format type (i.e. enum values of LEADERBOARD, ROUND_ROBIN, SINGLE_ELIM etc.). */
  formatType: FormatType;
  /** The game_id of the game being played in the competition. */
  gameID: Scalars['ID'];
  /** Primary artwork for the competition. */
  imageURL?: Maybe<Scalars['String']>;
  /** The required inputs for leaderboard format. */
  leaderboardDetails?: Maybe<CreateCompetitionLeaderboardDetailsInput>;
  /** The name of the competition. */
  name: Scalars['String'];
  /** Owner of the Competition, or filled in as user making the request. */
  ownerID?: Maybe<Scalars['ID']>;
  /** The participant-facing points of contact for the competition that only registered players can see. */
  participantOnlyContactInfo?: Maybe<CreateCompetitionContactInfoInput>;
  /** The type of participant for the competition. e.g. SOLO, TEAM, ... */
  participantType: CompetitionParticipantType;
  /**
   * Long form text block description that explains the prizing for the competition
   * and will be converted to Markdown client-side.
   */
  prizeDescription?: Maybe<Scalars['String']>;
  /** The public points of contact for the competition that anyone can see. */
  publicContactInfo?: Maybe<CreateCompetitionContactInfoInput>;
  /** The time the competition is scheduled to end registration. */
  registrationEndAt: Scalars['Time'];
  /** The type of a registration for the competition. e.g. OPEN, INVITATIONAL, ... */
  registrationType: RegistrationType;
  /**
   * Long form text block description that explains the rules for the competition
   * and will be converted to Markdown client-side.
   */
  rulesDescription?: Maybe<Scalars['String']>;
  /** The time the competition is scheduled to start. */
  startAt: Scalars['Time'];
  /** The state the Competition. Defaults to the UPCOMING state if not specified. */
  state?: Maybe<CompetitionState>;
  /** The number of players within a single team entity. Must be 1 for solo-type competitions. */
  teamSize: Scalars['Int'];
  /** Link URL to any additional terms and conditions. */
  termsURL?: Maybe<Scalars['String']>;
};

/** The required inputs for leaderboard format. */
export type CreateCompetitionLeaderboardDetailsInput = {
  /** The max participant count for a lobby in phase. Value values are 1-100. */
  lobbyMaxSize: Scalars['Int'];
  /** The number of phases to be created for the competition. Value values are 1-100. */
  phaseCount: Scalars['Int'];
};

/** Data that was mutated after the competition was created. */
export type CreateCompetitionPayload = {
   __typename?: 'CreateCompetitionPayload';
  /** The competition that was created. */
  competition?: Maybe<Competition>;
};

/** Create new tags associated with CLIP, STREAM, or VOD with contentID. */
export type CreateContentTagsInput = {
  /** ID of the channel owning the content. */
  authorID: Scalars['ID'];
  /** ID of content: Channel ID for Streams, Slugs for Clips, and VOD ids for VODs. */
  contentID: Scalars['ID'];
  /** Type of content being returned. Can only be of values CLIP, STREAM, or VOD. */
  contentType: ContentType;
  /** List of tag IDs to be added to the content. */
  tagIDs: Array<Scalars['ID']>;
};

/** Result of mutation is the updated tags. */
export type CreateContentTagsPayload = {
   __typename?: 'CreateContentTagsPayload';
  /** Content which tags have been added to. */
  content?: Maybe<TaggedContent>;
};

/** Possible errors from CreateDropImageUploadURL. */
export enum CreateDropImageUploadUrlErrorCode {
  /** The user does not have permissions to create this type of image for this service. */
  UserUnauthorized = 'USER_UNAUTHORIZED',
  /** There was an issue calling a dependency of this call. */
  ServiceDependencyFailure = 'SERVICE_DEPENDENCY_FAILURE',
  /** An issue not matching any other specific error code. */
  Unknown = 'UNKNOWN'
}

/** Information needed to generate a URL to upload a drop image to. */
export type CreateDropImageUploadUrlInput = {
  /** The campaign this image is for if it's of type LINK_NOTIFICATION. */
  campaignID?: Maybe<Scalars['ID']>;
  /** The type of image this is. */
  imageType: DropImageType;
  /** The item ID this image is for if it's of type ITEM. */
  itemID?: Maybe<Scalars['ID']>;
  /** The drop service this image will be created for. */
  serviceID: Scalars['ID'];
  /** The JWT used to verify the request. */
  token: Scalars['String'];
};

/** Returned information about image upload including URL to upload the image to. */
export type CreateDropImageUploadUrlPayload = {
   __typename?: 'CreateDropImageUploadURLPayload';
  /** Error (if any) from trying to create the upload URL. */
  error?: Maybe<CreateDropImageUploadUrlErrorCode>;
  /** Unique identifier for the generated URL. */
  uploadID?: Maybe<Scalars['ID']>;
  /** The actual URL to be used by the client to upload the image. */
  url?: Maybe<Scalars['String']>;
};

/** CreateExtensionClientError is an error associated with the createExtensionClient mutation. */
export enum CreateExtensionClientError {
  /** The specified name was invalid. */
  InvalidName = 'INVALID_NAME',
  /** The specified name is already taken by another extension or app. */
  NameInUse = 'NAME_IN_USE'
}

/** CreateExtensionClientInput creates an extension with a given name. */
export type CreateExtensionClientInput = {
  /** name is the name of the extension client ID. */
  name: Scalars['String'];
  /** organizationID is the organization ID that the extension will be binded with in RBAC. */
  organizationID?: Maybe<Scalars['ID']>;
  /** redirectURI is the URI that can be used for OAuth login using the extension's client ID. */
  redirectURI: Scalars['String'];
};

/** CreateExtensionClientPayload returns the created extension ID. */
export type CreateExtensionClientPayload = {
   __typename?: 'CreateExtensionClientPayload';
  /** The created extension client. */
  client?: Maybe<ExtensionClient>;
  /** The error when the mutation fails to create an extension client. */
  error?: Maybe<CreateExtensionClientError>;
};

/** CreateExtensionImageUploadInfoError is wrapper for error associated with the createExtensionImageUploadInfo mutation. */
export type CreateExtensionImageUploadInfoError = {
   __typename?: 'CreateExtensionImageUploadInfoError';
  /** Error code. */
  code: CreateExtensionImageUploadInfoErrorCode;
  /**
   * On TOO_MANY_UPLOAD_DISCOVERY_IMAGE, TOO_MANY_UPLOAD_LOGO_IMAGE
   * ,TOO_MANY_UPLOAD_SCREENSHOT_IMAGE, TOO_MANY_UPLOAD_TASKBAR_IMAGE, the maximum
   * number of specific image allowed (existing + incoming).
   */
  maximum?: Maybe<Scalars['Int']>;
  /**
   * On NOT_ENOUGH_UPLOAD_DISCOVERY_IMAGE, NOT_ENOUGH_UPLOAD_LOGO_IMAGE
   * ,NOT_ENOUGH_UPLOAD_SCREENSHOT_IMAGE, NOT_ENOUGH_UPLOAD_TASKBAR_IMAGE, the
   * minimum number of screenshots allowed (existing + incoming).
   */
  minimum?: Maybe<Scalars['Int']>;
};

/** CreateExtensionImageUploadInfoErrorCode is an error code associated with CreateExtensionImageUploadInfoError. */
export enum CreateExtensionImageUploadInfoErrorCode {
  /** User is unable to make modifications to the extension. */
  Unauthorized = 'UNAUTHORIZED',
  /** Version specified is invalid. */
  InvalidVersion = 'INVALID_VERSION',
  /** Not enough discovery image to upload. Must >= 0. */
  NotEnoughUploadDiscoveryImage = 'NOT_ENOUGH_UPLOAD_DISCOVERY_IMAGE',
  /** Not enough logo image to upload. Must >= 0. */
  NotEnoughUploadLogoImage = 'NOT_ENOUGH_UPLOAD_LOGO_IMAGE',
  /** Not enough screenshot image to upload. Must >= 0. */
  NotEnoughUploadScreenshotImage = 'NOT_ENOUGH_UPLOAD_SCREENSHOT_IMAGE',
  /** Not enough taskbar image to upload. Must >= 0. */
  NotEnoughUploadTaskbarImage = 'NOT_ENOUGH_UPLOAD_TASKBAR_IMAGE',
  /** Too many discovery image to upload. Must <= 1. */
  TooManyUploadDiscoveryImage = 'TOO_MANY_UPLOAD_DISCOVERY_IMAGE',
  /** Too many logo image to upload. Must <= 1. */
  TooManyUploadLogoImage = 'TOO_MANY_UPLOAD_LOGO_IMAGE',
  /** Too many screenshot image to upload. Must <= 1. */
  TooManyUploadScreenshotImage = 'TOO_MANY_UPLOAD_SCREENSHOT_IMAGE',
  /** Too many taskbar image to upload. Must <= 1. */
  TooManyUploadTaskbarImage = 'TOO_MANY_UPLOAD_TASKBAR_IMAGE'
}

/** Information needed to generate a URL and UploadId to upload extension images to. */
export type CreateExtensionImageUploadInfoInput = {
  /** Whether to upload new discovery image. */
  discovery?: Maybe<Scalars['Boolean']>;
  /** The extension:version the images are for. */
  extensionID: Scalars['ID'];
  /** Whether to upload new logo image. */
  logo?: Maybe<Scalars['Boolean']>;
  /** Amount of new screenshot image to be uploaded. */
  screenshots?: Maybe<Scalars['Int']>;
  /** Whether to upload new taskbar image. */
  taskbar?: Maybe<Scalars['Boolean']>;
};

/** Returned information about images upload including URL to upload the image to. */
export type CreateExtensionImageUploadInfoPayload = {
   __typename?: 'CreateExtensionImageUploadInfoPayload';
  /** Url and UploadId for discovery. */
  discovery?: Maybe<ExtensionImageUploadResponse>;
  /** The error when the mutation fails to create upload information. */
  error?: Maybe<CreateExtensionImageUploadInfoError>;
  /** Url and UploadId for logo. */
  logo?: Maybe<ExtensionImageUploadResponse>;
  /** Urls and UploadIds for screenshots. */
  screenshots?: Maybe<Array<Maybe<ExtensionImageUploadResponse>>>;
  /** Url and UploadId for taskbar. */
  taskbar?: Maybe<ExtensionImageUploadResponse>;
};

/** CreateExtensionZipUploadInfoError is an error associated with the createExtensionZipUploadInfo mutation. */
export enum CreateExtensionZipUploadInfoError {
  /** User is unable to make modifications to the extension. */
  Unauthorized = 'UNAUTHORIZED',
  /** Version specified is invalid. */
  InvalidVersion = 'INVALID_VERSION'
}

/** Information needed to generate a URL and UploadId to upload extension zip file to. */
export type CreateExtensionZipUploadInfoInput = {
  /** The extension:version the zip file is for. */
  extensionID: Scalars['ID'];
  /** The file name of the zip file. */
  filename?: Maybe<Scalars['String']>;
};

/** Returned information about zip file upload including URL to upload the zip to. */
export type CreateExtensionZipUploadInfoPayload = {
   __typename?: 'CreateExtensionZipUploadInfoPayload';
  /** The error when the mutation fails to upload a zip file. */
  error?: Maybe<CreateExtensionZipUploadInfoError>;
  /** Url and UploadId for zip file. */
  response?: Maybe<ExtensionZipUploadResponse>;
};

export type CreateFriendRequestInput = {
  /** The authenticated user will send a friend request to the user with an ID equal to targetID. */
  targetID: Scalars['ID'];
};

export type CreateFriendRequestPayload = {
   __typename?: 'CreateFriendRequestPayload';
  /** The user who is the target of the friend request. */
  user?: Maybe<User>;
};

/** Error associated with mutation CreateGameApplication. */
export type CreateGameApplicationError = {
   __typename?: 'CreateGameApplicationError';
  /** Error code. */
  code?: Maybe<CreateGameApplicationErrorCode>;
};

/** Client error code. */
export enum CreateGameApplicationErrorCode {
  /** The game has already been owned by another company. */
  GameHasAlreadyBeenOwned = 'GAME_HAS_ALREADY_BEEN_OWNED',
  /** Sumbitting user does not have authorization to create a game application for the organziation. */
  PermissionDenied = 'PERMISSION_DENIED',
  /** Internal error. */
  InternalError = 'INTERNAL_ERROR'
}

/** Input to the CreateGameApplication mutation. */
export type CreateGameApplicationInput = {
  /** Company ID. */
  companyID: Scalars['ID'];
  /** Game ID. */
  gameID: Scalars['ID'];
};

/** Output from the CreateGameApplication mutation. */
export type CreateGameApplicationPayload = {
   __typename?: 'CreateGameApplicationPayload';
  /** The possible error returned from service. */
  error?: Maybe<CreateGameApplicationError>;
  /** The game application. */
  gameApplication?: Maybe<GameApplication>;
};

/** CreateLoyaltyBadge creates a new badge with these settings. */
export type CreateLoyaltyBadgeInput = {
  /** The channel ID where the badge will be uploaded. */
  channelID: Scalars['ID'];
  /** The S3 ID of the 1x sized badge. */
  image1xID: Scalars['ID'];
  /** The S3 ID of the 2x sized badge. */
  image2xID: Scalars['ID'];
  /** The S3 ID of the 4x sized badge. */
  image4xID: Scalars['ID'];
  /** The number of months of the badge. */
  requiredTenureMonths: Scalars['Int'];
};

/** CreateLoyaltyBadgePayload returns the created badge. */
export type CreateLoyaltyBadgePayload = {
   __typename?: 'CreateLoyaltyBadgePayload';
  /** The created badge. */
  badge?: Maybe<LoyaltyBadge>;
  /** A code indicating why the create call failed, if it did. */
  errorCode?: Maybe<CreateLoyaltyBadgeResponseCode>;
};

/** A code indicating why the create call failed, if it did. */
export enum CreateLoyaltyBadgeResponseCode {
  /** Only eligible users can create a badge. */
  ErrInvalidUser = 'ERR_INVALID_USER',
  /** The badge image 1x submitted was not valid. */
  ErrInvalidBadgeImage_1XId = 'ERR_INVALID_BADGE_IMAGE_1X_ID',
  /** The badge image 2x submitted was not valid. */
  ErrInvalidBadgeImage_2XId = 'ERR_INVALID_BADGE_IMAGE_2X_ID',
  /** The badge image 4x submitted was not valid. */
  ErrInvalidBadgeImage_4XId = 'ERR_INVALID_BADGE_IMAGE_4X_ID',
  /** The badge tenure submitted was not valid. */
  ErrInvalidBadgeRequiredTenureMonths = 'ERR_INVALID_BADGE_REQUIRED_TENURE_MONTHS',
  /** Badge already exists for this tenure. */
  ErrBadgeExists = 'ERR_BADGE_EXISTS',
  /** User is timed out of badge creation. */
  ErrBadgeTimeout = 'ERR_BADGE_TIMEOUT',
  /** Unknown error occurred, most likely a server error. */
  ErrUnknown = 'ERR_UNKNOWN'
}

/** CreateLoyaltyBadgeUploadConfig creates a config with URL to upload the badge image to. */
export type CreateLoyaltyBadgeUploadConfigInput = {
  /** The channel ID where the badge will be uploaded. */
  channelID: Scalars['ID'];
  /** The size of the badge. */
  size: Scalars['Int'];
};

/** CreateLoyaltyBadgeUploadConfigPayload returns the badge upload config. */
export type CreateLoyaltyBadgeUploadConfigPayload = {
   __typename?: 'CreateLoyaltyBadgeUploadConfigPayload';
  /** A code indicating why the config call failed, if it did. */
  errorCode?: Maybe<CreateLoyaltyBadgeUploadConfigResponseCode>;
  /** The badge upload config. */
  uploadConfig?: Maybe<LoyaltyBadgeUploadConfig>;
};

/** A code indicating why the config call failed, if it did. */
export enum CreateLoyaltyBadgeUploadConfigResponseCode {
  /** Only eligible users can create a badge upload config. */
  ErrInvalidUser = 'ERR_INVALID_USER',
  /** The badge submitted was not valid. */
  ErrInvalidBadgeSize = 'ERR_INVALID_BADGE_SIZE',
  /** Unknown error occurred, most likely a server error. */
  ErrUnknown = 'ERR_UNKNOWN'
}

/** The required input to create a moderator comment on a channel. */
export type CreateModeratorCommentInput = {
  /** The channel where the moderator comment was created. */
  channelID: Scalars['ID'];
  /** The target of the moderator comment. */
  targetID: Scalars['ID'];
  /** The body of the comment. */
  text: Scalars['String'];
};

/** Result of a createModeratorComment mutation. */
export type CreateModeratorCommentPayload = {
   __typename?: 'CreateModeratorCommentPayload';
  /** The moderator comment created. */
  comment?: Maybe<ModLogsComment>;
};

/** Input for creating a new highlight with multi-segment support. */
export type CreateMultiVideoHighlightInput = {
  /** Metadata used to create the highlight. */
  metadata: CreateMultiVideoHighlightMetadata;
};

/** Metadata to describe the requested highlight to be created. */
export type CreateMultiVideoHighlightMetadata = {
  /** The ID of the user who created this highlight. */
  creatorID: Scalars['ID'];
  /** The long form description of the Highlight content. */
  description: Scalars['String'];
  /** The primary game featured in the highlight, if any. */
  game?: Maybe<Scalars['ID']>;
  /** List of ordered time ranges from the source VOD used to create the highlight. */
  highlightRanges: Array<HighlightRange>;
  /** The language the highlight content is in. */
  language: Scalars['String'];
  /** Discovery tags to associate with the Highlight. */
  tags: Array<Scalars['String']>;
  /** The title of the the highlight. */
  title: Scalars['String'];
};

/** Response of highlight creation, the new highlight entering the creation process. */
export type CreateMultiVideoHighlightPayload = {
   __typename?: 'CreateMultiVideoHighlightPayload';
  /** The created Video representing the Highlight. */
  highlight?: Maybe<Video>;
};

/** Contains the channel ID to create new image upload URL for. */
export type CreateMultiviewContentAttributeImageUploadConfigInput = {
  /** The channel for which the content attribute belongs to. */
  channelID: Scalars['ID'];
};

/** Payload contains the upload ID and URL, as well as the URL to access the uploaded image. */
export type CreateMultiviewContentAttributeImageUploadConfigPayload = {
   __typename?: 'CreateMultiviewContentAttributeImageUploadConfigPayload';
  /** The channel for which the content attribute belongs to. */
  channel?: Maybe<Channel>;
  /** The URL to access this image once uploaded. */
  imageURL: Scalars['String'];
  /** Generated unique identifier for this upload. */
  uploadID: Scalars['ID'];
  /** Generated unique URL to upload the image to. */
  uploadURL: Scalars['String'];
};

/** Contains a list of new content attributes to be created. */
export type CreateMultiviewContentAttributesInput = {
  /** params is a list of multi-view content attribute params for creating new records. */
  params: Array<MultiviewContentAttributeParams>;
};

/** Contains the results from the create request. */
export type CreateMultiviewContentAttributesPayload = {
   __typename?: 'CreateMultiviewContentAttributesPayload';
  /** Unprocessed content attributes. */
  failedCreates: Array<MultiviewContentAttribute>;
  /** Processed content attributes. */
  succeededCreates: Array<MultiviewContentAttribute>;
};

/** Error associated with mutation CreateGameApplication. */
export type CreateOrganizationApplicationError = {
   __typename?: 'CreateOrganizationApplicationError';
  /** Error code. */
  code?: Maybe<CreateOrganizationApplicationErrorCode>;
};

/** Client error code. */
export enum CreateOrganizationApplicationErrorCode {
  /** Internal error. */
  InternalError = 'INTERNAL_ERROR',
  /** Invalid Argument. */
  InvalidArgument = 'INVALID_ARGUMENT'
}

/** Input to the CreateOrganizationApplication mutation. */
export type CreateOrganizationApplicationInput = {
  /** City the applying Organization is located in. e.g. San Fransico. */
  city?: Maybe<Scalars['String']>;
  /** Email of the person creating the application. */
  contactEmail: Scalars['String'];
  /** First Name of person creating the application. */
  contactFirstName: Scalars['String'];
  /** Last Name of the person creating the application. */
  contactLastName: Scalars['String'];
  /** Title of the person creating the application. e.g. Director of Sales. */
  contactTitle: Scalars['String'];
  /** Country the applying organization is located in. e.g. US. */
  country: Scalars['String'];
  /** List of game IDs that belong to the applying organization. */
  gameIDs?: Maybe<Array<Scalars['ID']>>;
  /** Industry the applying organization is operating in e.g. e-sports, gaming, health care, energy. */
  industry: Scalars['String'];
  /** Reason for wanting to add the organization. */
  joinReason?: Maybe<Scalars['String']>;
  /** The name of applying organization. */
  organizationName: Scalars['String'];
  /**
   * Indicate which Twitch products the organization wants to manage; e.g. creating
   * Drops, managing game box art, accessing game Insights.
   */
  productInterest?: Maybe<Scalars['String']>;
  /** Estimated size of the applying organization. e.g. 1-5, 6-20, 21-50, 51-100, 101-1000, and 1000+. */
  size: Scalars['String'];
  /** State the applying organization is located in. e.g. CA. */
  state?: Maybe<Scalars['String']>;
  /** The type of work the applying organization does. */
  type: OrganizationType;
  /** The Twitch ID for the user submitting the applicaton. */
  userID: Scalars['ID'];
  /** The website address for the applying organization. */
  website: Scalars['String'];
};

/** Output from the CreateGameApplication mutation. */
export type CreateOrganizationApplicationPayload = {
   __typename?: 'CreateOrganizationApplicationPayload';
  /** The organization application id. */
  applicationID?: Maybe<Scalars['ID']>;
  /** The possible error returned from service. */
  error?: Maybe<CreateOrganizationApplicationError>;
};

/** CreateOrganizationJWTError is the error associated with a CreateOrganizationJWT. */
export type CreateOrganizationJwtError = {
   __typename?: 'CreateOrganizationJWTError';
  /** The associated error code. */
  code: CreateOrganizationJwtErrorCode;
};

/** CreateOrganizationJWTErrorCode defines a client error that occurred while creating Organization JWT. */
export enum CreateOrganizationJwtErrorCode {
  /** User does not have permission to create the JWT for this operation and company. */
  PermissionDenied = 'PERMISSION_DENIED',
  /** The operation passed in was invalid. */
  InvalidArgument = 'INVALID_ARGUMENT'
}

/** Inputs to the CreateOrganizationJWT mutation. */
export type CreateOrganizationJwtInput = {
  /** Operation to be used in drops to get a jwt for. */
  operation: Scalars['String'];
  /** Organization id for which to generate the jwt. */
  organizationID: Scalars['ID'];
};

/** Outputs from the CreateOrganizationJWT mutation. */
export type CreateOrganizationJwtPayload = {
   __typename?: 'CreateOrganizationJWTPayload';
  /** The possible error returned from the service. */
  error?: Maybe<CreateOrganizationJwtError>;
  /** The new orgnizationJWT. */
  jwt?: Maybe<Scalars['String']>;
};

/** CreateOrganizationMemberError is the error associated with a CreateOrganizationMember. */
export type CreateOrganizationMemberError = {
   __typename?: 'CreateOrganizationMemberError';
  /** The associated error code. */
  code: CreateOrganizationMemberErrorCode;
};

/** CreateOrganizationMemberErrorCode defines a client error that occurred while creating an organization member. */
export enum CreateOrganizationMemberErrorCode {
  /** Organization Member already exists. */
  AlreadyExists = 'ALREADY_EXISTS',
  /** User does not have permission to perform action. */
  PermissionDenied = 'PERMISSION_DENIED',
  /** The user does not exist. */
  UserNotFound = 'USER_NOT_FOUND',
  /**
   * The user doesn't meet the requirements to have this role. For example, when trying to assign the
   * "BILLING_MANAGER" role, but the user doesn't have 2FA enabled or completed Extension Monetization Onboarding.
   */
  MemberIneligible = 'MEMBER_INELIGIBLE'
}

/** Inputs to the CreateOrganizationMember mutation. */
export type CreateOrganizationMemberInput = {
  /** Users email. */
  email: Scalars['String'];
  /** Users first name. */
  firstName: Scalars['String'];
  /** Users last name. */
  lastName: Scalars['String'];
  /** The ID of the organization. */
  organizationID: Scalars['ID'];
  /** The Role a member has in an organization. */
  role: OrganizationMemberRole;
  /** Users title. */
  title: Scalars['String'];
  /** The user's Twitch ID. */
  userID: Scalars['ID'];
};

/** Outputs from the CreateOrganizationMember mutation. */
export type CreateOrganizationMemberPayload = {
   __typename?: 'CreateOrganizationMemberPayload';
  /** The possible error returned from the service. */
  error?: Maybe<CreateOrganizationMemberError>;
  /** The new orgnizationMember. */
  organizationMember?: Maybe<OrganizationMember>;
};

/**
 * CreatePanelInput contains a panel with created data
 * The schema here has arguments for both extension panels and default panels
 * each panel needs a PanelType, and channelID it corresponds to,
 * but each panel does not need the other arguments
 * extension panels can have a slotID
 * default panels can have a title, image, link, and/or description.
 */
export type CreatePanelInput = {
  channelID: Scalars['ID'];
  description?: Maybe<Scalars['String']>;
  imageURL?: Maybe<Scalars['String']>;
  linkURL?: Maybe<Scalars['String']>;
  slotID?: Maybe<Scalars['String']>;
  title?: Maybe<Scalars['String']>;
  type: PanelType;
};

/** CreatePanelPayload contains the panel data after the create succeeds. */
export type CreatePanelPayload = {
   __typename?: 'CreatePanelPayload';
  panel: Panel;
};

/**
 * CreatePartnershipApplication accepts a userID and other parameters to create the partnership application of a given user.
 * The required input for a createPartnershipApplicationInput mutation.
 */
export type CreatePartnershipApplicationInput = {
  /**
   * Broadcast category (selected by the applicant).
   * eg: gaming, creative.
   */
  category: Scalars['String'];
  /**
   * Country from where the applicant belongs (selected by the applicant).
   * eg: US, NZ, UK.
   */
  country: Scalars['String'];
  /** Description why the applicant wants to be a partner. */
  description: Scalars['String'];
  /** First and last name of the applicant. */
  fullName: Scalars['String'];
  /** Broadcast language (selected by the applicant). */
  language: Scalars['String'];
};

/**
 * Whether or not the partnership application submission to was successful.
 * The result of a createPartnershipApplicationInput mutation.
 */
export type CreatePartnershipApplicationPayload = {
   __typename?: 'CreatePartnershipApplicationPayload';
  /**
   * A successful creation returns the partnership application.
   * A failed creation returns null.
   */
  partnershipApplication?: Maybe<PartnershipApplication>;
};

/** Inputs for creating a choice. */
export type CreatePollChoiceInput = {
  /** Title of the choice. */
  title: Scalars['String'];
};

/** Vote in poll error. */
export type CreatePollError = {
   __typename?: 'CreatePollError';
  /** Code describing the error. */
  code: CreatePollErrorCode;
};

/** Vote in poll error code. */
export enum CreatePollErrorCode {
  /** User attempted to create poll with restricted content. */
  AutomodFailed = 'AUTOMOD_FAILED',
  /** User attempted to create poll when a poll was already active. */
  PollAlreadyActive = 'POLL_ALREADY_ACTIVE',
  /** User attempted to create poll with bits on a channel where bits are not enabled. */
  ChannelNotBitsEnabled = 'CHANNEL_NOT_BITS_ENABLED',
  /** An unknown error occurred. */
  Unknown = 'UNKNOWN'
}

/** Inputs for creating a new poll. */
export type CreatePollInput = {
  /** The cost in bits for casting a vote. */
  bitsCost?: Maybe<Scalars['Int']>;
  /** Denotes if votes can be cast with bits. */
  bitsVoting?: Maybe<Scalars['Boolean']>;
  /** Choices that can be voted for in the poll. */
  choices: Array<CreatePollChoiceInput>;
  /** The cost in Community Points for casting a vote. */
  communityPointsCost?: Maybe<Scalars['Int']>;
  /** Duration of the poll in seconds. */
  durationSeconds: Scalars['Int'];
  /** Denotes if votes can be cast with Community Points. */
  isCommunityPointsVotingEnabled?: Maybe<Scalars['Boolean']>;
  /** Denotes if the poll allows voting for multiple options. */
  multichoiceEnabled?: Maybe<Scalars['Boolean']>;
  /** Id of the channel this poll is owned by. */
  ownedBy: Scalars['ID'];
  /**
   * Denotes if subscribers receives bonus votes.
   * Deprecated: Subscriber multipliers are no longer supported.
   */
  subscriberMultiplier?: Maybe<Scalars['Boolean']>;
  /**
   * Denotes if the poll is only open to subscribers.
   * Deprecated: Subscriber-only polls are no longer supported.
   */
  subscriberOnly?: Maybe<Scalars['Boolean']>;
  /** Title of the poll. */
  title: Scalars['String'];
};

/** Outputs from the create poll mutation. */
export type CreatePollPayload = {
   __typename?: 'CreatePollPayload';
  /** If present, there was an error with the request. */
  error?: Maybe<CreatePollError>;
  /** The created poll. */
  poll?: Maybe<Poll>;
};

export type CreatePostInput = {
  body: Scalars['String'];
  channelID: Scalars['ID'];
  embedURLs?: Maybe<Array<Scalars['String']>>;
  postToTwitter?: Maybe<Scalars['Boolean']>;
};

export type CreatePostPayload = {
   __typename?: 'CreatePostPayload';
  post?: Maybe<Post>;
  tweet?: Maybe<Scalars['String']>;
  tweetStatus: Scalars['Int'];
};

/** CreateRaidError is the error associated with a createRaid. */
export type CreateRaidError = {
   __typename?: 'CreateRaidError';
  /** The associated error code. */
  code: CreateRaidErrorCode;
};

/** CreateRaidErrorCode are the possible errors that this mutation returns. */
export enum CreateRaidErrorCode {
  /** The user is already raiding another channel. */
  AlreadyRaiding = 'ALREADY_RAIDING',
  /** The user tries to raid themselves. */
  CannotRaidYourself = 'CANNOT_RAID_YOURSELF',
  /** The user tries to raid an unraidable channel. */
  CannotRaidThisChannel = 'CANNOT_RAID_THIS_CHANNEL',
  /** The request is missing valid channel parameters. */
  InvalidChannel = 'INVALID_CHANNEL',
  /** The user tries to raid with too many viewers. */
  TooManyViewersToRaid = 'TOO_MANY_VIEWERS_TO_RAID'
}

/** Inputs to the createRaid mutation. */
export type CreateRaidInput = {
  /**
   * Caller is expected to be a channel owner, editor, or staff.
   * User ID of the source channel hosting the raid.
   */
  sourceID: Scalars['ID'];
  /** User ID of the target channel. */
  targetID: Scalars['ID'];
};

/** Outputs from the createRaid mutation. */
export type CreateRaidPayload = {
   __typename?: 'CreateRaidPayload';
  /** The possible error returned from the service. */
  error?: Maybe<CreateRaidError>;
  /** The created raid. */
  raid?: Maybe<Raid>;
};

/** Inputs to the createRewardedVideo mutation. */
export type CreateRewardedVideoTokenInput = {
  /** userID requesting the rewarded video token. */
  userID: Scalars['ID'];
};

/** Outputs from the createRewardedVideo mutation. */
export type CreateRewardedVideoTokenPayload = {
   __typename?: 'CreateRewardedVideoTokenPayload';
  /** token used to initialize the truex client application. */
  token?: Maybe<Scalars['String']>;
};

export type CreateRoomError = {
   __typename?: 'CreateRoomError';
  code: CreateRoomErrorCode;
  /** On MAX_ROOMS_LIMIT_EXCEEDED: Maximum number of rooms user can create. */
  maxAllowedRooms?: Maybe<Scalars['Int']>;
  /** On NAME_LENGTH_INVALID, TOPIC_LENGTH_INVALID: Maximum number of characters. */
  maxLength?: Maybe<Scalars['Int']>;
  /** On NAME_LENGTH_INVALID, TOPIC_LENGTH_INVALID: Minimum number of characters. */
  minLength?: Maybe<Scalars['Int']>;
};

export enum CreateRoomErrorCode {
  /** Name too short or too long. */
  NameLengthInvalid = 'NAME_LENGTH_INVALID',
  /** Name contains invalid characters (e.g. spaces). */
  NameContainsInvalidCharacters = 'NAME_CONTAINS_INVALID_CHARACTERS',
  /** Name failed automod check. */
  NameInappropriate = 'NAME_INAPPROPRIATE',
  /** Name was not unique to channel. */
  NameNotUnique = 'NAME_NOT_UNIQUE',
  /** Topic too short or too long. */
  TopicLengthInvalid = 'TOPIC_LENGTH_INVALID',
  /** Topic failed automod check. */
  TopicInappropriate = 'TOPIC_INAPPROPRIATE',
  /** User cannot create any more rooms. */
  MaxRoomsLimitExceeded = 'MAX_ROOMS_LIMIT_EXCEEDED',
  /** Invalid roles specified (e.g. a more permissive role for send than read). */
  RolesInvalid = 'ROLES_INVALID'
}

export type CreateRoomInput = {
  /** Deprecated. Use minimumReadMessagesRole instead. */
  isPreviewable?: Maybe<Scalars['Boolean']>;
  /** Deprecated. Use minimumReadMessagesRole and minimumSendMessagesRole instead. */
  minimumAllowedRole?: Maybe<RoomRole>;
  /** Minimum role required to read messages in the room. */
  minimumReadMessagesRole?: Maybe<RoomRole>;
  /** Minimum role required to send messages in the room. */
  minimumSendMessagesRole?: Maybe<RoomRole>;
  /** The name of the room. */
  name: Scalars['String'];
  /** The topic for the room. */
  topic: Scalars['String'];
};

export type CreateRoomPayload = {
   __typename?: 'CreateRoomPayload';
  error?: Maybe<CreateRoomError>;
  room?: Maybe<Room>;
};

/** The possible errors. */
export enum CreateScheduleError {
  /** Channel already has a schedule. */
  AlreadyExists = 'ALREADY_EXISTS',
  /** Cannot create a schedule for this channel. */
  PermissionDenied = 'PERMISSION_DENIED'
}

/** The input to create a schedule. */
export type CreateScheduleInput = {
  /** The channel ID the schedule belongs to. */
  channelID: Scalars['ID'];
};

/** The payload returned after creating a schedule. */
export type CreateSchedulePayload = {
   __typename?: 'CreateSchedulePayload';
  /** The channel with the new schedule. */
  channel?: Maybe<Channel>;
  /** The possible error. */
  error?: Maybe<CreateScheduleError>;
};

/** CreateScheduleSegmentError is a wrapper for error associated with the CreateScheduleSegment mutation. */
export type CreateScheduleSegmentError = {
   __typename?: 'CreateScheduleSegmentError';
  /** Error code. */
  code: CreateScheduleSegmentErrorCode;
  /** If the error is related to an input out of service-defined bounds, provide the maximum allowed value. */
  maximum?: Maybe<Scalars['Int']>;
  /** If the error is related to an input out of service-defined bounds, provide the miniimum allowed value. */
  minimum?: Maybe<Scalars['Int']>;
};

/** The possible errors when creating a schedule segment. */
export enum CreateScheduleSegmentErrorCode {
  /** Not authorized to edit this user schedule. */
  PermissionDenied = 'PERMISSION_DENIED',
  /** The schedule to create a segment for was not found. */
  NotFound = 'NOT_FOUND',
  /** The number of categories is invalid. Refer to the error for min and max acceptable values. */
  InvalidCategoryCount = 'INVALID_CATEGORY_COUNT',
  /** The segment time overlaps with another segment time. */
  OverlappingSegments = 'OVERLAPPING_SEGMENTS',
  /** The title length is invalid. Refer to the error for min and max acceptable values. */
  InvalidTitle = 'INVALID_TITLE',
  /** The title failed the moderation check. */
  TitleFailedModeration = 'TITLE_FAILED_MODERATION',
  /** The timezone is not valid. */
  InvalidTimezone = 'INVALID_TIMEZONE',
  /** The category is not valid. */
  InvalidCategories = 'INVALID_CATEGORIES',
  /** The the start day is not valid. */
  InvalidStartDay = 'INVALID_START_DAY',
  /** The start hour is not valid. */
  InvalidStartHour = 'INVALID_START_HOUR',
  /** The start minute is not valid. */
  InvalidStartMinute = 'INVALID_START_MINUTE',
  /** The duration is invalid. Refer to the error for min and max acceptable values. */
  InvalidDuration = 'INVALID_DURATION',
  /** The segment is invalid. */
  InvalidSegment = 'INVALID_SEGMENT',
  /** The input is not valid. */
  InvalidArgument = 'INVALID_ARGUMENT',
  /** The number of segments is invalid. Refer to the error for min and max acceptable values. */
  InvalidSegmentCount = 'INVALID_SEGMENT_COUNT'
}

/** The input to create a new schedule segment. */
export type CreateScheduleSegmentInput = {
  /** The categories of the new segment. */
  categories: Array<Scalars['ID']>;
  /** The duration of the segment in minutes. */
  durationMinutes?: Maybe<Scalars['Int']>;
  /** The ID of the schedule. */
  scheduleID: Scalars['ID'];
  /** The start time of the new segment. */
  start: SegmentStartTimeInput;
  /** The geographic timezone of the new segment defined by IANA; i.e. "America/Los_Angeles". */
  timezone: Scalars['String'];
  /** The title of the new segment. */
  title?: Maybe<Scalars['String']>;
};

/** The payload returned when creating a new schedule segment. */
export type CreateScheduleSegmentPayload = {
   __typename?: 'CreateScheduleSegmentPayload';
  /** The possible error. */
  error?: Maybe<CreateScheduleSegmentError>;
  /** The updated schedule with the created segment. */
  schedule?: Maybe<Schedule>;
};

/** CreateSocialMediaError is a user error while creating a social media. */
export enum CreateSocialMediaError {
  /** The title failed moderation. */
  FailedTitleModeration = 'FAILED_TITLE_MODERATION'
}

/** CreateSocialMediaInput creates social media under the given channelID. */
export type CreateSocialMediaInput = {
  /** The ID of the channel the social media should belong to. */
  channelID: Scalars['ID'];
  /** The visible text of the social media item. */
  title: Scalars['String'];
  /** The web address of the social media item. */
  url: Scalars['String'];
};

/** CreateSocialMediaPayload returns the new social medias that were created. */
export type CreateSocialMediaPayload = {
   __typename?: 'CreateSocialMediaPayload';
  /** The channel of the social media that was created. */
  channel?: Maybe<Channel>;
  /** The potential error when creating a social media. */
  error?: Maybe<CreateSocialMediaError>;
};

/** CreateSquadStreamInvitationError is the error associated with a createSquadStreamInvitation. */
export type CreateSquadStreamInvitationError = {
   __typename?: 'CreateSquadStreamInvitationError';
  /** The associated error code. */
  code: CreateSquadStreamInvitationErrorCode;
};

/** CreateSquadStreamInvitationErrorCode are the possible errors that this mutation returns. */
export enum CreateSquadStreamInvitationErrorCode {
  /** The squad is already full. */
  SquadFull = 'SQUAD_FULL',
  /** The recipient does not have access to squad streams. */
  UserCannotAccessSquads = 'USER_CANNOT_ACCESS_SQUADS',
  /** The recipient is already in the squad. */
  UserAlreadyInSquad = 'USER_ALREADY_IN_SQUAD',
  /** The recipient is already invited to the squad. */
  InvitationAlreadyExists = 'INVITATION_ALREADY_EXISTS',
  /** The sender does not have permission to invite the recipient. */
  InvitationBlocked = 'INVITATION_BLOCKED',
  /** The invitation is not valid (e.g. the user is inviting themselves). */
  InvitationInvalid = 'INVITATION_INVALID',
  /** The user is not authorized to invite members to the squad. */
  Unauthorized = 'UNAUTHORIZED'
}

/** Inputs to the createSquadStreamInvitation mutation. */
export type CreateSquadStreamInvitationInput = {
  /** The user ID of the broadcaster that should be invited to join the squad stream. */
  recipientUserID: Scalars['ID'];
  /** The user ID of the broadcaster that is sending the invitation to join the squad stream. */
  senderUserID: Scalars['ID'];
};

/** Outputs from the createSquadStreamInvitation mutation. */
export type CreateSquadStreamInvitationPayload = {
   __typename?: 'CreateSquadStreamInvitationPayload';
  /** The possible error returned from the service. */
  error?: Maybe<CreateSquadStreamInvitationError>;
  /** The updated squad stream. */
  squadStream?: Maybe<SquadStream>;
};

/** Inputs to creating a stucco. */
export type CreateStuccoInput = {
  /** ID of the channel this stucco belongs to. */
  channelID: Scalars['ID'];
  /** Description representing the stucco, should be the words contained in the stucco, used by screen readers. */
  description: Scalars['String'];
  /** Base64 encoded binary data of the 92x28px stucco ("1x") image asset. */
  imageData1x: Scalars['String'];
  /** Base64 encoded binary data of the 182x56px stucco ("2x") image asset. */
  imageData2x: Scalars['String'];
  /** Base64 encoded binary data of the 368x112px stucco ("4x") image asset. */
  imageData4x: Scalars['String'];
  /** Text code representing the stucco without any prefixes (prefixes are added in the backend). */
  suffix: Scalars['String'];
};

/** Inputs for creating a new stucco pack. */
export type CreateStuccoPackInput = {
  /** Id of the channel this pack is part of. */
  channelID: Scalars['ID'];
  /** Updated list of stuccos for this pack. */
  stuccos?: Maybe<Array<CreateStuccoPackItemInput>>;
};

/** Single item in a stuccopack, as part of the create stucco pack call, representing one stucco to be used in a certain slot. */
export type CreateStuccoPackItemInput = {
  /** Slot index in the pack (used for ordering). */
  slotIndex: Scalars['Int'];
  /** Id of the stucco. */
  stuccoID: Scalars['ID'];
};

/** Outputs from the create stucco pack mutation. */
export type CreateStuccoPackPayload = {
   __typename?: 'CreateStuccoPackPayload';
  /** The created stucco pack. */
  stuccoPack?: Maybe<StuccoPack>;
};

/** The output for the create update stucco mutation. */
export type CreateStuccoPayload = {
   __typename?: 'CreateStuccoPayload';
  /** The created or updated stucco. */
  stucco?: Maybe<Stucco>;
};

/** CreateVideoBookmarkError is the error associated with a createVideoBookmark. */
export type CreateVideoBookmarkError = {
   __typename?: 'CreateVideoBookmarkError';
  /** The associated error code. */
  code?: Maybe<CreateVideoBookmarkErrorCode>;
};

/** CreateVideoBookmarkErrorCode are the possible errors that this mutation returns. */
export enum CreateVideoBookmarkErrorCode {
  /** The broadcaster is not live. */
  BroadcasterNotLive = 'BROADCASTER_NOT_LIVE',
  /** Archives are disabled for the channel. */
  ArchivesDisabled = 'ARCHIVES_DISABLED',
  /** The rerun broadcast format is unsupported.. */
  BroadcastFormatInvalidRerun = 'BROADCAST_FORMAT_INVALID_RERUN',
  /** The premiere broadcast format is unsupported. */
  BroadcastFormatInvalidPremiere = 'BROADCAST_FORMAT_INVALID_PREMIERE',
  /** The VOD for the associated broadcast is not yet ready. */
  VodNotReady = 'VOD_NOT_READY',
  /** An unexpected internal server error occurred. */
  InternalServerError = 'INTERNAL_SERVER_ERROR',
  /** The user is unauthorized to create the bookmark. */
  UserUnauthorized = 'USER_UNAUTHORIZED',
  /** The description length has exceeded the max length. */
  MaxDescriptionLengthExceeded = 'MAX_DESCRIPTION_LENGTH_EXCEEDED'
}

/** Input for creating a new bookmark. */
export type CreateVideoBookmarkInput = {
  /** ID of the broadcast the bookmark is made for. */
  broadcastID?: Maybe<Scalars['ID']>;
  /** Channel ID of the channel the bookmark is made for. */
  channelID?: Maybe<Scalars['ID']>;
  /** A description for the bookmark. */
  description?: Maybe<Scalars['String']>;
  /**
   * The medium where the request came from.
   * e.g. "popout_chat", "chat", "live_dashboard_button", "live_dashboard_hotkey", "live_dashboard_chat".
   */
  medium: Scalars['String'];
  /**
   * The platform where the request came from.
   * e.g."web", "android", "ios".
   */
  platform: Scalars['String'];
};

/** Response for creating a bookmark, the bookmark that was created. */
export type CreateVideoBookmarkPayload = {
   __typename?: 'CreateVideoBookmarkPayload';
  /** Error of the create video bookmark request. */
  error?: Maybe<CreateVideoBookmarkError>;
  /** The bookmark that was created. */
  videoBookmark?: Maybe<VideoBookmark>;
};

export type CreateVideoCommentInput = {
  /** The id of the parent video comment when you reply. */
  commentID?: Maybe<Scalars['ID']>;
  /** Position of the video where this comment will be added. */
  contentOffsetSeconds: Scalars['Int'];
  /** The message of the comment. */
  message: Scalars['String'];
  /** The id of the video this comment belongs to. */
  videoID: Scalars['ID'];
};

export type CreateVideoCommentPayload = {
   __typename?: 'CreateVideoCommentPayload';
  /** The comment that was created. */
  comment: VideoComment;
};

export type CreateVideoHighlightInput = {
  /** The time in the source Archive type video that the Highlight will end at. */
  endOffsetSeconds: Scalars['Int'];
  /** Metadata to set for the highlight. */
  metadata: CreateVideoHighlightMetadata;
  /** The id of the Archive type video to create the Highlight from. */
  sourceVideoID: Scalars['ID'];
  /** The time in the source Archive type video that the Highlight will begin at. */
  startOffsetSeconds: Scalars['Int'];
};

export type CreateVideoHighlightMetadata = {
  /** The long form description of the Highlight content. */
  description: Scalars['String'];
  /** The primary game featured in the highlight, if any. */
  game?: Maybe<Scalars['ID']>;
  /** The language the highlight content is in. */
  language: Scalars['String'];
  /** Discovery tags to associate with the Highlight. */
  tags: Array<Scalars['String']>;
  /** The title of the the highlight. */
  title: Scalars['String'];
};

export type CreateVideoHighlightPayload = {
   __typename?: 'CreateVideoHighlightPayload';
  /** The created Video representing the Highlight. */
  highlight: Video;
};

/**
 * A CreatorCampArticle is a represenation of an article from 
 * https://www.twitch.tv/creatorcamp.
 */
export type CreatorCampArticle = {
   __typename?: 'CreatorCampArticle';
  /** The ID of the article is also a human readable "slug" e.g. "twitch-101". */
  id: Scalars['ID'];
  /** The locale associated with this article's translations. */
  locale: Scalars['String'];
  /** A URL pointing to an image associated with this article. */
  previewImage?: Maybe<Scalars['String']>;
  /** A short introduction for the article. */
  previewText?: Maybe<Scalars['String']>;
  /** The localized title of the article. */
  title: Scalars['String'];
  /** The cannonical location of this article on the CreatorCamp site. */
  url: Scalars['String'];
  /** The length of the article's video in seconds. */
  videoDurationSeconds?: Maybe<Scalars['Int']>;
  /**
   * A URL pointing to the embedded video in this article. Most
   * CreatorCamp articles have an assoicated video.
   */
  videoURL?: Maybe<Scalars['String']>;
};

/**
 * A CreatorCampCategory is a grouping of CreatorCamp articles.
 * https://www.twitch.tv/creatorcamp.
 */
export type CreatorCampCategory = {
   __typename?: 'CreatorCampCategory';
  /** A list of CreatorCamp articles in this category. */
  articles: Array<CreatorCampArticle>;
  /** The ID of the category is also a human-readable "slug" e.g. "learn-the-basics". */
  id: Scalars['ID'];
  /** The localized title of the category. */
  title: Scalars['String'];
};

/** Creator metrics for the given time period. */
export type CreatorMetricsByInterval = {
   __typename?: 'CreatorMetricsByInterval';
  /** Creator metrics aggregated and broken up by the interval length. */
  items?: Maybe<Array<Maybe<CreatorMetricsByIntervalItem>>>;
};

/** Creator metrics for the given time period. */
export type CreatorMetricsByIntervalItem = {
   __typename?: 'CreatorMetricsByIntervalItem';
  /** Ad breaks in seconds for the time period. */
  adBreaksInSeconds: Scalars['Int'];
  /** Ad seconds per hour for the time period. */
  adSecondsPerHour: Scalars['Float'];
  /** Average chat messages for the time period. */
  averageChatMessages: Scalars['Int'];
  /** Average of the number of chatters in the time period, weighted by time streamed. */
  averageChatters: Scalars['Int'];
  /**
   * Average of the number of chatters in the time period, weighted by time streamed.
   * @deprecated Use averageChatters instead
   */
  averageUniqueChatters: Scalars['Int'];
  /** Average viewers for the time period. */
  averageViewers: Scalars['Float'];
  /** Clips views for the time period. */
  clipViews: Scalars['Int'];
  /** Clips created for the time period. */
  clipsCreated: Scalars['Int'];
  /** Number of follows for the time period. */
  follows: Scalars['Int'];
  /** Host raids percentage for the time period. */
  hostRaidsPercentage: Scalars['Float'];
  /** Live views for the time period. */
  liveViews: Scalars['Int'];
  /** Max viewers for the time period. */
  maxViewers: Scalars['Int'];
  /** Time streamed (in minutes) for the time period. */
  minutesStreamed: Scalars['Int'];
  /** Minutes watched for the time period. */
  minutesWatched: Scalars['Int'];
  /** New subscriptions for the time period. */
  newSubscriptions: Scalars['Int'];
  /** Starting timestamp for the time period. */
  timestamp: Scalars['Time'];
  /** Total chat messages for the time period. */
  totalChatMessages: Scalars['Int'];
  /** Total chatters for the time period. */
  totalChatters: Scalars['Int'];
  /** Unique viewers for the time period. */
  uniqueViewers: Scalars['Int'];
};

/** Onboarding content and tips that are shown during the streamer onboarding experience. */
export type CreatorOnboardingContent = {
   __typename?: 'CreatorOnboardingContent';
  /** The time when the onboarding content was first shown to the user. */
  firstSeenAt?: Maybe<Scalars['Time']>;
  /** The id of the creator onboarding content. */
  id: Scalars['ID'];
};

/** A url to be shared by a creator to gain referrals, and associated metadata. */
export type CreatorReferralLink = {
   __typename?: 'CreatorReferralLink';
  /** The body text that will show on social media when the associated url is shared -- og:description. */
  description: Scalars['String'];
  /** The ID of the referral link. */
  id: Scalars['ID'];
  /** The image that will show on social media when the associated url is shared -- og:image. */
  imageURL: Scalars['String'];
  /** The title text that will show on social media when the associated url is shared -- og:title. */
  title: Scalars['String'];
  /** The url of the referral link. */
  url: Scalars['String'];
};

/** A paginated list of creator referral links. */
export type CreatorReferralLinkConnection = {
   __typename?: 'CreatorReferralLinkConnection';
  /** The list edges contain CreatorReferralLink with pagination information. */
  edges: Array<CreatorReferralLinkEdge>;
  /** Information about this page of creator referral links. */
  pageInfo: PageInfo;
};

/** An element in a paginated list of creator referral links. */
export type CreatorReferralLinkEdge = {
   __typename?: 'CreatorReferralLinkEdge';
  /** Cursor represents the position of the current edge/node. */
  cursor: Scalars['Cursor'];
  /** Node represents the creator referral link for the current edge. */
  node: CreatorReferralLink;
};

/** Contains a reference to the link object and the number of referrals from that link. */
export type CreatorReferralLinkStat = {
   __typename?: 'CreatorReferralLinkStat';
  /** The reference to the link that caused the associated number of referrals. */
  link: CreatorReferralLink;
  /** The number of referred users for the given link. */
  referralCount: Scalars['Int'];
};

/** Contains the statistics summary for creator referral link. */
export type CreatorReferralSummary = {
   __typename?: 'CreatorReferralSummary';
  /** Average referrals per day in the given date range. */
  averageReferrals: Scalars['Int'];
  /** List of data points in the summary. */
  days: Array<CreatorReferralSummaryDay>;
  /** Total referrals in the given date range. */
  totalReferrals: Scalars['Int'];
  /** Trend of the referrals per day in the given date range, when compared to the previous date range of the same length. */
  trend: CreatorReferralTrend;
};

/** Each data point contains date and list of links with number of referred users. */
export type CreatorReferralSummaryDay = {
   __typename?: 'CreatorReferralSummaryDay';
  /** The date for the enclosed data. */
  date: Scalars['Time'];
  /** List of CreatorReferralLinkStat objects on the given date. */
  linkStats: Array<CreatorReferralLinkStat>;
  /** The total number of referred users on the given date. */
  referralCountSum: Scalars['Int'];
};

/** Specifies the general trend of this data set vs the previous data set. */
export enum CreatorReferralTrend {
  /** The new data set has increased relative to the previous data set. */
  Positive = 'POSITIVE',
  /** The new data set has not changed relative to the previous data set. */
  Neutral = 'NEUTRAL',
  /** The new data set has decreased relative to the previous data set. */
  Negative = 'NEGATIVE'
}

/** Single item of stats for the time series. */
export type CreatorTimeseriesItem = {
   __typename?: 'CreatorTimeseriesItem';
  /** Streamed duration (in minutes). */
  minutesStreamed?: Maybe<Scalars['Int']>;
  /** Timestamp of the broken down time series. */
  timestamp: Scalars['Time'];
  /** Value at the timestamp. */
  value: Scalars['Float'];
};

/** List of timestamp, value metric pairs and total for that metric. */
export type CreatorTimeseriesMetric = {
   __typename?: 'CreatorTimeseriesMetric';
  /** CreatorTimeseries data (timestamp, value) associated with this metric. */
  items?: Maybe<Array<CreatorTimeseriesItem>>;
  /** Total (sum) of all CreatorTimeseriesMetrics values. */
  total: Scalars['Int'];
};

/** Metrics within a time frame broken down by granularity. */
export type CreatorTimeseriesMetrics = {
   __typename?: 'CreatorTimeseriesMetrics';
  /** Seconds of ads played per time chunk. */
  adBreaksInSeconds: CreatorTimeseriesMetric;
  /** Ad time (in seconds) per hour per time chunk. */
  adTimePerHour: CreatorTimeseriesMetric;
  /** Average number of viewers per time chunk. */
  averageViewers: CreatorTimeseriesMetric;
  /** Number of chat messages per time chunk. */
  chatMessages: CreatorTimeseriesMetric;
  /** Number of clip views per time chunk. */
  clipViews: CreatorTimeseriesMetric;
  /** Number of clips created per time chunk. */
  clipsCreated: CreatorTimeseriesMetric;
  /** Number of follows during this timestamp. */
  follows: CreatorTimeseriesMetric;
  /** Granularity of the time series, default unit is five minutes. */
  granularity: Granularity;
  /** Host/Raid viewers per time chunk. */
  hostRaidViewers: CreatorTimeseriesMetric;
  /** Live number of views per time chunk. */
  liveViews: CreatorTimeseriesMetric;
  /** Max viewers per time chunk. */
  maxViewers: CreatorTimeseriesMetric;
  /** Minutes watched per time chunk. */
  minutesWatched: CreatorTimeseriesMetric;
  /** Number of subscriptions per time chunk. */
  newSubscriptions: CreatorTimeseriesMetric;
  /** Time streamed per time chunk. */
  timeStreamed: CreatorTimeseriesMetric;
  /** Number of people chatting per time chunk. */
  uniqueChatters: CreatorTimeseriesMetric;
  /** Number of unique people watching per time chunk. */
  uniqueViewers: CreatorTimeseriesMetric;
};

/** CreditChargeModel defines a charge model using non-FIAT currencies. */
export type CreditChargeModel = {
   __typename?: 'CreditChargeModel';
  /** The value of the credit. */
  amount: Scalars['Int'];
  /** The type of credit. */
  creditType: CreditType;
};

/** Types of non-fiat currencies. */
export enum CreditType {
  /** Indicates that there is no specific type of Credit in this model. */
  NoCreditType = 'NO_CREDIT_TYPE',
  /** A sub token type. */
  SubToken = 'SUB_TOKEN'
}

/** An enumeration of currencies being accepted by PriceInfo. */
export enum Currency {
  /** United States currency. */
  Usd = 'USD',
  /** Euro currency. */
  Eur = 'EUR',
  /** Pound currency. */
  Gbp = 'GBP'
}

/** CurrentPrimePayout is the detail breakdown of the payout that will be made in this specific payout cycle. */
export type CurrentPrimePayout = {
   __typename?: 'CurrentPrimePayout';
  /** pastCyclePayoutAmount is the part of the payout that was earned in previous payout cycle(s). */
  pastCyclePayoutAmount: Scalars['Int'];
  /** thisCyclePayoutAmount is the part of the payout that was earned in this payout cycle itself. */
  thisCyclePayoutAmount: Scalars['Int'];
  /** totalPayoutAmount is the total amount for this payout. */
  totalPayoutAmount: Scalars['Int'];
};


/** An action (and metadata about the action) which occurred for a channel's Dashboard Activity Feed. */
export type DashboardActivityFeedActivity = {
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** Unique identifier for this activity. */
  id: Scalars['ID'];
  /** When this activity occurred. */
  timestamp: Scalars['Time'];
};

/** DashboardActivityFeedActivityAlertStatus are the possible alert statuses that an activity's corresponding alert can have. */
export enum DashboardActivityFeedActivityAlertStatus {
  /** The alert failed to be published. */
  Failed = 'FAILED',
  /** The alert was received when the channel was offline. */
  Offline = 'OFFLINE',
  /** The alert has been played and will not be seen again. */
  Played = 'PLAYED',
  /** The alert is currently being displayed. */
  Playing = 'PLAYING',
  /** The alert is in the alert queue, but yet to be seen. */
  Queued = 'QUEUED',
  /** The alert was not queued and will not be displayed. */
  Rejected = 'REJECTED',
  /** The alert was being displayed, but was skipped by the broadcaster. */
  Skipped = 'SKIPPED',
  /** The alert was purged from the alert queue by the broadcaster, after being queued originally. */
  Purged = 'PURGED'
}

/** When a user AutoHosts a channel. */
export type DashboardActivityFeedActivityAutoHosting = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityAutoHosting';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** User/Channel who is now AutoHosting the channel. */
  host?: Maybe<User>;
  /** Unique identifier for this AutoHosting action. */
  id: Scalars['ID'];
  /** When the host initiated the AutoHosting session. */
  timestamp: Scalars['Time'];
  /** Number of viewers from the host channel. */
  viewerCount: Scalars['Int'];
};

/** When a user uses Bits for or sends Bits to a channel. */
export type DashboardActivityFeedActivityBitsUsage = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityBitsUsage';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** Bits spent. */
  amount: Scalars['Int'];
  /** Unique identifier for this Bits usage. */
  id: Scalars['ID'];
  /**
   * Whether the Cheer was anonymized to other users.
   * If true, then `user` is guaranteed to be null.
   */
  isAnonymous: Scalars['Boolean'];
  /** When the Bits were used. */
  timestamp: Scalars['Time'];
  /** Bits spender. */
  user?: Maybe<User>;
};

/** When a user redeems a community points reward on a channel. */
export type DashboardActivityFeedActivityCommunityPointsReward = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityCommunityPointsReward';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** Unique identifier for this redemption. */
  id: Scalars['ID'];
  /** The user that redeemed the reward. */
  redeemingUser?: Maybe<User>;
  /** The redemption object itself. */
  redemption?: Maybe<CommunityPointsCustomRewardRedemption>;
  /** When the reward was redeemed. */
  timestamp: Scalars['Time'];
  /** The title of the reward. */
  title: Scalars['String'];
  /** The user's text input, if provided. */
  userInput?: Maybe<Scalars['String']>;
};

/** When a user gifts subscriptions to a community for a channel. */
export type DashboardActivityFeedActivityCommunitySubscriptionGifting = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityCommunitySubscriptionGifting';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** Total subscriptions gifted by the gifter. */
  giftQuantity: Scalars['Int'];
  /** Subscription purchaser & gifter. */
  gifter?: Maybe<User>;
  /** Unique identifier for this gifting action. */
  id: Scalars['ID'];
  /**
   * Whether the subscription gifting was anonymized to other users.
   * If true, then `gifter` is guaranteed to be null.
   */
  isAnonymous: Scalars['Boolean'];
  /**
   * Users who received the gift.
   * Maximum count is currently 100.
   * @deprecated Use giftQuantity for total subscriptions
   */
  recipients?: Maybe<Array<User>>;
  /** The gifted subscription's tier. */
  tier: SubscriptionTier;
  /** When the subscriptions were gifted. */
  timestamp: Scalars['Time'];
};

/** Paginated list of past activities for a channel's Dashboard Activity Feed. */
export type DashboardActivityFeedActivityConnection = {
   __typename?: 'DashboardActivityFeedActivityConnection';
  /** Activity elements of the list. */
  edges: Array<DashboardActivityFeedActivityEdge>;
  /** Information about this page. */
  pageInfo: PageInfo;
};

/** When a creator completes a drop quest and a drop can now be claimed by users/viewers. */
export type DashboardActivityFeedActivityDropClaimWindowOpen = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityDropClaimWindowOpen';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** The community claimable drop which has been activated. */
  drop: DropObject;
  /** Unique identifier for this drop activity. */
  id: Scalars['ID'];
  /** When the quest was completed. */
  timestamp: Scalars['Time'];
};

/** Activity element in a list of past activities of a channel's Dashboard Activity Feed. */
export type DashboardActivityFeedActivityEdge = {
   __typename?: 'DashboardActivityFeedActivityEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** Activity that occurred. */
  node: DashboardActivityFeedActivity;
};

/** When a user newly follows or refollows a channel. */
export type DashboardActivityFeedActivityFollowing = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityFollowing';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** User who is now following the channel. */
  follower?: Maybe<User>;
  /** Unique identifier for this follow action. */
  id: Scalars['ID'];
  /** When the user followed the channel. */
  timestamp: Scalars['Time'];
};

/** When a user hosts a channel. */
export type DashboardActivityFeedActivityHosting = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityHosting';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** User/Channel who is now hosting the channel. */
  host?: Maybe<User>;
  /** Unique identifier for this hosting action. */
  id: Scalars['ID'];
  /** When the host initiated the hosting session. */
  timestamp: Scalars['Time'];
  /** Number of viewers from the host channel. */
  viewerCount?: Maybe<Scalars['Int']>;
};

/** When a user gifts a single subscription to another individual user for a channel. */
export type DashboardActivityFeedActivityIndividualSubscriptionGifting = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityIndividualSubscriptionGifting';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** Subscription purchaser & gifter. */
  gifter?: Maybe<User>;
  /** Unique identifier for this gifting action. */
  id: Scalars['ID'];
  /**
   * Whether the subscription gifting was anonymized to other users.
   * If true, then `gifter` is guaranteed to be null.
   */
  isAnonymous: Scalars['Boolean'];
  /** User that received the gift. */
  recipient?: Maybe<User>;
  /** The gifted subscription's tier. */
  tier: SubscriptionTier;
  /** When the subscription was gifted. */
  timestamp: Scalars['Time'];
};

/**
 * When an ingest session begins.
 * Deprecated type: no longer exists in activity feed.
 */
export type DashboardActivityFeedActivityIngestSessionStarting = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityIngestSessionStarting';
  /**
   * Status of the corresponding alert.
   * @deprecated ingest start has been removed from activity feed
   */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /**
   * Unique identifier for the start of this ingest session.
   * @deprecated ingest start has been removed from activity feed
   */
  id: Scalars['ID'];
  /**
   * Start time of the ingest session.
   * @deprecated ingest start has been removed from activity feed
   */
  timestamp: Scalars['Time'];
};

/** When a user resubscribes via Twitch Prime to a channel. */
export type DashboardActivityFeedActivityPrimeResubscribing = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityPrimeResubscribing';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** Duration of the subscription. */
  durationMonths: Scalars['Int'];
  /** Unique identifier for the act of renewing the subscription. */
  id: Scalars['ID'];
  /**
   * Custom message submitted by the resubscribing user to share in chat.
   * @deprecated Use messageContent's fragments for enriching the text
   */
  message?: Maybe<Scalars['String']>;
  /**
   * Custom message submitted by the resubscribing user to share in chat.
   * Message is filtered for moderation and emotes are extracted as message fragments.
   */
  messageContent?: Maybe<MessageContent>;
  /** User who is renewing the subscription. */
  resubscriber?: Maybe<User>;
  /** When the subscription was renewed. */
  timestamp: Scalars['Time'];
};

/** When a user subscribes for the first time via Twitch Prime to a channel. */
export type DashboardActivityFeedActivityPrimeSubscribing = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityPrimeSubscribing';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** Unique identifier for the act of subscribing. */
  id: Scalars['ID'];
  /** User who made the subscription. */
  subscriber?: Maybe<User>;
  /** When the subscription was made. */
  timestamp: Scalars['Time'];
};

/** When a user raids a channel. */
export type DashboardActivityFeedActivityRaiding = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityRaiding';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** Unique identifier for this raiding action. */
  id: Scalars['ID'];
  /**
   * Number of users who participated in the raid.
   * @deprecated Renamed to viewerCount
   */
  partySize: Scalars['Int'];
  /** User/Channel who is now raiding the channel. */
  raider?: Maybe<User>;
  /** When the raid was initiated. */
  timestamp: Scalars['Time'];
  /** Number of users who participated in the raid. */
  viewerCount: Scalars['Int'];
};

/** When a user resubscribes (NOT via Twitch Prime) to a channel. */
export type DashboardActivityFeedActivityResubscribing = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivityResubscribing';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** Duration of the subscription. */
  durationMonths: Scalars['Int'];
  /** Unique identifier for the act of renewing the subscription. */
  id: Scalars['ID'];
  /**
   * Custom message submitted by the resubscribing user to share in chat.
   * @deprecated Use messageContent's fragments for enriching the text
   */
  message?: Maybe<Scalars['String']>;
  /**
   * Custom message submitted by the resubscribing user to share in chat.
   * Message is filtered for moderation and emotes are extracted as message fragments.
   */
  messageContent?: Maybe<MessageContent>;
  /** User who is renewing the subscription. */
  resubscriber?: Maybe<User>;
  /** Subscription tier. */
  tier: SubscriptionTier;
  /** When the subscription was renewed. */
  timestamp: Scalars['Time'];
};

/** When a user subscribes for the first time (NOT via Twitch Prime) to a channel. */
export type DashboardActivityFeedActivitySubscribing = DashboardActivityFeedActivity & {
   __typename?: 'DashboardActivityFeedActivitySubscribing';
  /** Status of the corresponding alert. */
  alertStatus?: Maybe<DashboardActivityFeedActivityAlertStatus>;
  /** Unique identifier for the act of subscribing. */
  id: Scalars['ID'];
  /** User who made the subscription. */
  subscriber?: Maybe<User>;
  /** Subscription tier. */
  tier: SubscriptionTier;
  /** When the subscription was made. */
  timestamp: Scalars['Time'];
};

/** Paginated list of past activities for a channel's Dashboard Alert Queue. */
export type DashboardAlertQueueActivityConnection = {
   __typename?: 'DashboardAlertQueueActivityConnection';
  /** Activity elements of the list. */
  edges: Array<DashboardAlertQueueActivityEdge>;
  /** Information about this page. */
  pageInfo: PageInfo;
};

/** Activity element in a list of past activities of a channel's Dashboard Alert Queue. */
export type DashboardAlertQueueActivityEdge = {
   __typename?: 'DashboardAlertQueueActivityEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** Activity that occurred. */
  node: DashboardActivityFeedActivity;
};

/** Preferences of a user controlling the types of dashboard alerts to be published. */
export type DashboardAlertQueuePreferences = {
   __typename?: 'DashboardAlertQueuePreferences';
  /** If true, cannot publish alerts to the user. */
  isDNDModeEnabled: Scalars['Boolean'];
  /** When the preferences were last modified. */
  lastModified?: Maybe<Scalars['Time']>;
  /** If true, cannot publish bits alerts to the user. */
  shouldHideBits: Scalars['Boolean'];
  /** If true, cannot publish follows alerts to the user. */
  shouldHideFollows: Scalars['Boolean'];
  /** If true, cannot publish subscription gift alerts to the user. */
  shouldHideGiftSubscriptions: Scalars['Boolean'];
  /** If true, cannot publish hosts alerts to the user. */
  shouldHideHosts: Scalars['Boolean'];
  /** If true, cannot publish raids alerts to the user. */
  shouldHideRaids: Scalars['Boolean'];
  /** If true, cannot publish regular subscriptions alerts to the user (gift subs are still shown). */
  shouldHideSubscriptions: Scalars['Boolean'];
};

/** The required input for a deactivateExtension mutation. */
export type DeactivateExtensionInput = {
  /** The composite ID of an extension installation <extensionID:version:channelID>. */
  extensionInstallationID: Scalars['ID'];
};

/** The resulting payload after a deactivateExtension mutation. */
export type DeactivateExtensionPayload = {
   __typename?: 'DeactivateExtensionPayload';
  /** The resulting extension installation record from the deactivate. */
  installedExtension: ExtensionInstallation;
};

/** DefaultPanel is the normal panel type that displays text and images. */
export type DefaultPanel = Panel & {
   __typename?: 'DefaultPanel';
  /**
   * description is markdown-formatted text to be displayed below the title and image.
   * If the panel doesn't have a description this will be null.
   */
  description?: Maybe<Scalars['String']>;
  /** id is a unique identifier for the panel. */
  id: Scalars['ID'];
  /**
   * imageURL is a URL to an image to be displayed at the top of the panel (but below the header).
   * If the panel doesn't use an image this will be null.
   */
  imageURL?: Maybe<Scalars['String']>;
  /**
   * linkURL is the URL to navigate to when a user clicks on the image.
   * If the panel's image doesn't link anywhere this will be null.
   */
  linkURL?: Maybe<Scalars['String']>;
  /**
   * title is the header text to display in the panel.
   * If the panel doesn't have a title this will return null.
   */
  title?: Maybe<Scalars['String']>;
  /** type is `PanelType.DEFAULT`. */
  type: PanelType;
};

/** DeferredPrimePayout is the earning that has been deferred to future payout cycles. */
export type DeferredPrimePayout = {
   __typename?: 'DeferredPrimePayout';
  /** totalPayoutAmount is the total amount for this payout. */
  totalPayoutAmount: Scalars['Int'];
};

/** The input for delete bits badge tier emoticon. */
export type DeleteBitsBadgeTierEmoticonInput = {
  /** channelID is the owner of the emoticon being deleted. */
  channelID: Scalars['ID'];
  /** emoteID is the unique identifier for the emote. */
  emoteID: Scalars['ID'];
  /**
   * The visual representation of the emote.
   * For example, "O_o" instead of "(O|o)_(o|O)".
   */
  text: Scalars['String'];
  /** threshold is the badge tier threshold associated with this emoticon. */
  threshold: Scalars['Int'];
};

/** Result of delete bits badge tier emoticon. */
export type DeleteBitsBadgeTierEmoticonPayload = {
   __typename?: 'DeleteBitsBadgeTierEmoticonPayload';
  /** Time that the emoticon got deleted. */
  deletedAt?: Maybe<Scalars['Time']>;
};

/** Inputs for deleting a celebration. */
export type DeleteCelebrationInput = {
  /** ID of celebration to delete. */
  celebrationID: Scalars['ID'];
  /** ID of channel where the celebration to delete exists. */
  channelID: Scalars['ID'];
};

/** Outputs from the create celebration mutation. */
export type DeleteCelebrationPayload = {
   __typename?: 'DeleteCelebrationPayload';
  /** If present, there was an error with the request. */
  error?: Maybe<CelebrationError>;
};

/** Errors that the mutation returns. */
export type DeleteChannelBlockedTermError = {
   __typename?: 'DeleteChannelBlockedTermError';
  /** The error code that the mutation returned. */
  code: DeleteChannelBlockedTermErrorCode;
};

/** The errors returned from this mutation. */
export enum DeleteChannelBlockedTermErrorCode {
  /** User does not have permission to delete blocked term in channel. */
  NoPermissions = 'NO_PERMISSIONS'
}

/** Inputs for the mutation. channel ID and a list of phrases to be deleted. */
export type DeleteChannelBlockedTermInput = {
  /** channelID is the owner of the term being deleted. */
  channelID: Scalars['ID'];
  /** phrases is the strings representation of the term being deleted. */
  phrases: Array<Scalars['String']>;
};

/** The returned payload from the mutation. */
export type DeleteChannelBlockedTermPayload = {
   __typename?: 'DeleteChannelBlockedTermPayload';
  /** The time term was deleted. */
  deletedAt?: Maybe<Scalars['Time']>;
  /** Mutation error caused by the user input. */
  error?: Maybe<DeleteChannelBlockedTermError>;
  /** The phrases that were deleted. */
  phrases: Array<Scalars['String']>;
};

/** The errors returned from this mutation. */
export type DeleteChannelPermittedTermError = {
   __typename?: 'DeleteChannelPermittedTermError';
  /** Error code that was returned. */
  code: DeleteChannelPermittedTermErrorCode;
};

/** The possible error types returned from this mutation. */
export enum DeleteChannelPermittedTermErrorCode {
  /** User does not have permission to delete Permitted term in channel. */
  NoPermissions = 'NO_PERMISSIONS'
}

/** Inputs for the mutation. channel ID and a list of phrases to be deleted. */
export type DeleteChannelPermittedTermInput = {
  /** channelID is the ID of the owner of the permitted term being deleted. */
  channelID: Scalars['ID'];
  /** phrases is the string representation of the term being deleted. */
  phrases: Array<Scalars['String']>;
};

/** Returned payload of the mutation. */
export type DeleteChannelPermittedTermPayload = {
   __typename?: 'DeleteChannelPermittedTermPayload';
  /** The time term was deleted. */
  deletedAt?: Maybe<Scalars['Time']>;
  /** Mutation error caused by the user input. */
  error?: Maybe<DeleteChannelPermittedTermError>;
  /** The phrases that were deleted. */
  phrases: Array<Scalars['String']>;
};

/** The input for deleteChatMessage. */
export type DeleteChatMessageInput = {
  /** The channel the message was sent in. */
  channelID: Scalars['ID'];
  /** The UUID of the message to be deleted. */
  messageID: Scalars['ID'];
};

/** The returned payload for deleteChatMessage. */
export type DeleteChatMessagePayload = {
   __typename?: 'DeleteChatMessagePayload';
  /** The returned message. */
  message?: Maybe<DeletedMessage>;
  /** The response codes for this mutation. */
  responseCode: DeleteChatMessageStatusCode;
};

/** The response codes for this mutation. */
export enum DeleteChatMessageStatusCode {
  /** Deletion was successful. */
  Success = 'SUCCESS',
  /** Deletion was successful. Target user is staff. */
  SuccessStaff = 'SUCCESS_STAFF',
  /** User does not have permission to delete messages. */
  Forbidden = 'FORBIDDEN',
  /** Target is the broadcaster. */
  TargetIsBroadcaster = 'TARGET_IS_BROADCASTER',
  /** Target is another moderator. */
  TargetIsModerator = 'TARGET_IS_MODERATOR'
}

/**
 * DeleteClipsInput accepts either a list of slugs, a video id, or a broadcast id
 * to determine the clips to delete.
 */
export type DeleteClipsInput = {
  /** The id of the broadcast to delete clips from. */
  broadcastID?: Maybe<Scalars['ID']>;
  /** The list of clip slugs to be deleted. */
  slugs?: Maybe<Array<Scalars['ID']>>;
  /** The id of the video to delete clips from. */
  videoID?: Maybe<Scalars['ID']>;
};

/**
 * DeleteClipsPayload returns the deleted clips. Only the slug and id can be accessed
 * from the returned list of deleted clips.
 */
export type DeleteClipsPayload = {
   __typename?: 'DeleteClipsPayload';
  /** The clips that were deleted. Only Slug and ID can be accessed. */
  clips: Array<Maybe<Clip>>;
  /** The amount of clips that were deleted. */
  count: Scalars['Int'];
};

/** DeleteCollectionInput accepts a collection ID to delete a collection. */
export type DeleteCollectionInput = {
  /** The id of the collection to be deleted. */
  collectionID: Scalars['ID'];
};

/** DeleteCollectionPayload resolves the deleted collection. */
export type DeleteCollectionPayload = {
   __typename?: 'DeleteCollectionPayload';
  /** The collection that was just deleted. */
  collection: Collection;
};

/** An error from deleting a custom Community Points reward in a channel. */
export type DeleteCommunityPointsCustomRewardError = {
   __typename?: 'DeleteCommunityPointsCustomRewardError';
  /** An identifier for the error that occurred. */
  code: DeleteCommunityPointsCustomRewardErrorCode;
};

/** The possible reasons deleting a custom Community Points reward in a channel could fail. */
export enum DeleteCommunityPointsCustomRewardErrorCode {
  /** An unexpected error occurred. */
  Unknown = 'UNKNOWN',
  /** The current user is not allowed to delete a reward in this channel. */
  Forbidden = 'FORBIDDEN',
  /** The reward was not found. */
  NotFound = 'NOT_FOUND'
}

/** Input for deleting a custom Community Points reward in a channel. */
export type DeleteCommunityPointsCustomRewardInput = {
  /** The channel ID that the reward is being deleted in. */
  channelID: Scalars['ID'];
  /** The ID of the reward being deleted. */
  rewardID: Scalars['ID'];
  /**
   * Rewards cannot be deleted while they have unfulfilled redemptions.
   * All unfulfilled redemptions will be set to this new state asynchronously after the reward is deleted.
   */
  unfulfilledRedemptionsNewStatus?: Maybe<CommunityPointsCustomRewardRedemptionStatus>;
};

/** The response from deleting a custom Community Points reward in a channel. */
export type DeleteCommunityPointsCustomRewardPayload = {
   __typename?: 'DeleteCommunityPointsCustomRewardPayload';
  /** An error that occurred while deleting a custom Community Points reward in a channel. */
  error?: Maybe<DeleteCommunityPointsCustomRewardError>;
  /** The now deleted reward. */
  reward?: Maybe<CommunityPointsCustomReward>;
};

/** Delete a Competition. */
export type DeleteCompetitionInput = {
  /** Unique Competition Id. */
  id: Scalars['ID'];
};

/** Result of the remove operation. */
export type DeleteCompetitionPayload = {
   __typename?: 'DeleteCompetitionPayload';
  /** The deleted competition. */
  competition?: Maybe<Competition>;
};

/** Delete tags associated with CLIP, STREAM, or VOD with contentID. */
export type DeleteContentTagsInput = {
  /** ID of the channel owning the content. */
  authorID: Scalars['ID'];
  /** ID of content: Channel ID for Streams, Slugs for Clips, and VOD ids for VODs. */
  contentID: Scalars['ID'];
  /** Type of content being returned. Can only be of values CLIP, STREAM, or VOD. */
  contentType: ContentType;
  /** List of tag IDs to be deleted from the content. */
  tagIDs: Array<Scalars['ID']>;
};

/** Result of mutation is the contentID. */
export type DeleteContentTagsPayload = {
   __typename?: 'DeleteContentTagsPayload';
  /** Content which tags have been deleted from. */
  content?: Maybe<TaggedContent>;
};

/** The input required when making a request to delete a user's default payment method for a given provider. */
export type DeleteDefaultPaymentMethodInput = {
  /** The payment provider we're deleting the payment method on. */
  provider: PaymentProvider;
  /** The user to delete default payment method for. */
  userID: Scalars['ID'];
};

/** Payload returned after deleting a default payment method for a given provider. */
export type DeleteDefaultPaymentMethodPayload = {
   __typename?: 'DeleteDefaultPaymentMethodPayload';
  /** Time when payment method was deleted. */
  updatedAt?: Maybe<Scalars['Time']>;
  /** User who had their default payment method deleted. */
  user?: Maybe<User>;
};

/** DeleteDeviceTokenInput accepts a token and user ID and deletes that pair from the database. */
export type DeleteDeviceTokenInput = {
  /** The token to be deleted. */
  deviceToken: Scalars['ID'];
  /** ID for the user associated with the device token. */
  userID: Scalars['ID'];
};

/** The response from deleting a push notification token from a user. */
export type DeleteDeviceTokenPayload = {
   __typename?: 'DeleteDeviceTokenPayload';
  /** The ID of the token that was deleted. */
  deviceToken: Scalars['ID'];
};

/** A deleted message sent by a user to a stream chat. */
export type DeletedMessage = {
   __typename?: 'DeletedMessage';
  /** Content of the deleted message. */
  content: RoomMessageContent;
  /** UUID of the deleted message. */
  id: Scalars['ID'];
  /** Sender of the message. */
  sender?: Maybe<User>;
};

/** DeletedMessageDisplaySetting represents the possible settings for how deleted messages should be displayed. */
export enum DeletedMessageDisplaySetting {
  /** LEGACY hides deleted messages behind a clickable '<message_deleted>' chat line. */
  Legacy = 'LEGACY',
  /** BRIEF removes all deleted messages and inserts a system message that reports the number of deleted messages. */
  Brief = 'BRIEF',
  /** DETAILED the deleted message is readable but strikethrough and grayed out. */
  Detailed = 'DETAILED'
}

/** Error types returned for the deleteExtension mutation. */
export enum DeleteExtensionError {
  /** Returned when the extension id was not specified. */
  MissingExtensionId = 'MISSING_EXTENSION_ID',
  /** Returned when the id specified could not be found. */
  ExtensionNotFound = 'EXTENSION_NOT_FOUND',
  /** Returned when the calling user does not have access to delete the extension. */
  Unauthorized = 'UNAUTHORIZED'
}

/** DeleteExtensionImageError is an error associated with the deleteExtensionImage mutation. */
export enum DeleteExtensionImageError {
  /** User is unable to make modifications to the extension. */
  Unauthorized = 'UNAUTHORIZED',
  /** Version specified is invalid. */
  InvalidVersion = 'INVALID_VERSION',
  /** Cannot find url in the manifest. */
  CannotFindUrlInManifest = 'CANNOT_FIND_URL_IN_MANIFEST',
  /** Invalid image url. */
  InvalidImageUrl = 'INVALID_IMAGE_URL'
}

/** Information needed to delete images on extension. */
export type DeleteExtensionImageInput = {
  /** The extension:version the images are for. */
  extensionID: Scalars['ID'];
  /** Urls to be deleted. */
  urls: Array<Scalars['String']>;
};

/** DeleteExtensionImagePayload returns the update Extension manifest. */
export type DeleteExtensionImagePayload = {
   __typename?: 'DeleteExtensionImagePayload';
  /** The error when the mutation fails to update an extension. */
  error?: Maybe<DeleteExtensionImageError>;
  /** The updated extension manifest. */
  manifest?: Maybe<ExtensionManifest>;
};

/** Inputs for the deleteExtension mutation. */
export type DeleteExtensionInput = {
  /** ID for the extension being deleted. */
  id: Scalars['ID'];
};

/** The returned payload from the deleteExtension mutation. */
export type DeleteExtensionPayload = {
   __typename?: 'DeleteExtensionPayload';
  /**
   * Error response from the deleteExtension mutation.
   * null if the delete was successful.
   */
  error?: Maybe<DeleteExtensionError>;
};

/** Inputs for the mutation. Loyalty Badge to be deleted by channelID, badgeID, and channelTenureMethodID. */
export type DeleteLoyaltyBadgeInput = {
  /** badgeID correlated to the badge being deleted. */
  badgeID: Scalars['ID'];
  /** channelID correlated to the badge being deleted. */
  channelID: Scalars['ID'];
  /** channelTenureMethodID uniquely identifies the badge being deleted. */
  channelTenureMethodID: Scalars['ID'];
};

/** The returned payload from the mutation for Deleting a Loyalty Badge. */
export type DeleteLoyaltyBadgePayload = {
   __typename?: 'DeleteLoyaltyBadgePayload';
  /** LoyaltyBadge object that was deleted. */
  badge?: Maybe<LoyaltyBadge>;
};

/** Output from the DeleteModeratorComment mutation. */
export type DeleteModeratorCommentInput = {
  /** ID of the comment to be deleted. */
  ID: Scalars['ID'];
};

/** Output from the DeleteModeratorComment mutation. */
export type DeleteModeratorCommentPayload = {
   __typename?: 'DeleteModeratorCommentPayload';
  /** The deleted comment. */
  comment?: Maybe<ModLogsComment>;
};

/** Contains a list of IDs of content attributes that are to be deleted. */
export type DeleteMultiviewContentAttributesInput = {
  /** A list of content attribute IDs. */
  IDs: Array<Scalars['ID']>;
};

/** Contains the results from the delete request. */
export type DeleteMultiviewContentAttributesPayload = {
   __typename?: 'DeleteMultiviewContentAttributesPayload';
  /** Unprocessed content attributes. */
  failedDeletes: Array<MultiviewContentAttribute>;
  /** Processed content attributes. */
  succeededDeletes: Array<MultiviewContentAttribute>;
};

export type DeleteNotificationInput = {
  /** The notification to delete. */
  id: Scalars['ID'];
};

export type DeleteNotificationPayload = {
   __typename?: 'DeleteNotificationPayload';
  /** The notification that was deleted. Only the ID is accessible. */
  notification: OnsiteNotification;
};

export type DeletePanelInput = {
  id: Scalars['ID'];
};

export type DeletePanelPayload = {
   __typename?: 'DeletePanelPayload';
  panel: Panel;
};

export type DeletePostInput = {
  postID: Scalars['ID'];
};

export type DeletePostPayload = {
   __typename?: 'DeletePostPayload';
  post?: Maybe<Post>;
};

/** Data required to delete recommendation feedback. */
export type DeleteRecommendationFeedbackInput = {
  /** The id of the feedback. */
  feedbackID: Scalars['ID'];
  /** The page this event was fired from. */
  sourceItemPage: Scalars['String'];
};

/** Returns the created feedback item back to the client. */
export type DeleteRecommendationFeedbackPayload = {
   __typename?: 'DeleteRecommendationFeedbackPayload';
  /** The id of the feedback you just deleted. */
  feedbackID: Scalars['ID'];
};

export type DeleteRoomInput = {
  roomID: Scalars['ID'];
};

export type DeleteRoomMessageInput = {
  messageID: Scalars['ID'];
  roomID: Scalars['ID'];
};

export type DeleteRoomMessagePayload = {
   __typename?: 'DeleteRoomMessagePayload';
  message?: Maybe<RoomMessage>;
};

export type DeleteRoomPayload = {
   __typename?: 'DeleteRoomPayload';
  room?: Maybe<Room>;
};

/** The possible errors when deleting a schedule. */
export enum DeleteScheduleError {
  /** Not authorized to delete this user schedule. */
  PermissionDenied = 'PERMISSION_DENIED'
}

/** The input to delete a schedule. */
export type DeleteScheduleInput = {
  /** The channel ID. */
  channelID: Scalars['ID'];
  /** The schedule ID. */
  scheduleID: Scalars['ID'];
};

/** The payload returned after deleting a schedule. */
export type DeleteSchedulePayload = {
   __typename?: 'DeleteSchedulePayload';
  /** The channel with the deleted schedule. */
  channel?: Maybe<Channel>;
  /** The possible error. */
  error?: Maybe<DeleteScheduleError>;
};

/** The possible errors when deleting a schedule segment. */
export enum DeleteScheduleSegmentError {
  /** Not authorized to delete this segment. */
  PermissionDenied = 'PERMISSION_DENIED'
}

/** The input to delete a schedule segment. */
export type DeleteScheduleSegmentInput = {
  /** The schedule id. */
  scheduleID: Scalars['ID'];
  /** The segment id to delete. */
  segmentID: Scalars['ID'];
};

/** The returned payload when deleting a schedule segment. */
export type DeleteScheduleSegmentPayload = {
   __typename?: 'DeleteScheduleSegmentPayload';
  /** The possible error. */
  error?: Maybe<DeleteScheduleSegmentError>;
  /** The updated schedule without the deleted segment. */
  schedule?: Maybe<Schedule>;
};

/** Mutation input to delete a social media item by ID under the given channelID. */
export type DeleteSocialMediaInput = {
  /** The ID of the channel the social media belongs to. */
  channelID: Scalars['ID'];
  /** The ID of the social media item. */
  id: Scalars['ID'];
};

/** DeleteSocialMediaPayload returns an error, if any. */
export type DeleteSocialMediaPayload = {
   __typename?: 'DeleteSocialMediaPayload';
  /** The channel of the social media that was deleted. */
  channel?: Maybe<Channel>;
};

/** Errors from deleteSquadStreamInvitation mutation. */
export type DeleteSquadStreamInvitationError = {
   __typename?: 'DeleteSquadStreamInvitationError';
  /** Error from request to delete invitation. */
  code: DeleteSquadStreamInvitationErrorCode;
};

/** Possible errors that this mutation returns. */
export enum DeleteSquadStreamInvitationErrorCode {
  /** Invitation to be deleted does not exist. */
  InvitationNotFound = 'INVITATION_NOT_FOUND',
  /** Squad associated with the invitation does not exist. */
  SquadNotFound = 'SQUAD_NOT_FOUND',
  /** User does not have permissions to delete invitation. */
  Unauthorized = 'UNAUTHORIZED',
  /** Invitation not in pending or rejected state cannot be deleted. */
  InvitationCannotBeDeleted = 'INVITATION_CANNOT_BE_DELETED'
}

/** Inputs to the deleteSquadStreamInvitation mutation. */
export type DeleteSquadStreamInvitationInput = {
  /** ID of the invitation to be deleted. */
  invitationID: Scalars['ID'];
};

/** Outputs from the deleteSquadStreamInvitation mutation. */
export type DeleteSquadStreamInvitationPayload = {
   __typename?: 'DeleteSquadStreamInvitationPayload';
  /** Error from mutation if exists. */
  error?: Maybe<DeleteSquadStreamInvitationError>;
  /** The deleted invitation. */
  invitation?: Maybe<SquadStreamInvitation>;
};

/** Error that may be returned by the DeleteStreamAuthorizedUser mutation. */
export type DeleteStreamAuthorizedUserError = {
   __typename?: 'DeleteStreamAuthorizedUserError';
  /** Type of mutation error. */
  code: DeleteStreamAuthorizedUserErrorCode;
};

/** DeleteStreamAuthorizedUserErrorCode is the client error type that occurred during the DeleteStreamAuthorizedUser mutation. */
export enum DeleteStreamAuthorizedUserErrorCode {
  /** Unable to assign the Targeted user to stream on behalf of the broadcaster. */
  TargetUserUnreturnable = 'TARGET_USER_UNRETURNABLE',
  /** The broadcaster is not found. */
  ChannelNotFound = 'CHANNEL_NOT_FOUND',
  /** Maximum limit for adding authorized user is reached. */
  MaxAccountLimit = 'MAX_ACCOUNT_LIMIT',
  /** Permission denied to add an authorized user. */
  PermissionDenied = 'PERMISSION_DENIED',
  /** Invalid argument to add an authorized user. */
  InvalidArgument = 'INVALID_ARGUMENT'
}

/** DeleteStreamAuthorizedUserInput contains the channelID for the broadcaster and the authorized userID. */
export type DeleteStreamAuthorizedUserInput = {
  /** authorizedUserID for an authorized user who was allowed to stream on behalf of broadcaster. */
  authorizedUserID: Scalars['ID'];
  /** channelID of the broadcaster. */
  channelID: Scalars['ID'];
};

/** DeleteStreamAuthorizedUserPayload contains the VideoStreamSettings with updated authorized users. */
export type DeleteStreamAuthorizedUserPayload = {
   __typename?: 'DeleteStreamAuthorizedUserPayload';
  /** The updated channel of broadcaster. */
  channel?: Maybe<Channel>;
  /** Error code. */
  error?: Maybe<AddStreamAuthorizedUserError>;
};

/** Inputs for the DeleteUserColors mutation. */
export type DeleteUserColorsInput = {
  /** The ID of the user whose creator color is being deleted. */
  userID: Scalars['ID'];
};

/** The returned payload from the DeleteUserColors mutation. */
export type DeleteUserColorsPayload = {
   __typename?: 'DeleteUserColorsPayload';
  /** The modified user. */
  user?: Maybe<User>;
};

export type DeleteVideoCommentPayload = {
   __typename?: 'DeleteVideoCommentPayload';
  /** The comment that was deleted. */
  comment: VideoComment;
};

export type DenyRejectedChatMessageInput = {
  id: Scalars['ID'];
};

export type DenyRejectedChatMessagePayload = {
   __typename?: 'DenyRejectedChatMessagePayload';
  message?: Maybe<RejectedChatMessage>;
};

/** Input to the denyRejectedCheer mutation. */
export type DenyRejectedCheerInput = {
  /**
   * Client-generated unique ID used to prevent a cheer from being re-sent (thus spending double bits).
   * The server will reject any request with an ID that has already been used.
   */
  id: Scalars['ID'];
  /** ID of the user whose message is automodded. */
  targetUserID: Scalars['ID'];
};

/** Payload from the denyRejectedCheer mutation. */
export type DenyRejectedCheerPayload = {
   __typename?: 'DenyRejectedCheerPayload';
  /**
   * Client-generated unique ID used to prevent a cheer from being re-sent (thus spending double bits).
   * The server will reject any request with an ID that has already been used.
   */
  id: Scalars['ID'];
};

/** Inputs for deselecting a channel badge. */
export type DeselectChannelBadgeInput = {
  /** ID of the channel this badge is selected on. */
  channelID: Scalars['ID'];
};

/** The output for the deselect channel badge mutation. */
export type DeselectChannelBadgePayload = {
   __typename?: 'DeselectChannelBadgePayload';
  /** The channel (user object of channel) this badge is deselected on. */
  user?: Maybe<User>;
};

/** The output for the deselect global badge mutation. */
export type DeselectGlobalBadgePayload = {
   __typename?: 'DeselectGlobalBadgePayload';
  /** The user (contains the badge status). */
  user?: Maybe<User>;
};

/** A Directory is a container of content – Streams, Videos, and Clips – on Twitch. */
export type Directory = {
  /**
   * URL to an avatar image.
   * The image dimensions are specifiable via the `height` and `width` parameters.
   * 
   * If `height` or `width` are not specified, the URL will contain
   * the template strings `{height}` and/or `{width}` in their respective places.
   */
  avatarURL?: Maybe<Scalars['String']>;
  /** Number of broadcasters currently broadcasting in this directory. */
  broadcastersCount?: Maybe<Scalars['Int']>;
  /**
   * URL to a cover image.
   * The image dimensions are specifiable via the `height` and `width` parameters.
   * 
   * If `height` or `width` are not specified, the URL will contain
   * the template strings `{height}` and/or `{width}` in their respective places.
   */
  coverURL?: Maybe<Scalars['String']>;
  /** The type of directory – community or game. */
  directoryType?: Maybe<DirectoryType>;
  /** The name to display for the directory. */
  displayName: Scalars['String'];
  /** Number of users that follow this directory. */
  followersCount?: Maybe<Scalars['Int']>;
  /** The directory's unique Twitch identifier. */
  id: Scalars['ID'];
  /** The canonical name of the directory. */
  name: Scalars['String'];
  /**
   * Get a page of live streams broadcasting in this directory.
   * If no language filters are provided all languages will be returned.
   * Tags are an array of tag ID as optional filters for streams.
   */
  streams?: Maybe<StreamConnection>;
  /** Number of viewers currently watching a stream which is in this directory. */
  viewersCount?: Maybe<Scalars['Int']>;
};


/** A Directory is a container of content – Streams, Videos, and Clips – on Twitch. */
export type DirectoryAvatarUrlArgs = {
  width?: Maybe<Scalars['Int']>;
  height?: Maybe<Scalars['Int']>;
};


/** A Directory is a container of content – Streams, Videos, and Clips – on Twitch. */
export type DirectoryCoverUrlArgs = {
  width?: Maybe<Scalars['Int']>;
  height?: Maybe<Scalars['Int']>;
};


/** A Directory is a container of content – Streams, Videos, and Clips – on Twitch. */
export type DirectoryStreamsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  languages?: Maybe<Array<Scalars['String']>>;
  tags?: Maybe<Array<Scalars['String']>>;
};

/**
 * Paginated list of Directories.
 * Implements the Relay cursor connections specification.
 * See: https://facebook.github.io/relay/graphql/connections.htm.
 */
export type DirectoryConnection = {
   __typename?: 'DirectoryConnection';
  edges: Array<Maybe<DirectoryEdge>>;
  pageInfo: PageInfo;
};

/**
 * Contains information about a Directory's relationship to a given page (connection),
 * and the Directory itself.
 */
export type DirectoryEdge = {
   __typename?: 'DirectoryEdge';
  cursor?: Maybe<Scalars['Cursor']>;
  node?: Maybe<Directory>;
};

/** The set of ways to filter directories. */
export enum DirectoryFilter {
  /** Return game communities. */
  Games = 'GAMES',
  /** Return creative communities. */
  Creative = 'CREATIVE'
}

/** The set of ways to sort directories against each other. */
export enum DirectorySort {
  /** Order results by viewer count descending. */
  ViewerCount = 'VIEWER_COUNT',
  /** Order results randomly. */
  Random = 'RANDOM',
  /** Order results by relevance score. */
  Relevance = 'RELEVANCE'
}

/** The set of types of directory. */
export enum DirectoryType {
  /** A game. */
  Game = 'GAME'
}

/** Disable Prerolls Ability contains the properties used by the Disable Prerolls Feature. */
export type DisablePrerollsAbility = {
   __typename?: 'DisablePrerollsAbility';
  /** DisablePrerollsFreeTime define relation of midroll-length:preroll-free-time-earned on this channel. */
  disablePrerollsTimeEarned?: Maybe<Array<DisablePrerollsFreeTime>>;
  /** If "disable prerolls for midrolls" feature is accessible on this channel. */
  hasDisablePrerollsAbilityAccess?: Maybe<Scalars['Boolean']>;
  /** If "disable prerolls for midrolls" feature is enabled on this channel. */
  hasDisablePrerollsAbilityEnabled?: Maybe<Scalars['Boolean']>;
  /** If disable preroll notifications are enabled on this channel. */
  hasDisablePrerollsNotificationsEnabled?: Maybe<Scalars['Boolean']>;
  /** Maximum amount of preroll-free time (in seconds) that can be accumulated on this channel. */
  maxDisablePrerollsCapacity?: Maybe<Scalars['Int']>;
};

/**
 * Disable Prerolls Free Time maps the relationship between a specific midroll
 * length and amount of preroll-free time earned for a channel.
 */
export type DisablePrerollsFreeTime = {
   __typename?: 'DisablePrerollsFreeTime';
  /** The length (in seconds) of a midroll ad. */
  midrollLengthSeconds: Scalars['Int'];
  /** The amount of preroll-free time (in seconds) earned on this channel for running midroll of related length. */
  prerollFreeTimeSeconds: Scalars['Int'];
};

/** Error type that DisableUserAccountPayload returns. */
export type DisableUserAccountError = {
   __typename?: 'DisableUserAccountError';
  /** Error Code, see DisableUserAccountErrorCode. */
  code: DisableUserAccountErrorCode;
};

/** DisableUserAccountErrorCode is an error while deleting a user. */
export enum DisableUserAccountErrorCode {
  /** User ID is invalid. */
  InvalidUserId = 'INVALID_USER_ID',
  /** Requester is not authorized to make the requested change. */
  Unauthorized = 'UNAUTHORIZED'
}

/** Inputs to the disableUserAccount mutation. */
export type DisableUserAccountInput = {
  /** Reason for a user to disable their account. */
  description?: Maybe<Scalars['String']>;
  /**
   * Permanently delete account.
   * false means account will be disabled and can be reenabled in the future.
   * true means the account will be disabled and will be permanently deleted after a period of time.
   * default is false.
   */
  isDelete?: Maybe<Scalars['Boolean']>;
  /**
   * The ID of the user to disable or delete.
   * Only the requester's user ID is allowed.
   */
  userID: Scalars['ID'];
};

/** Output from the disableUserAccount mutation. */
export type DisableUserAccountPayload = {
   __typename?: 'DisableUserAccountPayload';
  /** Error if operation failed from user error. */
  error?: Maybe<DisableUserAccountError>;
  /** User that has been deleted or disabled. */
  user?: Maybe<User>;
};

/** DiscountBreakdown shows discounted pricing for a promotional offer. */
export type DiscountBreakdown = {
   __typename?: 'DiscountBreakdown';
  /** The numerical price of a discounted offer. */
  price: Scalars['Int'];
  /** The localized tax rate of a offer. */
  tax: Scalars['Int'];
  /** The total discounted price given price and tax. */
  total: Scalars['Int'];
};

/**
 * DEPRECATED: to be replaced by SubscriptionPromotionDiscountType.
 * Valid discount types for subscription products.
 */
export enum DiscountType {
  /** Percent discount type, eg. "50%". */
  PercentOff = 'PERCENT_OFF'
}

export type DismissFriendRecommendationInput = {
  /** The recommendation to the authenticated user to become friends with a user with ID targetID will be removed. */
  targetID: Scalars['ID'];
};

export type DismissFriendRecommendationPayload = {
   __typename?: 'DismissFriendRecommendationPayload';
  /** The user who was previously a friend recommendation to the target user. */
  user?: Maybe<User>;
};

export type DismissRitualTokenError = {
   __typename?: 'DismissRitualTokenError';
  code: DismissRitualTokenErrorCode;
};

export enum DismissRitualTokenErrorCode {
  /** Token is not in a status that can be dismissed. */
  TokenNotAvailable = 'TOKEN_NOT_AVAILABLE',
  /** Token does not exist. */
  TokenNotFound = 'TOKEN_NOT_FOUND'
}

/** DismissRitualTokenInput is the input when dismissing a ritual token. */
export type DismissRitualTokenInput = {
  /** The channel to dismiss the ritual token in. */
  channelID: Scalars['ID'];
  /** The type of ritual token to dismiss. */
  type: RitualTokenType;
};

/** DismissRitualTokenPayload is the response when dismissing a ritual token. */
export type DismissRitualTokenPayload = {
   __typename?: 'DismissRitualTokenPayload';
  error?: Maybe<DismissRitualTokenError>;
  token?: Maybe<RitualToken>;
};

/** Input for dismissing a video's suggested highlight. */
export type DismissVideoSuggestedHighlightInput = {
  /** VideoID of the video whos automated highlight suggestions were dismissed. */
  videoID: Scalars['ID'];
};

/** Ouput for dismissing a video's suggested highlight. */
export type DismissVideoSuggestedHighlightPayload = {
   __typename?: 'DismissVideoSuggestedHighlightPayload';
  /** Video whos automated highlight suggestions were dismissed. */
  video?: Maybe<Video>;
};

/** Contains all of the information about a Drop awarded to a user. */
export type Drop = {
   __typename?: 'Drop';
  /** The game that awarded the Drop. */
  game?: Maybe<Game>;
  /** The assigned ID of this drop. */
  id: Scalars['ID'];
  /** The image URL of the Drop. Images are 80x80 pixels. */
  imageURL: Scalars['String'];
  /** The developer-provided name of the Drop. */
  name: Scalars['String'];
};

/** Contains all of the information about a Drop's action stating what happens when a drop is triggered. */
export type DropAction = {
   __typename?: 'DropAction';
  /** The time in seconds a user has to claim a drop after occurence. */
  claimDurationSeconds: Scalars['Int'];
  /** The description of this drop's action. */
  description: Scalars['String'];
  /** The Action ID. */
  id: Scalars['ID'];
  /** The type of action happening when a drop is triggered. */
  type: DropActionType;
};

/** A list of all supported Action types. */
export enum DropActionType {
  /** Returned in case the action type cannot be identified. */
  UnknownActionType = 'UNKNOWN_ACTION_TYPE',
  /** Returned in case the action starts a user claim flow. */
  UserClaimFlow = 'USER_CLAIM_FLOW'
}

/** Data about the award of a drop to a user. */
export type DropAward = {
   __typename?: 'DropAward';
  /** The timestamp when the Drop was awarded to the user. */
  awardedAt?: Maybe<Scalars['Time']>;
  /** The drop that was awarded to the user. */
  node?: Maybe<Drop>;
  /** The reason the Drop was awarded. */
  reason?: Maybe<Scalars['String']>;
};

/** Contains all of the information about a Drop awarded to a user. */
export type DropBenefit = {
   __typename?: 'DropBenefit';
  /** The redirect URL where a user can link their account. */
  accountLinkURL: Scalars['String'];
  /** The display description of this award object. */
  description: Scalars['String'];
  /** The limit of how often this benefit can be awarded to a user. */
  entitlementLimit: Scalars['Int'];
  /** The game that awarded the Drop. */
  game?: Maybe<Game>;
  /** The ID of this reward object. */
  id: Scalars['ID'];
  /** An image asset for this reward object. */
  imageAssetURL: Scalars['String'];
  /** The display name of this award object. */
  name: Scalars['String'];
  /** The ID of the owner of the item for this reward. */
  owner: User;
};

/**
 * A campaign a developer is running to give drops away to viewers of their game
 * To be considered live, a campaign must be enabled with the current time
 * being after the start but before the end times
 * To apply to a particular channel a campaign must be live and additionally
 * the channel must be playing an applicable game and either must be one of the
 * applicable channels or the campaign must have an empty applicable channel list
 * (where an empty list specifically means all channels are eligible).
 */
export type DropCampaign = {
   __typename?: 'DropCampaign';
  /**
   * If isAvailableToAllChannels is false, applicableChannels is the list of
   * what channels this campaign is targeted to.  If the flag is true but the
   * list is empty, that means that all whitelisted users cannot be loaded.
   * An applicable channel must also be playing an applicable game for the
   * campaign to apply to the channel.
   */
  applicableChannels?: Maybe<Array<User>>;
  /**
   * The games that this campaign is enabled on
   * A channel playing one of these games must be in the applicable channels
   * list or list must be empty for the campaign to apply to the channel.
   */
  applicableGames?: Maybe<Array<Game>>;
  /** The drops this campaign can award. */
  awardableDrops?: Maybe<Array<Drop>>;
  /**
   * The URL users who aren't linked should click on to create a link that will
   * allow them create an account link for the developer of the game(s)
   * this campaign is for.
   */
  connectionURL: Scalars['String'];
  /**
   * The time this campaign ends
   * To be considered live, a campaign must be enabled with the current time
   * being after the start but before the end times.
   */
  endAt: Scalars['Time'];
  /** GUID identifying this campaign. */
  id: Scalars['ID'];
  /**
   * Indicates if this campaign is available to all channels or if only some.
   * If false, applicableChannels should contain the channels where the campaign
   * is available.
   */
  isAvailableToAllChannels: Scalars['Boolean'];
  /**
   * If this campaign is enabled
   * To be considered live, a campaign must be enabled with the current time
   * being after the start but before the end times.
   */
  isEnabled: Scalars['Boolean'];
  /**
   * The time this campaign starts
   * To be considered live, a campaign must be enabled with the current time
   * being after the start but before the end times.
   */
  startAt: Scalars['Time'];
};

/** Contains all of the information about the channel seetings for a Drop. */
export type DropChannelSetting = {
   __typename?: 'DropChannelSetting';
  /**
   * UserAccountConnected is a boolean specifying if a streamer has a connected
   * account link to the game required for the game developers to send drop related
   * game data for this user.
   */
  isUserAccountConnected: Scalars['Boolean'];
};

/** Contains all of the information about a Drop awarded to a user. */
export type DropEligibility = {
   __typename?: 'DropEligibility';
  /** The remaining time in which this reward can be claimed. */
  claimSecondsRemaining: Scalars['Int'];
  /** Summary information for the drop the reward is claimed of. */
  drop: DropObject;
  /** The unique ID of this drop instance. */
  dropInstanceID: Scalars['ID'];
  /** Rewards available to the user for this drop and their statuses. */
  rewards: Array<DropReward>;
  /** User eligibility for this drop instance. */
  status: DropInstanceEligibilityStatus;
};

/** DropImageType is the list of possible uses that an image can have for drops. */
export enum DropImageType {
  /** Image for telling viewers that drops are available if they link accounts. */
  LinkNotification = 'LINK_NOTIFICATION',
  /** Image for showing a viewer what item a developer awarded as a drop. */
  Item = 'ITEM'
}

/** Status enums for a drop instance. */
export enum DropInstanceEligibilityStatus {
  /** User can claim all rewards. */
  EligibleForAll = 'ELIGIBLE_FOR_ALL',
  /** User can claim some rewards. */
  Limited = 'LIMITED',
  /** User can not claim any of the rewards in this drop instance. */
  EntitlementLimitReached = 'ENTITLEMENT_LIMIT_REACHED',
  /** User has already claimed this drop instance. */
  DropInstanceAlreadyClaimed = 'DROP_INSTANCE_ALREADY_CLAIMED',
  /** The claim duration has expired and user can no longer claim this drop instance. */
  Expired = 'EXPIRED',
  /** Unknown is returned if a status is returned from the backend that was not expected. */
  Unknown = 'UNKNOWN'
}

/** Contains all of the information about a Drop awardable to a user. */
export type DropObject = {
   __typename?: 'DropObject';
  /** The redirect URL where a user can link their account. */
  accountLinkURL: Scalars['String'];
  /** The actions defining what happens after a drop is triggered. */
  actions: Array<DropAction>;
  /** The description of this drop. */
  description: Scalars['String'];
  /** The URL that links to the details / marketing page for this drop. */
  detailsURL: Scalars['String'];
  /** The date at which this drop can no longer occur. */
  endDate: Scalars['Time'];
  /** The game associated with this drop. */
  game: Game;
  /** The Drops ID. */
  id: Scalars['ID'];
  /** An image asset for this drop. */
  imageURL: Scalars['String'];
  /** The friendly name of this drop. */
  name: Scalars['String'];
  /** The OrganizationID of the owner of this drop. */
  ownerID: Scalars['ID'];
  /** The friendly name of the owner of this drop. */
  ownerName: Scalars['String'];
  /** The Quest name for this specific Drop. */
  questName: Scalars['String'];
  /** The rules defining what needs to happen to trigger this drop. */
  rules: Array<DropRule>;
  /** The date at which this drop can start to occur. */
  startDate: Scalars['Time'];
};

/** Contains all of the information about a Drop awarded to a user. */
export type DropReward = {
   __typename?: 'DropReward';
  /** The URL where a user can link their account for this reward. */
  accountLinkURL: Scalars['String'];
  /** An availability enum for this reward. */
  availability: DropRewardAvailability;
  /** The display description of this award object. */
  description: Scalars['String'];
  /** The ID of this reward object. */
  id: Scalars['ID'];
  /** An image asset for this reward object. */
  imageAssetURL: Scalars['String'];
  /** The display name of this award object. */
  name: Scalars['String'];
  /** The ID of the owner of the item for this reward. */
  ownerID: Scalars['ID'];
  /** The display name of item owner for this drop. */
  ownerName: Scalars['String'];
};

/** Availability enum for Drop Rewards. */
export enum DropRewardAvailability {
  /** User can claim this item. */
  Available = 'AVAILABLE',
  /** User has claimed this item already the maximum number of times. */
  LimitReached = 'LIMIT_REACHED',
  /** Unknown is returned when an unexpected status is received from the backend. */
  Unknown = 'UNKNOWN'
}

/** Contains all of the information about a Drop's rule stating what a broadcaster has to do to trigger a drop. */
export type DropRule = {
   __typename?: 'DropRule';
  /** The description of this drop's rule. */
  description: Scalars['String'];
  /** The Rule ID. */
  id: Scalars['ID'];
};


/** Paginated list of channels a user is an editor for. */
export type EditableChannelConnection = {
   __typename?: 'EditableChannelConnection';
  /** The elements of the list. */
  edges: Array<EditableChannelEdge>;
  /** Information about this page. */
  pageInfo: PageInfo;
};

/** Points to a editable channel with the editor. */
export type EditableChannelEdge = {
   __typename?: 'EditableChannelEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** The user whose channel has the editor. */
  node?: Maybe<User>;
};

/** Paginated list of editors of a channel. */
export type EditorConnection = {
   __typename?: 'EditorConnection';
  /** The elements of the list. */
  edges: Array<EditorEdge>;
  /** Information about this page. */
  pageInfo: PageInfo;
};

/** Points to a user with the editor status, with metadata regarding the relationship. */
export type EditorEdge = {
   __typename?: 'EditorEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** Timestamp of when the editor status was granted. */
  grantedAt: Scalars['Time'];
  /** The user who has the editor status. */
  node?: Maybe<User>;
};

export type EditRoomMessageInput = {
  message: Scalars['String'];
  messageID: Scalars['ID'];
  roomID: Scalars['ID'];
};

export type EditRoomMessagePayload = {
   __typename?: 'EditRoomMessagePayload';
  message?: Maybe<RoomMessage>;
};

/** The list of payment methods that are supported for web checkout for a user. */
export type EligiblePaymentMethod = {
   __typename?: 'EligiblePaymentMethod';
  /** Availability status of the underlying payment gateway. */
  availabilityStatus: PaymentMethodAvailabilityStatus;
  /** Name of the payment method. */
  name: EligiblePaymentMethodName;
};

/** The list of names of payment methods that are supported for web checkout. */
export enum EligiblePaymentMethodName {
  /** Amazon Pay payment method. */
  AmazonPay = 'AMAZON_PAY',
  /** Paypal payment method. */
  Paypal = 'PAYPAL',
  /** Credit card payment method. */
  CreditCard = 'CREDIT_CARD',
  /** Xsolla payment method. */
  Xsolla = 'XSOLLA'
}

/**
 * EmbeddedEmote is an encoding format used to describe an emote embedded in a string of text.
 * 
 * Example:
 *   body = "hey KappaHD"
 *   from = 4
 *   to = 10
 * 
 *   "KappaHD" will be replaced with the KappaHD emote image.
 */
export type EmbeddedEmote = {
   __typename?: 'EmbeddedEmote';
  /** The emote's identifier, for example "115847" -> KappaHD. */
  emoteID?: Maybe<Scalars['ID']>;
  /** from is the index of the string where replacement starts. */
  from?: Maybe<Scalars['Int']>;
  id?: Maybe<Scalars['ID']>;
  /** setID is the identifier of the set this emote is in. */
  setID?: Maybe<Scalars['ID']>;
  /** to is the index of the string where replacement ends. */
  to?: Maybe<Scalars['Int']>;
};

/**
 * EmitCampaignDiscoveryEventInput contains the campaign objective type of the event being emitted
 * and the channelID from which this event is born.
 */
export type EmitCampaignDiscoveryEventInput = {
  /** The channelID from the channel this event is taking place on. */
  channelID: Scalars['ID'];
  /** The campaign objective type of the event. */
  discoveryType: CampaignDiscoveryEventType;
};

/** EmitCampaignDiscoveryEventPayload is the success response for emitting a campaign discovery event. */
export type EmitCampaignDiscoveryEventPayload = {
   __typename?: 'EmitCampaignDiscoveryEventPayload';
  /** Whether the call succeeded or not. */
  isSuccess: Scalars['Boolean'];
};

export type Emote = {
   __typename?: 'Emote';
  /** The Bits Badge Tier metadata associated with this Bits Badge Tier Emote. Nil for other emote types. */
  bitsBadgeTierSummary?: Maybe<EmoteBitsBadgeTierSummary>;
  /**
   * The emote's identifier.
   * For example, "115847".
   */
  id?: Maybe<Scalars['ID']>;
  /** The list of modifiers a user is entitled to use for an emote. */
  modifiers?: Maybe<Array<EmoteModifier>>;
  /** The user who owns the subscription product that this emote belongs to. */
  owner?: Maybe<User>;
  /** Identifies which set this emote belongs to. */
  setID?: Maybe<Scalars['ID']>;
  /** The state of an emote. Can be either active or pending. */
  state: EmoteState;
  /** The subscription product this emote belongs to. Nil for globals. */
  subscriptionProduct?: Maybe<SubscriptionProduct>;
  /**
   * For subscription and bits badge tier emotes, this is the user generated suffix.
   * For example, for "lirikLUL" suffix would be "LUL".
   */
  suffix?: Maybe<Scalars['String']>;
  /**
   * The visual representation of the emote.
   * For example, "O_o" instead of "(O|o)_(o|O)".
   */
  text?: Maybe<Scalars['String']>;
  /**
   * The text token of the emote.
   * For example, "KappaHD".
   */
  token?: Maybe<Scalars['String']>;
};

/** Bits Badges Tier metadata for emotes. */
export type EmoteBitsBadgeTierSummary = {
   __typename?: 'EmoteBitsBadgeTierSummary';
  /** The Bits Badge Tier Summary data that is user-dependent. */
  self?: Maybe<EmoteBitsBadgeTierSummarySelfEdge>;
  /** The amount of bits any user must cheer to achieve this tier. */
  threshold: Scalars['Int'];
};

/** The Bits Badge Tier Summary data that is user-dependent. */
export type EmoteBitsBadgeTierSummarySelfEdge = {
   __typename?: 'EmoteBitsBadgeTierSummarySelfEdge';
  /** Is true if the user has unlocked this emote. */
  isUnlocked: Scalars['Boolean'];
  /** The number of bits that this user must use in order to unlock this emote. 0 if already unlocked. */
  numberOfBitsUntilUnlock: Scalars['Int'];
};

/** Represents the data needed to continue the upload of an emoticon image asset. */
export type EmoteImageUploadConfiguration = {
   __typename?: 'EmoteImageUploadConfiguration';
  /** The id used by upload service to publish updates via pubsub about the uploaded image. */
  uploadID?: Maybe<Scalars['ID']>;
  /** The url in s3 for where the front-end should post the image asset. */
  uploadURL?: Maybe<Scalars['String']>;
};

/** The name of an emote modifier and it's abbreviated code. */
export type EmoteModifier = {
   __typename?: 'EmoteModifier';
  /** The code to use the emote modifier in chat. */
  code: Scalars['String'];
  /** The name of the emote modifier. */
  name: PermanentEmoteModifier;
};

/** A set of modifications to apply to a tier of emotes for a creator. */
export type EmoteModifierGroupInput = {
  /** The modifiers to set. */
  modifiers: Array<PermanentEmoteModifier>;
  /** The ID of the product to set the modifiers for. */
  productID: Scalars['ID'];
};

/** A set of modifiers that have been set on a tier of emotes for a creator. */
export type EmoteModifierGroupPayload = {
   __typename?: 'EmoteModifierGroupPayload';
  /** The modifiers that were set. */
  modifiers?: Maybe<Array<PermanentEmoteModifier>>;
  /** The product the modifiers were set for. */
  product?: Maybe<SubscriptionProduct>;
};

/** Represents a group of emotes. */
export type EmoteSet = {
   __typename?: 'EmoteSet';
  /** The list of emotes which belong to this set. */
  emotes?: Maybe<Array<Maybe<Emote>>>;
  /** The emote set's identifier. */
  id?: Maybe<Scalars['ID']>;
  /**
   * The channel associated with the emote set. Nil for emote sets not associated
   * with an owner (prime, fuel, rewards, etc.).
   */
  owner?: Maybe<User>;
};

/** Deprecated: Domains that emotes belong to. */
export enum EmoteSetDomain {
  /** Emotes that were granted via Twitch crates. */
  Crate = 'CRATE'
}

/** The state of an emote. */
export enum EmoteState {
  /** Emote has been approved and is active. */
  Active = 'ACTIVE',
  /** Emote has been uploaded and is awaiting approval. */
  Pending = 'PENDING',
  /** Emote is inactive. */
  Inactive = 'INACTIVE',
  /** Emote has an unknown state. */
  Unknown = 'UNKNOWN'
}

/** Used to filter emotes by state. */
export enum EmoteStateFilter {
  /** Show all emotes, including active and pending. */
  All = 'ALL',
  /** Show only active emotes. */
  Active = 'ACTIVE'
}

/** Represents an emote that is currently in the process of being uploaded. */
export type EmoteUploadConfiguration = {
   __typename?: 'EmoteUploadConfiguration';
  /** The relevant metadata for the 1X image asset. */
  imageUploadConfig1X?: Maybe<EmoteImageUploadConfiguration>;
  /** The relevant metadata for the 2X image asset. */
  imageUploadConfig2X?: Maybe<EmoteImageUploadConfiguration>;
  /** The relevant metadata for the 4X image asset. */
  imageUploadConfig4X?: Maybe<EmoteImageUploadConfiguration>;
};

/** Channels have emoticon prefixes. */
export type EmoticonPrefix = {
   __typename?: 'EmoticonPrefix';
  /** If the prefix can be edited or not. */
  isEditable: Scalars['Boolean'];
  /** Name of the prefix. */
  name: Scalars['String'];
  /** If the prefix has been approved or not. */
  state: EmoticonPrefixState;
};

/** State to track if the emote prefix is approved or not. */
export enum EmoticonPrefixState {
  /** Unknown. */
  Unknown = 'UNKNOWN',
  /** No prefix has been submitted. */
  Unset = 'UNSET',
  /** Prefix is approved and active. */
  Active = 'ACTIVE',
  /** Prefix was rejected by Twitch. */
  Rejected = 'REJECTED',
  /** Prefix is waiting moderation by Twitch. */
  Pending = 'PENDING'
}

/** Episode metadata. */
export type EpisodeDetails = {
   __typename?: 'EpisodeDetails';
  /** Total length of the content. */
  durationSeconds?: Maybe<Scalars['Int']>;
  /** The episode number. */
  episode?: Maybe<Scalars['Int']>;
  /** The season number. */
  season?: Maybe<Scalars['Int']>;
  /** The name of the series. */
  series?: Maybe<Scalars['String']>;
};

/** Settings for a given event. */
export type EventNotificationSetting = {
   __typename?: 'EventNotificationSetting';
  /** The setting category. */
  category: Scalars['String'];
  /** Settings for individual platforms. */
  platforms: Array<PlatformEventSetting>;
};

/**
 * Experimental properties that should NOT be used outside of experiments.
 * When your property is no longer in use, please mark as deprecated and then formally delete it.
 */
export type Experiment = {
   __typename?: 'Experiment';
  /** The selected promoted Stream for placement experiments. */
  promotedStream?: Maybe<Stream>;
};


/**
 * Experimental properties that should NOT be used outside of experiments.
 * When your property is no longer in use, please mark as deprecated and then formally delete it.
 */
export type ExperimentPromotedStreamArgs = {
  promoLocation: Scalars['Int'];
};

/** Data about an inactive subscription to a broadcaster. */
export type ExpiredSubscription = {
   __typename?: 'ExpiredSubscription';
  /** The channel that the expired subscription belongs to. */
  channelOwner?: Maybe<User>;
  /** The unique identifier. */
  id: Scalars['ID'];
  /** Resolves the product that the expired subscription is to. */
  product?: Maybe<SubscriptionProduct>;
  /** The total tenure of a user to a broadcaster. */
  tenure: SubscriptionTenure;
};

/** A paginated list of expired subscriptions. */
export type ExpiredSubscriptionConnection = {
   __typename?: 'ExpiredSubscriptionConnection';
  /** The list of expired subscriptions. */
  edges?: Maybe<Array<ExpiredSubscriptionEdge>>;
  /** Information about this page of expired subs. */
  pageInfo: PageInfo;
};

/** An element in a paginated list of expired subscriptions. */
export type ExpiredSubscriptionEdge = {
   __typename?: 'ExpiredSubscriptionEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** The element node. */
  node?: Maybe<ExpiredSubscription>;
};

/** Twitch Extension. */
export type Extension = {
   __typename?: 'Extension';
  /**
   * The SKU of the extension for monetizable extensions.
   * @deprecated sku should be used instead
   */
  SKU: Scalars['String'];
  /** The anchor point the extension expects to render into on the client. */
  anchor: ExtensionAnchor;
  /** A list of assets which the extension must have uploaded to the Twitch Extensions CDN. */
  assetURLs: Array<Scalars['String']>;
  /** The author of the extension as specified by the developer's extension manifest. */
  authorName: Scalars['String'];
  /** The bits support level required by the broadcaster for the extension to operate. */
  bitsSupportLevel: ExtensionBitsSupportLevel;
  /** The list of categories that the developer has set for the extension. */
  categories: Array<ExtensionCategory>;
  /**
   * The list of challenge condition participants that are associated with this
   * extension for a particular condition participant owner and condition owner.
   */
  challengeConditionParticipants?: Maybe<ExtensionChallengeConditionParticipantConnection>;
  /** The list of challenge conditions that are associated with this extension. */
  challengeConditions?: Maybe<ExtensionChallengeConditionConnection>;
  /** The client ID of the extension. Also used as the non-composite, non-unique ID of an extension internally. */
  clientID: Scalars['ID'];
  /**
   * The URL which is used to preset the configuration experience of the extension.
   * @deprecated configURL should be captured from the config ExtensionView: Extension.views.config.viewerURL
   */
  configURL: Scalars['String'];
  /** The list of games that an extension is content-matched to. This list is managed internally by Twitch. */
  contentMatchedGames?: Maybe<Array<Game>>;
  /**
   * The description of the extension specified by the developer's extension manifest
   * (max-length: 1024 characters).
   */
  description: Scalars['String'];
  /** The list of games that an extension is associated to. This list is managed by the extension developer. */
  games?: Maybe<Array<Game>>;
  /** Whether the extension developer has turned on chat support for this extension. */
  hasChatSupport: Scalars['Boolean'];
  /**
   * Represents whether or not the developer of the extension would like to provide users with
   * the ability to link their identity with the extension.
   */
  hasIdentityLinking: Scalars['Boolean'];
  /**
   * The extension icon URL used to visually represent the extension.
   * @deprecated iconURL should be captured from the iconURLs map: Extension.iconURLs.Square100
   */
  iconURL: Scalars['String'];
  /** The extension icon URLs used to visually represent the extension. */
  iconURLs: ExtensionIcons;
  /** The extension ID which is a composite form of <clientID>:<version>. */
  id: Scalars['ID'];
  /**
   * The number of installations the extension has.
   * @deprecated Installation counts are no longer surfaced to clients
   */
  installationCount: Scalars['Int'];
  /** Represents whether or not the extension supports bits monetization. */
  isBitsEnabled: Scalars['Boolean'];
  /**
   * The URL which is used to preset the live-dashboard experience of the extension.
   * @deprecated liveConfigURL should be captured from the liveConfig ExtensionView: Extension.views.liveConfig.viewerURL
   */
  liveConfigURL: Scalars['String'];
  /**
   * The name of the extension specified by the developer's extension manifest
   * (max-length: 40 characters).
   */
  name: Scalars['String'];
  /**
   * The panel height specified by the developer's extension manifest -or- 300.
   * @deprecated panelHeight should be captured from the panel ExtensionView: Extension.views.panel.height
   */
  panelHeight: Scalars['Int'];
  /** The link to the extension's privacy policy as specified by the developer's extension manifest. */
  privacyPolicyURL: Scalars['String'];
  /** Screenshots of the URL used to showcase the extension on extension details pages. */
  screenshotURLs: Array<Scalars['String']>;
  /** Represents whether the requesting user is able to install the extension. */
  self?: Maybe<ExtensionSelfConnection>;
  /** The sku of the extension for monetizable extensions. */
  sku: Scalars['String'];
  /** The current state of the extension in our approval process. */
  state: ExtensionState;
  /** The subscription support level required by the broadcaster for the extension to operate. */
  subscriptionsSupportLevel: ExtensionSubscriptionsSupportLevel;
  /**
   * The summary of the extension specified by the developer's extension manifest
   * (max-length: 140 characters).
   */
  summary: Scalars['String'];
  /** The support contact email as specified by the developer's extension manifest. */
  supportEmail: Scalars['String'];
  /** End-user license agreement terms of service URL. */
  termsURL: Scalars['String'];
  /** The vendor code of the extension for monetizable extensions. */
  vendorCode: Scalars['String'];
  /** The current version of the extension specified by the developer's extension manifest. */
  version: Scalars['String'];
  /**
   * The URL which is used to preset the viewer experience of the extension.
   * @deprecated viewerURL should be captured from the ExtensionView corresponding with the Extension's specified anchor
   */
  viewerURL: Scalars['String'];
  /** The UI configurations of each supported view of the extension. */
  views: ExtensionViews;
  /** The list of URLs an extension can link to while loaded in the configuration experience. */
  whitelistedConfigURLs: Array<Scalars['String']>;
  /** The list of URLs a panel extension can link to while loaded in the viewer experience. */
  whitelistedPanelURLs: Array<Scalars['String']>;
};


/** Twitch Extension. */
export type ExtensionChallengeConditionParticipantsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  input: ExtensionChallengeConditionParticipantsInput;
};


/** Twitch Extension. */
export type ExtensionChallengeConditionsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  input: ExtensionChallengeConditionsInput;
};

/** The current activation configuration for an installed extension. */
export type ExtensionActivationConfig = {
   __typename?: 'ExtensionActivationConfig';
  /**
   * The anchor that the installation has been activated into. If not activated into a slot,
   * the value will be null.
   */
  anchor?: Maybe<ExtensionAnchor>;
  /**
   * The slot that the installation has been activated into. If not activated into a slot,
   * the value will be null.
   */
  slot?: Maybe<Scalars['String']>;
  /** The activation state of the extension installation. */
  state: ActivationState;
  /**
   * The horizontal positioning of the left side of the component extension from the left side
   * of the visible video space as a fixed-point percentage (ie: 5742 would represent 57.42 percent).
   */
  x?: Maybe<Scalars['Int']>;
  /**
   * The vertical positioning of the top side of the component extension from the top side
   * of the visible video space as a fixed-point percentage (ie: 5742 would represent 57.42 percent).
   */
  y?: Maybe<Scalars['Int']>;
};

/**
 * Represents the action which should be taken on the provided installation ID. If no
 * anchor configuration is provided, the installation will be deactivated.
 */
export type ExtensionActivationInput = {
  /** The required activation input to apply activation state to a component anchor. */
  component?: Maybe<ComponentActivationInput>;
  /** The installation ID of the component extension you're attempting to activate. */
  installationID: Scalars['ID'];
  /** The required activation input to apply activation state to a panel anchor. */
  panel?: Maybe<PanelActivationInput>;
  /** The required activation input to apply activation state to a video overyla anchor. */
  videoOverlay?: Maybe<VideoOverlayActivationInput>;
};

/** The possible values for an Extension Anchor. */
export enum ExtensionAnchor {
  /** Component extension anchor. */
  Component = 'COMPONENT',
  /** Hidden extensions are used currently for load tests. */
  Hidden = 'HIDDEN',
  /** Panel extension anchor. */
  Panel = 'PANEL',
  /** Video overlay extension anchor. */
  VideoOverlay = 'VIDEO_OVERLAY'
}

/** ExtensionAssetManifest is data related to the assets of an extension. */
export type ExtensionAssetManifest = {
   __typename?: 'ExtensionAssetManifest';
  /** Hash of the asset zip file. */
  assetHash: Scalars['String'];
  /** Base URI used for extensions out of local test. */
  baseURI?: Maybe<Scalars['String']>;
  /** The name of the file that was uploaded. */
  fileName?: Maybe<Scalars['String']>;
  /** The size of the file that was uploaded. */
  fileSize?: Maybe<Scalars['String']>;
  /** The time that the assets were uploaded. */
  uploadedAt?: Maybe<Scalars['Time']>;
  /** The user that uploaded the assets. */
  uploader?: Maybe<User>;
};

/** ExtensionAssetManifestInput is data related to the assets of an extension. */
export type ExtensionAssetManifestInput = {
  /** Hash of the asset zip file. */
  assetHash: Scalars['String'];
};

/** The support levels for Bits features. */
export enum ExtensionBitsSupportLevel {
  /** This extension doesn't have any support for bit features. */
  None = 'NONE',
  /**
   * This extension has support for bit features but can operate in the event
   * the broadcaster disables the permissions.
   */
  Optional = 'OPTIONAL',
  /**
   * This extension requires support for bit features and cannot operate in the event
   * the broadcaster disables the permissions.
   */
  Required = 'REQUIRED'
}

/** ExtensionCapabilities contains data about what an Extension can do, in general, and at the time of interaction. */
export type ExtensionCapabilities = {
   __typename?: 'ExtensionCapabilities';
  /** The bit support level required by the broadcaster for the extension to operate. Defaults to "NONE". */
  bitsSupportLevel: ExtensionBitsSupportLevel;
  /** Location of configuration. */
  configurationLocation: ExtensionConfigurationLocation;
  /** Does this extension use bits. */
  hasBitsSupport: Scalars['Boolean'];
  /** Does this extension support chat. */
  hasChatSupport: Scalars['Boolean'];
  /** Required configuration string. */
  requiredConfiguration: Scalars['String'];
  /** The subscription support level required by the broadcaster for the extension to operate. Defaults to "NONE". */
  subscriptionsSupportLevel: ExtensionSubscriptionsSupportLevel;
  /** Whitelists for restricting extension access and behavior. */
  whitelists?: Maybe<ExtensionWhitelists>;
  /** Will this extension request an identity link. */
  willRequestIdentityLink: Scalars['Boolean'];
};

/** ExtensionCapabilitiesInput contains data about what an Extension can do, in general, and at the time of interaction. */
export type ExtensionCapabilitiesInput = {
  /** The bits support level required by the broadcaster for the extension to operate. Defaults to "NONE". */
  bitsSupportLevel?: Maybe<ExtensionBitsSupportLevel>;
  /** Location of configuration. */
  configurationLocation: ExtensionConfigurationLocation;
  /** Does this extension use bits. */
  hasBitsSupport: Scalars['Boolean'];
  /** Does this extension support chat. */
  hasChatSupport: Scalars['Boolean'];
  /** Required configuration string. */
  requiredConfiguration: Scalars['String'];
  /** The subscription support level required by the broadcaster for the extension to operate. Defaults to "NONE". */
  subscriptionsSupportLevel?: Maybe<ExtensionSubscriptionsSupportLevel>;
  /** Whitelists for restricting extension access and behavior. */
  whitelists: ExtensionWhitelistsInput;
  /** Will this extension request an identity link. */
  willRequestIdentityLink: Scalars['Boolean'];
};

/** An extension carousel. */
export type ExtensionCarousel = {
   __typename?: 'ExtensionCarousel';
  /** List of entries associated with the carousel. */
  entries: Array<ExtensionCarouselEntry>;
  /** Unique ID of the carousel. */
  id: Scalars['ID'];
};

/** An extension carousel entry. */
export type ExtensionCarouselEntry = {
   __typename?: 'ExtensionCarouselEntry';
  /** URL the user is directed to when clicking the carousel entry. */
  clickThroughURL: Scalars['String'];
  /** Unique ID of the entry. */
  id: Scalars['ID'];
  /** URL of the image to display for the carousel entry. */
  imageURL: Scalars['String'];
  /** Text associated with the carousel entry. */
  title: Scalars['String'];
};

/** An extension category. */
export type ExtensionCategory = {
   __typename?: 'ExtensionCategory';
  /** Description for what kind of extensions this category represents. */
  description: Scalars['String'];
  /** The paginated list of extensions in the category. */
  extensions?: Maybe<ExtensionConnection>;
  /** The category ID which is uniquely generated. */
  id: Scalars['ID'];
  /** Boolean value representing whether a category has been deleted. */
  isDeleted: Scalars['Boolean'];
  /** Denotes that no updates can be made to the category and no extensions can be added to it. */
  isReadOnly: Scalars['Boolean'];
  /** Boolean value representing whether this category should be hidden from listings. */
  isVisible: Scalars['Boolean'];
  /** Human readable name for the Category. */
  name: Scalars['String'];
  /** Display order for this category. Categories are returned in ascending order. */
  order: Scalars['Float'];
  /**
   * The URL-safe slug for the category. This slug may be used as the identifier to retrieve
   * categories from the root Query.
   */
  slug?: Maybe<Scalars['ID']>;
  /** Enumerated value specifying how this category's content should be ordered. Popularity, manual, etc. */
  sortKey: ExtensionCategorySortKey;
  /** Category Type which can be curated or developer. */
  type: ExtensionCategoryType;
};


/** An extension category. */
export type ExtensionCategoryExtensionsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};

/** A paginated list of extension categories, and their metadata. */
export type ExtensionCategoryConnection = {
   __typename?: 'ExtensionCategoryConnection';
  /** The list of extension categories in this page. */
  edges: Array<ExtensionCategoryEdge>;
  /** Information about this page of extension categories. */
  pageInfo: PageInfo;
  /** The total number of extension categories. */
  totalCount: Scalars['Int'];
};

/** An element in a paginated list of extension categories and its metadata. */
export type ExtensionCategoryEdge = {
   __typename?: 'ExtensionCategoryEdge';
  /** Cursor represents the position of the current edge/node. */
  cursor: Scalars['Cursor'];
  /** Node represents the extension category for the current edge. */
  node: ExtensionCategory;
};

/** Enumeration of the different sort keys to sort extensions within a category. */
export enum ExtensionCategorySortKey {
  /** Manual sort key refers to an arbitrary sorting of extensions. */
  Manual = 'MANUAL',
  /** Popularity sort key refers to sorting of extensions by popularity. */
  Popularity = 'POPULARITY',
  /** Time sort key refers to sorting of extensions from newest to latest. */
  Time = 'TIME'
}

/** Enumeration of the different category types that are currently supported. */
export enum ExtensionCategoryType {
  /** Curated Category Type is Twitch controlled. */
  Curated = 'CURATED',
  /** Developer Category Type is developer controlled. */
  Developer = 'DEVELOPER',
  /**
   * Pseudo Categories are categories whose extensions are generated. Slugs are required
   * on pseudo categories and are often the best way to retrieve them. Example pseudo categories
   * and slugs include "new-releases" and "whitelisted".
   */
  Pseudo = 'PSEUDO'
}

/** A paginated list of extension challenge conditions. */
export type ExtensionChallengeConditionConnection = {
   __typename?: 'ExtensionChallengeConditionConnection';
  /** The elements of the paginated list. */
  edges: Array<ExtensionChallengeConditionEdge>;
  /** Information about this page. */
  pageInfo: PageInfo;
};

/** An element in a paginated list of extension challenge conditions. */
export type ExtensionChallengeConditionEdge = {
   __typename?: 'ExtensionChallengeConditionEdge';
  /** An opaque cursor identifying the edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** The element node. */
  node: ChallengeCondition;
};

/** A paginated list of extension challenge conditionParticipants. */
export type ExtensionChallengeConditionParticipantConnection = {
   __typename?: 'ExtensionChallengeConditionParticipantConnection';
  /** The elements of the paginated list. */
  edges: Array<ExtensionChallengeConditionParticipantEdge>;
  /** Information about this page. */
  pageInfo: PageInfo;
};

/** An element in a paginated list of extension challenge conditionParticipants. */
export type ExtensionChallengeConditionParticipantEdge = {
   __typename?: 'ExtensionChallengeConditionParticipantEdge';
  /** An opaque cursor identifying the edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** The element node. */
  node: ChallengeConditionParticipant;
};

/** Parameters for filtering ChallengeConditionParticipants. */
export type ExtensionChallengeConditionParticipantsInput = {
  /** TUID of condition participant's associated condition's owner. */
  conditionOwnerID: Scalars['ID'];
  /** TUID of condition participant owner. */
  conditionParticipantOwnerID: Scalars['ID'];
  /** Filter condition participants with this state. */
  endState: ChallengeConditionParticipantEndState;
};

/** Parameters for filtering ChallengeConditions. */
export type ExtensionChallengeConditionsInput = {
  /** TUID of condition owner. This will typically be the broadcaster's user ID. */
  conditionOwnerID: Scalars['ID'];
  /** Filter conditions with this state. */
  state: ChallengeConditionState;
};

/** ExtensionClient is the authorization component of an extension. */
export type ExtensionClient = {
   __typename?: 'ExtensionClient';
  /**
   * A organization member assigned as a billing manager for this extension. Null
   * when extension is not an organization or the extension is not monetized.
   */
  assignedBillingManager?: Maybe<OrganizationMember>;
  /** CreatedAt is the timestamp at which this client was created. */
  createdAt: Scalars['Time'];
  /** ID is the OAuth ID representing the extension. */
  id: Scalars['ID'];
  /** Name is the name of the extension. */
  name: Scalars['String'];
  /** Organization is the Organization entity of the extension, it means which organization the extension belongs to. */
  organization?: Maybe<Organization>;
  /** RedirectURI is the URI used for client redirect on OAuth login. */
  redirectURI: Scalars['String'];
};

/** A paginated list of extension clients. */
export type ExtensionClientConnection = {
   __typename?: 'ExtensionClientConnection';
  /** The list of extension clients in this page. */
  edges: Array<ExtensionClientEdge>;
  /** Information about this page of extension clients. */
  pageInfo: PageInfo;
};

/** An element in a paginated list of extension clients. */
export type ExtensionClientEdge = {
   __typename?: 'ExtensionClientEdge';
  /** Cursor represents the position of the current edge/node. */
  cursor: Scalars['Cursor'];
  /** Node represents the extension client for the current edge. */
  node: ExtensionClient;
};

/** ExtensionComment contains the data for the comment of an extension review. */
export type ExtensionComment = {
   __typename?: 'ExtensionComment';
  /** The review comment text provided by the user. */
  content: Scalars['String'];
  /** The ID of the recorded comment. */
  id: Scalars['ID'];
};

/** Possible locations for Extension Configuration to be hosted. */
export enum ExtensionConfigurationLocation {
  /** Configuration not required for activation of this extension. */
  None = 'NONE',
  /** Configuration hosted by Twitch using Extensions Configuration service. */
  Hosted = 'HOSTED',
  /** Custom/Own service hosted configuration. */
  Custom = 'CUSTOM'
}

/** A paginated list of extensions, and its metadata. */
export type ExtensionConnection = {
   __typename?: 'ExtensionConnection';
  /** The list of extensions in this page. */
  edges: Array<ExtensionEdge>;
  /** Information about this page of extensions. */
  pageInfo: PageInfo;
  /** The total number of extensions in the larger collection. */
  totalCount: Scalars['Int'];
};

/** ExtensionDeveloperManifest is the developer specific extension data. */
export type ExtensionDeveloperManifest = {
   __typename?: 'ExtensionDeveloperManifest';
  /** Author email. */
  authorEmail: Scalars['String'];
  /** Time when an extension was created. */
  createdAt: Scalars['String'];
  /** Time when an extensions version was last transitioned. */
  lastTransitionedAt?: Maybe<Scalars['Time']>;
  /** Testing uri for extension development. */
  testingBaseURI: Scalars['String'];
  /** Current state of this version in the development timeline. */
  versionState: ExtensionState;
};

/** ExtensionDeveloperManifestInput is the developer specific extension data. */
export type ExtensionDeveloperManifestInput = {
  /** Author email. */
  authorEmail: Scalars['String'];
  /** Testing uri for extension development. */
  testingBaseURI: Scalars['String'];
};

/** Extension metadata used for discovery. */
export type ExtensionDiscoveryManifest = {
   __typename?: 'ExtensionDiscoveryManifest';
  /** Name of the extension author. */
  authorName: Scalars['String'];
  /** Extension categories. */
  categories: Array<ExtensionCategory>;
  /** Games that an extension is content-matched to. This list is managed internally by Twitch. */
  contentMatchedGames?: Maybe<Array<Game>>;
  /** Extension descriprion. 1024 character limit. */
  description: Scalars['String'];
  /** Games that an extension is associated to. This list is managed by the extension developer. */
  games: Array<Game>;
  /** Icon urls for extensions. */
  iconURLs?: Maybe<ExtensionIcons>;
  /** name of the extension. */
  name: Scalars['String'];
  /** Url to an extensions privacy policy. */
  privacyPolicyURL: Scalars['String'];
  /** Extension screenshot urls. */
  screenshotURLs: Array<Scalars['String']>;
  /** Extension summary. 140 character limit. */
  summary: Scalars['String'];
  /** Extension developers support email. */
  supportEmail: Scalars['String'];
  /** Extension eula/tos url. */
  termsURL: Scalars['String'];
  /** Extension viewer summary. */
  viewerSummary: Scalars['String'];
};

/** Extension metadata used for discovery. */
export type ExtensionDiscoveryManifestInput = {
  /** Name of the extension author. */
  authorName: Scalars['String'];
  /** Extension categories. */
  categories: Array<Scalars['ID']>;
  /** Extension descriprion. 1024 character limit. */
  description: Scalars['String'];
  /** games an extension is associated with. */
  games: Array<Scalars['ID']>;
  /** name of the extension. */
  name: Scalars['String'];
  /** Url to an extensions privacy policy. */
  privacyPolicyURL: Scalars['String'];
  /** Extension summary. 140 character limit. */
  summary: Scalars['String'];
  /** Extension developers support email. */
  supportEmail: Scalars['String'];
  /** Extension eula/tos url. */
  termsURL: Scalars['String'];
  /** A summary of the extension's functionality from a viewer's perspective. */
  viewerSummary?: Maybe<Scalars['String']>;
};

/** ExtensionDynamicManagementInput represents the game ID and whether it is dynamically managed or not on an extension. */
export type ExtensionDynamicManagementInput = {
  /** The discovery game ID. */
  gameID: Scalars['ID'];
  /** If the game has been marked as dynamically managed or not. */
  isManaged: Scalars['Boolean'];
};

/** An element in a paginated extensions of videos, and its metadata. */
export type ExtensionEdge = {
   __typename?: 'ExtensionEdge';
  /** Cursor represents the position of the current edge/node. */
  cursor: Scalars['Cursor'];
  /** Node represents the extension for the current edge. */
  node: Extension;
};

/** The complete set of potential icons provided by a developer to represent their Extension on the site. */
export type ExtensionIcons = {
   __typename?: 'ExtensionIcons';
  /** 300x200 splash image used in extension discovery & management. */
  discoverySplash: Scalars['String'];
  /** Square 100x100 icon used in extension discovery & management. */
  square100: Scalars['String'];
  /** Square 24x24 icon used in video player taskbar. */
  square24: Scalars['String'];
};

/** Url and UploadId provided by Upload Service. */
export type ExtensionImageUploadResponse = {
   __typename?: 'ExtensionImageUploadResponse';
  /** Upload ID. */
  uploadID: Scalars['ID'];
  /** Upload URL. */
  url: Scalars['String'];
};

/** Extension Installation are models which contain an Extension and it's associated installation metadata. */
export type ExtensionInstallation = {
   __typename?: 'ExtensionInstallation';
  /** The abilities this extension can use for the channel it is installed on. */
  abilities: ExtensionInstallationAbilities;
  /** The current activation metadata for the extension. */
  activationConfig: ExtensionActivationConfig;
  /** The extension which the installation record is for. */
  extension: Extension;
  /** The the composite extension installation ID in the form of <clientID>:<version>:<channelID>. */
  id: Scalars['ID'];
  /** The installer's decision whether to allow an extension to use a particular feature. */
  permittedFeatures: ExtensionInstallationFeatureFlags;
  /** The required, if any, for the installed extension after an activation. */
  requiredActions?: Maybe<Array<ExtensionRequiredAction>>;
  /** The self connection of the extension installation. */
  self?: Maybe<ExtensionInstallationSelfConnection>;
};

/** The set of abilities an extension is authorized to use. */
export type ExtensionInstallationAbilities = {
   __typename?: 'ExtensionInstallationAbilities';
  /** Whether the extension can use bits in the current context. */
  isBitsEnabled: Scalars['Boolean'];
  /** Whether the extension can send chat messages in the current context. */
  isChatEnabled: Scalars['Boolean'];
  /** Whether the extension has access to subscription status in the current context. */
  isSubscriptionStatusAvailable: Scalars['Boolean'];
};

/** The dynamic management setting for a content-matched game on an extension installation. */
export type ExtensionInstallationDynamicManagement = {
   __typename?: 'ExtensionInstallationDynamicManagement';
  /** The game that the setting is for. */
  game?: Maybe<Game>;
  /** Whether or not dynamic management is turned on for this extensions. */
  isManaged: Scalars['Boolean'];
};

/** The set of extension features an installer can opt in or out of. */
export type ExtensionInstallationFeatureFlags = {
   __typename?: 'ExtensionInstallationFeatureFlags';
  /** Whether the installer has granted the extension access to their subscriptions list. */
  canRetrieveSubscriptionStatus: Scalars['Boolean'];
  /** Whether the installer has opted in or out of chat capabilities in extensions. */
  canSendChat: Scalars['Boolean'];
  /** Whether the installer has opted in or out of bit capabilities in extensions. */
  canUseBits: Scalars['Boolean'];
  /** The dynamic management settings for the extension installation. */
  dynamicManagement?: Maybe<Array<ExtensionInstallationDynamicManagement>>;
};

/** The connection a user has to an Installed Extension. */
export type ExtensionInstallationSelfConnection = {
   __typename?: 'ExtensionInstallationSelfConnection';
  /** Represents whether the requesting user can activate the extension. */
  canActivate: Scalars['Boolean'];
  /** A token that the requestor of the extension installations will send into the extension. */
  token: ExtensionToken;
};

/** ExtensionManifest is the data that represents an entire extension manfiest. */
export type ExtensionManifest = {
   __typename?: 'ExtensionManifest';
  /** ExtensionAssetManifest is data related to the assets of an extension. */
  assetManifest: ExtensionAssetManifest;
  /** Data about what an Extension can do, in general, and at the time of interaction. */
  capabilities: ExtensionCapabilities;
  /** ExtensionDeveloperManifest is the developer specific extension data. */
  developerManifest: ExtensionDeveloperManifest;
  /** Extension metadata used for discovery. */
  discoveryManifest: ExtensionDiscoveryManifest;
  /** Extension id. */
  id: Scalars['ID'];
  /** Extension version. */
  version: Scalars['String'];
  /** Extension views. */
  views: ExtensionViews;
};

/** A paginated list of extension manifests. */
export type ExtensionManifestConnection = {
   __typename?: 'ExtensionManifestConnection';
  /** The list of extension manifests in this page. */
  edges: Array<ExtensionManifestEdge>;
  /** Information about this page of extension manifests. */
  pageInfo: PageInfo;
};

/** An element in a paginated list of extension manifests. */
export type ExtensionManifestEdge = {
   __typename?: 'ExtensionManifestEdge';
  /** Cursor represents the position of the current edge/node. */
  cursor: Scalars['Cursor'];
  /** Node represents the extension manifest for the current edge. */
  node?: Maybe<ExtensionManifest>;
};

/** A summary of extension state and the associated manifests. */
export type ExtensionManifestsSummary = {
   __typename?: 'ExtensionManifestsSummary';
  /** The global deleted state of the extension. */
  isDeleted: Scalars['Boolean'];
  /** The list of extension manifests. */
  manifests?: Maybe<ExtensionManifestConnection>;
};

/** ExtensionPanel is a placeholder in the panel list for arbitrary iframed content. */
export type ExtensionPanel = Panel & {
   __typename?: 'ExtensionPanel';
  /** id is a unique identifier for the panel. */
  id: Scalars['ID'];
  /** slotID is an identifier to map extensions content from `User.extensions` to the proper place in the `User.panels` list. */
  slotID: Scalars['ID'];
  /** type is `PanelType.EXTENSION`. */
  type: PanelType;
};

/** ExtensionRating contains the information of a user's rating of a Twitch extension. */
export type ExtensionRating = {
   __typename?: 'ExtensionRating';
  /** The ID of the recorded rating. */
  id: Scalars['ID'];
  /** Whether the user recommended the extension or not. */
  isRecommended: Scalars['Boolean'];
  /** Where the user submitted the rating. */
  location: ExtensionRatingLocation;
};

/** Enumerates where the user can submit an extension rating. */
export enum ExtensionRatingLocation {
  /** The global notifications popout. */
  Notification = 'NOTIFICATION'
}

/** A holder for the presigned S3 URL for an extension ratings report. */
export type ExtensionRatingsCsvReportPresignedUrl = {
   __typename?: 'ExtensionRatingsCSVReportPresignedURL';
  /** The presigned URL, if one is ready.  Otherwise empty string. */
  presignedURL?: Maybe<Scalars['String']>;
};

/** Extension recommendation. */
export type ExtensionRecommendation = {
   __typename?: 'ExtensionRecommendation';
  /** The recommended extension. */
  extension?: Maybe<Extension>;
};

/** The action a user must take to complete an activation of an extension installation. */
export type ExtensionRequiredAction = {
   __typename?: 'ExtensionRequiredAction';
  /**
   * On PROMPT_FOR_PERMISSIONS the redirectURI to load for OAuth.
   * @deprecated PROMPT_FOR_PERMISSIONS is no longer a valid required action
   */
  redirectURI?: Maybe<Scalars['String']>;
  /** The action the user must take in order to complete the activation. */
  type: ExtensionRequiredActionType;
};

/** The possible types of required actions after attempting to activate an extension. */
export enum ExtensionRequiredActionType {
  /** The user must accept the permissions in order to complete the activation. */
  PromptForPermissions = 'PROMPT_FOR_PERMISSIONS',
  /** The user must configure the extension in order to complete the activation. */
  RequiresConfiguration = 'REQUIRES_CONFIGURATION'
}

/** The connection a user has to an Extension object. */
export type ExtensionSelfConnection = {
   __typename?: 'ExtensionSelfConnection';
  /** Represents whether the requesting user is able to install extensions. */
  canInstall: Scalars['Boolean'];
};

/** The possible values for ExtensionState. */
export enum ExtensionState {
  /** IN_TEST extensions are currently being worked on by a developer. */
  InTest = 'IN_TEST',
  /**
   * READY_FOR_REVIEW extensions are currently being examined by a developer for their readiness
   * to be reviewed (assets hosted on CDN).
   */
  ReadyForReview = 'READY_FOR_REVIEW',
  /** IN_REVIEW extensions are being looked at by Twitch. */
  InReview = 'IN_REVIEW',
  /** REJECTED extensions are permanently rejected; no action by the  developer will make them acceptable. */
  Rejected = 'REJECTED',
  /** APPROVED extensions are ready to be released, at the developer's convenience. */
  Approved = 'APPROVED',
  /**
   * RELEASED extensions are currently available to users.  Only one version of an extension
   * can be in this state at any time.
   */
  Released = 'RELEASED',
  /** DEPRECATED extensions were once released, but a newer version now exists. */
  Deprecated = 'DEPRECATED',
  /** PENDING_ACTION extensions are ones that were reviewed by Twitch and returned to the developer for fixing. */
  PendingAction = 'PENDING_ACTION',
  /** UPLOADING extensions are in the process of having their assets loaded onto S3. */
  Uploading = 'UPLOADING',
  /**
   * ASSETS_UPLOADED extensions have had their assets uploaded already to S3. This state mirrors
   * the existing READY_FOR_REVIEW state, but doesn't incur an implicit upload.
   */
  AssetsUploaded = 'ASSETS_UPLOADED',
  /** DELETED extensions have been deleted; this is a soft delete so we can undelete things. */
  Deleted = 'DELETED'
}

/** ExtensionStateFilter contains all the valid states to filter the list of extensions by. */
export enum ExtensionStateFilter {
  /** Released extension. */
  Released = 'RELEASED'
}

/** The support levels for subscriptions features. */
export enum ExtensionSubscriptionsSupportLevel {
  /** This extension doesn't have any support for subscriptions features. */
  None = 'NONE',
  /**
   * This extension has support for subscriptions features but can operate in the event
   * the broadcaster disables the permissions.
   */
  Optional = 'OPTIONAL'
}

/** The user-specific token for an installed extension on a channel. */
export type ExtensionToken = {
   __typename?: 'ExtensionToken';
  /** The JWT token for the requesting user. */
  jwt: Scalars['String'];
};

/** ExtensionVersionDiscoveryManifest is the data that represents an extension discovery manifest. */
export type ExtensionVersionDiscoveryManifest = {
   __typename?: 'ExtensionVersionDiscoveryManifest';
  /** Extension metadata used for discovery. */
  discoveryManifest: ExtensionDiscoveryManifest;
  /** Extension id. */
  id: Scalars['ID'];
  /** Extension version. */
  version: Scalars['String'];
};

/** ExtensionView is the interface which every anchor-specific extension view extends from. */
export type ExtensionView = {
  /** Relative path of the HTML file to load for this view, used by devsite to specify the layout of assets. */
  viewerPath: Scalars['String'];
  /** The URL which should be loaded in for the extension. */
  viewerURL: Scalars['String'];
};

/** The potential anchor-specific configurations and extension can have. */
export type ExtensionViews = {
   __typename?: 'ExtensionViews';
  /** The developer configuration of the extension as a component extension, if supported. */
  component?: Maybe<ComponentView>;
  /** The developer configuration of the extension's configuration view, if supported. */
  config?: Maybe<ConfigView>;
  /** The configuration for a hidden extension. The only hidden extension is used for load testing. */
  hidden?: Maybe<HiddenView>;
  /** The developer configuration of the extension's live configuration dashboard view, if supported. */
  liveConfig?: Maybe<LiveConfigView>;
  /** The developer configuration of the extension as a mobile extension, if supported. */
  mobile?: Maybe<MobileView>;
  /** The developer configuration of the extension as a panel extension, if supported. */
  panel?: Maybe<PanelView>;
  /** The developer configuration of the extension as a video overlay extension, if supported. */
  videoOverlay?: Maybe<VideoOverlayView>;
};

/** The potential anchor-specific configurations and extension can have. */
export type ExtensionViewsInput = {
  /** The developer configuration of the extension as a component extension, if supported. */
  component?: Maybe<ComponentViewInput>;
  /** The developer configuration of the extension's configuration view, if supported. */
  config?: Maybe<ConfigViewInput>;
  /** The developer configuration of the extension's live configuration dashboard view, if supported. */
  liveConfig?: Maybe<LiveConfigViewInput>;
  /** The developer configuration of the extension as a mobile extension, if supported. */
  mobile?: Maybe<MobileViewInput>;
  /** The developer configuration of the extension as a panel extension, if supported. */
  panel?: Maybe<PanelViewInput>;
  /** The developer configuration of the extension as a video overlay extension, if supported. */
  videoOverlay?: Maybe<VideoOverlayViewInput>;
};

/** Whitelists for restricting extension access and behavior. */
export type ExtensionWhitelists = {
   __typename?: 'ExtensionWhitelists';
  /**
   * List of broadcaster account IDs allowed to install an extension after release.
   * If this is empty or missing, all broadcasters can use this extension.
   */
  broadcasters: Array<Scalars['ID']>;
  /** URLs which are permitted to be opened from the configuration dialog. */
  configURLs: Array<Scalars['String']>;
  /** URLs which are permitted to be opened from an extension set as a panel. */
  panelURLs: Array<Scalars['String']>;
  /**
   * List of account IDs which should have access to a version of an extension.
   * Users in this list are ignored by the broadcaster whitelist check.
   */
  testers: Array<Scalars['ID']>;
};

/** ExtensionWhitelistsInput contains whitelists for restricting extension access and behavior. */
export type ExtensionWhitelistsInput = {
  /**
   * List of broadcaster account IDs allowed to install an extension after release.
   * If this is empty or missing, all broadcasters can use this extension.
   */
  broadcasters: Array<Scalars['ID']>;
  /** URLs which are permitted to be opened from the configuration dialog. */
  configURLs: Array<Scalars['String']>;
  /** URLs which are permitted to be opened from an extension set as a panel. */
  panelURLs: Array<Scalars['String']>;
  /**
   * List of account IDs which should have access to a version of an extension.
   * Users in this list are ignored by the broadcaster whitelist check.
   */
  testers: Array<Scalars['ID']>;
};

/** Url and UploadId provided by Upload Service. */
export type ExtensionZipUploadResponse = {
   __typename?: 'ExtensionZipUploadResponse';
  /** Upload ID. */
  uploadID: Scalars['ID'];
  /** Upload URL. */
  url: Scalars['String'];
};

/** ExternalChargeModel defines a 3P managed SKU for a given offer. */
export type ExternalChargeModel = {
   __typename?: 'ExternalChargeModel';
  /** The provider for this externally managed SKU. */
  provider: Scalars['String'];
  /** Externally managed SKU identifier. */
  sku: Scalars['String'];
};

/**
 * FeaturedContentSections contain the a set of FeaturedItems that should be shown
 * together in a particular section of Twitch apps.
 */
export type FeaturedContentSection = {
   __typename?: 'FeaturedContentSection';
  /** A combination of the type and style for a given section, i.e. spotlight-previews. */
  id: Scalars['ID'];
  items?: Maybe<Array<FeaturedItem>>;
};

export type FeaturedItem = {
   __typename?: 'FeaturedItem';
  /** The featured item's content. */
  content?: Maybe<FeaturedItemContent>;
  /** An markdown description of the item, available when a item is featured. */
  description: Scalars['String'];
  /** ID used for tracking interactions. */
  id: Scalars['ID'];
  /** A URL for a special thumbnail image, when this item is featured. */
  imageURL: Scalars['String'];
  /** Is this item featured because it is scheduled? */
  isScheduled: Scalars['Boolean'];
  /** Is this item featured because it is sponsored? */
  isSponsored: Scalars['Boolean'];
  /** A lower priority level means the item is higher priority. */
  priorityLevel: Scalars['Int'];
  /** When featured, the title of the item. */
  title: Scalars['String'];
};

export type FeaturedItemContent = Stream | User | Video;

/** FeaturedStream contains extra metadata for presenting a featured Stream. */
export type FeaturedStream = {
   __typename?: 'FeaturedStream';
  /** The featured stream's broadcaster. */
  broadcaster?: Maybe<User>;
  /**
   * The featured channel.
   * @deprecated Use featuredStream.broadcaster instead.
   */
  channel?: Maybe<Channel>;
  /** A markdown description of the stream, available when a stream is featured. */
  description?: Maybe<Scalars['String']>;
  /**
   * An HTML description of the stream, available when a stream is featured.
   * @deprecated Use featuredStream.description instead
   */
  descriptionHTML?: Maybe<Scalars['String']>;
  /** A URL for a special thumbnail image, when this stream is featured. */
  imageURL?: Maybe<Scalars['String']>;
  /** Is this stream featured because it is scheduled? */
  isScheduled?: Maybe<Scalars['Boolean']>;
  /** Is this stream featured because it is sponsored? */
  isSponsored?: Maybe<Scalars['Boolean']>;
  /** A lower priority level means the stream is higher priority. */
  priorityLevel?: Maybe<Scalars['Int']>;
  /** The featured live steam. */
  stream?: Maybe<Stream>;
  /** When featured, the title of the stream. */
  title?: Maybe<Scalars['String']>;
};

/**
 * DEPRECATED: do not use, it is subject to change.
 * FeaturedVideo contains extra metadata for presenting a featured video.
 */
export type FeaturedVideo = {
   __typename?: 'FeaturedVideo';
  /** An markdown description of the video, available when a video is featured. */
  description: Scalars['String'];
  /** A URL for a special thumbnail image, when this video is featured. */
  imageURL: Scalars['String'];
  /** Is this video featured because it is scheduled? */
  isScheduled: Scalars['Boolean'];
  /** Is this video featured because it is sponsored? */
  isSponsored: Scalars['Boolean'];
  /** A lower priority level means the stream is higher priority. */
  priorityLevel: Scalars['Int'];
  /** When featured, the title of the video. */
  title: Scalars['String'];
  /** The featured video. */
  video?: Maybe<Video>;
};

export type FeatureFlags = {
   __typename?: 'FeatureFlags';
  /** @deprecated Enabled for everyone. */
  isPulseEnabled?: Maybe<Scalars['Boolean']>;
};

/** Feed is twitch's pulse product of content a user may enjoy. */
export type Feed = {
   __typename?: 'Feed';
  id: Scalars['ID'];
  items?: Maybe<FeedItemConnection>;
};


/** Feed is twitch's pulse product of content a user may enjoy. */
export type FeedItemsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};

export type FeedEmbed = Clip | LinkOEmbed | PhotoOEmbed | RichOEmbed | Video | VideoOEmbed;

/**
 * FeedItem is the units of a feed.
 * They do not have an identifier because you cannot look them up by identifier.
 */
export type FeedItem = {
   __typename?: 'FeedItem';
  content?: Maybe<FeedItemContent>;
  reasons?: Maybe<Array<Maybe<FeedItemReason>>>;
  tracking?: Maybe<FeedItemTracking>;
};

export type FeedItemConnection = {
   __typename?: 'FeedItemConnection';
  edges?: Maybe<Array<Maybe<FeedItemEdge>>>;
  pageInfo?: Maybe<PageInfo>;
};

/** FeedItemContent is the supported content types that may appear in a feed. */
export type FeedItemContent = Clip | Post | Share | Stream | Video;

export type FeedItemEdge = {
   __typename?: 'FeedItemEdge';
  cursor?: Maybe<Scalars['Cursor']>;
  node?: Maybe<FeedItem>;
};

/** FeedItemReason explains why an item is in your feed. */
export type FeedItemReason = {
   __typename?: 'FeedItemReason';
  reason?: Maybe<Scalars['String']>;
};

/** FeedItemTracking contains the tracking info of a feeditem. */
export type FeedItemTracking = {
   __typename?: 'FeedItemTracking';
  batchID?: Maybe<Scalars['String']>;
  cardImpressionID?: Maybe<Scalars['String']>;
  recGenerationID?: Maybe<Scalars['String']>;
  recGenerationIndex?: Maybe<Scalars['Int']>;
};

/** FinalizeCompetitionLobbyInput contains the inputs required to change a lobby's status to done. */
export type FinalizeCompetitionLobbyInput = {
  /** The competition id of the competition. */
  competitionID: Scalars['ID'];
  /** The lobbyID of the competition that we want to mark done. */
  lobbyID: Scalars['ID'];
  /** The phase id of the competition that this lobby belongs to. */
  phaseID: Scalars['ID'];
};

/** FinalizeCompetitionLobbyPayload is the success response for updating a lobby to done. */
export type FinalizeCompetitionLobbyPayload = {
   __typename?: 'FinalizeCompetitionLobbyPayload';
  /** The new state of competition after marking the lobby as done. */
  competition?: Maybe<Competition>;
};

/** Settings specific to the first cheer tutorial. */
export type FirstCheerTutorial = {
   __typename?: 'FirstCheerTutorial';
  /** Optional field that dictates whether a user has exited out of the first cheer tutorial by clicking out of the experience. */
  hasAbandoned?: Maybe<Scalars['Boolean']>;
  /** Optional field that dictates whether a user has skipped the first cheer tutorial by clicking the skip button. */
  hasSkipped?: Maybe<Scalars['Boolean']>;
};

/** Data about the relationship between one User and a User they are following. */
export type Follow = {
   __typename?: 'Follow';
  /** Whether to disable notifications for this relationship. */
  disableNotifications?: Maybe<Scalars['Boolean']>;
  /** Represents when this relationship was established. */
  followedAt?: Maybe<Scalars['Time']>;
  /** The user who is followed. */
  user?: Maybe<User>;
};

/** A paginated list of follows relationships. */
export type FollowConnection = {
   __typename?: 'FollowConnection';
  /** The elements of the paginated list. */
  edges?: Maybe<Array<Maybe<FollowEdge>>>;
  /** Information about this page. */
  pageInfo?: Maybe<PageInfo>;
  /** The total number of followers. */
  totalCount?: Maybe<Scalars['Int']>;
};

/** A list of followed games. */
export type FollowedGameConnection = {
   __typename?: 'FollowedGameConnection';
  /** The elements of the paginated list. */
  nodes?: Maybe<Array<Game>>;
};

export enum FollowedGamesType {
  /** Only games which are currently being streamed will be returned. */
  Live = 'LIVE',
  /** All followed games. */
  All = 'ALL'
}

/**
 * An element in a paginated list of follows relationships.
 * Contains metadata about the follow relationship between two users.
 */
export type FollowEdge = {
   __typename?: 'FollowEdge';
  /** An opaque cursor identifying the edge's position in the paginted list. */
  cursor: Scalars['Cursor'];
  /**
   * Whether to disable notifications for this relationship.
   * @deprecated use notificationSettings.isEnabled instead.
   */
  disableNotifications?: Maybe<Scalars['Boolean']>;
  /** Represents when this relationship was established. */
  followedAt?: Maybe<Scalars['Time']>;
  /** The user who is followed. */
  node?: Maybe<User>;
  /** Notification settings for this relationship. */
  notificationSettings?: Maybe<ChannelNotificationSettings>;
};

/** A list of broadcasters followed by a user and hosting live broadcasters. */
export type FollowedHostConnection = {
   __typename?: 'FollowedHostConnection';
  /** The broadcasters. */
  nodes?: Maybe<Array<Maybe<User>>>;
};

/** A list of live-streaming broadcasters followed by a user. */
export type FollowedLiveUserConnection = {
   __typename?: 'FollowedLiveUserConnection';
  /** The live broadcasters. */
  edges: Array<Maybe<FollowedLiveUserEdge>>;
  /**
   * The live broadcasters.
   * @deprecated Use FollowedLiveUserConnection.edges instead for pagination support
   */
  nodes?: Maybe<Array<Maybe<User>>>;
  /** Pagination. */
  pageInfo: PageInfo;
};

/** A live streaming broadcaster with cursor. */
export type FollowedLiveUserEdge = {
   __typename?: 'FollowedLiveUserEdge';
  cursor: Scalars['Cursor'];
  node?: Maybe<User>;
};

/** A paginated list of followers relationships. */
export type FollowerConnection = {
   __typename?: 'FollowerConnection';
  /** The elements of the paginated list. */
  edges?: Maybe<Array<Maybe<FollowerEdge>>>;
  /** Metadata about this page. */
  pageInfo?: Maybe<PageInfo>;
  /** The total number of followers. */
  totalCount?: Maybe<Scalars['Int']>;
};

/**
 * An element in a paginated list of followers.
 * Contains metadata about the follower relationship between two users.
 */
export type FollowerEdge = {
   __typename?: 'FollowerEdge';
  /** An opaque cursor identifying the edge's position in the paginted list. */
  cursor: Scalars['Cursor'];
  /** Whether to disable notifications for this relationship. */
  disableNotifications?: Maybe<Scalars['Boolean']>;
  /** Represents when this relationship was established. */
  followedAt?: Maybe<Scalars['Time']>;
  /** The user who is a follower. */
  node?: Maybe<User>;
  /** Notification settings for this relationship. */
  notificationSettings?: Maybe<ChannelNotificationSettings>;
};

export type FollowGameInput = {
  /** The identifier of the game to follow. */
  gameID: Scalars['ID'];
};

export type FollowGamePayload = {
   __typename?: 'FollowGamePayload';
  /** The game that was followed if the operation was successful. */
  game?: Maybe<Game>;
};

export enum FollowsFilter {
  /** All users the user is following. */
  All = 'ALL',
  /**
   * Users the user is following to which the user can subscribe.
   * this is authenticated so only a logged in user can filter by SUBBABLE.
   */
  Subbable = 'SUBBABLE'
}

/** Information to communicate to the user about an error state. */
export type FollowUserError = {
   __typename?: 'FollowUserError';
  /** Error code. */
  code: FollowUserErrorCode;
};

/** Enum for follow errors. */
export enum FollowUserErrorCode {
  /** Used when fromUser is being blocked by targetUser. */
  Forbidden = 'FORBIDDEN',
  /** Used when user has reached their follow cap. */
  TooManyFollows = 'TOO_MANY_FOLLOWS'
}

export type FollowUserInput = {
  /**
   * disableNotifications, when true, prevents the followed user's stream from sending email and push notifications to
   * the authenticated user when it goes live.
   */
  disableNotifications: Scalars['Boolean'];
  targetID: Scalars['ID'];
};

export type FollowUserPayload = {
   __typename?: 'FollowUserPayload';
  /** Used for user blocked errors. */
  error?: Maybe<FollowUserError>;
  /** The new follow relationship. */
  follow?: Maybe<Follow>;
};

/** The format type signifies the format the competition will run from. */
export enum FormatType {
  /** Double elimination bracket format. */
  DoubleElim = 'DOUBLE_ELIM',
  /** Single elimination bracket format. */
  SingleElim = 'SINGLE_ELIM',
  /** Round robin format. */
  RoundRobin = 'ROUND_ROBIN',
  /** Leaderboard format. */
  Leaderboard = 'LEADERBOARD',
  /** Unknown format. */
  Unknown = 'UNKNOWN'
}

/** The details of different formats. Currently there is only 1 detail type. */
export type FormatTypeDetails = LeaderboardDetails;

/**
 * FragmentContent contains the parse content of a fragment, and can be an emote or a mention.
 * NOTE: should have been called RoomMessageFragmentContent.
 */
export type FragmentContent = AutoMod | CheermoteToken | Emote | RoomMessageGroupMention | User;

/** A list of a user's friend relationships. */
export type FriendConnection = {
   __typename?: 'FriendConnection';
  /** The friend elements of this list. */
  edges?: Maybe<Array<Maybe<FriendEdge>>>;
  /** The total number of friends this user has. */
  totalCount: Scalars['Int'];
};

/** The friendship between the authenticated user and another user. */
export type FriendEdge = {
   __typename?: 'FriendEdge';
  /** An action that a user or session is performing. */
  activity?: Maybe<Activity>;
  /** The computed state of a user or session. */
  availability: Availability;
  /** The last time the friend's availability or activity changed. */
  lastStatusChangeAt?: Maybe<Scalars['Time']>;
  /** The friend user. */
  node?: Maybe<User>;
};

/**
 * The friend-type relationship between the authenticated user and another user.
 * 
 * If this field is a FriendEdge, the authenticated user and the other user are Friends.
 * 
 * If it is an IncomingFriendRequestEdge, the other user has an open friend request with authenticated user.
 * 
 * If it is an OutgoingFriendRequestEdge, the authenticated user has an open friend request with the other user.
 */
export type FriendRelationship = FriendEdge | IncomingFriendRequestEdge | OutgoingFriendRequestEdge;

/** Decides how to sort Friendship-related responses. */
export enum FriendSort {
  /** Sort from oldest to newest. */
  Asc = 'ASC',
  /** Sort from newest to oldest. */
  Desc = 'DESC'
}

/** A Game is often the subject of a Stream on Twitch. */
export type Game = Directory & {
   __typename?: 'Game';
  /** What campaigns are active for this game. */
  activeDropCampaigns?: Maybe<Array<DropCampaign>>;
  /**
   * URL to an avatar image.
   * The image dimensions are specifiable via the `height` and `width` parameters.
   * 
   * If `height` or `width` are not specified, the URL will contain
   * the template strings `{height}` and/or `{width}` in their respective places.
   */
  avatarURL?: Maybe<Scalars['String']>;
  /**
   * URL to a box art image.
   * The image dimensions are specifiable via the `height` and `width` parameters.
   * 
   * If `height` or `width` are not specified, the URL will contain
   * the template strings `{height}` and/or `{width}` in their respective places.
   */
  boxArtURL?: Maybe<Scalars['String']>;
  /** Number of broadcasters streaming this game. */
  broadcastersCount?: Maybe<Scalars['Int']>;
  /**
   * Number of channels currently streaming this game.
   * @deprecated Use broadcastersCount instead.
   */
  channelsCount?: Maybe<Scalars['Int']>;
  /**
   * A paginated list of clips featuring this game, ordered by view count descending.
   * When criteria is not specified, the default values are used.
   */
  clips?: Maybe<ClipConnection>;
  /**
   * URL to a cover image.
   * The image dimensions are specifiable via the `height` and `width` parameters.
   * 
   * If `height` or `width` are not specified, the URL will contain
   * the template strings `{height}` and/or `{width}` in their respective places.
   */
  coverURL?: Maybe<Scalars['String']>;
  /** The type of directory – in this case, always GAME. */
  directoryType?: Maybe<DirectoryType>;
  /**
   * The translated game name used for display purposes.
   * Use name for tracking props or URLs.
   */
  displayName: Scalars['String'];
  /** A list of extension recommendations, according to the game. */
  extensionRecommendations?: Maybe<Array<ExtensionRecommendation>>;
  /** Number of users that follow this game. */
  followersCount?: Maybe<Scalars['Int']>;
  /** The game's unique GiantBomb identifier. */
  giantBombID?: Maybe<Scalars['ID']>;
  /**
   * The game's unique Twitch identifier.
   * It is used to associate games with product offers.
   */
  id: Scalars['ID'];
  /**
   * URL to a game logo image.
   * The image dimensions are specifiable via the `height` and `width` parameters.
   * 
   * If `height` or `width` are not specified, the URL will contain
   * the template strings `{height}` and/or `{width}` in their respective places.
   */
  logoURL?: Maybe<Scalars['String']>;
  /**
   * The name of the game. This string is untranslated. 
   * This field should only be used in limited occassions, like tracking and URLs. 
   * You should use displayName for all all game names shown to the users.
   */
  name: Scalars['String'];
  /** A measure of the games popularity. */
  popularityScore?: Maybe<Scalars['Int']>;
  /** The authenticated user's relationship with this Game. */
  self?: Maybe<GameSelfConnection>;
  /**
   * Get a page of live streams broadcasting this game.
   * The languages param can be used to filter the streams. Otherwise all languages will be returned.
   * The filters param contains additional metadata filters, for example {hearthstoneGameMode: "arena"}.
   * The sort param can be used to change the default sorting, which sometimes is specific to specific games.
   * The tags param are an array of tag ID as optional filters for streams.
   * DEPRECATED field arguments: languages, requestID, sort, tags
   * Use GameStreamOptions instead.
   */
  streams?: Maybe<StreamConnection>;
  /** List of recommeded tags in the corresponding category. */
  tags?: Maybe<Array<Tag>>;
  /** A paginated list of top videos for this game. */
  videos?: Maybe<VideoConnection>;
  /** Number of viewers currently watching a stream which features this game. */
  viewersCount?: Maybe<Scalars['Int']>;
};


/** A Game is often the subject of a Stream on Twitch. */
export type GameAvatarUrlArgs = {
  width?: Maybe<Scalars['Int']>;
  height?: Maybe<Scalars['Int']>;
};


/** A Game is often the subject of a Stream on Twitch. */
export type GameBoxArtUrlArgs = {
  width?: Maybe<Scalars['Int']>;
  height?: Maybe<Scalars['Int']>;
};


/** A Game is often the subject of a Stream on Twitch. */
export type GameClipsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  criteria?: Maybe<GameClipsInput>;
};


/** A Game is often the subject of a Stream on Twitch. */
export type GameCoverUrlArgs = {
  width?: Maybe<Scalars['Int']>;
  height?: Maybe<Scalars['Int']>;
};


/** A Game is often the subject of a Stream on Twitch. */
export type GameLogoUrlArgs = {
  width?: Maybe<Scalars['Int']>;
  height?: Maybe<Scalars['Int']>;
};


/** A Game is often the subject of a Stream on Twitch. */
export type GameStreamsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  options?: Maybe<GameStreamOptions>;
  languages?: Maybe<Array<Scalars['String']>>;
  filters?: Maybe<StreamMetadataFilterInput>;
  sort?: Maybe<StreamSort>;
  requestID?: Maybe<Scalars['ID']>;
  tags?: Maybe<Array<Scalars['String']>>;
};


/** A Game is often the subject of a Stream on Twitch. */
export type GameTagsArgs = {
  limit?: Maybe<Scalars['Int']>;
  tagType: TagType;
};


/** A Game is often the subject of a Stream on Twitch. */
export type GameVideosArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  languages?: Maybe<Array<Scalars['String']>>;
  types?: Maybe<Array<BroadcastType>>;
  sort?: Maybe<VideoSort>;
};

/** GameApplication is an application to associate a game with an organization. */
export type GameApplication = {
   __typename?: 'GameApplication';
  /** Creation time. */
  createdAt: Scalars['Time'];
  /** Game that is added in the application. */
  game: Game;
  /** ID of the game application, stored in RBAC. */
  id: Scalars['ID'];
  /** Organization that is going to be associated with the game. */
  organization: Organization;
};

/** Moment Details specific to a game change. */
export type GameChangeMomentDetails = {
   __typename?: 'GameChangeMomentDetails';
  /** The game that the user changed to. */
  game?: Maybe<Game>;
};

/** Filtering criteria for paginated game clips results. */
export type GameClipsInput = {
  /** The ID of the broadcaster to filter results by. */
  broadcasterID?: Maybe<Scalars['ID']>;
  /** The ID of the curator to filter results by. */
  curatorID?: Maybe<Scalars['ID']>;
  /** Overrides the period. if startAt is provided, but endAt isn't, the endAt value will be the day when the query was made. */
  endAt?: Maybe<Scalars['Time']>;
  /**
   * DEPRECATED: `filter` should no longer be used. Prefer `period` and `sort` instead.
   * A filter which restricts results.
   */
  filter?: Maybe<ClipsFilter>;
  /**
   * Clip results will be filtered by this language.
   * Omit this input field to get results by all languages.
   */
  languages?: Maybe<Array<Language>>;
  /** The time period to restrict clips based on creation time. */
  period?: Maybe<ClipsPeriod>;
  /** The sort order for the clips results. */
  sort?: Maybe<ClipsSort>;
  /** Overrides the period param. If endAt is provided, but startAt isn't, 2015-01-01 will be used for it. */
  startAt?: Maybe<Scalars['Time']>;
};

/**
 * Paginated list of Games.
 * Implements the Relay cursor connections specification.
 * See: https://facebook.github.io/relay/graphql/connections.htm.
 */
export type GameConnection = {
   __typename?: 'GameConnection';
  /** The list of games to display. */
  edges?: Maybe<Array<GameEdge>>;
  pageInfo: PageInfo;
};

/**
 * Contains information about a Game's relationship to a given page (connection),
 * and the Game itself.
 */
export type GameEdge = {
   __typename?: 'GameEdge';
  cursor?: Maybe<Scalars['Cursor']>;
  node?: Maybe<Game>;
  /** Unique id per game response item, used by clients to attribute displays/clicks to items. */
  trackingID?: Maybe<Scalars['ID']>;
};

/** Game followed by a User. */
export type GameFollow = {
   __typename?: 'GameFollow';
  /** Represents when this relationship was established. */
  followedAt: Scalars['Time'];
  /** The game that is followed. */
  game?: Maybe<Game>;
  /** The user who is following. */
  user?: Maybe<User>;
};

/**
 * Optional input to filter categories.
 * Add any additional optional fields to this input.
 */
export type GameOptions = {
  /** The locale of the user. */
  locale?: Maybe<Scalars['String']>;
  /** If sorted by relevance, this provides additional context used to influence recommendations. */
  recommendationsContext?: Maybe<RecommendationsContext>;
  /**
   * A GUID that is created by the caller for tracking. This should be globally
   * unique per request and is required if sort=RELEVANCE.
   */
  requestID?: Maybe<Scalars['ID']>;
  /** The sort param can be used to change the default sorting of results. */
  sort?: Maybe<GameSort>;
  /** Tags are an array of tag IDs as optional filters for categories. */
  tags?: Maybe<Array<Scalars['String']>>;
};

/** Game that my viewers also like to watch. */
export type GameOverlap = {
   __typename?: 'GameOverlap';
  /** Game that my viewers also like to watch. */
  game: Game;
  /** How much my viewers like to watch this game. */
  score: Scalars['Float'];
};

/** The relationship between the authenticated user and a game. */
export type GameSelfConnection = {
   __typename?: 'GameSelfConnection';
  /** The current user's follow relationship with this game. */
  follow?: Maybe<GameFollow>;
  /**
   * Whether or not the current user has a link to this game that can be used
   * for Drops.
   */
  isDropsLinked?: Maybe<Scalars['Boolean']>;
};

/** Possible ways of sorting collections of categories. */
export enum GameSort {
  /** Sort by number of concurrent viewers, descending (most viewers first). */
  ViewerCount = 'VIEWER_COUNT',
  /** Sort by relevance to the current user. */
  Relevance = 'RELEVANCE'
}

/**
 * Optional input to filter game specific streams.
 * add additional optional fields to this input.
 */
export type GameStreamOptions = {
  /** Filter streams based on restriction types. */
  includeRestricted?: Maybe<Array<StreamRestrictionType>>;
  /**
   * Broadcaster languages to filter streams by.
   * Deprecated: use language tags instead.
   */
  languages?: Maybe<Array<Scalars['String']>>;
  /** The locale of the user. */
  locale?: Maybe<Scalars['String']>;
  /** If sorted by relevance, this provides additional context used to influence recommendations. */
  recommendationsContext?: Maybe<RecommendationsContext>;
  /** RequestID must be specified if sort=RELEVANCE. */
  requestID?: Maybe<Scalars['ID']>;
  /** The sort param can be used to change the default sorting, which sometimes is specific to specific games. */
  sort?: Maybe<StreamSort>;
  /** The tags param are an array of tag ID as optional filters for streams. */
  tags?: Maybe<Array<Scalars['String']>>;
};

/** GDPR Consent contains user consent on different tracking vendors. */
export type GdprConsent = {
  /** Whether Amazon has user GDPR consent. */
  allowAmazon?: Maybe<Scalars['Boolean']>;
  /** Whether Comscore has user GDPR consent. */
  allowComscore?: Maybe<Scalars['Boolean']>;
  /** Whether Google has user GDPR consent. */
  allowGoogle?: Maybe<Scalars['Boolean']>;
  /** Whether Nielson has user GDPR consent. */
  allowNielsen?: Maybe<Scalars['Boolean']>;
  /** Whether Salesforce has user GDPR consent. */
  allowSalesforce?: Maybe<Scalars['Boolean']>;
};

/**
 * GenerateExtensionRatingsCSVInput takes an extensionID and some time range info for generating a CSV of extension ratings
 * data for an extension developer.
 * Authenticated on UserID via oauth token and OWL (via the ExtensionRatings backend).
 */
export type GenerateExtensionRatingsCsvReportInput = {
  /** endAt is expected to be RFC3339 UTC and is inclusive in the results when truncated to YYYY-MM-DD. */
  endAt: Scalars['Time'];
  /** extensionID to generate a CSV of ratings data for. */
  extensionID: Scalars['ID'];
  /** startAt is expected to be RFC3339 UTC and is inclusive in the results when truncated to YYYY-MM-DD. */
  startAt: Scalars['Time'];
};

/**
 * GenerateExtensionRatingsCSVPayload returns the filename that the CSV report will have when it is completed, and gives
 * the caller something to poll for.
 */
export type GenerateExtensionRatingsCsvReportPayload = {
   __typename?: 'GenerateExtensionRatingsCSVReportPayload';
  /** reportFilename is the filename for the generated report. */
  reportFilename?: Maybe<Scalars['String']>;
};

/**
 * GenerateSubscribersCSVInput takes a channelID to generate a CSV of subscribers for.
 * Authenticated on channelID.
 */
export type GenerateSubscribersCsvInput = {
  /** channelID to generate a CSV of subscribers for. */
  channelID: Scalars['String'];
};

/**
 * GenerateSubscribersCSVPayload returns the channelID it currently generating
 * a CSV for.
 */
export type GenerateSubscribersCsvPayload = {
   __typename?: 'GenerateSubscribersCSVPayload';
  /** channelID that a subscribers CSV is being generated for. */
  channelID: Scalars['ID'];
};

/** GiftCardCode that can be claimed to add a monetary balance to a user's account. */
export type GiftCardCode = Claimable & {
   __typename?: 'GiftCardCode';
  /** A description of what is claimable for the code. */
  description: Scalars['String'];
  /** The ID of the Gift Card code. */
  id: Scalars['ID'];
  /** The field that gives us claim information for the logged in user. */
  self?: Maybe<SelfClaimEdge>;
  /** The type is `ClaimableType.GIFT_CARD_CODE`. */
  type: ClaimableType;
};

/** User edge relating the pin's status to the user. */
export type GiftCardCodeSelfClaimEdge = SelfClaimEdge & {
   __typename?: 'GiftCardCodeSelfClaimEdge';
  /** If the user is eligible to claim the key code. */
  canClaim: Scalars['Boolean'];
  /** Nullable field for the country where the user redeemed the claimable. */
  countryOfResidence?: Maybe<Scalars['String']>;
  /** The user ID that is claiming the code. */
  id: Scalars['ID'];
  /** Nullable status code for if the user cannot claim the key code. */
  statusCode?: Maybe<Scalars['String']>;
};

/** Types of a gift offer. */
export enum GiftType {
  /** A single recipient gift type. */
  SingleRecipient = 'SINGLE_RECIPIENT',
  /** A community gift type. */
  Community = 'COMMUNITY'
}

/** GlobalCheerConfig contains information about (1) How to display Cheers and (2) What Cheermotes are globally available. */
export type GlobalCheerConfig = {
   __typename?: 'GlobalCheerConfig';
  /**
   * The CheermoteDisplayConfig provides information about how Cheermotes can be displayed
   * This includes things like the possible sizes, colors, backgrounds, and display order.
   */
  displayConfig: CheermoteDisplayConfig;
  /** The Cheermote Groups containing the Global Cheermotes. */
  groups: Array<CheermoteGroup>;
};

/** GoRaidError is the error associated with a goRaid. */
export type GoRaidError = {
   __typename?: 'GoRaidError';
  /** The associated error code. */
  code: GoRaidErrorCode;
};

/** GoRaidErrorCode are the possible errors that this mutation returns. */
export enum GoRaidErrorCode {
  /** The request is missing valid channel parameters. */
  InvalidChannel = 'INVALID_CHANNEL',
  /** The user tries to unraid without an active raid. */
  NoActiveRaid = 'NO_ACTIVE_RAID'
}

/** Inputs to the goRaid mutation. */
export type GoRaidInput = {
  /** Source ID. */
  sourceID: Scalars['ID'];
};

/** Outputs from the goRaid mutation. */
export type GoRaidPayload = {
   __typename?: 'GoRaidPayload';
  /** The possible error returned from the service. */
  error?: Maybe<GoRaidError>;
  /** The raid then just went. */
  raid?: Maybe<Raid>;
};

/** Set based on the auth input type. */
export enum GrantType {
  /** Used for the initial flow after LWA, one-time usage. */
  AuthorizationCode = 'AUTHORIZATION_CODE',
  /** Used for follow up refreshes, can be used as many times as needed. */
  RefreshToken = 'REFRESH_TOKEN'
}

/** GrantVIPError contains details about a client error that occurred. */
export type GrantVipError = {
   __typename?: 'GrantVIPError';
  /** The type of error that occurred when granting VIP status. */
  code: GrantVipErrorCode;
};

/** GrantVIPErrorCode defines a client error that occurred while granting the VIP status. */
export enum GrantVipErrorCode {
  /** The channel does not exist. */
  ChannelNotFound = 'CHANNEL_NOT_FOUND',
  /** The granter does not have permission to grant VIP status in this channel. */
  Forbidden = 'FORBIDDEN',
  /** The user who is to be granted the VIP status actually already has the VIP status. */
  GranteeAlreadyVip = 'GRANTEE_ALREADY_VIP',
  /** The user who is to be granted the VIP status is banned or timed out in this channel. */
  GranteeChatBanned = 'GRANTEE_CHAT_BANNED',
  /** The user who is to be granted the VIP status does not exist. */
  GranteeNotFound = 'GRANTEE_NOT_FOUND',
  /** The channel has reached the maximum number of users with the VIP status and cannot grant the status to any more users. */
  MaxVipsReached = 'MAX_VIPS_REACHED',
  /** The channel has not completed the VIP Achievement to unlock the VIP feature. */
  VipAchievementIncomplete = 'VIP_ACHIEVEMENT_INCOMPLETE'
}

/** GrantVIPInput contains the parameters to grant the VIP status to a user for a channel. */
export type GrantVipInput = {
  /** The channel for which the VIP status of a user will be granted. */
  channelID: Scalars['ID'];
  /**
   * The ID of the user who will be granted the VIP status.
   * Either granteeID or granteeLogin must be provided.
   */
  granteeID?: Maybe<Scalars['ID']>;
  /**
   * The login of the user who will be granted the VIP status.
   * Either granteeID or granteeLogin must be provided.
   */
  granteeLogin?: Maybe<Scalars['String']>;
};

/** GrantVIPPayload is the response after attemping to grant the VIP status to a user. */
export type GrantVipPayload = {
   __typename?: 'GrantVIPPayload';
  /** The channel for which the VIP status of the user was granted. */
  channel?: Maybe<User>;
  /**
   * The client error that has occurred.
   * Null if the operation is successful.
   */
  error?: Maybe<GrantVipError>;
  /** The user who was granted the VIP status. */
  grantee?: Maybe<User>;
};

/** Different types of granularities supported. */
export enum Granularity {
  /** Bucketed by five minute intervals. */
  FiveMinute = 'FIVE_MINUTE',
  /** Bucketed by day intervals. */
  Day = 'DAY',
  /** Bucketed by week intervals. */
  Week = 'WEEK',
  /** Bucketed by month intervals. */
  Month = 'MONTH'
}

/** The hearthstone game mode that was played. */
export type HearthsoneMomentGameMode = {
   __typename?: 'HearthsoneMomentGameMode';
  /** The game type (e.g. Ranked, Casual, Arena, Pack Opening, etc.). */
  type: Scalars['String'];
  /** The value for the game type (e.g. 0-11 for Arena, Priest vs Warlock for Ranked). */
  value?: Maybe<Scalars['String']>;
};

/** Moment Details specific to the hearthstone game. */
export type HearthstoneMomentDetails = {
   __typename?: 'HearthstoneMomentDetails';
  /** The broadcasters hero, can be null. */
  broadcasterHero?: Maybe<HearthstoneMomentHero>;
  /** The game mode that was played, can be null. */
  gameMode?: Maybe<HearthsoneMomentGameMode>;
  /** The oponents hero, can be null. */
  opponentHero?: Maybe<HearthstoneMomentHero>;
};

/** The hero that either the broadcaster or opponent played. */
export type HearthstoneMomentHero = {
   __typename?: 'HearthstoneMomentHero';
  /** The hero's (capitalized) class. */
  class: Scalars['String'];
  /** The hero's id. */
  id: Scalars['ID'];
  /** The hero's (capitalized) name. */
  name: Scalars['String'];
};

/** The hero preset. */
export enum HeroPreset {
  /** The first preset. */
  Preset_1 = 'PRESET_1',
  /** The second preset. */
  Preset_2 = 'PRESET_2'
}

/** HiddenView holds the view configuration of an extension if it is a hidden load test extension. */
export type HiddenView = ExtensionView & {
   __typename?: 'HiddenView';
  /** Specifies whether or not the extension has the ability to link to external websites. */
  canLinkExternalContent: Scalars['Boolean'];
  /** Relative path of the HTML file to load for this view, used by devsite to specify the layout of assets. */
  viewerPath: Scalars['String'];
  /** The URL which should be loaded in for the extension. */
  viewerURL: Scalars['String'];
};

/** HiddenView holds the view configuration of an extension if it is a hidden load test extension. */
export type HiddenViewInput = {
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

/** Input to describe a single continuous time range of the source VOD to be included in the highlight. */
export type HighlightRange = {
  /** The end time offset in milliseconds into the VOD. */
  endMs: Scalars['Int'];
  /** The start time offset in milliseconds into the VOD. */
  startMs: Scalars['Int'];
  /** The ID of the source VOD to create a Highlight from. */
  vodID: Scalars['ID'];
};

/** Paginated list of Users hosting a particular target User. */
export type HostConnection = {
   __typename?: 'HostConnection';
  /** Users hosting a target User. */
  edges?: Maybe<Array<HostEdge>>;
  /** Pagination information for this connection. */
  pageInfo: PageInfo;
  /** The total number of users hosting a target. */
  totalCount?: Maybe<Scalars['Int']>;
};

/** Edge between Users hosting a target. */
export type HostEdge = {
   __typename?: 'HostEdge';
  /** Unique identifier for each Users hosting. */
  cursor: Scalars['Cursor'];
  /** A User hosting. */
  node?: Maybe<User>;
};

/** HostTargetChannelError contains a error code. */
export type HostTargetChannelError = {
   __typename?: 'HostTargetChannelError';
  /** The type of error that occurred when trying to host. */
  code: HostTargetChannelErrorCode;
};

/** HostTargetChannelErrorCode are the list of thrown errors. */
export enum HostTargetChannelErrorCode {
  /** The target channel does not exist. */
  TargetChannelNotFound = 'TARGET_CHANNEL_NOT_FOUND',
  /** The target channel is already being hosted. */
  TargetChannelAlreadyHosted = 'TARGET_CHANNEL_ALREADY_HOSTED',
  /** Cannot host any more times over this period. */
  HostLimit = 'HOST_LIMIT'
}

/** HostTargetChannelInput contains the necessary inputs to host a target channel. */
export type HostTargetChannelInput = {
  /** Channel ID where host was initiated on. */
  channelID: Scalars['ID'];
  /** Target channel ID to host. */
  targetID: Scalars['ID'];
};

/** HostTargetChannelPayload is the response after attempting to host. */
export type HostTargetChannelPayload = {
   __typename?: 'HostTargetChannelPayload';
  /**
   * The client error that has occurred.
   * Null if the operation is successful.
   */
  error?: Maybe<HostTargetChannelError>;
  /** The channel that is hosting. */
  source?: Maybe<User>;
  /** The target channel that is hosted. */
  target?: Maybe<User>;
};

/** The wrapper structure that contains information regarding a Hype Train. */
export type HypeTrain = {
   __typename?: 'HypeTrain';
  /**
   * Configuration for Hype Trains for a channel, normally loaded this way when configuring the Hype Train from the
   * Broadcaster's perspective.
   */
  config?: Maybe<HypeTrainConfig>;
  /** Information pertaining to executions of Hype Trains in a channel. This is loaded on channel page load. */
  execution?: Maybe<HypeTrainExecution>;
};

/** The Hype Train reward that's a Badge. */
export type HypeTrainBadgeReward = HypeTrainReward & {
   __typename?: 'HypeTrainBadgeReward';
  /** The badge that is to be entitled. */
  badge?: Maybe<Badge>;
  /** The identifier of the reward. */
  id: Scalars['ID'];
  /** The type of reward, which will be HypeTrainRewardType.BADGE. */
  type: HypeTrainRewardType;
};

/** A conductor of the Hype Train. */
export type HypeTrainConductor = {
   __typename?: 'HypeTrainConductor';
  /** The participation that made them the Hype Train conductor. */
  participation: Array<HypeTrainParticipation>;
  /** The conductor source. */
  source: HypeTrainParticipationSource;
  /** The user object that is the conductor. */
  user: User;
};

/** The configured conductor rewards for a given participation source. */
export type HypeTrainConductorReward = {
   __typename?: 'HypeTrainConductorReward';
  /** The rewards entitled for being the conductor and contributing from this source. */
  rewards: Array<HypeTrainReward>;
  /** The source that the conductor participated from. */
  source: HypeTrainParticipationSource;
  /** The type of conductor that gets this reward. */
  type: HypeTrainConductorType;
};

/** The conductor type of the Hype Train reward. */
export enum HypeTrainConductorType {
  /** The current conductor of an active hype train. */
  Current = 'CURRENT',
  /** The former conductor of a hype train. */
  Former = 'FORMER',
  /** An unknown conductor type. */
  Unknown = 'UNKNOWN'
}

/** The Hype Train config for a channel. */
export type HypeTrainConfig = {
   __typename?: 'HypeTrainConfig';
  /**
   * A custom setting that will be an emote that the user has chosen (or PogChamp
   * if not set) to display in their Hype Train events.
   */
  calloutEmote?: Maybe<Emote>;
  /** The conductor rewards for a Hype Train successful execution. */
  conductorRewards: Array<HypeTrainConductorReward>;
  /** The cooldown period between Hype Train executions. */
  cooldownPeriodMinutes: Scalars['Int'];
  /** The difficulty of the Hype Train. */
  difficulty: HypeTrainDifficulty;
  /** The configured levels of the Hype Train. */
  difficultySettings: Array<HypeTrainDifficultySettings>;
  /** The identifier for the hype train. */
  id: Scalars['ID'];
  /** The boolean flag that denotes if the Hype Train is enabled or not. */
  isEnabled: Scalars['Boolean'];
  /** The structure that holds the parameters for tweaking how a Hype Train gets kicked off. */
  kickoff: HypeTrainKickoffConfig;
  /** The duration a Hype Train level executes for. */
  levelDurationSeconds: Scalars['Int'];
  /** The threshold for a notification to be displayed. */
  notificationThresholds: Array<HypeTrainNotificationThreshold>;
  /** The conversion rates for all the actions that contribute to Hype Train progress. */
  participationConversionRates: Array<HypeTrainParticipationConversionRate>;
  /** A custom setting, which is a hex string, that will render the Hype Train progress bar this base color. */
  themeColor: Scalars['String'];
};

/** The difficulty a Hype Train can be set to. */
export enum HypeTrainDifficulty {
  /** Easy, the easiest difficulty level. */
  Easy = 'EASY',
  /** Medium, the middle difficulty level. */
  Medium = 'MEDIUM',
  /** Hard, the hard difficulty level. */
  Hard = 'HARD',
  /** Super Hard, the harder difficulty level. */
  SuperHard = 'SUPER_HARD',
  /** Insane, the hardest difficulty level. */
  Insane = 'INSANE',
  /** An unknown difficulty. */
  Unknown = 'UNKNOWN'
}

/** A mapping between a difficulty and the levels that correspond. */
export type HypeTrainDifficultySettings = {
   __typename?: 'HypeTrainDifficultySettings';
  /** The difficulty of the level. */
  difficulty: HypeTrainDifficulty;
  /** The levels associated with the difficulty. */
  levels: Array<HypeTrainLevel>;
};

/** The Hype Train reward that's an Emote. */
export type HypeTrainEmoteReward = HypeTrainReward & {
   __typename?: 'HypeTrainEmoteReward';
  /** The emote that is to be entitled. */
  emote?: Maybe<Emote>;
  /** The identifier of the reward. */
  id: Scalars['ID'];
  /** The type of reward, which will be HypeTrainRewardType.EMOTE. */
  type: HypeTrainRewardType;
};

/** The enumerated end reasons for a Hype Train. */
export enum HypeTrainEndReason {
  /** The Hype Train expired, which means that the Hype Train never completed level 1 after being started. */
  Expired = 'EXPIRED',
  /** The Hype Train is in progress, which means it has not ended. */
  InProgress = 'IN_PROGRESS',
  /** The Hype Train was completed, which means that any level was completed. */
  Completed = 'COMPLETED',
  /** An unknown ending reason. */
  Unknown = 'UNKNOWN'
}

/** The structure that defines Hype Train Execution in a channel. */
export type HypeTrainExecution = {
   __typename?: 'HypeTrainExecution';
  /** The conductors of the Hype Train. */
  conductors: Array<HypeTrainConductor>;
  /** The Hype Train config that the train was started with. */
  config: HypeTrainConfig;
  /** The reason the Hype Train was ended, if it has been ended. */
  endReason?: Maybe<HypeTrainEndReason>;
  /** The time the Hype Train was ended, if the Hype Train was a previous execution. */
  endedAt?: Maybe<Scalars['Time']>;
  /** The time that the Hype Train will expire at. */
  expiresAt: Scalars['Time'];
  /** The identifier of the execution. */
  id: Scalars['ID'];
  /** Boolean flag that denotes if the Hype Train is active or not. */
  isActive: Scalars['Boolean'];
  /** The participation events in the Hype Train. */
  participations: Array<HypeTrainParticipation>;
  /** The progress structure that contains relevant information about how much progress the Hype Train acheived. */
  progress: HypeTrainProgress;
  /** The time that the Hype Train started. */
  startedAt: Scalars['Time'];
  /** The last time the Hype Train was updated. */
  updatedAt: Scalars['Time'];
};

/** The Hype Train kickoff configuration. */
export type HypeTrainKickoffConfig = {
   __typename?: 'HypeTrainKickoffConfig';
  /** What quantity of current commerce events can trigger a Hype Train. */
  eventsThreshold: Scalars['Int'];
  /** The minimum value of points that the combined events have to equal to kick off a Hype Train. */
  minPoints: Scalars['Int'];
  /** The period of time that is required for these commerce events to occur in to execute a Hype Train. */
  periodSeconds: Scalars['Int'];
};

/** HypeTrainKickoffInput specifies settings for kicking off hype trains. */
export type HypeTrainKickoffInput = {
  /** The number of qualifying events needed to kickoff a hype train. */
  eventsThreshold?: Maybe<Scalars['Int']>;
};

/** The Hype Train level configuration, which includes information about level completion and associated rewards. */
export type HypeTrainLevel = {
   __typename?: 'HypeTrainLevel';
  /** The value of participation that will take to complete the level. */
  goal: Scalars['Int'];
  /** The level ID. */
  id: Scalars['ID'];
  /** The associated rewards for completing the level. */
  rewards: Array<HypeTrainReward>;
  /** The value of the level, like Level 1, 2, etc. Can be configurable. */
  value: Scalars['Int'];
};

/** The notification threshold for an action / source combination. */
export type HypeTrainNotificationThreshold = {
   __typename?: 'HypeTrainNotificationThreshold';
  /** The action performed. */
  action: HypeTrainParticipationAction;
  /** The source of the action. */
  source: HypeTrainParticipationSource;
  /** The value that is the theshold for displaying a notification. */
  value: Scalars['Int'];
};

/** The Hype Train participation structure that contains relevant information about the participation event. */
export type HypeTrainParticipation = {
   __typename?: 'HypeTrainParticipation';
  /** The type of participation. */
  action: HypeTrainParticipationAction;
  /** The amount that the participation is valued in the Hype Train progress. */
  quantity: Scalars['Int'];
  /** The participation source. */
  source: HypeTrainParticipationSource;
};

/** The participation action of events in a Hype Train. */
export enum HypeTrainParticipationAction {
  /** A Cheer event. */
  Cheer = 'CHEER',
  /** A use of bits in extensions. */
  BitsOnExtension = 'BITS_ON_EXTENSION',
  /** A poll bits usage. */
  Polls = 'POLLS',
  /** A tier 1 sub purchase. */
  Tier_1Sub = 'TIER_1_SUB',
  /** A tier 2 sub purchase. */
  Tier_2Sub = 'TIER_2_SUB',
  /** A tier 3 sub purchase. */
  Tier_3Sub = 'TIER_3_SUB',
  /** A tier 1 sub gift. */
  Tier_1GiftedSub = 'TIER_1_GIFTED_SUB',
  /** A tier 2 sub gift. */
  Tier_2GiftedSub = 'TIER_2_GIFTED_SUB',
  /** A tier 3 sub gift. */
  Tier_3GiftedSub = 'TIER_3_GIFTED_SUB',
  /** An unkonwn action. */
  Unknown = 'UNKNOWN'
}

/** The participation conversion rate for what an action will count towards the Hype Train. */
export type HypeTrainParticipationConversionRate = {
   __typename?: 'HypeTrainParticipationConversionRate';
  /** The action performed. */
  action: HypeTrainParticipationAction;
  /** The source of the action. */
  source: HypeTrainParticipationSource;
  /** The rate that it will be converted as in the Hype Train progress calculations. */
  value: Scalars['Int'];
};

/** The Hype Train participation source that denotes the commerce types that can occur. */
export enum HypeTrainParticipationSource {
  /** Bits source, like cheering. */
  Bits = 'BITS',
  /** Subs source, like subbing to twitch.tv/michael on stream. */
  Subs = 'SUBS',
  /** An unknown source. */
  Unknown = 'UNKNOWN'
}

/** The structure that contains relevant information about the current progress in the Hype Train. */
export type HypeTrainProgress = {
   __typename?: 'HypeTrainProgress';
  /** The goal value that the Hype Train is trying to complete. */
  goal: Scalars['Int'];
  /** The Level that the Hype Train is currently on. */
  level: HypeTrainLevel;
  /** The current progression that the channel has made in the level. */
  progression: Scalars['Int'];
  /** The number of seconds left until this Hype Train execution ends. */
  remainingSeconds: Scalars['Int'];
  /** The total progression overall that has occurred in the Hype Train across all levels. */
  total: Scalars['Int'];
};

/** The hype train reward interface, which has to implement an identifier and the hype train reward type. */
export type HypeTrainReward = {
  /** The identifier of the reward. */
  id: Scalars['ID'];
  /** The type of reward that is entitled. */
  type: HypeTrainRewardType;
};

/** The enumerated types of rewards that can be entitled. */
export enum HypeTrainRewardType {
  /** Emote rewards. */
  Emote = 'EMOTE',
  /** Badge rewards. */
  Badge = 'BADGE',
  /** An unknown reward type. */
  Unknown = 'UNKNOWN'
}

export type Image = {
   __typename?: 'Image';
  /** The original height of the image in pixels. */
  height: Scalars['Int'];
  /**
   * The URL source of the image.
   * @deprecated Use the 'url' query instead.
   */
  imageURL: Scalars['String'];
  /** The URL source of the image. */
  url: Scalars['String'];
  /** The original width of the image in pixels. */
  width: Scalars['Int'];
};


export type ImageUrlArgs = {
  width?: Maybe<Scalars['Int']>;
  height?: Maybe<Scalars['Int']>;
};

export type ImageOptions = {
  /** The height of the image in pixels. */
  height?: Maybe<Scalars['Int']>;
  /** The width of the image in pixels. */
  width?: Maybe<Scalars['Int']>;
};

/** Friend requests sent from other users to this user. */
export type IncomingFriendRequestConnection = {
   __typename?: 'IncomingFriendRequestConnection';
  /** The friend request elements of this list. */
  edges: Array<IncomingFriendRequestEdge>;
  /**
   * The most recent incoming friend request received by this user, if any exist. This field is provided as a
   * convenience, as edges is not strictly time-ordered. The incoming friend request's presence in this field does not
   * prevent it from also occurring in edges.
   */
  newestEdge?: Maybe<IncomingFriendRequestEdge>;
  /** Information about this page. */
  pageInfo: PageInfo;
  /** The total number of incoming friend requests. */
  totalCount: Scalars['Int'];
  /** The total number of unseen incoming friend requests. Use the ClearUnreadFriendRequests mutation to set this to 0. */
  totalUnreadCount: Scalars['Int'];
};

/** A friend request sent from another user to this user. */
export type IncomingFriendRequestEdge = {
   __typename?: 'IncomingFriendRequestEdge';
  /** The time at which the friend request was sent. */
  createdAt: Scalars['Time'];
  /** An opaque cursor identifying the edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** The user who sent the friend request. */
  node?: Maybe<User>;
};

/** Determines what other channels can raid this channel. */
export enum IncomingRaidsPolicy {
  /** This user cannot be radied by anyone. */
  None = 'NONE',
  /** This user can be raided by other people in their network. */
  Network = 'NETWORK',
  /** This user can be raided by anyone. */
  All = 'ALL'
}

/** IngestFrameDrop represent an event where a video frame is dropped while ingesting a video stream. */
export type IngestFrameDrop = {
   __typename?: 'IngestFrameDrop';
  /** Duration of events in seconds. */
  durationSeconds: Scalars['Float'];
  /** Start time of the event. */
  startedAt: Scalars['Time'];
};

/** IngestSession is a set of stream metadata related to ingest events. */
export type IngestSession = {
   __typename?: 'IngestSession';
  /** Type of live stream. */
  broadcastFormat: BroadcastFormat;
  /** Staff-only field. Hostname for the session where ingest stream was received. */
  ingestHost?: Maybe<Scalars['String']>;
  /** Name of Ingest Server PoP that received the broadcast. Ex) IAD or PDX. */
  ingestProxy: Scalars['String'];
  /** How many seconds were intentionally delayed in stream as requested by the broadcaster. */
  streamDelaySeconds: Scalars['Int'];
  /** The time when the stream was ended. */
  streamDownAt?: Maybe<Scalars['Time']>;
  /** The time when the stream was started. */
  streamUpAt?: Maybe<Scalars['Time']>;
};

/** IngestStarvationEvent represent an event where an expected video frame from broadcaster does not arrive. */
export type IngestStarvationEvent = {
   __typename?: 'IngestStarvationEvent';
  /** Duration of events in seconds. */
  durationSeconds: Scalars['Float'];
  /** Starr time of the event. */
  startedAt: Scalars['Time'];
};

/** Set of codes to warn the broadcaster about what is wrong with the stream. */
export type IngestStreamHealth = {
   __typename?: 'IngestStreamHealth';
  /** Reasons why the stream is unstable. */
  reasons?: Maybe<Array<IngestStreamHealthReason>>;
  /** Indicate whether the stream is at okay, warning or unstable status. */
  status: IngestStreamHealthStatus;
};

/** Reason of why the stream is unstable. */
export enum IngestStreamHealthReason {
  /** Reason not set. */
  Unknown = 'UNKNOWN',
  /** Stream is behaving normally. */
  AllGood = 'ALL_GOOD',
  /** Broadcaster's encoder is sending an incompatible audio codec. */
  IncompAudioCodec = 'INCOMP_AUDIO_CODEC',
  /** Broadcaster's encoder is sending an incompatible video codec. */
  IncompVideoCodec = 'INCOMP_VIDEO_CODEC',
  /** Broadcaster's encoder is using a deprecated MP3 audio codec. */
  IncompMp3Deprecated = 'INCOMP_MP3_DEPRECATED',
  /** The stream is unstable due to high bitrate of the stream. */
  HighBitrate = 'HIGH_BITRATE',
  /** Some frames are being dropped by the broadcaster's encoder. */
  DroppedFrames = 'DROPPED_FRAMES',
  /** Ingest server expects video segments in sequence, but the server did not receive them from the client. */
  Starvation = 'STARVATION',
  /** The interval between each key frame is too high. */
  HighKeyFrameInterval = 'HIGH_KEY_FRAME_INTERVAL'
}

/** Health of the stream to inform the broadcaster. */
export enum IngestStreamHealthStatus {
  /** Health Status not set. */
  Unknwon = 'UNKNWON',
  /** The stream is ingested okay. */
  Ok = 'OK',
  /** The stream is at warning level. */
  Warn = 'WARN',
  /** The stream is unstable. */
  Unstable = 'UNSTABLE'
}

/** InstallExtensionError is wrapper for error associated with the installExtension mutation. */
export type InstallExtensionError = {
   __typename?: 'InstallExtensionError';
  /** Error code. */
  code: InstallExtensionErrorCode;
  /** The installation id if got EXTENSION_ALREADY_INSTALLED error. */
  installationID?: Maybe<Scalars['ID']>;
};

/** InstallExtensionErrorCode is an error code associated with InstallExtensionError. */
export enum InstallExtensionErrorCode {
  /** User is unable to make modifications to the extension. */
  Unauthorized = 'UNAUTHORIZED',
  /** Channel id is invalid, for example, is empty. */
  InvalidChannelId = 'INVALID_CHANNEL_ID'
}

/** The required input for an installExtension mutation. */
export type InstallExtensionInput = {
  /** The channelID the user is installing the extension on. */
  channelID: Scalars['ID'];
  /** The composite ID of an extension <extensionID:version>. */
  extensionID: Scalars['ID'];
};

/** The result of an installExtension mutation. */
export type InstallExtensionPayload = {
   __typename?: 'InstallExtensionPayload';
  /** The error when the mutation fails to install extension. */
  error?: Maybe<InstallExtensionError>;
  /** The resulting extension installation record from the install. */
  installedExtension?: Maybe<ExtensionInstallation>;
};

/** InternalChargeModel defines a 1P price identifier for the offer. */
export type InternalChargeModel = {
   __typename?: 'InternalChargeModel';
  /** The charge model plan. It will be omitted for consumable purchases (e.g. Bits). */
  plan?: Maybe<ChargeModelPlan>;
  /** Preview of the price. */
  previewPrice?: Maybe<PriceInfo>;
  /** The price identifier. */
  priceID: Scalars['ID'];
  /** The authenticated user's relationship with the internal charge model. */
  self?: Maybe<InternalChargeModelSelfEdge>;
};

/** The authenticated user's relationship with the internal charge model. */
export type InternalChargeModelSelfEdge = {
   __typename?: 'InternalChargeModelSelfEdge';
  /** Contains information on the final checkout price of this offer. */
  checkoutPrice?: Maybe<ProductPurchase>;
};


/** The authenticated user's relationship with the internal charge model. */
export type InternalChargeModelSelfEdgeCheckoutPriceArgs = {
  quantity: Scalars['Int'];
  paymentProvider: PaymentProvider;
};

/** InterruptScheduleBoundsError represents errors that are due to input being out of bounds. */
export type InterruptScheduleBoundsError = InterruptScheduleError & {
   __typename?: 'InterruptScheduleBoundsError';
  /** Error code. */
  code: InterruptScheduleErrorCode;
  /** If the error is related to an input out of service-defined bounds, provide the maximum allowed value. */
  maximum?: Maybe<Scalars['Int']>;
  /** If the error is related to an input out of service-defined bounds, provide the miniimum allowed value. */
  minimum?: Maybe<Scalars['Int']>;
};

/** InterruptScheduleError is a wrapper for error associated with the CreateScheduleSegment mutation. */
export type InterruptScheduleError = {
  /** Error code. */
  code: InterruptScheduleErrorCode;
};

/** The possible errors. */
export enum InterruptScheduleErrorCode {
  /** Not authorized to disable the schedule. */
  Forbidden = 'FORBIDDEN',
  /** The schedule was not found. */
  NotFound = 'NOT_FOUND',
  /** EndAt is too far in the future. */
  EndTooFarInFuture = 'END_TOO_FAR_IN_FUTURE',
  /** The argument is invalid and does not map to a known error. */
  InvalidArgument = 'INVALID_ARGUMENT'
}

/** The input to interrupt a schedule. */
export type InterruptScheduleInput = {
  /** The end time when the schedule will no longer be disabled. */
  endAt: Scalars['Time'];
  /** The reason the schedule was disabled. */
  reason: ScheduleInterruptionReason;
  /** The id of the schedule. */
  scheduleID: Scalars['ID'];
  /** The start time when the schedule will be disabled. */
  startAt: Scalars['Time'];
  /** The geographic timezone of the new segment defined by IANA; i.e. "America/Los_Angeles". */
  timezone: Scalars['String'];
};

/** The payload returned when interrupting a schedule. */
export type InterruptSchedulePayload = {
   __typename?: 'InterruptSchedulePayload';
  /** The possible error. */
  error?: Maybe<InterruptScheduleError>;
  /** The updated stream schedule. */
  schedule?: Maybe<Schedule>;
};

/** InterruptScheduleStandardError represents general errors that are not related to bound errors. */
export type InterruptScheduleStandardError = InterruptScheduleError & {
   __typename?: 'InterruptScheduleStandardError';
  /** Error code. */
  code: InterruptScheduleErrorCode;
};

/** Arguments for the invalidation of all of a user's sessions. */
export type InvalidateAuthenticatedSessionsInput = {
  /** Session to keep alive. */
  keepSession?: Maybe<Scalars['String']>;
  /** Twitch user owner of the sessions. */
  userID: Scalars['ID'];
};

/** Payload after invalidating sessions. */
export type InvalidateAuthenticatedSessionsPayload = {
   __typename?: 'InvalidateAuthenticatedSessionsPayload';
  /** Twitch User. */
  user?: Maybe<User>;
};

/** InvalidateEmailAssociationPayload is input required to mark a user as not owning an email address. */
export type InvalidateEmailAssociationInput = {
  /** Email address that is incorrectly attributed to a user. */
  email: Scalars['String'];
  /** EmailAssociationOpaqueID is the OpaqueID of the association to the above email. */
  emailAssociationOpaqueID: Scalars['ID'];
};

/** InvalidateEmailAssociationPayload is the response payload. */
export type InvalidateEmailAssociationPayload = {
   __typename?: 'InvalidateEmailAssociationPayload';
  /** HasSucceeded indicates whether or not the request has succeeded. */
  hasSucceeded: Scalars['Boolean'];
};

/** Contains the inventory for a particular user, which consists of drops. */
export type Inventory = {
   __typename?: 'Inventory';
  /** The drops awarded to this user via Drops 1.0 and triggered by game publishers according to minutes watched data. */
  drops?: Maybe<UserDropAwardConnection>;
  /** The drops awarded to this user via Drops 2.0 and triggered by broadcaster's game events. */
  gameEventDrops?: Maybe<Array<Maybe<UserDropReward>>>;
};

export type JoinChannelRoomsInput = {
  channelID: Scalars['ID'];
};

export type JoinChannelRoomsPayload = {
   __typename?: 'JoinChannelRoomsPayload';
  channel?: Maybe<User>;
};

/** Inputs to the joinRaid mutation. */
export type JoinRaidInput = {
  /** The raid ID being joined by the user. */
  raidID: Scalars['ID'];
};

/** Outputs from the joinRaid mutation. */
export type JoinRaidPayload = {
   __typename?: 'JoinRaidPayload';
  /** The ID of the raid that was joined by the user. */
  raidID?: Maybe<Scalars['ID']>;
};

/** The connection of key batches for a given key pool. */
export type KeyBatchConnection = {
   __typename?: 'KeyBatchConnection';
  /** The list of key batch edges in the connection. */
  edges: Array<KeyBatchEdge>;
  /** The metadata about having more key batches to fetch, or if there is a previous page of key batches. */
  pageInfo: PageInfo;
  /** The total number of key batches for the key pool. */
  totalCount: Scalars['Int'];
};

/** The key batch edge which contains our cursor and node. */
export type KeyBatchEdge = {
   __typename?: 'KeyBatchEdge';
  /** The cursor of the edge, which is the key batch ID. */
  cursor: Scalars['Cursor'];
  /** The node of the edge, which contains all information about the key batch. */
  node?: Maybe<KeyBatchNode>;
};

/** The information associated with a given key batch. */
export type KeyBatchNode = {
   __typename?: 'KeyBatchNode';
  /** The key batch ID, which is unique for a given key pool. */
  id: Scalars['ID'];
  /** The number of keys in the batch. */
  numKeys: Scalars['Int'];
  /** The status of the batch. */
  status: KeyBatchStatus;
};

/** An enumeration of key batch statuses. */
export enum KeyBatchStatus {
  /** The key batch is active and keys generated from it can be claimed. */
  Active = 'ACTIVE',
  /** The key batch is inactive and keys generated from it cannot be claimed. */
  Inactive = 'INACTIVE',
  /** The key batch is invalid and keys generated from it are invalidated. */
  Invalidated = 'INVALIDATED'
}

/** The connection of key pools to a user. */
export type KeyPoolConnection = {
   __typename?: 'KeyPoolConnection';
  /** The list of key pool edges associated with the user. */
  edges: Array<KeyPoolEdge>;
  /** The metadata about having more key pools to fetch, or if there is a previous page of key pools. */
  pageInfo: PageInfo;
  /** The total number of key pools for the given user. */
  totalCount: Scalars['Int'];
};

/** The key pool edge which contains our cursor and node. */
export type KeyPoolEdge = {
   __typename?: 'KeyPoolEdge';
  /** The cursor of the edge, which is also the key pool ID. */
  cursor: Scalars['Cursor'];
  /** The node of the edge, which contains all information about the key pool. */
  node?: Maybe<KeyPoolNode>;
};

/** The information associated with a given key pool. */
export type KeyPoolNode = {
   __typename?: 'KeyPoolNode';
  /** The key batches that have been generated in the key pool. */
  batches?: Maybe<KeyBatchConnection>;
  /** The description of the key pool. */
  description: Scalars['String'];
  /** The key pool ID, which is unique. */
  id: Scalars['ID'];
  /** The product type associated with the key pool, which determines what kind of keys are generated. */
  productType: Scalars['String'];
  /** The SKU associated with the key pool, which is used to redeem content. */
  sku: Scalars['String'];
  /** Status of the key pool, which can be active, inactive, or invalidated. */
  status: KeyPoolStatus;
};


/** The information associated with a given key pool. */
export type KeyPoolNodeBatchesArgs = {
  after?: Maybe<Scalars['String']>;
};

/** An enumeration of key pool statuses. */
export enum KeyPoolStatus {
  /** The key pool is active and can generate more key batches. */
  Active = 'ACTIVE',
  /** The key pool is inactive and all batches are invalid. */
  Inactive = 'INACTIVE',
  /** The key pool is invalid and new batches cannot be made. */
  Invalidated = 'INVALIDATED'
}

/** An enumeration of broadcaster languages. */
export enum Language {
  /** Arabic. */
  Ar = 'AR',
  /** American Sign Language. */
  Asl = 'ASL',
  /** Bulgarian. */
  Bg = 'BG',
  /** Catalan. */
  Ca = 'CA',
  /** Czech. */
  Cs = 'CS',
  /** Danish. */
  Da = 'DA',
  /** German. */
  De = 'DE',
  /** Greek. */
  El = 'EL',
  /** English. */
  En = 'EN',
  /** Spanish. */
  Es = 'ES',
  /** Finnish. */
  Fi = 'FI',
  /** French. */
  Fr = 'FR',
  /** Hindi. */
  Hi = 'HI',
  /** Hungarian. */
  Hu = 'HU',
  /** Indonesian. */
  Id = 'ID',
  /** Italian. */
  It = 'IT',
  /** Japanese. */
  Ja = 'JA',
  /** Korean. */
  Ko = 'KO',
  /** Malay. */
  Ms = 'MS',
  /** Dutch. */
  Nl = 'NL',
  /** Norwegian. */
  No = 'NO',
  /** Other. */
  Other = 'OTHER',
  /** Polish. */
  Pl = 'PL',
  /** Portuguese. */
  Pt = 'PT',
  /** Romanian. */
  Ro = 'RO',
  /** Russian. */
  Ru = 'RU',
  /** Slovak. */
  Sk = 'SK',
  /** Swedish. */
  Sv = 'SV',
  /** Thai. */
  Th = 'TH',
  /** Tagalog. */
  Tl = 'TL',
  /** Turkish. */
  Tr = 'TR',
  /** Ukrainian. */
  Uk = 'UK',
  /** Vietnamese. */
  Vi = 'VI',
  /** Chinese. */
  Zh = 'ZH',
  /** Chinese (Hong Kong). */
  ZhHk = 'ZH_HK'
}

/**
 * An enumeration of user language tags (shortened BCP 47) available on Twitch.
 * This should not be confused with Language, which is broadcaster language.
 */
export enum LanguageTag {
  /** Arabic. */
  Ar = 'AR',
  /** Bulgarian. */
  Bg = 'BG',
  /** Czech. */
  Cs = 'CS',
  /** Danish. */
  Da = 'DA',
  /** German. */
  De = 'DE',
  /** Greek. */
  El = 'EL',
  /** English. */
  En = 'EN',
  /** English - Great Britain. */
  EnGb = 'EN_GB',
  /** Spanish. */
  Es = 'ES',
  /** Spanish - Mexico. */
  EsMx = 'ES_MX',
  /** Finnish. */
  Fi = 'FI',
  /** French. */
  Fr = 'FR',
  /** Hindi. */
  Hi = 'HI',
  /** Hungarian. */
  Hu = 'HU',
  /** Italian. */
  It = 'IT',
  /** Japanese. */
  Ja = 'JA',
  /** Korean. */
  Ko = 'KO',
  /** Dutch. */
  Nl = 'NL',
  /** Norwegian. */
  No = 'NO',
  /** Polish. */
  Pl = 'PL',
  /** Portuguese. */
  Pt = 'PT',
  /** Portuguese - Brazil. */
  PtBr = 'PT_BR',
  /** Romanian. */
  Ro = 'RO',
  /** Russian. */
  Ru = 'RU',
  /** Slovak. */
  Sk = 'SK',
  /** Swedish. */
  Sv = 'SV',
  /** Thai. */
  Th = 'TH',
  /** Turkish. */
  Tr = 'TR',
  /** Vietnamese. */
  Vi = 'VI',
  /** Chinese - China. */
  ZhCn = 'ZH_CN',
  /** Chinese - Taiwan. */
  ZhTw = 'ZH_TW',
  /** Chinese. */
  Zh = 'ZH'
}

/** The details of Leaderboard format. */
export type LeaderboardDetails = {
   __typename?: 'LeaderboardDetails';
  /** The max participant count for a lobby in phase. Value values are 1-100. */
  lobbyMaxSize: Scalars['Int'];
  /** The number of phases to be created for the competition. Value values are 1-100. */
  phaseCount: Scalars['Int'];
};

/** LeaderboardSet contains the set of leaderboards that are active on a channel. */
export type LeaderboardSet = {
   __typename?: 'LeaderboardSet';
  /** bits contains the leaderboard of top users by number of bits cheered for the channel. */
  bits?: Maybe<UserLeaderboard>;
  /** subGift contains the leaderboard of top users by number of sub gifts given in the channel. */
  subGift?: Maybe<UserLeaderboard>;
};

/** Partner dashboard settings for the bits cheering and sub gifting leaderboards. */
export type LeaderboardSettings = {
   __typename?: 'LeaderboardSettings';
  /** The default leaderboard the user wants to show. */
  defaultLeaderboard: LeaderboardType;
  /** Flag that is true if the user has bits cheering leaderboards turned on. */
  isCheerEnabled: Scalars['Boolean'];
  /** Flag that is true if the user has sub gifting leaderboards turned on. */
  isSubGiftEnabled: Scalars['Boolean'];
  /** The time period the user wants the leaderboard to be displayed as. */
  timePeriod: LeaderboardTimePeriodType;
};

/** LeaderboardTimePeriodType enumerates the various types of supported Leaderboards. */
export enum LeaderboardTimePeriodType {
  /** Daily leaderboards reset at midnight PT. */
  Day = 'DAY',
  /** Weekly leaderboards reset at midnight PT between Sunday and Monday. */
  Week = 'WEEK',
  /** Monthly leaderboards reset at midnight PT on the last day of the month. */
  Month = 'MONTH',
  /** All time leaderboards are cumulative back to when Bits launched in June of 2016. */
  Alltime = 'ALLTIME'
}

/** LeaderboardType enumerates the various types of supported Leaderboards. */
export enum LeaderboardType {
  /** Bits cheering leaderboards. */
  Cheer = 'CHEER',
  /** Sub gifting leaderboards. */
  Subgift = 'SUBGIFT'
}

export type LeaveChannelRoomsInput = {
  channelID: Scalars['ID'];
};

export type LeaveChannelRoomsPayload = {
   __typename?: 'LeaveChannelRoomsPayload';
  channel?: Maybe<User>;
};

/** Inputs to the leaveRaid mutation. */
export type LeaveRaidInput = {
  /** The raid ID being left by the user. */
  raidID: Scalars['ID'];
};

/** Outputs from the leaveRaid mutation. */
export type LeaveRaidPayload = {
   __typename?: 'LeaveRaidPayload';
  /** The ID of the raid that was joined by the user. */
  raidID?: Maybe<Scalars['ID']>;
};

/** LeaveSquadStreamError is the error associated with a leaveSquadStream. */
export type LeaveSquadStreamError = {
   __typename?: 'LeaveSquadStreamError';
  /** The associated error code. */
  code: LeaveSquadStreamErrorCode;
};

/** LeaveSquadStreamErrorCode are the possible errors that this mutation returns. */
export enum LeaveSquadStreamErrorCode {
  /** The user is not in the squad specified. */
  UserNotInSquad = 'USER_NOT_IN_SQUAD',
  /** The operation is unauthorized. */
  Unauthorized = 'UNAUTHORIZED'
}

/** Inputs to the leaveSquadStream mutation. */
export type LeaveSquadStreamInput = {
  /** The optional ID of a squad member that is leaving the squad (defaults to ID from auth token). */
  memberID: Scalars['ID'];
  /** The ID of the squad stream that the caller wants to leave. */
  squadStreamID: Scalars['ID'];
};

/** Outputs from the leaveSquadStream mutation. */
export type LeaveSquadStreamPayload = {
   __typename?: 'LeaveSquadStreamPayload';
  /** The possible error returned from the service. */
  error?: Maybe<LeaveSquadStreamError>;
  /** The updated squad stream. */
  squadStream?: Maybe<SquadStream>;
};

/** LinkOEmbed is a link oEmbed.  This looks strange being empty, but mirrors the oEmbed official spec most exactly. */
export type LinkOEmbed = OEmbed & {
   __typename?: 'LinkOEmbed';
  authorName?: Maybe<Scalars['String']>;
  authorURL?: Maybe<Scalars['String']>;
  cacheAge?: Maybe<Scalars['Int']>;
  inputURL: Scalars['String'];
  providerName?: Maybe<Scalars['String']>;
  providerURL?: Maybe<Scalars['String']>;
  thumbnail?: Maybe<ThumbnailOEmbed>;
  title?: Maybe<Scalars['String']>;
  type: Scalars['String'];
  version: Scalars['String'];
};

/** LinkSSOError is an error that occurs when account linking fails. */
export type LinkSsoError = {
   __typename?: 'LinkSSOError';
  /** The error code that describes why account linking failed. */
  code: LinkSsoErrorCode;
};

/** LinkSSOErrorCode enumerates the possible errors that can cause account linking to fail. */
export enum LinkSsoErrorCode {
  /** The activation code is incorrect. */
  CodeIncorrect = 'CODE_INCORRECT',
  /** The activation code is expired. */
  CodeExpired = 'CODE_EXPIRED',
  /** The user has already linked an SSO app of the same type to their account. */
  AlreadyLinked = 'ALREADY_LINKED'
}

/** LinkSSOInput links an SSO app to the authenticated user's account if the activation code is valid. */
export type LinkSsoInput = {
  /** The code that identifies the single sign-on (SSO) app that should be linked to the authenticated user's account. */
  code: Scalars['String'];
};

/** LinkSSOPayload returns the newly created link or an error if account linking failed. */
export type LinkSsoPayload = {
   __typename?: 'LinkSSOPayload';
  /** The error when an app cannot be linked to the user's account. */
  error?: Maybe<LinkSsoError>;
  /** The new SSO link. */
  link?: Maybe<SsoLink>;
};

/** The location that a piece of text should link to. */
export enum LinkType {
  /** Do not link to anything. */
  NoLink = 'NO_LINK',
  /** Link to the categories directory (on web: https://www.twitch.tv/directory). */
  CategoriesDirectory = 'CATEGORIES_DIRECTORY',
  /** Link to the streams directory (on web: https://www.twitch.tv/directory/all). */
  StreamsDirectory = 'STREAMS_DIRECTORY'
}

/** LiveConfigView holds the view configuration of an extension if the live config dashboard page is supported. */
export type LiveConfigView = ExtensionView & {
   __typename?: 'LiveConfigView';
  /** Specifies whether or not the extension has the ability to link to external websites. */
  canLinkExternalContent: Scalars['Boolean'];
  /** Relative path of the HTML file to load for this view, used by devsite to specify the layout of assets. */
  viewerPath: Scalars['String'];
  /** The URL which should be loaded in for the extension. */
  viewerURL: Scalars['String'];
};

/** LiveConfigViewInput holds the view configuration of an extension if the live config dashboard page is supported. */
export type LiveConfigViewInput = {
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

export type LiveRecommendationConnection = {
   __typename?: 'LiveRecommendationConnection';
  /** The list of recommended streams with metadata to display. */
  edges?: Maybe<Array<StreamRecommendationEdge>>;
  /** Per-generation tracking id for identifying a recommendation model. */
  generationID: Scalars['String'];
  /**
   * The list of recommended streams to display.
   * @deprecated To be replaced by edges which also includes a required trackingID.
   */
  nodes: Array<Maybe<Stream>>;
  /** Unique tracking id per response. */
  responseID: Scalars['String'];
};

/** Information about the live up notification of a user. */
export type LiveUpNotificationInfo = {
   __typename?: 'LiveUpNotificationInfo';
  /** Whether the user's liveUpNotification field is the default value (i.e. "<user> went live!"). */
  isDefault?: Maybe<Scalars['Boolean']>;
  /**
   * The text that will be in the notification that sends when the user starts broadcasting.
   * The default value is currently a translated version of "<user> went live!" when the user has not set a custom value.
   */
  liveUpNotification?: Maybe<Scalars['String']>;
};

/** The lobby state signifies the progress in the competition. */
export enum LobbyState {
  /** No participants are in lobby. */
  Prep = 'PREP',
  /** Participants have filled the lobby and can be swapped around different lobbies. */
  Ready = 'READY',
  /** Participants are currently playing in the lobby, they can be scored but cannot be swapped to different lobbies. */
  Active = 'ACTIVE',
  /** Participants are all scored and no longer playing. */
  Done = 'DONE',
  /** Lobby state is unknown. */
  Unknown = 'UNKNOWN'
}

/** Communicates a Loyalty Badge (usually during upload). */
export type LoyaltyBadge = {
   __typename?: 'LoyaltyBadge';
  /** Unique identifier the badges method of tenure by channelid and cumulative months. */
  channelTenureMethodID: Scalars['ID'];
  /** The channel's loyalty badge unique identifier. */
  id: Scalars['ID'];
  /** image1xURL to retrieve the 1x sized Badge. */
  image1xURL: Scalars['String'];
  /** Image1xURL to retrieve the 2x sized Badge. */
  image2xURL: Scalars['String'];
  /** image4xURL to retrieve the 4x sized Badge. */
  image4xURL: Scalars['String'];
  /** Identifies the amount of cumulative tenure months to acquire Badge. */
  requiredTenureMonths: Scalars['Int'];
  /**
   * A localized, human-friendly title for the badge.
   * Defaults to English if no translation exists for the requested locale.
   */
  title: Scalars['String'];
};

/** LoyaltyBadgeUploadConfig is the upload configuration for creating loyalty badges. */
export type LoyaltyBadgeUploadConfig = {
   __typename?: 'LoyaltyBadgeUploadConfig';
  /** The image ID of the badge image. */
  imageID?: Maybe<Scalars['ID']>;
  /** The resulting URL of the badge image. */
  imageURL?: Maybe<Scalars['String']>;
  /** The upload ID of the badge file. */
  uploadID?: Maybe<Scalars['ID']>;
  /** The URL to upload the badge image to. */
  uploadURL?: Maybe<Scalars['String']>;
};

/** Caller should store all of these fields. */
export type LwaToken = {
   __typename?: 'LWAToken';
  /** Access token to pass in on subsequent requests. */
  accessToken: Scalars['String'];
  /** TTL in seconds, default is 3600. */
  expiresIn: Scalars['Int'];
  /** Should be stored, though generally shouldn't change. */
  refreshToken: Scalars['String'];
};

/** Input for creating a batch download URL for key codes. */
export type MakeKeyBatchDownloadUrlInput = {
  /** The ID of the batch to download. */
  batchID: Scalars['String'];
};

/** The results of creating a key batch download. */
export type MakeKeyBatchDownloadUrlPayload = {
   __typename?: 'MakeKeyBatchDownloadURLPayload';
  /** The decryption key to decrypt the batch of keys. */
  decryptionKey: Scalars['String'];
  /** The URL created for downloading the batch of keys. */
  url: Scalars['String'];
};

/** A message from a user. */
export type Message = {
   __typename?: 'Message';
  /** The text and emoticon content of a message. */
  content: MessageContent;
  /** Time the message was deleted or purged. Null if the message is not deleted. */
  deletedAt?: Maybe<Scalars['Time']>;
  /** UUID of the message. */
  id: Scalars['ID'];
  /** The user that sent the message. */
  sender?: Maybe<User>;
  /** Time the message was sent. */
  sentAt: Scalars['Time'];
};

/**
 * MessageBody is a way of encoding emote annotated text.  The original text is included as content and the
 * parsed emotes are included which indicate the start and end indexes they should replace.
 */
export type MessageBody = {
   __typename?: 'MessageBody';
  /** The text content of the body. */
  content?: Maybe<Scalars['String']>;
  /** Collection of rune indexed emotes to be replaced clientside. */
  emotes?: Maybe<Array<Maybe<EmbeddedEmote>>>;
};

/** The content of a user's message to a room. */
export type MessageContent = {
   __typename?: 'MessageContent';
  /** Parsed list of fragments in the message, include emotes, mentions, and plaintext. */
  fragments: Array<MessageFragment>;
  /** String representation of the user message. */
  text: Scalars['String'];
};

/** One parsed part of a message, which may be an emote, mention, or plaintext. */
export type MessageFragment = {
   __typename?: 'MessageFragment';
  /** Contains an emote or a mentioned user depending on the text of the fragment. */
  content?: Maybe<FragmentContent>;
  /** Plaintext representation of the fragment. */
  text: Scalars['String'];
};

/** Contains all of the information about a Drop awardable to a user. */
export type MetadataDropObject = {
   __typename?: 'MetadataDropObject';
  /** Information about all benefits of the drop . A reward is a personalized version of a drop. */
  benefits: Array<DropBenefit>;
  /** Information about the personal settings for this Drop. */
  channelSettings: DropChannelSetting;
  /** The drop object including summary data. */
  dropObject: DropObject;
};

/**
 * Milestone is a construct is used within a tournament. For a given threshold, when the user
 * cheers at or past this amount, they are able to claim a reward for cheering at this level.
 * Rewards can be fulfilled by different platforms.
 * Types of milestones:
 * - **Global milestone**: for a given threshold, this milestone is reached when cheers from all
 *   users on the channel is greater than or equal to the threshold.
 *   This unlocks a reward for all users who have cheered.
 * - **Individual milestone**: for a given threshold, this milestone is reached when an individual
 *   user's total cheers in the channel is greater than or equal to the threshold.
 *   This unlocks a reward for the individual user who cheered.
 * - **Team milestone**: for a given threshold, this milestone is reached when an individual cheers
 *   for a specific team in total is greater than or equal to the threshold.
 *   This unlocks a reward for the individual user who cheered.
 * 
 * NOTE: Should have been named CheeringTournamentMilestone.
 */
export type Milestone = {
   __typename?: 'Milestone';
  /**
   * End date for when a milestone is no longer active.
   * @deprecated Field no longer supported
   */
  endDate: Scalars['String'];
  /**
   * GraphQL ID of the milestone.
   * @deprecated Field no longer supported
   */
  id: Scalars['ID'];
  /**
   * Whether the milestone is for prime users only.
   * @deprecated Field no longer supported
   */
  isPrimeOnly: Scalars['Boolean'];
  /**
   * The type of milestone this is for. e.g INDIVIDUAL or GLOBAL.
   * @deprecated Field no longer supported
   */
  objectiveTag: Scalars['String'];
  /**
   * Threshold that needs to be cheered by an individual to claim reward.
   * @deprecated Field no longer supported
   */
  participationThreshold: Scalars['Int'];
  /**
   * The subs that this milestone’s completion requires.
   * @deprecated Field no longer supported
   */
  requiredSubscriptions?: Maybe<Array<SubscriptionProduct>>;
  /**
   * The rewards associated with milestones.
   * @deprecated Field no longer supported
   */
  rewards: Array<TournamentReward>;
  /**
   * Start date for when a milestone is active.
   * @deprecated Field no longer supported
   */
  startDate: Scalars['String'];
  /**
   * Threshold that needs to be cheered to claim reward.
   * @deprecated Field no longer supported
   */
  threshold: Scalars['Int'];
};

/** MobileView holds the view configuration of an extension if mobile is supported. */
export type MobileView = ExtensionView & {
   __typename?: 'MobileView';
  /** Relative path of the HTML file to load for this view, used by devsite to specify the layout of assets. */
  viewerPath: Scalars['String'];
  /** The URL which should be loaded in for the extension. */
  viewerURL: Scalars['String'];
};

/** MobileViewInput holds the view configuration of an extension if mobile is supported. */
export type MobileViewInput = {
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

/** Paginated list of moderators of a channel. */
export type ModConnection = {
   __typename?: 'ModConnection';
  /** The elements of the list. */
  edges: Array<ModEdge>;
  /** Information about this page. */
  pageInfo: PageInfo;
};

/** Element in a list of moderators of a channel. */
export type ModEdge = {
   __typename?: 'ModEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** Timestamp of when the moderator status was granted. */
  grantedAt: Scalars['Time'];
  /** Whether the moderator is connected to the channel's chat. */
  isActive?: Maybe<Scalars['Boolean']>;
  /** The user that is a moderator. */
  node: User;
};

/** An interface to query subsets of the moderation logs information for a given channel. */
export type ModLogs = {
   __typename?: 'ModLogs';
  /** The comments left by moderators on a specified user on the given channel. */
  comments?: Maybe<ModLogsCommentConnection>;
  /** The chat history for an specified user on a given channel. */
  messagesBySender?: Maybe<ModLogsMessageConnection>;
  /** The chat moderation history on a specified user on the given channel. */
  targetedModActions?: Maybe<ModLogsTargetedModActionsConnection>;
};


/** An interface to query subsets of the moderation logs information for a given channel. */
export type ModLogsCommentsArgs = {
  targetID: Scalars['ID'];
  after?: Maybe<Scalars['Cursor']>;
  first?: Maybe<Scalars['Int']>;
  order?: Maybe<SortOrder>;
};


/** An interface to query subsets of the moderation logs information for a given channel. */
export type ModLogsMessagesBySenderArgs = {
  senderID: Scalars['ID'];
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  order?: Maybe<SortOrder>;
  includeMessageCount?: Maybe<Scalars['Boolean']>;
  includeAutoModCaughtMessages?: Maybe<Scalars['Boolean']>;
};


/** An interface to query subsets of the moderation logs information for a given channel. */
export type ModLogsTargetedModActionsArgs = {
  targetID: Scalars['ID'];
  actionType: ModLogsAction;
};

/** ModLogsAccess defines the access level of a channel role to the channel's moderator logs. */
export type ModLogsAccess = {
   __typename?: 'ModLogsAccess';
  /** The access level to moderator logs. */
  accessLevel: ModLogsAccessLevel;
  /** The user role. */
  channelRole: ChannelUserRole;
};

/** Access levels to moderator logs. */
export enum ModLogsAccessLevel {
  /** User cannot read moderator logs or create new entries. */
  None = 'NONE',
  /** User can read moderator log entries. */
  Read = 'READ',
  /** User can read and create moderator log entries. */
  Write = 'WRITE'
}

/** ModLogsAction represents the recorded actions a channel moderator takes on a channel. */
export enum ModLogsAction {
  /** Default Action. */
  InvalidAction = 'INVALID_ACTION',
  /** Channel Mod chat bans a user. */
  BanUser = 'BAN_USER',
  /** Channel Mod chat timeouts a user. */
  TimeoutUser = 'TIMEOUT_USER',
  /** Channel Mod chat unbans a user. */
  UnbanUser = 'UNBAN_USER',
  /** Channel Mod sets chat mode. */
  SetChannelMode = 'SET_CHANNEL_MODE',
  /** Channel Mod changes. */
  ChangeChannelRules = 'CHANGE_CHANNEL_RULES',
  /** Channel Mod approves an automod caught message. */
  AllowMessage = 'ALLOW_MESSAGE',
  /** Channel Mod denies an automod caught message. */
  DenyMessage = 'DENY_MESSAGE',
  /** Channel Mod updates mod terms. */
  UpdateModeratedTerms = 'UPDATE_MODERATED_TERMS',
  /** Channel Mod creates a mod comment about a user. */
  Comment = 'COMMENT',
  /** Channel Mod chat untimeouts a user. */
  UntimeoutUser = 'UNTIMEOUT_USER'
}

/** ModLogsCommentsEntry defines an entry of a user's moderation history on a channel. */
export type ModLogsComment = {
   __typename?: 'ModLogsComment';
  /** Author is the moderator that created the comment. */
  author?: Maybe<User>;
  /** Channel is where the moderator comment was created. */
  channel?: Maybe<User>;
  /** Details about the moderator comment. */
  details?: Maybe<ModLogsCommentDetails>;
  /** UUID of the moderator comment. */
  id: Scalars['ID'];
  /** Target is the target user of the moderator comment. */
  target?: Maybe<User>;
  /** Timestamp when comment was created. */
  timestamp: Scalars['Time'];
};

/** Paginated list of moderator comments on a user in a channel. */
export type ModLogsCommentConnection = {
   __typename?: 'ModLogsCommentConnection';
  /** The elements of the list. */
  edges?: Maybe<Array<ModLogsCommentEdge>>;
  /** Information about this page of mod logs. */
  pageInfo: PageInfo;
};

/** ModLogsCommentDetails contains the details of a moderator comment. */
export type ModLogsCommentDetails = {
   __typename?: 'ModLogsCommentDetails';
  /** Body of the comment. */
  text?: Maybe<Scalars['String']>;
};

/** Element in a list of moderator comments on a user in a channel. */
export type ModLogsCommentEdge = {
   __typename?: 'ModLogsCommentEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** A moderator comment on a user in a channel. */
  node?: Maybe<ModLogsComment>;
};

/** A message sent from a user to a room. */
export type ModLogsMessage = {
   __typename?: 'ModLogsMessage';
  /** The text and emoticon content of a message. */
  content: ModLogsMessageContent;
  /** UUID of the message. */
  id: Scalars['ID'];
  /** The user that sent the message. */
  sender?: Maybe<User>;
  /** Time the message was sent. */
  sentAt: Scalars['Time'];
};

/** Paginated list of messages from a single sender in a channel. */
export type ModLogsMessageConnection = {
   __typename?: 'ModLogsMessageConnection';
  /** The elements of the list. */
  edges: Array<ModLogsMessageEdge>;
  /**
   * The partial count of messages (up to 1000).
   * Empty if includeMessageCount was not set when the query was requested.
   */
  messageCount?: Maybe<Scalars['Int']>;
  /** Information about this page. */
  pageInfo: PageInfo;
};

/** The content of a user's message to a room. */
export type ModLogsMessageContent = {
   __typename?: 'ModLogsMessageContent';
  /** Parsed list of fragments in the message, include emotes, mentions, and plaintext. */
  fragments: Array<ModLogsMessageFragment>;
  /** String representation of the user message. */
  text: Scalars['String'];
};

/** Element in a list of messages. */
export type ModLogsMessageEdge = {
   __typename?: 'ModLogsMessageEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** The message or targeted moderation action. */
  node?: Maybe<ModLogsMessageResult>;
};

/** One parsed part of a message, which may be an emote, mention, or plaintext. */
export type ModLogsMessageFragment = {
   __typename?: 'ModLogsMessageFragment';
  /** Contains an emote or a mentioned user depending on the text of the fragment. */
  content?: Maybe<FragmentContent>;
  /** Plaintext representation of the fragment. */
  text: Scalars['String'];
};

/**
 * ModLogsMessageResult defines the types of entries that appear as mod log
 * messages: Mod Logs (Chat) Messages and Targeted Mod Actions.
 */
export type ModLogsMessageResult = AutoModCaughtMessage | ModLogsMessage | ModLogsTargetedModActionsEntry;

/** Paginated list of mod logs of a user on a channel. */
export type ModLogsTargetedModActionsConnection = {
   __typename?: 'ModLogsTargetedModActionsConnection';
  /**
   * The partial count of targeted mod actions (bans or timeouts), up to 100.
   * Does not count undo actions (unbans or untimeouts).
   */
  actionCount: Scalars['Int'];
  /** The elements of the list. */
  edges?: Maybe<Array<ModLogsTargetedModActionsEdge>>;
  /** Information about this page of mod logs. */
  pageInfo: PageInfo;
};

/** Element in a list of mod logs of a user on a channel. */
export type ModLogsTargetedModActionsEdge = {
   __typename?: 'ModLogsTargetedModActionsEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** A mod log of the user. */
  node?: Maybe<ModLogsTargetedModActionsEntry>;
};

/** ModLogsTargetedModActionsEntry defines an entry of a user's moderation history on a channel. */
export type ModLogsTargetedModActionsEntry = {
   __typename?: 'ModLogsTargetedModActionsEntry';
  /** Action is the mod action of the entry. */
  action: ModLogsAction;
  /** Channel is where the mod action was taken. */
  channel?: Maybe<User>;
  /** Details about the mod action. */
  details?: Maybe<TargetedModActionDetails>;
  /** The UUID of the entry. */
  id: Scalars['ID'];
  /** Target is the target user of the mod action. */
  target?: Maybe<User>;
  /** Timestamp when entry was created. */
  timestamp: Scalars['Time'];
  /** User is the mod that created the action. */
  user?: Maybe<User>;
};

/** ModUserError contains details about a client error that occurred. */
export type ModUserError = {
   __typename?: 'ModUserError';
  /** The enum indicating what error has occurred. */
  code: ModUserErrorCode;
};

/** ModUserErrorCode defines a client error that occurred while adding a moderator. */
export enum ModUserErrorCode {
  /** The requesting user does not have permission to add a moderator in this channel. */
  Forbidden = 'FORBIDDEN',
  /** The target user does not exist or has a suspended account. */
  TargetNotFound = 'TARGET_NOT_FOUND',
  /** The channel does not exist. */
  ChannelNotFound = 'CHANNEL_NOT_FOUND',
  /** The target user is banned or timed out in this channel. */
  TargetIsChatBanned = 'TARGET_IS_CHAT_BANNED',
  /** The target user is already a moderator. */
  TargetAlreadyMod = 'TARGET_ALREADY_MOD'
}

/** ModUserInput contains the parameters to add a user as a moderator to a channel. */
export type ModUserInput = {
  /** The channel that the user will be added as a moderator to. */
  channelID: Scalars['ID'];
  /**
   * The ID of the user that will be added as a moderator.
   * Either targetID or targetLogin must be provided.
   */
  targetID?: Maybe<Scalars['ID']>;
  /**
   * The login of the user that will be added as a moderator.
   * Either targetID or targetLogin must be provided.
   */
  targetLogin?: Maybe<Scalars['String']>;
};

/** ModUserPayload is the response when adding a user as a moderator. */
export type ModUserPayload = {
   __typename?: 'ModUserPayload';
  /** The channel that the user is added as a moderator to. */
  channel?: Maybe<User>;
  /**
   * The client error that has occurred.
   * Null if the operation is successful.
   */
  error?: Maybe<ModUserError>;
  /** The user that is added as a moderator. */
  target?: Maybe<User>;
};

/** Settings for Mod View Page. */
export type ModViewSettings = {
   __typename?: 'ModViewSettings';
  /** Date that tuorial was SEEN (nullable when tutorial is dismissed or unseen). */
  tutorialSeenAt?: Maybe<Scalars['Time']>;
  /** Setting to store whether the user has completed the mod view tutorial. */
  tutorialState?: Maybe<TutorialState>;
};

/** Movie metadata. */
export type MovieDetails = {
   __typename?: 'MovieDetails';
  /** Total length of the content. */
  durationSeconds?: Maybe<Scalars['Int']>;
};

/** A multiplayer ad offer is an ad offer. */
export type MultiplayerAdOffer = {
   __typename?: 'MultiplayerAdOffer';
  /** The duration of the ad in seconds. */
  adDurationSeconds: Scalars['Int'];
  /** The name of the brand associated with the ad. */
  brandName?: Maybe<Scalars['String']>;
  /** The message to be display to the broadcaster. */
  broadcasterMessage?: Maybe<Scalars['String']>;
  /** When the offer expires. */
  expiresAt: Scalars['Time'];
  /** The offer's unique identifier. */
  id: Scalars['ID'];
};

/**
 * Multi-view content attribute(s) are used to augment the multi-view experience.
 * they are used for filterings and groupings of chanlets to help viewers find content that they are interested in.
 */
export type MultiviewContentAttribute = {
   __typename?: 'MultiviewContentAttribute';
  /** childIDs is an optional list of child content attribute ids. */
  childIDs?: Maybe<Array<Scalars['ID']>>;
  /** Time when this content attribute is created. */
  createdAt?: Maybe<Scalars['Time']>;
  /** id is a unique identifier generated on the server side. */
  id: Scalars['ID'];
  /** URL to the image (icon) of the content attribute. */
  imageURL?: Maybe<Scalars['String']>;
  /** key is a grouping identifier for content attributes of the same type. */
  key: Scalars['String'];
  /** name is a human-readable string of the content attribute type. */
  name: Scalars['String'];
  /** ownerChannel is the channel that this content attribute is created under. */
  ownerChannel?: Maybe<Channel>;
  /** parentID is an optional pointer to specify the parent attribute. */
  parentID?: Maybe<Scalars['ID']>;
  /** parentKey is an optional pointer to specifiy the key of the parent attribute. */
  parentKey?: Maybe<Scalars['String']>;
  /** Time when this content attribute is last modified. */
  updatedAt?: Maybe<Scalars['Time']>;
  /** value is the human-readble value of the attribute value. */
  value: Scalars['String'];
  /** valueShortName is an optional abbreviation of value. */
  valueShortName?: Maybe<Scalars['String']>;
};

/** Contains all information to create a new content attribute. */
export type MultiviewContentAttributeParams = {
  /** Optional list of child content attribute ids. */
  childIDs?: Maybe<Array<Scalars['ID']>>;
  /** Unique identifier. */
  id?: Maybe<Scalars['ID']>;
  /** Optional an URL to the icon of this content attribute. */
  imageURL?: Maybe<Scalars['String']>;
  /** Indicates the type of the attribute. */
  key: Scalars['String'];
  /** Human-readable name of the attribute. */
  name: Scalars['String'];
  /** The channel that the content attribute is created under. */
  ownerChannelID?: Maybe<Scalars['ID']>;
  /** Optional pointer to a parent content attribute instance. */
  parentID?: Maybe<Scalars['ID']>;
  /** Optional pointer to a parent content attribute key. */
  parentKey?: Maybe<Scalars['String']>;
  /** value of the attribute. */
  value: Scalars['String'];
  /** Optional abbreviation of value. */
  valueShortName?: Maybe<Scalars['String']>;
};

/** Operations to update data in the Twitch API. */
export type Mutation = {
   __typename?: 'Mutation';
  /**
   * acceptFriendRequest accepts a friend request from the target user to the
   * authenticated user, creating a new Friend relationship.
   */
  acceptFriendRequest?: Maybe<AcceptFriendRequestPayload>;
  /** Accept program agreement during payout onboarding. */
  acceptProgramAgreement?: Maybe<AcceptProgramAgreementPayload>;
  /**
   * acceptSquadStreamInvitation allows a user that has recieved a squad stream invitation to accept and join
   * the squad stream.
   */
  acceptSquadStreamInvitation?: Maybe<AcceptSquadStreamInvitationPayload>;
  /** acknowledgeSubscriptionState allow to apply Acknowledged status to the provided subscription. */
  acknowledgeSubscriptionState?: Maybe<AcknowledgeSubscriptionStatePayload>;
  /**
   * Activate an extension which has been installed on a channel.
   * @deprecated Should use applyExtensionActivations instead
   */
  activateExtension?: Maybe<ActivateExtensionPayload>;
  /** Adds to a user's list of channelIDs to autohost. */
  addAutohostChannels?: Maybe<AddAutohostChannelsPayload>;
  /**
   * addBrowserPushSubscription adds a browser push subscription for receiving browser (desktop) push notifications.
   * The client must retrieve the input fields from the browser's push notification API. Client's will
   * call this when the user opts-in. A browser push subscription is tied to a user's browser (device).
   * Twitch will use these push subscriptions to send browser push notifications.
   * 
   * Spec: https://www.w3.org/TR/push-api/#push-subscription.
   */
  addBrowserPushSubscription?: Maybe<AddBrowserPushSubscriptionPayload>;
  /** Adds a blocked term to a channel. */
  addChannelBlockedTerm?: Maybe<AddChannelBlockedTermPayload>;
  /** Adds a permitted term to a channel. */
  addChannelPermittedTerm?: Maybe<AddChannelPermittedTermPayload>;
  /** addCollectionItem adds an item to a collection. */
  addCollectionItem?: Maybe<AddCollectionItemPayload>;
  /** Add CompetitionPhase to a competition. */
  addCompetitionPhase?: Maybe<AddCompetitionPhasePayload>;
  /** Add CompetitionPlayer to a competition. */
  addCompetitionPlayer?: Maybe<AddCompetitionPlayerPayload>;
  /** Add CompetitionTeam to a competition. */
  addCompetitionTeam?: Maybe<AddCompetitionTeamPayload>;
  /** addDeviceToken associates a new push notification token to the given user. */
  addDeviceToken?: Maybe<AddDeviceTokenPayload>;
  /** Grant a user the editor status for a given channel. */
  addEditor?: Maybe<AddEditorPayload>;
  /**
   * addReaction allows a user to create a reaction for any reactable item in a feed.
   * @deprecated Field no longer supported
   */
  addReaction?: Maybe<AddReactionPayload>;
  /** addRecommendationFeedback allows a user to add feedback about a recommendation they've received. */
  addRecommendationFeedback?: Maybe<AddRecommendationFeedbackPayload>;
  /** Adds a user to stream on behalf of broadcaster. */
  addStreamAuthorizedUser?: Maybe<AddStreamAuthorizedUserPayload>;
  /** Allocates product keys that a broadcaster may need to complete the bounty. */
  allocateKeysForBounty?: Maybe<AllocateKeysForBountyPayload>;
  /** Allows a message rejected on a channel chat. */
  allowRejectedChatMessage?: Maybe<AllowRejectedChatMessagePayload>;
  /** Allows a cheer rejected on a channel chat. */
  allowRejectedCheer?: Maybe<AllowRejectedCheerPayload>;
  /**
   * Apply activation state to a subset of installed extensions. In order to deactivate an installed extension,
   * simply pass a null value in the anchor.
   */
  applyExtensionActivations?: Maybe<ApplyExtensionActivationsPayload>;
  /** Archives a chanlet to remove the chanlet from the parent channel. */
  archiveChanlet?: Maybe<ArchiveChanletPayload>;
  /** Archive a poll with the given poll id. */
  archivePoll?: Maybe<ArchivePollPayload>;
  /** Archive the current poll in a channel. */
  archivePollInChannel?: Maybe<ArchivePollInChannelPayload>;
  /**
   * Assign a billing manager to an extension.
   * The billing manager is the organization's Owner or member with Billing_Manager role that is ready to receive
   * payments for the monetized extension within an organization.
   */
  assignExtensionBillingManager?: Maybe<AssignExtensionBillingManagerPayload>;
  /** Bans a user from chat room permanently or for an specified period of time. */
  banUserFromChatRoom?: Maybe<BanUserFromChatRoomPayload>;
  /** banVideoCommenter bans a user from commenting on a video. */
  banVideoCommenter?: Maybe<BanVideoCommenterPayload>;
  /** Blocks target user from communicating with the current user. */
  blockUser?: Maybe<BlockUserPayload>;
  /**
   * cancelBounty allows a user to cancel a claimed bounty.
   * If the user has not met the requirements to cancel the bounty, an error will be returned.
   */
  cancelBounty?: Maybe<CancelBountyPayload>;
  /** cancelFriendRequest destroys a friend request relationship from the authenticated user to the target user. */
  cancelFriendRequest?: Maybe<CancelFriendRequestPayload>;
  /** Cancel a current payout onboarding workflow. */
  cancelPayoutOnboardingWorkflow?: Maybe<CancelPayoutOnboardingWorkflowPayload>;
  /** Cancel a raid. */
  cancelRaid?: Maybe<CancelRaidPayload>;
  /** cancelSubscriptionGift allows the current user to cancel their gifted subscription to a channel. */
  cancelSubscriptionGift?: Maybe<CancelSubscriptionGiftPayload>;
  /** Mark a gem notification as checked. */
  checkGemNotification?: Maybe<CheckGemNotificationPayload>;
  /**
   * claimBounty allows a user to claim a bounty from a campaign (e.g. Stream a Game Campaign).
   * If the user has not met the requirements to claim it, an error will be returned.
   */
  claimBounty?: Maybe<ClaimBountyPayload>;
  /**
   * claimCommunityPoints allows a user to claim community points that they have available in a channel.
   * If the user does not have a claim available, an error will be returned.
   */
  claimCommunityPoints?: Maybe<ClaimCommunityPointsPayload>;
  /** claimDropRewards allows a user to attempt to claim their rewards from a Drops 2.0 drop. */
  claimDropRewards?: Maybe<ClaimDropRewardsPayload>;
  /** claimPrimeOffer allows a user to create their entitlement to the given offer/content. */
  claimPrimeOffer?: Maybe<ClaimPrimeOfferPayload>;
  /** clearUnreadFriendRequests marks all friend requests for the authenticated user as read. */
  clearUnreadFriendRequests?: Maybe<ClearUnreadFriendRequestsPayload>;
  /** cloneExtensionDiscoveryData copies the discovery data of an extension from one version to another. */
  cloneExtensionDiscoveryData?: Maybe<CloneExtensionDiscoveryDataPayload>;
  /** cloneExtensionManifest creates a new version of an extension that is a clone of a previous version. */
  cloneExtensionManifest?: Maybe<CloneExtensionManifestPayload>;
  /** createBitsChallengeConditionForExtension creates a Bits condition on behalf of a user by an extension. */
  createBitsChallengeConditionForExtension?: Maybe<CreateBitsChallengeConditionForExtensionPayload>;
  /**
   * createBitsChallengeConditionParticipantForExtension creates a Bits condition
   * participant on behalf of a user by an extension.
   */
  createBitsChallengeConditionParticipantForExtension?: Maybe<CreateBitsChallengeConditionParticipantForExtensionPayload>;
  /** createBountyCampaign creates a campaign for Bounty Board. */
  createBountyCampaign?: Maybe<CreateBountyCampaignPayload>;
  /** createBountyCampaignUploadConfig creates a upload configuration for assets for bounty campaigns. */
  createBountyCampaignUploadConfig?: Maybe<CreateBountyCampaignUploadConfigPayload>;
  /** createCelebration creates a new celebration for a channel. */
  createCelebration?: Maybe<CreateCelebrationPayload>;
  /** createChanlet creates a new chanlet for a Channel. */
  createChanlet?: Maybe<CreateChanletPayload>;
  /** createClip creates a new clip with the authenticated user as the curator. */
  createClip?: Maybe<CreateClipPayload>;
  /** createCollection creates a collection with a provided collection name. */
  createCollection?: Maybe<CreateCollectionPayload>;
  /** Create a custom Community Points reward in a channel. */
  createCommunityPointsCustomReward?: Maybe<CreateCommunityPointsCustomRewardPayload>;
  /**
   * Generate image upload information (URL and upload ID) for uploading a Community Points image.
   * Can upoload a new Community Points icon, an automatic reward icon, or a custom reward icon.
   */
  createCommunityPointsImageUploadInfo?: Maybe<CreateCommunityPointsImageUploadInfoPayload>;
  /** Create a Competition. */
  createCompetition?: Maybe<CreateCompetitionPayload>;
  /** createContentTags creates the tags specified and associates it with the piece of content specified. */
  createContentTags?: Maybe<CreateContentTagsPayload>;
  /** createDropImageUploadURL creates and returns a url to use on the client side to upload drops images. */
  createDropImageUploadURL?: Maybe<CreateDropImageUploadUrlPayload>;
  /** createExtensionClient creates an extension with a provided name. */
  createExtensionClient?: Maybe<CreateExtensionClientPayload>;
  /**
   * createExtensionImageUploadInfo creates and returns a url and uploadId to use
   * on the client side to upload extension logo, taskbar, discovery and screenshot images.
   */
  createExtensionImageUploadInfo?: Maybe<CreateExtensionImageUploadInfoPayload>;
  /** createExtensionZipUploadInfo creates and returns a url and uploadId to use on the client side to upload zip files. */
  createExtensionZipUploadInfo?: Maybe<CreateExtensionZipUploadInfoPayload>;
  /** createFriendRequest creates a friend request relationship between the authenticated user and the target user. */
  createFriendRequest?: Maybe<CreateFriendRequestPayload>;
  /** createGameApplication creates an application request to add game to a certain organization. */
  createGameApplication?: Maybe<CreateGameApplicationPayload>;
  /** CreateLoyaltyBadge creates a new badge with these settings. */
  createLoyaltyBadge?: Maybe<CreateLoyaltyBadgePayload>;
  /** createLoyaltyBadgeUploadConfig creates a config with URL to upload the badge image to. */
  createLoyaltyBadgeUploadConfig?: Maybe<CreateLoyaltyBadgeUploadConfigPayload>;
  /**
   * createModeratorComment creates and returns a comment on the target user in the given channel.
   * Requester must be a moderator or higher in the channel.
   */
  createModeratorComment?: Maybe<CreateModeratorCommentPayload>;
  /** createMultiVideoHighlight creates a video of type Highlight with multi-segment support from an Archive type video. */
  createMultiVideoHighlight?: Maybe<CreateMultiVideoHighlightPayload>;
  /**
   * createMultiviewContentAttributeImageUploadConfig creates and returns a upload
   * configuration for uploading and retrieving content attribute images.
   */
  createMultiviewContentAttributeImageUploadConfig?: Maybe<CreateMultiviewContentAttributeImageUploadConfigPayload>;
  /** createMultiviewContentAttributes creates new content attributes with server assigned IDs. */
  createMultiviewContentAttributes?: Maybe<CreateMultiviewContentAttributesPayload>;
  /**
   * CreateOrganizationApplicaton creates a new Twitch Developer Organization
   * application with the authenticated user as the submitter.
   */
  createOrganizationApplication?: Maybe<CreateOrganizationApplicationPayload>;
  /** Creates JWT to be used in subsequent drops calls. */
  createOrganizationJWT?: Maybe<CreateOrganizationJwtPayload>;
  /** Adds a user to a developer organization. */
  createOrganizationMember?: Maybe<CreateOrganizationMemberPayload>;
  /** createPanel removes a panel. */
  createPanel?: Maybe<CreatePanelPayload>;
  /** createPartnershipApplication allows a user to create partnership application. */
  createPartnershipApplication?: Maybe<CreatePartnershipApplicationPayload>;
  /** createPoll creates a poll. */
  createPoll?: Maybe<CreatePollPayload>;
  /**
   * createPost creates a new post.
   * @deprecated Field no longer supported
   */
  createPost?: Maybe<CreatePostPayload>;
  /** Create a raid. */
  createRaid?: Maybe<CreateRaidPayload>;
  /** createRewardedVideoToken creates a token used to initialize the truex client application. */
  createRewardedVideoToken?: Maybe<CreateRewardedVideoTokenPayload>;
  /**
   * Creates a new chatroom.
   * @deprecated Field no longer supported
   */
  createRoom?: Maybe<CreateRoomPayload>;
  /** Create a new schedule. */
  createSchedule?: Maybe<CreateSchedulePayload>;
  /** Create a new schedule segment. */
  createScheduleSegment?: Maybe<CreateScheduleSegmentPayload>;
  /** createSocialMedia creates new social media items for a Channel. */
  createSocialMedia?: Maybe<CreateSocialMediaPayload>;
  /** Creates an invitation to a new or existing squad stream. */
  createSquadStreamInvitation?: Maybe<CreateSquadStreamInvitationPayload>;
  /** createStucco allows a user to create a stucco. */
  createStucco?: Maybe<CreateStuccoPayload>;
  /** createStuccoPack allows the creation a new stucco pack for the channel. */
  createStuccoPack?: Maybe<CreateStuccoPackPayload>;
  /** createVideoBookmark creates a video bookmark. */
  createVideoBookmark?: Maybe<CreateVideoBookmarkPayload>;
  /** createVideoComment creates a video comment. */
  createVideoComment?: Maybe<CreateVideoCommentPayload>;
  /** createVideoHighlight creates a video of type Highlight from an Archive type video. */
  createVideoHighlight?: Maybe<CreateVideoHighlightPayload>;
  /**
   * Deactivate an extension which has been installed on a channel.
   * @deprecated Should use applyExtensionActivations instead
   */
  deactivateExtension?: Maybe<DeactivateExtensionPayload>;
  /** Deletes a bits badge tier emoticon. */
  deleteBitsBadgeTierEmoticon?: Maybe<DeleteBitsBadgeTierEmoticonPayload>;
  /** Deletes a celebration from the channel. */
  deleteCelebration?: Maybe<DeleteCelebrationPayload>;
  /** Deletes a blocked term from a channel. */
  deleteChannelBlockedTerm?: Maybe<DeleteChannelBlockedTermPayload>;
  /** Deletes a permitted term from a channel. */
  deleteChannelPermittedTerm?: Maybe<DeleteChannelPermittedTermPayload>;
  /** deleteChatMessage deletes a single message from stream chat. */
  deleteChatMessage?: Maybe<DeleteChatMessagePayload>;
  /**
   * deleteClips allows a user to delete clips by slugs, video id, or broadcast id.
   * Only the slug and id can be accessed from the list of deleted clips.
   */
  deleteClips?: Maybe<DeleteClipsPayload>;
  /** deleteCollection performs a delete on the collection with the provided ID. */
  deleteCollection?: Maybe<DeleteCollectionPayload>;
  /** Deletes a custom Community Points reward from a channel. */
  deleteCommunityPointsCustomReward?: Maybe<DeleteCommunityPointsCustomRewardPayload>;
  /** Delete a Competition. */
  deleteCompetition?: Maybe<DeleteCompetitionPayload>;
  /** deleteContentTags removes the tags specified and associates it with the piece of content specified. */
  deleteContentTags?: Maybe<DeleteContentTagsPayload>;
  /**
   * Deletes the default payment method for a user.
   * Currently supports the Zuora (credit card) and Recurly (credit card, Pay-with-Amazon, PayPal) payment providers.
   */
  deleteDefaultPaymentMethod?: Maybe<DeleteDefaultPaymentMethodPayload>;
  /** deleteDeviceToken deletes a previously added device token by user and device token ID. */
  deleteDeviceToken?: Maybe<DeleteDeviceTokenPayload>;
  /** deleteExtension allows an extension owner to delete an extension. */
  deleteExtension?: Maybe<DeleteExtensionPayload>;
  /** deleteExtensionImage delete extension image assets of the given urls. */
  deleteExtensionImage?: Maybe<DeleteExtensionImagePayload>;
  /** Deletes a Loyalty Badge of a Channel. */
  deleteLoyaltyBadge?: Maybe<DeleteLoyaltyBadgePayload>;
  /**
   * deleteModeratorComment deletes a moderator comment with the given ID.
   * The comment must have been created on the requester's channel.
   */
  deleteModeratorComment?: Maybe<DeleteModeratorCommentPayload>;
  /** deleteMultiviewContentAttributes deletes content attributes with the provided IDs. */
  deleteMultiviewContentAttributes?: Maybe<DeleteMultiviewContentAttributesPayload>;
  /** deleteNotification deletes an onsite notification of the authenticated user. */
  deleteNotification?: Maybe<DeleteNotificationPayload>;
  /** deletePanel removes a panel. */
  deletePanel?: Maybe<DeletePanelPayload>;
  /**
   * deletePost deletes a old post.
   * @deprecated Field no longer supported
   */
  deletePost?: Maybe<DeletePostPayload>;
  /** deleteRecommendationFeedback deletes all the recommendation feedback that matches the given input. */
  deleteRecommendationFeedback?: Maybe<DeleteRecommendationFeedbackPayload>;
  /**
   * Deletes a chatroom.
   * @deprecated Field no longer supported
   */
  deleteRoom?: Maybe<DeleteRoomPayload>;
  /** Deletes an existing message in a chatroom. */
  deleteRoomMessage?: Maybe<DeleteRoomMessagePayload>;
  /** Delete the entire schedule of a user. */
  deleteSchedule?: Maybe<DeleteSchedulePayload>;
  /** Delete a segment of a schedule of a user. */
  deleteScheduleSegment?: Maybe<DeleteScheduleSegmentPayload>;
  /** deleteSocialMedia deletes a social media item for a Channel. */
  deleteSocialMedia?: Maybe<DeleteSocialMediaPayload>;
  /** deleteSquadStreamInvitation allows a squad stream member to delete a squad stream invitation. */
  deleteSquadStreamInvitation?: Maybe<DeleteSquadStreamInvitationPayload>;
  /** Deletes an authorized user who was allowed to stream on behalf of broadcaster. */
  deleteStreamAuthorizedUser?: Maybe<DeleteStreamAuthorizedUserPayload>;
  /** Deletes a user's creator colors. */
  deleteUserColors?: Maybe<DeleteUserColorsPayload>;
  /**
   * deleteVideoComment performs a delete on the video comment with the provided comment ID.
   * NOTE: this should use an input argument, not define the commentID right here.
   */
  deleteVideoComment?: Maybe<DeleteVideoCommentPayload>;
  /** Denies a message rejected on a channel chat. */
  denyRejectedChatMessage?: Maybe<DenyRejectedChatMessagePayload>;
  /** Denies a cheer rejected on a channel chat. */
  denyRejectedCheer?: Maybe<DenyRejectedCheerPayload>;
  /** Deselect channel badge (default to global badge). */
  deselectChannelBadge?: Maybe<DeselectChannelBadgePayload>;
  /** Deselect global badge (default to no badge). */
  deselectGlobalBadge?: Maybe<DeselectGlobalBadgePayload>;
  /** Allows the current user to disable or permanently delete their own account. */
  disableUserAccount?: Maybe<DisableUserAccountPayload>;
  /**
   * dismissFriendRecommendation removes a friend recommendation to the authenticated user without creating a friend
   * request.
   */
  dismissFriendRecommendation?: Maybe<DismissFriendRecommendationPayload>;
  /** Permanently dismiss a ritual token without redeeming it. */
  dismissRitualToken?: Maybe<DismissRitualTokenPayload>;
  /** dismissVideoSuggestedHighlight dismisses the automated highlight suggestion for a video. */
  dismissVideoSuggestedHighlight?: Maybe<DismissVideoSuggestedHighlightPayload>;
  /**
   * Edits an existing message in a chatroom.
   * @deprecated Field no longer supported
   */
  editRoomMessage?: Maybe<EditRoomMessagePayload>;
  /** emitCampaignDiscoveryEvent updates a user's progress towards a discovery objective in applicable campaigns. */
  emitCampaignDiscoveryEvent?: Maybe<EmitCampaignDiscoveryEventPayload>;
  /** finalizeCompetitionLobby update's a lobby's state to DONE and progresses the competition. */
  finalizeCompetitionLobby?: Maybe<FinalizeCompetitionLobbyPayload>;
  /** followGame allows a user to follow a game. */
  followGame?: Maybe<FollowGamePayload>;
  /**
   * followUser creates a follow relationship between the authenticated user and
   * the target user.
   */
  followUser?: Maybe<FollowUserPayload>;
  /**
   * generateExtensionRatingsCSVReport  asks the ExtensionRatings backend to generate a report and return a filename
   * for that report.  The filename can then be used in follow-up calls to getReportPresignedURL to poll for its
   * completion.  Authenticated on userID:extensionID via OWL in the ExtensionRatings backend.
   */
  generateExtensionRatingsCSVReport?: Maybe<GenerateExtensionRatingsCsvReportPayload>;
  /**
   * generateSubscribersCSV kicks off a background job that will generate a csv containing a list
   * of the channel's subscribers and then will alert the frontend that the csv is ready to
   * download using pubsub. Authenticated on the channelID.
   */
  generateSubscribersCSV?: Maybe<GenerateSubscribersCsvPayload>;
  /** Start a raid. */
  goRaid?: Maybe<GoRaidPayload>;
  /** Grant the VIP status to a user for a channel. */
  grantVIP?: Maybe<GrantVipPayload>;
  /** Host a target channel from a channel. */
  hostTargetChannel?: Maybe<HostTargetChannelPayload>;
  /** Install an extension onto a specific channel. */
  installExtension?: Maybe<InstallExtensionPayload>;
  /** Disable the schedule of a user. */
  interruptSchedule?: Maybe<InterruptSchedulePayload>;
  /** Invalidates authenticated sessions. */
  invalidateAuthenticatedSessions?: Maybe<InvalidateAuthenticatedSessionsPayload>;
  /** Invalidates an association to an email. */
  invalidateEmailAssociation?: Maybe<InvalidateEmailAssociationPayload>;
  /**
   * Joins the channel's chatrooms.
   * @deprecated Field no longer supported
   */
  joinChannelRooms?: Maybe<JoinChannelRoomsPayload>;
  /** Add a viewer to a source channel's raid. The viewer will be redirected to the target channel when the raid starts. */
  joinRaid?: Maybe<JoinRaidPayload>;
  /**
   * Leaves the channel's chatrooms.
   * @deprecated Field no longer supported
   */
  leaveChannelRooms?: Maybe<LeaveChannelRoomsPayload>;
  /** Leave a raid for a viewer. */
  leaveRaid?: Maybe<LeaveRaidPayload>;
  /**
   * leaveSquadStream allows a member of a squad stream to leave the squad.  Their stream will be
   * removed from the viewer experience, and they will be free to start/join another squad stream.
   */
  leaveSquadStream?: Maybe<LeaveSquadStreamPayload>;
  /** Link a single sign-on (SSO) app to a user's account. */
  linkSSO?: Maybe<LinkSsoPayload>;
  /** Makes a download URL for an authorized user to download a batch of keys. */
  makeKeyBatchDownloadURL?: Maybe<MakeKeyBatchDownloadUrlPayload>;
  /** Make a user a moderator for a channel. */
  modUser?: Maybe<ModUserPayload>;
  /**
   * orderPanels updates the sort order of the provided panels, the input must be a list of panel ids
   * all of which are owned by the acting user otherwise the request will fail and a generic GraphQL
   * error will be returned.
   */
  orderPanels?: Maybe<OrderPanelsPayload>;
  /** publishClip allows a user to permanently edit and update their default clip, viewable to the public. */
  publishClip?: Maybe<PublishClipPayload>;
  /** purchaseOffer completes the purchase of an offer. */
  purchaseOffer?: Maybe<PurchaseOfferPayload>;
  /** Submit a rating for a Twitch extension. */
  rateExtension?: Maybe<RateExtensionPayload>;
  /** readNotifications sets the read state to true for one or more onsite notifications of the authenticated user. */
  readNotifications?: Maybe<ReadNotificationsPayload>;
  /** Record an ad event. */
  recordAdEvent?: Maybe<RecordAdEventPayload>;
  /** Record a Mission Referral to a channel page. */
  recordMissionReferralExperiment?: Maybe<RecordMissionReferralExperimentPayload>;
  /** Redeem a claimable code, like a bits key code to add bits to your account, etc. */
  redeemClaimable?: Maybe<RedeemClaimablePayload>;
  /** Redeem a Community Points custom reward in a channel. */
  redeemCommunityPointsCustomReward?: Maybe<RedeemCommunityPointsCustomRewardPayload>;
  /**
   * Redeem an available ritual token. Currently, tokens are redeemed by sending
   * a special message to a channel's chat.
   */
  redeemRitualToken?: Maybe<RedeemRitualTokenPayload>;
  /** Submit a Subscription Redemption. */
  redeemSubscription?: Maybe<RedeemSubscriptionPayload>;
  /**
   * redeemTrueXAd processes the result of watching an ad to earn bits.
   * This action can only be taken if an OAuth token is supplied with the request.
   */
  redeemTrueXAd?: Maybe<RedeemTrueXAdPayload>;
  /** regenerateStreamKey generates a new stream key for the broadcaster and returns the newly generated stream key. */
  regenerateStreamKey?: Maybe<RegenerateStreamKeyPayload>;
  /** regenerateVerificationCode generates a new verification code and resends the verification message with the new code. */
  regenerateVerificationCode?: Maybe<RegenerateVerificationCodePayload>;
  /** Register payout information during payout onboarding. */
  registerPayoutInformation?: Maybe<RegisterPayoutInformationPayload>;
  /** rejectFriendRequest destroys a friend request relationship from the target user to the authenticated user. */
  rejectFriendRequest?: Maybe<RejectFriendRequestPayload>;
  /** rejectSquadStreamInvitation allows a user to decline an invitation to join a squad stream. */
  rejectSquadStreamInvitation?: Maybe<RejectSquadStreamInvitationPayload>;
  /** rejectSquadStreamOutOfNetworkInvitations allows a user to decline all out-of-network invitations to join a squad stream. */
  rejectSquadStreamOutOfNetworkInvitations?: Maybe<RejectSquadStreamOutOfNetworkInvitationsPayload>;
  /** Removes channels from a user's AutoHost list. */
  removeAutohostChannels?: Maybe<RemoveAutohostChannelsPayload>;
  /** removeCollectionItem removes an item from a collection. */
  removeCollectionItem?: Maybe<RemoveCollectionItemPayload>;
  /** Remove a phase from a Competition. */
  removeCompetitionPhase?: Maybe<RemoveCompetitionPhasePayload>;
  /** Remove CompetitionPlayer from a competition. */
  removeCompetitionPlayer?: Maybe<RemoveCompetitionPlayerPayload>;
  /** Remove a competition team from a Competition. */
  removeCompetitionTeam?: Maybe<RemoveCompetitionTeamPayload>;
  /** Revoke the editor status from a user for a given channel. */
  removeEditor?: Maybe<RemoveEditorPayload>;
  /** Removes a rbac user from a developer organization. */
  removeOrganizationMember?: Maybe<RemoveOrganizationMemberPayload>;
  /**
   * removeReaction removes a reaction created with addReaction.
   * @deprecated Field no longer supported
   */
  removeReaction?: Maybe<RemoveReactionPayload>;
  /** removeSquadStreamMember allows the owner of a squad stream to remove a member from the squad stream. */
  removeSquadStreamMember?: Maybe<RemoveSquadStreamMemberPayload>;
  /** removeStucco allows the owner of a stucco to remove an inactive stucco from their library. */
  removeStucco?: Maybe<RemoveStuccoPayload>;
  /** reorderCollectionItem reorders an item's position in a collection. */
  reorderCollectionItem?: Maybe<ReorderCollectionItemPayload>;
  /** reportContent allows a user to report content on the site as infringing of our terms of service. */
  reportContent?: Maybe<ReportContentPayload>;
  /** Reports a whisper thread as spam. */
  reportWhisperThread?: Maybe<ReportWhisperThreadPayload>;
  /** Request a ritual token to be issued to the user. */
  requestRitualToken?: Maybe<RequestRitualTokenPayload>;
  /** resendVerificationEmail resends a verification email to the current user. */
  resendVerificationEmail?: Maybe<ResendVerificationEmailPayload>;
  /** Enable the schedule of a user. */
  resumeSchedule?: Maybe<ResumeSchedulePayload>;
  /** Revoke the VIP status of a user from a channel. */
  revokeVIP?: Maybe<RevokeVipPayload>;
  /** Runs multiplayer ads on a channel. */
  runMultiplayerAds?: Maybe<RunMultiplayerAdsPayload>;
  /** saveExtensionManifest allows a user to update the manifest for an extension in development. */
  saveExtensionManifest?: Maybe<SaveExtensionManifestPayload>;
  /** Give a competition participant a seed value. */
  seedCompetitionParticipant?: Maybe<SeedCompetitionParticipantPayload>;
  /** Select a user's channel badge for a channel. */
  selectChannelBadge?: Maybe<SelectChannelBadgePayload>;
  /** Select a user's global badge. */
  selectGlobalBadge?: Maybe<SelectGlobalBadgePayload>;
  /** Send a chat message through subscribers-only mode with Channel Points. */
  sendChatMessageThroughSubscriberMode?: Maybe<SendChatMessageThroughSubscriberModePayload>;
  /**
   * sendCheer sends a chat message that contains cheermotes. The message will
   * be processed, bits deducted from the authenticated user's balance, and then the
   * message will be passed on to the chat service (client shouldn't send the message itself).
   * This action can only be taken if an OAuth token is supplied with the request.
   */
  sendCheer?: Maybe<SendCheerPayload>;
  /** Send a highlighted chat message with Channel Points. */
  sendHighlightedChatMessage?: Maybe<SendHighlightedChatMessagePayload>;
  /**
   * Sends a message to a chatroom.
   * @deprecated Field no longer supported
   */
  sendRoomMessage?: Maybe<SendRoomMessagePayload>;
  /** Sends a whisper message to the target user. */
  sendWhisper?: Maybe<SendWhisperPayload>;
  /** Sets the user's auto refill settings. */
  setAutoRefillSettings?: Maybe<SetAutoRefillSettingsPayload>;
  /** Sets the user's list of channelIDs to autohost. */
  setAutohostChannels?: Maybe<SetAutohostChannelsPayload>;
  /** setBitsUserSettings sets a Bits users settings such as skipping the tutorial. */
  setBitsUserSettings?: Maybe<SetBitsUserSettingsPayload>;
  /**
   * Set value for channel_feed_enabled.
   * @deprecated Field no longer supported
   */
  setChannelFeedEnabled?: Maybe<SetChannelFeedEnabledPayload>;
  /** setChannelNotificationSetting allows a user to set a notification setting. */
  setChannelNotificationSetting?: Maybe<SetChannelNotificationSettingPayload>;
  /**
   * Set a channel's trailer.
   * A channel trailer can only be modified by its corresponding user, a channel editor, or a Twitch admin.
   */
  setChannelTrailer?: Maybe<SetChannelTrailerPayload>;
  /** Set a user's Chat Pause setting. */
  setChatPauseSetting?: Maybe<SetChatPauseSettingPayload>;
  /** setContentTags updates the tags specified and associates it with the piece of content specified. */
  setContentTags?: Maybe<SetContentTagsPayload>;
  /** setDashboardAlertQueueActivityStatus updates the specified activity's status for the dashboard alert queue. */
  setDashboardAlertQueueActivityStatus?: Maybe<SetDashboardAlertQueueActivityStatusPayload>;
  /** setDashboardAlertQueuePreference updates the preference specified for the dashboard alert queue. */
  setDashboardAlertQueuePreference?: Maybe<SetDashboardAlertQueuePreferencePayload>;
  /**
   * Sets the default payment method for a user.
   * Currently supports the Zuora (credit card) and Recurly (credit card, Pay-with-Amazon, PayPal) payment providers
   * This is the final step of the payment method management flow.
   * (User.paymentMethods -> User.paymentMethodConfigs -> this mutation).
   */
  setDefaultPaymentMethod?: Maybe<SetDefaultPaymentMethodPayload>;
  /** Set a user's Deleted Message Display Chat UI setting. */
  setDeletedMessageDisplaySetting?: Maybe<SetDeletedMessageDisplaySettingPayload>;
  /** Sets the emote modifier groups for a user. */
  setEmoteModifierGroups?: Maybe<SetEmoteModifierGroupsPayload>;
  /** Sets the feature flag options on a specified extension installation. */
  setExtensionFeatureFlags?: Maybe<SetExtensionFeatureFlagsPayload>;
  /** Set the OAuth token for an installation which is retrieved and used for Helix requests from extensions. */
  setExtensionInstallationOAuth?: Maybe<SetExtensionInstallationOAuthPayload>;
  /** Set access permission to the channel's moderator logs for a given role. */
  setModLogsAccess?: Maybe<SetModLogsAccessPayload>;
  /** Set a user's mod view page tutorial seen state & time. */
  setModViewSettings?: Maybe<SetModViewSettingsPayload>;
  /** setNotificationSetting allows a user to set a notification setting. */
  setNotificationSetting?: Maybe<SetNotificationSettingPayload>;
  /** setOverwatchLeagueTeamPreference allows a user to set their preferred Overwatch team. */
  setOverwatchLeagueTeamPreference?: Maybe<SetOverwatchLeagueTeamPreferencePayload>;
  /** Set a user's preferred language tag. */
  setPreferredLanguageTag?: Maybe<SetPreferredLanguageTagPayload>;
  /** Set a user's quick action layout. */
  setQuickActionLayout?: Maybe<SetQuickActionLayoutPayload>;
  /** Set a user's readable chat colors UI setting. */
  setReadableChatColorsEnabled?: Maybe<SetReadableChatColorsEnabledPayload>;
  /** setResourceRestriction can create or update a restriction on a resource. */
  setResourceRestriction?: Maybe<SetResourceRestrictionPayload>;
  /**
   * setSessionStatus sets the user's status for this session, which influences how they appear ("online", "idle",
   * "watching SnarfyBobo") to friends and related users. To maintain a session status, setSessionStatus needs to be sent
   * periodically. The amount of time your application should wait between these status heartbeats is included in the
   * response payload.
   */
  setSessionStatus?: Maybe<SetSessionStatusPayload>;
  /** Set whether to show social media panel. */
  setSocialMediaPanelEnabled?: Maybe<SetSocialMediaPanelEnabledPayload>;
  /** Set the ID of the primary player in a squad stream that the user currently has in the primary position. */
  setSquadStreamPrimaryPlayer?: Maybe<SetSquadStreamPrimaryPlayerPayload>;
  /** Set user's country of residence. */
  setUserResidence?: Maybe<SetUserResidencePayload>;
  /** Spend Twitch Prime monthly subscription credit. */
  spendSubscriptionCredit?: Maybe<SpendSubscriptionCreditPayload>;
  /** Start a new ad break. */
  startAd?: Maybe<StartAdPayload>;
  /**
   * startBounty allows a user to start a bounty for tracking (e.g. track the
   * viewers CCU for meeting the bounty's requirements).
   * If the user has not provided a title or met the other requirements to start the bounty, it will return an error.
   */
  startBounty?: Maybe<StartBountyPayload>;
  /** Start a new payout onboarding workflow. */
  startPayoutOnboardingWorkflow?: Maybe<StartPayoutOnboardingWorkflowPayload>;
  /** Start a Prime Video Watch Party. */
  startWatchParty?: Maybe<StartWatchPartyPayload>;
  /** stopBounty allows a user to stop tracking progress for a bounty. */
  stopBounty?: Maybe<StopBountyPayload>;
  /** Stop a Prime Video Watch Party. */
  stopWatchParty?: Maybe<StopWatchPartyPayload>;
  /**
   * Submit a new emote prefix for a given channel. Each channel has a single prefix.
   * Submitting more than once overrides the previously set prefix.
   */
  submitEmotePrefix?: Maybe<SubmitEmotePrefixPayload>;
  /**
   * Submit a new emoticon prefix for a given channel. Each channel has a single prefix. Submitting
   * more than once simply overrides the previously set prefix and putting it in a pending state.
   * @deprecated Use 'submitEmotePrefix' instead
   */
  submitEmoticonPrefix?: Maybe<SubmitEmoticonPrefixPayload>;
  /** Submit feedback for a Twitch extension. */
  submitExtensionFeedback?: Maybe<SubmitExtensionFeedbackPayload>;
  /** Swap competition lobby participants within a competition phase. */
  swapCompetitionLobbyParticipants?: Maybe<SwapCompetitionLobbyParticipantsPayload>;
  /** Terminates the poll with the given poll id. */
  terminatePoll?: Maybe<TerminatePollPayload>;
  /** Terminates the current poll in a channel. */
  terminatePollInChannel?: Maybe<TerminatePollInChannelPayload>;
  /** toggleRitualsEnabled allows a user to toggle the rituals feature for their channel. */
  toggleRitualsEnabled?: Maybe<ToggleRitualsEnabledPayload>;
  /**
   * Transitions the state for an existing extension.
   * Only allowed for the owner of the extension.
   */
  transitionExtensionState?: Maybe<TransitionExtensionStatePayload>;
  /** Removes a ban imposed on a user for a specified chat room. */
  unbanUserFromChatRoom?: Maybe<UnbanUserFromChatRoomPayload>;
  /** Removes block from target user. */
  unblockUser?: Maybe<UnblockUserPayload>;
  /** undoRecommendationFeedback allows a user to removes a single piece of feedback. */
  undoRecommendationFeedback?: Maybe<UndoRecommendationFeedbackPayload>;
  /** unfollowGame allows a user to unfollow a game. */
  unfollowGame?: Maybe<UnfollowGamePayload>;
  /**
   * unfollowUser destroys the follow relationship between the authenticated user and
   * the target user.
   */
  unfollowUser?: Maybe<UnfollowUserPayload>;
  /** unfriendUser destroys a friend relationship from the target user to the authenticated user. */
  unfriendUser?: Maybe<UnfriendUserPayload>;
  /** Unhost from a channel. */
  unhost?: Maybe<UnhostPayload>;
  /** Uninstall an extension from a specific channel. */
  uninstallExtension?: Maybe<UninstallExtensionPayload>;
  /** Unlink an authenticated user's amazon connection. */
  unlinkAmazonConnection?: Maybe<UnlinkAmazonConnectionPayload>;
  /** Unlink a user's account connection to Riot. */
  unlinkRiotConnection?: Maybe<UnlinkRiotConnectionPayload>;
  /** Unlink an SSO app from a user's account. */
  unlinkSSO?: Maybe<UnlinkSsoPayload>;
  /** Unlock a chosen modified subscriber emote using Community Points. */
  unlockChosenModifiedSubscriberEmote?: Maybe<UnlockChosenModifiedSubscriberEmotePayload>;
  /** Unlock a chosen subscriber emote using Community Points. */
  unlockChosenSubscriberEmote?: Maybe<UnlockChosenSubscriberEmotePayload>;
  /** Unlock a random subscriber emote using Community Points. */
  unlockRandomSubscriberEmote?: Maybe<UnlockRandomSubscriberEmotePayload>;
  /** Remove moderator status from a user in a channel. */
  unmodUser?: Maybe<UnmodUserPayload>;
  /** unsetHypeTrainConfig allows a user to unset the channel's custom hype train configurations. */
  unsetHypeTrainConfig?: Maybe<UnsetHypeTrainConfigPayload>;
  /** unsubscribeEmail unsubscribes a given user from a given email campaign. */
  unsubscribeEmail?: Maybe<UnsubscribeEmailPayload>;
  /** Updates a user's ad settings for their channel. */
  updateAdProperties?: Maybe<UpdateAdPropertiesPayload>;
  /** Updates all of a user's whisper threads. */
  updateAllWhisperThreads?: Maybe<UpdateAllWhisperThreadsPayload>;
  /** Set individual automod categories (i.e. set identity to level 3 but profanity to 0). */
  updateAutoModProperties?: Maybe<UpdateAutoModPropertiesPayload>;
  /** Update a user's autohost settings. */
  updateAutohostSettings?: Maybe<UpdateAutohostSettingsPayload>;
  /** Updates bits badge tier notification. */
  updateBitsBadgeTierNotification?: Maybe<UpdateBitsBadgeTierNotificationPayload>;
  /** Updates bits badge tiers. */
  updateBitsBadgeTiers?: Maybe<UpdateBitsBadgeTiersPayload>;
  /** updateBroadcastSettings allows the user to update their broadcast setting. */
  updateBroadcastSettings?: Maybe<UpdateBroadcastSettingsPayload>;
  /** Update a channels celebration. */
  updateCelebration?: Maybe<UpdateCelebrationPayload>;
  /** Update a channels celebration config. */
  updateCelebrationConfig?: Maybe<UpdateCelebrationConfigPayload>;
  /** updateChangelogReadTime marks the changelog as read for a user. */
  updateChangelogReadTime?: Maybe<UpdateChangelogReadTimePayload>;
  /** updateChanletContentAttributes allows users to make changes to the multi-view content attributes on a chanlet. */
  updateChanletContentAttributes?: Maybe<UpdateChanletContentAttributesPayload>;
  /** updateChannelHomePreferences updates a streamer's channel home preferences. */
  updateChannelHomePreferences?: Maybe<UpdateChannelHomePreferencesPayload>;
  /** Updates a user's chat color. */
  updateChatColor?: Maybe<UpdateChatColorPayload>;
  /** Set different chat settings (i.e. disable globalBannedWordsOptOut). */
  updateChatSettings?: Maybe<UpdateChatSettingsPayload>;
  /** Update the user's partner settings regarding bits. */
  updateCheerPartnerSettings?: Maybe<UpdateCheerPartnerSettingsPayload>;
  /** updateClip allows a user to update the metadata of a clip. */
  updateClip?: Maybe<UpdateClipPayload>;
  /**
   * updateClipViewCount allows a user to increment the viewcount of a clip.
   * @deprecated Will eventually be replaced by different viewcounting method
   */
  updateClipViewCount?: Maybe<UpdateClipViewCountPayload>;
  /** updateCollection performs an update on the collection with the provided ID and updated attributes. */
  updateCollection?: Maybe<UpdateCollectionPayload>;
  /** Update an automatic Community Points reward in a channel. */
  updateCommunityPointsAutomaticReward?: Maybe<UpdateCommunityPointsAutomaticRewardPayload>;
  /** Update a channel's Community Points channel settings. */
  updateCommunityPointsChannelSettings?: Maybe<UpdateCommunityPointsChannelSettingsPayload>;
  /** Update a custom Community Points reward in a channel. */
  updateCommunityPointsCustomReward?: Maybe<UpdateCommunityPointsCustomRewardPayload>;
  /** Update the status of a Community Points redemption (for example, from unfulfilled to fulfilled). */
  updateCommunityPointsCustomRewardRedemptionStatus?: Maybe<UpdateCommunityPointsCustomRewardRedemptionStatusPayload>;
  /** Update the status of all Community Points redemptions for a channel. */
  updateCommunityPointsCustomRewardRedemptionStatusesByChannel?: Maybe<UpdateCommunityPointsCustomRewardRedemptionStatusesByChannelPayload>;
  /** Update the status of the Community Points redemptions from the provided list. */
  updateCommunityPointsCustomRewardRedemptionStatusesByRedemptions?: Maybe<UpdateCommunityPointsCustomRewardRedemptionStatusesByRedemptionsPayload>;
  /** Update the status of all Community Points redemptions for a reward. */
  updateCommunityPointsCustomRewardRedemptionStatusesByReward?: Maybe<UpdateCommunityPointsCustomRewardRedemptionStatusesByRewardPayload>;
  /**
   * Allows users to sign up for or remove themselves from the Community Points early access program.
   * @deprecated Early access period is over.
   */
  updateCommunityPointsEarlyAccessSettings?: Maybe<UpdateCommunityPointsEarlyAccessSettingsPayload>;
  /** Update an automatic Community Points reward cost acknowledgements. */
  updateCommunityPointsSmartCostsAcknowledgements?: Maybe<UpdateCommunityPointsSmartCostsAcknowledgementsPayload>;
  /** Update Competition. */
  updateCompetition?: Maybe<UpdateCompetitionPayload>;
  /** Update CompetitionPlayer in a competition. */
  updateCompetitionPlayer?: Maybe<UpdateCompetitionPlayerPayload>;
  /** Update  a Team in a Competition. */
  updateCompetitionTeam?: Maybe<UpdateCompetitionTeamPayload>;
  /** Update a consent status or create a new consent status. */
  updateConsent?: Maybe<UpdateConsentPayload>;
  /**
   * updateContentTags updates the tags specified and associates it with the piece of content specified.
   * @deprecated Use setContentTags instead
   */
  updateContentTags?: Maybe<UpdateContentTagsPayload>;
  /** updateDropsOptOutStatus allows the user to update their drops opt-out status. */
  updateDropsOptOutStatus?: Maybe<UpdateDropsOptOutStatusPayload>;
  /** updateExtensionDiscoveryData allows a user to update the discovery data for an extension. */
  updateExtensionDiscoveryData?: Maybe<UpdateExtensionDiscoveryDataPayload>;
  /**
   * updateExtensionManifest allows a user to update the manifest for an extension in development.
   * @deprecated Switching to saveExtensionManifest
   */
  updateExtensionManifest?: Maybe<UpdateExtensionManifestPayload>;
  /** updateHypeTrainConfig allows a user to update the channel's hype train configurations. */
  updateHypeTrainConfig?: Maybe<UpdateHypeTrainConfigPayload>;
  /** Changes the user's activity sharing setting. A user's activity is one part of their status. */
  updateIsSharingActivity?: Maybe<UpdateIsSharingActivityPayload>;
  /** Exchanges an LWA token for an Amazon OAuth token. */
  updateLWAToken?: Maybe<UpdateLwaTokenPayload>;
  /** Update the user's partner settings regarding leaderboards. */
  updateLeaderboardSettings?: Maybe<UpdateLeaderboardSettingsPayload>;
  /** Changes the user's activity sharing setting. A user's activity is one part of their status. */
  updateLiveUpNotification?: Maybe<UpdateLiveUpNotificationPayload>;
  /** Updates a lobby participant who is a competition player's or competition team's score. */
  updateLobbyParticipantScore?: Maybe<UpdateLobbyParticipantScorePayload>;
  /** Modifies multi-view content attributes. */
  updateMultiviewContentAttributes?: Maybe<UpdateMultiviewContentAttributesPayload>;
  /**
   * updateOnboardingSkippedChannels updates skipped channel IDs during onboarding for a given user.
   * @deprecated This feature is retired
   */
  updateOnboardingSkippedChannels?: Maybe<UpdateOnboardingSkippedChannelsPayload>;
  /** updateOrganizationMemberRole updates the role of an organization member (Twitch Developers). */
  updateOrganizationMemberRole?: Maybe<UpdateOrganizationMemberRolePayload>;
  /** updateOwnerChanletAttributes updates/creates a new set of owner chanlet attributes for a Channel. */
  updateOwnerChanletAttributes?: Maybe<UpdateOwnerChanletAttributesPayload>;
  /** updatePanel updates the data for a given panel. */
  updatePanel?: Maybe<UpdatePanelPayload>;
  /** updatePrimeOfferStatus allows a user to update their status in respect to an offer. (e.g. UNSEEN, SEEN, CLAIMED). */
  updatePrimeOfferStatus?: Maybe<UpdatePrimeOfferStatusPayload>;
  /**
   * updatePrimeSettings allows the user to enable or disable chat notifications when spending a Prime Credit,
   * and allows the user to set the type of Smilies (Turbos, Robots, or Monkeys) they want for Prime/Turbo Emoticons.
   */
  updatePrimeSettings?: Maybe<UpdatePrimeSettingsPayload>;
  /** Update a user's raid settings. */
  updateRaidSettings?: Maybe<UpdateRaidSettingsPayload>;
  /**
   * Updates an existing chatroom.
   * @deprecated Field no longer supported
   */
  updateRoom?: Maybe<UpdateRoomPayload>;
  /** Updates the room modes (slow mode, emotes only mode, etc.) for the room. */
  updateRoomModes?: Maybe<UpdateRoomModesPayload>;
  /**
   * Update's a user's room view for a chatroom.
   * @deprecated Field no longer supported
   */
  updateRoomView?: Maybe<UpdateRoomViewPayload>;
  /** Update a schedule segment. */
  updateScheduleSegment?: Maybe<UpdateScheduleSegmentPayload>;
  /** UpdateSeenCreatorOnboardingContent updates the list of streamer onboarding content that a user has seen. */
  updateSeenCreatorOnboardingContent?: Maybe<UpdateSeenCreatorOnboardingContentPayload>;
  /** updateSocialMedia updates an existing social media item for a Channel. */
  updateSocialMedia?: Maybe<UpdateSocialMediaPayload>;
  /** updateSquadInvitePolicy allows a broadcaster to update their squad stream invite policy. */
  updateSquadInvitePolicy?: Maybe<UpdateSquadInvitePolicyPayload>;
  /** updateSquadStream allows an owner of a squad stream to update the squad stream. */
  updateSquadStream?: Maybe<UpdateSquadStreamPayload>;
  /** updateStucco allows a user to update a stucco (that is currently not active). */
  updateStucco?: Maybe<UpdateStuccoPayload>;
  /** updateStuccoPack allows the updating of a channel's stucco pack. (activating stuccos). */
  updateStuccoPack?: Maybe<UpdateStuccoPackPayload>;
  /** updateSubscriptionProduct allows a user to update their subscription product settings. */
  updateSubscriptionProduct?: Maybe<UpdateSubscriptionProductPayload>;
  /** Updates a user's creator colors. */
  updateUserColors?: Maybe<UpdateUserColorsPayload>;
  /** Set a user's privacy preference for registration date. */
  updateUserCreateDateHidden?: Maybe<UpdateUserCreateDateHiddenPayload>;
  /** Set a user's directory hidden field. */
  updateUserDirectoryHidden?: Maybe<UpdateUserDirectoryHiddenPayload>;
  /** Set a user's email reuse field. */
  updateUserEmailReusable?: Maybe<UpdateUserEmailReusablePayload>;
  /** updateUserIsEmailRevertSuccess sets/resets a user's Email revert success flag. */
  updateUserIsEmailRevertSuccess?: Maybe<UpdateUserIsEmailRevertSuccessPayload>;
  /** updateUserSubscriptionSettings updates the subscription preferences for the authenticated user. */
  updateUserSubscriptionSettings?: Maybe<UpdateUserSubscriptionSettingsPayload>;
  /** updateUserVideoShelves adds/removes/reorders for a user's video shelves. */
  updateUserVideoShelves?: Maybe<UpdateUserVideoShelvesPayload>;
  /** updateUserViewedVideo updates a resume watching entry for a specified user and video. */
  updateUserViewedVideo?: Maybe<UpdateUserViewedVideoPayload>;
  /** updateVideo updates a video identified by provided video ID. */
  updateVideo?: Maybe<UpdateVideoPayload>;
  /** updateVideoComment updates a video comment identified by provided comment ID. */
  updateVideoComment?: Maybe<UpdateVideoCommentPayload>;
  /** updateVideoStreamSettings updates the broadcaster's video stream settings such as latency mode. */
  updateVideoStreamSettings?: Maybe<UpdateVideoStreamSettingsPayload>;
  /**
   * Changes the user's visibility setting. This is an account-level setting that will cause the user's availability to
   * appear differently to other users, despite what sessions are reporting. See the VisibilityInput enum for details on
   * the effects of each value.
   * 
   * Because this is an account-level setting, it should only be used in response to the user expressing clear intention
   * to change their visibility. Setting a status for an individual session should be done using setSessionStatus.
   */
  updateVisibility?: Maybe<UpdateVisibilityPayload>;
  /** Updates Whisper settings for the authenticated user. */
  updateWhisperSettings?: Maybe<UpdateWhisperSettingsPayload>;
  /** Updates a whisper thread. */
  updateWhisperThread?: Maybe<UpdateWhisperThreadPayload>;
  /** Uses a chat notification token. */
  useChatNotificationToken?: Maybe<UseChatNotificationTokenPayload>;
  /** validateVerificationCode validates a given code and sets the address to verified if it matches. */
  validateVerificationCode?: Maybe<ValidateVerificationCodePayload>;
  /** verifyContactMethod verifies a user contact method from an opaque ID. */
  verifyContactMethod?: Maybe<VerifyContactMethodPayload>;
  /** verifyRewardedVideoEligibilityCaptcha verifies a users captcha with the rewarded video system. */
  verifyRewardedVideoEligibilityCaptcha?: Maybe<VerifyRewardedVideoEligibilityCaptchaPayload>;
  /** viewedNotifications updates when the authenticated user last saw onsite notifications. */
  viewedNotifications?: Maybe<ViewedNotificationsPayload>;
  /** Casts a vote for a specific choice in a poll. */
  voteInPoll?: Maybe<VoteInPollPayload>;
  /** Casts a vote for a specific choice in a poll, by index and channelID. */
  voteInPollByChoiceIndex?: Maybe<VoteInPollByChoiceIndexPayload>;
};


/** Operations to update data in the Twitch API. */
export type MutationAcceptFriendRequestArgs = {
  input: AcceptFriendRequestInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAcceptProgramAgreementArgs = {
  input: AcceptProgramAgreementInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAcceptSquadStreamInvitationArgs = {
  input: AcceptSquadStreamInvitationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAcknowledgeSubscriptionStateArgs = {
  input: AcknowledgeSubscriptionStateInput;
};


/** Operations to update data in the Twitch API. */
export type MutationActivateExtensionArgs = {
  input: ActivateExtensionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddAutohostChannelsArgs = {
  input: AddAutohostChannelsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddBrowserPushSubscriptionArgs = {
  input: AddBrowserPushSubscriptionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddChannelBlockedTermArgs = {
  input: AddChannelBlockedTermInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddChannelPermittedTermArgs = {
  input: AddChannelPermittedTermInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddCollectionItemArgs = {
  input: AddCollectionItemInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddCompetitionPhaseArgs = {
  input: AddCompetitionPhaseInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddCompetitionPlayerArgs = {
  input: AddCompetitionPlayerInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddCompetitionTeamArgs = {
  input: AddCompetitionTeamInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddDeviceTokenArgs = {
  input: AddDeviceTokenInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddEditorArgs = {
  input: AddEditorInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddReactionArgs = {
  input: AddReactionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddRecommendationFeedbackArgs = {
  input: AddRecommendationFeedbackInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAddStreamAuthorizedUserArgs = {
  input: AddStreamAuthorizedUserInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAllocateKeysForBountyArgs = {
  input: AllocateKeysForBountyInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAllowRejectedChatMessageArgs = {
  input: AllowRejectedChatMessageInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAllowRejectedCheerArgs = {
  input: AllowRejectedCheerInput;
};


/** Operations to update data in the Twitch API. */
export type MutationApplyExtensionActivationsArgs = {
  input: ApplyExtensionActivationsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationArchiveChanletArgs = {
  input: ArchiveChanletInput;
};


/** Operations to update data in the Twitch API. */
export type MutationArchivePollArgs = {
  input: ArchivePollInput;
};


/** Operations to update data in the Twitch API. */
export type MutationArchivePollInChannelArgs = {
  input: ArchivePollInChannelInput;
};


/** Operations to update data in the Twitch API. */
export type MutationAssignExtensionBillingManagerArgs = {
  input: AssignExtensionBillingManagerInput;
};


/** Operations to update data in the Twitch API. */
export type MutationBanUserFromChatRoomArgs = {
  input: BanUserFromChatRoomInput;
};


/** Operations to update data in the Twitch API. */
export type MutationBanVideoCommenterArgs = {
  input: BanVideoCommenterInput;
};


/** Operations to update data in the Twitch API. */
export type MutationBlockUserArgs = {
  input: BlockUserInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCancelBountyArgs = {
  input: CancelBountyInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCancelFriendRequestArgs = {
  input: CancelFriendRequestInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCancelPayoutOnboardingWorkflowArgs = {
  input: CancelPayoutOnboardingWorkflowInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCancelRaidArgs = {
  input: CancelRaidInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCancelSubscriptionGiftArgs = {
  input: CancelSubscriptionGiftInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCheckGemNotificationArgs = {
  input: CheckGemNotificationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationClaimBountyArgs = {
  input: ClaimBountyInput;
};


/** Operations to update data in the Twitch API. */
export type MutationClaimCommunityPointsArgs = {
  input: ClaimCommunityPointsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationClaimDropRewardsArgs = {
  input: ClaimDropRewardsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationClaimPrimeOfferArgs = {
  input: ClaimPrimeOfferInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCloneExtensionDiscoveryDataArgs = {
  input: CloneExtensionDiscoveryDataInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCloneExtensionManifestArgs = {
  input: CloneExtensionManifestInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateBitsChallengeConditionForExtensionArgs = {
  input: CreateBitsChallengeConditionForExtensionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateBitsChallengeConditionParticipantForExtensionArgs = {
  input: CreateBitsChallengeConditionParticipantForExtensionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateBountyCampaignArgs = {
  input: CreateBountyCampaignInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateBountyCampaignUploadConfigArgs = {
  input: CreateBountyCampaignUploadConfigInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateCelebrationArgs = {
  input: CreateCelebrationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateChanletArgs = {
  input: CreateChanletInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateClipArgs = {
  input: CreateClipInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateCollectionArgs = {
  input: CreateCollectionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateCommunityPointsCustomRewardArgs = {
  input: CreateCommunityPointsCustomRewardInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateCommunityPointsImageUploadInfoArgs = {
  input: CreateCommunityPointsImageUploadInfoInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateCompetitionArgs = {
  input: CreateCompetitionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateContentTagsArgs = {
  input: CreateContentTagsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateDropImageUploadUrlArgs = {
  input: CreateDropImageUploadUrlInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateExtensionClientArgs = {
  input: CreateExtensionClientInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateExtensionImageUploadInfoArgs = {
  input: CreateExtensionImageUploadInfoInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateExtensionZipUploadInfoArgs = {
  input: CreateExtensionZipUploadInfoInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateFriendRequestArgs = {
  input: CreateFriendRequestInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateGameApplicationArgs = {
  input: CreateGameApplicationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateLoyaltyBadgeArgs = {
  input: CreateLoyaltyBadgeInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateLoyaltyBadgeUploadConfigArgs = {
  input: CreateLoyaltyBadgeUploadConfigInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateModeratorCommentArgs = {
  input: CreateModeratorCommentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateMultiVideoHighlightArgs = {
  input: CreateMultiVideoHighlightInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateMultiviewContentAttributeImageUploadConfigArgs = {
  input: CreateMultiviewContentAttributeImageUploadConfigInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateMultiviewContentAttributesArgs = {
  input: CreateMultiviewContentAttributesInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateOrganizationApplicationArgs = {
  input: CreateOrganizationApplicationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateOrganizationJwtArgs = {
  input: CreateOrganizationJwtInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateOrganizationMemberArgs = {
  input: CreateOrganizationMemberInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreatePanelArgs = {
  input: CreatePanelInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreatePartnershipApplicationArgs = {
  input: CreatePartnershipApplicationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreatePollArgs = {
  input: CreatePollInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreatePostArgs = {
  input: CreatePostInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateRaidArgs = {
  input: CreateRaidInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateRewardedVideoTokenArgs = {
  input: CreateRewardedVideoTokenInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateRoomArgs = {
  input: CreateRoomInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateScheduleArgs = {
  input: CreateScheduleInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateScheduleSegmentArgs = {
  input: CreateScheduleSegmentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateSocialMediaArgs = {
  input: CreateSocialMediaInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateSquadStreamInvitationArgs = {
  input: CreateSquadStreamInvitationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateStuccoArgs = {
  input: CreateStuccoInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateStuccoPackArgs = {
  input: CreateStuccoPackInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateVideoBookmarkArgs = {
  input: CreateVideoBookmarkInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateVideoCommentArgs = {
  input: CreateVideoCommentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationCreateVideoHighlightArgs = {
  input: CreateVideoHighlightInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeactivateExtensionArgs = {
  input: DeactivateExtensionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteBitsBadgeTierEmoticonArgs = {
  input: DeleteBitsBadgeTierEmoticonInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteCelebrationArgs = {
  input: DeleteCelebrationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteChannelBlockedTermArgs = {
  input: DeleteChannelBlockedTermInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteChannelPermittedTermArgs = {
  input: DeleteChannelPermittedTermInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteChatMessageArgs = {
  input: DeleteChatMessageInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteClipsArgs = {
  input: DeleteClipsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteCollectionArgs = {
  input: DeleteCollectionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteCommunityPointsCustomRewardArgs = {
  input?: Maybe<DeleteCommunityPointsCustomRewardInput>;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteCompetitionArgs = {
  input: DeleteCompetitionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteContentTagsArgs = {
  input: DeleteContentTagsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteDefaultPaymentMethodArgs = {
  input: DeleteDefaultPaymentMethodInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteDeviceTokenArgs = {
  input: DeleteDeviceTokenInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteExtensionArgs = {
  input: DeleteExtensionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteExtensionImageArgs = {
  input: DeleteExtensionImageInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteLoyaltyBadgeArgs = {
  input: DeleteLoyaltyBadgeInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteModeratorCommentArgs = {
  input: DeleteModeratorCommentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteMultiviewContentAttributesArgs = {
  input: DeleteMultiviewContentAttributesInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteNotificationArgs = {
  input: DeleteNotificationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeletePanelArgs = {
  input: DeletePanelInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeletePostArgs = {
  input: DeletePostInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteRecommendationFeedbackArgs = {
  input: DeleteRecommendationFeedbackInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteRoomArgs = {
  input: DeleteRoomInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteRoomMessageArgs = {
  input: DeleteRoomMessageInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteScheduleArgs = {
  input: DeleteScheduleInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteScheduleSegmentArgs = {
  input: DeleteScheduleSegmentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteSocialMediaArgs = {
  input: DeleteSocialMediaInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteSquadStreamInvitationArgs = {
  input: DeleteSquadStreamInvitationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteStreamAuthorizedUserArgs = {
  input: DeleteStreamAuthorizedUserInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteUserColorsArgs = {
  input: DeleteUserColorsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeleteVideoCommentArgs = {
  commentID: Scalars['ID'];
};


/** Operations to update data in the Twitch API. */
export type MutationDenyRejectedChatMessageArgs = {
  input: DenyRejectedChatMessageInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDenyRejectedCheerArgs = {
  input: DenyRejectedCheerInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDeselectChannelBadgeArgs = {
  input: DeselectChannelBadgeInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDisableUserAccountArgs = {
  input: DisableUserAccountInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDismissFriendRecommendationArgs = {
  input: DismissFriendRecommendationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDismissRitualTokenArgs = {
  input: DismissRitualTokenInput;
};


/** Operations to update data in the Twitch API. */
export type MutationDismissVideoSuggestedHighlightArgs = {
  input: DismissVideoSuggestedHighlightInput;
};


/** Operations to update data in the Twitch API. */
export type MutationEditRoomMessageArgs = {
  input: EditRoomMessageInput;
};


/** Operations to update data in the Twitch API. */
export type MutationEmitCampaignDiscoveryEventArgs = {
  input: EmitCampaignDiscoveryEventInput;
};


/** Operations to update data in the Twitch API. */
export type MutationFinalizeCompetitionLobbyArgs = {
  input: FinalizeCompetitionLobbyInput;
};


/** Operations to update data in the Twitch API. */
export type MutationFollowGameArgs = {
  input: FollowGameInput;
};


/** Operations to update data in the Twitch API. */
export type MutationFollowUserArgs = {
  input: FollowUserInput;
};


/** Operations to update data in the Twitch API. */
export type MutationGenerateExtensionRatingsCsvReportArgs = {
  input: GenerateExtensionRatingsCsvReportInput;
};


/** Operations to update data in the Twitch API. */
export type MutationGenerateSubscribersCsvArgs = {
  input: GenerateSubscribersCsvInput;
};


/** Operations to update data in the Twitch API. */
export type MutationGoRaidArgs = {
  input: GoRaidInput;
};


/** Operations to update data in the Twitch API. */
export type MutationGrantVipArgs = {
  input: GrantVipInput;
};


/** Operations to update data in the Twitch API. */
export type MutationHostTargetChannelArgs = {
  input: HostTargetChannelInput;
};


/** Operations to update data in the Twitch API. */
export type MutationInstallExtensionArgs = {
  input: InstallExtensionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationInterruptScheduleArgs = {
  input: InterruptScheduleInput;
};


/** Operations to update data in the Twitch API. */
export type MutationInvalidateAuthenticatedSessionsArgs = {
  input: InvalidateAuthenticatedSessionsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationInvalidateEmailAssociationArgs = {
  input: InvalidateEmailAssociationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationJoinChannelRoomsArgs = {
  input: JoinChannelRoomsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationJoinRaidArgs = {
  input: JoinRaidInput;
};


/** Operations to update data in the Twitch API. */
export type MutationLeaveChannelRoomsArgs = {
  input: LeaveChannelRoomsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationLeaveRaidArgs = {
  input: LeaveRaidInput;
};


/** Operations to update data in the Twitch API. */
export type MutationLeaveSquadStreamArgs = {
  input: LeaveSquadStreamInput;
};


/** Operations to update data in the Twitch API. */
export type MutationLinkSsoArgs = {
  input: LinkSsoInput;
};


/** Operations to update data in the Twitch API. */
export type MutationMakeKeyBatchDownloadUrlArgs = {
  input: MakeKeyBatchDownloadUrlInput;
};


/** Operations to update data in the Twitch API. */
export type MutationModUserArgs = {
  input: ModUserInput;
};


/** Operations to update data in the Twitch API. */
export type MutationOrderPanelsArgs = {
  input: OrderPanelsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationPublishClipArgs = {
  input: PublishClipInput;
};


/** Operations to update data in the Twitch API. */
export type MutationPurchaseOfferArgs = {
  input: PurchaseOfferInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRateExtensionArgs = {
  input: RateExtensionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationReadNotificationsArgs = {
  input: ReadNotificationsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRecordAdEventArgs = {
  input: RecordAdEventInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRecordMissionReferralExperimentArgs = {
  input: RecordMissionReferralExperimentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRedeemClaimableArgs = {
  input: RedeemClaimableInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRedeemCommunityPointsCustomRewardArgs = {
  input: RedeemCommunityPointsCustomRewardInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRedeemRitualTokenArgs = {
  input: RedeemRitualTokenInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRedeemSubscriptionArgs = {
  input: RedeemSubscriptionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRedeemTrueXAdArgs = {
  input: RedeemTrueXAdInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRegenerateStreamKeyArgs = {
  input: RegenerateStreamKeyInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRegenerateVerificationCodeArgs = {
  input: RegenerateVerificationCodeInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRegisterPayoutInformationArgs = {
  input: RegisterPayoutInformationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRejectFriendRequestArgs = {
  input: RejectFriendRequestInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRejectSquadStreamInvitationArgs = {
  input: RejectSquadStreamInvitationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRejectSquadStreamOutOfNetworkInvitationsArgs = {
  input: RejectSquadStreamOutOfNetworkInvitationsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRemoveAutohostChannelsArgs = {
  input: RemoveAutohostChannelsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRemoveCollectionItemArgs = {
  input: RemoveCollectionItemInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRemoveCompetitionPhaseArgs = {
  input: RemoveCompetitionPhaseInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRemoveCompetitionPlayerArgs = {
  input: RemoveCompetitionPlayerInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRemoveCompetitionTeamArgs = {
  input: RemoveCompetitionTeamInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRemoveEditorArgs = {
  input: RemoveEditorInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRemoveOrganizationMemberArgs = {
  input: RemoveOrganizationMemberInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRemoveReactionArgs = {
  input: RemoveReactionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRemoveSquadStreamMemberArgs = {
  input: RemoveSquadStreamMemberInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRemoveStuccoArgs = {
  input: RemoveStuccoInput;
};


/** Operations to update data in the Twitch API. */
export type MutationReorderCollectionItemArgs = {
  input: ReorderCollectionItemInput;
};


/** Operations to update data in the Twitch API. */
export type MutationReportContentArgs = {
  input: ReportContentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationReportWhisperThreadArgs = {
  input: ReportWhisperThreadInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRequestRitualTokenArgs = {
  input: RequestRitualTokenInput;
};


/** Operations to update data in the Twitch API. */
export type MutationResendVerificationEmailArgs = {
  input: ResendVerificationEmailInput;
};


/** Operations to update data in the Twitch API. */
export type MutationResumeScheduleArgs = {
  input: ResumeScheduleInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRevokeVipArgs = {
  input: RevokeVipInput;
};


/** Operations to update data in the Twitch API. */
export type MutationRunMultiplayerAdsArgs = {
  input: RunMultiplayerAdsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSaveExtensionManifestArgs = {
  input: SaveExtensionManifestInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSeedCompetitionParticipantArgs = {
  input: SeedCompetitionParticipantInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSelectChannelBadgeArgs = {
  input: SelectChannelBadgeInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSelectGlobalBadgeArgs = {
  input: SelectGlobalBadgeInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSendChatMessageThroughSubscriberModeArgs = {
  input: SendChatMessageThroughSubscriberModeInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSendCheerArgs = {
  input: SendCheerInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSendHighlightedChatMessageArgs = {
  input: SendHighlightedChatMessageInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSendRoomMessageArgs = {
  input: SendRoomMessageInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSendWhisperArgs = {
  input: SendWhisperInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetAutoRefillSettingsArgs = {
  input: SetAutoRefillSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetAutohostChannelsArgs = {
  input: SetAutohostChannelsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetBitsUserSettingsArgs = {
  input: SetBitsUserSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetChannelFeedEnabledArgs = {
  input: SetChannelFeedEnabledInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetChannelNotificationSettingArgs = {
  input: SetChannelNotificationSettingInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetChannelTrailerArgs = {
  input: SetChannelTrailerInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetChatPauseSettingArgs = {
  input: SetChatPauseSettingInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetContentTagsArgs = {
  input: SetContentTagsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetDashboardAlertQueueActivityStatusArgs = {
  input: SetDashboardAlertQueueActivityStatusInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetDashboardAlertQueuePreferenceArgs = {
  input: SetDashboardAlertQueuePreferenceInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetDefaultPaymentMethodArgs = {
  input: SetDefaultPaymentMethodInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetDeletedMessageDisplaySettingArgs = {
  input: SetDeletedMessageDisplaySettingInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetEmoteModifierGroupsArgs = {
  input: SetEmoteModifierGroupsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetExtensionFeatureFlagsArgs = {
  input: SetExtensionFeatureFlagsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetExtensionInstallationOAuthArgs = {
  input: SetExtensionInstallationOAuthInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetModLogsAccessArgs = {
  input: SetModLogsAccessInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetModViewSettingsArgs = {
  input: SetModViewSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetNotificationSettingArgs = {
  input: SetNotificationSettingInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetOverwatchLeagueTeamPreferenceArgs = {
  input: SetOverwatchLeagueTeamPreferenceInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetPreferredLanguageTagArgs = {
  input: SetPreferredLanguageTagInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetQuickActionLayoutArgs = {
  input: SetQuickActionLayoutInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetReadableChatColorsEnabledArgs = {
  input: SetReadableChatColorsEnabledInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetResourceRestrictionArgs = {
  input: SetResourceRestrictionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetSessionStatusArgs = {
  input: SetSessionStatusInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetSocialMediaPanelEnabledArgs = {
  input: SetSocialMediaPanelEnabledInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetSquadStreamPrimaryPlayerArgs = {
  input: SetSquadStreamPrimaryPlayerInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSetUserResidenceArgs = {
  input: SetUserResidenceInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSpendSubscriptionCreditArgs = {
  input: SpendSubscriptionCreditInput;
};


/** Operations to update data in the Twitch API. */
export type MutationStartAdArgs = {
  input: StartAdInput;
};


/** Operations to update data in the Twitch API. */
export type MutationStartBountyArgs = {
  input: StartBountyInput;
};


/** Operations to update data in the Twitch API. */
export type MutationStartPayoutOnboardingWorkflowArgs = {
  input: StartPayoutOnboardingWorkflowInput;
};


/** Operations to update data in the Twitch API. */
export type MutationStartWatchPartyArgs = {
  input: StartWatchPartyInput;
};


/** Operations to update data in the Twitch API. */
export type MutationStopBountyArgs = {
  input: StopBountyInput;
};


/** Operations to update data in the Twitch API. */
export type MutationStopWatchPartyArgs = {
  input: StopWatchPartyInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSubmitEmotePrefixArgs = {
  input: SubmitEmotePrefixInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSubmitEmoticonPrefixArgs = {
  input: SubmitEmoticonPrefixInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSubmitExtensionFeedbackArgs = {
  input: SubmitExtensionFeedbackInput;
};


/** Operations to update data in the Twitch API. */
export type MutationSwapCompetitionLobbyParticipantsArgs = {
  input: SwapCompetitionLobbyParticipantsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationTerminatePollArgs = {
  input: TerminatePollInput;
};


/** Operations to update data in the Twitch API. */
export type MutationTerminatePollInChannelArgs = {
  input: TerminatePollInChannelInput;
};


/** Operations to update data in the Twitch API. */
export type MutationToggleRitualsEnabledArgs = {
  input: ToggleRitualsEnabledInput;
};


/** Operations to update data in the Twitch API. */
export type MutationTransitionExtensionStateArgs = {
  input: TransitionExtensionStateInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnbanUserFromChatRoomArgs = {
  input: UnbanUserFromChatRoomInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnblockUserArgs = {
  input: UnblockUserInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUndoRecommendationFeedbackArgs = {
  input: UndoRecommendationFeedbackInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnfollowGameArgs = {
  input: UnfollowGameInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnfollowUserArgs = {
  input: UnfollowUserInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnfriendUserArgs = {
  input: UnfriendUserInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnhostArgs = {
  input: UnhostInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUninstallExtensionArgs = {
  input: UninstallExtensionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnlinkAmazonConnectionArgs = {
  input: UnlinkAmazonConnectionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnlinkRiotConnectionArgs = {
  input: UnlinkRiotConnectionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnlinkSsoArgs = {
  input: UnlinkSsoInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnlockChosenModifiedSubscriberEmoteArgs = {
  input: UnlockChosenModifiedSubscriberEmoteInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnlockChosenSubscriberEmoteArgs = {
  input: UnlockChosenSubscriberEmoteInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnlockRandomSubscriberEmoteArgs = {
  input: UnlockRandomSubscriberEmoteInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnmodUserArgs = {
  input: UnmodUserInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnsetHypeTrainConfigArgs = {
  input: UnsetHypeTrainConfigInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUnsubscribeEmailArgs = {
  input: UnsubscribeEmailInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateAdPropertiesArgs = {
  input: UpdateAdPropertiesInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateAllWhisperThreadsArgs = {
  input: UpdateAllWhisperThreadsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateAutoModPropertiesArgs = {
  input: UpdateAutoModPropertiesInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateAutohostSettingsArgs = {
  input: UpdateAutohostSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateBitsBadgeTierNotificationArgs = {
  input: UpdateBitsBadgeTierNotificationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateBitsBadgeTiersArgs = {
  input: UpdateBitsBadgeTiersInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateBroadcastSettingsArgs = {
  input: UpdateBroadcastSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCelebrationArgs = {
  input: UpdateCelebrationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCelebrationConfigArgs = {
  input: UpdateCelebrationConfigInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateChanletContentAttributesArgs = {
  input: UpdateChanletContentAttributesInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateChannelHomePreferencesArgs = {
  input: UpdateChannelHomePreferencesInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateChatColorArgs = {
  input: UpdateChatColorInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateChatSettingsArgs = {
  input: UpdateChatSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCheerPartnerSettingsArgs = {
  input: UpdateCheerPartnerSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateClipArgs = {
  input: UpdateClipInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateClipViewCountArgs = {
  input: UpdateClipViewCountInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCollectionArgs = {
  input: UpdateCollectionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCommunityPointsAutomaticRewardArgs = {
  input: UpdateCommunityPointsAutomaticRewardInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCommunityPointsChannelSettingsArgs = {
  input: UpdateCommunityPointsChannelSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCommunityPointsCustomRewardArgs = {
  input: UpdateCommunityPointsCustomRewardInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCommunityPointsCustomRewardRedemptionStatusArgs = {
  input: UpdateCommunityPointsCustomRewardRedemptionStatusInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCommunityPointsCustomRewardRedemptionStatusesByChannelArgs = {
  input: UpdateCommunityPointsCustomRewardRedemptionStatusesByChannelInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCommunityPointsCustomRewardRedemptionStatusesByRedemptionsArgs = {
  input: UpdateCommunityPointsCustomRewardRedemptionStatusesByRedemptionsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCommunityPointsCustomRewardRedemptionStatusesByRewardArgs = {
  input: UpdateCommunityPointsCustomRewardRedemptionStatusesByRewardInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCommunityPointsEarlyAccessSettingsArgs = {
  input: UpdateCommunityPointsEarlyAccessSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCommunityPointsSmartCostsAcknowledgementsArgs = {
  input: UpdateCommunityPointsSmartCostsAcknowledgementsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCompetitionArgs = {
  input: UpdateCompetitionInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCompetitionPlayerArgs = {
  input: UpdateCompetitionPlayerInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateCompetitionTeamArgs = {
  input: UpdateCompetitionTeamInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateConsentArgs = {
  input: UpdateConsentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateContentTagsArgs = {
  input: UpdateContentTagsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateDropsOptOutStatusArgs = {
  input: UpdateDropsOptOutStatusInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateExtensionDiscoveryDataArgs = {
  input: UpdateExtensionDiscoveryDataInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateExtensionManifestArgs = {
  input: UpdateExtensionManifestInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateHypeTrainConfigArgs = {
  input: UpdateHypeTrainConfigInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateIsSharingActivityArgs = {
  input: UpdateIsSharingActivityInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateLwaTokenArgs = {
  input: UpdateLwaTokenInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateLeaderboardSettingsArgs = {
  input: UpdateLeaderboardSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateLiveUpNotificationArgs = {
  input: UpdateLiveUpNotificationInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateLobbyParticipantScoreArgs = {
  input: UpdateLobbyParticipantScoreInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateMultiviewContentAttributesArgs = {
  input: UpdateMultiviewContentAttributesInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateOnboardingSkippedChannelsArgs = {
  input: UpdateOnboardingSkippedChannelsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateOrganizationMemberRoleArgs = {
  input: UpdateOrganizationMemberRoleInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateOwnerChanletAttributesArgs = {
  input: UpdateOwnerChanletAttributesInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdatePanelArgs = {
  input: UpdatePanelInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdatePrimeOfferStatusArgs = {
  input: UpdatePrimeOfferStatusInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdatePrimeSettingsArgs = {
  input: UpdatePrimeSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateRaidSettingsArgs = {
  input: UpdateRaidSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateRoomArgs = {
  input: UpdateRoomInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateRoomModesArgs = {
  input: UpdateRoomModesInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateRoomViewArgs = {
  input: UpdateRoomViewInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateScheduleSegmentArgs = {
  input: UpdateScheduleSegmentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateSeenCreatorOnboardingContentArgs = {
  input: UpdateSeenCreatorOnboardingContentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateSocialMediaArgs = {
  input: UpdateSocialMediaInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateSquadInvitePolicyArgs = {
  input: UpdateSquadInvitePolicyInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateSquadStreamArgs = {
  input: UpdateSquadStreamInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateStuccoArgs = {
  input: UpdateStuccoInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateStuccoPackArgs = {
  input: UpdateStuccoPackInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateSubscriptionProductArgs = {
  input: UpdateSubscriptionProductInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateUserColorsArgs = {
  input: UpdateUserColorsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateUserCreateDateHiddenArgs = {
  input: UpdateUserCreateDateHiddenInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateUserDirectoryHiddenArgs = {
  input: UpdateUserDirectoryHiddenInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateUserEmailReusableArgs = {
  input: UpdateUserEmailReusableInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateUserIsEmailRevertSuccessArgs = {
  input: UpdateUserIsEmailRevertSuccessInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateUserSubscriptionSettingsArgs = {
  input: UpdateUserSubscriptionSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateUserVideoShelvesArgs = {
  input: UpdateUserVideoShelvesInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateUserViewedVideoArgs = {
  input: UpdateUserViewedVideoInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateVideoArgs = {
  input: UpdateVideoInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateVideoCommentArgs = {
  input: UpdateVideoCommentInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateVideoStreamSettingsArgs = {
  input: UpdateVideoStreamSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateVisibilityArgs = {
  input: UpdateVisibilityInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateWhisperSettingsArgs = {
  input: UpdateWhisperSettingsInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUpdateWhisperThreadArgs = {
  input: UpdateWhisperThreadInput;
};


/** Operations to update data in the Twitch API. */
export type MutationUseChatNotificationTokenArgs = {
  input: UseChatNotificationTokenInput;
};


/** Operations to update data in the Twitch API. */
export type MutationValidateVerificationCodeArgs = {
  input: ValidateVerificationCodeInput;
};


/** Operations to update data in the Twitch API. */
export type MutationVerifyContactMethodArgs = {
  input: VerifyContactMethodInput;
};


/** Operations to update data in the Twitch API. */
export type MutationVerifyRewardedVideoEligibilityCaptchaArgs = {
  input: VerifyRewardedVideoEligibilityCaptchaInput;
};


/** Operations to update data in the Twitch API. */
export type MutationVoteInPollArgs = {
  input: VoteInPollInput;
};


/** Operations to update data in the Twitch API. */
export type MutationVoteInPollByChoiceIndexArgs = {
  input: VoteInPollByChoiceIndexInput;
};

/** Information about a registered developer OAuth application. */
export type OAuthApp = {
   __typename?: 'OAuthApp';
  /** The category that describes the app's type. */
  category?: Maybe<OAuthAppCategory>;
  /** The timestamp when the app was created. */
  createdAt: Scalars['Time'];
  /** The ID of the app. It is the value of the `Client-ID` header when the app makes API requests. */
  id: Scalars['ID'];
  /** The name of the app. */
  name: Scalars['String'];
  /** The user-provided description of the app's type. Used if `Category` is Other. */
  otherDescription?: Maybe<Scalars['String']>;
  /** Owner is the user that owns this app. */
  owner?: Maybe<User>;
  /** The URI to which users should be redirected after authorizing the app. */
  redirectURI: Scalars['String'];
  /** The client secret of the app. */
  secret: Scalars['String'];
  /** The timestamp when the app was last updated. */
  updatedAt: Scalars['Time'];
  /** Whether the app's OAuth tokens expire. */
  willTokensExpire: Scalars['Boolean'];
};

/** Possible categories of developer apps. */
export enum OAuthAppCategory {
  /** Game integration category. */
  GameIntegration = 'GAME_INTEGRATION',
  /** Website integration category. */
  WebsiteIntegration = 'WEBSITE_INTEGRATION',
  /** Application integration category. */
  ApplicationIntegration = 'APPLICATION_INTEGRATION',
  /** Browser extension category. */
  BrowserExtension = 'BROWSER_EXTENSION',
  /** Broadcaster suite category. */
  BroadcasterSuite = 'BROADCASTER_SUITE',
  /** Chat bot category. */
  ChatBot = 'CHAT_BOT',
  /** Giveaway loyalty tool category. */
  GiveawayLoyaltyTool = 'GIVEAWAY_LOYALTY_TOOL',
  /** Analytics tool category. */
  AnalyticsTool = 'ANALYTICS_TOOL',
  /** Category for when the other categories do not describe. */
  Other = 'OTHER'
}

/** A list of applications. */
export type OAuthAppConnection = {
   __typename?: 'OAuthAppConnection';
  /** The applications. */
  edges: Array<OAuthAppEdge>;
  /** Pagination. */
  pageInfo: PageInfo;
};

/** A broadcaster user with cursor. */
export type OAuthAppEdge = {
   __typename?: 'OAuthAppEdge';
  /** Cursor represents the position of the current edge/node. */
  cursor: Scalars['Cursor'];
  /** Node represents the app for the current edge. */
  node: OAuthApp;
};

/** OEmbed is a universal spec converted to GraphQL from http://oembed.com/. */
export type OEmbed = {
  authorName?: Maybe<Scalars['String']>;
  authorURL?: Maybe<Scalars['String']>;
  cacheAge?: Maybe<Scalars['Int']>;
  /**
   * The inputURL is the URL that we are trying to resolve via oEmbed.  It is not part
   * of the official spec, but GQL implementations practically need to use it.
   */
  inputURL: Scalars['String'];
  providerName?: Maybe<Scalars['String']>;
  providerURL?: Maybe<Scalars['String']>;
  /**
   * The description of thumbnail from the oembed spec fits with an optional thumbnail
   * type with required parameters.
   */
  thumbnail?: Maybe<ThumbnailOEmbed>;
  title?: Maybe<Scalars['String']>;
  type: Scalars['String'];
  version: Scalars['String'];
};

/** Offer describes something that is purchasable. */
export type Offer = {
   __typename?: 'Offer';
  /** Details of the user's eligibility to purchase the Offer. */
  eligibility: OfferEligibility;
  /** The time at which this Offer ceases to be valid for purchase. If null, this Offer will never expire. */
  endAt?: Maybe<Scalars['Time']>;
  /** The type of the gift offer (will be omitted if the Offer is not a gift). */
  giftType?: Maybe<GiftType>;
  /** Unique identifier for an Offer. */
  id: Scalars['ID'];
  /** A listing describing the charge model and cancellation policy for the Offer. */
  listing?: Maybe<OfferListing>;
  /** The platform on which the Offer is eligible for purchase. */
  platform: OfferPlatform;
  /** A Promotion object describes the promotion to be applied on an Offer (if any). */
  promotion?: Maybe<OfferPromotion>;
  /** Quantity is the configured purchase quantity restrictions. */
  quantity?: Maybe<Range>;
  /** The authenticated user's relationship with the Offer. */
  self?: Maybe<OfferSelfEdge>;
  /** The time at which this Offer becomes valid for purchase. */
  startAt: Scalars['Time'];
  /** Tag bindings provide static and dynamic bindings of the attributes on an Offer. */
  tagBindings: Array<OfferTagBinding>;
  /** Tenant product line registry to which this Offer belongs. */
  tplr: Scalars['String'];
};

/** Contains an offer ID and offer status. */
export type OfferAndStatus = {
  /** Unique Identifier for an offer. */
  offerID: Scalars['ID'];
  /** The status to set the offer to for the specified user. */
  status: Scalars['String'];
};

/** Deliver method type for Prime Offers entitlements. */
export enum OfferDeliveryMethod {
  /** The entitlement will be delivered as a claim code, which can be used to get the entitlement. */
  ClaimCode = 'CLAIM_CODE',
  /** The entitlement will be directly delivered. */
  DirectEntitlement = 'DIRECT_ENTITLEMENT',
  /** Misspelling of EXTERNAL_OFFER. */
  External = 'EXTERNAL',
  /** The entitlement will be delivered via external means. */
  ExternalOffer = 'EXTERNAL_OFFER'
}

/** OfferEligibility describes user's eligibility to purchase an Offer. */
export type OfferEligibility = {
   __typename?: 'OfferEligibility';
  /**
   * If the user is eligible for the Offer, then this is set to the
   * time at which the user's benefits would expire if the
   * Offer is purchased. If null, the benefits never expire.
   */
  benefitsEndAt?: Maybe<Scalars['Time']>;
  /**
   * If the user is eligible for the Offer, then this is set to the
   * time at which the user's benefits would become available if the
   * Offer is purchased.
   */
  benefitsStartAt?: Maybe<Scalars['Time']>;
  /** A boolean that is true when the user is eligible for the Offer. */
  isEligible: Scalars['Boolean'];
  /**
   * Allows tenants to override the maximum purchasable quantity for an offer 
   * within a checkout session (used in purchase velocity cases).
   */
  maxQuantityOverride?: Maybe<Scalars['Int']>;
  /** Provides extra contextual details for the type of purchase. */
  purchaseType: OfferPurchaseType;
  /**
   * If the user is ineligible for the Offer, then this code is set
   * as the reason why the user is ineligible.
   */
  reasonCode?: Maybe<OfferIneligibilityReasonCode>;
};

/** OfferIneligibilityReasonCode indicates why a user isn't eligible. */
export enum OfferIneligibilityReasonCode {
  /** Not eligible because the user has already purchased this offer. */
  AlreadyPurchased = 'ALREADY_PURCHASED',
  /** Not eligible because something about the transaction could not be verified. */
  CouldNotVerify = 'COULD_NOT_VERIFY',
  /** Offer would exceed user's max token balance. */
  MaxTokenBalance = 'MAX_TOKEN_BALANCE',
  /** No ineligibility reason was given. */
  None = 'NONE',
  /** The reason for ineligibility could not be resolved. */
  Other = 'OTHER'
}

/** OfferListing defines the charge model for a given listing. */
export type OfferListing = {
   __typename?: 'OfferListing';
  /** The conditions around a user's cancellation of their purchase (e.g. refund policy). */
  cancellationPolicy: CancellationPolicyType;
  /** FIAT/non-FIAT based charge model OR 3P managed SKU. */
  chargeModel: ChargeModel;
};

/** The platform on which the Offer is valid. */
export enum OfferPlatform {
  /** The web site. */
  Web = 'WEB',
  /** The iOS app. */
  Ios = 'IOS',
  /** The Android app. */
  Android = 'ANDROID',
  /** The desktop app. */
  Desktop = 'DESKTOP'
}

/** Promotion is a modifier to an Offer. */
export type OfferPromotion = {
   __typename?: 'OfferPromotion';
  /** End time of a promotion (empty if evergreen promotion). */
  endAt?: Maybe<Scalars['Time']>;
  /** Unique identifier for a Promotion. */
  id: Scalars['ID'];
  /**
   * The OfferListing associated with this Promotion.
   * @deprecated No longer used, currently left for backwards compatibility
   */
  listing: OfferListing;
  /** Unique name for a Promotion. */
  name: Scalars['String'];
  /** Describes the priority of the Promotion (the higher the priorty, the more important the promo). */
  priority: Scalars['Int'];
  /** Describe the Promotions metadata to display to the client. */
  promoDisplay: PromotionDisplay;
  /** Start time of a promotion. */
  startAt: Scalars['Time'];
};

/** OfferPUrchaseType provides extra contextual details for the type of purchase. */
export enum OfferPurchaseType {
  /** This offer is a default, standard purchase. */
  DefaultPurchase = 'DEFAULT_PURCHASE',
  /** This offer being purchased will be a tier upgrade from their current active tier. */
  UpgradeRecurringSubTier = 'UPGRADE_RECURRING_SUB_TIER',
  /** This offer being purchased will be a tier downgrade from their current active tier. */
  DowngradeRecurringSubTier = 'DOWNGRADE_RECURRING_SUB_TIER',
  /** This offer being purchased is future-dated. */
  FuturePurchase = 'FUTURE_PURCHASE'
}

/** The authenticated user's relationship with the offer. */
export type OfferSelfEdge = {
   __typename?: 'OfferSelfEdge';
  /** Returns any fraud-related checkout actions that the client must invoke. */
  checkoutActions?: Maybe<Array<CheckoutAction>>;
  /** Configs that initiate the user's checkout flow for this Offer. */
  checkoutConfiguration?: Maybe<CheckoutConfiguration>;
  /**
   * Provides a list of eligible payment methods that the user can select for this offer.
   * This is a temporary field for the migration of eligiblePaymentMethods field.
   * @deprecated Use eligiblePaymentMethods instead
   */
  eligiblePaymentMethodNames?: Maybe<Array<EligiblePaymentMethodName>>;
  /** Provides a list of eligible payment methods that the user can select for this offer. */
  eligiblePaymentMethods?: Maybe<Array<EligiblePaymentMethod>>;
};


/** The authenticated user's relationship with the offer. */
export type OfferSelfEdgeCheckoutActionsArgs = {
  quantity: Scalars['Int'];
  paymentSession?: Maybe<PaymentSession>;
};

/** OfferTagBinding defines a key-value pair. */
export type OfferTagBinding = {
   __typename?: 'OfferTagBinding';
  /** The key of the tag. */
  key: Scalars['String'];
  /** The value of the tag. */
  value: Scalars['String'];
};

/** OfferTagBindingInput defines a key-value pair. */
export type OfferTagBindingInput = {
  /** The key of the tag. */
  key: Scalars['String'];
  /** The value of the tag. */
  value: Scalars['String'];
};

/** Current state of the user in the onboarding process. */
export type Onboarding = {
   __typename?: 'Onboarding';
  /**
   * Retrieves a list of streams that have been selected for onboarding based on a user's followed games.
   * `first` is the number of streams PER FOLLOWED GAME to fetch.
   * `locale` is a language code that will filter streams by if there are viewers
   * with that language code (ex. "en-US", "es-ES", or "de-AT").
   * `languages` is list of language codes that will be used to filter streams by the broadcaster language. (ex. [EN, KO]).
   * `games` are a list of game ids that would replace the user's followed games for fetching the streams.
   */
  onboardingStreams?: Maybe<Array<Maybe<Stream>>>;
  /**
   * List of channel IDs skipped by a user during onboarding.
   * @deprecated This feature is retired
   */
  skippedChannelIDs?: Maybe<Array<Scalars['ID']>>;
};


/** Current state of the user in the onboarding process. */
export type OnboardingOnboardingStreamsArgs = {
  first?: Maybe<Scalars['Int']>;
  locale?: Maybe<Scalars['String']>;
  languages?: Maybe<Array<Language>>;
  games?: Maybe<Array<Scalars['String']>>;
};

export type OnsiteNotification = {
   __typename?: 'OnsiteNotification';
  /** Actions of the notification. */
  actions: Array<OnsiteNotificationAction>;
  /** Body of the notification in Markdown format. */
  body: Scalars['String'];
  /** When this notification was created. */
  createdAt: Scalars['Time'];
  /** List of users that created this notification. */
  creators: Array<Maybe<User>>;
  /**
   * Destination type to route users to when they interact with the notification on non-web clients.
   * Values include Homepage, ChannelPage, NotificationSettingsPage, and BroadcasterDashboard.
   */
  destinationType?: Maybe<Scalars['String']>;
  /**
   * Optional extra notification content.
   * When type is "vodupload", extra is Video.
   * When type is "hotclipfollower", extra is Clip.
   * When type is "hotclip", extra is Clip.
   * When type is "subgiftreceived", extra is User.
   * When type is "vodcomment", extra is VideoComment.
   * When type is "vodcommentmod", extra is VideoComment.
   * When type is "vodcommentreply", extra is VideoComment.
   * When destination is "ChannelPage", extra is User.
   * When destination is "BrowseGame", extra is Game.
   * When destination is "ExternalLink", extra is OnsiteNotificationExternalLink.
   */
  extra?: Maybe<OnsiteNotificationContent>;
  /** ID of the notification. */
  id: Scalars['ID'];
  /** Whether this notification is read. */
  isRead: Scalars['Boolean'];
  /** Type of onsite render style. */
  renderStyle: OnsiteNotificationRenderStyle;
  /** A URL to a thumbnail image. */
  thumbnailURL: Scalars['String'];
  /** Type of notification. */
  type: Scalars['String'];
  /** When notification was last updated. */
  updatedAt: Scalars['Time'];
};

export type OnsiteNotificationAction = {
   __typename?: 'OnsiteNotificationAction';
  /** Body of the notification action in plain text. */
  body: Scalars['String'];
  /** ID of the action. */
  id: Scalars['ID'];
  /** Label of the action. */
  label: Scalars['String'];
  /** ID of the modal that will open on click, if it is a modal CTA. */
  modalID: Scalars['ID'];
  /** Type of the notification action. */
  type: Scalars['String'];
  /** URL of the notification action. */
  url: Scalars['String'];
};

export type OnsiteNotificationConnection = {
   __typename?: 'OnsiteNotificationConnection';
  /** List of notifications. */
  edges?: Maybe<Array<OnsiteNotificationEdge>>;
  /** Information about pagination in this connection. */
  pageInfo?: Maybe<PageInfo>;
  /** Notifications summary. */
  summary?: Maybe<OnsiteNotificationsSummary>;
};

/** Extra onsite notification content. */
export type OnsiteNotificationContent = Clip | Game | OnsiteNotificationExternalLink | User | Video | VideoComment;

export type OnsiteNotificationEdge = {
   __typename?: 'OnsiteNotificationEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor?: Maybe<Scalars['Cursor']>;
  /** The notification. */
  node: OnsiteNotification;
};

/** Extra onsite notification content returned when the notification links to an external site. */
export type OnsiteNotificationExternalLink = {
   __typename?: 'OnsiteNotificationExternalLink';
  /** The link that the notification opens when clicked. */
  url: Scalars['String'];
};

/** Used to determine how to render the onsite notification. */
export enum OnsiteNotificationRenderStyle {
  /** The default render style with no buttons and a single click CTA. */
  Default = 'DEFAULT',
  /** Rendered with two CTA buttons. */
  TwoButtons = 'TWO_BUTTONS'
}

export type OnsiteNotificationsSummary = {
   __typename?: 'OnsiteNotificationsSummary';
  /** Last time notifications were seen. */
  lastSeenAt?: Maybe<Scalars['Time']>;
  /** Number of unseen notifications. */
  unseenCount: Scalars['Int'];
};

export type OrderPanelsInput = {
  ids: Array<Scalars['ID']>;
};

export type OrderPanelsPayload = {
   __typename?: 'OrderPanelsPayload';
  /** List of panels in their new order. */
  panels?: Maybe<Array<Maybe<Panel>>>;
};

/** A developer organization. */
export type Organization = {
   __typename?: 'Organization';
  /** ID of the Company in the CurseForge Infrastructure. */
  curseCompanyID?: Maybe<Scalars['ID']>;
  /** Drop Campaigns developed by the organization. */
  dropCampaigns?: Maybe<Array<DropCampaign>>;
  /**
   * The games associated with the company. Optionally include games that a company can use for Bounty Board
   * campaigns (ie. "Just Chatting" for trailer campaigns).
   */
  games?: Maybe<Array<Game>>;
  /** The company's unique identifier. */
  id: Scalars['ID'];
  /** Legacy Companies need to agree to the Drops Terms. */
  isCampaignsEnabled: Scalars['Boolean'];
  /** Legacy Companies are required to sign the Contract. */
  isContractSigned: Scalars['Boolean'];
  /** Indicates if the Company is a Legacy Company from the first iteration of the DevSite. */
  isLegacy: Scalars['Boolean'];
  /** A list of rbac users who are apart of an organization. */
  members?: Maybe<OrganizationMemberConnection>;
  /** The human-readable name of the company. */
  name: Scalars['String'];
  /** Attributes related to the current user. */
  self?: Maybe<OrganizationSelfEdge>;
  /** Indicates if company is a developer, publisher or other. */
  type: OrganizationType;
  /** The Company URL for their Corporate Website. */
  url: Scalars['String'];
};


/** A developer organization. */
export type OrganizationGamesArgs = {
  includeBountyBoardGames?: Maybe<Scalars['Boolean']>;
};


/** A developer organization. */
export type OrganizationMembersArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  input?: Maybe<OrganizationMembersInput>;
};

/** Status of company applications. */
export enum OrganizationAppilcationStatus {
  /** Application is pending. */
  Pending = 'PENDING',
  /** Application has been rejected. */
  Rejected = 'REJECTED',
  /** Application has been approved. */
  Approved = 'APPROVED',
  /** Application has been deleted. */
  Deleted = 'DELETED'
}

/** OrganziationApplication is the application for requesting an organization be added to Twitch Developer Organizations. */
export type OrganizationApplication = {
   __typename?: 'OrganizationApplication';
  /** Email of the person creating the application. */
  contactEmail: Scalars['String'];
  /** The name of applying organization. */
  organizationName: Scalars['String'];
  /** Current status of the company application. */
  status: OrganizationAppilcationStatus;
};

/** A RBAC user. */
export type OrganizationMember = {
   __typename?: 'OrganizationMember';
  /** Users email. */
  email: Scalars['String'];
  /** Users first name. */
  firstName: Scalars['String'];
  /** Twitch user id. */
  id: Scalars['ID'];
  /** Users last name. */
  lastName: Scalars['String'];
  /** Users role. */
  role: OrganizationMemberRole;
  /** Users title. */
  title: Scalars['String'];
  /** The Twitch user associated with the RBAC user. */
  user?: Maybe<User>;
};

/** A paginated list of organization member relationships. */
export type OrganizationMemberConnection = {
   __typename?: 'OrganizationMemberConnection';
  /** The elements of the paginated list. */
  edges: Array<OrganizationMemberEdge>;
  /** Information about this page. */
  pageInfo: PageInfo;
  /** The total number of Organization members. */
  totalCount: Scalars['Int'];
};

/**
 * An element in a paginated list of organization member relationships.
 * Contains metadata about the follow relationship between two users.
 */
export type OrganizationMemberEdge = {
   __typename?: 'OrganizationMemberEdge';
  /** An opaque cursor identifying the edge's position in the paginted list. */
  cursor: Scalars['Cursor'];
  /** Date user joined organization. */
  joinedAt: Scalars['Time'];
  /** The user who is organization members. */
  node: OrganizationMember;
};

/** Role for an organization member. */
export enum OrganizationMemberRole {
  /** Adiministrator role. */
  Administrator = 'ADMINISTRATOR',
  /** Developer role. */
  Developer = 'DEVELOPER',
  /** Manager role. */
  Manager = 'MANAGER',
  /** Marketer role. */
  Marketer = 'MARKETER',
  /** Owner Role. */
  Owner = 'OWNER',
  /** Billing Manager Role. */
  BillingManager = 'BILLING_MANAGER'
}

/** Parameters for filtering OrganizationMembers. */
export type OrganizationMembersInput = {
  /** Filter members with this role. */
  role?: Maybe<OrganizationMemberRole>;
};

/** The relationship between the authenticated user and a game. */
export type OrganizationSelfEdge = {
   __typename?: 'OrganizationSelfEdge';
  /** Whether or not the current user is able to add another to the organization. */
  canAddMember: Scalars['Boolean'];
  /** Whether or not the current user is able to leave the organization. */
  canLeaveOrganization: Scalars['Boolean'];
  /** Whether or not the current user is able to remove a member from the organization. */
  canRemoveMember: Scalars['Boolean'];
  /** Date user joined organization. */
  joinedAt: Scalars['Time'];
  /** The current users role in the organization. */
  role: OrganizationMemberRole;
};

/** Type of work an organization does. */
export enum OrganizationType {
  /** Organization that developes games. */
  GameDeveloper = 'GAME_DEVELOPER',
  /** Organization that publishes games. */
  GamePublisher = 'GAME_PUBLISHER',
  /** Organization that does other work. */
  Other = 'OTHER',
  /** Organization that works in brands/advertsing. */
  BrandsAdvertising = 'BRANDS_ADVERTISING',
  /** Organization that works with broadcaster tools. */
  BroadcasterTools = 'BROADCASTER_TOOLS'
}

/** Friend requests sent from this user to other users. */
export type OutgoingFriendRequestConnection = {
   __typename?: 'OutgoingFriendRequestConnection';
  /** The friend request elements of this list. */
  edges?: Maybe<Array<OutgoingFriendRequestEdge>>;
  /** Information about this page. */
  pageInfo: PageInfo;
  /** The total number of outgoing friend requests. */
  totalCount: Scalars['Int'];
};

/** A friend request sent from this user to another user. */
export type OutgoingFriendRequestEdge = {
   __typename?: 'OutgoingFriendRequestEdge';
  /** The time at which the friend request was sent. */
  createdAt: Scalars['Time'];
  /** An opaque cursor identifying the edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** The user to whom the friend request was sent. */
  node?: Maybe<User>;
};

/** Contains Overwatch League Team preferences. */
export type OverwatchLeagueTeamPreference = {
   __typename?: 'OverwatchLeagueTeamPreference';
  /** Set of available teams for selection. */
  availableTeamsSet?: Maybe<Array<OverwatchTeamPreferenceOption>>;
  /** Unique identifier for this set of Overwatch team preferences. */
  id: Scalars['ID'];
  /** The preferred team. */
  selectedTeam?: Maybe<OverwatchTeamPreferenceOption>;
};

/** Moment Details specific to the overwatch game. */
export type OverwatchMomentDetails = {
   __typename?: 'OverwatchMomentDetails';
  /** One of "game_start" or "hero_change". */
  event: Scalars['String'];
  /** The hero the broadcaster is playing. */
  heroName: Scalars['String'];
  /** The role the broadcaster is playing. */
  role: Scalars['String'];
};

/** Contains an Overwatch team option to choose as the preferred team. */
export type OverwatchTeamPreferenceOption = {
   __typename?: 'OverwatchTeamPreferenceOption';
  /** Unique identifier for this Overwatch team preference. */
  id: Scalars['ID'];
  /** The rewards associated with this team preference. */
  rewards?: Maybe<Array<TournamentReward>>;
  /** The name of the team. */
  teamName: Scalars['String'];
};

/** OwnerChanletAttributes store configuration flags for child chanlets the channel owns. */
export type OwnerChanletAttributes = {
   __typename?: 'OwnerChanletAttributes';
  /** Whether to show the child chanlets. */
  isChanletFeatureEnabled: Scalars['Boolean'];
};

/**
 * PageInfo is a special field which contains information about the page,
 * specifically the cursors which the page starts and ends, and whether or
 * not the client can forward-paginate or backward-paginate.
 * 
 * This is part of the Relay Cursor Connections Specification:
 * https://facebook.github.io/relay/graphql/connections.htm.
 */
export type PageInfo = {
   __typename?: 'PageInfo';
  hasNextPage: Scalars['Boolean'];
  hasPreviousPage: Scalars['Boolean'];
};

/**
 * Data about a paid upgrade for a subscription.
 * ie. a user upgrades a 1-month gift to a recurring subscription.
 */
export type PaidUpgrade = {
   __typename?: 'PaidUpgrade';
  /** The id of the paid upgrade purchase. Used to cancel the paid upgrade. */
  originID: Scalars['ID'];
  /**
   * The formatted price of the paid upgrade in USD.
   * @deprecated Transitioning to priceInfo instead
   */
  price: Scalars['String'];
  /** PriceInfo holds the paid upgrade's pricing information such as currency, cost, and tax information. */
  priceInfo: PriceInfo;
  /** The date the paid upgrade begins. */
  startsAt: Scalars['Time'];
  /** Tier of upgraded product. */
  tier: Scalars['String'];
};


/**
 * Data about a paid upgrade for a subscription.
 * ie. a user upgrades a 1-month gift to a recurring subscription.
 */
export type PaidUpgradePriceInfoArgs = {
  taxCountry?: Maybe<Scalars['String']>;
};

/** Panel is information about a single info panel for a channel. */
export type Panel = {
  /** id is a unique identifier for the panel. */
  id: Scalars['ID'];
  /** type is the kind of panel. */
  type: PanelType;
};

/** The required configuration to activate a panel extension. */
export type PanelActivationInput = {
  /** The slot name of where the component extension should be displayed. */
  slot: Scalars['String'];
};

/** PanelType is the kind of panel. */
export enum PanelType {
  /** DEFAULT panels contain one or more of the content values in `Panel` to display. */
  Default = 'DEFAULT',
  /** EXTENSION panels are placeholders for extension content. */
  Extension = 'EXTENSION'
}

/** PanelView holds the view configuration of an extension if the panel anchor is supported. */
export type PanelView = ExtensionView & {
   __typename?: 'PanelView';
  /** Specifies whether or not the extension has the ability to link to external websites. */
  canLinkExternalContent: Scalars['Boolean'];
  /** The extension developer configured height of the panel extension. */
  height: Scalars['Int'];
  /** Relative path of the HTML file to load for this view, used by devsite to specify the layout of assets. */
  viewerPath: Scalars['String'];
  /** The URL which should be loaded in for the extension. */
  viewerURL: Scalars['String'];
};

/** PanelViewInput holds the view configuration of an extension if the panel anchor is supported. */
export type PanelViewInput = {
  /** The extension developer configured height of the panel extension. */
  height: Scalars['Int'];
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

/** DEPRECATED. */
export type Partnership = {
   __typename?: 'Partnership';
  isPartner?: Maybe<Scalars['Boolean']>;
};

/** PartnershipApplication is a submitted partnership application. */
export type PartnershipApplication = {
   __typename?: 'PartnershipApplication';
  /**
   * ID of the user that submitted the application,
   * provided purely for the convenience of invalidating GraphQL client caches.
   */
  id: Scalars['ID'];
  /**
   * A submitted application currently can only be unresolved or resolved:
   * 
   * - A null resolvedAt timestamp means that the application is unresolved and may be under review.
   * 
   * - A non-null resolvedAt means that the application has been resolved, either approved or rejected.
   *   A user with an approved application may now start the partnership on-boarding flow.
   */
  resolvedAt?: Maybe<Scalars['Time']>;
};

/** PasswordStatus determines the current state of the users password. */
export enum PasswordStatus {
  /** The users password has never been evaluated. */
  NotEvaluated = 'NOT_EVALUATED',
  /** The users password meets requirements. */
  Valid = 'VALID',
  /** The users password does not meet requirements. */
  Invalid = 'INVALID',
  /** Unknown password status. */
  Unknown = 'UNKNOWN'
}

/** Types of credit cards supported. */
export enum PaymentCardType {
  /** Visa. */
  Visa = 'VISA',
  /** Mastercard. */
  Mastercard = 'MASTERCARD',
  /** American Express. */
  AmericanExpress = 'AMERICAN_EXPRESS',
  /** Discover. */
  Discover = 'DISCOVER'
}

/**
 * A monthly rollup of metrics that are relevant to incentive-based contracts for
 * some partnered streamers.
 */
export type PaymentIncentiveMetricsRollup = {
   __typename?: 'PaymentIncentiveMetricsRollup';
  /**
   * A measure of how much advertising time broadcasters have during their live
   * streams.
   */
  advertisingDensity: Scalars['Float'];
  /** The number of live hours the user streamed for the month. */
  liveHoursBroadcast: Scalars['Float'];
  /** The number of live minutes watched for the month. */
  liveMinutesWatched: Scalars['Float'];
  /**
   * The start time for the monthly rollup. These times are in the Pacific Time
   * Zone and the monthly rollups begin in this time zone. Rather than
   * converting to local time, clients should inform end users of this timing
   * quirk and perform custom parsing on these values to show the current year
   * and month in Pacific Time.
   */
  timestamp?: Maybe<Scalars['Time']>;
  /** The number of VOD minutes watched the user has for the month. */
  vodMinutesWatched: Scalars['Float'];
};

/** Payment instrument used through the payment provider. */
export enum PaymentInstrumentType {
  /** Credit or debit card. */
  CreditCard = 'CREDIT_CARD',
  /** Pay with Amazon. */
  Amazon = 'AMAZON',
  /** Pay with Paypal. */
  Paypal = 'PAYPAL',
  /** Pay with Google In-App Billing. */
  GoogleIab = 'GOOGLE_IAB',
  /** Pay with Apple In-App Purchase. */
  AppleIap = 'APPLE_IAP',
  /** Xsolla only. */
  Skrill = 'SKRILL',
  /** Xsolla only. */
  Yandex = 'YANDEX',
  /** Xsolla only. */
  Webmoney = 'WEBMONEY',
  /** Xsolla default. */
  Unknown = 'UNKNOWN',
  /** Pay with Wallet. */
  Wallet = 'WALLET'
}

/** Type of payment method a user has used to buy products on Twitch, such as subs. */
export type PaymentMethod = {
   __typename?: 'PaymentMethod';
  /** Country (ISO-3166) associated to the billing info for the customer's payment method. */
  billingCountry?: Maybe<Scalars['String']>;
  /** Email associated with customer's Amazon/Paypal account. */
  billingEmail?: Maybe<Scalars['String']>;
  /** If payment type is card, then the type of card used is shown here. */
  cardType?: Maybe<PaymentCardType>;
  /** ID of the payment method that can be referenced by other systems. */
  chargeInstrumentID: Scalars['ID'];
  /** Credit card expiration month, if paymentType is CREDIT_CARD. */
  expirationMonth?: Maybe<Scalars['Int']>;
  /** Credit card expiration year, if paymentType is CREDIT_CARD. */
  expirationYear?: Maybe<Scalars['Int']>;
  /**
   * External payment method ID (the ID recorded by the payment provider)
   * We can guarantee its uniqueness since it is external from our systems.
   */
  extMethodID?: Maybe<Scalars['ID']>;
  /** Whether or not payment method has restrictions. */
  isRestricted: Scalars['Boolean'];
  /** Credit card last four digits, if paymentType is CREDIT_CARD. */
  lastFour?: Maybe<Scalars['String']>;
  /** Payment type used via the payment provider. */
  paymentType: PaymentInstrumentType;
  /** One of the payment providers that Twitch currently supports. */
  provider: PaymentProvider;
  /** List of purchase profiles associated with this payment method. */
  purchaseProfiles?: Maybe<Array<PurchaseProfile>>;
  /**
   * List of recurring payments associated with this payment method.
   * New schema to eventually replace purchase profiles.
   */
  recurringPaymentDetails?: Maybe<Array<RecurringPaymentDetail>>;
};

/** The list of availability statuses for a payment method. */
export enum PaymentMethodAvailabilityStatus {
  /** Available status. */
  Available = 'AVAILABLE',
  /** Degraded status. */
  Degraded = 'DEGRADED',
  /** Full outage status. */
  FullOutage = 'FULL_OUTAGE'
}

/** Type of payment providers. */
export enum PaymentProvider {
  /** Recurly payment provider, allows payments with credit card, amazon, paypal. */
  Recurly = 'RECURLY',
  /** Xsolla payment provider, usually provides Iframe for users to go through checkout process. */
  Xsolla = 'XSOLLA',
  /** (Deprecated) Xsolla payment provider, usually provides Iframe for users to go through checkout process. */
  XsollaV3 = 'XSOLLA_V3',
  /** Zuora payment provider, supports credit card payments. */
  Zuora = 'ZUORA',
  /** Twitch Prime used to buy product on Twitch. */
  Prime = 'PRIME',
  /** Google In-App Billing, for Android transactions. */
  GoogleIab = 'GOOGLE_IAB',
  /** Apple In-App Purchases for iOS transactions. */
  AppleIap = 'APPLE_IAP',
  /** Sub tokens, which can be redeemed for channel subscriptions. */
  SubToken = 'SUB_TOKEN'
}

export type PaymentProviderConfigs = {
   __typename?: 'PaymentProviderConfigs';
  /** Configs to initiate Recurly library for the user for purchase checkout or payment method update. */
  recurly: RecurlyConfigs;
  /** Xsolla configs include the iframe URL for purchase checkout or payment method update. */
  xsolla: XsollaConfigs;
  /** Configs for initiating Zuora credit card payments or payment method update. */
  zuora: ZuoraConfigs;
};

/** Inputs for PaymentSession. */
export type PaymentSession = {
  /** Payment's Tracking Checkout ID. */
  checkoutSessionID?: Maybe<Scalars['ID']>;
  /** User's device ID. */
  deviceID?: Maybe<Scalars['ID']>;
  /** Purchase Fingerprint. */
  fingerprint?: Maybe<Scalars['String']>;
  /** Twilight's storage device ID. */
  localStorageDeviceID?: Maybe<Scalars['ID']>;
  /** Offer Session ID. */
  offerSessionID?: Maybe<Scalars['ID']>;
  /** Twilight's Page Session ID. */
  pageSessionID?: Maybe<Scalars['ID']>;
  /** Twilight's Tab Session ID. */
  tabSessionID?: Maybe<Scalars['ID']>;
};

/**
 * There are legacy and new data sources that contain similar payment transaction data. This type aims to merge several
 * data sources into one to expose a consistent payment history for each Twitch user.
 */
export type PaymentTransaction = {
   __typename?: 'PaymentTransaction';
  /** Currency for the price. */
  currency?: Maybe<Scalars['String']>;
  /** Price in smallest subunit for the currency, such as 499. */
  grossAmount?: Maybe<Scalars['Int']>;
  /** The divisor used to derive the gross amount. */
  grossAmountDivisor?: Maybe<Scalars['Int']>;
  /** Payment ID such as PPT321281 or POPT3278183712. */
  id: Scalars['ID'];
  /** Whether this payment transaction was made to purchase a gift for someone else or not. */
  isGift: Scalars['Boolean'];
  /** The payment method that was used to generate this payment transaction. */
  paymentMethod: PaymentMethod;
  /** Payment transaction purchased product details. */
  product: PaymentTransactionProduct;
  /** PurchaseOrderID for the payment. */
  purchaseOrderID?: Maybe<Scalars['ID']>;
  /** Time the purchase payment was recognized at. */
  purchasedAt: Scalars['Time'];
  /** Quantity of the purchase. */
  quantity: Scalars['Int'];
  /** The recipient Twitch user of the product purchased by the payment transaction, if applicable. */
  recipient?: Maybe<User>;
};

/** A paginated list of payment transactions, and its metadata. */
export type PaymentTransactionConnection = {
   __typename?: 'PaymentTransactionConnection';
  /** The list of payment transactions on this page. */
  edges?: Maybe<Array<PaymentTransactionEdge>>;
  /** The payment date of the earliest PaymentTransaction among all possible pages. */
  firstPurchasedAt?: Maybe<Scalars['Time']>;
  /** The payment date of the latest PaymentTransaction among all possible pages. */
  lastPurchasedAt?: Maybe<Scalars['Time']>;
  /** Information about this page of payment transactions. */
  pageInfo: PageInfo;
  /** The total number of payment transactions in the overall collection. */
  totalCount?: Maybe<Scalars['Int']>;
};

/** Filter and sorting options for querying all transactions for a Twitch purchaser. */
export type PaymentTransactionConnectionCriteriaInput = {
  /** Only show transactions purchased after this date. */
  purchasedAfter?: Maybe<Scalars['Time']>;
  /** Only show transactions purchased before this date. */
  purchasedBefore?: Maybe<Scalars['Time']>;
  /** Sort transactions by... defaults to date desc. */
  sortBy?: Maybe<PaymentTransactionSort>;
  /** Only show transactions that purchased products of a certain type, defaults to ALL. */
  type?: Maybe<PaymentTransactionTypeFilter>;
  /** Purchaser ID. */
  userID: Scalars['ID'];
};

/** An element in a paginated list of payment transactions, and its metadata. */
export type PaymentTransactionEdge = {
   __typename?: 'PaymentTransactionEdge';
  /** Offset acting as a cursor. */
  cursor: Scalars['Cursor'];
  /** The element node. */
  node?: Maybe<PaymentTransaction>;
};

/** Payment transaction purchased product details. */
export type PaymentTransactionProduct = {
   __typename?: 'PaymentTransactionProduct';
  /** Number of digital goods wrapped into a product. */
  bundleSize: Scalars['Int'];
  /** The name of the product. */
  name: Scalars['String'];
  /** Some products have owners. For example, the owner of the `Lirik - Tier 1 Subscription` product is Lirik. */
  owner?: Maybe<User>;
  /** Some products have tiers, such as subs. */
  tier?: Maybe<Scalars['String']>;
  /** What type of product the payment was made for. */
  type: PaymentTransactionType;
};

/** Possible sort orders for lists of payment transactions. */
export enum PaymentTransactionSort {
  /** Sort the payment transactions descending by price. */
  PriceDesc = 'PRICE_DESC',
  /** Sort the payment transactions ascending by price. */
  PriceAsc = 'PRICE_ASC',
  /** Sort by purchase date descending. */
  PurchaseDateDesc = 'PURCHASE_DATE_DESC',
  /** Sort by purchase date ascending. */
  PurchaseDateAsc = 'PURCHASE_DATE_ASC'
}

/** Payment transaction type. */
export enum PaymentTransactionType {
  /** Transaction for a subscription type. */
  Subscription = 'SUBSCRIPTION',
  /** Transaction for a bits type. */
  Bits = 'BITS',
  /** Transaction for a sub token. */
  SubToken = 'SUB_TOKEN',
  /** Transaction for gift cards. */
  GiftCard = 'GIFT_CARD'
}

/** Select the kind of transactions. */
export enum PaymentTransactionTypeFilter {
  /** Only return payment transactions that associated with subscription products. */
  Subscriptions = 'SUBSCRIPTIONS',
  /** Only return payment transactions that are associated with subtoken purchases and redemptions. */
  SubToken = 'SUB_TOKEN',
  /** The default filter (no filter). */
  All = 'ALL'
}

/** Payout Information. */
export type Payout = {
   __typename?: 'Payout';
  /** Payout History Information. */
  history?: Maybe<PayoutHistory>;
};

/** Enumerates valid payout categories. */
export enum PayoutCategory {
  /** Assigned if the user has a payout plan for the affiliate program. */
  Affiliate = 'AFFILIATE',
  /** Assigned if the user has a payout plan for the extensions developer program. */
  ExtensionsDeveloper = 'EXTENSIONS_DEVELOPER',
  /** Assigned if the user has a payout plan for the partner program. */
  Partner = 'PARTNER'
}

/** Payout History Information. */
export type PayoutHistory = {
   __typename?: 'PayoutHistory';
  /** Url for Tipalti payout history iframe. */
  iframeURL?: Maybe<Scalars['String']>;
};

/** PayoutInvite describes a user's invite to a payout program. */
export type PayoutInvite = {
   __typename?: 'PayoutInvite';
  /** The payout program category the user has been invited to. */
  category?: Maybe<PayoutOnboardingCategory>;
  /** A PayoutInvite's unique ID. */
  id: Scalars['ID'];
  /** Whether or not this payout invite is for the affiliate program. */
  isForAffiliate: Scalars['Boolean'];
  /** Whether or not this payout invite is for the extensions developer program. */
  isForExtensionsDeveloper: Scalars['Boolean'];
  /** Whether or not this payout invite is for the partner program. */
  isForPartner: Scalars['Boolean'];
  /** Whether or not the payout invite was created through the legacy onboarding flow. */
  isLegacy: Scalars['Boolean'];
  /** The payout onboarding workflow for this payout invite. */
  workflow?: Maybe<PayoutOnboardingWorkflow>;
};

/** PayoutOnboardingCategory enumerates valid categories for payout onboarding. */
export enum PayoutOnboardingCategory {
  /** Assigned for payout onboarding flows to enroll a user into the affiliate program. */
  Affiliate = 'AFFILIATE',
  /** Assigned for payout onboarding flows to enroll a user into the partner program with the "standard" payout plan. */
  StandardPartner = 'STANDARD_PARTNER',
  /** Assigned for payout onboarding flows to enroll a user into the partner program with the "premium" payout plan. */
  PremiumPartner = 'PREMIUM_PARTNER',
  /** Assigned for payout onboarding flows to enroll a user into the partner program with a "custom" payout plan. */
  CustomPartner = 'CUSTOM_PARTNER',
  /** Assigned for payout onboarding flows to enroll a user into the extensions developer program. */
  ExtensionsDeveloper = 'EXTENSIONS_DEVELOPER',
  /** Assigned for payout onboarding flows to enroll a user into an unpaid partner program. */
  UnpaidPartner = 'UNPAID_PARTNER'
}

/** PayoutOnboardingStep enumerates valid payout onboarding steps. */
export enum PayoutOnboardingStep {
  /** User needs to complete their registration step. */
  RegistrationNotStarted = 'REGISTRATION_NOT_STARTED',
  /** User needs to agree to their payout agreement. */
  AgreementNotStarted = 'AGREEMENT_NOT_STARTED',
  /** User needs to submit their royalty tax interview. */
  RoyaltyTaxInterviewNotStarted = 'ROYALTY_TAX_INTERVIEW_NOT_STARTED',
  /** User submitted their royalty tax interview and is waiting for it to be accepted. */
  RoyaltyTaxInterviewPending = 'ROYALTY_TAX_INTERVIEW_PENDING',
  /** User submitted their royalty tax interview but additional action by the user is required before completion. */
  RoyaltyTaxInterviewActionRequired = 'ROYALTY_TAX_INTERVIEW_ACTION_REQUIRED',
  /** User submitted their royalty tax interview and received mismatch errors. */
  RoyaltyTaxInterviewMismatch = 'ROYALTY_TAX_INTERVIEW_MISMATCH',
  /** User submitted their royalty tax interview and received errors while it was processed. */
  RoyaltyTaxInterviewFailed = 'ROYALTY_TAX_INTERVIEW_FAILED',
  /** User has completed their royalty tax interview and needs to complete their service tax interview. */
  ServiceTaxInterviewNotStarted = 'SERVICE_TAX_INTERVIEW_NOT_STARTED',
  /** User submitted their service tax interview and is waiting for it to be accepted. */
  ServiceTaxInterviewPending = 'SERVICE_TAX_INTERVIEW_PENDING',
  /** User submitted their service tax interview but additional action by the user is required before completion. */
  ServiceTaxInterviewActionRequired = 'SERVICE_TAX_INTERVIEW_ACTION_REQUIRED',
  /** User submitted their service tax interview and received mismatch errors. */
  ServiceTaxInterviewMismatch = 'SERVICE_TAX_INTERVIEW_MISMATCH',
  /** User submitted their service tax interview and received errors while it was processed. */
  ServiceTaxInterviewFailed = 'SERVICE_TAX_INTERVIEW_FAILED',
  /** User neeeds to setup how they want to get paid out. */
  PayoutMethodNotStarted = 'PAYOUT_METHOD_NOT_STARTED',
  /** User submitted their payout method and is waiting for it to be accepted. */
  PayoutMethodPending = 'PAYOUT_METHOD_PENDING',
  /** User is waiting for a final approval from the payout onboarding reviewers. */
  ReviewPending = 'REVIEW_PENDING',
  /** User has completed their payout onboarding. */
  Completed = 'COMPLETED',
  /** User has canceled their payout onboarding workflow. */
  Canceled = 'CANCELED',
  /** User has a pending upgrade to their payout agreement. */
  AgreementPendingUpgrade = 'AGREEMENT_PENDING_UPGRADE'
}

/** PayoutOnboardingWorkflow describes the workflow details while a user is onboarding into a payout program. */
export type PayoutOnboardingWorkflow = {
   __typename?: 'PayoutOnboardingWorkflow';
  /** The current step at which this workflow is at. */
  currentStep: PayoutOnboardingStep;
  /** A PayoutOnboardingWorkflow's unique ID. */
  id: Scalars['ID'];
  /**
   * The URL for a user to update their payout settings. A redirectURL is the URL
   * where the user will be redirected to after updating their payout settings.
   */
  payoutSettingsURL: Scalars['String'];
  /** The registration information submitted by the user for this workflow. */
  registration?: Maybe<PayoutRegistration>;
  /** Describes a user's tax interview information while completing their payout onboarding. */
  taxInterview?: Maybe<TaxInterview>;
  /** Lists the fields that were mismatched during the registration and tax interview steps. */
  taxMismatchErrors?: Maybe<Array<TaxMismatchError>>;
  /** The timestamp when the workflow was most recently updated. */
  timestamp: Scalars['Time'];
};


/** PayoutOnboardingWorkflow describes the workflow details while a user is onboarding into a payout program. */
export type PayoutOnboardingWorkflowPayoutSettingsUrlArgs = {
  redirectURL?: Maybe<Scalars['String']>;
};


/** PayoutOnboardingWorkflow describes the workflow details while a user is onboarding into a payout program. */
export type PayoutOnboardingWorkflowTaxInterviewArgs = {
  type: TaxInterviewType;
  returnURL: Scalars['String'];
};

/** Describes the payout plan a user has when enrolled into a payout program. */
export type PayoutPlan = {
   __typename?: 'PayoutPlan';
  /** The category applied for this payout plan. */
  category: PayoutCategory;
  /** Describes whether or not this payout plan is receiving revenue. */
  isReceivingRevenue: Scalars['Boolean'];
  /** Lists tags to further describe this type of payout plan. */
  tags?: Maybe<Array<PayoutPlanTag>>;
};

/** Enumerates valid payout plan tags. */
export enum PayoutPlanTag {
  /** Assigned if the user has the "standard" payout plan. */
  Standard = 'STANDARD',
  /** Assigned if the user has the "premium" payout plan. */
  Premium = 'PREMIUM',
  /** Assigned if the user has the "custom" payout plan. */
  Custom = 'CUSTOM',
  /** Assigned if the user has a payout plan created through the legacy onboarding flow. */
  Legacy = 'LEGACY'
}

/** PayoutRegistration describes the personal information a user submitted while onboarding into a payout program. */
export type PayoutRegistration = {
   __typename?: 'PayoutRegistration';
  /** Birthdate submitted by the user while registering into a payout program. */
  birthdate: Scalars['Time'];
  /** City submitted by the user while registering into a payout program. */
  city: Scalars['String'];
  /** Company Name submitted by the user while registering into a payout program. */
  companyName?: Maybe<Scalars['String']>;
  /** Country Code (ISO-3166) submitted by the user while registering into a payout program. */
  countryCode: Scalars['String'];
  /** Email submitted by the user while registering into a payout program. */
  email: Scalars['String'];
  /** First Name submitted by the user while registering into a payout program. */
  firstName: Scalars['String'];
  /** Last Name submitted by the user while registering into a payout program. */
  lastName: Scalars['String'];
  /** Middle Name submitted by the user while registering into a payout program. */
  middleName?: Maybe<Scalars['String']>;
  /** Parent Email submitted by the under age user while registering into a payout program. */
  parentEmail?: Maybe<Scalars['String']>;
  /** Parent Name submitted by the under age user while registering into a payout program. */
  parentName?: Maybe<Scalars['String']>;
  /** Postal submitted by the user while registering into a payout program. */
  postal?: Maybe<Scalars['String']>;
  /** State Code submitted by the user while registering into a payout program. */
  stateCode?: Maybe<Scalars['String']>;
  /** Primary Address submitted by the user while registering into a payout program. */
  streetAddress: Scalars['String'];
  /** Secondary Address submitted by the user while registering into a payout program. */
  streetAddress2?: Maybe<Scalars['String']>;
};

export type PayWithAmazonConfigs = {
   __typename?: 'PayWithAmazonConfigs';
  /** Used to configure PWA gateway and identify requests to Amazon. */
  clientID: Scalars['ID'];
  /** Frontend only has access to production PWA environment so this helps QA. */
  isProduction: Scalars['Boolean'];
  /** Also known as merchant ID, which identifies the account accepting payments. */
  sellerID: Scalars['ID'];
};

/**
 * Data about a pending future subscription.
 * ie. a user turns a 1-month gift into a recurring subscription.
 */
export type PendingSubscription = {
   __typename?: 'PendingSubscription';
  /** Whether the pending sub is cancelable. */
  isCancelable: Scalars['Boolean'];
  /** The id of the pending subscription purchase. Used to cancel the paid upgrade. */
  originID: Scalars['ID'];
  /**
   * The formatted price of the pending subscription in USD.
   * @deprecated Transitioning to priceInfo instead
   */
  price: Scalars['String'];
  /** PriceInfo holds the pending subscription's pricing information such as currency, cost, and tax information. */
  priceInfo: PriceInfo;
  /** The date the pending subscription begins. */
  startsAt: Scalars['Time'];
  /** Tier of pending subscription. */
  tier: Scalars['String'];
  /** The type of pending subscription. Ie GIFT_TO_PAID for a gift to paid conversion. */
  type: PendingSubType;
};


/**
 * Data about a pending future subscription.
 * ie. a user turns a 1-month gift into a recurring subscription.
 */
export type PendingSubscriptionPriceInfoArgs = {
  taxCountry?: Maybe<Scalars['String']>;
};

/** Denotes the type of pending subscription. */
export enum PendingSubType {
  /** This pending subscription was a conversion from a gift sub to a paid sub. */
  GiftToPaid = 'GIFT_TO_PAID',
  /** This pending subscription was a conversion from a DNRd sub to a renewing sub. */
  DnrToResubRecurring = 'DNR_TO_RESUB_RECURRING',
  /** This pending subscription was a conversion from a DNRd sub to a one month sub. */
  DnrToResubNonrecurring = 'DNR_TO_RESUB_NONRECURRING',
  /** This pending subscription was a conversion from a prime sub to a paid sub. */
  PrimeToPaid = 'PRIME_TO_PAID'
}

/** The permanent emote modifiers available to set. */
export enum PermanentEmoteModifier {
  /** Unknown emote modifier. */
  Unknown = 'UNKNOWN',
  /** BlackWhite emote modifier. */
  BlackWhite = 'BLACK_WHITE',
  /** HorizontalFlip emote modifier. */
  HorizontalFlip = 'HORIZONTAL_FLIP',
  /** Sunglasses emote modifier. */
  Sunglasses = 'SUNGLASSES',
  /** Thinking emote modifier. */
  Thinking = 'THINKING',
  /** Squished emote modifier. */
  Squished = 'SQUISHED'
}

/** The phase state signifies the progress of the phase in the competition. */
export enum PhaseState {
  /** No lobbies are currently actively playing in the phase. */
  Unstarted = 'UNSTARTED',
  /** Some or all the lobbies in the phase are actively playing. */
  Playing = 'PLAYING',
  /** All lobbies in the phase are done playing. */
  Finished = 'FINISHED',
  /** Lobby state is unknown. */
  Unknown = 'UNKNOWN'
}

export type PhotoOEmbed = OEmbed & {
   __typename?: 'PhotoOEmbed';
  authorName?: Maybe<Scalars['String']>;
  authorURL?: Maybe<Scalars['String']>;
  cacheAge?: Maybe<Scalars['Int']>;
  height: Scalars['Int'];
  inputURL: Scalars['String'];
  providerName?: Maybe<Scalars['String']>;
  providerURL?: Maybe<Scalars['String']>;
  thumbnail?: Maybe<ThumbnailOEmbed>;
  title?: Maybe<Scalars['String']>;
  type: Scalars['String'];
  url: Scalars['String'];
  version: Scalars['String'];
  width: Scalars['Int'];
};

/** Stream Platform. */
export type Platform = PlayStation;

export type PlatformEventSetting = {
   __typename?: 'PlatformEventSetting';
  /** Whether the setting is enabled for the given platform. */
  isEnabled: Scalars['Boolean'];
  /** The name of the platform. ("email", "push", etc..). */
  platformName: Scalars['String'];
  /** The exact state of the setting. ("on", "off", "friends_only", etc). */
  settingState: Scalars['String'];
};

/** Stream platform type. */
export enum PlatformType {
  All = 'all',
  Ps4 = 'ps4',
  Xbox = 'xbox'
}

export type Playing = Activity & {
   __typename?: 'Playing';
  /** The game being played. */
  game?: Maybe<Game>;
  /** This activity's type, i.e. "PLAYING". */
  type?: Maybe<ActivityType>;
};

/** Stream metadata for PlayStation. */
export type PlayStation = {
   __typename?: 'PlayStation';
  platform?: Maybe<Scalars['String']>;
  title?: Maybe<SceTitle>;
  updatedAt?: Maybe<Scalars['Time']>;
  user?: Maybe<SceUser>;
};

/** A poll users can vote in. */
export type Poll = {
   __typename?: 'Poll';
  /** A choice specified by a choice id. */
  choice?: Maybe<PollChoice>;
  /** A list of choices users can vote for. */
  choices: Array<PollChoice>;
  /**
   * User that created the poll.
   * Mods and editors can make polls on behalf of a broadcaster.
   */
  createdBy?: Maybe<User>;
  /**
   * Amount of seconds from when the poll starts to when it ends.
   * Since a broadcaster can end a poll early ("terminate a poll"), it may be possible for endedAt - startedAt != duration.
   */
  durationSeconds: Scalars['Int'];
  /**
   * Time when the poll ended.
   * Null if the poll is still active.
   */
  endedAt?: Maybe<Scalars['Time']>;
  /**
   * User that ended the poll. Mods and editors can end polls on behalf of a broadcaster.
   * Null if no user manually ended the poll.
   */
  endedBy?: Maybe<User>;
  /** ID of poll. */
  id: Scalars['ID'];
  /** Whether the poll is viewable by other users. */
  isViewable: Scalars['Boolean'];
  /** User who owns this poll. The poll will appear on their channel. */
  ownedBy?: Maybe<User>;
  /**
   * Amount of milliseconds before the poll ends.
   * 0 when the polls is ended.
   */
  remainingDurationMilliseconds: Scalars['Int'];
  /**
   * The authenticated user's relationship with this poll.
   * Main use case is to check if the user has voted in the poll already.
   * Null if un-authenticated user is making this query.
   */
  self?: Maybe<PollSelfEdge>;
  /** A map of poll settings. */
  settings: PollSettings;
  /** Time when poll started. */
  startedAt: Scalars['Time'];
  /** The status of the poll. */
  status: PollStatus;
  /** Title of poll. */
  title: Scalars['String'];
  /** A breakdown of the different tokens used in this poll. */
  tokens: PollTokenBreakdown;
  /** The top Bits contributor for the poll. */
  topBitsContributor?: Maybe<PollTopBitsContributor>;
  /** The top Community Points contributor for the poll. */
  topCommunityPointsContributor?: Maybe<PollTopCommunityPointsContributor>;
  /**
   * The top Bits contributor for the poll.
   * @deprecated Use topBitsContributor instead.
   */
  topContributor?: Maybe<PollTopContributor>;
  /** Total number of unique voters that have voted in this poll. */
  totalVoters: Scalars['Int'];
  /** A breakdown of the different votes cast in this poll. */
  votes: PollVoteBreakdown;
};


/** A poll users can vote in. */
export type PollChoiceArgs = {
  id: Scalars['ID'];
};

/** A choice in a poll that users can vote for. */
export type PollChoice = {
   __typename?: 'PollChoice';
  /** ID of choice. */
  id: Scalars['ID'];
  /** The authenticated user's relationship with this choice. */
  self: PollChoiceSelfEdge;
  /** The title of the choice. */
  title: Scalars['String'];
  /** A breakdown of the different tokens used for this choice. */
  tokens: PollTokenBreakdown;
  /** Total number of unique voters that have voted for this choice. */
  totalVoters: Scalars['Int'];
  /**
   * A list of voters for this choice.
   * Only the poll's ownerID and their mods/editors can search for this.
   */
  voters?: Maybe<PollChoiceVoterConnection>;
  /** A breakdown of the different votes cast for this choice. */
  votes: PollVoteBreakdown;
};


/** A choice in a poll that users can vote for. */
export type PollChoiceVotersArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  sort?: Maybe<PollVoterConnectionSort>;
  direction?: Maybe<PollVoterConnectionSortDirection>;
};

/** A connection between poll choice and the authenticated user. */
export type PollChoiceSelfEdge = {
   __typename?: 'PollChoiceSelfEdge';
  /** The voter object pertaining to the authenticated user. */
  voter?: Maybe<PollVoter>;
};

/** A connection between poll and voters and metadata. */
export type PollChoiceVoterConnection = {
   __typename?: 'PollChoiceVoterConnection';
  /** The list of voters in this poll / choice. */
  nodes: Array<PollVoterConnectionEdge>;
};

/** A connection between poll and metadata. */
export type PollConnection = {
   __typename?: 'PollConnection';
  /** The list of polls for the user. */
  edges?: Maybe<Array<PollEdge>>;
  /** Information about pagination in this connection. */
  pageInfo: PageInfo;
};

/** A page entry, that contains the Poll item and a cursor to return from the query to allow pagination. */
export type PollEdge = {
   __typename?: 'PollEdge';
  /** Cursor used for next query. */
  cursor: Scalars['Cursor'];
  /** The underlying poll voter. */
  node: Poll;
};

/** A connection between a poll and the authenticated user. */
export type PollSelfEdge = {
   __typename?: 'PollSelfEdge';
  /** The voter object pertaining to the authenticated user. */
  voter?: Maybe<PollVoter>;
};

/** Poll Settings. */
export type PollSettings = {
   __typename?: 'PollSettings';
  /** Bits votes poll settings. */
  bitsVotes: PollSettingsBitsVotes;
  /** Channel Points votes poll settings. */
  communityPointsVotes: PollSettingsCommunityPointsVotes;
  /** ID of poll settings. */
  id: Scalars['ID'];
  /** Multichoice voting poll settings. */
  multichoice: PollSettingsMultichoice;
  /**
   * Subscriber multiplier poll settings.
   * @deprecated Subscriber multipliers are no longer supported.
   */
  subscriberMultiplier: PollSettingsSubscriberMultiplier;
  /**
   * Subscriber only poll settings.
   * @deprecated Subscriber-only polls are no longer supported.
   */
  subscriberOnly: PollSettingsSubscriberOnly;
};

/** Bits votes poll settings. */
export type PollSettingsBitsVotes = {
   __typename?: 'PollSettingsBitsVotes';
  /** Cost of bits for a vote. */
  cost: Scalars['Int'];
  /** Whether the poll allows for users to use bits for votes. */
  isEnabled: Scalars['Boolean'];
};

/** Channel Points votes poll settings. */
export type PollSettingsCommunityPointsVotes = {
   __typename?: 'PollSettingsCommunityPointsVotes';
  /** Cost of channel points for a vote. */
  cost: Scalars['Int'];
  /** Whether the poll allows for users to use channel points for votes. */
  isEnabled: Scalars['Boolean'];
};

/** Multichoice voting enabled poll setting. */
export type PollSettingsMultichoice = {
   __typename?: 'PollSettingsMultichoice';
  /** Whether the poll has multichoice voting enabled. */
  isEnabled: Scalars['Boolean'];
};

/**
 * Subscriber multiplier poll settings.
 * Deprecated: subscriber multipliers are no longer supported.
 */
export type PollSettingsSubscriberMultiplier = {
   __typename?: 'PollSettingsSubscriberMultiplier';
  /** Whether the poll has a subscriber multipler. */
  isEnabled: Scalars['Boolean'];
};

/**
 * Subscriber only poll settings.
 * Deprecated: subscriber-only polls are no longer supported.
 */
export type PollSettingsSubscriberOnly = {
   __typename?: 'PollSettingsSubscriberOnly';
  /** Whether the poll is subscriber only. */
  isEnabled: Scalars['Boolean'];
};

/** Possible sort orders for lists of polls. */
export enum PollSort {
  /** Sort the polls by time. */
  StartTime = 'START_TIME'
}

/** The status of the poll. */
export enum PollStatus {
  /** Encountered some poll status that we do not know how to handle BibleThump. */
  Unknown = 'UNKNOWN',
  /** Poll is running. Users can vote. Results are publicly visible. */
  Active = 'ACTIVE',
  /** Poll ran its entire duration and "naturally" completed. Users cannot vote. Results are publicly visible. */
  Completed = 'COMPLETED',
  /** Poll was manually ended ("terminated") by a user. Users cannot vote. Results are publicly visible. */
  Terminated = 'TERMINATED',
  /** Poll has ended and is no longer publicly visible. Users cannot vote. Results are not publicly visible. */
  Archived = 'ARCHIVED',
  /**
   * Poll has been moderated by Twitch and is no longer viewable, even to the poll
   * owner. Users cannot vote. Results are not visible to any user.
   */
  Moderated = 'MODERATED'
}

/** A breakdown of tokens used/by for this poll/choice/user. */
export type PollTokenBreakdown = {
   __typename?: 'PollTokenBreakdown';
  /** Total number of bits used. */
  bits: Scalars['Int'];
  /** Total number of community points used. */
  communityPoints: Scalars['Int'];
  /** ID of token breakdown. */
  id: Scalars['ID'];
};

/** Top contributor to the poll and the bits they contributed. */
export type PollTopBitsContributor = {
   __typename?: 'PollTopBitsContributor';
  /** Bits amount contributed. */
  bitsAmount: Scalars['Int'];
  /** Top contributor to the poll. */
  user?: Maybe<User>;
};

/** Top contributor to the poll and the community points they contributed. */
export type PollTopCommunityPointsContributor = {
   __typename?: 'PollTopCommunityPointsContributor';
  /** Community Points amount contributed. */
  communityPointsAmount: Scalars['Int'];
  /** Top contributor to the poll. */
  user?: Maybe<User>;
};

/**
 * Top contributor to the poll and the bits they contributed.
 * Deprecated: use PollTopBitsContributor instead.
 */
export type PollTopContributor = {
   __typename?: 'PollTopContributor';
  /** Bits amount contributed. */
  bitsAmount: Scalars['Int'];
  /** Top contributor to the poll. */
  user?: Maybe<User>;
};

/** A breakdown of votes cast for/by this poll/choice/user. */
export type PollVoteBreakdown = {
   __typename?: 'PollVoteBreakdown';
  /** Total number of base votes. */
  base: Scalars['Int'];
  /** Total number of votes due to bits contributions. */
  bits: Scalars['Int'];
  /** Total number of votes due to Community Points contributions. */
  communityPoints: Scalars['Int'];
  /** ID of vote breakdown. */
  id: Scalars['ID'];
  /** Total number of votes across all different vote types. */
  total: Scalars['Int'];
};

/** A voter taking part in a poll and associated information. */
export type PollVoter = {
   __typename?: 'PollVoter';
  /** The Choices this voter voted for. */
  choices: Array<PollVoterChoice>;
  /** id of the voter in the poll. */
  id: Scalars['ID'];
  /** The Poll this voter voted in. */
  poll?: Maybe<Poll>;
  /** A breakdown of the different tokens used by the voter in the poll. */
  tokens: PollTokenBreakdown;
  /** The User object relating to this voter. */
  user?: Maybe<User>;
  /** A breakdown of the different votes this voter used in the poll. */
  votes: PollVoteBreakdown;
};

/** A choice a voter made taking part in a poll. */
export type PollVoterChoice = {
   __typename?: 'PollVoterChoice';
  /** The id of the PollVoterChoice. */
  id: Scalars['ID'];
  /** The poll choice. */
  pollChoice?: Maybe<PollChoice>;
  /** A breakdown of the different tokens used by the voter. */
  tokens: PollTokenBreakdown;
  /** A breakdown of the different votes this voter used. */
  votes: PollVoteBreakdown;
};

/** A connection between poll and voters and metadata. */
export type PollVoterConnection = {
   __typename?: 'PollVoterConnection';
  /** The list of voters in this poll / choice. */
  nodes: Array<PollVoterConnectionEdge>;
};

/** A page entry, that contains the PollVoter item and a cursor to return from the query to allow pagination. */
export type PollVoterConnectionEdge = {
   __typename?: 'PollVoterConnectionEdge';
  /** Cursor used for next query. */
  cursor: Scalars['Cursor'];
  /** The underlying poll voter. */
  node: PollVoter;
};

/** Possible sort orders for lists of voters. */
export enum PollVoterConnectionSort {
  /** Sort the voters by # of votes. */
  Votes = 'VOTES',
  /** Sort the voters by time of creation. */
  CreatedDate = 'CREATED_DATE',
  /** Sort the voters by amount of Bits on vote. */
  Bits = 'BITS',
  /** Sort the voters by amount of channel points. */
  ChannelPoints = 'CHANNEL_POINTS'
}

/** Possible sort directions for lists of voters. */
export enum PollVoterConnectionSortDirection {
  /** Sort in descending order. */
  Desc = 'DESC',
  /** Sort in ascending order. */
  Asc = 'ASC'
}

/** The tokens that are used on a vote. */
export type PollVoteTokensInput = {
  /** The amount of bits used for this vote. */
  bits: Scalars['Int'];
  /** The amount of channel points used for this vote. */
  channelPoints: Scalars['Int'];
};

export type Post = {
   __typename?: 'Post';
  /** The user that created this post. */
  author?: Maybe<User>;
  /** The content of the post as entered by the user and annotated with links and emotes. */
  body?: Maybe<MessageBody>;
  /** Time the post was created by the user. */
  createdAt?: Maybe<Scalars['Time']>;
  /** Collection of embedable content attached to this post. */
  embeds?: Maybe<Array<Maybe<PostEmbed>>>;
  /** This Post's unique feeds ID. */
  id: Scalars['ID'];
  /** Is this post deleted. */
  isDeleted?: Maybe<Scalars['Boolean']>;
  /** The reactions associated with this post. */
  reactions?: Maybe<Array<Maybe<Reaction>>>;
  /** Data related to the current user. */
  self?: Maybe<PostSelfConnection>;
};

/** TODO: Add events. */
export type PostEmbed = Clip | LinkOEmbed | PhotoOEmbed | RichOEmbed | Video | VideoOEmbed;

export type PostPermissionSet = {
   __typename?: 'PostPermissionSet';
  /** True if the current user is allowed to delete this post. */
  canDelete: Scalars['Boolean'];
};

export type PostSelfConnection = {
   __typename?: 'PostSelfConnection';
  /** Permissions that the current user has on this post. */
  permissions?: Maybe<PostPermissionSet>;
};

/** DEPRECATED. */
export type Premiere = {
   __typename?: 'Premiere';
  /**
   * The Premiere’s identifier.
   * @deprecated Premieres as a product has been deprecated
   */
  id: Scalars['ID'];
  /**
   * The paginated items in the premiere. At this time, they will all be VoDs.
   * A maximum of 100 items will be returned per request.
   * @deprecated Premieres as a product has been deprecated
   */
  items?: Maybe<PremiereConnection>;
  /**
   * The archived video. Only populated if the premiere is in state SUCCESS.
   * @deprecated Premieres as a product has been deprecated
   */
  pastPremiere?: Maybe<Video>;
  /**
   * Status of the premiere.
   * @deprecated Premieres as a product has been deprecated
   */
  status: PremiereStatus;
  /**
   * The user who this premiere belongs to.
   * @deprecated Premieres as a product has been deprecated
   */
  user?: Maybe<User>;
};


/** DEPRECATED. */
export type PremiereItemsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};

/**
 * DEPRECATED.
 * Paginated list of videos.
 */
export type PremiereConnection = {
   __typename?: 'PremiereConnection';
  /**
   * The list of items in this page.
   * @deprecated Premieres as a product has been deprecated
   */
  edges?: Maybe<Array<Maybe<PremiereItemEdge>>>;
  /**
   * Information about this page of videos.
   * @deprecated Premieres as a product has been deprecated
   */
  pageInfo?: Maybe<PageInfo>;
  /**
   * The total number of items in the premiere.
   * @deprecated Premieres as a product has been deprecated
   */
  totalCount?: Maybe<Scalars['Int']>;
};

/**
 * DEPRECATED.
 * The types of objects that can be contained in a premiere.
 */
export type PremiereItem = Video;

/**
 * DEPRECATED.
 * A page entry, that contains a premiere item and a cursor to return
 * from the query to allow pagination.
 * NOTE: this should have been named PremiereEdge.
 */
export type PremiereItemEdge = {
   __typename?: 'PremiereItemEdge';
  /**
   * Cursor is a cursor.
   * @deprecated Premieres as a product has been deprecated
   */
  cursor: Scalars['Cursor'];
  /**
   * Node is a node.
   * @deprecated Premieres as a product has been deprecated
   */
  node: PremiereItem;
};

/** DEPRECATED. */
export enum PremiereStatus {
  /** An unscheduled premiere. */
  Unscheduled = 'UNSCHEDULED',
  /** A scheduled premiere. */
  Scheduled = 'SCHEDULED',
  /** A cancelled premiere. */
  Cancelled = 'CANCELLED',
  /** A premiere that has been started. */
  Started = 'STARTED',
  /** A successfully completed premiere. */
  Success = 'SUCCESS',
  /**
   * A failed premiere. Examples of failed premieres are premieres that attempt to run
   * prior to the video being processed (or failed processing,) or the event failing
   * in the middle due to technical difficulties.
   */
  Failed = 'FAILED',
  /** An unknown status to ensure we are able to return something. */
  Unknown = 'UNKNOWN'
}

/**
 * Generic Price Information that supports taxing and multi region pricing.
 * LONG-TERM NOTE: using Int (32 bit) as a price field can cause issue when we sell products locally
 * e.g. 2147483648 (2^31) Lao Att = 253132 USD cent
 * Therefor, if we sell product which price more than $2500 in Laos currency. We will need to fix this.
 */
export type PriceInfo = {
   __typename?: 'PriceInfo';
  /** The currency associated with the price of a subscription product. */
  currency: Currency;
  /** The description associated with pricing information. */
  description: Scalars['String'];
  /** The discounted total also broken down by price and tax. */
  discount?: Maybe<DiscountBreakdown>;
  /** The ISO-4217 wording of deriving price. */
  exponent: Scalars['Int'];
  /** Identifier used for caching. */
  id: Scalars['ID'];
  /** If the tax is already included in price. */
  isTaxInclusive: Scalars['Boolean'];
  /** The numerical price of a subscription product. */
  price: Scalars['Int'];
  /** The tax rate of localized product. */
  tax: Scalars['Int'];
  /** The total price given price and tax. */
  total: Scalars['Int'];
};

/** Wrapper around standard Emoticons for Prime Smilies Emoticons. */
export type PrimeEmoticons = {
   __typename?: 'PrimeEmoticons';
  /** Name for the currently enabled Emoticon set selected by the user. */
  currentSetName: PrimeEmoticonsSetName;
  /** All Prime Emoticon Sets of emote values (id, token, setId). */
  emoticonSets?: Maybe<Array<SmiliesSet>>;
};

/** The Names for the smilies Emoticon sets supported by Prime. */
export enum PrimeEmoticonsSetName {
  /** Emotes that are granted to all users with Robot faces. Group id is #0 and emoticons start at id #1. */
  Robots = 'ROBOTS',
  /** Emotes that are granted via Prime with Turbo faces. */
  Purple = 'PURPLE',
  /** Emotes that are granted via Prime with Monkey faces. */
  Monkeys = 'MONKEYS'
}

/** Prime Digital Content Offers are displayed to users on Twitch via Offers in the top nav. */
export type PrimeOffer = {
   __typename?: 'PrimeOffer';
  /** Instructions string in Markdown displayed after offer is claimed to use or redeem. */
  claimInstructions: Scalars['String'];
  /** Content metadata for the given offer. */
  content?: Maybe<PrimeOfferContent>;
  /** The method of offer entitlement. */
  deliveryMethod: OfferDeliveryMethod;
  /** Description string in Markdown used in info block for Offer. */
  description: Scalars['String'];
  /** Unique Identifier for an offer. */
  id: Scalars['ID'];
  /** Offer image asset URL. */
  imageURL: Scalars['String'];
  /** Ranking for which the offer should be displayed, ordered ASC -1 through 99 where -1 value indicates top priority. */
  priority: Scalars['Int'];
  /** The connection for whether the user is entitled to the offer. */
  self?: Maybe<PrimeOfferSelfConnection>;
  /** Tags related to the offer such as Free Games with Prime (FGWP). */
  tags: Array<Scalars['String']>;
  /** Primary Title for Offer. */
  title: Scalars['String'];
};

/** An Object containing metadata for Digital Content. */
export type PrimeOfferContent = {
   __typename?: 'PrimeOfferContent';
  /** Content Categories for the game, displayed in info. */
  categories: Array<Scalars['String']>;
  /** If the content has an external marketing page (Blizzard, Retail, etc), some offers will have no external URL. */
  externalURL?: Maybe<Scalars['String']>;
  /** The Game metadata. */
  game?: Maybe<Game>;
  /** The publisher of the content. */
  publisher: Scalars['String'];
  /** Content SKU list for the offer. */
  skus: Array<Scalars['String']>;
};

/** The connection between the user and their offer entitlement state. */
export type PrimeOfferSelfConnection = {
   __typename?: 'PrimeOfferSelfConnection';
  /** The data (link, text, or claim code) for the entitlement that was created. */
  claimData: Scalars['String'];
  /** Indicates whether the user has the entitlement to the offer. */
  hasEntitlement: Scalars['Boolean'];
  /** The visual status of the offer to the user, UNSEEN, SEEN, CLAIMED, DISMISSED, OVERRIDDEN. */
  status: Scalars['String'];
};

/** PrimePayoutDetail shows the detailed breakdown of the prime payouts for a given user. */
export type PrimePayoutDetail = {
   __typename?: 'PrimePayoutDetail';
  /** currency for the payout number above. */
  currency: Currency;
  /** currentPrimePayout is the payout that will be made in this specific payout cycle. */
  currentPrimePayout: CurrentPrimePayout;
  /** deferredPrimePayout is part of the earning that was earned this month but will not be paid out this month. */
  deferredPrimePayout: DeferredPrimePayout;
  /** month when this payout will be made. */
  month: Scalars['Int'];
  /** year when this payout will be made. */
  year: Scalars['Int'];
};

/** PrimePayoutDetails shows the history of prime payout detail. */
export type PrimePayoutDetails = {
   __typename?: 'PrimePayoutDetails';
  /** primePayoutHistory is the history of prime payout details for a user. */
  primePayoutHistory: Array<PrimePayoutDetail>;
};

/** Metadata relevant to Prime copy or marketing that needs to be scheduled. */
export type PrimePromotion = {
   __typename?: 'PrimePromotion';
  /** externalURL is a string with the destination URL. */
  externalURL?: Maybe<Scalars['String']>;
  /** id is the unique identifier for the PrimePromotion. */
  id: Scalars['ID'];
  /** isExternalLink is boolean that indicates whether the text should be a link. */
  isExternalLink: Scalars['Boolean'];
  /** text is a string field containing the user visible text for a dynamic/changing string. */
  text: Scalars['String'];
};

/** Prime Settings related data for a given user. */
export type PrimeSettings = {
   __typename?: 'PrimeSettings';
  /** This type's unique identifier. */
  id: Scalars['ID'];
  /** If true, chat notifications will be sent on Prime Credit Token Channel Subscriptions. */
  isSubCreditChatNotificationEnabled: Scalars['Boolean'];
  /** The currently chosen Emoticon Set for the Prime User that are Smilies. */
  primeEmoticons?: Maybe<PrimeEmoticons>;
};

/** Information about the authenticated user's Prime subscription credit benefit. */
export type PrimeSubCreditBenefit = {
   __typename?: 'PrimeSubCreditBenefit';
  /** Checks when the authenticated user's Prime subscription credit will renew. */
  renewalDate?: Maybe<Scalars['Time']>;
  /** Checks if the authenticated user has the Prime benefit for 30-day subscription credit renewals. */
  willRenew?: Maybe<Scalars['Boolean']>;
};

/** Information about the Amazon user's Prime Video benefit. */
export type PrimeVideoBenefit = {
   __typename?: 'PrimeVideoBenefit';
  /** Error when the authentication token is expired. */
  error?: Maybe<WatchPartyError>;
  /** True if the user has valid access. */
  isValid?: Maybe<Scalars['Boolean']>;
};

/** Contains rating information for Prime Video content. */
export type PrimeVideoRating = {
   __typename?: 'PrimeVideoRating';
  /** Number of votes. */
  count: Scalars['Int'];
  /** Fractional number of stars. */
  stars: Scalars['Float'];
};

/** PrivacyLawName is the privacy law. */
export enum PrivacyLawName {
  /** Privacy law CCPA. */
  Ccpa = 'CCPA',
  /** Privacy GDPR. */
  Gdpr = 'GDPR',
  /** Rest of World. */
  Row = 'ROW'
}

/** Contains the product's checkout price and tax info for a purchase and error if a final price cannot be determined. */
export type ProductPurchase = {
   __typename?: 'ProductPurchase';
  /** The price and tax breakdown for the purchase. */
  checkoutPriceSummary?: Maybe<CheckoutPriceSummary>;
  /** Error when the final price could not be retrieved for a product. */
  errorCode?: Maybe<ProductPurchaseErrorCode>;
  /** The region from which the tax was calculated. */
  taxRegion?: Maybe<TaxRegion>;
};

/** Possible errors when retrieving product purchase info. */
export enum ProductPurchaseErrorCode {
  /** The user is unauthorized to retrieve the purchase info. */
  UserUnauthorized = 'USER_UNAUTHORIZED',
  /** PricingID not found. */
  PricingIdNotFound = 'PRICING_ID_NOT_FOUND',
  /** Cannot determine the user residence. */
  UnknownUserResidence = 'UNKNOWN_USER_RESIDENCE',
  /** Billing info not found for the user. */
  BillingInfoNotFound = 'BILLING_INFO_NOT_FOUND',
  /** User ineligible to make corresponding purchase. */
  PurchaseIneligible = 'PURCHASE_INELIGIBLE',
  /** Unexpected error occurred. */
  Unknown = 'UNKNOWN'
}

/** ProgramAgreement describes the End User License Agreement associated with a user's current payout plan. */
export type ProgramAgreement = {
   __typename?: 'ProgramAgreement';
  /** Agreement body in HTML. */
  body: Scalars['String'];
  /** Agreement type accepted by the user. */
  type: PayoutOnboardingCategory;
  /** Agreement version (e.g. "v1"). */
  version: Scalars['String'];
};

/** Types that can only be displayed for an Offer Promotion. */
export enum PromoDiscountType {
  /** No Discount type to be shown. */
  DiscountTypeNone = 'DISCOUNT_TYPE_NONE',
  /** Percent Discount type to be shown. */
  DiscountTypePercent = 'DISCOUNT_TYPE_PERCENT'
}

/** Data used to display promotional discounts to the client. */
export type PromotionDisplay = {
   __typename?: 'PromotionDisplay';
  /** Describes the discount percent to display to the client. */
  discountPercent?: Maybe<Scalars['Float']>;
  /** Describes the type of discount that will be applied to the client. */
  discountType: PromoDiscountType;
};

/** Moment Details specific to the PUBG game. */
export type PubgMomentDetails = {
   __typename?: 'PUBGMomentDetails';
  /** bucket is the player count bucket for aggregations. */
  bucket: Scalars['Int'];
  /** One of "game_start" or "player_count". */
  event: Scalars['String'];
  /** The game mode for the moment. */
  gameMode: Scalars['String'];
  /** The maximum player count in this period. */
  maxPlayerCount: Scalars['Int'];
  /** The minimum player count in this period. */
  minPlayerCount: Scalars['Int'];
};

/** PublishClipError is an error associated with the publishClip mutation. */
export type PublishClipError = {
   __typename?: 'PublishClipError';
  message?: Maybe<Scalars['String']>;
};

/** PublishClipInput edits the clip with the provided slug via segments. */
export type PublishClipInput = {
  /** The number of seconds into the clip's raw media the preview image is set to. */
  previewOffsetSeconds?: Maybe<Scalars['Float']>;
  /** The segments describing the desired changes to apply to the newly edited clip. */
  segments: Array<ClipSegmentInput>;
  /** The slug uniquely identifying the clip to edit. */
  slug: Scalars['ID'];
  /** The new title this clip will be updated to. */
  title?: Maybe<Scalars['String']>;
};

/** PublishClipPayload returns the edited clip or an error. */
export type PublishClipPayload = {
   __typename?: 'PublishClipPayload';
  /** The clip with its updated properties. */
  clip?: Maybe<Clip>;
  /** The error when the clip fails to publish. */
  error?: Maybe<PublishClipError>;
};

/** Parameters to get details about a purchasable offer for the current logged in user. */
export type PurchasableOfferParams = {
  /** List of gift recipient IDs if the offer is giftable. */
  giftRecipientIDs?: Maybe<Array<Scalars['ID']>>;
  /** The ID of the Offer. */
  offerID: Scalars['ID'];
  /** The ID of the Promotion attached to a Purchasable Offer (optional). */
  promotionID?: Maybe<Scalars['ID']>;
  /** The static and dynamic bindings of the attributes on an Offer. */
  tagBindings?: Maybe<Array<OfferTagBindingInput>>;
};

/** Category of product that can be purchased. */
export enum PurchaseableProductType {
  /** Subscription product. */
  Subscription = 'SUBSCRIPTION',
  /** Bits product. */
  Bits = 'BITS'
}

/** Set of purchase Ineligibility reasons. */
export enum PurchaseIneligibilityReason {
  /** User already has an active subscription to this product. */
  HasActiveSubscription = 'HAS_ACTIVE_SUBSCRIPTION',
  /** Not applicable as user is eligible to make a purchase. */
  NotApplicable = 'NOT_APPLICABLE'
}

/** The enumerated error reasons when purchasing an offer. */
export enum PurchaseOfferErrorCode {
  /** User is ineligible to purchase. */
  Ineligible = 'INELIGIBLE',
  /** An unexpected internal server error occurred. */
  InternalServerError = 'INTERNAL_SERVER_ERROR',
  /** User's payment method is invalid. */
  InvalidPaymentMethod = 'INVALID_PAYMENT_METHOD',
  /** Must have auth credentials to purchase an offer. */
  Unauthenticated = 'UNAUTHENTICATED'
}

/** PurchaseOfferInput contains the necessary fields to purchase an offer. */
export type PurchaseOfferInput = {
  /** Data to facilitate the Fraud analysis. */
  billingAuthInfo?: Maybe<BillingAuthInfo>;
  /** User IDs of the gift purchase recipients (if the Offer is a gift). */
  giftRecipientUserIDs?: Maybe<Array<Scalars['ID']>>;
  /** The ID of the Offer. */
  offerID: Scalars['ID'];
  /** Payments' session tracking. */
  paymentSession: PaymentSession;
  /** The ID of the user making the purchase. */
  purchasingUserID: Scalars['ID'];
  /** The number of units purchased. */
  quantity: Scalars['Int'];
  /** The static and dynamic bindings of the attributes on an Offer. */
  tagBindings: Array<OfferTagBindingInput>;
  /** Tenant-specific tracking params. */
  tenantTracking?: Maybe<Scalars['String']>;
};

/** PurchaseOfferPayload returns the order created for the purchase. */
export type PurchaseOfferPayload = {
   __typename?: 'PurchaseOfferPayload';
  /** Reason why a Purchase Order failed to be created if an error occurred. */
  error?: Maybe<PurchaseOfferErrorCode>;
  /** The Purchase Order created for this purchase attempt. */
  purchaseOrder?: Maybe<PurchaseOrder>;
};

/** PurchaseOrder is the record of a purchase made by a user. */
export type PurchaseOrder = {
   __typename?: 'PurchaseOrder';
  /** The action token ID used to facilitate the 3D Secure flow. */
  actionTokenID?: Maybe<Scalars['ID']>;
  /** The reason for a purchase order failure, if it failed. */
  failureReason?: Maybe<PurchaseOrderFailureReason>;
  /** The ID of the Purchase Order. */
  id: Scalars['ID'];
  /** The state of the Purchase Order. */
  state: PurchaseOrderState;
};

/** The enumerated failure reasons for a purchase order failure. */
export enum PurchaseOrderFailureReason {
  /** Bank declined the charge. */
  BankDeclined = 'BANK_DECLINED',
  /** Failed to entitle the benefit. User was refunded if a charge occurred. */
  EntitlementFailed = 'ENTITLEMENT_FAILED',
  /** User is ineligible to purchase. */
  Ineligible = 'INELIGIBLE',
  /** User's payment method is invalid. */
  InvalidPaymentMethod = 'INVALID_PAYMENT_METHOD',
  /** System error. */
  SystemError = 'SYSTEM_ERROR',
  /** Unknown failure reason. */
  Unknown = 'UNKNOWN'
}

/** PurchaseOrderState is the current state of the Purchase Order. */
export enum PurchaseOrderState {
  /** The Purchase Order is in an unknown state. */
  Unknown = 'UNKNOWN',
  /** The Purchase Order flow has been initiated and is at its starting state. */
  Initiated = 'INITIATED',
  /** The Purchase Order has a scheduled future-dated payment to complete the purchase. */
  PaymentPending = 'PAYMENT_PENDING',
  /** The Purchase Order has been paid and fulfillment has been kicked off. */
  FulfillmentInitiated = 'FULFILLMENT_INITIATED',
  /** The Purchase Order has been successfully fulfilled. */
  Success = 'SUCCESS',
  /** The Purchase Order failed and requires 3DS2 verification. */
  ThreeDSecureChallengeRequired = 'THREE_D_SECURE_CHALLENGE_REQUIRED',
  /** The Purchase Order failed. */
  Failed = 'FAILED',
  /** The Purchase Order's benefit cancellation has been kicked off. */
  CancelBenefitsInitiated = 'CANCEL_BENEFITS_INITIATED',
  /** The Purchase Order's benefits have been fully cancelled. */
  BenefitsCancelled = 'BENEFITS_CANCELLED',
  /** A refund has been kicked off for the Purchase Order. */
  RefundInitiated = 'REFUND_INITIATED',
  /** A refund has been successfully applied to the Purchase Order. */
  RefundApplied = 'REFUND_APPLIED',
  /** A refund has failed to the Purchase Order. */
  RefundFailed = 'REFUND_FAILED'
}

/** Purchase profile of a recurring or non-recurring subscription that a user bought. */
export type PurchaseProfile = {
   __typename?: 'PurchaseProfile';
  /** Cancels the entitled benefit and refunds if isRefundable is true. */
  cancelledAt?: Maybe<Scalars['Time']>;
  /** Date this purchase profile was created. */
  createdAt: Scalars['Time'];
  expiresAt?: Maybe<Scalars['Time']>;
  /** Usually the Twitch user's ID, but recorded by the payment provider. */
  extPurchaserID?: Maybe<Scalars['ID']>;
  /** The external subscription ID recorded by the payment provider. */
  extSubscriptionID?: Maybe<Scalars['ID']>;
  /** ID of the Purchase Profile in Payments team database. */
  id: Scalars['ID'];
  isExpired?: Maybe<Scalars['Boolean']>;
  /** Whether this purchase profile was gifted. */
  isGift?: Maybe<Scalars['Boolean']>;
  /** Whether this purchase profile is being paid for. */
  isPaying: Scalars['Boolean'];
  isRecurring: Scalars['Boolean'];
  isRefundable?: Maybe<Scalars['Boolean']>;
  paidAt?: Maybe<Scalars['Time']>;
  /** Product type of the purchase. */
  productType: SubscriptionProductType;
  purchasedAt?: Maybe<Scalars['Time']>;
  /** Twitch purchaser's email. */
  purchaserEmail: Scalars['String'];
  /** Twitch purchaser's user ID. */
  purchaserID: Scalars['ID'];
  /** Twitch purchaser's real name. */
  purchaserName?: Maybe<Scalars['String']>;
  /** Currency for the renewalPrice, e.g. "USD". */
  renewalCurrency?: Maybe<Scalars['String']>;
  /** Expected renewal price of the product in the smallest subunit of the currency, e.g. "499". */
  renewalPrice?: Maybe<Scalars['Int']>;
  /** Different from cancellation in that it stops renewal but let's user keep the benefit until it expires. */
  renewalStoppedAt?: Maybe<Scalars['Time']>;
  /** State of the purchase profile. i.e. cancelling the purchase profile can set state to 'cancelled'. */
  state: PurchaseProfileState;
  /** Subscription benefit associated with this purchase profile, if still active. */
  subscriptionBenefit?: Maybe<SubscriptionBenefit>;
  /** Date this purchase profile was last updated. */
  updatedAt?: Maybe<Scalars['Time']>;
  /** Whether this purchase profile will renew in the future and charge the user's payment method. */
  willRenew: Scalars['Boolean'];
};

export enum PurchaseProfileState {
  Active = 'ACTIVE',
  Cancelled = 'CANCELLED',
  Inactive = 'INACTIVE',
  Migrated = 'MIGRATED'
}

/** Root fields to access the Twitch API. */
export type Query = {
   __typename?: 'Query';
  /** Get the context that corresponds to an upcoming ad request made client side. */
  adContext?: Maybe<AdContext>;
  /** Get a single AdCreative. */
  adCreative?: Maybe<AdCreative>;
  /** Get all tags. */
  allTags?: Maybe<TagConnection>;
  /** Get AutoMod evaluation of text using AutoMod rule. */
  automodContent?: Maybe<AutomodContentResponse>;
  /** A list of global chat badges. */
  badges?: Maybe<Array<Maybe<Badge>>>;
  /** Gets a list of Bits offers for a logged out user, for use on the Bits landing page. */
  bitsOffers?: Maybe<Array<BitsOffer>>;
  /** Get a list of the most recent changelog items. */
  changelogEntries?: Maybe<Array<ChangelogEntry>>;
  /**
   * Get a channel by ID or name.
   * @deprecated Use the 'user' query instead.
   */
  channel?: Maybe<Channel>;
  /**
   * Get a list of channels, either by IDs or by their names.
   * @deprecated Use the 'users' query instead.
   */
  channels?: Maybe<Array<Maybe<Channel>>>;
  /** Get the ban status of a usser with respect to a channel's chat room. */
  chatRoomBanStatus?: Maybe<ChatRoomBanStatus>;
  /** GlobalCheerConfig contains information about (1) How to display Cheers and (2) What Cheermotes are globally available. */
  cheerConfig: GlobalCheerConfig;
  /** Get a clip by slug. */
  clip?: Maybe<Clip>;
  /** Get a single collection (playlist) item by its ID. */
  collection?: Maybe<Collection>;
  /** Gets competition by ID. */
  competition?: Maybe<Competition>;
  /** Gets a paginated list of competitions, commonly by its state. */
  competitions?: Maybe<CompetitionConnection>;
  /** Get a privacy consent status from a user, e.g. GDPR or CCPA. */
  consent?: Maybe<Consent>;
  /** Get a content tag by tag ID. */
  contentTag?: Maybe<Tag>;
  /** Get content tags by tag IDs. */
  contentTags?: Maybe<Array<Tag>>;
  /** Get a Creator Camp article. */
  creatorCampArticle?: Maybe<CreatorCampArticle>;
  /** Get a Creator Camp category. */
  creatorCampCategory?: Maybe<CreatorCampCategory>;
  /**
   * The currently authenticated user.
   * Returns null if the user is not authenticated.
   */
  currentUser?: Maybe<User>;
  /** Fetch a single directory by name and type. */
  directory?: Maybe<Directory>;
  /** Determine the currently logged in users eligibility for the specified drop. */
  dropEligibility?: Maybe<DropEligibility>;
  /** Get an emote by ID. */
  emote?: Maybe<Emote>;
  /** Get an emote set by ID. */
  emoteSet?: Maybe<EmoteSet>;
  /** Experiment properties for temporary use. */
  experiment?: Maybe<Experiment>;
  /**
   * Get an Extension by ID. Optionally, provide a specific version. If no version is provided,
   * the released version of that extension is returned.
   */
  extension?: Maybe<Extension>;
  /** Get an ExtensionCarousel by ID. The default carousel can be loaded by providing the ID: "default". */
  extensionCarousel?: Maybe<ExtensionCarousel>;
  /**
   * Fetch a paginated list of Extension Categories. Each Category will provide the first ten
   * extensions sorted by popularity in that category.
   */
  extensionCategories?: Maybe<ExtensionCategoryConnection>;
  /** Fetch a single category. Both slugs and ids are valid inputs for getting a category. */
  extensionCategory?: Maybe<ExtensionCategory>;
  /**
   * Fetch a single Extension Client by ID.
   * An ExtensionClient is the authorization component of an extension.
   * Returns Null if the current user doesn't have access to the extension.
   */
  extensionClient?: Maybe<ExtensionClient>;
  /** Fetch a paginated list of Extension Clients. */
  extensionClients?: Maybe<ExtensionClientConnection>;
  /** Fetch an ExtensionManifest by ID and version. */
  extensionManifest?: Maybe<ExtensionManifest>;
  /** Fetch a paginated list of ExtensionManifests. */
  extensionManifests?: Maybe<ExtensionManifestConnection>;
  /** Fetch a Summary of the state of an extension. The Cursor is used to page extension manifests. */
  extensionManifestsSummary?: Maybe<ExtensionManifestsSummary>;
  /**
   * extensionRatingsCSVReportPresignedURL asks the ExtensionRatings backend if the given report is completed, and if
   * so, to generate and return a presigned S3 URL that the devsite can use to allow the user to download it.
   * If the URL is not ready yet, the response will be an empty string.
   */
  extensionRatingsCSVReportPresignedURL?: Maybe<ExtensionRatingsCsvReportPresignedUrl>;
  /** Fetch an ExtensionVersionDiscoveryManifest by ID and version. */
  extensionVersionDiscoveryManifest?: Maybe<ExtensionVersionDiscoveryManifest>;
  /**
   * Search extensions by text found in the Extension name, description or summary. The results are
   * always returned in order of popularity. By default, all RELEASED and IN_TEST extensions are returned.
   * Pass RELEASED as the value of 'state' to only return extensions in the RELEASED state.
   */
  extensions?: Maybe<ExtensionConnection>;
  /**
   * Fetch the sections & content that should be featured on mobile
   * `language` is a letter code for the language the requesting user speaks (e.g. "en").
   */
  featuredContentSections?: Maybe<Array<FeaturedContentSection>>;
  /**
   * Fetch streams that are featured on the front page, ordered by featurePriority ascending.
   * DEPRECATED: `geolocation` is computed based on GeoIP with a fallback value of "US" and should be omitted
   * `language` is a letter code for the language the requesting user speaks (ex. "en")
   * By default returns 6 streams.
   */
  featuredStreams?: Maybe<Array<Maybe<FeaturedStream>>>;
  /**
   * Fetch VODs that should be featured on the homepage
   * `language` is a letter code for the language the requesting user speaks (e.g. "en").
   * @deprecated Subject to change
   */
  featuredVideos?: Maybe<Array<Maybe<FeaturedVideo>>>;
  /**
   * Get a Feed by ID.
   * @deprecated Field no longer supported
   */
  feed?: Maybe<Feed>;
  /**
   * Convert a URL to an object that can be embedded into Twitch feeds.
   * @deprecated Field no longer supported
   */
  feedEmbed?: Maybe<FeedEmbed>;
  /**
   * Get a feed item by ID.
   * @deprecated Field no longer supported
   */
  feedItemContent?: Maybe<FeedItemContent>;
  /** Get a single game as identified by its name or ID. At least one parameter must be provided. */
  game?: Maybe<Game>;
  /**
   * Fetch games based on a variety of sorting options.
   * By default returns 10 games, sorted by highest ccu.
   * DEPRECATED field arguments: locale, tags
   * Use GameOptions instead.
   */
  games?: Maybe<GameConnection>;
  /** Get whether a username is available for registration. */
  isUsernameAvailable?: Maybe<Scalars['Boolean']>;
  /** Get key code information given a key code. */
  key?: Maybe<Claimable>;
  /**
   * Returns a developer organization by ID.
   * User must be apart of the organization.
   */
  organization?: Maybe<Organization>;
  /** Gets a pending Twitch Developer Organization application of the currently authenticated user. */
  pendingOrganizationApplication?: Maybe<OrganizationApplication>;
  /** Returns a poll by its ID. */
  poll?: Maybe<Poll>;
  /**
   * Get Current PrimeOffers for a given region based on country code (request info or query param)
   * optional dateOverride to provide offers that would be displayed on that date
   * optional countryCode to provide offers that are displayed for that country
   * optional locale to provide offers displayed for the supplied locale.
   */
  primeOffers: Array<PrimeOffer>;
  /**
   * PrimePromotions data - query supports optional identifiers for promotion strings but default behavior will use
   * countryCode and userID to find available marketing promotions. For whitelisted QA users dateOverride can be provided.
   */
  primePromotions: Array<Maybe<PrimePromotion>>;
  /** PrimeVideoBenefit returns a user's prime video benefits from Amazon. Requires an LWA token. */
  primeVideoBenefit?: Maybe<PrimeVideoBenefit>;
  /**
   * Get details about a purchasable offer for the current logged in user.
   * This field can only be requested if an OAuth token is supplied with the request.
   * If the OAuth token is not supplied or if the offer does not exist, this will return null.
   */
  purchasableOffer?: Maybe<Offer>;
  /**
   * Fetch a group of recommended games.
   * `recRequestID` is a tracking id created by the caller. This should be unique per request.
   * `location` defines the source location of the recommended streams request (e.g. "TV_APPS").
   * `context` contains parameters that are used to personalize recommendations (e.g. "Platform").
   */
  recommendedGames?: Maybe<RecommendedGamesConnection>;
  /**
   * Fetch a group of recommended streams.
   * `recRequestID` is a tracking id created by the caller. This should be unique per request.
   * `location` defines the source location of the recommended streams request (e.g. "LEFT_NAV").
   * `context` contains parameters that are used to personalize recommendations (e.g. "Platform").
   */
  recommendedStreams?: Maybe<RecommendedStreamsConnection>;
  /** Holds configuration necessary for calling Recurly. */
  recurlyConfigs?: Maybe<RecurlyConfigs>;
  /** Get a message rejected by chat. */
  rejectedChatMessage?: Maybe<RejectedChatMessage>;
  /** Get a list of valid reasons for a content type. */
  reportReasons?: Maybe<Array<ReportReason>>;
  /** Metadata about the request to the API. */
  requestInfo: RequestInfo;
  /** Get a room by its ID. */
  room?: Maybe<Room>;
  /**
   * Get search results for a user's query.
   * @deprecated Use the 'searchFor' query instead.
   */
  search?: Maybe<SearchResult>;
  /** Search for tags to apply to a channel. */
  searchApplicableTags?: Maybe<Array<Tag>>;
  /** Search for category tags to filter categories in Browse. */
  searchCategoryTags?: Maybe<Array<Tag>>;
  /** Get gql search results for a user's query. */
  searchFor?: Maybe<SearchFor>;
  /** Search for tags to filter live channels in Browse. */
  searchLiveTags?: Maybe<Array<Tag>>;
  /** Get search suggestions for a user's query. */
  searchSuggestions?: Maybe<SearchSuggestionConnection>;
  /**
   * Fetch shelves to display on the homepage.
   * DEPRECATED field arguments: platform (use context.platform), langWeightedCCU.
   */
  shelves?: Maybe<ShelfConnection>;
  /** Get a squad stream by ID. */
  squadStream?: Maybe<SquadStream>;
  /**
   * Fetch live streams, ordered by the number of viewers descending.
   * languages can be empty or null, which will imply all the languages are included on the results.
   * tags are an array of tag ID as optional filters for streams.
   * DEPRECATED field arguments: platformType, languageTags, tags
   * Use StreamOptions instead.
   */
  streams?: Maybe<StreamConnection>;
  /**
   * Get a subscription product by its name. See product name examples below. The productName uniquely identifies a product.
   * 
   * e.g. "meclipse", "meclipse_2000", "meclipse_3000", these are respectively, the tier 1, 2, and 3 subscription product
   * names for the user with login "shroud".
   */
  subscriptionProduct?: Maybe<SubscriptionProduct>;
  /**
   * Get all available subscription token bundle offers available for the user.
   * @deprecated replaced with subscriptionTokenBundleProducts
   */
  subscriptionTokenBundleOffers?: Maybe<Array<Offer>>;
  /** Get all avaialble token bundle products available for the user. */
  subscriptionTokenBundleProducts?: Maybe<Array<SubscriptionTokenBundleProduct>>;
  /** Gets the Token Product Config. */
  subscriptionTokenProductConfig?: Maybe<SubscriptionTokenProductConfig>;
  /** Gets a team by its Twitch name. */
  team?: Maybe<Team>;
  /** Gets a list of sorted top tags aggregated from all tags applied to current live channels. */
  topTags?: Maybe<Array<Tag>>;
  /**
   * Get a user by their ID or login.
   * If no ID or login is provided, null is returned.
   * Lookup type can tell the resolver to include all users (inclusing deleted and
   * suspended accounts) on the lookup, defaults to only retrieve active users.
   */
  user?: Maybe<User>;
  /** Fetch the user by a specific attribute. */
  userByAttribute?: Maybe<User>;
  /** Get a list of users, either by their logins or by their IDs. */
  users?: Maybe<Array<Maybe<User>>>;
  /**
   * Get a verification request given an opaqueID.
   * These are generally email verification requests, but could be phone-numbers in the future.
   */
  verificationRequest?: Maybe<VerificationRequest>;
  /** Get content for a vertical directory by its ID. */
  verticalDirectory?: Maybe<VerticalDirectory>;
  /** Get content for a vertical subdirectory filtered by one or more context IDs (ex: category ID, tag ID). */
  verticalSubDirectory?: Maybe<VerticalSubDirectory>;
  /**
   * Get a video by its ID.
   * By default, Video queries only return public videos.
   * If the owner should also see their own private videos, set includePrivate flag in the `options` input.
   * This flag does not include other people's private videos.
   */
  video?: Maybe<Video>;
  /** A paginated list of comments against id, videoID, or channelID. */
  videoComments?: Maybe<VideoCommentConnection>;
  /**
   * Get the current or past video ingest metadata such as bitrates and codecs by its ID and channelID.
   * Optional customerID for staffs.
   */
  videoIngestSession?: Maybe<VideoIngestSession>;
  /**
   * Get the current or past video ingest metadata such as bitrates and codecs by
   * time range and channelID. Optional customerID for staffs.
   */
  videoIngestSessions?: Maybe<Array<VideoIngestSession>>;
  /** Get a list of videos in order of descending popularity. */
  videos?: Maybe<VideoConnection>;
  /** Get a list of Prime Video items for Watch Parties. */
  watchPartyItems?: Maybe<WatchPartyItemConnection>;
  /** Get a whisper thread by ID. */
  whisperThread?: Maybe<WhisperThread>;
};


/** Root fields to access the Twitch API. */
export type QueryAdContextArgs = {
  context: AdRequestContext;
};


/** Root fields to access the Twitch API. */
export type QueryAdCreativeArgs = {
  adSystem: Scalars['String'];
  creativeID: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryAllTagsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  tagScope?: Maybe<TagScope>;
};


/** Root fields to access the Twitch API. */
export type QueryAutomodContentArgs = {
  text: Scalars['String'];
  rule: Scalars['Int'];
};


/** Root fields to access the Twitch API. */
export type QueryChangelogEntriesArgs = {
  limit?: Maybe<Scalars['Int']>;
};


/** Root fields to access the Twitch API. */
export type QueryChannelArgs = {
  id?: Maybe<Scalars['ID']>;
  name?: Maybe<Scalars['String']>;
};


/** Root fields to access the Twitch API. */
export type QueryChannelsArgs = {
  ids?: Maybe<Array<Scalars['ID']>>;
  names?: Maybe<Array<Scalars['String']>>;
};


/** Root fields to access the Twitch API. */
export type QueryChatRoomBanStatusArgs = {
  channelID: Scalars['ID'];
  userID: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryClipArgs = {
  slug: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryCollectionArgs = {
  id: Scalars['ID'];
  options?: Maybe<CollectionOptions>;
};


/** Root fields to access the Twitch API. */
export type QueryCompetitionArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryCompetitionsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  state?: Maybe<CompetitionState>;
};


/** Root fields to access the Twitch API. */
export type QueryConsentArgs = {
  consentSessionID: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryContentTagArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryContentTagsArgs = {
  ids?: Maybe<Array<Scalars['ID']>>;
};


/** Root fields to access the Twitch API. */
export type QueryCreatorCampArticleArgs = {
  id: Scalars['ID'];
  category: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryCreatorCampCategoryArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryDirectoryArgs = {
  name: Scalars['String'];
  type: DirectoryType;
};


/** Root fields to access the Twitch API. */
export type QueryDropEligibilityArgs = {
  dropInstanceID: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryEmoteArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryEmoteSetArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryExtensionArgs = {
  id: Scalars['ID'];
  version?: Maybe<Scalars['String']>;
};


/** Root fields to access the Twitch API. */
export type QueryExtensionCarouselArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryExtensionCategoriesArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};


/** Root fields to access the Twitch API. */
export type QueryExtensionCategoryArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryExtensionClientArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryExtensionClientsArgs = {
  organizationID?: Maybe<Scalars['ID']>;
  after?: Maybe<Scalars['Cursor']>;
};


/** Root fields to access the Twitch API. */
export type QueryExtensionManifestArgs = {
  id: Scalars['ID'];
  version: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryExtensionManifestsArgs = {
  id: Scalars['ID'];
  after?: Maybe<Scalars['Cursor']>;
};


/** Root fields to access the Twitch API. */
export type QueryExtensionManifestsSummaryArgs = {
  id: Scalars['ID'];
  after?: Maybe<Scalars['Cursor']>;
};


/** Root fields to access the Twitch API. */
export type QueryExtensionRatingsCsvReportPresignedUrlArgs = {
  reportFilename: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryExtensionVersionDiscoveryManifestArgs = {
  id: Scalars['ID'];
  version: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryExtensionsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  search?: Maybe<Scalars['String']>;
  state?: Maybe<ExtensionStateFilter>;
};


/** Root fields to access the Twitch API. */
export type QueryFeaturedContentSectionsArgs = {
  language: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryFeaturedStreamsArgs = {
  first?: Maybe<Scalars['Int']>;
  geolocation?: Maybe<Scalars['String']>;
  language?: Maybe<Scalars['String']>;
  acceptedMature?: Maybe<Scalars['Boolean']>;
};


/** Root fields to access the Twitch API. */
export type QueryFeaturedVideosArgs = {
  first?: Maybe<Scalars['Int']>;
  language: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryFeedArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryFeedEmbedArgs = {
  url: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryFeedItemContentArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryGameArgs = {
  name?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['ID']>;
};


/** Root fields to access the Twitch API. */
export type QueryGamesArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  options?: Maybe<GameOptions>;
  locale?: Maybe<Scalars['String']>;
  tags?: Maybe<Array<Scalars['String']>>;
};


/** Root fields to access the Twitch API. */
export type QueryIsUsernameAvailableArgs = {
  username: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryKeyArgs = {
  code: Scalars['String'];
  countryOfResidence?: Maybe<Scalars['String']>;
};


/** Root fields to access the Twitch API. */
export type QueryOrganizationArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryPollArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryPrimeOffersArgs = {
  dateOverride?: Maybe<Scalars['Time']>;
  countryCode?: Maybe<Scalars['String']>;
  locale?: Maybe<Scalars['String']>;
};


/** Root fields to access the Twitch API. */
export type QueryPrimePromotionsArgs = {
  ids?: Maybe<Array<Scalars['ID']>>;
  dateOverride?: Maybe<Scalars['Time']>;
};


/** Root fields to access the Twitch API. */
export type QueryPrimeVideoBenefitArgs = {
  accessToken: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryPurchasableOfferArgs = {
  params: PurchasableOfferParams;
};


/** Root fields to access the Twitch API. */
export type QueryRecommendedGamesArgs = {
  first?: Maybe<Scalars['Int']>;
  recRequestID: Scalars['ID'];
  location: Scalars['String'];
  context: RecommendationsContext;
};


/** Root fields to access the Twitch API. */
export type QueryRecommendedStreamsArgs = {
  first?: Maybe<Scalars['Int']>;
  recRequestID: Scalars['ID'];
  location: Scalars['String'];
  context: RecommendationsContext;
};


/** Root fields to access the Twitch API. */
export type QueryRecurlyConfigsArgs = {
  paymentSession?: Maybe<PaymentSession>;
};


/** Root fields to access the Twitch API. */
export type QueryRejectedChatMessageArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryReportReasonsArgs = {
  content: ReportContentType;
};


/** Root fields to access the Twitch API. */
export type QueryRoomArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QuerySearchArgs = {
  userQuery: Scalars['String'];
  platform: Scalars['String'];
  options?: Maybe<SearchOptions>;
};


/** Root fields to access the Twitch API. */
export type QuerySearchApplicableTagsArgs = {
  userQuery: Scalars['String'];
  limit?: Maybe<Scalars['Int']>;
};


/** Root fields to access the Twitch API. */
export type QuerySearchCategoryTagsArgs = {
  userQuery: Scalars['String'];
  limit?: Maybe<Scalars['Int']>;
};


/** Root fields to access the Twitch API. */
export type QuerySearchForArgs = {
  userQuery: Scalars['String'];
  platform: Scalars['String'];
  options?: Maybe<SearchForOptions>;
  target?: Maybe<SearchForTarget>;
};


/** Root fields to access the Twitch API. */
export type QuerySearchLiveTagsArgs = {
  userQuery: Scalars['String'];
  categoryID?: Maybe<Scalars['ID']>;
  limit?: Maybe<Scalars['Int']>;
};


/** Root fields to access the Twitch API. */
export type QuerySearchSuggestionsArgs = {
  queryFragment: Scalars['String'];
  requestID?: Maybe<Scalars['ID']>;
};


/** Root fields to access the Twitch API. */
export type QueryShelvesArgs = {
  requestID: Scalars['String'];
  platform: Scalars['String'];
  langWeightedCCU?: Maybe<Scalars['Boolean']>;
  first?: Maybe<Scalars['Int']>;
  itemsPerRow?: Maybe<Scalars['Int']>;
  context?: Maybe<RecommendationsContext>;
};


/** Root fields to access the Twitch API. */
export type QuerySquadStreamArgs = {
  id: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryStreamsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  options?: Maybe<StreamOptions>;
  platformType?: Maybe<PlatformType>;
  languages?: Maybe<Array<Language>>;
  input?: Maybe<StreamMetadataFilterInput>;
  tags?: Maybe<Array<Scalars['String']>>;
};


/** Root fields to access the Twitch API. */
export type QuerySubscriptionProductArgs = {
  productName: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryTeamArgs = {
  name: Scalars['String'];
};


/** Root fields to access the Twitch API. */
export type QueryTopTagsArgs = {
  limit?: Maybe<Scalars['Int']>;
};


/** Root fields to access the Twitch API. */
export type QueryUserArgs = {
  id?: Maybe<Scalars['ID']>;
  login?: Maybe<Scalars['String']>;
  lookupType?: Maybe<UserLookupType>;
};


/** Root fields to access the Twitch API. */
export type QueryUserByAttributeArgs = {
  input: UserByAttribute;
};


/** Root fields to access the Twitch API. */
export type QueryUsersArgs = {
  ids?: Maybe<Array<Scalars['ID']>>;
  logins?: Maybe<Array<Scalars['String']>>;
};


/** Root fields to access the Twitch API. */
export type QueryVerificationRequestArgs = {
  opaqueID: Scalars['ID'];
};


/** Root fields to access the Twitch API. */
export type QueryVerticalDirectoryArgs = {
  id: Scalars['ID'];
  recommendationsContext: RecommendationsContext;
  contentMin: Scalars['Int'];
  contentMax: Scalars['Int'];
};


/** Root fields to access the Twitch API. */
export type QueryVerticalSubDirectoryArgs = {
  id: Scalars['ID'];
  contentContext?: Maybe<VerticalSubDirectoryContentContext>;
  recommendationsContext: RecommendationsContext;
  contentMin: Scalars['Int'];
  contentMax: Scalars['Int'];
};


/** Root fields to access the Twitch API. */
export type QueryVideoArgs = {
  id?: Maybe<Scalars['ID']>;
  options?: Maybe<VideoOptions>;
};


/** Root fields to access the Twitch API. */
export type QueryVideoCommentsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  last?: Maybe<Scalars['Int']>;
  Before?: Maybe<Scalars['Cursor']>;
  id?: Maybe<Scalars['String']>;
  videoID?: Maybe<Scalars['String']>;
  channelID?: Maybe<Scalars['String']>;
};


/** Root fields to access the Twitch API. */
export type QueryVideoIngestSessionArgs = {
  id: Scalars['ID'];
  channelID: Scalars['ID'];
  customerID?: Maybe<Scalars['ID']>;
};


/** Root fields to access the Twitch API. */
export type QueryVideoIngestSessionsArgs = {
  channelID: Scalars['ID'];
  customerID?: Maybe<Scalars['ID']>;
  startedAt: Scalars['Time'];
  endedAt: Scalars['Time'];
};


/** Root fields to access the Twitch API. */
export type QueryVideosArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  broadcastType?: Maybe<BroadcastType>;
  language?: Maybe<Language>;
};


/** Root fields to access the Twitch API. */
export type QueryWatchPartyItemsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  accessToken?: Maybe<Scalars['String']>;
  options?: Maybe<WatchPartyItemSearchOptions>;
};


/** Root fields to access the Twitch API. */
export type QueryWhisperThreadArgs = {
  id?: Maybe<Scalars['ID']>;
};

/** Represents a single quick action. */
export type QuickAction = {
   __typename?: 'QuickAction';
  /** Category name of QA for client side store sections. */
  category: QuickActionCategory;
  /** If the user currently has this QA enabled. */
  isEnabled: Scalars['Boolean'];
  /** The name of the item. Quick action IDs are represented by their canonical names. */
  name: QuickActionName;
  /** Scope can be "local" or "global". */
  scope: QuickActionScope;
};

/** Valid Categories of quick actions. */
export enum QuickActionCategory {
  /** Uncategorized quick action. */
  Uncategorized = 'UNCATEGORIZED',
  /** Stream management quick actions. */
  ManageYourStream = 'MANAGE_YOUR_STREAM',
  /** Monetization quick actions. */
  MonetizeYourStream = 'MONETIZE_YOUR_STREAM',
  /** Community growth quick actions. */
  GrowYourCommunity = 'GROW_YOUR_COMMUNITY',
  /** Chat management quick actions. */
  ManageYourChat = 'MANAGE_YOUR_CHAT',
  /** extensions quick actions. */
  Extensions = 'EXTENSIONS'
}

/** Represents a folder of quick actions. */
export type QuickActionFolder = {
   __typename?: 'QuickActionFolder';
  /** A list of quick action IDs in the folder. */
  items: Array<QuickActionLayoutItem>;
  /** The name of the folder. */
  name: Scalars['String'];
};

/** Contains the quick action layout. */
export type QuickActionLayout = {
   __typename?: 'QuickActionLayout';
  /** The ID of the layout. */
  id: Scalars['ID'];
  /** A list of items in the layout. */
  items: Array<QuickActionLayoutItem>;
};

/** Quick action items can be either a quick action or a folder of quick actions. */
export type QuickActionLayoutItem = QuickAction | QuickActionFolder;

/** Valid names of quick actions. */
export enum QuickActionName {
  /** Name of the edit stream info quick action. */
  EditStreamInfo = 'EDIT_STREAM_INFO',
  /** Name of the clip that quick action. */
  ClipThat = 'CLIP_THAT',
  /** Name of the raid channel quick action. */
  RaidChannel = 'RAID_CHANNEL',
  /** Name of the start squad stream quick action. */
  StartSquadStream = 'START_SQUAD_STREAM',
  /** Name of the run 30s ad quick action. */
  RunAd_30S = 'RUN_AD_30S',
  /** Name of the run 1m ad quick action. */
  RunAd_1M = 'RUN_AD_1M',
  /** Name of the run 2m ad quick action. */
  RunAd_2M = 'RUN_AD_2M',
  /** Name of the start bounty quick action. */
  StartBounty = 'START_BOUNTY',
  /** Name of the host channel quick action. */
  HostChannel = 'HOST_CHANNEL',
  /** Name of the gift subs quick action. This action doesn't specify an amount of subs to gift. */
  GiftSubs = 'GIFT_SUBS',
  /** Name of the gift 50 subs quick action. */
  Gift_50Subs = 'GIFT_50_SUBS',
  /** Name of the gift 100 subs quick action. */
  Gift_100Subs = 'GIFT_100_SUBS',
  /** Name of the add stream delay quick action. */
  AddStreamDelay = 'ADD_STREAM_DELAY',
  /** Name of the add stream marker quick action. */
  AddStreamMarker = 'ADD_STREAM_MARKER',
  /** Name of the schedule premiere quick action. */
  SchedulePremiere = 'SCHEDULE_PREMIERE',
  /** Name of the start rerun quick action. */
  StartRerun = 'START_RERUN',
  /** Name of the clear chat quick action. */
  ClearChat = 'CLEAR_CHAT',
  /** Name of the quick action to set emote only chat. */
  EmoteOnlyChat = 'EMOTE_ONLY_CHAT',
  /** Name of the quick action to set sub only chat. */
  SubOnlyChat = 'SUB_ONLY_CHAT',
  /** Name of the quick action to set follow only chat. */
  FollowOnlyChat = 'FOLLOW_ONLY_CHAT',
  /** Name of the start watch party quick action. */
  StartWatchParty = 'START_WATCH_PARTY'
}

/** Valid scopes of quick actions. */
export enum QuickActionScope {
  /** global refers to QAs available to all users. */
  Global = 'GLOBAL',
  /** local scope refers to QAs unique to the user, i.e. extension QAs. */
  Local = 'LOCAL'
}

/** Represents a list of quick actions for the store. */
export type QuickActionStore = {
   __typename?: 'QuickActionStore';
  /** A list of quick actions available for the user's store. */
  quickActions: Array<QuickAction>;
};

/**
 * A raid represents a broadcaster directing their viewers to another channel
 * in a synchronized "raid" on the channel after a countdown during which
 * each viewer has a chance to opt out of the raid.
 * 
 * Raids are created by a broadcaster from their dashbboard where they can search
 * and select the channel they wish to target. Once selected the raid takes counts
 * down to prepare after which the broadcaster can tell the raid to "Go", redirecting
 * all joined raiders to the target channel.
 */
export type Raid = {
   __typename?: 'Raid';
  /** Timestamp of raid announcement. */
  announceAt?: Maybe<Scalars['Time']>;
  /** Timestamp of raid go time. */
  goAt?: Maybe<Scalars['Time']>;
  /** The ID of the raid. */
  id: Scalars['ID'];
  /** Channel hosting the raid. */
  sourceChannel?: Maybe<User>;
  /** Target of the raid. */
  targetChannel?: Maybe<User>;
  /** Number of viewers in raid. */
  viewerCount?: Maybe<Scalars['Int']>;
};

/** A user's raid settings. */
export type RaidSettings = {
   __typename?: 'RaidSettings';
  /** Determines what other channels can raid this channel. */
  incomingRaidsPolicy: IncomingRaidsPolicy;
};

/** An integer range with a minimum and a maximum. */
export type Range = {
   __typename?: 'Range';
  /** The maximum value of the Range. */
  max: Scalars['Int'];
  /** The minimum value of the Range. */
  min: Scalars['Int'];
};

/** Possible errors returned by the RateExtension mutation. */
export enum RateExtensionError {
  /** Internal service error eg. database timeout. */
  InternalError = 'INTERNAL_ERROR'
}

/** RateExtensionInput submits a user's rating and feedback on a Twitch extension. */
export type RateExtensionInput = {
  /** The ID of the extension being rated. */
  extensionClientID: Scalars['ID'];
  /** The version of the extension being rated. */
  extensionVersion: Scalars['String'];
  /** Whether the user recommends the extension or not. */
  isRecommended: Scalars['Boolean'];
  /** Indicates from where the user submitted the rating. */
  location: ExtensionRatingLocation;
  /** The ID of the user performing the rating. */
  userID: Scalars['ID'];
};

/** The result of a rateExtension mutation. */
export type RateExtensionPayload = {
   __typename?: 'RateExtensionPayload';
  /** The error if the mutation fails to submit the extension rating. */
  error?: Maybe<RateExtensionError>;
  /** The resulting ExtensionRating record. */
  rating?: Maybe<ExtensionRating>;
};

export type ReactableContent = Clip | Post | Stream | Video;

export type Reaction = {
   __typename?: 'Reaction';
  /** count of users that reacted with a particular Emote. */
  count: Scalars['Int'];
  /** The Emote associated with the Reaction. */
  emote: Emote;
  /** The authenticated user's relationship with this reaction. */
  self: ReactionSelfConnection;
};

export type ReactionSelfConnection = {
   __typename?: 'ReactionSelfConnection';
  /** Did the authenticated user react. */
  hasReacted: Scalars['Boolean'];
};

export type ReadNotificationsInput = {
  /** IDs of the notifications to set as read. The minimum number is 1 and the maximum is 100. */
  ids: Array<Scalars['ID']>;
};

export type ReadNotificationsPayload = {
   __typename?: 'ReadNotificationsPayload';
  /** The amount of notifications that were set to read. */
  count: Scalars['Int'];
  /** The notifications that were set to read. Only ID and isRead are accessible. */
  notifications: Array<Maybe<OnsiteNotification>>;
};

/** Feedback from a user about a piece of content. */
export type RecommendationFeedback = {
   __typename?: 'RecommendationFeedback';
  /** Reason for feedback. */
  category: RecommendationFeedbackCategory;
  /** Feedback target. */
  content?: Maybe<RecommendationFeedbackContent>;
  /** Recommendation Feedback ID. Generated from the type, category, content id, and user id. */
  id: Scalars['ID'];
  /** Last time this feedback was given. */
  lastUpdated: Scalars['Time'];
  /** Feedback target type. */
  type: RecommendationFeedbackType;
  /** Feedback giver. */
  user?: Maybe<User>;
};

/** Reason for feedback. */
export enum RecommendationFeedbackCategory {
  /** Only returned when there is an issue. Shouldn't be returned, should not be used for fetching. */
  Unspecified = 'UNSPECIFIED',
  /** The user is not interested in this type of content. */
  NotInterested = 'NOT_INTERESTED',
  /** The user finds this type of content to be offensive. */
  Offensive = 'OFFENSIVE',
  /** The user has already seen this content. */
  AlreadyWatched = 'ALREADY_WATCHED',
  /** Used when the other reasons do not capture the reason a user is giving feedback. */
  Other = 'OTHER'
}

/** Connection between a user and recommendation feedback. */
export type RecommendationFeedbackConnection = {
   __typename?: 'RecommendationFeedbackConnection';
  /** Contains the edges for the recommendation feedback. */
  edges?: Maybe<Array<RecommendationFeedbackEdge>>;
  /** Contains pagination metadata. */
  pageInfo: PageInfo;
};

/** Feedback target. */
export type RecommendationFeedbackContent = Channel | Game | Video;

/** Edge containing the node and cursor for recommendation feedback items. */
export type RecommendationFeedbackEdge = {
   __typename?: 'RecommendationFeedbackEdge';
  /** Cursor for the feedback edge. */
  cursor: Scalars['Cursor'];
  /** Node for the feedback edge. */
  node?: Maybe<RecommendationFeedback>;
};

/** Feedback target type. */
export enum RecommendationFeedbackType {
  /** Only returned when there is an issue. Shouldn't be returned, should not be used for fetching. */
  Unspecified = 'UNSPECIFIED',
  /** Feedback given about channels. */
  Channel = 'CHANNEL',
  /** Feedback given about a game / category. */
  Category = 'CATEGORY',
  /** Feedback given about a shelf. */
  Shelf = 'SHELF',
  /** Feedback given about a video. */
  Vod = 'VOD'
}

export type Recommendations = {
   __typename?: 'Recommendations';
  /**
   * The recommended community gifting quantities to display to the user when they intend to gift subscriptions.
   * The trackingID is not a unique ID for the recommendations, but a passthrough
   * value for backend logging to link to purchases made by the user after being
   * shown these recommendations.
   */
  communityGiftQuantities?: Maybe<Array<Scalars['Int']>>;
  /** A list of recommended friends. */
  friends?: Maybe<Array<Maybe<RecommendedFriend>>>;
  /**
   * Live recommendations.
   * recRequestID is a tracking id created by the caller. Should be unique per request.
   */
  liveRecommendations?: Maybe<LiveRecommendationConnection>;
  /**
   * Stream recommendations.
   * @deprecated use a specific recommendation instead
   */
  streams?: Maybe<RecommendedStreamConnection>;
  /** A list of recommended VODs. */
  videos?: Maybe<RecommendedVideoConnection>;
};


export type RecommendationsCommunityGiftQuantitiesArgs = {
  trackingID: Scalars['ID'];
};


export type RecommendationsLiveRecommendationsArgs = {
  first?: Maybe<Scalars['Int']>;
  recRequestID: Scalars['String'];
  language: Scalars['String'];
  location?: Maybe<Scalars['String']>;
  context?: Maybe<RecommendationsContext>;
};


export type RecommendationsStreamsArgs = {
  first?: Maybe<Scalars['Int']>;
};


export type RecommendationsVideosArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};

/** RecommendationsContext define parameters which can control recommendations logic. */
export type RecommendationsContext = {
  /** Optional ISO country code, defaults to use the country code from the geoip of the request. */
  country?: Maybe<Scalars['String']>;
  /** Web, ios, android, etc. */
  platform?: Maybe<Scalars['String']>;
};

export type RecommendedFriend = {
   __typename?: 'RecommendedFriend';
  /** Reason why this recommendation was made. */
  reason?: Maybe<Scalars['String']>;
  /** The user recommended to be a friend of the source user. */
  user?: Maybe<User>;
};

/** The response of a recommended games request which contains a list of recommended games. */
export type RecommendedGamesConnection = {
   __typename?: 'RecommendedGamesConnection';
  /** A list of recommended games. */
  edges?: Maybe<Array<RecommendedGamesEdge>>;
  /** Per-generation tracking id for identifying a recommendation model. */
  generationID: Scalars['ID'];
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  pageInfo: PageInfo;
  /** Unique tracking id per response. */
  responseID: Scalars['ID'];
};

/** The content to render from a recommended game. */
export type RecommendedGamesEdge = {
   __typename?: 'RecommendedGamesEdge';
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  cursor: Scalars['Cursor'];
  /** The underlying game content to render. */
  node?: Maybe<Game>;
  /** Globally unique id per category used in client tracking. */
  trackingID: Scalars['ID'];
};

export type RecommendedStream = {
  /** The recommended stream. */
  stream?: Maybe<Stream>;
  /** The type of recommendation. Different types contain different metadata about why the recommendation was made. */
  type?: Maybe<StreamRecommendationType>;
};

export type RecommendedStreamConnection = {
   __typename?: 'RecommendedStreamConnection';
  nodes?: Maybe<Array<Maybe<RecommendedStream>>>;
};

/** The response of a recommended streams request which contains a list of recommended streams. */
export type RecommendedStreamsConnection = {
   __typename?: 'RecommendedStreamsConnection';
  /** A list of recommended streams. */
  edges?: Maybe<Array<RecommendedStreamsEdge>>;
  /** Per-generation tracking id for identifying a recommendation model. */
  generationID: Scalars['ID'];
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  pageInfo: PageInfo;
  /** Unique tracking id per response. */
  responseID: Scalars['ID'];
};

/** The content to render from a recommended stream. */
export type RecommendedStreamsEdge = {
   __typename?: 'RecommendedStreamsEdge';
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  cursor: Scalars['Cursor'];
  /** The underlying stream content to render. */
  node?: Maybe<Stream>;
  /** Globally unique id per stream used in client tracking. */
  trackingID: Scalars['ID'];
};

export type RecommendedVideoConnection = {
   __typename?: 'RecommendedVideoConnection';
  edges?: Maybe<Array<Maybe<RecommendedVideoEdge>>>;
  pageInfo?: Maybe<PageInfo>;
  /** A unique ID for this generated list of recommendations. */
  setID?: Maybe<Scalars['String']>;
};

export type RecommendedVideoEdge = {
   __typename?: 'RecommendedVideoEdge';
  cursor?: Maybe<Scalars['Cursor']>;
  node?: Maybe<Video>;
};

/** Record ad event error. */
export type RecordAdEventError = {
   __typename?: 'RecordAdEventError';
  /** Error from recording ad event. */
  code: RecordAdEventErrorCode;
};

/** Enumeration of RecordAdEvent error status codes. */
export enum RecordAdEventErrorCode {
  /** The RAd token in the request was not valid. */
  InvalidToken = 'INVALID_TOKEN',
  /** The event payload was invalid. */
  InvalidJson = 'INVALID_JSON',
  /** An internal error has occurred, other than a 500. */
  UnknownError = 'UNKNOWN_ERROR'
}

/** The input for recording an ad event. */
export type RecordAdEventInput = {
  /** The ad event name. */
  eventName: Scalars['String'];
  /** Ad details JSON encoded as a string. */
  eventPayload: Scalars['String'];
  /** The RAd service token used for validation. */
  radToken: Scalars['String'];
};

/** The payload returned after recording an ad event. */
export type RecordAdEventPayload = {
   __typename?: 'RecordAdEventPayload';
  /** Error from mutation, if one exists. */
  error?: Maybe<RecordAdEventError>;
};

/**
 * This mutation handles incoming referrals that are part of a Mission (similar to a quest or goal).
 * A user can generate a referral link to share with their friends.
 * This records a referral, which comes from a referral URL for a given channel.
 */
export type RecordMissionReferralExperimentInput = {
  /** The channel that the referral link references. */
  channelID: Scalars['ID'];
  /** The referral link code, corresponds to a user (recruiter). */
  referralCode: Scalars['String'];
};

/** The result of an RecordMissionReferral mutation. */
export type RecordMissionReferralExperimentPayload = {
   __typename?: 'RecordMissionReferralExperimentPayload';
  /** The user who followed the referral link. */
  user?: Maybe<User>;
};

export type RecurlyConfigs = {
   __typename?: 'RecurlyConfigs';
  /** For interacting with the Braintree gateway and Paypal (supported by Recurly). */
  braintreeClientAuthorization: Scalars['String'];
  /** For interacting with Pay With Amazon gateway (supported by Recurly). */
  payWithAmazonConfigs: PayWithAmazonConfigs;
  /** Sent to Recurly to identify requests. */
  publicKey: Scalars['String'];
};

/**
 * Payment Method information for a recurring payment.
 * An abstraction for a set of Payments models, existing here to surface to the Payments Management Page.
 */
export type RecurringPaymentDetail = {
   __typename?: 'RecurringPaymentDetail';
  /** Time that the payment will attempt to renew. */
  expiresAt?: Maybe<Scalars['Time']>;
  /** Product type of the purchase. */
  productType: SubscriptionProductType;
  /** Currency for the renewalPrice, e.g. "USD". */
  renewalCurrency?: Maybe<Scalars['String']>;
  /** Expected renewal price of the product in the smallest subunit of the currency, e.g. "499". */
  renewalPrice?: Maybe<Scalars['Int']>;
  /** Divisor for renewalPrice for display: e.g. "100" for USD. */
  renewalPriceDivisor?: Maybe<Scalars['Int']>;
  /** Subscription benefit, if still active. */
  subscriptionBenefit?: Maybe<SubscriptionBenefit>;
  /** Twitch user ID, owner of the entitlement benefit. */
  ticketOwnerID?: Maybe<Scalars['ID']>;
  /**
   * Twitch user ID, owner of the channel that was subscribed to.
   * Can be null if product type is Turbo.
   */
  ticketProductOwnerID?: Maybe<Scalars['ID']>;
  /** Whether this subscription will renew in the future and charge the user's payment method. */
  willRenew: Scalars['Boolean'];
};

/** Redeem claimable error. */
export type RedeemClaimableError = {
   __typename?: 'RedeemClaimableError';
  /** Error code while redeeming. */
  code: RedeemClaimableErrorCode;
};

/** Redeem claimable error status codes. */
export enum RedeemClaimableErrorCode {
  /** The request has been throttled. */
  RequestThrottled = 'REQUEST_THROTTLED',
  /** The user is not allowed to redeem this key. */
  Unauthorized = 'UNAUTHORIZED',
  /** The key has already been claimed. */
  AlreadyClaimed = 'ALREADY_CLAIMED',
  /** Unknown error being returned from service. */
  Unknown = 'UNKNOWN',
  /**
   * Invalid PIN/Claimable.
   * Currently only used for Gift Card PINs.
   */
  InvalidPin = 'INVALID_PIN',
  /**
   * PIN already redeemed.
   * Currently only used for Gift Card PINs.
   */
  AlreadyRedeemed = 'ALREADY_REDEEMED',
  /**
   * User can't redeem due to wallet balance limit
   * Currently only used for Gift Card PINs.
   */
  ExceededWalletBalance = 'EXCEEDED_WALLET_BALANCE',
  /**
   * Two Factor Auth is required past a certain balance
   * for fraud mitigation. Currently only used for Gift Card PINs.
   */
  TwoFactorRequired = 'TWO_FACTOR_REQUIRED',
  /**
   * Unsupported Country of Residence
   * Currently only used for Gift Card PINs.
   */
  InvalidCountryOfResidence = 'INVALID_COUNTRY_OF_RESIDENCE'
}

/** The input for claiming a key code. */
export type RedeemClaimableInput = {
  /**
   * Optional param for user's self-declared country of residence.
   * Currently only used for Gift Card Redemptions.
   */
  countryOfResidence?: Maybe<Scalars['String']>;
  /** The key code that needs to be claimed. */
  keyCode: Scalars['String'];
};

/** The payload returned after claiming a key code. */
export type RedeemClaimablePayload = {
   __typename?: 'RedeemClaimablePayload';
  /** Possible errors returned from the service for this mutation. */
  error?: Maybe<RedeemClaimableError>;
  /** The updated key information. */
  key?: Maybe<Claimable>;
};

/** An error from redeeming a custom Community Points reward in a channel. */
export type RedeemCommunityPointsCustomRewardError = {
   __typename?: 'RedeemCommunityPointsCustomRewardError';
  /** An identifier for the error that occurred. */
  code?: Maybe<RedeemCommunityPointsCustomRewardErrorCode>;
};

/** The possible reasons redeeming a custom Community Points reward in a channel could fail. */
export enum RedeemCommunityPointsCustomRewardErrorCode {
  /** The reward was not found. */
  NotFound = 'NOT_FOUND',
  /** The current user is not allowed to redeem this reward in this channel. */
  Forbidden = 'FORBIDDEN',
  /** The user does not have sufficient points to redeem the reward. */
  NotEnoughPoints = 'NOT_ENOUGH_POINTS',
  /** The client-provided properties (title, cost, or prompt) did not match the reward's true properties. */
  PropertiesMismatch = 'PROPERTIES_MISMATCH',
  /** The client is retrying a redemption with a transaction id that has already been redeemed. */
  DuplicateTransaction = 'DUPLICATE_TRANSACTION',
  /** The client is retrying a redemption with a transaction id that is currently being redeemed in another request. */
  TransactionInProgress = 'TRANSACTION_IN_PROGRESS',
  /** The reward is disabled. */
  Disabled = 'DISABLED',
  /** The stream is not live. */
  StreamNotLive = 'STREAM_NOT_LIVE',
  /** The reward has hit its maximum number of redemptions per stream. */
  MaxPerStream = 'MAX_PER_STREAM',
  /** The user is banned and cannot redeem rewards. */
  UserBanned = 'USER_BANNED',
  /** The redemption message contained a blocked phrase. */
  ChannelSettings = 'CHANNEL_SETTINGS',
  /** The redemption message starts with a '/' like a chat command. */
  MessageIsCommand = 'MESSAGE_IS_COMMAND',
  /** An unknown error occurred. */
  Unknown = 'UNKNOWN'
}

/** Input for redeeming a custom Community Points reward in a channel. */
export type RedeemCommunityPointsCustomRewardInput = {
  /** The channel ID that the reward is being redeemed in. */
  channelID: Scalars['ID'];
  /**
   * The cost that the client expects this reward to cost.
   * If this cost is different from the reward's true cost, the request will fail.
   */
  cost: Scalars['Int'];
  /**
   * The prompt that the client expects this reward to have.
   * If this prompt is different from the reward's true prompt, the request will fail.
   * Should be null if the reward does not have a prompt.
   */
  prompt?: Maybe<Scalars['String']>;
  /** The unique reward ID. */
  rewardID: Scalars['ID'];
  /**
   * For rewards that require text input, this is the user-supplied text.
   * Discarded if the reward does not require text input.
   */
  textInput?: Maybe<Scalars['String']>;
  /**
   * The title that the client expects this reward to have.
   * If this title is different from the reward's true title, the request will fail.
   */
  title: Scalars['String'];
  /** Client-set identifier for the transaction. This ID should be universally unique. */
  transactionID: Scalars['ID'];
};

/** The response from redeeming a custom Community Points reward in a channel. */
export type RedeemCommunityPointsCustomRewardPayload = {
   __typename?: 'RedeemCommunityPointsCustomRewardPayload';
  /** An error that occurred while redeeming a custom Community Points reward in a channel. */
  error?: Maybe<RedeemCommunityPointsCustomRewardError>;
  /** The newly created redemption. */
  redemption?: Maybe<CommunityPointsCustomRewardRedemption>;
};

export type RedeemRitualTokenError = {
   __typename?: 'RedeemRitualTokenError';
  code: RedeemRitualTokenErrorCode;
};

export enum RedeemRitualTokenErrorCode {
  /** Token is not in a status that can be redeemed. */
  TokenNotAvailable = 'TOKEN_NOT_AVAILABLE',
  /** Token does not exist. */
  TokenNotFound = 'TOKEN_NOT_FOUND',
  /** User is not a follower and tried redeeming the token in a follower-only chat. */
  FollowerOnlyModeEnforcementFailed = 'FOLLOWER_ONLY_MODE_ENFORCEMENT_FAILED',
  /** User is not a subscriber and tried redeeming the token in a subs-only chat. */
  SubOnlyModeEnforcementFailed = 'SUB_ONLY_MODE_ENFORCEMENT_FAILED',
  /** User is banned in the channel. */
  UserChatBanned = 'USER_CHAT_BANNED',
  /** User is timed out in the channel. */
  UserChatTimedOut = 'USER_CHAT_TIMED_OUT'
}

/** RedeemRitualTokenInput is the input when redeeming a ritual token. */
export type RedeemRitualTokenInput = {
  /** The channel to redeem the token in. */
  channelID: Scalars['ID'];
  /** User-specified text to send with the token redemption. */
  messageText?: Maybe<Scalars['String']>;
  /** The type of ritual to be redeemed. */
  type: RitualTokenType;
};

/** RedeemRitualTokenPayload is the response when redeeming a ritual token. */
export type RedeemRitualTokenPayload = {
   __typename?: 'RedeemRitualTokenPayload';
  error?: Maybe<RedeemRitualTokenError>;
  token?: Maybe<RitualToken>;
};

/** RedeemSubscriptionInput creates a new subscription redemption input. */
export type RedeemSubscriptionInput = {
  /** The channelID to which the user is currently subscribed to and is allowing to redeem a subscription. */
  fromChannelID: Scalars['ID'];
  /** The channelID to which the user wants to redeem their subscription to. */
  targetChannelID: Scalars['ID'];
  /** The User who is trying to redeem the subscription. */
  userID: Scalars['ID'];
};

/** RedeemSubscriptionPayload returns a status code indicating whether the update was successful or not. */
export type RedeemSubscriptionPayload = {
   __typename?: 'RedeemSubscriptionPayload';
  /** A code indicating why the redemption of subscription failed, if it did. */
  errorCode?: Maybe<RedeemSubscriptionResponseErrorCode>;
  /** The Subscription Product that the user has been entitled to. */
  product?: Maybe<SubscriptionProduct>;
};

/** An Error indicating why the submit failed, if it did. */
export enum RedeemSubscriptionResponseErrorCode {
  /** The Channel ID is invalid. */
  InvalidChannel = 'INVALID_CHANNEL',
  /** The User is not Eligible to Redeem Subscription to this Channel. */
  NotEligible = 'NOT_ELIGIBLE',
  /** Something unexpected occured when Redeeming the Subscription. */
  Unknown = 'UNKNOWN',
  /** The User has already redeemed the subscription offerd by the channel. */
  UserHasRedeemedSubscription = 'USER_HAS_REDEEMED_SUBSCRIPTION',
  /** The channel the user is trying to redeem from has not been off-boarded. */
  ChannelNotOffBoarded = 'CHANNEL_NOT_OFF_BOARDED',
  /** The user already has an existing subscription to the target channel they are trying to redeem to. */
  UserHasExistingSubscription = 'USER_HAS_EXISTING_SUBSCRIPTION',
  /** The target Channel the user is trying to redeem to is Invalid. */
  RedeemChannelInvalid = 'REDEEM_CHANNEL_INVALID',
  /** The user is not subscribed to the channel that is being off-boarded. */
  UserNotSubscribedToOffBoardedChannel = 'USER_NOT_SUBSCRIBED_TO_OFF_BOARDED_CHANNEL'
}

export type RedeemTrueXAdInput = {
  /** args are parameters describing the engagement the user just completed for bits. */
  args: Scalars['String'];
  /** signature is a digital signature protecting the integrity of `args`. */
  signature: Scalars['String'];
  /** targetID is the `User.id` of the channel where the user is watching the ad. */
  targetID?: Maybe<Scalars['ID']>;
  /**
   * trueXAd is descriptive information about the engagement that was just shown.
   * This information is useful for logging errors on the server-side.
   */
  trueXAd?: Maybe<TrueXAd>;
};

export type RedeemTrueXAdPayload = {
   __typename?: 'RedeemTrueXAdPayload';
  /**
   * currentUser is the authenticated user object which includes the updated
   * `Wallet` info after the message bits have been spent.
   */
  currentUser?: Maybe<User>;
  /** grantedBits is the number of bits the user earned from this engagement. */
  grantedBits: Scalars['Int'];
};

/** How to group the referral sources. */
export enum ReferralsDimension {
  /** Return referrals grouped by platforms. */
  Platform = 'PLATFORM',
  /** Return referrals grouped by country. */
  Country = 'COUNTRY',
  /** Return referrals grouped by channel. */
  Channel = 'CHANNEL',
  /** Return referrals grouped by internal source. */
  Internal = 'INTERNAL',
  /** Return referrals grouped by external source. */
  External = 'EXTERNAL'
}

/** Which subset of referrals to return. */
export enum ReferralsFilter {
  /** Return all referral sources. */
  All = 'ALL',
  /** Return live video play referrals from external sources, filtered by the web platform. */
  ExternalLiveWeb = 'EXTERNAL_LIVE_WEB',
  /** Return live video play referrals from internal channels, filtered by the web platform. */
  InternalChannelLiveWeb = 'INTERNAL_CHANNEL_LIVE_WEB',
  /** Return live video play referrals from internal sources, filtered by the web platform. */
  InternalLiveWeb = 'INTERNAL_LIVE_WEB'
}

/** RegenerateStreamKeyInput is input required to regenerate a broadcaster's stream key. */
export type RegenerateStreamKeyInput = {
  /** channelID of the broadcaster. */
  channelID: Scalars['ID'];
};

/** RegenerateStreamKeyPayload contains the VideoStreamSettings with updated stream key. */
export type RegenerateStreamKeyPayload = {
   __typename?: 'RegenerateStreamKeyPayload';
  /** The updated video stream for channel. */
  channel?: Maybe<Channel>;
};

/** RegenerateVerificationCodeInput is input required to regenerate a user's verification code in EVS. */
export type RegenerateVerificationCodeInput = {
  /** Address that the user is verifying. This will most likely be an email address or phone number. */
  address: Scalars['String'];
  /** Key for the entity associated with the address. This is generally the Twitch ID of the user. */
  key: Scalars['String'];
};

/** RegenerateVerificationCodePayload is the VerificationRequest document returned from EVS on success. */
export type RegenerateVerificationCodePayload = {
   __typename?: 'RegenerateVerificationCodePayload';
  /** The updated verification request. */
  request?: Maybe<VerificationRequest>;
};

/**
 * RegisterPayoutInformationError describes the error that occured when registering
 * a user's payout information during payout onboarding.
 */
export type RegisterPayoutInformationError = {
   __typename?: 'RegisterPayoutInformationError';
  /** Code to describe error that occurred while registering payout information. */
  code: RegisterPayoutInformationErrorCode;
  /** Lists any field names that have an invalid format. */
  invalidFields?: Maybe<Array<RegisterPayoutInformationFieldName>>;
};

/** Enumerates possible errors when registering payout information. */
export enum RegisterPayoutInformationErrorCode {
  /** Must have auth credentials to register payout information. */
  Unauthenticated = 'UNAUTHENTICATED',
  /** User does not have permission to register payout information for the targeted user. */
  Forbidden = 'FORBIDDEN',
  /** One or more fields have an invalid format. */
  InvalidFormat = 'INVALID_FORMAT',
  /** An internal error has occurred. */
  InternalError = 'INTERNAL_ERROR'
}

/** Enumerates vaid field names when registering payout information. */
export enum RegisterPayoutInformationFieldName {
  /** Assigned if Birthdate is given in invalid format. */
  Birthdate = 'BIRTHDATE',
  /** Assigned if City is given in invalid format. */
  City = 'CITY',
  /** Assigned if Company Name is given in invalid format. */
  CompanyName = 'COMPANY_NAME',
  /** Assigned if Country Code is given in invalid format. */
  CountryCode = 'COUNTRY_CODE',
  /** Assigned if Email is given in invalid format. */
  Email = 'EMAIL',
  /** Assigned if First Name is given in invalid format. */
  FirstName = 'FIRST_NAME',
  /** Assigned if Last Name is given in invalid format. */
  LastName = 'LAST_NAME',
  /** Assigned if Middle Name is given in invalid format. */
  MiddleName = 'MIDDLE_NAME',
  /** Assigned if Postal is given in invalid format. */
  Postal = 'POSTAL',
  /** Assigned if State Code is given in invalid format. */
  StateCode = 'STATE_CODE',
  /** Assigned if Primary Address is given in invalid format. */
  StreetAddress = 'STREET_ADDRESS',
  /** Assigned if Secondary Address is given in invalid format. */
  StreetAddress_2 = 'STREET_ADDRESS_2',
  /** Assigned if Parent Name is given in invalid format. */
  ParentName = 'PARENT_NAME',
  /** Assigned if Parent Email is given in invalid format. */
  ParentEmail = 'PARENT_EMAIL'
}

/** RegisterPayoutInformationInput is the input required to register a user's payout information during payout onboarding. */
export type RegisterPayoutInformationInput = {
  /** Birthdate submitted by the user while registering into a payout program. */
  birthdate: Scalars['Time'];
  /** City submitted by the user while registering into a payout program. */
  city: Scalars['String'];
  /** Company Name submitted by the user while registering into a payout program. */
  companyName?: Maybe<Scalars['String']>;
  /** Country Code (ISO-3166) submitted by the user while registering into a payout program. */
  countryCode: Scalars['String'];
  /** Email submitted by the user while registering into a payout program. */
  email: Scalars['String'];
  /** First Name submitted by the user while registering into a payout program. */
  firstName: Scalars['String'];
  /** Last Name submitted by the user while registering into a payout program. */
  lastName: Scalars['String'];
  /** Middle Name submitted by the user while registering into a payout program. */
  middleName?: Maybe<Scalars['String']>;
  /** Parent Email submitted by the under age user while registering into a payout program. */
  parentEmail?: Maybe<Scalars['String']>;
  /** Parent Name submitted by the under age user while registering into a payout program. */
  parentName?: Maybe<Scalars['String']>;
  /** Postal submitted by the user while registering into a payout program. */
  postal?: Maybe<Scalars['String']>;
  /** State Code submitted by the user while registering into a payout program. */
  stateCode?: Maybe<Scalars['String']>;
  /** Primary Address submitted by the user while registering into a payout program. */
  streetAddress: Scalars['String'];
  /** Secondary Address submitted by the user while registering into a payout program. */
  streetAddress2?: Maybe<Scalars['String']>;
  /** TargetUserID is the ID of the user whose payout information will be registered. */
  targetUserID: Scalars['ID'];
};

/** RegisterPayoutInformationPayload is the updated workflow after registration is accepted. */
export type RegisterPayoutInformationPayload = {
   __typename?: 'RegisterPayoutInformationPayload';
  /** Describes error that occured when registering payout information. */
  error?: Maybe<RegisterPayoutInformationError>;
  /** New workflow state. */
  workflow?: Maybe<PayoutOnboardingWorkflow>;
};

/** The registration type signifies the policy for participants to join the competition. */
export enum RegistrationType {
  /** Open competition that anyone can join. */
  Open = 'OPEN',
  /** Invite-only competition where only invited participants can join. */
  Invitational = 'INVITATIONAL',
  /** Unknown type. */
  Unknown = 'UNKNOWN'
}

export type RejectedChatMessage = {
   __typename?: 'RejectedChatMessage';
  /** Original message's raw body. */
  body?: Maybe<Scalars['String']>;
  /** Optional list of fragments from the messages's body that lead to the message rejection. */
  failedFragments?: Maybe<Array<Maybe<Scalars['String']>>>;
  /** The ID of the message. */
  id?: Maybe<Scalars['ID']>;
  /** Specifies if a action by a moderator has been taken on the message. */
  isResolved?: Maybe<Scalars['Boolean']>;
  /** The extracted caught message. */
  message?: Maybe<Message>;
  /** The user that created the message. */
  sender?: Maybe<User>;
  /** The channel where the message was originally sent. */
  target?: Maybe<User>;
};

export type RejectFriendRequestInput = {
  /** The authenticated user will reject the friend request sent by the user with an ID equal to targetID. */
  targetID: Scalars['ID'];
};

export type RejectFriendRequestPayload = {
   __typename?: 'RejectFriendRequestPayload';
  /** The user whose friend request was just rejected. */
  user?: Maybe<User>;
};

/** Errors from rejectSquadStreamInvitation mutation. */
export type RejectSquadStreamInvitationError = {
   __typename?: 'RejectSquadStreamInvitationError';
  /** Error from request to reject invitation. */
  code: RejectSquadStreamInvitationErrorCode;
};

/** Possible errors from this mutation. */
export enum RejectSquadStreamInvitationErrorCode {
  /** Invitation to be rejected does not exist. */
  InvitationNotFound = 'INVITATION_NOT_FOUND',
  /** Squad associated with the invitation does not exist. */
  SquadNotFound = 'SQUAD_NOT_FOUND',
  /** User does not have permissions to reject invitation. */
  Unauthorized = 'UNAUTHORIZED',
  /** Invitation not in pending state cannot be rejected. */
  InvitationCannotBeRejected = 'INVITATION_CANNOT_BE_REJECTED'
}

/** Inputs to the rejectSquadStreamInvitation mutation. */
export type RejectSquadStreamInvitationInput = {
  /** ID of the invitation to be rejected. */
  invitationID: Scalars['ID'];
};

/** Outputs from the rejectSquadStreamInvitation mutation. */
export type RejectSquadStreamInvitationPayload = {
   __typename?: 'RejectSquadStreamInvitationPayload';
  /** Error from mutation if exists. */
  error?: Maybe<RejectSquadStreamInvitationError>;
  /** The rejected invitation. */
  invitation?: Maybe<SquadStreamInvitation>;
};

/** RejectSquadStreamOutOfNetworkInvitationsError is the error associated with a rejectSquadStreamOutOfNetworkInvitations. */
export type RejectSquadStreamOutOfNetworkInvitationsError = {
   __typename?: 'RejectSquadStreamOutOfNetworkInvitationsError';
  /** The associated error code. */
  code: RejectSquadStreamOutOfNetworkInvitationsErrorCode;
};

/** RejectSquadStreamOutOfNetworkInvitationsErrorCode are the possible errors that this mutation returns. */
export enum RejectSquadStreamOutOfNetworkInvitationsErrorCode {
  /** The user is not authorized to reject invitations on behalf of the recipient. */
  Unauthorized = 'UNAUTHORIZED'
}

/** Inputs to the rejectSquadStreamOutOfNetworkInvitations mutation. */
export type RejectSquadStreamOutOfNetworkInvitationsInput = {
  /** ID of the user whose out of network invitations will be rejected. */
  recipientID: Scalars['ID'];
};

/** Outputs from the rejectSquadStreamOutOfNetworkInvitations mutation. */
export type RejectSquadStreamOutOfNetworkInvitationsPayload = {
   __typename?: 'RejectSquadStreamOutOfNetworkInvitationsPayload';
  /** The possible error returned from the service. */
  error?: Maybe<RejectSquadStreamOutOfNetworkInvitationsError>;
};

/** RemoveAutohostChannelsInput remove channelIDs from a user's list to autohost. */
export type RemoveAutohostChannelsInput = {
  /** ChannelIDs that will be removed from the list to autohost. */
  channelIDs: Array<Scalars['ID']>;
  /** UserID to update autohost list for. */
  userID: Scalars['ID'];
};

/** RemoveAutohostChannelsPayload returns the user whose autohostChannels field had been updated. */
export type RemoveAutohostChannelsPayload = {
   __typename?: 'RemoveAutohostChannelsPayload';
  /** User whose autohostChannels field had been updated. */
  user?: Maybe<User>;
};

/** RemoveCollectionItemInput accepts a collectionID and item ID and parameters to remove the item from a collection. */
export type RemoveCollectionItemInput = {
  /** The id of the collection. */
  collectionID: Scalars['ID'];
  /** The id of the item of which will be added to the collection. */
  itemID: Scalars['ID'];
  /** The type of item ie. video. */
  itemType: Scalars['String'];
};

/** The response from removing an item from a collection. */
export type RemoveCollectionItemPayload = {
   __typename?: 'RemoveCollectionItemPayload';
  /** The newly updated collection. */
  collection?: Maybe<Collection>;
};

/** RemoveCompetitionPhaseInput contains the inputs required to remove a phase. */
export type RemoveCompetitionPhaseInput = {
  /** The competition id of the competition. */
  competitionID: Scalars['ID'];
  /** The id of the competition phase. */
  phaseID: Scalars['ID'];
};

/** RemoveCompetitionPhasePayload is the success response for removing a phase. */
export type RemoveCompetitionPhasePayload = {
   __typename?: 'RemoveCompetitionPhasePayload';
  /** The new state of competition after removing a phase. */
  competition?: Maybe<Competition>;
};

/**
 * Remove a player from a Competition. If you remove a player that is part of a
 * team, the player will removed from the team as well. If that player is a captain
 * of the team, the team will no longer have a captain.
 */
export type RemoveCompetitionPlayerInput = {
  /** Unique Competition ID. */
  competitionID: Scalars['ID'];
  /** Twitch user id of the player. */
  userID: Scalars['ID'];
};

/** Indication that the player was removed. */
export type RemoveCompetitionPlayerPayload = {
   __typename?: 'RemoveCompetitionPlayerPayload';
  /** The new state of competition after removing a competition player from the competition. */
  competition?: Maybe<Competition>;
};

/** Inputs for removing a competition team from a competition. */
export type RemoveCompetitionTeamInput = {
  /** ID of the competition. */
  competitionID: Scalars['ID'];
  /** ID of the team. */
  teamID: Scalars['ID'];
};

/** RemoveCompetitionTeamPayload is the success response removing a competition team from the competition. */
export type RemoveCompetitionTeamPayload = {
   __typename?: 'RemoveCompetitionTeamPayload';
  /** The new state of competition after removing a competition team from the competition. */
  competition?: Maybe<Competition>;
};

/** RemoveEditorError contains details about a client error that occurred. */
export type RemoveEditorError = {
   __typename?: 'RemoveEditorError';
  /** The type of error that occurred when revoking a user's editor status. */
  code: RemoveEditorErrorCode;
};

/** RemoveEditorErrorCode defines a client error that occurred while removing an editor. */
export enum RemoveEditorErrorCode {
  /** The channel does not exist. */
  ChannelNotFound = 'CHANNEL_NOT_FOUND',
  /** The target user does not exist. */
  TargetUserNotFound = 'TARGET_USER_NOT_FOUND'
}

/** RemoveEditorInput contains the parameters to revoke the editor status from a user for a channel. */
export type RemoveEditorInput = {
  /** The channel from which the editor status of the user will be revoked. */
  channelID: Scalars['ID'];
  /**
   * The ID of the user whose editor status will be revoked.
   * Either targetUserID or targetUserLogin must be provided.
   */
  targetUserID?: Maybe<Scalars['ID']>;
  /**
   * The login of the user whose editor status will be revoked.
   * Either targetUserID or targetUserLogin must be provided.
   */
  targetUserLogin?: Maybe<Scalars['String']>;
};

/** RemoveEditorPayload is the response after attempting to revoke the editor status of a user. */
export type RemoveEditorPayload = {
   __typename?: 'RemoveEditorPayload';
  /** The channel for which the editor status of the target user is removed. */
  channel?: Maybe<User>;
  /**
   * The client error that has occurred.
   * Null if the operation is successful.
   */
  error?: Maybe<RemoveEditorError>;
  /** The user whose editor status was revoked. */
  targetUser?: Maybe<User>;
};

/** RemoveOrganizationMemberError is the error associated with a RemoveOrganizationMember. */
export type RemoveOrganizationMemberError = {
   __typename?: 'RemoveOrganizationMemberError';
  /** The associated error code. */
  code: RemoveOrganizationMemberErrorCode;
};

/** RemoveOrganizationMemberErrorCode defines a client error that occurred while removing an organizaiton member. */
export enum RemoveOrganizationMemberErrorCode {
  /** User does not have permission to remove another member. */
  PermissionDenied = 'PERMISSION_DENIED',
  /** The user to be removed does not exist. */
  UserNotFound = 'USER_NOT_FOUND',
  /** Can not remove this user because it is assigned as an extension billing manager. Need to unassign first. */
  AssignedBillingManager = 'ASSIGNED_BILLING_MANAGER',
  /** Deprecated: code not used, a resolver error is returned instead. */
  InternalError = 'INTERNAL_ERROR'
}

/** Inputs to the removeOrganizationMember mutation. */
export type RemoveOrganizationMemberInput = {
  /** The ID of the organization. */
  organizationID: Scalars['ID'];
  /** The twitch ID of the organization member. */
  userID: Scalars['ID'];
};

/** Outputs from the removeOrganizationMember mutation. */
export type RemoveOrganizationMemberPayload = {
   __typename?: 'RemoveOrganizationMemberPayload';
  /** The possible error returned from the service. */
  error?: Maybe<RemoveOrganizationMemberError>;
  /** The user who is removed from organization. */
  targetUser?: Maybe<User>;
};

export type RemoveReactionInput = {
  emoteID: Scalars['ID'];
  entityID: Scalars['ID'];
};

export type RemoveReactionPayload = {
   __typename?: 'RemoveReactionPayload';
  content: ReactableContent;
};

/** RemoveSquadStreamMemberError is the error associated with a removeSquadStreamMember. */
export type RemoveSquadStreamMemberError = {
   __typename?: 'RemoveSquadStreamMemberError';
  /** The associated error code. */
  code: RemoveSquadStreamMemberErrorCode;
};

/** RemoveSquadStreamMemberErrorCode are the possible errors that this mutation returns. */
export enum RemoveSquadStreamMemberErrorCode {
  /** The user is not authorized to remove members from the squad. */
  Unauthorized = 'UNAUTHORIZED',
  /** The user to be removed is not in the squad specified. */
  UserNotInSquad = 'USER_NOT_IN_SQUAD'
}

/** Inputs to the removeSquadStreamMember mutation. */
export type RemoveSquadStreamMemberInput = {
  /** The user ID of the member that should be removed from the squad stream. */
  memberUserID: Scalars['ID'];
  /** The ID of the squad stream. */
  squadStreamID: Scalars['ID'];
};

/** Outputs from the removeSquadStreamMember mutation. */
export type RemoveSquadStreamMemberPayload = {
   __typename?: 'RemoveSquadStreamMemberPayload';
  /** The possible error returned from the service. */
  error?: Maybe<RemoveSquadStreamMemberError>;
  /** The updated squad stream. */
  squadStream?: Maybe<SquadStream>;
};

/**
 * Inputs for removing a stucco (from the library).
 * - Active stuccos cannot be removed, they have to be inactive first (not part of a stucco pack).
 */
export type RemoveStuccoInput = {
  /** ID of the channel the stucco is removed from. */
  channelID: Scalars['ID'];
  /** Unique ID of the stucco to be removed. */
  stuccoID: Scalars['ID'];
};

/** The output payload for removing a stucco, returns the library of stuccos after removal. */
export type RemoveStuccoPayload = {
   __typename?: 'RemoveStuccoPayload';
  /** The list of stuccos available in the channel's library after removal. */
  stuccos?: Maybe<Array<Stucco>>;
};

/** RenewalPolicy defines whether the charge model will renew or not. */
export enum RenewalPolicy {
  /** Will not renew automatically. */
  NoRenew = 'NO_RENEW',
  /** Will renew automatically. */
  AutoRenew = 'AUTO_RENEW',
  /** Unknown renewal policy. */
  Unknown = 'UNKNOWN'
}

/** ReorderCollectionItemInput accepts a collectionID and item ID and parameters to update the item order of a collection. */
export type ReorderCollectionItemInput = {
  /** The id of the collection. */
  collectionID: Scalars['ID'];
  /** The id of the item of which will be moved in the collection. */
  itemID: Scalars['ID'];
  /** The type of item ie. video. */
  itemType: Scalars['String'];
  /** The new position of the item. */
  position: Scalars['Int'];
};

/** The response from reordering an item in a collection. */
export type ReorderCollectionItemPayload = {
   __typename?: 'ReorderCollectionItemPayload';
  /** The newly updated collection. */
  collection?: Maybe<Collection>;
};

export type ReportContentInput = {
  /** Content type being reported. */
  content: ReportContentType;
  /** ID of the content being reported. */
  contentID: Scalars['ID'];
  /** The description of the report. */
  description: Scalars['String'];
  /** Extra (content specific) data for the report. */
  extra: Scalars['String'];
  /** The reason ID for the report. */
  reason: Scalars['ID'];
  /** ID of the user being reported. */
  targetID: Scalars['ID'];
};

export type ReportContentPayload = {
   __typename?: 'ReportContentPayload';
  /** Content type that was reported. */
  content: ReportContentType;
  /** ID of the content that was reported. */
  contentID: Scalars['ID'];
};

/** Types of content that can be reported. */
export enum ReportContentType {
  /** Report against a channel feed comment. */
  ChannelFeedCommentReport = 'CHANNEL_FEED_COMMENT_REPORT',
  /** Report against a channel feed post. */
  ChannelFeedPostReport = 'CHANNEL_FEED_POST_REPORT',
  /** Report against a chat message. */
  ChatReport = 'CHAT_REPORT',
  /** Report against a channel's channel points. */
  ChannelPointsReport = 'CHANNEL_POINTS_REPORT',
  /** Report against a clip. */
  ClipReport = 'CLIP_REPORT',
  /** (Deprecated) Report against a vod collection. */
  CollectionReport = 'COLLECTION_REPORT',
  /** (Deprecated) Report against a curse private group. */
  CursePrivateGroup = 'CURSE_PRIVATE_GROUP',
  /** (Deprecated) Report against a curse public group. */
  CursePublicGroup = 'CURSE_PUBLIC_GROUP',
  /** (Deprecated) Report against a curse whisper. */
  CurseWhisper = 'CURSE_WHISPER',
  /** Report against an emote. */
  EmoteReport = 'EMOTE_REPORT',
  /** Report against an oracle event. */
  EventReport = 'EVENT_REPORT',
  /** Report against an extension. */
  ExtensionReport = 'EXTENSION_REPORT',
  /** Report against a live up notification. */
  LiveUpReport = 'LIVE_UP_REPORT',
  /** Report against a poll. */
  PollReport = 'POLL_REPORT',
  /** Report against a raid. */
  RaidReport = 'RAID_REPORT',
  /** Report against a reward redemption. */
  RewardRedemptionReport = 'REWARD_REDEMPTION_REPORT',
  /** Report against a chatroom. */
  RoomReport = 'ROOM_REPORT',
  /** Report against sings group name. */
  SingsGroupNameReport = 'SINGS_GROUP_NAME_REPORT',
  /** Report against sings group biography. */
  SingsGroupBioReport = 'SINGS_GROUP_BIO_REPORT',
  /** Report against sings group chat. */
  SingsGroupChatReport = 'SINGS_GROUP_CHAT_REPORT',
  /** Report against a sings group vod comment. */
  SingsVodCommentReport = 'SINGS_VOD_COMMENT_REPORT',
  /** Report against sings duet seed. */
  SingsDuetSeedReport = 'SINGS_DUET_SEED_REPORT',
  /** Report against a live user. */
  UserReport = 'USER_REPORT',
  /** Report against a twitch vod comment. */
  VodCommentReport = 'VOD_COMMENT_REPORT',
  /** Report against a twitch vod. */
  VodReport = 'VOD_REPORT',
  /** Report against a whisper. */
  WhisperReport = 'WHISPER_REPORT'
}

/** A valid reason for a report. */
export type ReportReason = {
   __typename?: 'ReportReason';
  /** The unique ID of the reason. */
  id: Scalars['ID'];
  /** The displayed text for this reason localized based on Accept-Language. */
  text: Scalars['String'];
};

export type ReportWhisperThreadInput = {
  /** Reason why the user is reporting the thread. */
  reason?: Maybe<Scalars['String']>;
  /** ID of user being reported. */
  targetUserID: Scalars['ID'];
  /** ID of thread to report. */
  threadID: Scalars['ID'];
};

export type ReportWhisperThreadPayload = {
   __typename?: 'ReportWhisperThreadPayload';
  thread: WhisperThread;
};

/** Metadata about a GraphQL request. */
export type RequestInfo = {
   __typename?: 'RequestInfo';
  /** The country code where the request originated. Defaults to "US" if geoip lookup fails. */
  countryCode: Scalars['String'];
  /** Whether the request came from a country belonging to the European Union. */
  fromEU: Scalars['Boolean'];
  /** The IP address where the request originated. */
  ipAddress?: Maybe<Scalars['String']>;
  /** Whether the request came from a country belonging to the European Economic Area. */
  isFromEEA: Scalars['Boolean'];
};

export type RequestRitualTokenError = {
   __typename?: 'RequestRitualTokenError';
  code: RequestRitualTokenErrorCode;
};

export enum RequestRitualTokenErrorCode {
  /** Token is not in a status that can be requested. */
  TokenNotAvailable = 'TOKEN_NOT_AVAILABLE',
  /** Token does not exist. */
  TokenNotFound = 'TOKEN_NOT_FOUND'
}

/** RequestRitualTokenInput is the input when requesting a ritual token. */
export type RequestRitualTokenInput = {
  /** The channel to request a ritual token in. */
  channelID: Scalars['ID'];
  /** The type of ritual token to request. */
  type: RitualTokenType;
};

/** RequestRitualTokenPayload is the response when requesting a ritual token. */
export type RequestRitualTokenPayload = {
   __typename?: 'RequestRitualTokenPayload';
  error?: Maybe<RequestRitualTokenError>;
  token?: Maybe<RitualToken>;
};

/** ResendVerificationEmailInput is input required to resend the verification email. */
export type ResendVerificationEmailInput = {
  /** ID of the user to resend a verification email to. */
  userID: Scalars['ID'];
};

/** ResendVerificationEmailPayload is the output after resending a verification email. */
export type ResendVerificationEmailPayload = {
   __typename?: 'ResendVerificationEmailPayload';
  /** The modified user. */
  user?: Maybe<User>;
};

/** A restriction for a specific resource. */
export type ResourceRestriction = {
   __typename?: 'ResourceRestriction';
  /** The list of exemptions for a given resource restriction. */
  exemptions?: Maybe<Array<ResourceRestrictionExemption>>;
  /** The restriction's unique identifier. */
  id: Scalars['ID'];
  /** The list of options that were applied at time of creation for a given resource restriction. */
  options: Array<ResourceRestrictionOption>;
  /** The type of restriction on this resource. */
  type: ResourceRestrictionType;
};

/** Exemption information for a specific resource restriction. */
export type ResourceRestrictionExemption = {
   __typename?: 'ResourceRestrictionExemption';
  /** The list of description data a user make take to become exempt for the given restriction. */
  actions?: Maybe<Array<ResourceRestrictionExemptionAction>>;
  /** The time that the restriction is no longer active. */
  endsAt?: Maybe<Scalars['Time']>;
  /** The keys needed for a given restriction. */
  keys?: Maybe<Array<Scalars['String']>>;
  /** The time that the restriction becomes active. */
  startsAt?: Maybe<Scalars['Time']>;
  /** The type of exemption. */
  type: ResourceRestrictionExemptionType;
};

/** Description data for clients to get for user actions to get exempt. */
export type ResourceRestrictionExemptionAction = {
   __typename?: 'ResourceRestrictionExemptionAction';
  /** Name of the action need. e.g. Ticket Product short name. */
  name: Scalars['String'];
  /** The human readable title of the restriction. */
  title: Scalars['String'];
};

/** An enumeration of the different exemption types. */
export enum ResourceRestrictionExemptionType {
  /** The restriction is exempt for an unknown reason. */
  Unknown = 'UNKNOWN',
  /** The restriction is exempt for all users. */
  All = 'ALL',
  /** The restriction is exempt for staff accounts. */
  Staff = 'STAFF',
  /** The restriction is exempt for site admins. */
  SiteAdmin = 'SITE_ADMIN',
  /** The restriction is exempt for owning a product. */
  Product = 'PRODUCT',
  /** The restriction is exempt for viewers that are in the same org as the channel owner. */
  OrganizationMember = 'ORGANIZATION_MEMBER'
}

/** An enumeration of the different restriction options. */
export enum ResourceRestrictionOption {
  /** Allows users holding the channel VIP role to access the resource. */
  AllowChannelVip = 'ALLOW_CHANNEL_VIP',
  /** Allows users holding the channel moderator role to access the resource. */
  AllowChannelModerator = 'ALLOW_CHANNEL_MODERATOR',
  /** Allows only users with tier 3 subscriptions to access the resource. */
  AllowTier_3Only = 'ALLOW_TIER_3_ONLY',
  /** Allows only users with tier 2 and 3 subscriptions to access the resource. */
  AllowTier_2And_3Only = 'ALLOW_TIER_2_AND_3_ONLY',
  /** Allows users with any tier subscriptions to access the resource. */
  AllowAllTiers = 'ALLOW_ALL_TIERS'
}

/** An enumeration of the different restriction types. */
export enum ResourceRestrictionType {
  /** The resource is restricted for an unknown reason. */
  Unknown = 'UNKNOWN',
  /** The resource is restricted by a subscription. */
  SubOnlyLive = 'SUB_ONLY_LIVE',
  /** The resource is restricted by the All-Access Pass. */
  AllAccessPass = 'ALL_ACCESS_PASS',
  /** The resource is restricted by the organization membership logic in RBAC. */
  OrganizationAccessOnly = 'ORGANIZATION_ACCESS_ONLY'
}

/** An enumeration of the different restriction types. */
export enum RestrictionResource {
  /** For non-live video content, e.g. VODs. */
  Video = 'VIDEO',
  /** For live video content. */
  Live = 'LIVE'
}

/** A recent resub token to use for sending a special message. */
export type ResubNotification = {
   __typename?: 'ResubNotification';
  /** The number of months of total subbing. */
  cumulativeTenureMonths: Scalars['Int'];
  /** A unique ID for the resub notification. */
  id: Scalars['ID'];
  /** The number of months of consecutive subbing. */
  months: Scalars['Int'];
  /** The number of months of consecutive subbing. */
  streakTenureMonths: Scalars['Int'];
  /** The token to use when submitting a sub/resub message. */
  token: Scalars['String'];
};

/** The possible erors when resuming a schedule. */
export enum ResumeScheduleError {
  /** Not authorized to resume this schedule. */
  PermissionDenied = 'PERMISSION_DENIED',
  /** The schedule was not found. */
  NotFound = 'NOT_FOUND'
}

/** The input to resume a schedule. */
export type ResumeScheduleInput = {
  /** The id of the schedule. */
  scheduleID: Scalars['ID'];
};

/** The returned payload when resuming a schedule. */
export type ResumeSchedulePayload = {
   __typename?: 'ResumeSchedulePayload';
  /** The possible error. */
  error?: Maybe<ResumeScheduleError>;
  /** The updated schedule input. */
  schedule?: Maybe<Schedule>;
};

/** Revenue configuration data related to a subscription product. */
export type RevenueConfig = {
   __typename?: 'RevenueConfig';
  /** Unique identifier for the revenue configuration. */
  id: Scalars['ID'];
  /** 0-100 percent value of revenue the broadcaster will earn. */
  splitPercent: Scalars['Int'];
  /** Start time of when the revenue split configuration takes effect. */
  startAt?: Maybe<Scalars['Time']>;
};

/** RevokeVIPError contains details about a client error that occurred. */
export type RevokeVipError = {
   __typename?: 'RevokeVIPError';
  /** The type of error that occurred when revoking a user's VIP status. */
  code: RevokeVipErrorCode;
};

/** RevokeVIPErrorCode defines a client error that occurred while revoking a VIP status. */
export enum RevokeVipErrorCode {
  /** The channel does not exist. */
  ChannelNotFound = 'CHANNEL_NOT_FOUND',
  /** The revoker does not have permission to revoke the VIP status in this channel. */
  Forbidden = 'FORBIDDEN',
  /** The user whose VIP status is to be revoked does not exist. */
  RevokeeNotFound = 'REVOKEE_NOT_FOUND',
  /** The user whose VIP statu is to be revoked does not actually have the VIP status to be revoked. */
  RevokeeNotVip = 'REVOKEE_NOT_VIP'
}

/** RevokeVIPInput contains the parameters to revoke the VIP status of a user from a channel. */
export type RevokeVipInput = {
  /** The channel from which the VIP status of the user will be revoked. */
  channelID: Scalars['ID'];
  /**
   * The ID of the user whose VIP status will be revoked.
   * Either revokeeID or revokeeLogin must be provided.
   */
  revokeeID?: Maybe<Scalars['ID']>;
  /**
   * The login of the user whose VIP status will be revoked.
   * Either revokeeID or revokeeLogin must be provided.
   */
  revokeeLogin?: Maybe<Scalars['String']>;
};

/** RevokeVIPPayload is the response after attempting to revoke the VIP status of a user. */
export type RevokeVipPayload = {
   __typename?: 'RevokeVIPPayload';
  /** The channel that the user is revoked as a VIP to. */
  channel?: Maybe<User>;
  /**
   * The client error that has occurred.
   * Null if the operation is successful.
   */
  error?: Maybe<RevokeVipError>;
  /** The user whose VIP status is revoked. */
  revokee?: Maybe<User>;
};

/** Rewarded Video information. */
export type RewardedVideo = {
   __typename?: 'RewardedVideo';
  /** A flag indicating if the user is eligible for rewarded videos. */
  isEligible: Scalars['Boolean'];
  /** A flag indicating if the user needs to do a captcha in order to use rewarded videos. */
  shouldCaptcha: Scalars['Boolean'];
};

export type RichOEmbed = OEmbed & {
   __typename?: 'RichOEmbed';
  authorName?: Maybe<Scalars['String']>;
  authorURL?: Maybe<Scalars['String']>;
  cacheAge?: Maybe<Scalars['Int']>;
  height: Scalars['Int'];
  html: Scalars['String'];
  inputURL: Scalars['String'];
  providerName?: Maybe<Scalars['String']>;
  providerURL?: Maybe<Scalars['String']>;
  thumbnail?: Maybe<ThumbnailOEmbed>;
  title?: Maybe<Scalars['String']>;
  type: Scalars['String'];
  version: Scalars['String'];
  width: Scalars['Int'];
};

/**
 * A ritual is an opportunity for a viewer to better connect with a streamer's
 * community by announcing when they reach milestones in the channel.
 * A ritual token is issued when a user is eligible for the ritual, and can be
 * redeemed to send the announcement in a channel.
 */
export type RitualToken = {
   __typename?: 'RitualToken';
  /** The channel that the user can redeem the ritual token in. */
  channel?: Maybe<User>;
  /**
   * The time after which the ritual is considered expired and can no longer be
   * redeemed. Clients should dismiss the ritual UI if it's still shown after
   * this time. Null if the ritual never expires.
   */
  expiresAt?: Maybe<Scalars['Time']>;
  /** A unique ID for the ritual token. */
  id: Scalars['ID'];
  /** The status of the ritual token. */
  status?: Maybe<RitualTokenStatus>;
  /** The type of the ritual to be redeemed. */
  type?: Maybe<RitualTokenType>;
  /** The user that owns the ritual token. */
  user?: Maybe<User>;
};

export enum RitualTokenStatus {
  /** ELIGIBLE means a user does not have this token, but can request one. */
  Eligible = 'ELIGIBLE',
  /** AVAILABLE means a user has been granted this token and it can be redeemed. */
  Available = 'AVAILABLE',
  /** DISMISSED means a user has opted out of redeeming this token. */
  Dismissed = 'DISMISSED',
  /** REDEEMED means a user has successfully consumed this token. */
  Redeemed = 'REDEEMED'
}

export enum RitualTokenType {
  /** NEW_CHATTER is granted 5 minutes after a user joins a channel for the first time. */
  NewChatter = 'NEW_CHATTER'
}

/**
 * DEPRECATED.
 * A chatroom associated with a channel where members of the room can exchange messages.
 */
export type Room = {
   __typename?: 'Room';
  /**
   * UUID of the room.
   * @deprecated The Rooms product has been sunset
   */
  id: Scalars['ID'];
  /**
   * Whether the room can be read by non-members and logged out users.
   * @deprecated The Rooms product has been sunset
   */
  isPreviewable: Scalars['Boolean'];
  /**
   * Paginated list of members of the chatroom.
   * @deprecated The Rooms product has been sunset
   */
  members?: Maybe<RoomMemberConnection>;
  /**
   * List of messages to the room, in reverse chronological order. If fromTime is used, that time is used
   * as the cursor instead of after/before.
   * @deprecated The Rooms product has been sunset
   */
  messages?: Maybe<RoomMessageConnection>;
  /**
   * Minimum role required to join the room. For example, in a sub room, subs can join,
   * but also the broadcaster, mods, and staff.
   * @deprecated The Rooms product has been sunset
   */
  minimumAllowedRole: RoomRole;
  /**
   * Room modes (e.g. slow mode).
   * @deprecated The Rooms product has been sunset
   */
  modes?: Maybe<RoomModes>;
  /**
   * The name of the room (e.g. subs-only).
   * @deprecated The Rooms product has been sunset
   */
  name: Scalars['String'];
  /**
   * The user the room belongs to.
   * @deprecated The Rooms product has been sunset
   */
  owner: User;
  /**
   * rolePermissions describes the role necessary to perform actions in the room.
   * @deprecated The Rooms product has been sunset
   */
  rolePermissions?: Maybe<RoomRolePermissions>;
  /**
   * Returns the current user's settings for the room.
   * @deprecated The Rooms product has been sunset
   */
  self?: Maybe<RoomView>;
  /**
   * The room topic (e.g. "serious discussion only").
   * @deprecated The Rooms product has been sunset
   */
  topic?: Maybe<Scalars['String']>;
};


/**
 * DEPRECATED.
 * A chatroom associated with a channel where members of the room can exchange messages.
 */
export type RoomMembersArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};


/**
 * DEPRECATED.
 * A chatroom associated with a channel where members of the room can exchange messages.
 */
export type RoomMessagesArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
  last?: Maybe<Scalars['Int']>;
  before?: Maybe<Scalars['Cursor']>;
  fromTime?: Maybe<Scalars['Time']>;
};

/**
 * DEPRECATED
 * Paginated list of room members (users).
 */
export type RoomMemberConnection = {
   __typename?: 'RoomMemberConnection';
  /**
   * The elements of the list.
   * @deprecated The Rooms product has been sunset
   */
  edges: Array<Maybe<RoomMemberEdge>>;
  /**
   * Information about this page.
   * @deprecated The Rooms product has been sunset
   */
  pageInfo: PageInfo;
};

/** Element in a list of room members. */
export type RoomMemberEdge = {
   __typename?: 'RoomMemberEdge';
  /**
   * Opaque cursor describing this edge's position in the paginated list.
   * @deprecated The Rooms product has been sunset
   */
  cursor: Scalars['Cursor'];
  /**
   * The user who is a member of the room.
   * @deprecated The Rooms product has been sunset
   */
  node?: Maybe<User>;
  /**
   * Type of user for grouping users in the rooms member list.
   * @deprecated The Rooms product has been sunset
   */
  type: RoomMemberType;
};

/**
 * DEPRECATED
 * Type of user for grouping users in the rooms member list.
 */
export enum RoomMemberType {
  /** User that is the broadcaster. */
  Broadcaster = 'BROADCASTER',
  /** User that is staff. */
  Staff = 'STAFF',
  /** User that is admin. */
  Admin = 'ADMIN',
  /** User that is global moderator. */
  Globalmod = 'GLOBALMOD',
  /** User that is a channel moderator. */
  Mod = 'MOD',
  /** User that has no special role. */
  Regular = 'REGULAR'
}

/**
 * DEPRECATED
 * A message sent from a user to a room.
 */
export type RoomMessage = {
   __typename?: 'RoomMessage';
  /**
   * The text and emoticon content of a message.
   * @deprecated The Rooms product has been sunset
   */
  content: RoomMessageContent;
  /**
   * Time the message was deleted or purged. Null if the message is not deleted.
   * @deprecated The Rooms product has been sunset
   */
  deletedAt?: Maybe<Scalars['Time']>;
  /**
   * UUID of the message.
   * @deprecated The Rooms product has been sunset
   */
  id: Scalars['ID'];
  /**
   * The room the message was sent in.
   * @deprecated The Rooms product has been sunset
   */
  room: Room;
  /**
   * The user that sent the message.
   * @deprecated The Rooms product has been sunset
   */
  sender: User;
  /**
   * Time the message was sent.
   * @deprecated The Rooms product has been sunset
   */
  sentAt: Scalars['Time'];
};

/**
 * DEPRECATED
 * Paginated list of messages in a room.
 */
export type RoomMessageConnection = {
   __typename?: 'RoomMessageConnection';
  /**
   * The elements of the list.
   * @deprecated The Rooms product has been sunset
   */
  edges: Array<Maybe<RoomMessageEdge>>;
  /**
   * Information about this page.
   * @deprecated The Rooms product has been sunset
   */
  pageInfo: PageInfo;
};

/**
 * DEPRECATED
 * The content of a user's message to a room.
 */
export type RoomMessageContent = {
   __typename?: 'RoomMessageContent';
  /**
   * Parsed list of fragments in the message, include emotes, mentions, and plaintext.
   * @deprecated The Rooms product has been sunset
   */
  fragments: Array<Maybe<RoomMessageFragment>>;
  /**
   * String representation of the user message.
   * @deprecated The Rooms product has been sunset
   */
  text: Scalars['String'];
};

/** Element in a list of messages. */
export type RoomMessageEdge = {
   __typename?: 'RoomMessageEdge';
  /**
   * Opaque cursor describing this edge's position in the paginated list.
   * @deprecated The Rooms product has been sunset
   */
  cursor: Scalars['Cursor'];
  /**
   * The message.
   * @deprecated The Rooms product has been sunset
   */
  node?: Maybe<RoomMessageItem>;
};

/**
 * DEPRECATED
 * One parsed part of a message, which may be an emote, mention, or plaintext.
 */
export type RoomMessageFragment = {
   __typename?: 'RoomMessageFragment';
  /**
   * Contains an emote or a mentioned user depending on the text of the fragment.
   * @deprecated The Rooms product has been sunset
   */
  content?: Maybe<FragmentContent>;
  /**
   * Plaintext representation of the fragment.
   * @deprecated The Rooms product has been sunset
   */
  text: Scalars['String'];
};

/**
 * DEPRECATED
 * RoomMessageGroupMention represents a group mention, such as @here.
 */
export type RoomMessageGroupMention = {
   __typename?: 'RoomMessageGroupMention';
  /**
   * The type of mention.
   * @deprecated The Rooms product has been sunset
   */
  type: RoomMessageMentionType;
};

export type RoomMessageItem = RoomMessage;

/** Represents a group mention, such as @here. */
export enum RoomMessageMentionType {
  /** An @here mention. */
  Here = 'HERE'
}

/** Modes that have been enabled for the room. */
export type RoomModes = {
   __typename?: 'RoomModes';
  /**
   * If enabled, messages to the room must contain only emotes.
   * @deprecated The Rooms product has been sunset
   */
  emotesOnlyModeEnabled: Scalars['Boolean'];
  /**
   * If enabled, messages to the room must be unique.
   * @deprecated The Rooms product has been sunset
   */
  r9kModeEnabled: Scalars['Boolean'];
  /**
   * The number of seconds users must wait between messages. If 0, slow mode is disabled.
   * @deprecated The Rooms product has been sunset
   */
  slowModeDurationSeconds: Scalars['Int'];
};

/**
 * DEPRECATED
 * Represents the permissions a user has in a room.
 */
export type RoomPermissions = {
   __typename?: 'RoomPermissions';
  /**
   * Whether the user can moderate the room.
   * @deprecated The Rooms product has been sunset
   */
  moderate: Scalars['Boolean'];
  /**
   * Whether the user can read messages in the room.
   * @deprecated The Rooms product has been sunset
   */
  readMessages: Scalars['Boolean'];
  /**
   * Whether the user can send messages in the room.
   * @deprecated The Rooms product has been sunset
   */
  sendMessages: Scalars['Boolean'];
};

/**
 * DEPRECATED
 * Describes the role a user must be in order to perform an action, such as sending messages. Roles are
 * hierarchical, so users that meet a role also meet all lower roles as well. For example, a moderator
 * meets the subscriber role, even if they are not subscribed to the channel. Roles are defined in order
 * from highest to lowest in the enum.
 */
export enum RoomRole {
  /** The channel owner. */
  Broadcaster = 'BROADCASTER',
  /** A moderator for the channel. */
  Moderator = 'MODERATOR',
  /** A subscriber of the channel. */
  Subscriber = 'SUBSCRIBER',
  /** All users. */
  Everyone = 'EVERYONE'
}

/**
 * DEPRECATED
 * RoomRolePermissions describes the role necessary to perform actions in a room.
 */
export type RoomRolePermissions = {
   __typename?: 'RoomRolePermissions';
  /**
   * Read describes the role necessary to read messages in the room.
   * @deprecated The Rooms product has been sunset
   */
  read: RoomRole;
  /**
   * Send describes the role necessary to send messages in the room.
   * @deprecated The Rooms product has been sunset
   */
  send: RoomRole;
};

/**
 * DEPRECATED
 * A RoomView represents the authenticated user's self connection to a room, and includes the user's
 * settings and permissions.
 */
export type RoomView = {
   __typename?: 'RoomView';
  /**
   * Whether the user has archived the room.
   * @deprecated The Rooms product has been sunset
   */
  isArchived: Scalars['Boolean'];
  /**
   * Whether the user has muted the room.
   * @deprecated The Rooms product has been sunset
   */
  isMuted: Scalars['Boolean'];
  /**
   * Whether the user has unread messages in the room.
   * @deprecated The Rooms product has been sunset
   */
  isUnread: Scalars['Boolean'];
  /**
   * Last time the user read a message in the room.
   * @deprecated The Rooms product has been sunset
   */
  lastReadAt?: Maybe<Scalars['Time']>;
  /**
   * The permissions the authenticated user has in the room.
   * @deprecated The Rooms product has been sunset
   */
  permissions?: Maybe<RoomPermissions>;
  /**
   * The room the room view belongs to.
   * @deprecated The Rooms product has been sunset
   */
  room: Room;
  /**
   * The number of mentions for the user in the room that the user has not read.
   * @deprecated The Rooms product has been sunset
   */
  unreadMentionCount: Scalars['Int'];
};

/** RTMPSession is metadata related to the RTMP data sent by the broadcaster. */
export type RtmpSession = {
   __typename?: 'RTMPSession';
  /** Audio codecs of RTMP session. */
  audioCodecs: Scalars['String'];
  /** H.264 advanced video codec. */
  avcLevel?: Maybe<Scalars['Int']>;
  /** Staff-only field. The IP address of the broadcaster of the RTMP session. */
  clientIP?: Maybe<Scalars['String']>;
  /** Name of the broadcaster's encoder. */
  encoder: Scalars['String'];
  /** H.264 encoder Instantaneous Decoder Refresh interval. */
  idrInterval?: Maybe<Scalars['Int']>;
  /** rtmpExitReason tells how the stream session was terminated. */
  rtmpExitReason?: Maybe<Scalars['String']>;
  /** RTMP request parameters sent by the broadcaster. */
  rtmpFlags: Scalars['String'];
  /** A full list of RTMP header sent by the broadcaster. */
  rtmpMetadata: Scalars['String'];
  /** Duration of each video frame segment in seconds. */
  segmentDurationSeconds: Scalars['Int'];
  /** Video codecs of RTMP session. */
  videoCodecs: Scalars['String'];
  /** Video resolution height in pixel. */
  videoResolutionHeight: Scalars['Int'];
  /** Video resolution width in pixel. */
  videoResolutionWidth: Scalars['Int'];
};

/** Errors that can result from running multiplayer ads. */
export enum RunMultiplayerAdErrorCode {
  /** The channel is not live, so ads cannot be run on it. */
  ChannelNotLive = 'CHANNEL_NOT_LIVE',
  /** At least one of the multiplayer ad offers has expired. */
  OfferExpired = 'OFFER_EXPIRED',
  /** At least one of the multiplayer ad offers was not found. */
  OfferNotFound = 'OFFER_NOT_FOUND',
  /** An unknown error has occurred. */
  Unknown = 'UNKNOWN'
}

/** Inputs for running multiplayer ads. */
export type RunMultiplayerAdsInput = {
  /** ID of the channel the ads will run on. */
  channelID: Scalars['ID'];
  /** The ID of the ad offers to run. */
  offerIDs: Array<Scalars['ID']>;
};

/** The response after running multiplayer ads. */
export type RunMultiplayerAdsPayload = {
   __typename?: 'RunMultiplayerAdsPayload';
  /**
   * The error that has occurred.
   * Null if the operation is successful.
   */
  error?: Maybe<RunMultiplayerAdErrorCode>;
};

/** The view configuration of an extension if the component anchor is supported. */
export type SaveComponentViewInput = {
  /** The developer configured height of the extension as a ratio relative to it's width. */
  aspectHeight?: Maybe<Scalars['Int']>;
  /**
   * Specifies the width of a component extension in relation to it's targetHeight and aspectRatioY.
   * 
   * NOTE:  targetHeight and aspectRatio will replace aspectHeight and aspectWidth.
   *        however, since both will be used for a short time during the rollout of the new UI,
   *        aspectWidth and aspectHeight will not be deprecated until later.
   */
  aspectRatioX: Scalars['Int'];
  /**
   * Specifies the height of a component extension in relation to it's targetHeight and aspectRatioX.
   * 
   * NOTE:  targetHeight and aspectRatio will replace aspectHeight and aspectWidth, 
   *        however, since both will be used for a short time during the rollout of the new UI, 
   *        aspectWidth and aspectHeight will not be deprecated until later.
   */
  aspectRatioY: Scalars['Int'];
  /** The developer configured width of the extension as a ratio relative to it's height. */
  aspectWidth?: Maybe<Scalars['Int']>;
  /**
   * Specifies whether to automatically scale the extension iframe using css zoom as the video 
   * player dimensions change.
   */
  hasAutoscale?: Maybe<Scalars['Boolean']>;
  /**
   * Specifies whether CSS zooming should be applied to the CE container, creating a consistent
   * size of 1024 pixels along the long edge of the component. Default: true.
   */
  hasZoom?: Maybe<Scalars['Boolean']>;
  /**
   * If Autoscale is true, this indicates the baseline width of the extension.
   * This fields is optional, but is required if hasAutoscale is true.
   */
  scalePixels?: Maybe<Scalars['Int']>;
  /**
   * Size of the long edge of the Component Extension, relative to the length of the corresponding
   * interactable dimension of the video.
   */
  size?: Maybe<Scalars['Float']>;
  /**
   * The percentage of the available space (0-100) (between the top and bottom player controls) 
   * that the extension aims to consume.
   * 
   * NOTE:  targetHeight and aspectRatio will replace aspectHeight and aspectWidth, 
   *        however, since both will be used for a short time during the rollout of the new UI, 
   *        aspectWidth and aspectHeight will not be deprecated until later.
   */
  targetHeight: Scalars['Int'];
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
  /**
   * If hasZoom is set to true, specify the effective CSS zoom to apply to the long edge of the CE.
   * Default: 1024.
   */
  zoomPixels?: Maybe<Scalars['Int']>;
};

/** ConfigViewInput holds the view configuration of an extension if the config page is supported. */
export type SaveConfigViewInput = {
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

/** ExtensionAssetManifestInput is data related to the assets of an extension. */
export type SaveExtensionAssetManifestInput = {
  /** Hash of the asset zip file. */
  assetHash: Scalars['String'];
};

/** ExtensionCapabilitiesInput contains data about what an Extension can do, in general, and at the time of interaction. */
export type SaveExtensionCapabilitiesInput = {
  /** The bits support level required by the broadcaster for the extension to operate. Defaults to "NONE". */
  bitsSupportLevel?: Maybe<ExtensionBitsSupportLevel>;
  /** Location of configuration. */
  configurationLocation: ExtensionConfigurationLocation;
  /** Does this extension use bits. */
  hasBitsSupport: Scalars['Boolean'];
  /** Does this extension support chat. */
  hasChatSupport: Scalars['Boolean'];
  /** Required configuration string. */
  requiredConfiguration: Scalars['String'];
  /** The subscription support level required by the broadcaster for the extension to operate. Defaults to "NONE". */
  subscriptionsSupportLevel?: Maybe<ExtensionSubscriptionsSupportLevel>;
  /** Whitelists for restricting extension access and behavior. */
  whitelists: ExtensionWhitelistsInput;
  /** Will this extension request an identity link. */
  willRequestIdentityLink: Scalars['Boolean'];
};

/** ExtensionDeveloperManifestInput is the developer specific extension data. */
export type SaveExtensionDeveloperManifestInput = {
  /** Author email. */
  authorEmail: Scalars['String'];
  /** Testing uri for extension development. */
  testingBaseURI: Scalars['String'];
};

/** Extension metadata used for discovery. */
export type SaveExtensionDiscoveryManifestInput = {
  /** Name of the extension author. */
  authorName: Scalars['String'];
  /** Extension categories. */
  categories: Array<Scalars['ID']>;
  /** Extension descriprion. 1024 character limit. */
  description: Scalars['String'];
  /** games an extension is associated with. */
  games: Array<Scalars['ID']>;
  /** name of the extension. */
  name: Scalars['String'];
  /** Url to an extensions privacy policy. */
  privacyPolicyURL: Scalars['String'];
  /** Extension summary. 140 character limit. */
  summary: Scalars['String'];
  /** Extension developers support email. */
  supportEmail: Scalars['String'];
  /** Extension eula/tos url. */
  termsURL: Scalars['String'];
  /** A summary of the extension's functionality from a viewer's perspective. */
  viewerSummary: Scalars['String'];
};

/** SaveExtensionManifestError is an error associated with the saveExtensionManifest mutation. */
export enum SaveExtensionManifestError {
  /** User is unable to make modifications to the extension. */
  Unauthorized = 'UNAUTHORIZED',
  /** Version specified is invalid. */
  InvalidVersion = 'INVALID_VERSION',
  /** At least one anchor must be specified. */
  AnchorRequired = 'ANCHOR_REQUIRED',
  /** HasZoom was specified but ZoomPixels is missing. */
  InvalidZoom = 'INVALID_ZOOM',
  /** The number of whitelisted broadcasters exceeds the limit. */
  MaxBroadcasters = 'MAX_BROADCASTERS',
  /** The number of whitelisted testing users exceeds the limit. */
  MaxTesters = 'MAX_TESTERS',
  /** The number of whitelisted config URLs exceeds the limit. */
  MaxWhitelistedConfigUrls = 'MAX_WHITELISTED_CONFIG_URLS',
  /** The number of whitelisted panel URLs exceeds the limit. */
  MaxWhitelistedPanelUrls = 'MAX_WHITELISTED_PANEL_URLS',
  /** Extension names must be shorter than 40 characters. */
  InvalidNameLength = 'INVALID_NAME_LENGTH',
  /** Extension description must be shorter than 1024 characters. */
  InvalidDescriptionLength = 'INVALID_DESCRIPTION_LENGTH',
  /** Extension summary must be shorter than 140 characters. */
  InvalidSummaryLength = 'INVALID_SUMMARY_LENGTH',
  /** Extension author email must not be nil. Lenght must be < 254, Parses a single RFC 5322 address. */
  InvalidAuthorEmail = 'INVALID_AUTHOR_EMAIL',
  /** Extension support email must not be nil. Lenght must be < 254, Parses a single RFC 5322 address. */
  InvalidSupportEmail = 'INVALID_SUPPORT_EMAIL',
  /** Extension author name length must be > 40. */
  InvalidAuthorNameLength = 'INVALID_AUTHOR_NAME_LENGTH',
  /** Extension testing base uri must not be nil and empty scheme. Scheme should be http or https. User should not be nil. */
  InvalidTestingBaseUri = 'INVALID_TESTING_BASE_URI',
  /** Extension terms uri must not be nil and empty scheme. Scheme should be http or https. User should not be nil. */
  InvalidTermsUri = 'INVALID_TERMS_URI',
  /** Extension privacy uri must not be nil and empty scheme. Scheme should be http or https. User should not be nil. */
  InvalidPrivacyUri = 'INVALID_PRIVACY_URI',
  /** Extension component viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidComponentViewerPath = 'INVALID_COMPONENT_VIEWER_PATH',
  /** Extension panel viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidPanelViewerPath = 'INVALID_PANEL_VIEWER_PATH',
  /** Extension video overlay viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidVideoOverlayViewerPath = 'INVALID_VIDEO_OVERLAY_VIEWER_PATH',
  /** Extension config viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidConfigViewerPath = 'INVALID_CONFIG_VIEWER_PATH',
  /** Extension live config viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidLiveConfigViewerPath = 'INVALID_LIVE_CONFIG_VIEWER_PATH',
  /** Extension mobile viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidMobileViewerPath = 'INVALID_MOBILE_VIEWER_PATH',
  /** Extension component aspect width must be < 50 or > 1. */
  InvalidComponentAspectWidth = 'INVALID_COMPONENT_ASPECT_WIDTH',
  /** Extension component aspect height must be < 50 or > 1. */
  InvalidComponentAspectHeight = 'INVALID_COMPONENT_ASPECT_HEIGHT',
  /** Extension panel hiehgt must be < 500 or > 100. */
  InvalidPanelHeight = 'INVALID_PANEL_HEIGHT',
  /** Extension Bits Support Level must ba valid member of the BitsSupportLevelEnum. */
  InvalidBitsSupportLevel = 'INVALID_BITS_SUPPORT_LEVEL',
  /** Scale pixels must be set to a positive integer when autoscale is true. */
  InvalidScalingPixels = 'INVALID_SCALING_PIXELS',
  /** Aspect Ratio X must be set to a positive integer. */
  InvalidComponentAspectRatioX = 'INVALID_COMPONENT_ASPECT_RATIO_X',
  /** Aspect Ratio Y must be set to a positive integer. */
  InvalidComponentAspectRatioY = 'INVALID_COMPONENT_ASPECT_RATIO_Y',
  /** Target Height must be set to a positve integer. */
  InvalidComponentTargetHeight = 'INVALID_COMPONENT_TARGET_HEIGHT'
}

/** SaveExtensionManifestInput updates the manifest. */
export type SaveExtensionManifestInput = {
  /** ExtensionAssetManifest is data related to the assets of an extension. */
  assetManifest: SaveExtensionAssetManifestInput;
  /** Data about what an Extension can do, in general, and at the time of interaction. */
  capabilities: SaveExtensionCapabilitiesInput;
  /** ExtensionDeveloperManifest is the developer specific extension data. */
  developerManifest: SaveExtensionDeveloperManifestInput;
  /** Extension metadata used for discovery. */
  discoveryManifest: SaveExtensionDiscoveryManifestInput;
  /** The extension ID of the manifest to update. */
  id: Scalars['ID'];
  /** The extension version to update. */
  version: Scalars['String'];
  /** Extension views. */
  views: SaveExtensionViewsInput;
};

/** SaveExtensionManifestPayload returns the update Extension manifest. */
export type SaveExtensionManifestPayload = {
   __typename?: 'SaveExtensionManifestPayload';
  /** The error when the mutation fails to update an extension. */
  error?: Maybe<SaveExtensionManifestError>;
  /** The updated extension manifest. */
  manifest?: Maybe<ExtensionManifest>;
};

/** The potential anchor-specific configurations and extension can have. */
export type SaveExtensionViewsInput = {
  /** The developer configuration of the extension as a component extension, if supported. */
  component?: Maybe<SaveComponentViewInput>;
  /** The developer configuration of the extension's configuration view, if supported. */
  config?: Maybe<SaveConfigViewInput>;
  /** The developer configuration of the extension's live configuration dashboard view, if supported. */
  liveConfig?: Maybe<SaveLiveConfigViewInput>;
  /** The developer configuration of the extension as a mobile extension, if supported. */
  mobile?: Maybe<SaveMobileViewInput>;
  /** The developer configuration of the extension as a panel extension, if supported. */
  panel?: Maybe<SavePanelViewInput>;
  /** The developer configuration of the extension as a video overlay extension, if supported. */
  videoOverlay?: Maybe<SaveVideoOverlayViewInput>;
};

/** ExtensionWhitelistsInput contains whitelists for restricting extension access and behavior. */
export type SaveExtensionWhitelistsInput = {
  /**
   * List of broadcaster account IDs allowed to install an extension after release.
   * If this is empty or missing, all broadcasters can use this extension.
   */
  broadcasters: Array<Scalars['ID']>;
  /** URLs which are permitted to be opened from the configuration dialog. */
  configURLs: Array<Scalars['String']>;
  /** URLs which are permitted to be opened from an extension set as a panel. */
  panelURLs: Array<Scalars['String']>;
  /**
   * List of account IDs which should have access to a version of an extension.
   * Users in this list are ignored by the broadcaster whitelist check.
   */
  testers: Array<Scalars['ID']>;
};

/** HiddenView holds the view configuration of an extension if it is a hidden load test extension. */
export type SaveHiddenViewInput = {
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

/** LiveConfigViewInput holds the view configuration of an extension if the live config dashboard page is supported. */
export type SaveLiveConfigViewInput = {
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

/** MobileViewInput holds the view configuration of an extension if mobile is supported. */
export type SaveMobileViewInput = {
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

/** PanelViewInput holds the view configuration of an extension if the panel anchor is supported. */
export type SavePanelViewInput = {
  /** The extension developer configured height of the panel extension. */
  height: Scalars['Int'];
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

/** VideoOverlayViewInput holds the view configuration of an extension if the videoOverlay anchor is supported. */
export type SaveVideoOverlayViewInput = {
  /** Relative path of the HTML file to load for this view. */
  viewerPath: Scalars['String'];
};

/**
 * Sony Computer Entertainment (SCE) title properties.
 * Used as part of stream metadata for PlayStation.
 */
export type SceTitle = {
   __typename?: 'SCETitle';
  ageRating?: Maybe<Scalars['Int']>;
  attribute?: Maybe<Scalars['String']>;
  genre?: Maybe<Scalars['String']>;
  id?: Maybe<Scalars['ID']>;
  isPreset?: Maybe<Scalars['Boolean']>;
  language?: Maybe<Scalars['String']>;
  metadata?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
  presetText?: Maybe<Array<Maybe<Scalars['String']>>>;
  presetTextDescription?: Maybe<Scalars['String']>;
  productID?: Maybe<Scalars['String']>;
  sessionID?: Maybe<Scalars['String']>;
  shortName?: Maybe<Scalars['String']>;
  storeURL?: Maybe<Scalars['String']>;
};

/**
 * Sony Computer Entertainment (SCE) user properties.
 * Used as part of stream metadata for PlayStation.
 */
export type SceUser = {
   __typename?: 'SCEUser';
  country?: Maybe<Scalars['String']>;
  npID?: Maybe<Scalars['ID']>;
  onlineID?: Maybe<Scalars['ID']>;
};

/** The channel schedule. */
export type Schedule = {
   __typename?: 'Schedule';
  /** The ID of the schedule. */
  id: Scalars['ID'];
  /** A period during which scheduled events temporarily cease. */
  interruption?: Maybe<ScheduleInterruption>;
  /**
   * The next segment of the schedule. This will prepend 'next-' to the segmentID
   * because it has different behavior from segments returned in the 'segments' field.
   */
  nextSegment?: Maybe<ScheduleSegment>;
  /** The segments of the schedule. */
  segments?: Maybe<Array<ScheduleSegment>>;
};


/** The channel schedule. */
export type ScheduleSegmentsArgs = {
  utcOffsetMinutes?: Maybe<Scalars['Int']>;
  startingWeekday?: Maybe<Scalars['String']>;
};

/** The interruption of a schedule. */
export type ScheduleInterruption = {
   __typename?: 'ScheduleInterruption';
  /** The end time when the schedule will no longer be disabled. */
  endAt: Scalars['Time'];
  /** The reason the schedule is disabled. */
  reason: ScheduleInterruptionReason;
  /** The start time when the schedule will be disabled. */
  startAt: Scalars['Time'];
};

/** The reason of an interruption of a schedule. */
export enum ScheduleInterruptionReason {
  /** The user is on vacation. */
  Vacation = 'VACATION',
  /** Fallback value for reason unknown to the GQL schema. */
  Other = 'OTHER'
}

/** The segment of a schedule. */
export type ScheduleSegment = {
   __typename?: 'ScheduleSegment';
  /** The game categories tied to this segment. */
  categories?: Maybe<Array<Game>>;
  /** The end time of the segment. */
  endAt?: Maybe<Scalars['Time']>;
  /** The ID of the segment. */
  id: Scalars['ID'];
  /** If this segment is cancelled or not. */
  isCancelled: Scalars['Boolean'];
  /** The start time of the segment. */
  startAt: Scalars['Time'];
  /** The title of the segment. */
  title: Scalars['String'];
};

/** The days. */
export enum ScheduleSegmentDay {
  /** SUNDAY. */
  Sunday = 'SUNDAY',
  /** MONDAY. */
  Monday = 'MONDAY',
  /** TUESDAY. */
  Tuesday = 'TUESDAY',
  /** WEDNESDAY. */
  Wednesday = 'WEDNESDAY',
  /** THURSDAY. */
  Thursday = 'THURSDAY',
  /** FRIDAY. */
  Friday = 'FRIDAY',
  /** SATURDAY. */
  Saturday = 'SATURDAY'
}

/** Contains results for a searchFor query. */
export type SearchFor = {
   __typename?: 'SearchFor';
  /** Contains results for channels. */
  channels?: Maybe<SearchForResultUsers>;
  /** Contains results for games. */
  games?: Maybe<SearchForResultGames>;
  /** Contains results for live channels. */
  liveChannels?: Maybe<SearchForResultUsers>;
  /** Contains results for related live channels. */
  relatedLiveChannels?: Maybe<SearchForResultRelatedLiveChannels>;
  /** Contains results for users. */
  users?: Maybe<SearchForResultUsers>;
  /** Contains results for videos. */
  videos?: Maybe<SearchForResultVideos>;
};

/** SearchForOptions allows the user to target specific result types. */
export type SearchForOptions = {
  /** List of indices to run a user's query against. */
  targets?: Maybe<Array<SearchForTarget>>;
};

/** Contains game search results. */
export type SearchForResultGames = {
   __typename?: 'SearchForResultGames';
  /** Cursor for fetching the next page of results. */
  cursor?: Maybe<Scalars['String']>;
  /** List of matching game results. */
  items?: Maybe<Array<Game>>;
  /** Information about this page. */
  pageInfo: PageInfo;
  /** Order in which the result should be displayed. */
  score: Scalars['Int'];
  /** Total number of results. */
  totalMatches: Scalars['Int'];
};

/** Contains results for related live channels. */
export type SearchForResultRelatedLiveChannels = {
   __typename?: 'SearchForResultRelatedLiveChannels';
  /** List of matching user results. */
  items?: Maybe<Array<User>>;
  /** Optional score associated with the related live section. */
  score?: Maybe<Scalars['Int']>;
};

/** Contains user search results. */
export type SearchForResultUsers = {
   __typename?: 'SearchForResultUsers';
  /** Cursor for fetching the next page of results. */
  cursor?: Maybe<Scalars['String']>;
  /** List of matching user results. */
  items?: Maybe<Array<User>>;
  /** Information about this page. */
  pageInfo: PageInfo;
  /** Order in which the result should be displayed. */
  score: Scalars['Int'];
  /** Total number of results. */
  totalMatches: Scalars['Int'];
};

/** Contains video search results. */
export type SearchForResultVideos = {
   __typename?: 'SearchForResultVideos';
  /** Cursor for fetching the next page of results. */
  cursor?: Maybe<Scalars['String']>;
  /** List of matching video results. */
  items?: Maybe<Array<Video>>;
  /** Information about this page. */
  pageInfo: PageInfo;
  /** Order in which the result should be displayed. */
  score: Scalars['Int'];
  /** Total number of results. */
  totalMatches: Scalars['Int'];
};

/** Specify which index to run a user's search. */
export type SearchForTarget = {
  /** Pagination cursor for user to optionally provide to request a specific page of results. */
  cursor?: Maybe<Scalars['String']>;
  /** Search index to run a user's query against. */
  index: SearchIndex;
  /** Limit the number of results returned. */
  limit?: Maybe<Scalars['Int']>;
};

/** Enumeration of indexes a search query can target. */
export enum SearchIndex {
  /** Game index. */
  Game = 'GAME',
  /** User index. */
  User = 'USER',
  /** Video on demand index. */
  Vod = 'VOD',
  /** Live channel index. */
  Live = 'LIVE',
  /** Channel index. */
  Channel = 'CHANNEL'
}

/** SearchOptions to customize results returned by the search query. */
export type SearchOptions = {
  /**
   * List of indices to run a user's query against. If no targets are specified,
   * the query is run against all the indices listed in SearchIndex.
   */
  targets?: Maybe<Array<SearchTarget>>;
};

/** Contains the result returned by the search engine for a particular query. */
export type SearchResult = {
   __typename?: 'SearchResult';
  /** JSON encoded as a string. */
  result: Scalars['String'];
};

/** A search suggestion. */
export type SearchSuggestion = {
   __typename?: 'SearchSuggestion';
  /** Extra data for category or channel type of search suggestion. */
  content?: Maybe<SearchSuggestionContent>;
  /**
   * The part of the suggestion that matches the search query.
   * @deprecated Use 'matchingCharacters' instead.
   */
  highlight: SearchSuggestionHighlight;
  /** The search suggestion's unique identifier. */
  id: Scalars['ID'];
  /** The part of the suggestion that matches the search query. */
  matchingCharacters?: Maybe<SearchSuggestionHighlight>;
  /** The search suggestion string. */
  text: Scalars['String'];
};

/** A category search suggestion. */
export type SearchSuggestionCategory = {
   __typename?: 'SearchSuggestionCategory';
  /**
   * The boxart URL for the category, provided by the endpoint.
   * Use this field for lower latency.
   * 
   * The image dimensions are specifiable via the `height` and `width` parameters.
   * If `height` or `width` are not specified, the URL will contain
   * the template strings `{height}` and/or `{width}` in their respective places.
   */
  boxArtURL: Scalars['String'];
  /** The category. */
  game?: Maybe<Game>;
  /** The category's unique identifier. */
  id: Scalars['ID'];
};


/** A category search suggestion. */
export type SearchSuggestionCategoryBoxArtUrlArgs = {
  width?: Maybe<Scalars['Int']>;
  height?: Maybe<Scalars['Int']>;
};

/** A channel search suggestion. */
export type SearchSuggestionChannel = {
   __typename?: 'SearchSuggestionChannel';
  /** The channel's unique identifier. */
  id: Scalars['ID'];
  /**
   * Whether or not the channel is verified, provided by the endpoint.
   * Use this field for lower latency.
   */
  isVerified: Scalars['Boolean'];
  /**
   * The login of the channel, provided by the endpoint.
   * Use this field for lower latency.
   */
  login: Scalars['String'];
  /**
   * The profile image URL for the channel, provided by the endpoint.
   * Use this field for lower latency.
   * 
   * Valid widths are 28, 50, 70, 150, 300, and 600.
   * The image height will be the same as the given width.
   */
  profileImageURL?: Maybe<Scalars['String']>;
  /** The user of the channel. */
  user?: Maybe<User>;
};


/** A channel search suggestion. */
export type SearchSuggestionChannelProfileImageUrlArgs = {
  width: Scalars['Int'];
};

/** A list of search suggestions and related tracking data. */
export type SearchSuggestionConnection = {
   __typename?: 'SearchSuggestionConnection';
  /** The list of search suggestions. */
  edges?: Maybe<Array<SearchSuggestionEdge>>;
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  pageInfo: PageInfo;
  /** Tracking data for the search suggestions. */
  tracking?: Maybe<SearchSuggestionTracking>;
};

/** The types with additional content in a search suggestion. */
export type SearchSuggestionContent = SearchSuggestionCategory | SearchSuggestionChannel;

/** Edge containing the search suggestion. */
export type SearchSuggestionEdge = {
   __typename?: 'SearchSuggestionEdge';
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  cursor: Scalars['Cursor'];
  /** The search suggestion. */
  node: SearchSuggestion;
};

/** A range that matches the search query. */
export type SearchSuggestionHighlight = {
   __typename?: 'SearchSuggestionHighlight';
  /** The end of the match. */
  end: Scalars['Int'];
  /** The start of the match. */
  start: Scalars['Int'];
};

/** An object containing tracking data for a search suggestion. */
export type SearchSuggestionTracking = {
   __typename?: 'SearchSuggestionTracking';
  /** The unique identifier of the model instance. */
  modelTrackingID: Scalars['ID'];
  /** The unique identifier generated for every response. */
  responseID: Scalars['ID'];
};

/** Specify which index to run a user's search. */
export type SearchTarget = {
  /**
   * When true, response will return  the total number of matching documents in
   * index for a given query. The value for limit is ignored and assumed to be zero.
   */
  countTotalMatches?: Maybe<Scalars['Boolean']>;
  /** Search index to run a user's query against. */
  index: SearchIndex;
  /** Max number of matching documents that will be returned. */
  limit: Scalars['Int'];
};

/** Season metadata. */
export type SeasonDetails = {
   __typename?: 'SeasonDetails';
  /** Number of episodes. */
  episodeCount?: Maybe<Scalars['Int']>;
  /** The season number. */
  season?: Maybe<Scalars['Int']>;
};

/** Inputs for seeding a competition participant. */
export type SeedCompetitionParticipantInput = {
  /** ID of the competition. */
  competitionID: Scalars['ID'];
  /** ID of the competition player or competition team. */
  participantID: Scalars['ID'];
  /** The assigned seed value. */
  seedValue: Scalars['Int'];
};

/** SeedCompetitionParticipantPayload is the success response for seeding a competition player or competition team. */
export type SeedCompetitionParticipantPayload = {
   __typename?: 'SeedCompetitionParticipantPayload';
  /** The new state of competition after seeding a competition player or competition team. */
  competition?: Maybe<Competition>;
};

/** An enumeration of the statuses of suggested segments. */
export enum SegmentsStatusType {
  /** The suggested segments have successfully been created. */
  Completed = 'COMPLETED',
  /** There wasn't enough data to generate suggested segments. */
  NotEnoughData = 'NOT_ENOUGH_DATA',
  /** The vod is currently being processed for suggested segments. */
  InProgress = 'IN_PROGRESS',
  /** The backend failed to generate suggested segments. */
  Failed = 'FAILED'
}

/** The segment start time input. */
export type SegmentStartTimeInput = {
  /** The day of the segment. */
  day: ScheduleSegmentDay;
  /** The hour of the segment 0-23. */
  hour: Scalars['Int'];
  /** The minute of the segment 0-59. */
  minute: Scalars['Int'];
};

/** Inputs for selecting a channel badge. */
export type SelectChannelBadgeInput = {
  /** Set ID of the badge to select. */
  badgeSetID: Scalars['ID'];
  /** Optional Version of the Badge to select. */
  badgeSetVersion?: Maybe<Scalars['String']>;
  /** ID of the channel this badge is selected on. */
  channelID: Scalars['ID'];
};

/** The output for the select channel badge mutation. */
export type SelectChannelBadgePayload = {
   __typename?: 'SelectChannelBadgePayload';
  /** Indicates if selecting the badge was successful. */
  isSuccessful?: Maybe<Scalars['Boolean']>;
  /** The channel (user object of channel) this badge is selected on. */
  user?: Maybe<User>;
};

/** Inputs for selecting a global badge. */
export type SelectGlobalBadgeInput = {
  /** Set ID of the badge to select. */
  badgeSetID: Scalars['ID'];
  /** Optional Version of the Badge to select. */
  badgeSetVersion?: Maybe<Scalars['String']>;
};

/** The output for the select global badge mutation. */
export type SelectGlobalBadgePayload = {
   __typename?: 'SelectGlobalBadgePayload';
  /** Indicates if selecting the badge was successful. */
  isSuccessful?: Maybe<Scalars['Boolean']>;
  /** The user of the selected badge. */
  user?: Maybe<User>;
};

/** An interface to represent the logged in user's relationship to the claimable. */
export type SelfClaimEdge = {
  /** If the user is eligible to claim the object. */
  canClaim: Scalars['Boolean'];
  /** Nullable field for the country where the user redeemed the claimable. */
  countryOfResidence?: Maybe<Scalars['String']>;
  /** The user ID that is claiming. */
  id: Scalars['ID'];
  /** Nullable status code for if the user cannot claim the object. */
  statusCode?: Maybe<Scalars['String']>;
};

/** Input for sending a chat message through subscriber-only mode with Channel Points. */
export type SendChatMessageThroughSubscriberModeInput = {
  /** The channel the message is being sent to. */
  channelID: Scalars['ID'];
  /** The client's perception of the reward's cost. */
  cost: Scalars['Int'];
  /** The user's message. */
  message: Scalars['String'];
  /** Client-set identifier for the transaction. This ID should be universally unique. */
  transactionID: Scalars['ID'];
};

/** The response from redeeming the skip subs only chat message reward. */
export type SendChatMessageThroughSubscriberModePayload = {
   __typename?: 'SendChatMessageThroughSubscriberModePayload';
  /** The user's new Channel Points balance. */
  balance?: Maybe<Scalars['Int']>;
  /** The error that occurred during redemption, if any. */
  error?: Maybe<SendCopoMessageError>;
  /** Whether the message was flagged by Automod and held for review. */
  isHeldByAutomod?: Maybe<Scalars['Boolean']>;
};

export type SendCheerInput = {
  /** bits is the number of bits the message will spend (as parsed by the client). */
  bits: Scalars['Int'];
  /** content is the text to process and forward to the chat system. */
  content: Scalars['String'];
  /**
   * Client-generated unique ID used to prevent a cheer from being re-sent (thus spending double bits).
   * The server will reject any request with an ID that has already been used.
   */
  id: Scalars['ID'];
  /** Optional field that dictates the user wants their cheer to appear anonymously (i.e. unassociated with their username). */
  isAnonymous?: Maybe<Scalars['Boolean']>;
  /** Optional field that dictates whether automod should be enabled for the cheer or not. */
  isAutoModEnabled?: Maybe<Scalars['Boolean']>;
  /**
   * Optional field that dictates the cheer message was sent from a room, as this provides the context for what room
   * it was sent from.
   */
  roomID?: Maybe<Scalars['ID']>;
  /** Optional field that dictates that the user want to cheer anyways, even though they know it will be automodded. */
  shouldCheerAnyway?: Maybe<Scalars['Boolean']>;
  /** targetID is the `User.id` of the channel to send the cheer to. */
  targetID: Scalars['ID'];
};

export type SendCheerPayload = {
   __typename?: 'SendCheerPayload';
  /**
   * currentUser is the authenticated user object which includes the updated
   * `Wallet` info after the message bits have been spent.
   */
  currentUser?: Maybe<User>;
  /** id is the client-generated value passed in as part of the request. */
  id: Scalars['ID'];
  /** If any validation errors occur, this will not be nil. */
  validationError?: Maybe<SendCheerValidationError>;
};

/** Resolver for validation errors that occur on send cheer. */
export type SendCheerValidationError = {
   __typename?: 'SendCheerValidationError';
  /** Error code that describes the validation error. */
  code: SendCheerValidationErrorCode;
  /** Error message that is returned from the backend service. */
  message: Scalars['String'];
  /** Optional rejected message for when the error requires frontend message changes, like AutoMod'd messages. */
  messageContent?: Maybe<RoomMessageContent>;
};

/** Validation error status codes. */
export enum SendCheerValidationErrorCode {
  /** Bits amount is below the minimum. */
  AmountBelowMinBits = 'AMOUNT_BELOW_MIN_BITS',
  /** The message was auto modded. */
  AutoModMessage = 'AUTO_MOD_MESSAGE',
  /** The channel was ineligible for receiving bits. */
  ChannelIneligible = 'CHANNEL_INELIGIBLE',
  /** The emote amount was below the minimum bits emote amount. */
  EmoteAmountBelowMinBits = 'EMOTE_AMOUNT_BELOW_MIN_BITS',
  /** The user has insufficient balance. */
  InsufficientBalance = 'INSUFFICIENT_BALANCE',
  /** The bits amount is invalid. */
  InvalidBitsAmount = 'INVALID_BITS_AMOUNT',
  /** The bits message is invalid. */
  InvalidBitsMessage = 'INVALID_BITS_MESSAGE',
  /** The event ID is invalid, probably because it's been used. */
  InvalidEventId = 'INVALID_EVENT_ID',
  /** The message length is greater than the max message length. */
  MessageLengthExceeded = 'MESSAGE_LENGTH_EXCEEDED',
  /** The request has been throttled. */
  RequestThrottled = 'REQUEST_THROTTLED',
  /** The bits emotes that were sent were greater than the max allowed. */
  TooLargeBitsEmote = 'TOO_LARGE_BITS_EMOTE',
  /** The cheer was over the maximum cheer limit. */
  TooLargeCheer = 'TOO_LARGE_CHEER',
  /** An unknown error has occurred, but it was a validation error. */
  Unknown = 'UNKNOWN',
  /** The user is banned from bits. */
  UserBanned = 'USER_BANNED',
  /** The user is ineligible to send bits. */
  UserIneligible = 'USER_INELIGIBLE',
  /** The use is suspended from sending bits. */
  UserSuspended = 'USER_SUSPENDED',
  /** The message contained Zalgo text. */
  ZalgoMessage = 'ZALGO_MESSAGE',
  /** The message was not processed due to an automodded pending cheer. */
  AutoModPending = 'AUTO_MOD_PENDING',
  /** The message contained term(s) blocked by the channel. */
  ChannelBlockedTerms = 'CHANNEL_BLOCKED_TERMS',
  /** The anonymous message contained text that is invalid. */
  InvalidAnonymousMessage = 'INVALID_ANONYMOUS_MESSAGE',
  /** The bits message contained an anonymous cheermote when it's not allowed (ex: in public cheers). */
  AnonymousCheermoteNotAllowed = 'ANONYMOUS_CHEERMOTE_NOT_ALLOWED'
}

/** An error from redeeming a chat message Channel Points reward. */
export type SendCopoMessageError = {
   __typename?: 'SendCopoMessageError';
  /** The error code. */
  code?: Maybe<SendCopoMessageErrorCode>;
};

/** Possible errors from redeeming a chat message Channel Points reward. */
export enum SendCopoMessageErrorCode {
  /** User has previously sent an identical message. */
  MsgDuplicate = 'MSG_DUPLICATE',
  /** The user is suspended from Twitch. */
  UserSuspended = 'USER_SUSPENDED',
  /** The user is banned in the channel. */
  UserBanned = 'USER_BANNED',
  /** The user is timed out in the channel. */
  UserTimedOut = 'USER_TIMED_OUT',
  /** The chat is emote-only mode and the message contained text. */
  EmoteOnly = 'EMOTE_ONLY',
  /** The chat is in slow mode and the user has recently sent a message. */
  SlowMode = 'SLOW_MODE',
  /** The chat is in followers-only mode and the user has not been following long enough. */
  FollowersOnly = 'FOLLOWERS_ONLY',
  /** The chat is in followers-only mode and the user is not following. */
  FollowersOnlyZero = 'FOLLOWERS_ONLY_ZERO',
  /** The chat is in subs-only mode and the user is not subbed. */
  SubsOnly = 'SUBS_ONLY',
  /** The chat is in r9k-only mode (relatively unique messages) and the message was not unique. */
  R9KMode = 'R9K_MODE',
  /** The chat is in Blizzard connect mode and the user does not have their Blizzard account connected. */
  BlizzardConnectMode = 'BLIZZARD_CONNECT_MODE',
  /** The chat is in verified account mode and the user's account is not verified. */
  VerifiedAccount = 'VERIFIED_ACCOUNT',
  /** The user's message contained a blocked phrase. */
  ChannelSettings = 'CHANNEL_SETTINGS',
  /** The user's message was flagged by Automod and is being reviewed. */
  AutomodHeld = 'AUTOMOD_HELD',
  /** The user's message was rejected for another reason- possibly intentionally hidden, such as IP block. */
  MessageRejected = 'MESSAGE_REJECTED',
  /** The request failed due to an underlying server error. */
  ServerError = 'SERVER_ERROR',
  /** The user does not have sufficient points to redeem the reward. */
  InsufficientPoints = 'INSUFFICIENT_POINTS',
  /** The client is retrying a redemption with a transaction id that has already been redeemed. */
  TransactionAlreadyCommitted = 'TRANSACTION_ALREADY_COMMITTED',
  /** The client is retrying a redemption with a transaction id that is currently being redeemed in another request. */
  TransactionInProgress = 'TRANSACTION_IN_PROGRESS',
  /** The reward cost has changed since the user has tried to redeem it. */
  RewardCostMismatch = 'REWARD_COST_MISMATCH',
  /** The reward is currently disabled. */
  RewardDisabled = 'REWARD_DISABLED',
  /** The user is not allowed to redeem this reward on this channel. */
  RewardForbidden = 'REWARD_FORBIDDEN',
  /** The user's message starts with a '/' like a chat command. */
  MessageIsCommand = 'MESSAGE_IS_COMMAND',
  /** An unknown error occurred. */
  Unknown = 'UNKNOWN'
}

/** Input for sending a highlighted chat message with Channel Points. */
export type SendHighlightedChatMessageInput = {
  /** The channel the message is being sent to. */
  channelID: Scalars['ID'];
  /** The client's perception of the reward's cost. */
  cost: Scalars['Int'];
  /** The user's message. */
  message: Scalars['String'];
  /** Client-set identifier for the transaction. This ID should be universally unique. */
  transactionID: Scalars['ID'];
};

/** The response from redeeming the highlighted chat message reward. */
export type SendHighlightedChatMessagePayload = {
   __typename?: 'SendHighlightedChatMessagePayload';
  /** The user's new Channel Points balance. */
  balance?: Maybe<Scalars['Int']>;
  /** The error that occurred during redemption, if any. */
  error?: Maybe<SendCopoMessageError>;
  /** Whether the message was flagged by Automod and held for review. */
  isHeldByAutomod?: Maybe<Scalars['Boolean']>;
};

export type SendRoomMessageError = {
   __typename?: 'SendRoomMessageError';
  code: SendRoomMessageErrorCode;
  /**
   * On SLOW_MODE_ENFORCEMENT_FAILED, USER_CHAT_TIMED_OUT: the number of remaining
   * seconds user must wait before sending another message.
   */
  remainingDurationSeconds?: Maybe<Scalars['Int']>;
  /** On SLOW_MODE_ENFORCEMENT_FAILED: the number of seconds users must wait in between sending messages. */
  slowModeDurationSeconds?: Maybe<Scalars['Int']>;
};

export enum SendRoomMessageErrorCode {
  /** User not allowed to chat in room. */
  Forbidden = 'FORBIDDEN',
  /** Message failed automod check. */
  AutoModEnforcementFailed = 'AUTO_MOD_ENFORCEMENT_FAILED',
  /** Room is in emotes only mode and message contained non-emote text. */
  EmoteOnlyModeEnforcementFailed = 'EMOTE_ONLY_MODE_ENFORCEMENT_FAILED',
  /** Room is in R9K mode and message was not unique. */
  R9KModeEnforcementFailed = 'R9K_MODE_ENFORCEMENT_FAILED',
  /** User is rate limited. */
  RateLimitFailed = 'RATE_LIMIT_FAILED',
  /** Room is in slow mode and user tried to send a message to quickly. */
  SlowModeEnforcementFailed = 'SLOW_MODE_ENFORCEMENT_FAILED',
  /** Message failed spam check. */
  SpamEnforcementFailed = 'SPAM_ENFORCEMENT_FAILED',
  /** Message contained zalgo characters. */
  ZalgoEnforcementFailed = 'ZALGO_ENFORCEMENT_FAILED',
  /** User is banned in the channel. */
  UserChatBanned = 'USER_CHAT_BANNED',
  /** User is timed out in the channel. */
  UserChatTimedOut = 'USER_CHAT_TIMED_OUT',
  /** User is suspended from Twitch. */
  UserSuspended = 'USER_SUSPENDED'
}

export type SendRoomMessageInput = {
  message: Scalars['String'];
  /** Optional nonce which will be included in the pubsub event for this message. */
  nonce?: Maybe<Scalars['String']>;
  roomID: Scalars['ID'];
};

export type SendRoomMessagePayload = {
   __typename?: 'SendRoomMessagePayload';
  error?: Maybe<SendRoomMessageError>;
  message?: Maybe<RoomMessage>;
};

/** Error code for when a mutation fails. */
export type SendWhisperError = {
   __typename?: 'SendWhisperError';
  /** Error code for the failed whisper send. */
  code: SendWhisperErrorCode;
};

/** Possible errors returned by the sendWhisper mutation. */
export enum SendWhisperErrorCode {
  /** Target is banned. */
  TargetBanned = 'TARGET_BANNED',
  /** Message body is empty. */
  BodyEmpty = 'BODY_EMPTY',
  /** Target's settings prevent them from receiving message. */
  TargetRestricted = 'TARGET_RESTRICTED',
  /** Sender does not have a verified account. */
  SenderNotVerified = 'SENDER_NOT_VERIFIED',
  /** Whisper was not delivered for an unspecified reason. */
  NotDelivered = 'NOT_DELIVERED'
}

export type SendWhisperInput = {
  /** Message to send to user. */
  message: Scalars['String'];
  /** Random string generated by the client and should be unique across messages. */
  nonce: Scalars['String'];
  /** User to send a whisper to. */
  recipientUserID: Scalars['ID'];
};

export type SendWhisperPayload = {
   __typename?: 'SendWhisperPayload';
  /** If an error occurred, the error code. Otherwise null. */
  error?: Maybe<SendWhisperError>;
  /** The message that was sent, or null if there was an error. */
  message?: Maybe<WhisperMessage>;
};

/** Series metadata. */
export type SeriesDetails = {
   __typename?: 'SeriesDetails';
  /** Number of seasons. */
  seasonCount?: Maybe<Scalars['Int']>;
};

/** SetAutohostChannelsInput sets the user's list to autohost. */
export type SetAutohostChannelsInput = {
  /** ChannelIDs that will be on the list to autohost. */
  channelIDs: Array<Scalars['ID']>;
  /** UserID to update autohost list for. */
  userID: Scalars['ID'];
};

/** SetAutohostChannelsPayload returns the user whose autohostChannels field had been updated. */
export type SetAutohostChannelsPayload = {
   __typename?: 'SetAutohostChannelsPayload';
  /** User whose autohostChannels field had been updated. */
  user?: Maybe<User>;
};

/** Input for setting auto refill settings. */
export type SetAutoRefillSettingsInput = {
  /** The charge instrument information for starting a purchase. */
  chargeInstrument: ChargeInstrumentInput;
  /** The currency this should be charged in. */
  currency: Currency;
  /** The gross amount (of currency) that can be charged on the charge instrument. */
  grossAmount: Scalars['Int'];
  /** Optional id of the auto refill settings that are being modified. */
  id?: Maybe<Scalars['ID']>;
  /** Indicates if the profile is active. */
  isEnabled: Scalars['Boolean'];
  /** Id of the refill offer used on auto refill. */
  offerID: Scalars['ID'];
  /** The threshold amount a balance must go below to trigger a reload. */
  threshold: Scalars['Int'];
};

/** The payload for the set auto refill settings mutation. */
export type SetAutoRefillSettingsPayload = {
   __typename?: 'SetAutoRefillSettingsPayload';
  /** The changed auto refill profile. */
  autoRefillProfile?: Maybe<AutoRefillProfile>;
};

/** Input for the set bits user settings mutation. */
export type SetBitsUserSettingsInput = {
  /** Optional field that dictates whether a user has exited out of the first cheer tutorial by clicking out of the experience. */
  abandonedFirstCheerTutorial?: Maybe<Scalars['Boolean']>;
  /** Optional field that dictates whether a user has skipped the first cheer tutorial by clicking the skip button. */
  skippedFirstCheerTutorial?: Maybe<Scalars['Boolean']>;
};

/** Payload for set bits user settings mutation. */
export type SetBitsUserSettingsPayload = {
   __typename?: 'SetBitsUserSettingsPayload';
  /**
   * currentUser is the authenticated user object which includes the updated
   * `Wallet` info after the message bits have been spent.
   */
  currentUser?: Maybe<User>;
};

export type SetChannelFeedEnabledInput = {
  /** The new desired value for channel_feed_enabled. */
  enabled: Scalars['Boolean'];
};

export type SetChannelFeedEnabledPayload = {
   __typename?: 'SetChannelFeedEnabledPayload';
  /** The user whose channel feed setting was toggled. */
  user: User;
};

export type SetChannelNotificationSettingInput = {
  category: Scalars['String'];
  channelID: Scalars['ID'];
  platform: Scalars['String'];
  settingState: Scalars['String'];
};

export type SetChannelNotificationSettingPayload = {
   __typename?: 'SetChannelNotificationSettingPayload';
  settingState: Scalars['String'];
};

/** SetChannelTrailerErrorCode are the types of errors that the setChannelTrailer mutation may return. */
export enum SetChannelTrailerErrorCode {
  /** The caller is not authorized to update the user's trailer settings. */
  Unauthorized = 'UNAUTHORIZED',
  /** The vod is longer than 60 seconds (max time for channel trailers). */
  VodTooLong = 'VOD_TOO_LONG'
}

/** Inputs to the setChannelTrailer mutation. */
export type SetChannelTrailerInput = {
  /** The channel whose trailer should be updated. */
  channelID: Scalars['ID'];
  /**
   * The ID of the video that should be used as the channel's trailer,
   * or null if the trailer should be cleared.
   */
  trailerVideoID?: Maybe<Scalars['ID']>;
};

/** Output of the setChannelTrailer mutation. */
export type SetChannelTrailerPayload = {
   __typename?: 'SetChannelTrailerPayload';
  /** The channel whose trailer vod was modified. */
  channel?: Maybe<Channel>;
  /** The error if the mutation failed in an expected way, or null if the mutation was successful. */
  error?: Maybe<SetChannelTrailerErrorCode>;
};

/** The required input to set a user's chat pause setting. */
export type SetChatPauseSettingInput = {
  /** The desired method for a user to pause chat. */
  chatPauseSetting: ChatPauseSetting;
};

/** Result of a setChatPauseSetting mutation. */
export type SetChatPauseSettingPayload = {
   __typename?: 'SetChatPauseSettingPayload';
  /** The newly saved chat pause setting. */
  chatPauseSetting?: Maybe<ChatPauseSetting>;
};

/** Update tags associated with CLIP, STREAM, or VOD with contentID. */
export type SetContentTagsInput = {
  /** ID of the channel owning the content. */
  authorID: Scalars['ID'];
  /** ID of content: Channel ID for Streams, Slugs for Clips, and VOD ids for VODs. */
  contentID: Scalars['ID'];
  /** Type of content being returned. Can only be of values CLIP, STREAM, or VOD. */
  contentType: ContentType;
  /** List of tag IDs to be replaced from the content. */
  tagIDs: Array<Scalars['ID']>;
};

/** Result of mutation is the contentID. */
export type SetContentTagsPayload = {
   __typename?: 'SetContentTagsPayload';
  /** Content which tags have been updated. */
  content?: Maybe<TaggedContent>;
};

/** SetDashboardAlertQueueActivityStatusError is the error associated with SetDashboardAlertQueueActivityStatus. */
export type SetDashboardAlertQueueActivityStatusError = {
   __typename?: 'SetDashboardAlertQueueActivityStatusError';
  /** The associated error code. */
  code: SetDashboardAlertQueueActivityStatusErrorCode;
};

/** SetDashboardAlertQueueActivityStatusErrorCode are the possible errors that this mutation returns. */
export enum SetDashboardAlertQueueActivityStatusErrorCode {
  /** The input activity ID is invalid. */
  InvalidActivityId = 'INVALID_ACTIVITY_ID',
  /** The input alert status is invalid. */
  InvalidAlertStatus = 'INVALID_ALERT_STATUS',
  /** The input channel ID is invalid. */
  InvalidChannelId = 'INVALID_CHANNEL_ID',
  /** The alert is not found. */
  NotFound = 'NOT_FOUND'
}

/** Inputs to the SetDashboardAlertQueueActivityStatus mutation. */
export type SetDashboardAlertQueueActivityStatusInput = {
  /** The ID corresponding to the activity whose alert queue activity status should be updated. */
  activityID: Scalars['ID'];
  /** The value to set the status to. */
  alertStatus: DashboardActivityFeedActivityAlertStatus;
  /** The ID corresponding to the user whose alert queue activity status should be updated. */
  userID: Scalars['ID'];
};

/** Outputs from the SetDashboardAlertQueueActivityStatus mutation. */
export type SetDashboardAlertQueueActivityStatusPayload = {
   __typename?: 'SetDashboardAlertQueueActivityStatusPayload';
  /** The updated activity. */
  activity?: Maybe<DashboardActivityFeedActivity>;
  /** The possible error returned from the service. */
  error?: Maybe<SetDashboardAlertQueueActivityStatusError>;
};

/** SetDashboardAlertQueuePreferenceError is the error associated with SetDashboardAlertQueuePreference. */
export type SetDashboardAlertQueuePreferenceError = {
   __typename?: 'SetDashboardAlertQueuePreferenceError';
  /** The associated error code. */
  code: SetDashboardAlertQueuePreferenceErrorCode;
};

/** SetDashboardAlertQueuePreferenceErrorCode are the possible errors that this mutation returns. */
export enum SetDashboardAlertQueuePreferenceErrorCode {
  /** The input channel ID is invalid. */
  InvalidChannelId = 'INVALID_CHANNEL_ID'
}

/** Inputs to the SetDashboardAlertQueuePreference mutation. Only one of the boolean settings should be set at once. */
export type SetDashboardAlertQueuePreferenceInput = {
  /** If true, cannot publish alerts to the user. */
  shouldEnableDNDMode?: Maybe<Scalars['Boolean']>;
  /** If true, cannot publish bits alerts to the user. */
  shouldHideBits?: Maybe<Scalars['Boolean']>;
  /** If true, cannot publish follows alerts to the user. */
  shouldHideFollows?: Maybe<Scalars['Boolean']>;
  /** If true, cannot publish subscription gift alerts to the user. */
  shouldHideGiftSubscriptions?: Maybe<Scalars['Boolean']>;
  /** If true, cannot publish hosts alerts to the user. */
  shouldHideHosts?: Maybe<Scalars['Boolean']>;
  /** If true, cannot publish raids alerts to the user. */
  shouldHideRaids?: Maybe<Scalars['Boolean']>;
  /** If true, cannot publish regular subscriptions alerts to the user (gift subs are still shown). */
  shouldHideSubscriptions?: Maybe<Scalars['Boolean']>;
  /** The ID corresponding to the user whose alert queue preference should be updated. */
  userID: Scalars['ID'];
};

/** Outputs from the SetDashboardAlertQueuePreference mutation. */
export type SetDashboardAlertQueuePreferencePayload = {
   __typename?: 'SetDashboardAlertQueuePreferencePayload';
  /** The possible error returned from the service. */
  error?: Maybe<SetDashboardAlertQueuePreferenceError>;
  /** The updated preferences for dashboard alert queue. */
  preferences?: Maybe<DashboardAlertQueuePreferences>;
};

/** Enumerates possible errors when setting a default payment method. */
export enum SetDefaultPaymentMethodErrorCode {
  /** Must have auth credentials to set default payment method. */
  Unauthenticated = 'UNAUTHENTICATED',
  /** User does not have permission to set default payment method for the targeted user. */
  Forbidden = 'FORBIDDEN',
  /** One or more fields are invalid or missing. */
  InvalidRequest = 'INVALID_REQUEST',
  /** An internal error has occurred. */
  InternalError = 'INTERNAL_ERROR'
}

/** The input to be provided to the setDefaultPaymentMethod mutation. */
export type SetDefaultPaymentMethodInput = {
  /** Country (ISO-3166) associated to the billing info for the customer's payment method. */
  billingCountry?: Maybe<Scalars['String']>;
  /** Payment type used via the payment provider. */
  paymentType: PaymentInstrumentType;
  /** The payment provider we're updating the payment method on. */
  provider: PaymentProvider;
  /** The token used to verify the selected payment method. */
  token: Scalars['String'];
  /** The user to set default payment method for. */
  userID: Scalars['ID'];
};

/** The result of the setDefaultPaymentMethod mutation. */
export type SetDefaultPaymentMethodPayload = {
   __typename?: 'SetDefaultPaymentMethodPayload';
  /** Code to describe error that occurred while setting the default payment method. */
  errorCode?: Maybe<SetDefaultPaymentMethodErrorCode>;
  /** User who had their payment method updated. */
  user?: Maybe<User>;
};

/** The required input to set a user's deleted message display setting. */
export type SetDeletedMessageDisplaySettingInput = {
  /** The desired deleted message display setting to be saved. */
  deletedMessageDisplaySetting: DeletedMessageDisplaySetting;
};

/** Result of a setDeletedMessageDisplaySetting mutation. */
export type SetDeletedMessageDisplaySettingPayload = {
   __typename?: 'SetDeletedMessageDisplaySettingPayload';
  /** The newly saved deleted message display setting. */
  deletedMessageDisplaySetting?: Maybe<DeletedMessageDisplaySetting>;
};

/** Possible errors from this mutation. */
export type SetEmoteModifierGroupsError = {
   __typename?: 'SetEmoteModifierGroupsError';
  /** Error code from the mutation. */
  code: SetEmoteModifierGroupsErrorCode;
};

/** Possible error codes from this mutation. */
export enum SetEmoteModifierGroupsErrorCode {
  /** An unexpected internal server error occurred. */
  InternalServerError = 'INTERNAL_SERVER_ERROR',
  /** The provided input is invalid. */
  InvalidArgument = 'INVALID_ARGUMENT',
  /** The user is not authorized to set emote modifiers. */
  UserUnauthorized = 'USER_UNAUTHORIZED',
  /** Unknown error returned from service. */
  Unknown = 'UNKNOWN'
}

/** SetEmoteModifierGroupsInput is the input required when a creator sets their emote modifiers. */
export type SetEmoteModifierGroupsInput = {
  /** Emote modifier groups to set. */
  groups: Array<EmoteModifierGroupInput>;
};

/** The result of setting emote modifier groups for a user. */
export type SetEmoteModifierGroupsPayload = {
   __typename?: 'SetEmoteModifierGroupsPayload';
  /** Error from the mutation if it exists. */
  error?: Maybe<SetEmoteModifierGroupsError>;
  /** The modified emote groups that were set. */
  groups?: Maybe<Array<EmoteModifierGroupPayload>>;
};

/** SetExtensionFeatureFlagsError is wrapper for error associated with the setExtensionFeatureFlags mutation. */
export type SetExtensionFeatureFlagsError = {
   __typename?: 'SetExtensionFeatureFlagsError';
  /** Error code. */
  code: SetExtensionFeatureFlagsErrorCode;
  /** The missing installation id if got EXTENSION_NOT_INSTALLED error. */
  missingInstallationID?: Maybe<Scalars['ID']>;
};

/** SetExtensionFeatureFlagsErrorCode is an error code associated with SetExtensionFeatureFlagsError. */
export enum SetExtensionFeatureFlagsErrorCode {
  /** User is unable to make modifications to the extension. */
  Unauthorized = 'UNAUTHORIZED',
  /** Channel id is invalid, for example, is empty. */
  InvalidChannelId = 'INVALID_CHANNEL_ID',
  /** The extension is not installed on the channel. */
  ExtensionNotInstalled = 'EXTENSION_NOT_INSTALLED'
}

/** The required input to set feature flags for an installation. */
export type SetExtensionFeatureFlagsInput = {
  /** Optional value to enable/disable chat for the specified installation. */
  canSendChat?: Maybe<Scalars['Boolean']>;
  /** Optional value to enable/disable bits for the specified installation. */
  canUseBits?: Maybe<Scalars['Boolean']>;
  /** Optional value for dynamicManagement flag on games. */
  dynamicManagement?: Maybe<Array<Maybe<ExtensionDynamicManagementInput>>>;
  /** The ID of the extension installation to set feature flags for. */
  id: Scalars['ID'];
};

/** The result of setting feature flags on an installation. */
export type SetExtensionFeatureFlagsPayload = {
   __typename?: 'SetExtensionFeatureFlagsPayload';
  /** The error when the mutation fails to set feature flags. */
  error?: Maybe<SetExtensionFeatureFlagsError>;
  /** The new state of the installation after the setExtensionFeatureFlags mutation. */
  installedExtension?: Maybe<ExtensionInstallation>;
};

/** The required input to set oauth on an installation. */
export type SetExtensionInstallationOAuthInput = {
  /** The installation ID we're setting the oauth token for. */
  id: Scalars['ID'];
  /** The OAuth token created for the extension. */
  oauthToken: Scalars['String'];
};

/** The resulting installedExtension state after setting OAuth. */
export type SetExtensionInstallationOAuthPayload = {
   __typename?: 'SetExtensionInstallationOAuthPayload';
  /** The new state of the installation after the setExtensionInstallationOAuth mutation. */
  installedExtension?: Maybe<ExtensionInstallation>;
};

/** The required input to set a role's moderator logs' access. */
export type SetModLogsAccessInput = {
  /** The access level to moderator logs to be given to the role. */
  accessLevel: ModLogsAccessLevel;
  /** The Channel for which to set moderator log access. */
  channelID: Scalars['ID'];
  /** The user role for which to set the moderator log access permission. */
  channelRole: ChannelUserRole;
};

/** Result of a setModLogsAccess mutation. */
export type SetModLogsAccessPayload = {
   __typename?: 'SetModLogsAccessPayload';
  /** The access level of the role set. */
  modLogsAccess?: Maybe<ModLogsAccess>;
};

/** The required input to set a user's mod view settings relating to turorial. */
export type SetModViewSettingsInput = {
  /** The time the tutorial on the mod view page was seen. */
  tutorialSeenAt: Scalars['Time'];
  /** The viewed state of the tutorial on the mod view page. */
  tutorialState: TutorialState;
};

/** Result of a setModViewSettings mutation. */
export type SetModViewSettingsPayload = {
   __typename?: 'SetModViewSettingsPayload';
  /** The newly resolved modviewsettings resolver. */
  modViewSettings?: Maybe<ModViewSettings>;
};

export type SetNotificationSettingInput = {
  category: Scalars['String'];
  platform: Scalars['String'];
  settingState: Scalars['String'];
};

export type SetNotificationSettingPayload = {
   __typename?: 'SetNotificationSettingPayload';
  settingState: Scalars['String'];
};

/** SetOverwatchLeagueTeamPreferenceInput contains the OverwatchLeagueTeamPreference ID to set. */
export type SetOverwatchLeagueTeamPreferenceInput = {
  /** The channelID from the channel this event is taking place on. */
  OverwatchTeamPreferenceOptionID: Scalars['ID'];
};

/**
 * SetOverwatchLeagueTeamPreferencePayload is the success response for setting an Overwatch League Team preference, and
 * the corresponding updated OverwatchLeagueTeamPreference struct.
 */
export type SetOverwatchLeagueTeamPreferencePayload = {
   __typename?: 'SetOverwatchLeagueTeamPreferencePayload';
  /** A possible error returned from the service. */
  error?: Maybe<SetOverwatchTeamPreferenceError>;
  /** The updated OverwatchLeagueTeamPreference struct. */
  overwatchLeagueTeamPreference?: Maybe<OverwatchLeagueTeamPreference>;
};

/** Error code for an error that occurs while claiming the bounty. */
export type SetOverwatchTeamPreferenceError = {
   __typename?: 'SetOverwatchTeamPreferenceError';
  /** Error code for error that occurred while claiming the bounty. */
  code: SetOverwatchTeamPreferenceErrorCode;
};

/** Error types recognized by the SetOverwatchLeagueTeamPreference mutation. */
export enum SetOverwatchTeamPreferenceErrorCode {
  /** Unknown error being returned from service. */
  Unknown = 'UNKNOWN'
}

/** The required input for a setPreferredLanguageTag mutation. */
export type SetPreferredLanguageTagInput = {
  /** The preferred language tag to set onto the user. */
  preferredLanguageTag: LanguageTag;
  /** The user to modify. */
  userID: Scalars['ID'];
};

/** The result of a setPreferredLanguageTag mutation. */
export type SetPreferredLanguageTagPayload = {
   __typename?: 'SetPreferredLanguageTagPayload';
  /** The user whose preferred language tag was changed. */
  user?: Maybe<User>;
};

/** Possible errors associated with the SetQuickActionLAyout mutation. */
export type SetQuickActionLayoutError = {
   __typename?: 'SetQuickActionLayoutError';
  /** The error code of a possible error when setting a layout. */
  code?: Maybe<SetQuickActionLayoutErrorCode>;
};

/** Possible errors that this mutation can return. */
export enum SetQuickActionLayoutErrorCode {
  /** The input channel ID is invalid. */
  InvalidChannelId = 'INVALID_CHANNEL_ID',
  /** The input owner ID is invalid. */
  InvalidOwnerId = 'INVALID_OWNER_ID',
  /** One of the input quick actions IDs is invalid/does not exist. */
  InvalidQuickActionId = 'INVALID_QUICK_ACTION_ID'
}

/** Represents a folder input. */
export type SetQuickActionLayoutFolderInput = {
  /**
   * A list of quick action inputs in the folder. This can include nested folders.
   * A max nesting level is implemented in the resolver and the service.
   */
  items: Array<SetQuickActionLayoutItemInput>;
  /** The name of the folder. */
  name: Scalars['String'];
};

/** Inputs to the SetQuickActionLayout mutation. */
export type SetQuickActionLayoutInput = {
  /** The ID corresponding to the stream manager owner in which the layout appears. */
  channelID: Scalars['ID'];
  /** Quick action items, input in the order they should appear on the quick actions panel. */
  layout: Array<SetQuickActionLayoutItemInput>;
  /** The ID corresponding to the owner of the layout. */
  ownerID: Scalars['ID'];
};

/**
 * Each input item in the input array. Only one of these fields can
 * be specified at the same time (a layout item can only be a folder or
 * a quick action).
 */
export type SetQuickActionLayoutItemInput = {
  /** The input folder. */
  folder?: Maybe<SetQuickActionLayoutFolderInput>;
  /** The input quick action. */
  quickAction?: Maybe<SetQuickActionLayoutQuickActionInput>;
};

/** Outputs from the SetQuickActionLayout mutation. */
export type SetQuickActionLayoutPayload = {
   __typename?: 'SetQuickActionLayoutPayload';
  /** The possible error returned from the layout service. */
  error?: Maybe<SetQuickActionLayoutError>;
  /** Available quick actions, returned in the order they should be rendered. */
  layout?: Maybe<QuickActionLayout>;
};

/** Represents a quick action input. */
export type SetQuickActionLayoutQuickActionInput = {
  /** The ID of the item. Quick action IDs are represented by their canonical names. */
  name: QuickActionName;
};

/** The required input to set a user's readable chat colors setting. */
export type SetReadableChatColorsEnabledInput = {
  /** Whether readable chat colors should be enabled for the current user. */
  isReadableChatColorsEnabled: Scalars['Boolean'];
};

/** Result of a setReadableChatColorsEnabled mutation. */
export type SetReadableChatColorsEnabledPayload = {
   __typename?: 'SetReadableChatColorsEnabledPayload';
  /** Whether readable chat colors are enabled for the current user. */
  isReadableChatColorsEnabled: Scalars['Boolean'];
};

/** SetResourceRestrictionInput sets a restriction for the given resourceID. */
export type SetResourceRestrictionInput = {
  /** The ID of the resource to set the restriction on. */
  resourceID: Scalars['ID'];
  /** The type of resource that will be restricted. */
  resourceType: RestrictionResource;
  /** The restriction options, if any, to apply to the restriction being created. */
  restrictionOptions?: Maybe<Array<ResourceRestrictionOption>>;
  /** The type of restriction that should be placed onto the channel. If empty, the restriction will be deleted. */
  restrictionType?: Maybe<ResourceRestrictionType>;
};

/** SetResourceRestrictionPayload returns the updated restriction for a channel. */
export type SetResourceRestrictionPayload = {
   __typename?: 'SetResourceRestrictionPayload';
  /** The channel if a live resource restriction was updated. */
  channel?: Maybe<Channel>;
  /** The stream if a live resource restriction was updated. */
  stream?: Maybe<Stream>;
  /** The video if a video resource restriction was updated. */
  video?: Maybe<Video>;
};

/**
 * SetSessionStatusInput represents a user's status within a single session (browser tab, game, desktop application,
 * mobile application, etc.).
 */
export type SetSessionStatusInput = {
  /**
   * activity is the action the user is performing in your application. The purpose of an activity is to allow the user's
   * friends and related users to join in on whatever the user is doing. If the user is not performing any action that
   * other users can join in on (e.g. watching a VOD, browsing their settings page) or is not performing any action at
   * all, this should be set to null.
   */
  activity?: Maybe<ActivityInput>;
  /**
   * availability is the state of the user's session in your application. You should set it to ONLINE if the user is
   * known to be at their device, IDLE if they are not, and OFFLINE if your application is currently terminating.
   * 
   * Note that if your application fails to send an OFFLINE heartbeat before terminating, the session will automatically
   * expire after some time without a heartbeat.
   */
  availability: AvailabilityInput;
  /**
   * sessionID must be supplied and can be any string unique to this session. Generating a random UUID when your
   * application starts and sending it for each setSessionStatus is a good idea.
   * 
   * Each instance of your application should send the same ID for each of its setSessionStatus calls, but two instances
   * of your application running at the same time should never have the same session ID.
   */
  sessionID: Scalars['String'];
};

export type SetSessionStatusPayload = {
   __typename?: 'SetSessionStatusPayload';
  /**
   * The number of seconds your application should wait before sending another setSessionStatus. If your application does
   * not call setSessionStatus again within roughly this duration, it will be assumed to have terminated unexpectedly and
   * its session status for this user will expire.
   */
  setAgainInSeconds: Scalars['Int'];
  /** The modified user. */
  user?: Maybe<User>;
};

/** SetSocialMediaInput updates existing a social media item under the given channelID. */
export type SetSocialMediaPanelEnabledInput = {
  /** The unique channel identifier. */
  channelID: Scalars['ID'];
  /** Whether the social media panel is enabled. */
  isEnabled: Scalars['Boolean'];
};

/** SetSocialMediaPayload returns the updated social media. */
export type SetSocialMediaPanelEnabledPayload = {
   __typename?: 'SetSocialMediaPanelEnabledPayload';
  /** The updated channel. */
  channel?: Maybe<Channel>;
};

/** Inputs to the setSquadStreamPrimaryPlayer mutation. */
export type SetSquadStreamPrimaryPlayerInput = {
  /** ID of the device viewing squad stream. */
  deviceID: Scalars['ID'];
  /** ID of the channel as the current primary player. */
  primaryPlayerID: Scalars['ID'];
  /** ID of the squad stream. */
  squadID: Scalars['ID'];
};

/** Outputs to the setSquadStreamPrimaryPlayer mutation. */
export type SetSquadStreamPrimaryPlayerPayload = {
   __typename?: 'SetSquadStreamPrimaryPlayerPayload';
  /** The current primary player of the squad stream. */
  primaryPlayer?: Maybe<User>;
};

/** SetUserResidenceInput is input required to set a user's residence. */
export type SetUserResidenceInput = {
  /** User's country in ISO alpha-2. */
  countryCode: Scalars['String'];
  /** Target user for setting residence. */
  userID: Scalars['ID'];
  /** User's zip code. */
  zipCode?: Maybe<Scalars['String']>;
};

/** SetUserResidencePayload is the response from the SetUserResidence mutation. */
export type SetUserResidencePayload = {
   __typename?: 'SetUserResidencePayload';
  /** User whose residence was set for. */
  user?: Maybe<User>;
};

export type Share = {
   __typename?: 'Share';
  /** The user that created this share. */
  author?: Maybe<User>;
  /** Time the share was created by the user. */
  createdAt?: Maybe<Scalars['Time']>;
  /** Share ID. */
  id: Scalars['ID'];
  /** The item that was shared. */
  target?: Maybe<ShareTarget>;
};

export type ShareTarget = Clip | Post | Stream | Video;

/** An ordered list of content to render with metadata on the content. */
export type Shelf = {
   __typename?: 'Shelf';
  /** The ordered content for the shelf. */
  content: ShelfContentConnection;
  /** How to present the content in the shelf. */
  displayType: Scalars['String'];
  /** A unique identifier for the shelf for use in tracking and pagination. */
  id: Scalars['ID'];
  /** The title for the shelf. */
  title: ShelfTitle;
  /** Information used for recommendation tracking. */
  trackingInfo: TrackingInfo;
};

/**
 * Paginated list of Shelves. (pagination not yet implemented)
 * Implements the Relay cursor connections specification.
 * See: https://facebook.github.io/relay/graphql/connections.htm.
 */
export type ShelfConnection = {
   __typename?: 'ShelfConnection';
  /** The list of shelves to display. */
  edges?: Maybe<Array<ShelfEdge>>;
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  pageInfo: PageInfo;
};

/** The content to render in a shelf. */
export type ShelfContent = Clip | Game | Stream | Video;

/** The list of content to render in a shelf. */
export type ShelfContentConnection = {
   __typename?: 'ShelfContentConnection';
  /** The list of content to display. */
  edges?: Maybe<Array<ShelfContentEdge>>;
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  pageInfo: PageInfo;
};

/** The content to render in a shelf. */
export type ShelfContentEdge = {
   __typename?: 'ShelfContentEdge';
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  cursor: Scalars['Cursor'];
  /** The metadata to show for each content edge. */
  metadata?: Maybe<ShelfContentMetadata>;
  /** The underlying content to render. */
  node?: Maybe<ShelfContent>;
  /** Used in client tracking. */
  trackingID: Scalars['ID'];
};

/** The metadata for content to render in a shelf. */
export type ShelfContentMetadata = {
   __typename?: 'ShelfContentMetadata';
  /** Whether the content has a live event. */
  hasLive: Scalars['Boolean'];
  /** The localized subtitle for a content item in a shelf. */
  subtitle?: Maybe<ShelfTitle>;
  /** The localized title for a content item in a shelf. */
  title: ShelfTitle;
};

/**
 * Contains information about a Shelf's relationship to a given page (connection),
 * and the Shelf itself.
 */
export type ShelfEdge = {
   __typename?: 'ShelfEdge';
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  cursor: Scalars['Cursor'];
  /** The shelf. */
  node: Shelf;
};

/** The title for the shelf. */
export type ShelfTitle = {
   __typename?: 'ShelfTitle';
  /** A resource to interpolate into the title string. */
  context?: Maybe<ShelfTitleContext>;
  /** The fallback localized title, only to be used if client fails to parse the localizedTitleTokens. */
  fallbackLocalizedTitle: Scalars['String'];
  /** The name of the shelf being presented, used for backwards compatibility. Allows for localization and interpolation. */
  key: Scalars['String'];
  /** The localized shelf title in the form of a list of tokens. */
  localizedTitleTokens: Array<Maybe<TitleTokenEdge>>;
};

/** Metadata used to render the shelf title. */
export type ShelfTitleContext = Game;

/** A set of options for configuring which shelf data to return to the user. */
export type ShelvesAvailableOptions = {
  /**
   * The ID of the collection. Only valid when shelfType is set to
   * VideoShelfType.COLLECTION.
   */
  collectionID?: Maybe<Scalars['ID']>;
  /**
   * The ID of the game shelf to query. Only valid when shelfType is set to
   * VideoShelfType.GAME_VIDEOS.
   */
  gameID?: Maybe<Scalars['ID']>;
  /**
   * Which shelf type to query. Currently required.
   * In future, omitting this option returns all valid shelves.
   */
  shelfType?: Maybe<VideoShelfType>;
};

/** A set of options to configuring how the shelves data is returned to the consumer. */
export type ShelvesOptions = {
  /** Should indicate whether the response includes empty shelves. */
  includeEmpty?: Maybe<Scalars['Boolean']>;
};

/** The type representing Community Points Smart Costs Acknowledgements. */
export type SmartCostsAcknowledgement = {
   __typename?: 'SmartCostsAcknowledgement';
  /** The last acknowledged cost. */
  lastAcknowledgedCost: Scalars['Int'];
  /** The type of automatic reward the smart costs acknowledgement is for. */
  rewardType: CommunityPointsAutomaticRewardType;
};

/** The input representing Community Points Smart Costs Acknowledgements. */
export type SmartCostsAcknowledgementInput = {
  /** The last acknowledged cost. */
  lastAcknowledgedCost: Scalars['Int'];
  /** The type of automatic reward the smart costs acknowledgement is for. */
  rewardType: CommunityPointsAutomaticRewardType;
};

/** Wrapper around the standard emoticon groups for Prime Emoticons. */
export type SmiliesSet = {
   __typename?: 'SmiliesSet';
  /** The list of emotes which belong to this set. */
  emotes?: Maybe<Array<Emote>>;
  /** ID for the current smilies set. */
  id?: Maybe<Scalars['ID']>;
};

/** A social media item that is an attribute of Channel. */
export type SocialMedia = {
   __typename?: 'SocialMedia';
  /** The social media's unique identifier. */
  id: Scalars['ID'];
  /** The name of the domain which will be used to determine which favicon to render. */
  name?: Maybe<Scalars['String']>;
  /** The label displayed to the client. */
  title: Scalars['String'];
  /** The web address to a social media website. */
  url: Scalars['String'];
};

export type SocialStream = RecommendedStream & {
   __typename?: 'SocialStream';
  /** The friend who generated the recommendation. */
  friend?: Maybe<User>;
  /** The recommended stream. */
  stream?: Maybe<Stream>;
  /** The type of recommendation. Different types contain different metadata about why the recommendation was made. */
  type?: Maybe<StreamRecommendationType>;
};

/** Sort direction. */
export enum SortOrder {
  /** Ascending (A-Z, 1-9). */
  Asc = 'ASC',
  /** Descending (Z-A, 9-1). */
  Desc = 'DESC'
}

/** Error returned when attempting to spend subscription credit. */
export type SpendSubscriptionCreditError = {
   __typename?: 'SpendSubscriptionCreditError';
  /** Error code for error that occured while attempting to spend subscription credit. */
  code: SpendSubscriptionCreditErrorCode;
};

/** Possible error codes returned when attempting to spend subscription credit. */
export enum SpendSubscriptionCreditErrorCode {
  /** Occurs if a Twitch Prime user attempts to spend subscription credit that is (still) unavailable. */
  UnableToSpend = 'UNABLE_TO_SPEND',
  /** Occurs if a Twitch Prime user attempts to spend multiple times, acting as a flag for fraud. */
  TooManyRecentSpends = 'TOO_MANY_RECENT_SPENDS'
}

/** Input requires the broadcaster to be payed and user to deduct credit. */
export type SpendSubscriptionCreditInput = {
  /** The user id of streamer being subscribed to. */
  broadcasterID: Scalars['String'];
  /** Twitch user ID. */
  userID: Scalars['ID'];
};

/** Mutated data after spending the subscription credit. */
export type SpendSubscriptionCreditPayload = {
   __typename?: 'SpendSubscriptionCreditPayload';
  /** Possible error returned from the service. */
  error?: Maybe<SpendSubscriptionCreditError>;
  /** The modified subscription benefit data. */
  subscriptionBenefit?: Maybe<SubscriptionBenefit>;
  /** Twitch user ID. */
  userID: Scalars['ID'];
};

/** The connection of sponsored cheermote channel settings to user. */
export type SponsoredCheermoteChannelSettingsConnection = {
   __typename?: 'SponsoredCheermoteChannelSettingsConnection';
  /** The list of key pool edges associated with the user. */
  edges: Array<SponsoredCheermoteChannelSettingsEdge>;
  /** The metadata about having more key pools to fetch, or if there is a previous page of key pools. */
  pageInfo: PageInfo;
  /** The total number of key pools for the given user. */
  totalCount: Scalars['Int'];
};

/** The sponsored cheermote channel settings edge which contains our cursor and node. */
export type SponsoredCheermoteChannelSettingsEdge = {
   __typename?: 'SponsoredCheermoteChannelSettingsEdge';
  /** The cursor of the edge, which is also the key pool ID. */
  cursor: Scalars['Cursor'];
  /** The node of the edge, which contains all information about the key pool. */
  node?: Maybe<SponsoredCheermoteChannelSettingsNode>;
};

/** The information associated with a given sponsored cheermote channel setting. */
export type SponsoredCheermoteChannelSettingsNode = {
   __typename?: 'SponsoredCheermoteChannelSettingsNode';
  /** Brand's image to display, in the form of a URL. */
  brandImageURL: Scalars['String'];
  /** Brand name to display. */
  brandName: Scalars['String'];
  /** Time the campaign ends. */
  endTime: Scalars['Time'];
  /** The campaign ID, which is unique. */
  id: Scalars['ID'];
  /** The opt in status of the campaign. */
  isOptedIn: Scalars['Boolean'];
  /** Time the campaign starts. */
  startTime: Scalars['Time'];
  /** Thresholds for matching on sponsored cheering. */
  thresholds: Array<CheermoteCampaignThreshold>;
};

/**
 * A squad stream represents a group of broadcasters that are streaming together.  When a squad
 * stream is live, viewers can opt to watch the streams of all its members together from a
 * single view.
 * 
 * Squad streams are created by a broadcaster who invites other broadcasters to participate.
 * Each broadcaster who accepts an invitation becomes a member of the squad stream and can also
 * invite other broadcasters to participate.  At the moment, a squad stream can have up to
 * four members and a broadcaster can only belong to a single squad stream.
 * 
 * A squad stream ends when all its members leave or stop streaming.
 */
export type SquadStream = {
   __typename?: 'SquadStream';
  /** The ID of the squad stream. */
  id: Scalars['ID'];
  /** The invitations with the given status that have been sent by members to other users to join to squad stream. */
  invitations?: Maybe<Array<SquadStreamInvitation>>;
  /** Broadcasters who are currently participating in the squad stream. */
  members?: Maybe<Array<User>>;
  /** The owner can remove members from the squad stream. */
  owner?: Maybe<User>;
  /** The current status of the squad stream. */
  status: SquadStreamStatus;
};


/**
 * A squad stream represents a group of broadcasters that are streaming together.  When a squad
 * stream is live, viewers can opt to watch the streams of all its members together from a
 * single view.
 * 
 * Squad streams are created by a broadcaster who invites other broadcasters to participate.
 * Each broadcaster who accepts an invitation becomes a member of the squad stream and can also
 * invite other broadcasters to participate.  At the moment, a squad stream can have up to
 * four members and a broadcaster can only belong to a single squad stream.
 * 
 * A squad stream ends when all its members leave or stop streaming.
 */
export type SquadStreamInvitationsArgs = {
  status: SquadStreamInvitationStatus;
};

/** Determines who can send the user invitations to join a squad stream. */
export enum SquadStreamIncomingInvitePolicy {
  /** This user should never receive invitations. */
  None = 'NONE',
  /** This user can receive invitations from friends, teammates and followed channels. */
  Network = 'NETWORK',
  /** This user can receive invitations from anyone. */
  All = 'ALL'
}

/**
 * SquadStreamInvitation represents an invitation sent by a member of a squad stream to another user to
 * join the squad stream.
 */
export type SquadStreamInvitation = {
   __typename?: 'SquadStreamInvitation';
  /** When the invitation was created. */
  createdAt: Scalars['Time'];
  /** ID of the invitation. */
  id: Scalars['ID'];
  /**
   * Network type of the invitation. This field is only non nil when the invitation
   * is fetched for User.IncomingSquadStreamInvitations.
   */
  networkType?: Maybe<SquadStreamInvitationNetworkType>;
  /** If the invitation's status is rejected, the reason for the rejection. */
  reasonRejected?: Maybe<SquadStreamInvitationRejectedReason>;
  /** The user that the invitation is sent to. */
  recipient?: Maybe<User>;
  /** The user that sent the invitation. */
  sender?: Maybe<User>;
  /** The squad stream that the recipient is invited to join. */
  squadStream?: Maybe<SquadStream>;
  /** The status of the invitation. */
  status: SquadStreamInvitationStatus;
};

/** List of Squad Stream invitations. */
export type SquadStreamInvitationConnection = {
   __typename?: 'SquadStreamInvitationConnection';
  /** The elements of the list. */
  nodes?: Maybe<Array<SquadStreamInvitation>>;
  /** The total count of invitations. */
  totalCount?: Maybe<Scalars['Int']>;
};

/** Describes the network type of a squad stream invitation. */
export enum SquadStreamInvitationNetworkType {
  /** The invitation is from within the recipient's network (friends, teammates and followed channels). */
  InNetwork = 'IN_NETWORK',
  /** The invitation is from outside of the recipient's network. */
  OutOfNetwork = 'OUT_OF_NETWORK'
}

/** Describes the reason a squad stream invitation was rejected. */
export enum SquadStreamInvitationRejectedReason {
  /** The recipient rejected the invitation. */
  RecipientRejected = 'RECIPIENT_REJECTED',
  /** The recipient cannot access the squad stream product (e.g. due to missing transcode, partner-only launch). */
  RecipientCannotAccessSquadStream = 'RECIPIENT_CANNOT_ACCESS_SQUAD_STREAM',
  /** The recipient does not allow the sender of the invitation to invite them (e.g. due to their squad stream settings). */
  RecipientCannotBeInvited = 'RECIPIENT_CANNOT_BE_INVITED'
}

/** Describes the current state of a squad stream invitation. */
export enum SquadStreamInvitationStatus {
  /** The recipient has accepted the invitation. */
  Accepted = 'ACCEPTED',
  /** A squad stream owner has deleted the invitation. */
  Deleted = 'DELETED',
  /** The invitation has been sent to the recipient and the sender is waiting for a response. */
  Pending = 'PENDING',
  /** The recipient has rejected the invitation. */
  Rejected = 'REJECTED',
  /** The invitation has an unknown status. */
  Unknown = 'UNKNOWN'
}

/** A user's squad stream settings. */
export type SquadStreamSettings = {
   __typename?: 'SquadStreamSettings';
  /**
   * Denotes whether or not a user can access squad management features like
   * accepting/receiving invites and viewing the Squad Stream dashboard widget.
   */
  canAccessSquads: Scalars['Boolean'];
  /**
   * Determines who can send the user invitations to join a squad stream.
   * Resolves for anyone who can access the user's dashboard (editors, staff, etc.).
   */
  incomingInvitePolicy?: Maybe<SquadStreamIncomingInvitePolicy>;
};

/** Describes the status of a squad stream. */
export enum SquadStreamStatus {
  /** The squad stream is live and is being broadcast to viewers. */
  Live = 'LIVE',
  /** The squad stream is being set up, and should not be shown to viewers. */
  Pending = 'PENDING',
  /** The squad stream has ended. */
  Ended = 'ENDED',
  /** The squad stream has an unknown status. */
  Unknown = 'UNKNOWN'
}

/**
 * A link between a single sign-on (SSO) app and a Twitch account.
 * SSO apps are the Twitch apps on console and smart TV.
 */
export type SsoLink = {
   __typename?: 'SSOLink';
  /** The name of the SSO app that is linked to the authenticated user's Twitch account. */
  app?: Maybe<Scalars['String']>;
  /**
   * The identifier of the device or user account on XboxLive, PSN, etc.
   * that is linked to the authenticated user's Twitch account.
   */
  ssoID?: Maybe<Scalars['String']>;
};

/** StartAdError ... */
export type StartAdError = {
   __typename?: 'StartAdError';
  /** code is the code for the error that occurs while trying to run an ad break. */
  code: StartAdErrorCode;
};

/** StartAdErrorCode ... */
export enum StartAdErrorCode {
  /** The user has requested an ad break before the rate limit timer has expired. */
  RateLimited = 'RATE_LIMITED',
  /** The user is not authorized to run an ad break on the requested channel. */
  UserNotAuthorized = 'USER_NOT_AUTHORIZED',
  /** An unknown error occured while trying to run an ad break. */
  UnknownError = 'UNKNOWN_ERROR'
}

/** StartAdInput ... */
export type StartAdInput = {
  /** channelID is the ID of the channel the ad will run on. */
  channelID: Scalars['ID'];
  /** lengthSeconds is the requested ad break length in seconds (30s ad, 60s ad, etc). */
  lengthSeconds?: Maybe<Scalars['Int']>;
};

/** StartAdPayload ... */
export type StartAdPayload = {
   __typename?: 'StartAdPayload';
  /** adSession is the response object from an ad request. */
  adSession?: Maybe<AdSession>;
  /** error is the StartAdError object from a failed request. */
  error?: Maybe<StartAdError>;
};

/** Error code for an error that occurs while starting the bounty. */
export type StartBountyError = {
   __typename?: 'StartBountyError';
  /** Error code for error that occurred while starting the bounty. */
  code: StartBountyErrorCode;
};

/** Error types recognized. */
export enum StartBountyErrorCode {
  /** Invalid parameter in the request. */
  InvalidParameter = 'INVALID_PARAMETER',
  /** The bounty cannot be started because it is not live. */
  BountyNotLive = 'BOUNTY_NOT_LIVE',
  /** The stream title contains banned words. */
  StreamTitleBannedWords = 'STREAM_TITLE_BANNED_WORDS',
  /** The stream title is too long. */
  StreamTitleTooLong = 'STREAM_TITLE_TOO_LONG',
  /** The user is not authorized to start the bounty. */
  Unauthorized = 'UNAUTHORIZED',
  /** Unknown error being returned from service. */
  UnknownError = 'UNKNOWN_ERROR'
}

/** StartBountyInput includes the bounty a user is trying to start. */
export type StartBountyInput = {
  /** Unique Identifier for the bounty. */
  bountyID: Scalars['ID'];
  /** Title of the stream for the bounty. Must start with #sponsored. */
  title: Scalars['String'];
  /** UserID of the user that will start the bounty. */
  userID: Scalars['ID'];
};

/** Data that was mutated after starting the bounty. */
export type StartBountyPayload = {
   __typename?: 'StartBountyPayload';
  /** The possible error returned from the service. */
  error?: Maybe<StartBountyError>;
  /** The started bounty with the updated status. */
  startedBounty?: Maybe<Bounty>;
  /** The user that now has the started bounty. */
  user?: Maybe<User>;
};

/** StartPayoutOnboardingWorkflowInput returns the required input when starting a new workflow for payout onboarding. */
export type StartPayoutOnboardingWorkflowInput = {
  /** TargetUserID is the ID of the user whose workflow will be started. */
  targetUserID: Scalars['ID'];
};

/** StartPayoutOnboardingWorkflowPayload returns a new workflow when starting payout onboarding. */
export type StartPayoutOnboardingWorkflowPayload = {
   __typename?: 'StartPayoutOnboardingWorkflowPayload';
  /** A new workflow status. */
  workflow?: Maybe<PayoutOnboardingWorkflow>;
};

/** Input for starting a PV Watch Party. */
export type StartWatchPartyInput = {
  /** Amazon LWA access token. */
  accessToken: Scalars['String'];
  /** Channel ID of the creator. */
  channelID: Scalars['ID'];
  /** Catalog GTI to use. */
  watchPartyItemID: Scalars['ID'];
};

/** Returns the new Watch Party and all decoration/details. */
export type StartWatchPartyPayload = {
   __typename?: 'StartWatchPartyPayload';
  /** Error if the user's token expired. */
  error?: Maybe<WatchPartyError>;
  /** The watch party that was started. */
  watchParty?: Maybe<WatchParty>;
};

/** Error code for an error that occurs while stopping the bounty. */
export type StopBountyError = {
   __typename?: 'StopBountyError';
  /** Error code for error that occurred while stopping the bounty. */
  code: StopBountyErrorCode;
};

/** Error types recognized. */
export enum StopBountyErrorCode {
  /** Invalid parameter in the request. */
  InvalidParameter = 'INVALID_PARAMETER',
  /** The user is not authorized to stop the bounty. */
  Unauthorized = 'UNAUTHORIZED',
  /** Unknown error being returned from service. */
  UnknownError = 'UNKNOWN_ERROR'
}

/** StopBountyInput includes the bounty a user is trying to stop. */
export type StopBountyInput = {
  /** Unique Identifier for the bounty. */
  bountyID: Scalars['ID'];
  /** UserID of the user that will stop the bounty. */
  userID: Scalars['ID'];
};

/** Data that was mutated after stopping the bounty. */
export type StopBountyPayload = {
   __typename?: 'StopBountyPayload';
  /** The possible error returned from the service. */
  error?: Maybe<StopBountyError>;
  /** The stopped bounty with the updated status. */
  stoppedBounty?: Maybe<Bounty>;
  /** The user that now has the stopped bounty. */
  user?: Maybe<User>;
};

/** Input for stopping a PV Watch Party. */
export type StopWatchPartyInput = {
  /** Amazon LWA access token. */
  accessToken: Scalars['String'];
  /** Channel ID of the creator. */
  channelID: Scalars['ID'];
};

/** Returns LWA authentication errors. */
export type StopWatchPartyPayload = {
   __typename?: 'StopWatchPartyPayload';
  /** Error if the user's token expired. */
  error?: Maybe<WatchPartyError>;
  /** The watch party that was stopped. */
  watchParty?: Maybe<WatchParty>;
};

/** A live stream. */
export type Stream = {
   __typename?: 'Stream';
  /** The associated archive of the stream. */
  archiveVideo?: Maybe<Video>;
  averageFPS?: Maybe<Scalars['Float']>;
  bitrate?: Maybe<Scalars['Float']>;
  /** The language the stream is being broadcasted in. */
  broadcastLanguage?: Maybe<Language>;
  /** The user who is broadcasting the live stream. */
  broadcaster?: Maybe<User>;
  /** Software being used for the broadcast. */
  broadcasterSoftware?: Maybe<Scalars['String']>;
  /** @deprecated Channel fields have been merged into User. Use stream.broadcaster instead. */
  channel?: Maybe<Channel>;
  /** Number of clips created since stream start. */
  clipCount?: Maybe<Scalars['Int']>;
  codec?: Maybe<Scalars['String']>;
  /** The time streaming started. */
  createdAt?: Maybe<Scalars['Time']>;
  /**
   * The stream delay in seconds.
   * @deprecated Not a supported feature anymore.
   */
  delayLengthSeconds?: Maybe<Scalars['Int']>;
  /**
   * Information about what directories the stream is categorized in.
   * @deprecated This was made for Communities, but the feature is officially dead. Use 'game' instead
   */
  directories: Array<Maybe<Directory>>;
  /** Information about the game being streamed. */
  game?: Maybe<Game>;
  /** The height of the stream's video, in pixels. */
  height?: Maybe<Scalars['Int']>;
  /** The stream's unique identifier. */
  id: Scalars['ID'];
  /** Whether the stream is hidden from its directory. */
  isDirectoryHidden?: Maybe<Scalars['Boolean']>;
  /** Information about whether the channel is encrypted. */
  isEncrypted?: Maybe<Scalars['Boolean']>;
  /**
   * Whether the broadcaster has indicated the stream is intended for mature audiences only.
   * @deprecated Use broadcaster.broadcastSettings.isMature instead
   */
  isMature?: Maybe<Scalars['Boolean']>;
  /** Whether the broadcaster is partnered with Twitch. */
  isPartner?: Maybe<Scalars['Boolean']>;
  /**
   * Whether or not viewers of this stream can receive drops.
   * Note: Actually earning drops additionally requires that the game have an
   * active drops campaign and is done at the discretion of the developer.
   */
  isStreamDropsEnabled?: Maybe<Scalars['Boolean']>;
  /** The lanugage setting of the streaming user. */
  language?: Maybe<Language>;
  /** When the stream was last updated. */
  lastUpdatedAt?: Maybe<Scalars['Time']>;
  /**
   * The maximum height of the stream's video, in pixels.
   * @deprecated Not a supported feature anymore
   */
  maxHeight?: Maybe<Scalars['Int']>;
  /** Platform-specific (e.g. Xbox, PlayStation) metadata. */
  platform?: Maybe<Platform>;
  /**
   * A URL to a dynamically sized image.
   * If either `height` or `width` are not given, a templated value will be present instead.
   */
  previewImageURL?: Maybe<Scalars['String']>;
  /**
   * The restriction that is currently active on the channel for restricting a user's access to it.
   * @deprecated Use Channel.restriction for full restriction data or Stream.restrictionType for stream's restriction type
   */
  restriction?: Maybe<ResourceRestriction>;
  /** The list of restriction options that were applied in addition to the restriction type for this stream. */
  restrictionOptions: Array<ResourceRestrictionOption>;
  /** The type of restriction this stream currently has. */
  restrictionType?: Maybe<Scalars['String']>;
  /** self contains information on the relationship between the current user (anonymous or authenticated) and this stream. */
  self?: Maybe<StreamSelfConnection>;
  /**
   * Tags are used as a discovery and search mechanism for tags and tagged content.
   * The tag data may not be updated immediately after streamers update their tags.
   * Please use User.tags instead if you want real time data from Graffiti.
   * For example, you should use Stream.tags for the channel page and the browse page, but use User.tags for the dashboard.
   */
  tags?: Maybe<Array<Tag>>;
  /**
   * A user-defined title describing the stream.
   * @deprecated Title field in Users has been deprecated. Use broadcaster.broadcastSettings.title instead
   */
  title?: Maybe<Scalars['String']>;
  /** What type of stream this is (e.g. live, playlist, watch_party). */
  type?: Maybe<Scalars['String']>;
  /** The number of viewers currently watching the stream. */
  viewersCount?: Maybe<Scalars['Int']>;
  /** The width of the stream's video, in pixels. */
  width?: Maybe<Scalars['Int']>;
};


/** A live stream. */
export type StreamPreviewImageUrlArgs = {
  height?: Maybe<Scalars['Int']>;
  width?: Maybe<Scalars['Int']>;
};

/** StreamBitrate represents the bitrate of stream session by time. */
export type StreamBitrate = {
   __typename?: 'StreamBitrate';
  /** Time of recorded bitrate. */
  recordedAt: Scalars['Time'];
  /** Bitrate of video stream in Kbps. */
  valueKbps: Scalars['Float'];
};

/** Paginated list of Streams. */
export type StreamConnection = {
   __typename?: 'StreamConnection';
  edges?: Maybe<Array<Maybe<StreamEdge>>>;
  /** Used for tracking. */
  generationID?: Maybe<Scalars['ID']>;
  pageInfo?: Maybe<PageInfo>;
  /** Used for tracking. */
  responseID?: Maybe<Scalars['ID']>;
};

/**
 * Contains information about a Streams's relationship to a given page (connection),
 * and the Stream itself.
 */
export type StreamEdge = {
   __typename?: 'StreamEdge';
  cursor?: Maybe<Scalars['Cursor']>;
  node?: Maybe<Stream>;
  /** Unique id per stream response item, used by clients to attribute displays/clicks to items. */
  trackingID?: Maybe<Scalars['ID']>;
};

/** The type of streamer shelf to display. */
export enum StreamerShelfType {
  /** Shows the streamer's autohost list. */
  Autohost = 'AUTOHOST',
  /** Shows the streamer's team members. */
  Team = 'TEAM',
  /** Disables the shelf. */
  Disabled = 'DISABLED'
}

/** StreamFramerate represents the framerate of strem session by time. */
export type StreamFramerate = {
   __typename?: 'StreamFramerate';
  /** Time of recorded bitrate. */
  recordedAt: Scalars['Time'];
  /** Framerate of video stream in Frame Per Second. */
  valueFPS: Scalars['Float'];
};

export type Streaming = Activity & {
   __typename?: 'Streaming';
  /** The stream being broadcasted. */
  stream?: Maybe<Stream>;
  /** This activity's type, i.e. "STREAMING". */
  type?: Maybe<ActivityType>;
};

/** StreamKey represents a RTMP stream key with its expiration date. */
export type StreamKey = {
   __typename?: 'StreamKey';
  /** Stream key expiration date. */
  expiresAt?: Maybe<Scalars['Time']>;
  /** RTMP stream key value. */
  value: Scalars['String'];
};

/**
 * StreamKeyError represents the error code and its translated error message
 * response that explains why the broadcaster can't start a stream.
 */
export type StreamKeyError = {
   __typename?: 'StreamKeyError';
  /** code is the error code for why the broadcaster is not allow to broadcast. */
  code: Scalars['String'];
  /** Link is the url link that is associated from the translated message. */
  links: Array<Scalars['String']>;
  /** message is the translated message for why the broadcaster is not allow to broadcast. */
  message: Scalars['String'];
};

/** StreamKeyResult represents StreamKey or StreamKeyError. */
export type StreamKeyResult = StreamKey | StreamKeyError;

/**
 * Query to let consumers filter streams that have specific metadata.
 * e.g. return only those hearthstone streams that have broadcasterheroclass as mage.
 * FE uses these parameters to implemtent filters.
 */
export type StreamMetadataFilterInput = {
  /** Filter streams by CSGO Map. */
  counterStrikeMap?: Maybe<Scalars['String']>;
  /** Filter streams by CSGO skill. */
  counterStrikeSkill?: Maybe<Scalars['String']>;
  /** Filter streams by Hearthstone hero class e.g "Mage". */
  hearthstoneBroadcasterHeroClass?: Maybe<Scalars['String']>;
  /** Filter streams by Hearthstone hero name e.g "Jaina". */
  hearthstoneBroadcasterHeroName?: Maybe<Scalars['String']>;
  /** Filter streams by Hearthstone game mode e.g "arena" or "rank" etc. */
  hearthstoneGameMode?: Maybe<Scalars['String']>;
  /** Filter streams by League Of Legends champion id. */
  leagueOfLegendsChampionID?: Maybe<Scalars['String']>;
  /** The maximum AVC level of the stream. e.g "4.1". */
  maxAVCLevel?: Maybe<Scalars['String']>;
  /** The maximum AVC profile of the stream. */
  maxAVCProfile?: Maybe<AvcProfile>;
  /** The maximum height of the stream. */
  maxHeight?: Maybe<Scalars['Int']>;
  /** Filter streams by Overwatch broadcaster's character e.g "Widowmaker". */
  overwatchBroadcasterCharacter?: Maybe<Scalars['String']>;
  /** Filter streams by PUBG game mode. */
  pubgGameMode?: Maybe<Scalars['String']>;
  /** Filter streams by PUBG max number of players alive in game. */
  pubgPlayerAliveMax?: Maybe<Scalars['String']>;
  /** Filter streams by PUBG min number of players alive in game. */
  pubgPlayerAliveMin?: Maybe<Scalars['String']>;
};

/**
 * Optional inputs to filter streams
 * add additional optional fields for filtering streams to the StreamOptions input type.
 */
export type StreamOptions = {
  /** Filter streams based on restriction types. */
  includeRestricted?: Maybe<Array<StreamRestrictionType>>;
  /**
   * Broadcaster languages to filter the streams by.
   * Deprecated: use language tags instead.
   */
  languages?: Maybe<Array<Language>>;
  /** The locale of the user. */
  locale?: Maybe<Scalars['String']>;
  /** The platform to filter streams by. */
  platformType?: Maybe<PlatformType>;
  /** If sorted by relevance, this provides additional context used to influence recommendations. */
  recommendationsContext?: Maybe<RecommendationsContext>;
  /**
   * A GUID that is created by the caller for tracking. This should be globally
   * unique per request and is required if sort=RELEVANCE.
   */
  requestID?: Maybe<Scalars['ID']>;
  /** The sort param can be used to change the default sorting. */
  sort?: Maybe<StreamSort>;
  /** List of tags to filter by. */
  tags?: Maybe<Array<Scalars['String']>>;
};

/** The content to render in a live recommendation item. */
export type StreamRecommendationEdge = {
   __typename?: 'StreamRecommendationEdge';
  /** As pagination is currently not supported by the backend, this will always be the zero value. */
  cursor: Scalars['Cursor'];
  /** The underlying stream content to render. */
  node?: Maybe<Stream>;
  /** Unique id per stream used in client tracking. */
  trackingID: Scalars['ID'];
};

export enum StreamRecommendationType {
  /** A SocialStream. */
  Social = 'SOCIAL'
}

/** Type of restricted stream. Currently used as inputs for user.followedLiveUsers, StreamOptions, and GameStreamOptions. */
export enum StreamRestrictionType {
  /** Represents streams that are restricted by OWL all-access pass. */
  OwlAllAccessPass = 'OWL_ALL_ACCESS_PASS',
  /** Represents streams that are restricted to sub-only. */
  SubOnlyLive = 'SUB_ONLY_LIVE'
}

/** The relationship between the authenticated user and a stream. */
export type StreamSelfConnection = {
   __typename?: 'StreamSelfConnection';
  /** Whether or not the requesting user is authorized to view the channel's stream. */
  canWatch: Scalars['Boolean'];
  /** Whether the stream is restricted. */
  isRestricted: Scalars['Boolean'];
  /** If the stream is restricted, the type indicates how the stream is restricted. */
  restrictionType?: Maybe<Scalars['String']>;
};

/** The start and end time of a stream session for a user. */
export type StreamSession = {
   __typename?: 'StreamSession';
  /** The associated archive of the stream. */
  archiveVideo?: Maybe<Video>;
  /** The end time for the stream session. */
  endedAt: Scalars['Time'];
  /** The start time for the stream session. */
  startedAt: Scalars['Time'];
};

/** Possible ways of sorting collections of live streams. */
export enum StreamSort {
  /**
   * Sort streams by number of concurrent viewers, descending (most viewers first).
   * This is the default if StreamSort is not set or is a deprecated field.
   */
  ViewerCount = 'VIEWER_COUNT',
  /** Sort streams by number of concurrent viewers, ascending (least viewers first). */
  ViewerCountAsc = 'VIEWER_COUNT_ASC',
  /** Sort by stream creation time, most recently started streams first. */
  Recent = 'RECENT',
  /** Sort by relevance to the current user. */
  Relevance = 'RELEVANCE',
  /**
   * Sort streams for the game "Counter-Strike: Global Offensive" by skill, descending (highest skill first).
   * Other streams are included last, sorted at random.
   * Deprecated: this sort option no longer exists.
   */
  CsgoSkill = 'CSGO_SKILL',
  /**
   * Sort streams for the game "League of Legends" by summoner rank, descending (highest rank first).
   * Other streams are included last, sorted at random.
   * Deprecated: this sort option no longer exists.
   */
  LolSummonerRank = 'LOL_SUMMONER_RANK'
}

/** Analytics information for a streaming session. */
export type StreamSummary = {
   __typename?: 'StreamSummary';
  /** The associated archive of the stream. */
  archiveVideo?: Maybe<Video>;
  /** Average viewers for the time period. */
  averageViewers: Scalars['Float'];
  /** The ID for the streaming channel. */
  channelID: Scalars['ID'];
  /** Video play referral metrics for internal channel referrals. */
  channelReferrals: VideoPlayReferrals;
  /** Unique chatters for the time period. */
  chatters: Scalars['Int'];
  /** The number of clips created during the stream summary. */
  clipsCreated: Scalars['Int'];
  /** The time that the stream session ended. */
  endedAt: Scalars['Time'];
  /** Video play referral metrics for external referrals. */
  externalReferrals: VideoPlayReferrals;
  /** Number of follows for the time period. */
  follows: Scalars['Int'];
  /** Video play referral metrics for internal referrals. */
  internalReferrals: VideoPlayReferrals;
  /** Live views for the time period. */
  liveViews: Scalars['Int'];
  /** Max viewers for the time period. */
  maxViewers: Scalars['Int'];
  /** New subscriptions for the time period. */
  newSubscriptions: Scalars['Int'];
  /** The time that the stream session started. */
  startedAt: Scalars['Time'];
  /**
   * Unique chatters for the time period.
   * @deprecated Use chatters instead
   */
  uniqueChatters: Scalars['Int'];
  /** Unique viewers for the time period. */
  uniqueViewers: Scalars['Int'];
};

/** A stucco (wide emote) represents an image that can be used for user interaction in specific cases. */
export type Stucco = {
   __typename?: 'Stucco';
  /** The description is used to describe the stucco (e.g. for screenreaders). */
  description: Scalars['String'];
  /** The unique ID of this stucco. */
  id: Scalars['ID'];
  /** The set of URLS to images related to this stucco, contains URLS for 1x, 2x and 4x images. */
  imageSet: StuccoImageSet;
  /** Indicates if this stucco does not belong to a single channel (available to all channels). */
  isGlobal: Scalars['Boolean'];
  /** The owner of this stucco, usually the channel this has been uploaded to. */
  ownerID: Scalars['ID'];
  /** The state of the stucco. */
  state: StuccoState;
  /** The textCode used to represent and identify this stucco, consists of channel prefix + stucco prefix + code. */
  textCode: Scalars['String'];
};

/** Image set of different sizes of the stucco. */
export type StuccoImageSet = {
   __typename?: 'StuccoImageSet';
  /** Image url of the 92x28px stucco ("1x") image asset. */
  image1xURL: Scalars['String'];
  /** Image url of the 182x56px stucco ("2x") image asset. */
  image2xURL: Scalars['String'];
  /** Image url of the 368x112px stucco ("4x") image asset. */
  image4xURL: Scalars['String'];
};

/** A Stucco pack is a collection of stuccos, the pack can be activated to be used by viewers of that channel. */
export type StuccoPack = {
   __typename?: 'StuccoPack';
  /** The ID of the stucco pack. */
  id: Scalars['ID'];
  /** User id of the owner of this pack (usually a channel). */
  ownerID: Scalars['ID'];
  /** The stuccos contained in this pack, represented as slots, containing the slot index and the stucco. */
  slots?: Maybe<Array<StuccoPackSlot>>;
};

/** A stucco pack slot represents a single ordered slot in a pack of stuccos. */
export type StuccoPackSlot = {
   __typename?: 'StuccoPackSlot';
  /** The index of this slot (used for ordering). */
  index: Scalars['Int'];
  /** The stucco in this slot. */
  stucco: Stucco;
};

/** The state a stucco can be in. */
export enum StuccoState {
  /** - Active: part of a stucco pack. */
  Active = 'ACTIVE',
  /** - Inactive: available in the library. */
  Inactive = 'INACTIVE',
  /** - Moderated: stucco was moderated and is no longer available to the broadcaster or viewers. */
  Moderated = 'MODERATED',
  /** - Pending: stucco is currently going through moderation. */
  Pending = 'PENDING',
  /** - Archived: Archived stucco, no longer visible. */
  Archived = 'ARCHIVED'
}

/** SubmitEmotePrefix creates a new emoticon prefix for a channel. */
export type SubmitEmotePrefixInput = {
  /** The channel ID whose emote prefix will be updated. */
  channelID: Scalars['ID'];
  /** The new emote prefix. */
  name: Scalars['String'];
};

/** SubmitEmotePrefixPayload returns a status code indicating whether the update was successful or not. */
export type SubmitEmotePrefixPayload = {
   __typename?: 'SubmitEmotePrefixPayload';
  /** A code indicating why the prefix submit failed, if it did. */
  errorCode?: Maybe<SubmitEmotePrefixResponseCode>;
  /** The newly submitted prefix. */
  prefix?: Maybe<EmoticonPrefix>;
};

/** A code indicating why the prefix submit failed, if it did. */
export enum SubmitEmotePrefixResponseCode {
  /** Only eligible users can update their emoticon prefix. */
  ErrInvalidUser = 'ERR_INVALID_USER',
  /** The prefix submitted was not the correct length. */
  ErrInvalidPrefixLength = 'ERR_INVALID_PREFIX_LENGTH',
  /** The prefix submitted does not meet the regular expression requirements. */
  ErrInvalidPrefixRegex = 'ERR_INVALID_PREFIX_REGEX',
  /** The prefix is not in a state that it can be updated. */
  ErrInvalidPrefixState = 'ERR_INVALID_PREFIX_STATE',
  /** Emote prefixes must be unique across the website. */
  ErrPrefixNotUnique = 'ERR_PREFIX_NOT_UNIQUE',
  /** The prefix was updated recently and can't be updated again for a while. */
  ErrPrefixUpdateTooSoon = 'ERR_PREFIX_UPDATE_TOO_SOON',
  /** The user is not in good standing and therefore cannot update their emoticon prefix. */
  ErrNotInGoodStanding = 'ERR_NOT_IN_GOOD_STANDING',
  /** Something unexpected happened when submitting the emote prefix. */
  ErrUnknown = 'ERR_UNKNOWN',
  /** The prefix for the affiliate can not be updated. Affiliates can update prefix once every name change. */
  ErrAffiliatePrefixUpdateTooSoon = 'ERR_AFFILIATE_PREFIX_UPDATE_TOO_SOON',
  /** The prefix submitted for the affiliate does not match the auto generated prefix. */
  ErrSubmittedPrefixDoesNotMatchAutoGeneratedPrefix = 'ERR_SUBMITTED_PREFIX_DOES_NOT_MATCH_AUTO_GENERATED_PREFIX'
}

/** SubmitEmoticonPrefix creates a new emoticon prefix for a channel. */
export type SubmitEmoticonPrefixInput = {
  /** The channel ID. */
  channelID: Scalars['ID'];
  /** Emoticon prefix. */
  name: Scalars['String'];
};

/** SubmitEmoticonPrefixPayload returns the updated emoticon prefix. */
export type SubmitEmoticonPrefixPayload = {
   __typename?: 'SubmitEmoticonPrefixPayload';
  /**
   * The response doesn't return the real state of the prefix. Querying the emoticon
   * prefix is required to get the most accurate state.
   */
  response: EmoticonPrefix;
};

/** Possible errors returned by the SubmitExtensionFeedback mutation. */
export enum SubmitExtensionFeedbackError {
  /** Internal service error eg. database timeout. */
  InternalError = 'INTERNAL_ERROR'
}

/** SubmitExtensionFeedbackInput submits a user's feedback for a related rating on a Twitch extension. */
export type SubmitExtensionFeedbackInput = {
  /** Feedback that the broadcaster can write. */
  comment: Scalars['String'];
  /** The ID of the extension the feedback applies to. */
  extensionClientID: Scalars['ID'];
  /** The version of the extension the feedback applies to. */
  extensionVersion: Scalars['String'];
  /** ID of the user submitting the feedback for the extension. */
  userID: Scalars['ID'];
};

/** The result of a submitExtensionFeedback mutation. */
export type SubmitExtensionFeedbackPayload = {
   __typename?: 'SubmitExtensionFeedbackPayload';
  /** The ExtensionRating record that the feedback was attached to. */
  comment?: Maybe<ExtensionComment>;
  /** The error when the mutation fails to submit the extension feedback. */
  error?: Maybe<SubmitExtensionFeedbackError>;
};

/** A list of channels subscribed to by a user. */
export type SubscribedChannelConnection = {
   __typename?: 'SubscribedChannelConnection';
  /** The subscribed channels. */
  edges?: Maybe<Array<SubscribedChannelEdge>>;
  /** Pagination. */
  pageInfo: PageInfo;
  /** The total number of subscribed channels. */
  totalCount?: Maybe<Scalars['Int']>;
};

/** A broadcaster user with cursor. */
export type SubscribedChannelEdge = {
   __typename?: 'SubscribedChannelEdge';
  /** Cursor represents the position of the current edge/node. */
  cursor: Scalars['Cursor'];
  /** Node represents the user for the current edge. */
  node?: Maybe<User>;
};

/** Breakdown of number of subscriptions by tier. */
export type SubscriberCountBreakdown = {
   __typename?: 'SubscriberCountBreakdown';
  /** The number of subscriptions to the product. */
  count: Scalars['Int'];
  /** The tier of the product. */
  tier: Scalars['String'];
};

/**
 * Information pertaining to user's subscriber score.
 * Contains subscription count, sub points, emote limits, and information about the next subscriber level.
 */
export type SubscriberScore = {
   __typename?: 'SubscriberScore';
  /** Breakdown of subscriber score by product tier. */
  breakdown?: Maybe<Array<SubscriberScoreBreakdown>>;
  /** Current subscriber count. */
  count: Scalars['Int'];
  /** Breakdown of total subs by product tier. */
  countBreakdown?: Maybe<Array<SubscriberCountBreakdown>>;
  /** Current subscriber score. */
  current: Scalars['Int'];
  /** Current number of emotes unlocked. */
  currentEmoteLimit: Scalars['Int'];
  /**
   * Next goal to unlock more emotes.
   * Will be null if max score already reached.
   */
  next?: Maybe<Scalars['Int']>;
  /**
   * Emote limit after reaching nextScoreGoal.
   * Will be null if max emote limit reached.
   */
  nextEmoteLimit?: Maybe<Scalars['Int']>;
};

/** Breakdown of score by tier. */
export type SubscriberScoreBreakdown = {
   __typename?: 'SubscriberScoreBreakdown';
  /** The score of the product. */
  score: Scalars['Int'];
  /** The tier of the product. */
  tier: Scalars['String'];
};

/** Data about a user's subscription to a broadcaster. */
export type SubscriptionBenefit = {
   __typename?: 'SubscriptionBenefit';
  /** The date that the subscription benefit ends. */
  endsAt?: Maybe<Scalars['Time']>;
  /** gift resolves gift info about a SubscriptionBenefit. */
  gift?: Maybe<SubscriptionGift>;
  /** The unique identifier. */
  id: Scalars['ID'];
  /** For a recurring subscription, the price is charged at every interval i months. */
  intervalNumber: Scalars['Int'];
  /** Whether the sub is set to "do not renew". */
  isDNRd: Scalars['Boolean'];
  /**
   * Whether this subscription has been extended. This means that a non-recurring
   * subscription has been extended with additional months.
   */
  isExtended: Scalars['Boolean'];
  /** Whether the subscription is in the grace period to be cancelled and refunded. */
  isRefundable: Scalars['Boolean'];
  /** The id of where the subscription originated from. Used when DNRing a recurring subscription. */
  originID?: Maybe<Scalars['String']>;
  /**
   * If the subscriptionBenefit has a future dated paid upgrade. (ie. a user has
   * upgraded a 1-month gift to a recurring subscription).
   * @deprecated gift to paid upgrades will now be in the pendingSubscription schema
   */
  paidUpgrade?: Maybe<PaidUpgrade>;
  /** If the subscriptionBenefit has a pending future dated paid subscription. */
  pendingSubscription?: Maybe<PendingSubscription>;
  /** The platform the subscription was purchased on. */
  platform: SubscriptionPlatform;
  /** Resolves the product that the subscription benefit is to. */
  product?: Maybe<SubscriptionProduct>;
  /** Whether this benefit was achieved using a Twitch Prime subscription. */
  purchasedWithPrime: Scalars['Boolean'];
  /**
   * The date that the subscription benefit will renew. Will be nil if the subscription benefit
   * is not going to renew.
   */
  renewsAt?: Maybe<Scalars['Time']>;
  /**
   * Exposes the third party SKU for managing third party subscriptions from the client.
   * Will be nil if there is not a thirdPartySKU associated with this subscription benefit.
   */
  thirdPartySKU?: Maybe<Scalars['String']>;
  /** The subscription tier. */
  tier: Scalars['String'];
  /** The user who is subscribed to. */
  user?: Maybe<User>;
};

/** A paginated list of subscription benefits. */
export type SubscriptionBenefitConnection = {
   __typename?: 'SubscriptionBenefitConnection';
  /** The list of subscription benefits on this page. */
  edges?: Maybe<Array<SubscriptionBenefitEdge>>;
  /** Information about this page of payment transactions. */
  pageInfo: PageInfo;
};

/** Criteria for building paginated list of user's all active subscriptions. */
export type SubscriptionBenefitCriteriaInput = {
  /** Only return subscription benefits for a given filter value. */
  filter?: Maybe<SubscriptionBenefitFilter>;
  /** Platform where subscriptions were purchased. */
  platform?: Maybe<SubscriptionPlatform>;
};

/** An element in a paginated list of subscription benefits. */
export type SubscriptionBenefitEdge = {
   __typename?: 'SubscriptionBenefitEdge';
  /** Opaque cursor describing this edge's position in the paginated list. */
  cursor: Scalars['Cursor'];
  /** The element node. */
  node?: Maybe<SubscriptionBenefit>;
};

/** Set of ways to filter subscription benefit paginated results. */
export enum SubscriptionBenefitFilter {
  /** Only subscriptions purchased on a platform, specified in the input as platform. */
  Platform = 'PLATFORM',
  /** Only Subscriptions received through gifts from another Twitch user. */
  Gift = 'GIFT',
  /** All active subscriptions. */
  All = 'ALL'
}

/** Configs that help initiate the subscription checkout flow. */
export type SubscriptionCheckoutConfigs = {
   __typename?: 'SubscriptionCheckoutConfigs';
  /** Lists any additional actions for a subscription checkout session. */
  actions: Array<CheckoutAction>;
  /** Whether the initiated checkout flow can complete/succeed and gift the recipient the product. */
  canGift: Scalars['Boolean'];
  /** Whether the initiated checkout flow can proceed with a purchase. */
  canPurchase: Scalars['Boolean'];
  /** Whether the purchaser is eligible for a one-time promotion in the subscription purchase checkout flow. */
  isOneMonthFreeEligible: Scalars['Boolean'];
  /** Holds configuration necessary for initializing payment provider client libraries and facilitate checkout flow. */
  paymentProviderConfigs: PaymentProviderConfigs;
  /** Purchase Ineligibility reason details. */
  purchaseIneligibilityReason: PurchaseIneligibilityReason;
};

/**
 * An Offer for purchasing community gift subscriptions with associated metadata about the Offer.
 * Composes the "model" (Offer) with the "view" metadata about the offer.
 */
export type SubscriptionCommunityGifting = {
   __typename?: 'SubscriptionCommunityGifting';
  /** The image assets for this offer. */
  assets: SubscriptionCommunityGiftingAssets;
  /** The Offer document for this Community Gift offer. */
  offer?: Maybe<Offer>;
  /** The default number of subscriptions that this offer is offering. */
  quantity: Scalars['Int'];
  /** The type of this community gifting offer. */
  type: SubscriptionCommunityGiftingType;
};

/** Groups image assets related to the community gifting Offer. */
export type SubscriptionCommunityGiftingAssets = {
   __typename?: 'SubscriptionCommunityGiftingAssets';
  /** The link to the 1x pixel density image asset for this community gifting offer. */
  imageURL1x: Scalars['String'];
  /** The link to the 2x pixel density image asset for this community gifting offer. */
  imageURL2x: Scalars['String'];
  /** The link to the 3x pixel density image asset for this community gifting offer. */
  imageURL3x: Scalars['String'];
  /** The link to the 4x pixel density image asset for this community gifting offer. */
  imageURL4x: Scalars['String'];
};

/** Describes the type of community gifting Offer that is being resolved. */
export enum SubscriptionCommunityGiftingType {
  /** A preset bundle of fixed-quantity community gift subscriptions. */
  Bundle = 'BUNDLE',
  /** An offer that allows the user to choose how many gift subscriptions they would like to purchase. */
  Custom = 'CUSTOM'
}

/** Gift information for a subscription benefit. */
export type SubscriptionGift = {
   __typename?: 'SubscriptionGift';
  /** giftDate is the date that the gift was given. */
  giftDate?: Maybe<Scalars['Time']>;
  /** Gifter is the user who sent the gift. Will be nil if isGift is false or is the gift is anonymous. */
  gifter?: Maybe<User>;
  /** isGift says whether the subscription benefit is a gift or not. */
  isGift: Scalars['Boolean'];
};

/** A parent field for grouping the different types of gift subscriptions. */
export type SubscriptionGifting = {
   __typename?: 'SubscriptionGifting';
  /** Offers and associated metadata for purchasing community gift subscriptions. */
  community?: Maybe<Array<SubscriptionCommunityGifting>>;
  /**
   * Offers for purchasing a gift subscription to the given user.
   * This will prefer the ID if both login and ID are provided.
   * If neither are provided, this will return null.
   */
  standard?: Maybe<Array<SubscriptionStandardGifting>>;
};


/** A parent field for grouping the different types of gift subscriptions. */
export type SubscriptionGiftingStandardArgs = {
  recipientID?: Maybe<Scalars['ID']>;
  recipientLogin?: Maybe<Scalars['String']>;
};

/**
 * A gift offer that is available on a particular subscription based
 * on gift type and platform.
 */
export type SubscriptionGiftOffer = {
   __typename?: 'SubscriptionGiftOffer';
  /** Unique identifier of a subscription gift offer. */
  id: Scalars['ID'];
  /** The subscription gift offer price info which contains information about currency, cost and tax information. */
  priceInfo: PriceInfo;
  /** The available promotions on this gift offer. */
  promotion?: Maybe<SubscriptionGiftPromotion>;
  /** The amount of gifts in this offer. */
  quantity: Scalars['Int'];
  /**
   * thirdPartySKU represents the purchasable third party SKU of the gift the user will purchase. 
   * Will return an nil if the user has no purchasable skus. 
   * Will return nil if not on a platform with an external subscription gift offer or if the country is not supported.
   */
  thirdPartySKU?: Maybe<Scalars['String']>;
  /** The type of gift this offer is for. */
  type: SubscriptionGiftType;
};


/**
 * A gift offer that is available on a particular subscription based
 * on gift type and platform.
 */
export type SubscriptionGiftOfferPriceInfoArgs = {
  taxCountry?: Maybe<Scalars['String']>;
};

/** The different types of platforms available for gift offers. */
export enum SubscriptionGiftOfferPlatform {
  /** Gift offers available for the web clients. */
  Web = 'WEB',
  /** Gift offers available for the Android clients. */
  Android = 'ANDROID'
}

/** The promotion offer on a subscription gift offer. */
export type SubscriptionGiftPromotion = {
   __typename?: 'SubscriptionGiftPromotion';
  /** The subscription gift's discount type for this promotion(e.g. "PERCENT_OFF"). */
  discountType: SubscriptionPromotionDiscountType;
  /** The discount value of the subscription gift product (e.g. "50"). */
  discountValue: Scalars['String'];
  /** Unique identifier of a subscription gift promotion. */
  id: Scalars['ID'];
  /** The subscription gift offer price info which contains information about currency, cost and tax information. */
  priceInfo: PriceInfo;
  /** The quantity of gifts this promotion is for(ex: 11 gifts for a promotion on 10 gifts). */
  quantity: Scalars['Int'];
  /** Promotion consumable SKU used by third party that the user will purchase. */
  thirdPartySKU?: Maybe<Scalars['String']>;
};


/** The promotion offer on a subscription gift offer. */
export type SubscriptionGiftPromotionPriceInfoArgs = {
  taxCountry?: Maybe<Scalars['String']>;
};

/** The different types of subscription gifting. */
export enum SubscriptionGiftType {
  /** Standard gifts are gifts to a specific user given by a user. */
  Standard = 'STANDARD',
  /** Community gifts are one or more gifts given to one or more users by a user. */
  Community = 'COMMUNITY'
}

/** Represents the interval of a subscription product. */
export type SubscriptionInterval = {
   __typename?: 'SubscriptionInterval';
  /** The unit-less amount of time a subscription lasts for. */
  duration: Scalars['Int'];
  /** Denotes the unit of the interval. */
  unit: SubscriptionIntervalUnit;
};

/** Denotes the unit of the period of a subscription product. */
export enum SubscriptionIntervalUnit {
  /** This subscription product lasts X weeks. */
  Week = 'WEEK',
  /** This subscription product lasts X months. */
  Month = 'MONTH',
  /** This subscription product lasts X years. */
  Year = 'YEAR',
  /** This subscription product lasts forever. */
  OneTime = 'ONE_TIME'
}

/** SubscriptionPlatform enumerates platform options such as WEB, IOS, ANDROID. */
export enum SubscriptionPlatform {
  /** Access from the browser.                                           ). */
  Web = 'WEB',
  /** Access from the Twitch iOS application. */
  Ios = 'IOS',
  /** Access from the Twitch Android application. */
  Android = 'ANDROID',
  /** Access from all Twitch Mobile applications (ANDROID + IOS). */
  MobileAll = 'MOBILE_ALL'
}

/**
 * A subscription that is purchasable by users.
 * Once purchased, the subscription entitles the user to use special emote sets on Twitch.
 */
export type SubscriptionProduct = {
   __typename?: 'SubscriptionProduct';
  /** The subscription product's display name. */
  displayName?: Maybe<Scalars['String']>;
  /** The emote modifiers associated with the product. */
  emoteModifiers?: Maybe<Array<EmoteModifier>>;
  /**
   * The identifier of an EmoteSet that a user gains access to use on Twitch,
   * when they purchase this product.
   */
  emoteSetID?: Maybe<Scalars['ID']>;
  /**
   * A list of Emotes the user gains access to use on Twitch when they purchase
   * this product.
   */
  emotes?: Maybe<Array<Maybe<Emote>>>;
  /**
   * A list of GiftOffers that are available on this subscription product
   * depending on which platform and gift type is given
   * Used by clients to display different gift prices, quantities and gift promotion information.
   */
  giftOffers?: Maybe<Array<SubscriptionGiftOffer>>;
  /** The subscription product's promotion if it is active. */
  giftPromotion?: Maybe<SubscriptionPromotion>;
  /** The different types of gift subscriptions ("Community" vs "Standard"). */
  gifting: SubscriptionGifting;
  /** Whether the subscription hides ads for the channel. */
  hasAdFree: Scalars['Boolean'];
  /** Whether the subscribers of this product are affected by slow chat mode. */
  hasFastChat?: Maybe<Scalars['Boolean']>;
  /** Whether the channel has sub only chatroom restriction. */
  hasSubOnlyChat?: Maybe<Scalars['Boolean']>;
  /** Whether the subscribers of this product are able to see the subs-only video archive. */
  hasSubonlyVideoArchive?: Maybe<Scalars['Boolean']>;
  /** The subscription product's identifier. */
  id: Scalars['ID'];
  /** The interval that the product lasts for. Includes unit + duration. */
  interval: SubscriptionInterval;
  /** The subscription product's name. */
  name: Scalars['String'];
  /** Available offers for a subscription product. */
  offers?: Maybe<Array<Offer>>;
  /**
   * The Twitch user that is the owner of the channel associated with this subscription product.
   * This is null for SubscriptionProducts like 'turbo' that are not associated with any user.
   */
  owner?: Maybe<User>;
  /**
   * The subscription's USD-formatted price, e.g. "$9.99".
   * @deprecated Transitioning to priceInfo instead to support multi region pricing
   */
  price: Scalars['String'];
  /** PriceInfo holds the products pricing information such as currency, cost, and tax information. */
  priceInfo: PriceInfo;
  /** The subscription product's promotion if it is active. */
  promotion?: Maybe<SubscriptionPromotion>;
  /** The currently active revenue configuration record for the subscription product. */
  revenueConfig?: Maybe<RevenueConfig>;
  /** The connection for user to the subscription product. */
  self?: Maybe<SubscriptionProductSelfConnection>;
  /** The avaliability state of the product. e.g. "active" or "inactive". */
  state: SubscriptionState;
  /**
   * ThirdPartytemplateSKU is used by the frontend to retrieve third party product information such
   * as price. templateSKU is exposed separately from purchaseSKU since retrieving purchaseSKU is a
   * more expensive operation. A user may not be able to purchase the templateSKU. Use purchaseSKU
   * when the user has indiciated they want to purchase.
   * Uses Client-ID to determine platform information and IP address to determine location.
   */
  thirdPartyTemplateSKU?: Maybe<Scalars['String']>;
  /** The tier of the product. */
  tier: Scalars['String'];
  /** The type of subscription, e.g. "chansub" or "teamsub". */
  type: SubscriptionProductType;
  /** The URL for this subscription's purchase page. */
  url: Scalars['String'];
};


/**
 * A subscription that is purchasable by users.
 * Once purchased, the subscription entitles the user to use special emote sets on Twitch.
 */
export type SubscriptionProductEmotesArgs = {
  state?: Maybe<EmoteStateFilter>;
};


/**
 * A subscription that is purchasable by users.
 * Once purchased, the subscription entitles the user to use special emote sets on Twitch.
 */
export type SubscriptionProductGiftOffersArgs = {
  platform?: Maybe<SubscriptionGiftOfferPlatform>;
  type: SubscriptionGiftType;
};


/**
 * A subscription that is purchasable by users.
 * Once purchased, the subscription entitles the user to use special emote sets on Twitch.
 */
export type SubscriptionProductPriceInfoArgs = {
  taxCountry?: Maybe<Scalars['String']>;
};


/**
 * A subscription that is purchasable by users.
 * Once purchased, the subscription entitles the user to use special emote sets on Twitch.
 */
export type SubscriptionProductThirdPartyTemplateSkuArgs = {
  platform?: Maybe<Scalars['String']>;
};

/** The connection between the user and subscription product. */
export type SubscriptionProductSelfConnection = {
   __typename?: 'SubscriptionProductSelfConnection';
  /** This user's subscription benefit information for the subscription product. */
  benefit?: Maybe<SubscriptionBenefit>;
  /** True if the user in this connection is allowed to gift the product in this connection. */
  canGiftInChannel: Scalars['Boolean'];
  /** True if the user in this connection can gift the product in this connection to the user with the supplied user ID. */
  canGiftTo: Scalars['Boolean'];
  /**
   * True if the user in this connection can gift the product in this connection to the user with the supplied login.
   * Since this requires an additonal lookup to get the user ID from the login, this is less preferable than canGift.
   */
  canGiftToLogin: Scalars['Boolean'];
  /** Holds configuration necessary to start subscription purchase checkout flow for this product for current user. */
  checkoutConfiguration?: Maybe<SubscriptionCheckoutConfigs>;
  /**
   * The subscription's discount type (e.g. "percent_off").
   * @deprecated Transitioning to promotion field instead
   */
  discountType: DiscountType;
  /**
   * The discount value of the subscription product (e.g. "50").
   * @deprecated Transitioning to promotion field instead
   */
  discountValue: Scalars['String'];
  /**
   * A list of GiftOffers that are available on this subscription product
   * depending on which platform, giftType and user that is authenticated.
   * Exposed on the self connection as well since user based promotions can be given in the future
   * Used by clients to display different gift prices, quantities and user based gift promotion information.
   */
  giftOffers?: Maybe<Array<SubscriptionGiftOffer>>;
  /**
   * If the product is eligible for a discount.
   * @deprecated Transitioning to promotion field instead
   */
  isEligibleForDiscount: Scalars['Boolean'];
  /**
   * The subscription's USD-formatted price after discount (e.g. "$2.49").
   * @deprecated Transitioning to promotion field instead
   */
  newPrice: Scalars['String'];
  /**
   * The subscription's USD-formatted price before discount (e.g. "$4.99").
   * @deprecated Transitioning to promotion field instead
   */
  oldPrice: Scalars['String'];
  /** If the subscription product is eligible for a paid upgrade promotion. */
  paidUpgradePromotion?: Maybe<SubscriptionPromotion>;
  /** Contains information on the final checkout price of this subscription product. */
  productPurchase?: Maybe<ProductPurchase>;
  /** The subscription product's promotion for user if eligible. */
  promotion?: Maybe<SubscriptionPromotion>;
  /**
   * This user's subscription purchase details for the subscription product. If this user is not
   * subscribed to the product, then the result's state is 'inactive'. If a compatible purchase exists,
   * then the result's "compatiblePurchase" field is present.
   */
  purchase?: Maybe<SubscriptionPurchase>;
  /** Subscription tenure data for the user to this subscription product. */
  subscriptionTenure?: Maybe<SubscriptionTenure>;
  /**
   * ThirdPartyPurchaseSKU is different from templateSKU since it represents the SKU of the exact item the
   * user will purchase. It is more expensive to retrieve purchaseSKU than templateSKU, so only
   * use purchaseSKU when the user has indicated they want to checkout. Use templateSKU on channel
   * page load to retrieve product information.
   * 
   * Will return an error if the user has no purchasable skus. Will return nil if not on a platform
   * with an external subscription product or if the country is not supported.
   * Uses Client-ID to determine platform information and IP address to determine location.
   */
  thirdPartyPurchaseSKU?: Maybe<Scalars['String']>;
};


/** The connection between the user and subscription product. */
export type SubscriptionProductSelfConnectionCanGiftToArgs = {
  recipientID: Scalars['ID'];
};


/** The connection between the user and subscription product. */
export type SubscriptionProductSelfConnectionCanGiftToLoginArgs = {
  recipientLogin: Scalars['String'];
};


/** The connection between the user and subscription product. */
export type SubscriptionProductSelfConnectionCheckoutConfigurationArgs = {
  config: CheckoutConfigurationInput;
};


/** The connection between the user and subscription product. */
export type SubscriptionProductSelfConnectionGiftOffersArgs = {
  platform?: Maybe<SubscriptionGiftOfferPlatform>;
  type: SubscriptionGiftType;
};


/** The connection between the user and subscription product. */
export type SubscriptionProductSelfConnectionProductPurchaseArgs = {
  quantity: Scalars['Int'];
  paymentProvider: PaymentProvider;
};


/** The connection between the user and subscription product. */
export type SubscriptionProductSelfConnectionSubscriptionTenureArgs = {
  tenureMethod: SubscriptionTenureMethod;
};


/** The connection between the user and subscription product. */
export type SubscriptionProductSelfConnectionThirdPartyPurchaseSkuArgs = {
  platform?: Maybe<Scalars['String']>;
};

/** The types of subscription products that can be purchased. */
export enum SubscriptionProductType {
  /** Channel sub. */
  Chansub = 'CHANSUB',
  /** Team sub. */
  Teamsub = 'TEAMSUB',
  /** Turbo sub. */
  Turbo = 'TURBO'
}

/** The promotion offer on subscription product. */
export type SubscriptionPromotion = {
   __typename?: 'SubscriptionPromotion';
  /** Contains information on the final checkout price for this promotion. */
  checkoutPrice?: Maybe<ProductPurchase>;
  /**
   * The subscription's discount type (e.g. "PERCENT_OFF").
   * @deprecated No longer supported.
   */
  discountType: SubscriptionPromotionDiscountType;
  /**
   * The discount value of the subscription product (e.g. "50").
   * @deprecated No longer supported.
   */
  discountValue: Scalars['String'];
  /**
   * The subscription's USD-formatted price after discount (e.g. "$2.49").
   * @deprecated Use SubscriptionPromotion.previewPrice instead.
   */
  newPrice: Scalars['String'];
  /**
   * The subscription's USD-formatted price before discount (e.g. "$4.99").
   * @deprecated Use SubscriptionProduct.priceInfo instead.
   */
  oldPrice: Scalars['String'];
  /** The price for the promotion. */
  previewPrice: PriceInfo;
};


/** The promotion offer on subscription product. */
export type SubscriptionPromotionCheckoutPriceArgs = {
  quantity: Scalars['Int'];
  paymentProvider: PaymentProvider;
};

/** Valid discount types for Subscription promotion. */
export enum SubscriptionPromotionDiscountType {
  /** No discount on subscription product. */
  None = 'NONE',
  /** Percent off discount on subscription product. */
  PercentOff = 'PERCENT_OFF',
  /** Fixed price discount on subscription product. */
  FixedValueOff = 'FIXED_VALUE_OFF'
}

/** A user's subscription purchase details, part of the Subscription Checkout workflow. */
export type SubscriptionPurchase = {
   __typename?: 'SubscriptionPurchase';
  /**
   * A compatible purchase exists if this user bought a subscription product of a different tier for the
   * channel in question.
   * 
   * i.e. this user doesn't have this subscription purchase for the $4.99 sub but they do have a
   *      compatible purchase for the $9.99 subscription.
   */
  compatiblePurchases?: Maybe<Array<SubscriptionPurchaseDetails>>;
  /** The purchase details for a Twitch purchaser - Subscription product combination. */
  details?: Maybe<SubscriptionPurchaseDetails>;
};

/** The receipt details for a subscription purchase. */
export type SubscriptionPurchaseDetails = {
   __typename?: 'SubscriptionPurchaseDetails';
  /** Date the purchase was cancelled at, if applicable, else null. */
  cancelledAt?: Maybe<Scalars['Time']>;
  /** Currency for the price, e.g. "USD". */
  currency: Scalars['String'];
  /** Divisor for the price based on the currency. e.g. Divisor for USD is 100. */
  divisor: Scalars['Int'];
  /** Purchase's payment provider. */
  paymentProvider: PaymentProvider;
  /** Price in smallest subunit of currency, e.g. "499" cents. */
  price: Scalars['Int'];
  /** The tier of the subscription purchase product. */
  productTier?: Maybe<Scalars['String']>;
  /** The type of subscription purchase. */
  productType: SubscriptionProductType;
  /** Purchase state. */
  state: SubscriptionPurchaseState;
};

/** The various states of the subscription purchase receipt. */
export enum SubscriptionPurchaseState {
  /** Active subscription purchase. It could be non-renewing or renewing. */
  Active = 'ACTIVE',
  /** Cancelled subscription purchase. */
  Cancelled = 'CANCELLED',
  /**
   * Inactive subscription purchase. User's subscription benefit from the original purchase has ended
   * and has not renewed.
   */
  Inactive = 'INACTIVE'
}

/**
 * An Offer for purchasing a Standard (AKA "single" or "targetted") gift subscription for a specific user.
 * This type exists as a futureproofing measure as gifting will evolve over time.
 */
export type SubscriptionStandardGifting = {
   __typename?: 'SubscriptionStandardGifting';
  /** The Offer document for this Standard Gift offer. */
  offer?: Maybe<Offer>;
};

/** The availability state of a subscription product. */
export enum SubscriptionState {
  /** Active state. */
  Active = 'ACTIVE',
  /** Inactive state. */
  Inactive = 'INACTIVE',
  /** Unknown state. */
  Unknown = 'UNKNOWN'
}

/** Tenure to a subscription product. */
export type SubscriptionTenure = {
   __typename?: 'SubscriptionTenure';
  /** The days remaining in a user's current tenure period. */
  daysRemaining: Scalars['Int'];
  /** The days elapsed in a user's current tenure period. */
  elapsedDays: Scalars['Int'];
  /** The ending date of a user's tenure. */
  end?: Maybe<Scalars['Time']>;
  /** The method used to calculate the user's tenure. */
  method: SubscriptionTenureMethod;
  /** The total duration of a user's tenure. */
  months: Scalars['Int'];
  /** The starting date of a user's tenure. */
  start?: Maybe<Scalars['Time']>;
};

/** A type of tenure to a subscription product. */
export enum SubscriptionTenureMethod {
  /** Tenure data calculated cumulatively. */
  Cumulative = 'CUMULATIVE',
  /** Tenure data calculated streak-based. */
  Streak = 'STREAK'
}

/**
 * A channel could have multiple subscription products at varying tiers.
 * Each value will always map to the respective tier for every channel that has the given tier available as a product.
 * 
 * Example:
 * A channel with a "tier 2" subscription product will always have the tier represented as T_2000.
 */
export enum SubscriptionTier {
  /** Custom tier. */
  Custom = 'CUSTOM',
  /** Subscribed with Twitch Prime. */
  Prime = 'PRIME',
  /** Tier "1000". */
  T_1000 = 'T_1000',
  /** Tier "2000". */
  T_2000 = 'T_2000',
  /** Tier "3000". */
  T_3000 = 'T_3000'
}

/** Token that a User uses for redeeming Subscriptions. */
export type SubscriptionToken = {
   __typename?: 'SubscriptionToken';
  /** Current token balance of user. */
  balance?: Maybe<Scalars['Int']>;
};

/**
 * A SubscriptionTokenBundleProduct can contain multiple Offers. 
 * ex) A Bundle of size 3 tokens, can have 3 other offers such as: 
 *   - Normal offer: "Pay $16.99 for the bundle
 *   - Discounted, one-time buy offer: "Pay $14.99 for the bundle, but a one-time purchase only"
 *   - Bits: Use X amount of Bits to purchase this Bundle.
 */
export type SubscriptionTokenBundleProduct = {
   __typename?: 'SubscriptionTokenBundleProduct';
  /** Assets assocaited with a certain Token Bundle Product. */
  assets?: Maybe<Array<TokenBundleAsset>>;
  /** Subscription token bundle product's identifier. */
  id: Scalars['ID'];
  /**
   * List of available offers for this bundle product.
   * Displays the cheapest offer to the user, if there are promotions to be applied.
   */
  offers?: Maybe<Array<Offer>>;
  /** Quantity of tokens the bundle. */
  quantity: Scalars['Int'];
};

/** Describes configurable values for the token product line. */
export type SubscriptionTokenProductConfig = {
   __typename?: 'SubscriptionTokenProductConfig';
  /** Max token balance a user can have. */
  maxBalance?: Maybe<Scalars['Int']>;
  /** Max quantity of subscription tokens that can be used to redeem a subscription. */
  maxQuantity: Scalars['Int'];
};

/** The individual swap participant input. */
export type SwapCompetitionLobbyParticipantInput = {
  /** The id of the lobby where the lobby participant currently is. */
  lobbyID: Scalars['ID'];
  /** The id of the lobby participant, which can be competition player id or competition team id, we are swapping with. */
  participantID: Scalars['ID'];
};

/** SwapCompetitionLobbyParticipantsInput exchanges the lobby placements of the two participants within the same phase. */
export type SwapCompetitionLobbyParticipantsInput = {
  /** The id of the competition. */
  competitionID: Scalars['ID'];
  /** The participantID and lobbyID of the first lobby participant to be swapped. */
  first: SwapCompetitionLobbyParticipantInput;
  /** The id of the phase. */
  phaseID: Scalars['ID'];
  /** The participantID and lobbyID of the second lobby participant to be swapped. */
  second: SwapCompetitionLobbyParticipantInput;
};

/** SwapCompetitionLobbyParticipantsPayload is the success response for swapping lobby participants. */
export type SwapCompetitionLobbyParticipantsPayload = {
   __typename?: 'SwapCompetitionLobbyParticipantsPayload';
  /** The new state of competition after swapping participants. */
  competition?: Maybe<Competition>;
};

/** Tag(s) are used as a discovery and search mechanism for tagged content, including Streams, Clips, and VODs. */
export type Tag = {
   __typename?: 'Tag';
  /** Timestamp of the creation of this tag. */
  createdAt?: Maybe<Scalars['Time']>;
  /** This tag's unique identifier. */
  id: Scalars['ID'];
  /** Whether this tag is auto generated. */
  isAutomated: Scalars['Boolean'];
  /** Whether this tag is a language tag. */
  isLanguageTag: Scalars['Boolean'];
  /** Localized description of this tag. */
  localizedDescription: Scalars['String'];
  /** Localized Name of this tag. */
  localizedName: Scalars['String'];
  /** Scope of the Tag. */
  scope: TagScope;
  /** Official Name of this tag in English. */
  tagName: Scalars['String'];
};

/** The frequency of a tag used as filter for a channel. */
export type TagAnalytic = {
   __typename?: 'TagAnalytic';
  /** A decimal that shows how often a Tag is used. */
  percentage: Scalars['Float'];
  /** The tag for the analytic. */
  tag: Tag;
};

/** A paginated list of tags, and its metadata. */
export type TagConnection = {
   __typename?: 'TagConnection';
  /** The list of tags in this page. */
  edges?: Maybe<Array<TagEdge>>;
  /** Information about this page of tags. */
  pageInfo: PageInfo;
};

/** An element in a paginated tags, and its metadata. */
export type TagEdge = {
   __typename?: 'TagEdge';
  /** Cursor represents the position of the current edge/node. */
  cursor: Scalars['Cursor'];
  /** Node represents the extension for the current edge. */
  node?: Maybe<Tag>;
};

/** The content that are possibly return for tagging mutation payload. */
export type TaggedContent = Clip | Game | Stream | User | Video;

/** An enumeration on the different scope of a tag. */
export enum TagScope {
  /** Tags that can be applied to all content types. */
  All = 'ALL',
  /** Tags that can only be applied to the CATEGORY content type. */
  Category = 'CATEGORY'
}

/** An enumeration on the different tag types of a category. */
export enum TagType {
  /** Tags applied to the category. */
  Content = 'CONTENT',
  /** The most popular tags used by other channels streaming this game/category. */
  Top = 'TOP'
}

/** TargetedModerationAction is a ModLogs entry of a chat ban,timeout, or unban. */
export type TargetedModActionDetails = {
   __typename?: 'TargetedModActionDetails';
  /** Timestamp when user was banned/timed-out. */
  bannedAt?: Maybe<Scalars['Time']>;
  /** Duration of the chat timeout (in seconds). */
  durationSeconds?: Maybe<Scalars['Int']>;
  /** Timestamp when the chat timeout expires. */
  expiresAt?: Maybe<Scalars['Time']>;
  /** Reason of the action. */
  reason?: Maybe<Scalars['String']>;
};

/** TaxInterview describes the information for a user's Amazon tax interview during payout onboarding. */
export type TaxInterview = {
   __typename?: 'TaxInterview';
  /** Amazon tax interview account ID. */
  accountID: Scalars['ID'];
  /** Amazon tax interview client ID. */
  clientID: Scalars['ID'];
  /** Legal name of the user completing the Amazon tax interview. */
  governmentAlias: Scalars['String'];
  /** The preferred locale for user in the accepted format to initate the Amazon tax interview (e.g. "en_US"). */
  locale: Scalars['String'];
  /** Unique signature to initiate the Amazon tax interview. */
  signature: Scalars['String'];
  /** The type of Amazon tax interview. */
  type: TaxInterviewType;
  /** The URL for user to begin their Amazon tax interview. */
  url: Scalars['String'];
};

/** TaxInterviewType enumerates valid Amazon tax interview types. */
export enum TaxInterviewType {
  /** Describes an Amazon tax interview that would allow users to receive royalty income through licensed content. */
  Royalty = 'ROYALTY',
  /** Describes an Amazon tax interview that would allow users to receive income for their goods and services. */
  Service = 'SERVICE'
}

/** TaxMismatchError enumerates valid registration and tax interview field names for payout onboarding. */
export enum TaxMismatchError {
  /**
   * Applied when the user submits a name that does not match the name on their registration.
   * If provided, the company name will be compared intead of the user's full legal name.
   */
  Name = 'NAME',
  /** Applied when the user submits a country that does not match the country on their registration. */
  Country = 'COUNTRY',
  /** Applied when the user submits an email that does not match the email on their registration. */
  Email = 'EMAIL',
  /** Applied when the user submits a street address that does not match the street address on their registration. */
  StreetAddress = 'STREET_ADDRESS',
  /** Applied when the user submits a street address 2 that does not match the street address 2 on their registration. */
  StreetAddress_2 = 'STREET_ADDRESS_2',
  /** Applied when the user submits a city that does not match the city on their registration. */
  City = 'CITY',
  /** Applied when the user submits a state that does not match the state on their registration. */
  State = 'STATE',
  /** Applied when the user submits a postal that does not match the postal on their registration. */
  Postal = 'POSTAL'
}

/** Represents a tax jurisdiction from which a final price was calculated. */
export type TaxRegion = {
   __typename?: 'TaxRegion';
  /** Tax country, required for the TaxRegion object type. */
  countryCode: Scalars['String'];
  /** Tax state if applicable. */
  state?: Maybe<Scalars['String']>;
  /** Tax zip code if applicable. */
  zipCode?: Maybe<Scalars['String']>;
};

/**
 * Team represents a Twitch Team.
 * Teams are collections of streaming channels, and are owned by a Twitch user.
 * Teams have landing pages, e.g. https://www.twitch.tv/team/clg.
 */
export type Team = {
   __typename?: 'Team';
  /** ID to an image meant to be the background of the Team's landing page. */
  backgroundImageID?: Maybe<Scalars['ID']>;
  /** URL to an image meant to be the background of the Team's landing page. */
  backgroundImageURL?: Maybe<Scalars['String']>;
  /** ID to the Team's banner image. */
  bannerID?: Maybe<Scalars['ID']>;
  /** URL to the Team's banner image. */
  bannerURL?: Maybe<Scalars['String']>;
  /**
   * Retrieves team stats within the start and end time broken down by granularity.
   * Default end time will be the current time (now).
   * Granularity defaults to 5 minutes.
   * ChannelIDs defaults to all team members.
   */
  creatorTimeseriesMetrics?: Maybe<CreatorTimeseriesMetrics>;
  /** Information about the team, formatted in Markdown. */
  description?: Maybe<Scalars['String']>;
  /** Display version of the team name. */
  displayName: Scalars['String'];
  /** The Team's ID. */
  id: Scalars['ID'];
  /**
   * Channels that the Team owner have opted to highlight that are currently live.
   * These channels may or may not also be members of the Team.
   * They will be returned in the order configured by the Team admin.
   */
  liveFeaturedChannels?: Maybe<UserConnection>;
  /**
   * Users that belong to the team that are currently live.
   * They will be returned in the order configured by the Team admin.
   */
  liveMembers?: Maybe<UserConnection>;
  /** ID to the Team's logo image. */
  logoID?: Maybe<Scalars['ID']>;
  /** URL to the Team's logo image. */
  logoURL?: Maybe<Scalars['String']>;
  /**
   * The list of users that belong to this team.
   * They will be returned in the order configured by the Team admin.
   */
  members?: Maybe<UserConnection>;
  /** The alphanumeric Twitch name of the team. */
  name: Scalars['String'];
  /** Owner is the User that owns and manages the Team. */
  owner?: Maybe<User>;
  /**
   * Aggregated analytics for several video referral sources, for use in teams dashboard.
   * ChannelIDs defaults to all team members.
   */
  videoPlayReferrals?: Maybe<VideoPlayReferrals>;
};


/**
 * Team represents a Twitch Team.
 * Teams are collections of streaming channels, and are owned by a Twitch user.
 * Teams have landing pages, e.g. https://www.twitch.tv/team/clg.
 */
export type TeamCreatorTimeseriesMetricsArgs = {
  startAt: Scalars['Time'];
  endAt?: Maybe<Scalars['Time']>;
  granularity?: Maybe<Granularity>;
  channelIDs?: Maybe<Array<Scalars['ID']>>;
};


/**
 * Team represents a Twitch Team.
 * Teams are collections of streaming channels, and are owned by a Twitch user.
 * Teams have landing pages, e.g. https://www.twitch.tv/team/clg.
 */
export type TeamLiveFeaturedChannelsArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};


/**
 * Team represents a Twitch Team.
 * Teams are collections of streaming channels, and are owned by a Twitch user.
 * Teams have landing pages, e.g. https://www.twitch.tv/team/clg.
 */
export type TeamLiveMembersArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};


/**
 * Team represents a Twitch Team.
 * Teams are collections of streaming channels, and are owned by a Twitch user.
 * Teams have landing pages, e.g. https://www.twitch.tv/team/clg.
 */
export type TeamMembersArgs = {
  first?: Maybe<Scalars['Int']>;
  after?: Maybe<Scalars['Cursor']>;
};


/**
 * Team represents a Twitch Team.
 * Teams are collections of streaming channels, and are owned by a Twitch user.
 * Teams have landing pages, e.g. https://www.twitch.tv/team/clg.
 */
export type TeamVideoPlayReferralsArgs = {
  start: Scalars['Time'];
  end: Scalars['Time'];
  filter?: Maybe<ReferralsFilter>;
  dimension: ReferralsDimension;
  first?: Maybe<Scalars['Int']>;
  channelIDs?: Maybe<Array<Scalars['ID']>>;
};

/** Inputs for terminating a poll. */
export type TerminatePollInChannelInput = {
  /** The id of the channel with the poll to terminate. */
  channelID: Scalars['ID'];
};

/** Outputs from the terminate poll mutation. */
export type TerminatePollInChannelPayload = {
   __typename?: 'TerminatePollInChannelPayload';
  /** The terminated poll. */
  poll?: Maybe<Poll>;
};

/** Inputs for terminating a poll. */
export type TerminatePollInput = {
  /** The id of the poll to terminate. */
  pollID: Scalars['ID'];
};

/** Outputs from the create poll mutation. */
export type TerminatePollPayload = {
   __typename?: 'TerminatePollPayload';
  /** The created poll. */
  poll?: Maybe<Poll>;
};

/** A shelf title token type that contains text with various formatters. */
export type TextToken = {
   __typename?: 'TextToken';
  /** If this title token should be emphasized or not. */
  hasEmphasis: Scalars['Boolean'];
  /** The location that this shelf title token should link to. */
  location: LinkType;
  /** The text to display for this token. */
  text: Scalars['String'];
};

export type ThumbnailOEmbed = {
   __typename?: 'ThumbnailOEmbed';
  height: Scalars['Int'];
  url: Scalars['String'];
  width: Scalars['Int'];
};


/** Single item of stats for the time series. */
export type TimeseriesItem = {
   __typename?: 'TimeseriesItem';
  /**
   * Deprecated: Number of follows during this timestamp.
   * @deprecated Use user.timeseriesStats.follows instead.
   */
  follows?: Maybe<Scalars['Int']>;
  /** Streamed duration (in minutes). */
  minutesStreamed: Scalars['Int'];
  /** Timestamp of the broken down time series. */
  timestamp: Scalars['Time'];
  /** Value at the timestamp. */
  value: Scalars['Float'];
};

/** Stats within a time frame broken down by granularity. */
export type TimeseriesStats = {
   __typename?: 'TimeseriesStats';
  /** Seconds of ads played per time chunk. */
  adBreaksInSeconds?: Maybe<Array<TimeseriesItem>>;
  /** Ad time (in seconds) per hour per time chunk. */
  adTimePerHour?: Maybe<Array<TimeseriesItem>>;
  /** Average number of viewers per time chunk. */
  averageViewers?: Maybe<Array<TimeseriesItem>>;
  /** Number of chat messages per time chunk. */
  chatMessages?: Maybe<Array<TimeseriesItem>>;
  /** Number of clip views per time chunk. */
  clipViews?: Maybe<Array<TimeseriesItem>>;
  /** Number of clips created per time chunk. */
  clipsCreated?: Maybe<Array<TimeseriesItem>>;
  /** Number of follows during this timestamp. */
  follows?: Maybe<Array<TimeseriesItem>>;
  /** Granularity of the time series, default unit is five minutes. */
  granularity: Granularity;
  /** Host/Raid viewers per time chunk. */
  hostRaidViewers?: Maybe<Array<TimeseriesItem>>;
  /**
   * Deprecated: List of the number of follows within a time period, broken up by granularity.
   * @deprecated Use specific metric from user.timeseriesStats instead.
   */
  items?: Maybe<Array<TimeseriesItem>>;
  /** Live number of views per time chunk. */
  liveViews?: Maybe<Array<TimeseriesItem>>;
  /** Max viewers per time chunk. */
  maxViewers?: Maybe<Array<TimeseriesItem>>;
  /** Minutes watched per time chunk. */
  minutesWatched?: Maybe<Array<TimeseriesItem>>;
  /** Number of subscriptions per time chunk. */
  newSubscriptions?: Maybe<Array<TimeseriesItem>>;
  /** Time streamed per time chunk. */
  timeStreamed?: Maybe<Array<TimeseriesItem>>;
  /** Number of people chatting per time chunk. */
  uniqueChatters?: Maybe<Array<TimeseriesItem>>;
  /** Number of unique people watching per time chunk. */
  uniqueViewers?: Maybe<Array<TimeseriesItem>>;
};

/** A piece of the shelf title in the form of a token. */
export type TitleTokenEdge = {
   __typename?: 'TitleTokenEdge';
  /** The token. */
  node?: Maybe<TitleTokenNode>;
};

/** The content of a shelf title token. */
export type TitleTokenNode = Game | TextToken | User;

export type ToggleRitualsEnabledInput = {
  channelID: Scalars['ID'];
  isEnabled: Scalars['Boolean'];
};

export type ToggleRitualsEnabledPayload = {
   __typename?: 'ToggleRitualsEnabledPayload';
  /** Whether the rituals feature is enabled for a channel. */
  isEnabled: Scalars['Boolean'];
  user?: Maybe<User>;
};

/**
 * Assets for a TokenBundleProduct. 
 * Each asset will have a 1x, 2x, 3x sizing w/ their respective URLs. 
 * Different sizing is required for mobile clients.
 */
export type TokenBundleAsset = {
   __typename?: 'TokenBundleAsset';
  /** URL of asset of size 1x. */
  imageURL1x: Scalars['String'];
  /** URL of asset size 2x. */
  imageURL2x: Scalars['String'];
  /** URL of asset size 3x. */
  imageURL3x: Scalars['String'];
  /**
   * Key identifier for an asset.
   * ex) "bundleImg", "promoImg", etc.
   */
  key: Scalars['String'];
};

/**
 * Tournament is an object that contains all information about a tournament
 * managed within Bits for a specific event tied to cheering.
 * NOTE: Should have been named CheeringTournament.
 */
export type Tournament = {
   __typename?: 'Tournament';
  /**
   * Leaderboard of all users who have cheered in the tournament.
   * @deprecated Field no longer supported
   */
  globalLeaderboard: BitsLeaderboard;
  /**
   * Event ID of the tournament.
   * @deprecated Field no longer supported
   */
  id: Scalars['ID'];
  /**
   * The list of global milestones that can be claimed in the tournament.
   * For a given threshold, this milestone is reached when cheers from all users on the channel
   * is greater than or equal to the threshold. This unlocks a reward for all users who have cheered.
   * @deprecated Field no longer supported
   */
  progress: TournamentProgress;
  /**
   * The list of rewards that are a part of the tournament. This is separated out into global, participant, and individual
   * rewards that can be claimed if the user is logged in.
   * @deprecated Field no longer supported
   */
  rewards?: Maybe<TournamentRewards>;
  /**
   * The list of individual milestones that can be claimed in the tournament.
   * for a given threshold, this milestone is reached when an individual user's total cheers in
   * the channel is greater than or equal to the threshold. This unlocks a reward
   * for the individual user who cheered.
   * @deprecated Field no longer supported
   */
  self?: Maybe<TournamentSelfEdge>;
  /**
   * Leaderboard of all teams who have been cheered for in the tournament. This leaderboard contains how much each team
   * in the tournament was cheered for.
   * @deprecated Field no longer supported
   */
  teamLeaderboard: BitsLeaderboard;
  /**
   * The list of teams participating in the tournament.
   * @deprecated Field no longer supported
   */
  teams: Array<Maybe<TournamentTeam>>;
};

/** Contains all rewards information about the Insider rewards. */
export type TournamentInsiderRewards = {
   __typename?: 'TournamentInsiderRewards';
  /**
   * Twitch chat badge rewards.
   * @deprecated Field no longer supported
   */
  badges: Array<TournamentReward>;
  /**
   * Bits rewards.
   * @deprecated Field no longer supported
   */
  bits: Array<TournamentReward>;
  /**
   * Hero skin rewards.
   * @deprecated Field no longer supported
   */
  heroSkins: Array<TournamentReward>;
  /**
   * In Game Content rewards, like sprays and avatars (non-hero skin rewards).
   * @deprecated Field no longer supported
   */
  inGameContent: Array<TournamentReward>;
};

/** Describes the amount of progress that has been made in a tournament, with corresponding milestones about said progress. */
export type TournamentProgress = {
   __typename?: 'TournamentProgress';
  /**
   * The amount of progress that has been made in the tournament. This is not exclusive to cheering in the channel.
   * @deprecated Field no longer supported
   */
  amount: Scalars['Int'];
  /**
   * The milestones associated with the progress made. This is a list of rewards the progress value will unlock.
   * @deprecated Field no longer supported
   */
  milestones: Array<Milestone>;
};

/** Type containing information about a Reward and claiming information. */
export type TournamentReward = {
   __typename?: 'TournamentReward';
  /**
   * The campaign ID associated with the reward.
   * @deprecated Field no longer supported
   */
  campaignID: Scalars['ID'];
  /**
   * Can this reward be entitled to the user.
   * @deprecated Field no longer supported
   */
  canBeFulfilled: Scalars['Boolean'];
  /**
   * Number representing quantity of the reward that user can claim (but not entitled yet) at the time the request is made.
   * @deprecated Field no longer supported
   */
  canBeFulfilledQuantity: Scalars['Int'];
  /**
   * The reward's description.
   * @deprecated Field no longer supported
   */
  description: Scalars['String'];
  /**
   * Number representing quantity of the reward that user already claimed and can
   * find in his inventory. If the type is In Game Content, Twitch already handed
   * off to the game through the fulfiller.
   * @deprecated Field no longer supported
   */
  entitledQuantity: Scalars['Int'];
  /**
   * The ID of the reward.
   * @deprecated Field no longer supported
   */
  id: Scalars['ID'];
  /**
   * The reward's display image URL.
   * @deprecated Field no longer supported
   */
  imageURL: Scalars['String'];
  /**
   * The state of the reward is entitled to the user.
   * @deprecated Field no longer supported
   */
  isEntitled: Scalars['Boolean'];
  /**
   * Whether the reward is for prime users only.
   * @deprecated Field no longer supported
   */
  isPrimeOnly: Scalars['Boolean'];
  /**
   * Whether the reward can be earned multiple times (e.g. in game consumables).
   * @deprecated Field no longer supported
   */
  isRepeatable: Scalars['Boolean'];
  /**
   * Metadata attached to the reward.
   * @deprecated Field no longer supported
   */
  metadata?: Maybe<CampaignRewardMetadata>;
  /**
   * The display name of the reward.
   * @deprecated Field no longer supported
   */
  name: Scalars['String'];
  /**
   * Amount of reward (e.g. amount for bits).
   * @deprecated Field no longer supported
   */
  quantity: Scalars['Int'];
  /**
   * A number presenting the rarity of this reward (the higher the rarer).
   * @deprecated Field no longer supported
   */
  rarity: Scalars['Int'];
  /**
   * The type of reward (ex. Twitch Emote, In Game Content).
   * @deprecated Field no longer supported
   */
  type: Scalars['String'];
};

/**
 * This type holds all information about rewards that are associated with a tournament. The struct parses out
 * which rewards are Global, Team, and Individual, as well as if you're logged in that status if you can claim the reward.
 */
export type TournamentRewards = {
   __typename?: 'TournamentRewards';
  /**
   * The list of Cheerbomb rewards. If the user is logged in, this will also show the claim status of the reward.
   * @deprecated Field no longer supported
   */
  cheerbomb: Array<TournamentReward>;
  /**
   * The list of Global rewards. If the user is logged in, this will also show the claim status of the reward.
   * @deprecated Field no longer supported
   */
  global: Array<TournamentReward>;
  /**
   * The list of Individual rewards. If the user is logged in, this will also show the claim status of the reward.
   * @deprecated Field no longer supported
   */
  individual: Array<TournamentReward>;
  /**
   * The list of Insider rewards, which are granted when one subscribes to the insider pass.
   * @deprecated Field no longer supported
   */
  insider: TournamentInsiderRewards;
  /**
   * The list of Team rewards. If the user is logged in, this will also show the claim status of the reward.
   * @deprecated Field no longer supported
   */
  team: Array<TournamentReward>;
};

/** Tournament progress related to a user. */
export type TournamentSelfEdge = {
   __typename?: 'TournamentSelfEdge';
  /**
   * The leaderboard entry of the user. Gives the current position and score.
   * @deprecated Field no longer supported
   */
  globalLeaderboardItem?: Maybe<BitsLeaderboardItem>;
  /**
   * Amount of progress a user had made towards the tournament personally. This could be a combination of factors,
   * including bits cheered in the channel.
   * @deprecated Field no longer supported
   */
  progress: TournamentProgress;
  /**
   * A list of the amount of bits a user has cheered for a certain team, as well as the
   * list of milestones that the user could claim with their claim status.
   * @deprecated Field no longer supported
   */
  teams: Array<TournamentTeam>;
};

/**
 * Team is a construct that contains metadata about a team participating in the tournament,
 * as well as the milestones associated with cheering for them.
 */
export type TournamentTeam = {
   __typename?: 'TournamentTeam';
  /**
   * The division of the team. This string is set by the tournament organizer. (NA, CN, Atlantic League, etc.).
   * @deprecated Field no longer supported
   */
  division: Scalars['String'];
  /**
   * The ID of the team.
   * @deprecated Field no longer supported
   */
  id: Scalars['ID'];
  /**
   * The image URL of the team.
   * @deprecated Field no longer supported
   */
  logoURL: Scalars['String'];
  /**
   * Name of the team.
   * @deprecated Field no longer supported
   */
  name: Scalars['String'];
};

/** Information used to track recommendation events. */
export type TrackingInfo = {
   __typename?: 'TrackingInfo';
  /** The target object for the shelf, if it exists. */
  reasonTarget?: Maybe<Scalars['String']>;
  /** The type of the target object, if it exists. */
  reasonTargetType?: Maybe<Scalars['String']>;
  /** The reason why this shelf has been recommended. */
  reasonType: Scalars['String'];
  /** The name of the shelf. */
  rowName: Scalars['String'];
};

/** A tracking pixel is used to measure impressions or demographics. */
export type TrackingPixel = {
   __typename?: 'TrackingPixel';
  /** Where this pixel came from. */
  origin?: Maybe<Scalars['String']>;
  /** What service will be using the pixel. */
  service: Scalars['String'];
  /** How long a client needs to view the content before firing the pixel. */
  timeOffsetSeconds?: Maybe<Scalars['Int']>;
  /** The type of tracker. */
  type?: Maybe<TrackingPixelType>;
  /** The URL that is requested when the pixel is fired. */
  url: Scalars['String'];
};

/** The tracking pixel that will be created as part of this campaign. */
export type TrackingPixelInput = {
  /** How long a client needs to view the content before firing the pixel. */
  timeOffsetSeconds?: Maybe<Scalars['Int']>;
  /** The type of tracker. */
  type?: Maybe<TrackingPixelType>;
  /** The URL that is requested when the pixel is fired. */
  url: Scalars['String'];
};

/** The type of the tracking pixel. */
export enum TrackingPixelType {
  /** Digital Ad Ratings, a Nielsen product that provides demographic data. */
  Dar = 'DAR',
  /** DoubleClick Campaign Manager, a Google product to track ad performance. */
  Dcm = 'DCM',
  /** An impression tracking product. */
  Sizmek = 'SIZMEK'
}

/**
 * A trailer is a video meant to introduce viewers to the creator and the type
 * of content they produce.
 */
export type Trailer = {
   __typename?: 'Trailer';
  /** The trailer video. This may be null if the channel has no trailer. */
  video?: Maybe<Video>;
};

/** TranscodeSession is session metadata related to transcode. */
export type TranscodeSession = {
   __typename?: 'TranscodeSession';
  /** Transcoded audio codecs. */
  audioCodecs: Scalars['String'];
  /** Staff-only field. Hostname of which transcode was processed. */
  host?: Maybe<Scalars['String']>;
  /** Staff-only field. The location of transcode origin. */
  ingestOrigin?: Maybe<Scalars['String']>;
  /** Staff-only field. Profile of transcode. */
  profile?: Maybe<Scalars['String']>;
  /** Transcoded video codecs. */
  videoCodecs: Scalars['String'];
};

/** TransitionExtensionStateError is an error associated with the transitionExtensionState mutation. */
export enum TransitionExtensionStateError {
  /** User is unable to make modifications to the extension. */
  Unauthorized = 'UNAUTHORIZED',
  /** The version does not have an asset hash and it must for the transition. */
  MissingAssetHash = 'MISSING_ASSET_HASH',
  /** Review notes were not specified when transitioning an extension to IN_REVIEW. */
  MissingReviewNotes = 'MISSING_REVIEW_NOTES',
  /** Test channel was not specified when transitioning an extension to IN_REVIEW. */
  MissingTestChannel = 'MISSING_TEST_CHANNEL',
  /** Only one version of an Extension can be in a review state (APPROVED, or in IN_REVIEW) at a time. */
  MultipleVersionsInReview = 'MULTIPLE_VERSIONS_IN_REVIEW',
  /** Author email cannot be empty when transit to READY_FOR_REVIEW. */
  TransitionMissingAuthorEmail = 'TRANSITION_MISSING_AUTHOR_EMAIL',
  /** Author name cannot be empty when transit to READY_FOR_REVIEW. */
  TransitionMissingAuthorName = 'TRANSITION_MISSING_AUTHOR_NAME',
  /** Category cannot be empty when transit to READY_FOR_REVIEW. */
  TransitionMissingCategory = 'TRANSITION_MISSING_CATEGORY',
  /** Support email cannot be empty when transit to READY_FOR_REVIEW. */
  TransitionMissingSupportEmail = 'TRANSITION_MISSING_SUPPORT_EMAIL',
  /** Name cannot be empty when transit to READY_FOR_REVIEW. */
  TransitionMissingName = 'TRANSITION_MISSING_NAME',
  /** Version cannot be empty when transit to READY_FOR_REVIEW. */
  TransitionMissingVersion = 'TRANSITION_MISSING_VERSION',
  /** Testing base URI cannot be empty when transit to READY_FOR_REVIEW. */
  TransitionMissingTestingBaseUri = 'TRANSITION_MISSING_TESTING_BASE_URI',
  /** Summary cannot be empty when transit to READY_FOR_REVIEW. */
  TransitionMissingSummary = 'TRANSITION_MISSING_SUMMARY',
  /** Description cannot be empty when transit to READY_FOR_REVIEW. */
  TransitionMissingDescription = 'TRANSITION_MISSING_DESCRIPTION',
  /** Version specified is invalid. */
  InvalidVersion = 'INVALID_VERSION',
  /** At least one anchor must be specified. */
  AnchorRequired = 'ANCHOR_REQUIRED',
  /** HasZoom was specified but ZoomPixels is missing. */
  InvalidZoom = 'INVALID_ZOOM',
  /** The number of whitelisted broadcasters exceeds the limit. */
  MaxBroadcasters = 'MAX_BROADCASTERS',
  /** The number of whitelisted testing users exceeds the limit. */
  MaxTesters = 'MAX_TESTERS',
  /** The number of whitelisted config URLs exceeds the limit. */
  MaxWhitelistedConfigUrls = 'MAX_WHITELISTED_CONFIG_URLS',
  /** The number of whitelisted panel URLs exceeds the limit. */
  MaxWhitelistedPanelUrls = 'MAX_WHITELISTED_PANEL_URLS',
  /** Extension names must be shorter than 40 characters. */
  InvalidNameLength = 'INVALID_NAME_LENGTH',
  /** Extension description must be shorter than 1024 characters. */
  InvalidDescriptionLength = 'INVALID_DESCRIPTION_LENGTH',
  /** Extension summary must be shorter than 140 characters. */
  InvalidSummaryLength = 'INVALID_SUMMARY_LENGTH',
  /** Extension author email must not be nil. Lenght must be < 254, Parses a single RFC 5322 address. */
  InvalidAuthorEmail = 'INVALID_AUTHOR_EMAIL',
  /** Extension support email must not be nil. Lenght must be < 254, Parses a single RFC 5322 address. */
  InvalidSupportEmail = 'INVALID_SUPPORT_EMAIL',
  /** Extension author name length must be > 40. */
  InvalidAuthorNameLength = 'INVALID_AUTHOR_NAME_LENGTH',
  /** Extension testing base uri must not be nil and empty scheme. Scheme should be http or https. User should not be nil. */
  InvalidTestingBaseUri = 'INVALID_TESTING_BASE_URI',
  /** Extension terms uri must not be nil and empty scheme. Scheme should be http or https. User should not be nil. */
  InvalidTermsUri = 'INVALID_TERMS_URI',
  /** Extension privacy uri must not be nil and empty scheme. Scheme should be http or https. User should not be nil. */
  InvalidPrivacyUri = 'INVALID_PRIVACY_URI',
  /** Extension component viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidComponentViewerPath = 'INVALID_COMPONENT_VIEWER_PATH',
  /** Extension panel viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidPanelViewerPath = 'INVALID_PANEL_VIEWER_PATH',
  /** Extension video overlay viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidVideoOverlayViewerPath = 'INVALID_VIDEO_OVERLAY_VIEWER_PATH',
  /** Extension config viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidConfigViewerPath = 'INVALID_CONFIG_VIEWER_PATH',
  /** Extension live config viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidLiveConfigViewerPath = 'INVALID_LIVE_CONFIG_VIEWER_PATH',
  /** Extension mobile viewer path must not be nil. Format should be BaseUri/Extension_Path. */
  InvalidMobileViewerPath = 'INVALID_MOBILE_VIEWER_PATH',
  /** Extension component aspect width must be < 50 or > 1. */
  InvalidComponentAspectWidth = 'INVALID_COMPONENT_ASPECT_WIDTH',
  /** Extension component aspect height must be < 50 or > 1. */
  InvalidComponentAspectHeight = 'INVALID_COMPONENT_ASPECT_HEIGHT',
  /** Extension panel hiehgt must be < 500 or > 100. */
  InvalidPanelHeight = 'INVALID_PANEL_HEIGHT',
  /** Extension Bits Support Level must ba valid member of the BitsSupportLevelEnum. */
  InvalidBitsSupportLevel = 'INVALID_BITS_SUPPORT_LEVEL',
  /** Scale pixels must be set to a positive integer when autoscale is true. */
  InvalidScalingPixels = 'INVALID_SCALING_PIXELS',
  /** Aspect Ratio X must be set to a positive integer. */
  InvalidComponentAspectRatioX = 'INVALID_COMPONENT_ASPECT_RATIO_X',
  /** Aspect Ratio Y must be set to a positive integer. */
  InvalidComponentAspectRatioY = 'INVALID_COMPONENT_ASPECT_RATIO_Y',
  /** Target Height must be set to a positve integer. */
  InvalidComponentTargetHeight = 'INVALID_COMPONENT_TARGET_HEIGHT'
}

/** TransitionExtesnsionManifest updates the state of an existing extension. */
export type TransitionExtensionStateInput = {
  /** The extension ID of the extension to update. */
  id: Scalars['ID'];
  /**
   * Notes provided to the moderation team while reviewing the extension.
   * Required when transitioning to READY_FOR_REVIEW.
   */
  reviewNotes?: Maybe<Scalars['String']>;
  /** The State to transition the extension to. */
  state: ExtensionState;
  /**
   * URL to a test channel, provided to the moderation team while reviewing the extension.
   * Required when transitioning to READY_FOR_REVIEW.
   */
  testChannel?: Maybe<Scalars['String']>;
  /** The extension version to update. */
  version: Scalars['String'];
};

/** TransitionExtensionStatePayload returns any errors that occur during update. */
export type TransitionExtensionStatePayload = {
   __typename?: 'TransitionExtensionStatePayload';
  /** The error when the mutation fails to update an extension. */
  error?: Maybe<TransitionExtensionStateError>;
  /** The updated extension manifest. */
  manifest?: Maybe<ExtensionManifest>;
};

/** Trigger type determines what type of events activate the trigger. */
export enum TriggerType {
  /** CHEER type trigger is activated by cheer events. */
  Cheer = 'CHEER'
}

/**
 * TrueXAd is descriptive information about an engagement that was show for bits.
 * Used as input on the redeem trueXAd mutation.
 */
export type TrueXAd = {
  /** campaignID is the ID of the campaign this ad belongs to. */
  campaignID: Scalars['ID'];
  /** creativeID is the ID of the particular ad experience displayed to the user. */
  creativeID: Scalars['ID'];
  /** currencyAmount is the suggested amount of "currency" to provide to the user based on this ad. */
  currencyAmount: Scalars['String'];
  /** name is the name of the ad campaign. */
  name: Scalars['String'];
};

/** TutorialState represents the possible states of the user's viewing of the mod view tutorial. */
export enum TutorialState {
  /** DISMISSED occurs when a user dismisses the tutorial. */
  Dismissed = 'DISMISSED',
  /** SEEN occurs when a user has seen every step in a tutorial. */
  Seen = 'SEEN',
  /** UNSEEN is the initial state, before a user has either dismissed or viewed the tutorial entirely. */
  Unseen = 'UNSEEN'
}

/** Two Factor Methods the user can have enabled. */
export enum TwoFactorMethod {
  /**
   * The user has 2fa enabled but does not have the authy app installed. Only way
   * for the user to receive the 2fa verification code is SMS.
   */
  AuthySms = 'AUTHY_SMS',
  /**
   * The user has 2fa enabled and has the authy app installed. The 2fa verification
   * code can be retreived from the authy app OR SMS.
   */
  AuthyApp = 'AUTHY_APP',
  /** unknown 2fa method. */
  Unknown = 'UNKNOWN'
}

/**
 * Used to provide info on the subscription events that might have happened in another device
 * and not acknowledged in the current device.
 */
export type UnacknowledgedSubscriptionEvent = {
   __typename?: 'UnacknowledgedSubscriptionEvent';
  /** The user of the channel the subscription was for. */
  channel?: Maybe<User>;
  /** The time that the subscription benefits will expire. */
  endDate?: Maybe<Scalars['Time']>;
  /** The external product id. */
  externalProductID: Scalars['ID'];
  /** The current status of the subscription. One of "active", "will_not_renew", or "canceled". */
  status: UnacknowledgedSubscriptionEventState;
  /** The UUID of the subscription. */
  subscriptionID: Scalars['ID'];
};

/** Subscrption state of the reported unacknowledged events. */
export enum UnacknowledgedSubscriptionEventState {
  /** The subscription is active. */
  Active = 'ACTIVE',
  /** Subscription will not renew, but may still be active. */
  WillNotRenew = 'WILL_NOT_RENEW',
  /** Subscription will not renew and is not active. */
  Cancelled = 'CANCELLED',
  /** Subscription that is on hold. */
  OnHold = 'ON_HOLD'
}

export type UnbanUserFromChatRoomError = {
   __typename?: 'UnbanUserFromChatRoomError';
  code: UnbanUserFromChatRoomErrorCode;
};

export enum UnbanUserFromChatRoomErrorCode {
  /** User does not have permission to unban in channel. */
  Forbidden = 'FORBIDDEN',
  /** Target does not exist. */
  TargetNotFound = 'TARGET_NOT_FOUND',
  /** Target is not banned in channel. */
  TargetNotBanned = 'TARGET_NOT_BANNED'
}

export type UnbanUserFromChatRoomInput = {
  bannedUserLogin: Scalars['String'];
  channelID: Scalars['ID'];
};

export type UnbanUserFromChatRoomPayload = {
   __typename?: 'UnbanUserFromChatRoomPayload';
  /** The new ban status of this user regarding the specified channel. */
  ban?: Maybe<ChatRoomBanStatus>;
  /** Mutation error caused by the user input. */
  error?: Maybe<UnbanUserFromChatRoomError>;
};

export type UnblockUserInput = {
  /** ID of user to unblock. */
  targetUserID: Scalars['ID'];
};

export type UnblockUserPayload = {
   __typename?: 'UnblockUserPayload';
  /** User that was unblocked. */
  targetUser: User;
};

/** Data required to undo recommendation feedback. */
export type UndoRecommendationFeedbackInput = {
  /** The id of the feedback. */
  feedbackID: Scalars['ID'];
  /** The page this event was fired from. */
  sourceItemPage: Scalars['String'];
  /** The unique id given to this request. */
  sourceItemRequestID: Scalars['ID'];
  /** The unique tracking id of the shelf / shelf card. */
  sourceItemTrackingID: Scalars['ID'];
};

/** Returns the created feedback item back to the client. */
export type UndoRecommendationFeedbackPayload = {
   __typename?: 'UndoRecommendationFeedbackPayload';
  /** The id of the feedback you just undid. */
  feedbackID: Scalars['ID'];
};

/** UnfollowGameInput contains just the game ID of the game to unfollow. */
export type UnfollowGameInput = {
  gameID: Scalars['ID'];
};

/** UnfollowGamePayload is the response from unfollowing a game. */
export type UnfollowGamePayload = {
   __typename?: 'UnfollowGamePayload';
  /** The deleted follow relationship, if one existed beforehand. */
  follow?: Maybe<GameFollow>;
  /**
   * The game that was unfollowed
   * game.self.follow should now be null.
   */
  game?: Maybe<Game>;
};

export type UnfollowUserInput = {
  targetID: Scalars['ID'];
};

export type UnfollowUserPayload = {
   __typename?: 'UnfollowUserPayload';
  /** The deleted follow relationship. */
  follow?: Maybe<Follow>;
};

export type UnfriendUserInput = {
  /** The authenticated user will no longer be friends with the user whose ID is equal to targetID. */
  targetID: Scalars['ID'];
};

export type UnfriendUserPayload = {
   __typename?: 'UnfriendUserPayload';
  /** The user whose friend relationship was just destroyed by the authenticated user. */
  user?: Maybe<User>;
};

/** UnhostInput contains the necessary inputs to unhost a channel. */
export type UnhostInput = {
  /** Channel ID to unhost from. */
  channelID: Scalars['ID'];
};

/** UnhostPayload is the response after attempting to unhost. */
export type UnhostPayload = {
   __typename?: 'UnhostPayload';
  /** The channel that just unhosted. */
  channel?: Maybe<User>;
};

/** UninstallExtensionError is wrapper for error associated with the uninstallExtension mutation. */
export type UninstallExtensionError = {
   __typename?: 'UninstallExtensionError';
  /** Error code. */
  code: UninstallExtensionErrorCode;
};

/** UninstallExtensionErrorCode is an error code associated with UninstallExtensionError. */
export enum UninstallExtensionErrorCode {
  /** User is unable to make modifications to the extension. */
  Unauthorized = 'UNAUTHORIZED',
  /** Channel id is invalid, for example, is empty. */
  InvalidChannelId = 'INVALID_CHANNEL_ID',
  /** The extension is not installed on the channel. */
  ExtensionNotInstalled = 'EXTENSION_NOT_INSTALLED'
}

/** The required input for an uninstallExtension mutation. */
export type UninstallExtensionInput = {
  /** The composite ID of an extension installation <extensionID:version:channelID>. */
  extensionInstallationID: Scalars['ID'];
};

/** The resulting payload of an uninstallExtension mutation. */
export type UninstallExtensionPayload = {
   __typename?: 'UninstallExtensionPayload';
  /** The error when the mutation fails to set feature flags. */
  error?: Maybe<UninstallExtensionError>;
  /** The id of the extension which was uninstalled. */
  id: Scalars['ID'];
};

/** UnlinkAmazonConnectionInput represent the parameters necessary to unlink an amazon connection. */
export type UnlinkAmazonConnectionInput = {
  /** Id of the user that wishes to unlink his amazon connection. */
  userID?: Maybe<Scalars['ID']>;
};

/** UnlinkAmazonConnectionPayload indicates whether the unlinking was successful or not. */
export type UnlinkAmazonConnectionPayload = {
   __typename?: 'UnlinkAmazonConnectionPayload';
  /**
   * Whether or not the unlink operation was successful. Only reports if the
   * underlying call was successful, as such will return true even if no unlinking
   * occured (such as when as user doesn't have a linked amazon account, for instance).
   */
  isSuccess?: Maybe<Scalars['Boolean']>;
};

/** User ID input of the connection being deleted. */
export type UnlinkRiotConnectionInput = {
  /** Twitch User ID to delete. */
  userID: Scalars['ID'];
};

/** Contains a struct of all current accounts connections. */
export type UnlinkRiotConnectionPayload = {
   __typename?: 'UnlinkRiotConnectionPayload';
  /** The complete account connections list where Riot will be null. */
  connections?: Maybe<AccountConnectionSet>;
};

export type UnlinkSsoInput = {
  /** The single sign-on (SSO) app that should be unlinked from the authenticated user's account. */
  app: Scalars['String'];
  /** The token that identifies the user on the linked SSO app. */
  token?: Maybe<Scalars['String']>;
};

export type UnlinkSsoPayload = {
   __typename?: 'UnlinkSSOPayload';
  /** The deleted SSO links. */
  links?: Maybe<Array<SsoLink>>;
};

/** Input for unlocking a chosen modified subscriber emote with Community Points. */
export type UnlockChosenModifiedSubscriberEmoteInput = {
  /** The channel the emote is being redeemed on. */
  channelID: Scalars['ID'];
  /** The client's perception of the reward's cost. */
  cost: Scalars['Int'];
  /** The modified emote to unlock. */
  emoteID: Scalars['ID'];
  /** Client-set identifier for the transaction. This ID should be universally unique. */
  transactionID: Scalars['ID'];
};

/** The response from redeeming the unlock a chosen modified subscriber emote reward. */
export type UnlockChosenModifiedSubscriberEmotePayload = {
   __typename?: 'UnlockChosenModifiedSubscriberEmotePayload';
  /** The user's new Community Points balance. */
  balance?: Maybe<Scalars['Int']>;
  /** The error that occurred during redemption, if any. */
  error?: Maybe<CommunityPointsUnlockEmoteError>;
};

/** Input for unlocking a chosen subscriber emote with Community Points. */
export type UnlockChosenSubscriberEmoteInput = {
  /** The channel the emote is being redeemed on. */
  channelID: Scalars['ID'];
  /** The client's perception of the reward's cost. */
  cost: Scalars['Int'];
  /** The emote to unlock. */
  emoteID: Scalars['ID'];
  /** Client-set identifier for the transaction. This ID should be universally unique. */
  transactionID: Scalars['ID'];
};

/** The response from redeeming the unlock a chosen subscriber emote reward. */
export type UnlockChosenSubscriberEmotePayload = {
   __typename?: 'UnlockChosenSubscriberEmotePayload';
  /** The user's new Community Points balance. */
  balance?: Maybe<Scalars['Int']>;
  /** The error that occurred during redemption, if any. */
  error?: Maybe<CommunityPointsUnlockEmoteError>;
};

/** Input for unlocking a random subscriber emote with Community Points. */
export type UnlockRandomSubscriberEmoteInput = {
  /** The channel the emote is being redeemed on. */
  channelID: Scalars['ID'];
  /** The client's perception of the reward's cost. */
  cost: Scalars['Int'];
  /** Client-set identifier for the transaction. This ID should be universally unique. */
  transactionID: Scalars['ID'];
};

/** The response from redeeming the unlock a random subscriber emote reward. */
export type UnlockRandomSubscriberEmotePayload = {
   __typename?: 'UnlockRandomSubscriberEmotePayload';
  /** The user's new Community Points balance. */
  balance?: Maybe<Scalars['Int']>;
  /** The random emote that was unlocked. */
  emote?: Maybe<CommunityPointsEmote>;
  /** The error that occurred during redemption, if any. */
  error?: Maybe<CommunityPointsUnlockEmoteError>;
};

/** ModUserError contains details about a client error that occurred. */
export type UnmodUserError = {
   __typename?: 'UnmodUserError';
  /** The enum indicating what error has occurred. */
  code: UnmodUserErrorCode;
};

/** UnmodUserErrorCode defines a client error that occurred while remove a moderator. */
export enum UnmodUserErrorCode {
  /** The requesting user does not have permission to add a moderator in this channel. */
  Forbidden = 'FORBIDDEN',
  /** The target user does not exist or has a suspended account. */
  TargetNotFound = 'TARGET_NOT_FOUND',
  /** The channel does not exist. */
  ChannelNotFound = 'CHANNEL_NOT_FOUND',
  /** The target user is not a moderator. */
  TargetNotMod = 'TARGET_NOT_MOD'
}

/** UnmodUserInput contains the parameters to remove a user as a moderator to a channel. */
export type UnmodUserInput = {
  /** The channel that the user will be removed as a moderator to. */
  channelID: Scalars['ID'];
  /**
   * The ID of the user that will be removed as a moderator.
   * Either targetID or targetLogin must be provided.
   */
  targetID?: Maybe<Scalars['ID']>;
  /**
   * The login of the user that will be removed as a moderator.
   * Either targetID or targetLogin must be provided.
   */
  targetLogin?: Maybe<Scalars['String']>;
};

/** UnmodUserPayload is the response when remove a user as a moderator. */
export type UnmodUserPayload = {
   __typename?: 'UnmodUserPayload';
  /** The channel that the user is removed as a moderator to. */
  channel?: Maybe<User>;
  /**
   * The client error that has occurred.
   * Null if the operation is successful.
   */
  error?: Maybe<UnmodUserError>;
  /** The user that is removed as a moderator. */
  target?: Maybe<User>;
};

/** UnsetHypeTrainConfigInput takes series of optional config settings and unsets the custom value for the default.. */
export type UnsetHypeTrainConfigInput = {
  /** Custom emote to be rendered in Hype Train messaging. */
  calloutEmote?: Maybe<Scalars['Boolean']>;
  /** Length of the cooldown period after a hype train ends. */
  cooldownPeriodMinutes?: Maybe<Scalars['Boolean']>;
  /** The difficulty of hype train levels. */
  difficulty?: Maybe<Scalars['Boolean']>;
  /** Hype Train kickoff settings. */
  eventsThreshold?: Maybe<Scalars['Boolean']>;
  /** Whether hype train should be enabled. */
  isEnabled?: Maybe<Scalars['Boolean']>;
  /** Custom color hex string that will be the base color of the Hype Train progress bar. */
  themeColor?: Maybe<Scalars['Boolean']>;
};

/** UnsetHypeTrainConfigPayload is the response that contains the Unsetd config. */
export type UnsetHypeTrainConfigPayload = {
   __typename?: 'UnsetHypeTrainConfigPayload';
  /** The hype train config for the channel. */
  config?: Maybe<HypeTrainConfig>;
};

/** Input to the unsubscribe mutation. One of "channel" or "type" fields must be provided. */
export type UnsubscribeEmailInput = {
  /** The unique ID of the origin email. */
  sourceEmailID: Scalars['String'];
  /** The email type of the origin email. */
  sourceEmailType: Scalars['String'];
  /** ID of the channel whose notifications should be blocked. */
  targetChannelID?: Maybe<Scalars['ID']>;
  /** The email type from which the user is unsubscribing. */
  targetEmailType?: Maybe<Scalars['String']>;
  /** ID of the user requesting the unsubscribe action. */
  userID: Scalars['ID'];
  /** Server signature to verify authenticity of the link author. */
  validatingHash: Scalars['String'];
};

/** Output from the unsubscribe mutation. */
export type UnsubscribeEmailPayload = {
   __typename?: 'UnsubscribeEmailPayload';
  /** Specifies whether the action was successful. */
  isSuccess: Scalars['Boolean'];
};

/** Inputs to the updateAdProperties mutation. */
export type UpdateAdPropertiesInput = {
  /** Toggle for disable prerolls for midrolls feature. */
  hasDisablePrerollsAbilityEnabled?: Maybe<Scalars['Boolean']>;
  /**
   * Toggle for disable prerolls for midrolls notifcations.
   * The "Disable Prerolls" product is a way for streamers to disable preroll ads by running midroll ads.
   * The streamer can choose to enable notifications (ie. "Preroll Ads are now disabled for X minutes") for this product.
   */
  hasDisablePrerollsNotificationsEnabled?: Maybe<Scalars['Boolean']>;
  /** Toggle for enable multiplayer ads for subs. */
  isMultiplayerAdsForSubsEnabled?: Maybe<Scalars['Boolean']>;
  /** User the update belongs to. */
  targetUserID: Scalars['ID'];
};

/** Output from the updateAdProperties mutation. */
export type UpdateAdPropertiesPayload = {
   __typename?: 'UpdateAdPropertiesPayload';
  /** User/channel to update the ad settings. */
  targetUser?: Maybe<User>;
};

export type UpdateAllWhisperThreadsInput = {
  markAllAsRead?: Maybe<Scalars['Boolean']>;
};

export type UpdateAllWhisperThreadsPayload = {
   __typename?: 'UpdateAllWhisperThreadsPayload';
  count: Scalars['Int'];
};

/** UpdateAutohostSettingsInput update a user's autohost settings. */
export type UpdateAutohostSettingsInput = {
  /** True if this channel has the autohost feature turned on. */
  isEnabled?: Maybe<Scalars['Boolean']>;
  /** The strategy to use when choosing channels to autohost. */
  strategy?: Maybe<AutohostSettingsStrategy>;
  /** UserID to update settings for. */
  userID: Scalars['ID'];
  /** True if this user autohosts their team members. */
  willAutohostTeam?: Maybe<Scalars['Boolean']>;
  /** True if this channels prefers autohost over vodcast. */
  willPrioritizeAutohost?: Maybe<Scalars['Boolean']>;
};

/** UpdateAutohostSettingsPayload returns the user whose settings had been updated. */
export type UpdateAutohostSettingsPayload = {
   __typename?: 'UpdateAutohostSettingsPayload';
  /** User whose autohost settings has been updated. */
  user?: Maybe<User>;
};

export type UpdateAutoModPropertiesInput = {
  /** These fields should be values between 0 and 4 inclusive. */
  aggressiveLevel: Scalars['Int'];
  /** String ID of the channel AutoModProperties are being updated for. */
  channelID: Scalars['String'];
  identityLevel: Scalars['Int'];
  profanityLevel: Scalars['Int'];
  sexualLevel: Scalars['Int'];
};

export type UpdateAutoModPropertiesPayload = {
   __typename?: 'UpdateAutoModPropertiesPayload';
  /** The new properties after applying the mutation. */
  autoModProperties?: Maybe<AutoModProperties>;
};

/** UpdateBitsBadgeTierNotificationInput is the input required when updating a bits badge tier notification. */
export type UpdateBitsBadgeTierNotificationInput = {
  /** Optional message to send when sharing notification. If supplied, will accompany user notice. */
  message?: Maybe<Scalars['String']>;
  /** Unique Identifier for the notification. */
  notificationID: Scalars['ID'];
  /** New state for notification. */
  notificationState: BitsBadgeTierNotificationState;
};

/** UpdateBitsBadgeTierNotificationPayload is the payload returned after updating a bits badge tier notification. */
export type UpdateBitsBadgeTierNotificationPayload = {
   __typename?: 'UpdateBitsBadgeTierNotificationPayload';
  /** The user that updated the bits badge tier notification. */
  user?: Maybe<User>;
};

/** Errors for updating bits badges. */
export type UpdateBitsBadgeTiersError = {
   __typename?: 'UpdateBitsBadgeTiersError';
  /** The associated error code. */
  code: UpdateBitsBadgeTiersErrorCode;
};

/** Possible error codes returned for updating bits badges. */
export enum UpdateBitsBadgeTiersErrorCode {
  /** Invalid parameters in the request. */
  InvalidParameter = 'INVALID_PARAMETER',
  /** Badge title is too long. */
  BadgeTitleExceedsCharacterLimit = 'BADGE_TITLE_EXCEEDS_CHARACTER_LIMIT',
  /** Badge title did not pass moderation check. */
  BadgeTitleFailedModeration = 'BADGE_TITLE_FAILED_MODERATION',
  /** The emote code submitted collides with an existing emote code. */
  EmoteCodeAlreadyExists = 'EMOTE_CODE_ALREADY_EXISTS',
  /** Data for least one of the image sizes is not provided. */
  IncompleteBadgeImageData = 'INCOMPLETE_BADGE_IMAGE_DATA',
  /** Other errors returned from the service. */
  UnknownError = 'UNKNOWN_ERROR'
}

/** Settings related to bits badges. */
export type UpdateBitsBadgeTiersInput = {
  /** A list of bits badge tiers to be modified. */
  tiers?: Maybe<Array<BitsBadgeTierInput>>;
  /** The owner ID of the channel that the badge tiers belong to. */
  userID: Scalars['ID'];
};

/** Results of bits badge tier updates. */
export type UpdateBitsBadgeTiersPayload = {
   __typename?: 'UpdateBitsBadgeTiersPayload';
  /** Whether or not the broadcaster is enabled to upload bits badge tier emote rewards. */
  canUploadBadgeTierEmoticons?: Maybe<Scalars['Boolean']>;
  /** Service error, if any. */
  error?: Maybe<UpdateBitsBadgeTiersError>;
  /** Updated bits badge tiers. */
  tiers?: Maybe<Array<BitsBadgeTier>>;
};

/** The required input for a updateBroadcastSettings mutation. */
export type UpdateBroadcastSettingsInput = {
  /** Indicate Brocadcaster's streaming language. */
  broadcasterLanguage?: Maybe<Scalars['String']>;
  /** The title of the game that the broadcaster is playing. */
  game?: Maybe<Scalars['String']>;
  /** The isMature boolean to set onto the user broadcast. */
  isMature?: Maybe<Scalars['Boolean']>;
  /** Channel's streaming Status. */
  status?: Maybe<Scalars['String']>;
  /** The Id of the user whose broadcast setting is being updated. */
  userID: Scalars['ID'];
};

/** The result of a updateBroadcastSettings mutation. */
export type UpdateBroadcastSettingsPayload = {
   __typename?: 'UpdateBroadcastSettingsPayload';
  /** The modified broadcast settings. */
  broadcastSettings?: Maybe<BroadcastSettings>;
};

/** Inputs for updating the user's celebration config. */
export type UpdateCelebrationConfigInput = {
  /** ID of channel to update the celebration config. */
  channelID: Scalars['ID'];
  /** If turn, celebrations are enabled on the channel. */
  isEnabled: Scalars['Boolean'];
};

/** Outputs from the update celebration config mutation. */
export type UpdateCelebrationConfigPayload = {
   __typename?: 'UpdateCelebrationConfigPayload';
  /** The updated celebration config. */
  celebrationConfig?: Maybe<CelebrationConfig>;
  /** If present, there was an error with the request. */
  error?: Maybe<CelebrationError>;
};

/** Inputs for creating a new celebration. */
export type UpdateCelebrationInput = {
  /** Where on the channel page the celebration will show. */
  area?: Maybe<CelebrationArea>;
  /** ID of celebration to update. */
  celebrationID: Scalars['ID'];
  /** ID of channel where the celebration to update exists. */
  channelID: Scalars['ID'];
  /** Length the celebration will play. */
  durationMilliseconds?: Maybe<Scalars['Int']>;
  /** Effect which will show when the celebration triggers (ex Fireworks). */
  effect?: Maybe<CelebrationEffect>;
  /** Threshold which will trigger the celebration (ex: Cheering 100 Bits). */
  eventThreshold?: Maybe<Scalars['Int']>;
  /** Event type which will trigger the celebration (ex: Cheering Bits). */
  eventType?: Maybe<CelebrationEventType>;
  /**
   * Intensity of the celebration.
   * Should be bounded (TBA) value which will determine the spectacle of the celebration.
   */
  intensity?: Maybe<Scalars['Int']>;
  /** If true, the celebration is enabled. */
  isEnabled?: Maybe<Scalars['Boolean']>;
};

/** Outputs from the Update celebration mutation. */
export type UpdateCelebrationPayload = {
   __typename?: 'UpdateCelebrationPayload';
  /** The updated celebration. */
  celebration?: Maybe<Celebration>;
  /** If present, there was an error with the request. */
  error?: Maybe<CelebrationError>;
};

/** The result of a UpdateChangelogReadTimePayload mutation. */
export type UpdateChangelogReadTimePayload = {
   __typename?: 'UpdateChangelogReadTimePayload';
  /** The user whose changelog was marked as read. */
  user?: Maybe<User>;
};

/** Mutation input for updating chanlet content attributes. */
export type UpdateChanletContentAttributesInput = {
  /** Identifier of the chanlet. */
  chanletID: Scalars['ID'];
  /**
   * A list of multi-view content attribute IDs.
   * The provided list will override the list of IDs currently stored.
   */
  contentAttributeIDs?: Maybe<Array<Scalars['ID']>>;
};

/** Response payload. */
export type UpdateChanletContentAttributesPayload = {
   __typename?: 'UpdateChanletContentAttributesPayload';
  /** Updated chanlet. */
  chanlet?: Maybe<Channel>;
};

/** The possible error returned. */
export enum UpdateChannelCategoryShelfError {
  /** The user making the update is not authorized to do so. */
  Forbidden = 'FORBIDDEN',
  /** One or more of the category IDs in the input are invalid. */
  InvalidCategory = 'INVALID_CATEGORY',
  /** The same category ID cannot be both shown and hidden. */
  CannotShowAndHideCategory = 'CANNOT_SHOW_AND_HIDE_CATEGORY'
}

/** The input to update a channel's category shelf content. */
export type UpdateChannelHomePreferencesInput = {
  /** A list of category IDs to hide from the category shelf. */
  categoryIDsToHide?: Maybe<Array<Scalars['ID']>>;
  /** A list of category IDs to unhide from the category shelf. */
  categoryIDsToUnhide?: Maybe<Array<Scalars['ID']>>;
  /** The ID of the channel whose category shelf is being updated. */
  channelID: Scalars['ID'];
  /** The hero preset. */
  heroPreset?: Maybe<HeroPreset>;
  /** The type of streamer shelf to display. */
  streamerShelfType?: Maybe<StreamerShelfType>;
};

/** The result of an update to the category shelf. */
export type UpdateChannelHomePreferencesPayload = {
   __typename?: 'UpdateChannelHomePreferencesPayload';
  /** The channel with the modified category shelf. */
  channel?: Maybe<Channel>;
  /** The possible error returned. */
  error?: Maybe<UpdateChannelCategoryShelfError>;
};

export type UpdateChatColorInput = {
  /**
   * Named color for normal users (e.g. "Blue"  or "Coral", see https://help.twitch.tv/customer/portal/articles/659095-twitch-chat-and-moderation-commands)
   * or a hex color for Turbo users (e.g. "#001122").
   */
  color: Scalars['String'];
};

export type UpdateChatColorPayload = {
   __typename?: 'UpdateChatColorPayload';
  /** The user whose chat color was set. */
  user?: Maybe<User>;
};

/**
 * Possible chat settings modifiable for the channel specified via ChannelID.
 * 
 * NOTE: Subscribers-only chat mode settings are in the UpdateSubscriptionProduct
 * mutation.
 */
export type UpdateChatSettingsInput = {
  /**
   * autoModLevel is an integer from 0-4 representing the level of automoderation of chat
   * 0 is off, 4 is the highest level of moderation.
   * 
   * Deprecated: No longer used.
   */
  autoModLevel?: Maybe<Scalars['Int']>;
  /** ID of the channel for which chat settings are being updated. */
  channelID: Scalars['String'];
  /** chatDelayInMs is the delay before non-mods see a message. */
  chatDelayInMs?: Maybe<Scalars['Int']>;
  /**
   * followersOnlyDurationMinutes is the number of minutes a user must have
   * followed the broadcaster before being able to chat.
   */
  followersOnlyDurationMinutes?: Maybe<Scalars['Int']>;
  /** hideLinks indicates if links should be deleted from non-mod messages. */
  hideLinks?: Maybe<Scalars['Boolean']>;
  /**
   * isBroadcasterLanguageModeEnabled indicates if the broadcaster requires chat messages to
   * match their language.
   * 
   * Deprecated: No longer used.
   */
  isBroadcasterLanguageModeEnabled?: Maybe<Scalars['Boolean']>;
  /**
   * Indicates whether chat is currently enforcing that messages may only contain
   * emotes.
   */
  isEmoteOnlyModeEnabled?: Maybe<Scalars['Boolean']>;
  /**
   * If isOptedOutOfGlobalBannedWordsList is true, the legacy twitch banned words list will
   * be inserted into automod if the channel has automod enabled.
   * 
   * Deprecated: No longer used.
   */
  isOptedOutOfGlobalBannedWordsList?: Maybe<Scalars['Boolean']>;
  /**
   * Indicates whether chat is currently enforcing that messages must be
   * reasonably unique from recent messages. Previously known as "r9k mode".
   */
  isUniqueChatModeEnabled?: Maybe<Scalars['Boolean']>;
  /** requireVerifiedAccount indicates if users must be verified to chat. */
  requireVerifiedAccount?: Maybe<Scalars['Boolean']>;
  /** A list of chat rules to display to users when joining a chat channel. */
  rules?: Maybe<Array<Scalars['String']>>;
  /**
   * The number of seconds a user must wait in between sending chat messages
   * If value is null, slow mode is not enabled.
   */
  slowModeDurationSeconds?: Maybe<Scalars['Int']>;
};

/** Result of mutation is the updated ChatSettings object. */
export type UpdateChatSettingsPayload = {
   __typename?: 'UpdateChatSettingsPayload';
  /** The new chatSettings after applying the mutation. */
  chatSettings?: Maybe<ChatSettings>;
};

/** Partner settings related to chat badges with bits. */
export type UpdateCheerPartnerSettingsBadgesInput = {
  /** A list of tiers to modify. */
  tiers?: Maybe<Array<BitsBadgeTierInput>>;
};

/** Partner settings related to chat messages with bits. */
export type UpdateCheerPartnerSettingsChatMessageInput = {
  /** The setting that controls if the user has project v enabled on their channel. */
  isOptedOutOfProjectV?: Maybe<Scalars['Boolean']>;
  /** The minimnm setting that controls the minimum bits that must be part of a cheer emote. */
  minBitsPerEmote?: Maybe<Scalars['Int']>;
  /** The minimum setting that controls the minimum amount a user must cheer in the channel. */
  minBitsToCheer?: Maybe<Scalars['Int']>;
};

/** Settings related to bits cheer bomb events. */
export type UpdateCheerPartnerSettingsCheerBombInput = {
  /** Flag that is true if the user has opted out of the cheer bomb event. */
  isOptedOut?: Maybe<Scalars['Boolean']>;
};

/** Partner settings related to the custom cheermote prefix. */
export type UpdateCheerPartnerSettingsCustomPrefixInput = {
  /** Flag that is set if the user has the custom cheermote prefix enabled. */
  isEnabled?: Maybe<Scalars['Boolean']>;
};

/** Mutation input for updating Bits partner channel settings. */
export type UpdateCheerPartnerSettingsInput = {
  /** Partner settings related to chat badges with bits. */
  badges?: Maybe<UpdateCheerPartnerSettingsBadgesInput>;
  /** Partner settings related to chat messages with bits. */
  chatMessage?: Maybe<UpdateCheerPartnerSettingsChatMessageInput>;
  /** Partner settings related to cheer bomb events. */
  cheerBombEvent?: Maybe<UpdateCheerPartnerSettingsCheerBombInput>;
  /** Partner settings related to the custom cheermote prefix. */
  customPrefix?: Maybe<UpdateCheerPartnerSettingsCustomPrefixInput>;
  /** Whether to onboard or offboard the user with bits. */
  isOnboarded?: Maybe<Scalars['Boolean']>;
  /** Partner settings related to the bits leaderboard. */
  leaderboard?: Maybe<UpdateCheerPartnerSettingsLeaderboardInput>;
  /** Partner settings related to the recent cheer message. */
  recentCheer?: Maybe<UpdateCheerPartnerSettingsRecentCheerInput>;
  /** Partner settings related to sponsored cheermote campaigns. */
  sponsoredCheermote?: Maybe<UpdateCheerPartnerSettingsSponsoredCheermoteInput>;
  /** The user ID to update channel settings. */
  userID: Scalars['ID'];
};

/** Partner settings related to the bits leaderboard. */
export type UpdateCheerPartnerSettingsLeaderboardInput = {
  /** Flag that is true if the user has bits leaderboards turned on. */
  isEnabled?: Maybe<Scalars['Boolean']>;
  /** The time period the user wants the leaderboard to be displayed as. */
  timePeriod?: Maybe<Scalars['String']>;
};

/** Result of mutation is the updated UserSettings object. */
export type UpdateCheerPartnerSettingsPayload = {
   __typename?: 'UpdateCheerPartnerSettingsPayload';
  /** The updated user settings object. */
  cheer: CheerPartnerSettings;
};

/** Partner settings related to the recent cheer message. */
export type UpdateCheerPartnerSettingsRecentCheerInput = {
  /** Flag that when true pins the recent cheer to their channel. */
  canPin?: Maybe<Scalars['Boolean']>;
  /** The minimum bits a user must cheer to show their cheer on the chat header. */
  minimumBits?: Maybe<Scalars['Int']>;
  /** The amount of time a recent cheer is shown before being dismissed. */
  timeoutMilliseconds?: Maybe<Scalars['Int']>;
};

/** Settings related to sponsored cheermote campaigns. */
export type UpdateCheerPartnerSettingsSponsoredCheermoteInput = {
  /** The campaign ID we are modifying for the user. */
  id: Scalars['ID'];
  /** Flag that is true if the user has opte