import { FunctionTimer } from './function-timer';

export class DebounceTimer implements FunctionTimer {
  private debounceDuration = 0;
  private timeout = 0;

  constructor(duration: number) {
    this.debounceDuration = duration;
  }

  public clear() {
    clearTimeout(this.timeout);
  }

  public invoke(fn: () => void) {
    clearTimeout(this.timeout);
    this.timeout = window.setTimeout(fn, this.debounceDuration);
  }
}
