import React, { useState, useCallback, useEffect } from 'react';
import { TableRow, TableCell } from 'twitch-core-ui';
import { GameWithCompany, Id, Company } from '~core/clients/rbac/code.justin.tv.devrel';
import { EntityProps } from '~features/entity-list/entity-list';
import { RBACClient } from '~core/vienna';

export interface PublicProps {}

type Props = PublicProps & EntityProps<GameWithCompany>;

export const GameListItem: React.FC<Props> = (props) => {
  const [company, setCompany] = useState<Company>();
  async function getCompany() {
    try {
      const result = await RBACClient.getCompany(new Id({ id: props.item.companyId }));
      setCompany(result);
    } catch {}
  }
  const getCompanyCallback = useCallback(getCompany, [props.item.companyId]);

  useEffect(() => {
    getCompanyCallback();
  }, [getCompanyCallback, props.item.companyId]);

  return (
    <TableRow>
      <TableCell>{props.item.gamename}</TableCell>
      <TableCell>{props.item.id}</TableCell>
      <TableCell>{props.item.giantbombId}</TableCell>
      <TableCell>{company?.companyName}</TableCell>
    </TableRow>
  );
};
