import React from 'react';
import {
  Layout,
  Display,
  JustifyContent,
  Pagination,
  PaginationMouseEvent,
  AlignItems,
  SearchInput,
  PaginationControl,
  PaginationControlType,
  FormLabel,
} from 'twitch-core-ui';
import './styles.scss';
import { PaginationProps, CursorPaginationProps } from '~features/hooks/use-pagination';

export interface PublicProps {
  onSearchChange?: (term: string) => void;
  searchPlaceholder?: string;
  searchLabel?: string;
  searchTerm?: string;
  additionalFields?: React.ReactChild[];
  pagination?: PaginationProps;
  cursorPagination?: CursorPaginationProps;
}

type Props = PublicProps;

export const ListingHeader: React.FC<Props> = (props) => {
  return (
    <Layout
      display={Display.Flex}
      justifyContent={JustifyContent.Between}
      margin={{ bottom: 2 }}
      className="listing-header"
    >
      <Layout>
        {props.pagination && (
          <Pagination
            currentPage={props.pagination.currentPage}
            totalPages={props.pagination.totalPages}
            previousPageButtonAriaLabel="Previous"
            nextPageButtonAriaLabel="Next"
            onClickNext={props.pagination.onNextPage}
            onClickPrevious={props.pagination.onPreviousPage}
            onClickIndex={(index: PaginationMouseEvent<HTMLDivElement>) =>
              props?.pagination?.onGoToPage(index.goToPage)
            }
          />
        )}
        {props.cursorPagination && (
          <Layout>
            <PaginationControl
              aria-label="Previous"
              type={PaginationControlType.Previous}
              totalPages={props.cursorPagination.totalPages}
              currentPage={props.cursorPagination.currentPage}
              onClick={props.cursorPagination.onPreviousPage}
            />
            <PaginationControl
              aria-label="Next"
              type={PaginationControlType.Next}
              totalPages={props.cursorPagination.totalPages}
              currentPage={props.cursorPagination.currentPage}
              onClick={props.cursorPagination.onNextPage}
            />
          </Layout>
        )}
      </Layout>
      <Layout display={Display.Flex} alignItems={AlignItems.Center}>
        {props.additionalFields &&
          props.additionalFields.length > 0 &&
          props.additionalFields.map((field, index) => (
            <Layout key={index} margin={{ right: 2 }}>
              {field}
            </Layout>
          ))}
        {props.onSearchChange && (
          <Layout display={Display.Flex} alignItems={AlignItems.Center}>
            {props.searchLabel && (
              <Layout padding={{ right: 1 }}>
                <FormLabel id={`${props.searchLabel}-label`} label={props.searchLabel} />
              </Layout>
            )}
            <Layout className="listing-header__search">
              <SearchInput
                value={props.searchTerm}
                onChange={(ev: React.ChangeEvent<HTMLInputElement>) =>
                  props.onSearchChange && props.onSearchChange(ev.target.value)
                }
                placeholder={props.searchPlaceholder}
              />
            </Layout>
          </Layout>
        )}
      </Layout>
    </Layout>
  );
};
