import React from 'react';
import { CompanyApplication } from '~core/clients/rbac/code.justin.tv.devrel';
import { TableRow, TableCell, CoreLink } from 'twitch-core-ui';
import { OrganizationApplicationStatus } from '~features/organization-application/models/organization-application-status';
import { DateTime } from 'luxon';
import { EntityProps } from '~features/entity-list/entity-list';

export interface PublicProps {}

type Props = PublicProps & EntityProps<CompanyApplication>;

export const OrganizationApplicationListItem: React.FC<Props> = (props) => {
  return (
    <TableRow>
      <TableCell>
        <CoreLink linkTo={`/organizations/review/${props.item.id}`}>
          {props.item.companyName}
        </CoreLink>
      </TableCell>
      <TableCell>{props.item.games.length}</TableCell>
      <TableCell>{OrganizationApplicationStatus[props.item.status]}</TableCell>
      <TableCell>
        {DateTime.fromISO(props.item.createdAt).toLocaleString(DateTime.DATETIME_MED)}
      </TableCell>
    </TableRow>
  );
};
