import React from 'react';
import { Layout, CoreText, TextType } from 'twitch-core-ui';

export interface PublicProps {
  title: string;
  subtitle?: string;
  marginBottom?: 0 | 0.5 | 1 | 2 | 3 | 4 | 5 | 'auto' | undefined;
}

type Props = PublicProps;

export const PageHeader: React.FC<Props> = (props) => {
  return (
    <Layout margin={{ bottom: props.marginBottom || 4 }}>
      <CoreText type={TextType.H1}>{props.title}</CoreText>
      {props.subtitle && <CoreText type={TextType.P}>{props.subtitle}</CoreText>}
    </Layout>
  );
};
