import React from 'react';
import { Layout } from 'twitch-core-ui';
import { CategoryHeader } from '~features/side-bar/components/category-header/category-header';
import { CategoryItemData } from '~features/side-bar/models/category-item-data';
import { Categoryitem } from '~features/side-bar/components/category-item';

export interface PublicProps {
  title?: string;
  items: CategoryItemData[];
}

type Props = PublicProps;

export const CategorySection: React.FC<Props> = props => {
  return (
    <Layout className="category-section">
      {props.title && <CategoryHeader title={props.title} />}
      <Layout className="category-section__items">
        {props.items.map((item, index) => {
          return (
            <Categoryitem title={item.name} linkTo={item.linkTo} key={index} />
          );
        })}
      </Layout>
    </Layout>
  );
};
