import React from 'react';
import { StyledLayout, Background, Layout } from 'twitch-core-ui';
import './styles.scss';
import { CategorySection } from '~features/side-bar/components/category-section/category-section';
import { AuthenticationBanner } from '~features/authentication-banner/authentication-banner';

export interface PublicProps {}

type Props = PublicProps;

export const SideBar: React.FC<Props> = () => {
  return (
    <StyledLayout background={Background.Alt} className="side-bar" fullHeight padding={{ top: 5 }}>
      <Layout margin={{ top: 1 }}>
        <Layout>
          <AuthenticationBanner />
        </Layout>
        <CategorySection items={[{ name: 'Organizations', linkTo: '/organizations' }]} />
        <CategorySection items={[{ name: 'Games', linkTo: '/games' }]} />
        <CategorySection items={[{ name: 'Extensions', linkTo: '/extensions' }]} />
        <CategorySection items={[{ name: 'E2 Client Allowlist', linkTo: '/e2' }]} />
      </Layout>
    </StyledLayout>
  );
};
