import React, { useState } from 'react';
import { get as getCookie } from 'js-cookie';
import { getJWTFromCookie, getJwtProperty } from 'bouncer-auth-js';

export interface UserContextStore {
  twitchToken?: string;
  bouncerToken?: string;
  LDAPRoles: string[];
  setTwitchToken: (token?: string) => void;
}

export const UserContext = React.createContext<UserContextStore>({
  twitchToken: undefined,
  bouncerToken: undefined,
  LDAPRoles: [],
  setTwitchToken: () => null,
});

export const UserContextProvider: React.FC = (props) => {
  const authToken = getCookie('vienna_auth_token');
  const [twitchToken, setTwitchToken] = useState(authToken);
  const [bouncerToken] = useState(getJWTFromCookie('bouncer_auth'));
  const [LDAPRoles] = useState(getJwtProperty('bouncer_auth', 'roles'));

  return (
    <UserContext.Provider value={{ twitchToken, setTwitchToken, bouncerToken, LDAPRoles }}>
      {props.children}
    </UserContext.Provider>
  );
};
