import { ToastContainer } from 'react-toastify';
import React from 'react';
import { Router } from 'react-router-dom';
import { history, apolloClient } from '~core/vienna';
import { Layout, Display, FlexDirection, Overflow } from 'twitch-core-ui';
import './styles.scss';
import { TopBar } from '~features/top-bar';
import { SideBar } from '~features/side-bar';
import { RootRouter } from '~features/vienna-root/root-router/root-router';
import { UserContextProvider } from '~features/user-context/user-context';
import Modal from 'react-modal';
import { ModalRoot } from 'tachyon-modal';
import { ApolloProvider } from '@apollo/react-hooks';

Modal.setAppElement('#root');

export const ViennaRoot: React.FC = () => {
  return (
    <ApolloProvider client={apolloClient}>
      <UserContextProvider>
        <Router history={history}>
          <ModalRoot appElementId="root">
            <Layout className="root">
              <TopBar />
              <Layout
                display={Display.Flex}
                fullWidth
                className="main-content"
                overflow={Overflow.Auto}
              >
                <SideBar />
                <Layout
                  display={Display.Flex}
                  flexDirection={FlexDirection.Column}
                  className="content-area"
                  overflow={Overflow.Auto}
                >
                  <RootRouter />
                </Layout>
              </Layout>
            </Layout>
            <ToastContainer />
          </ModalRoot>
        </Router>
      </UserContextProvider>
    </ApolloProvider>
  );
};
