import React from 'react';
import { Layout, Button, Display, AlignSelf } from 'twitch-core-ui';
import { PageHeader } from '~features/page-header';
import { E2ListPage } from '~pages/e2-list';
import { ViennaLDAPRoles } from '~core/components/with-authorization/roles';
import { UnauthorizedBehavior, withAuthorization } from '~core/components/with-authorization';
import { AllowlistE2Modal, E2ModalSchema } from '~features/allowlist-e2-modal/allowlist-e2-modal';
import { useModal } from 'tachyon-modal';
import { TwitchE2IngestHTTPClient } from '~core/vienna';
import { CreateAllowlistEntryRequest } from '~core/clients/twitch-e2-ingest-http/twitch.fulton.example';
import { toast } from 'react-toastify';
import { getJwtProperty } from 'bouncer-auth-js';

export const E2RootPageComponent: React.FC = () => {
  const { id, closeModal, openModal, active } = useModal();

  async function createAllowlistEntry(values: E2ModalSchema) {
    try {
      await TwitchE2IngestHTTPClient.createAllowlistEntry(
        new CreateAllowlistEntryRequest({
          ...values,
          createdBy: getJwtProperty('bouncer_auth', 'name'),
        }),
      );
      toast('Allowlisted!', { type: 'success' });
    } catch (err) {
      toast(`Failed to allowlist: ${err.message}`, { type: 'error' });
    }
  }

  return (
    <Layout padding={2} fullWidth fullHeight>
      <Layout display={Display.Flex}>
        <Layout flexGrow={1}>
          <PageHeader
            title="E2 Client Allowlist"
            subtitle="Find all the E2 clients allowlisted for organizations below"
          />
        </Layout>
        <Layout alignSelf={AlignSelf.Center}>
          <Button onClick={openModal}>Allowlist E2 Client</Button>
        </Layout>
      </Layout>
      <E2ListPage />
      <AllowlistE2Modal
        id={id}
        closeModal={closeModal}
        active={active}
        onSubmit={createAllowlistEntry}
      />
    </Layout>
  );
};

export const E2RootPage = withAuthorization({
  role: ViennaLDAPRoles.BaseAccess,
  behavior: UnauthorizedBehavior.Redirect,
})(E2RootPageComponent);
