import React from 'react';
import { Layout, Tabs, JustifyContent } from 'twitch-core-ui';
import { PageHeader } from '~features/page-header';
import { useLocation } from 'react-router';

export const ExtensionRootEntry: React.FC = (props) => {
  const location = useLocation();

  function determineTab() {
    switch (location.pathname) {
      case '/extensions':
        return 0;
      default:
        return 0;
    }
  }

  return (
    <>
      <PageHeader title="Extensions" subtitle="Manage extensions" />
      <Layout margin={{ bottom: 4 }}>
        <Tabs
          tabs={[
            {
              label: 'Management',
              linkTo: '/extensions',
            },
          ]}
          activeTabIndex={determineTab()}
          justifyContent={JustifyContent.Start}
        />
      </Layout>
      {props.children}
    </>
  );
};
