import React, { useState, useCallback, useEffect } from 'react';
import { RBACClient } from '~core/vienna';
import {
  GetAllGamesWithCompaniesRequest,
  GameWithCompany,
} from '~core/clients/rbac/code.justin.tv.devrel';
import { usePagination } from '~features/hooks/use-pagination';
import { EntityList } from '~features/entity-list/entity-list';
import { GameListItem } from '~features/games/list/components/game-list-item';

const GAME_LIMIT = 25;

export const GamesListPage: React.FC = () => {
  const { page, nextPage, previousPage, goToPage } = usePagination();
  const [total, setTotal] = useState(0);
  const [games, setGames] = useState<GameWithCompany[]>([]);

  async function getGames() {
    try {
      const result = await RBACClient.getAllGamesWithCompanies(
        new GetAllGamesWithCompaniesRequest({
          limit: GAME_LIMIT,
          offset: GAME_LIMIT * (page - 1),
        }),
      );

      setGames(result.games);
      setTotal(Math.ceil(result.Total / GAME_LIMIT));
    } catch (err) {}
  }
  const getGamesCallback = useCallback(getGames, [page]);

  useEffect(() => {
    getGamesCallback();
  }, [getGamesCallback, page]);

  return (
    <EntityList<GameWithCompany>
      pagination={{
        onGoToPage: goToPage,
        onNextPage: nextPage,
        onPreviousPage: previousPage,
        totalPages: total,
        currentPage: page,
      }}
      items={games}
      rowType={GameListItem}
      rowProps={{}}
      columns={['Name', 'Game ID', 'Giant Bomb ID', 'Company']}
      zeroStateMessage="No Games found"
      header={{}}
    />
  );
};
