import React from 'react';
import { Layout, Tabs, JustifyContent } from 'twitch-core-ui';
import { PageHeader } from '~features/page-header';
import { useLocation } from 'react-router';

export const GamesRootEntry: React.FC = (props) => {
  const location = useLocation();

  function determineTab() {
    switch (location.pathname) {
      case '/games':
        return 0;
      case '/games/review':
        return 1;
      default:
        return 0;
    }
  }

  return (
    <Layout fullHeight fullWidth>
      <PageHeader title="Games" subtitle="Manage and Review Games using the options below" />
      <Layout margin={{ bottom: 2 }}>
        <Tabs
          tabs={[
            {
              label: 'Overview',
              linkTo: '/games',
            },
            {
              label: 'Review',
              linkTo: '/games/review',
            },
          ]}
          activeTabIndex={determineTab()}
          justifyContent={JustifyContent.Start}
        />
      </Layout>
      {props.children}
    </Layout>
  );
};
