import React from 'react';
import { DeveloperApplication } from '~core/clients/rbac/code.justin.tv.devrel';
import { Layout, TableHeading, TableRow, Table, TableBody, TableHeader } from 'twitch-core-ui';
import { OrganizationDeveloperApplicationItem } from '~features/organization-developer-applications/components/organization-developer-application';

export interface PublicProps {
  developers: DeveloperApplication[];
  onOnboarding: (applicationId: string, role: string) => void;
  onRemove: (applicationId: string) => void;
}

type Props = PublicProps;

export const OrganizationDevelopersPresentation: React.FC<Props> = (props) => {
  return (
    <Layout>
      <Table>
        <TableHeader>
          <TableRow>
            <TableHeading label="Name" />
            <TableHeading label="Title" />
            <TableHeading label="Email" />
            <TableHeading label="Verified Email?" />
            <TableHeading label="Twitch ID" />
            <TableHeading label="Date Created" />
          </TableRow>
        </TableHeader>
        <TableBody>
          {props.developers.map((developer, index) => (
            <OrganizationDeveloperApplicationItem
              key={index}
              application={developer}
              onOnboard={props.onOnboarding}
              onRemove={props.onRemove}
            />
          ))}
        </TableBody>
      </Table>
    </Layout>
  );
};
