import React from 'react';
import {
  Layout,
  CoreText,
  TextType,
  TableHeader,
  TableRow,
  Table,
  TableHeading,
  TableBody,
  TableCell,
  InFeatureNotification,
  NotificationType,
  Display,
  JustifyContent,
  Button,
  ButtonType,
  AlignItems,
} from 'twitch-core-ui';
import { CompanyApplication } from '~core/clients/rbac/code.justin.tv.devrel';
import { OrganizationForm } from '~features/organizations/components/organization-form';
import { OrganizationInformation } from '~pages/organization-detail/models/organization-information';
import { PageHeader } from '~features/page-header';

export interface PublicProps {
  application: CompanyApplication;
  onUpdateApplication: (values: OrganizationInformation) => void;
  onRejectApplication: () => void;
  onApproveApplication: () => void;
}

type Props = PublicProps;

export const ApplicationPending: React.FC<Props> = (props) => {
  return (
    <Layout padding={2}>
      <Layout
        margin={{ bottom: 4 }}
        display={Display.Flex}
        alignItems={AlignItems.Center}
        justifyContent={JustifyContent.Between}
      >
        <PageHeader
          title={props.application.companyName}
          subtitle="Find all the details to review and update below"
        />
        <Layout display={Display.Flex}>
          <Layout margin={{ right: 1 }}>
            <Button type={ButtonType.Alert} onClick={props.onRejectApplication}>
              Reject
            </Button>
          </Layout>
          <Button onClick={props.onApproveApplication}>Approve</Button>
        </Layout>
      </Layout>
      <Layout margin={{ bottom: 2 }}>
        <OrganizationForm
          onSubmit={props.onUpdateApplication}
          organization={{
            companyName: props.application.companyName,
            url: props.application.companyWebsite,
            type: props.application.companyType,
          }}
        />
      </Layout>
      <Layout margin={{ bottom: 2 }}>
        <Layout margin={{ bottom: 2 }}>
          <CoreText type={TextType.H3}>Organization Owner</CoreText>
        </Layout>
        <Table>
          <TableHeader>
            <TableRow>
              <TableHeading label="First Name" />
              <TableHeading label="Last Name" />
              <TableHeading label="Title" />
              <TableHeading label="Email" />
              <TableHeading label="Email Verification Status" />
              <TableHeading label="Twitch ID" />
            </TableRow>
          </TableHeader>
          <TableBody>
            <TableRow>
              <TableCell>{props.application.contactFirstName}</TableCell>
              <TableCell>{props.application.contactLastName}</TableCell>
              <TableCell>{props.application.contactTitle}</TableCell>
              <TableCell>{props.application.contactEmail}</TableCell>
              <TableCell>{props.application.emailVerificationStatus}</TableCell>
              <TableCell>{props.application.twitchId}</TableCell>
            </TableRow>
          </TableBody>
        </Table>
      </Layout>
      {props.application.games && props.application.games.length > 0 && (
        <Layout>
          <Layout margin={{ bottom: 2 }}>
            <CoreText type={TextType.H3}>Game Applications</CoreText>
          </Layout>
          <Layout margin={{ bottom: 1 }}>
            <InFeatureNotification
              type={NotificationType.Info}
              message={{
                title: 'Approval Needed',
                description:
                  'These game applications ned to be approved after this company is approved in organizations management',
              }}
            />
          </Layout>
          <Layout>
            <Table>
              <TableHeader>
                <TableRow>
                  <TableHeading label="Game Name" />
                  <TableHeading label="Game Twitch ID" />
                </TableRow>
              </TableHeader>
              <TableBody>
                {props.application.games.map((game, index) => (
                  <TableRow key={index}>
                    <TableCell>{game.name}</TableCell>
                    <TableCell>{game.id}</TableCell>
                  </TableRow>
                ))}
              </TableBody>
            </Table>
          </Layout>
        </Layout>
      )}
    </Layout>
  );
};
