# Package [cors](https://godoc.internal.justin.tv/code.justin.tv/infosec/cors)
```go
import "code.justin.tv/infosec/cors
```
CORS represents a series of headers sent to the client to allow it to
make decisions about whether it can allow an XHR object to access the resource. This
package tries to express these headers using an abstraction as thin as possible.

More details in the godoc.

```go
CORSPolicy = cors.Policy {
	AllowedOrigins: cors.Origins("localhost", "cool.com"),

	MaxAge: cors.MaxAge(5 * time.Hour),
}

func ContentHandler(w http.ResponseWriter, r *http.Request) {
	w.Write([]byte("hello"))
}

//if OPTIONS happens, we block out the ContentHandler for the preflight request, so
//we don't perform an action / send data
var mainHandler = CORSPolicy.MustMiddleware(
	cors.BlockOnOptions(http.HandlerFunc(ContentHandler)))
```
