package actionhistories

import (
	"context"
	"testing"

	"code.justin.tv/devrel/devsite-rbac/backend/common/commonfakes"
	"github.com/stretchr/testify/require"
)

func TestInsertActionHistory(t *testing.T) {
	fakeDBX, actionHistories := newDBXActionHistories()
	fakeDBX.InsertOneReturns(nil)

	a := &ActionHistory{
		UserTwitchID: "123",
		Action:       "Testing some stuff",
		EntityType:   "Game",
		EntityID:     "doom",
	}
	actionHistories.InsertActionHistory(context.Background(), a)

	require.Equal(t, "123", a.UserTwitchID)
	require.NotEmpty(t, a.ID, "ID is generated as uuid")
	require.NotEmpty(t, a.CreatedAt, "CreatedAt is generated with current timestamp")

	require.Equal(t, 1, fakeDBX.InsertOneCallCount())
}

//
// Test Helpers
//

func newDBXActionHistories() (*commonfakes.FakeDBXer, *DBXActionHistories) {
	fakeDBX := &commonfakes.FakeDBXer{}
	return fakeDBX, &DBXActionHistories{
		DBX: fakeDBX,
	}
}
