package companyapplications

import (
	"testing"

	"github.com/stretchr/testify/require"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func TestToRBACCompayApplicationGamesFromStr(t *testing.T) {
	for _, testCase := range []struct {
		input    string
		expected []*rbacrpc.CompanyApplication_Game
	}{
		{
			input:    "",
			expected: nil,
		},
		{
			input: "1",
			expected: []*rbacrpc.CompanyApplication_Game{
				{Id: "1"},
			},
		},
		{
			input: "1,2,3",
			expected: []*rbacrpc.CompanyApplication_Game{
				{Id: "1"}, {Id: "2"}, {Id: "3"},
			},
		},
	} {
		t.Run(testCase.input, func(t *testing.T) {
			actual := ToRPCGamesFromStr(testCase.input)
			require.Equal(t, testCase.expected, actual)
		})
	}
}
