package companyresources

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/common"
	"code.justin.tv/devrel/devsite-rbac/backend/companies"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (b *backend) FindCompaniesWithResource(ctx context.Context, externalID, resourceType string) ([]*rbacrpc.Company, error) {
	var cs []companies.Company
	err := b.db.LoadAll(ctx, &cs, common.PSQL.Select(
		companies.Columns.Mapf("c.? as ?")...).
		From("company_resources as cr").
		Join("companies as c on c.id = cr.company_id").
		Where("cr.resource_id = ?", externalID).
		Where("cr.resource_type = ?", resourceType))

	return companies.ListToRPC(cs), err
}
