package developerapplications

import (
	"context"
)

// NoopClient implements the developerapplications.Backender interface as a NOOP,
// to provide predictable developer applications in unit tests
type NoopClient struct{}

func (c *NoopClient) GetDeveloperApplication(ctx context.Context, id string) (DeveloperApplication, error) {
	return DeveloperApplication{
		ID:        id,
		CompanyID: "compid" + id,
		TwitchID:  "twitchid" + id,
		FirstName: "John",
		LastName:  "Doe",
		CreatedAt: "2018-01-01T00:00:00Z",
	}, nil
}

func (c *NoopClient) ListDeveloperApplications(ctx context.Context, p ListDeveloperApplicationsParams) ([]DeveloperApplication, error) {
	return []DeveloperApplication{}, nil
}

func (c *NoopClient) InsertDeveloperApplication(ctx context.Context, devApp *DeveloperApplication) error {
	return nil
}

func (c *NoopClient) DeleteDeveloperApplication(ctx context.Context, id string) error {
	return nil
}

func (c *NoopClient) DeleteDeveloperApplicationByAccount(ctx context.Context, id string) error {
	return nil
}

func (c *NoopClient) DeleteDeveloperApplicationByCompany(ctx context.Context, id string) error {
	return nil
}
