package gameapplications

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/common"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/cactus/go-statsd-client/statsd"
)

//go:generate counterfeiter . GABackender
//go:generate errxer --timings GABackender
type GABackender interface {
	FindGameApplications(ctx context.Context, params *rbacrpc.ListGameApplicationsRequest) (*rbacrpc.ListGameApplicationsResponse, error)
	FindGameApplicationsByCompany(ctx context.Context, id string) (*rbacrpc.GetGameApplicationsByCompanyResponse, error)
	SelectGameApplication(ctx context.Context, id string) (*rbacrpc.GameApplication, error)
	SelectGameApplicationByGameId(ctx context.Context, gameId int32) (*rbacrpc.GameApplication, error)
	InsertGameApplication(ctx context.Context, params *rbacrpc.CreateGameApplicationRequest) (*rbacrpc.GameApplication, error)
	DeleteGameApplication(ctx context.Context, params *rbacrpc.DeleteGameApplicationRequest) error
	DeleteGameApplicationsByCompany(ctx context.Context, companyID string) error
}

type backend struct {
	db common.DBXer
}

func New(db common.DBXer, stats statsd.Statter) *GABackenderErrx {
	return &GABackenderErrx{
		GABackender: &backend{db: db},
		TimingFunc:  common.TimingStats(stats),
	}
}
