package gameapplications

import (
	"context"
	"fmt"

	"code.justin.tv/devrel/dbx"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (b *backend) DeleteGameApplication(ctx context.Context, params *rbacrpc.DeleteGameApplicationRequest) error {
	return b.db.DeleteOne(ctx, Table, dbx.Values{"id": params.Id})
}

func (b *backend) DeleteGameApplicationsByCompany(ctx context.Context, companyID string) error {
	ga := GameApplication{
		CompanyID: companyID,
	}

	_, err := b.db.NamedExec(ctx, fmt.Sprintf("DELETE FROM %s WHERE company_id = :company_id", Table), ga)

	return err
}
