package gameapplications

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/common"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (b *backend) FindGameApplications(ctx context.Context, params *rbacrpc.ListGameApplicationsRequest) (*rbacrpc.ListGameApplicationsResponse, error) {
	var gameApplications []GameApplication
	err := b.db.LoadAll(ctx, &gameApplications, b.selectGameApplicationsQuery(params))
	if err != nil {
		return nil, err
	}

	return &rbacrpc.ListGameApplicationsResponse{
		GameApplications: listToRPC(gameApplications),
		XTotal:           common.FirstRowInt32DBField(gameApplications, "_total"),
	}, nil
}
