package gameapplications

import (
	"context"
	"time"

	"code.justin.tv/devrel/dbx"
	"code.justin.tv/devrel/devsite-rbac/backend/common"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (b *backend) InsertGameApplication(ctx context.Context, params *rbacrpc.CreateGameApplicationRequest) (*rbacrpc.GameApplication, error) {
	gameApplication := GameApplication{
		ID:        common.NewUUID(),
		GameID:    params.GameId,
		CompanyID: params.CompanyId,
		CreatedAt: time.Now().Format(time.RFC3339),
	}
	err := b.db.InsertOne(ctx, Table, &gameApplication, dbx.Exclude("_total"))
	return gameApplication.toRPC(), err
}
