package testutils

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/auth"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func MockContextWithOauthToken(ctx context.Context) context.Context {
	return auth.WithRawAuthorizationToken(ctx, "ASFAHFKLQIOETPTPYKKJA")
}

func MockContextWithViennaRole(ctx context.Context, role rbacrpc.WhitelistUserRole) context.Context {
	return context.WithValue(ctx, auth.ViennaUserWhitelistRoleKey, role)
}
