package dart

import (
	"context"

	receiver "code.justin.tv/amzn/TwitchDartReceiverTwirp"
)

// NoopClient implements the Dart interface as a NOOP,
// to provide predictable results in a test environment.
type NoopClient struct{}

// SendCompanyInviteToUser does nothing
func (c *NoopClient) SendCompanyInviteToUser(ctx context.Context, userId string, organizationName string) (string, error) {
	return "", nil
}

// SendDeveloperCompanyActionApproved does nothing
func (c *NoopClient) SendDeveloperCompanyActionApproved(ctx context.Context, userId string, organizationName string) (string, error) {
	return "", nil
}

// SendDeveloperCompanyActionDenied does nothing
func (c *NoopClient) SendDeveloperCompanyActionDenied(ctx context.Context, userId string, organizationName string) (string, error) {
	return "", nil
}

// SendDeveloperCompanyUserActionAdded does nothing
func (c *NoopClient) SendDeveloperCompanyUserActionAdded(ctx context.Context, userId string, organizationName string) (string, error) {
	return "", nil
}

// SendDeveloperCompanyUserActionRemoved does nothing
func (c *NoopClient) SendDeveloperCompanyUserActionRemoved(ctx context.Context, userId string, organizationName string) (string, error) {
	return "", nil
}

// SendDeveloperCompanyGameActionApproved does nothing
func (c *NoopClient) SendDeveloperCompanyGameActionApproved(ctx context.Context, userId string, organizationName string) (string, error) {
	return "", nil
}

// SendDeveloperCompanyGameActionDenied does nothing
func (c *NoopClient) SendDeveloperCompanyGameActionDenied(ctx context.Context, userId string, organizationName string) (string, error) {
	return "", nil
}

// PublishNotification does nothing
func (c *NoopClient) PublishNotification(ctx context.Context, request *receiver.PublishNotificationRequest) (string, error) {
	return "", nil
}
