package nioh

import (
	"context"

	niohCli "code.justin.tv/commerce/nioh/rpc/nioh"
	"code.justin.tv/foundation/twitchclient"
)

//go:generate errxer Nioh
//go:generate counterfeiter . Nioh
type Nioh interface {
	SetOrgRestrictionOnChannel(ctx context.Context, callerID string, channelID string) error
}

type clientImpl struct {
	client niohCli.API
}

func NewClient(hostURL string, clientConf twitchclient.ClientConf) Nioh {
	client := niohCli.NewAPIProtobufClient(hostURL, twitchclient.NewHTTPClient(clientConf))
	return &NiohErrx{Nioh: &clientImpl{client: client}}
}

func (c *clientImpl) SetOrgRestrictionOnChannel(ctx context.Context, callerID string, channelID string) error {
	req := &niohCli.SetResourceRestrictionRequest{
		UserId:  callerID,
		OwnerId: channelID,
		Resource: &niohCli.RestrictionResource{
			Id:   channelID,
			Type: niohCli.ResourceType_LIVE,
		},
		Restriction: &niohCli.Restriction{
			RestrictionType: niohCli.Restriction_ORGANIZATION_ACCESS_ONLY,
		},
	}
	_, err := c.client.SetResourceRestriction(ctx, req)
	return err
}
