package passport

import (
	"context"
	"strconv"
)

type Fake struct{}

func (f Fake) GetTwoFactorEnabled(ctx context.Context, twitchID string) (bool, error) {
	_, err := strconv.Atoi(twitchID)
	if err != nil {
		return false, err
	}
	return true, nil
}

func (f Fake) SignUpNewAccount(ctx context.Context, req CreateNewAccountRequest) (CreateNewAccountResponse, error) {
	return CreateNewAccountResponse{
		AccessToken: "someaccesstoken",
	}, nil
}
