package pushy

import (
	"context"

	"code.justin.tv/chat/pushy/client/events"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sns"
	"github.com/cactus/go-statsd-client/statsd"
)

// Emailer is a simiplifier interface to send Pushy emails
//go:generate errxer Emailer
type Emailer interface {
	// Publishes an Event to send notification(s)
	Publish(ctx context.Context, eventName string, data interface{}) error
}

func New(topic string, statsClient statsd.Statter) (Emailer, error) {
	sess, err := session.NewSession(&aws.Config{Region: aws.String("us-west-2")})
	if err != nil {
		return nil, err
	}

	snsClient := sns.New(sess)

	pushyClient, err := events.NewPublisher(events.Config{
		DispatchSNSARN: topic,
		Stats:          statsClient,
		SNSClient:      snsClient,
	})
	return &EmailerErrx{Emailer: pushyClient}, err
}
