# RBAC Deploys

We recently changed our deploy process to utilize pipelines inside the respective accounts. Merging your branch to develop will automatically deploy it to staging. Merging into master will trigger a build/deploy for production but will require manual approve before it finishes the deploy. Please reach out to a maintainer to approve production deploys.

Note: These links assume you have Isengard access to the accounts

[Development Pipeline](https://isengard.amazon.com/federate?account=059023621032&role=admin&destination=codesuite%2Fcodepipeline%2Fpipelines%2FRbac-Deploy-Staging%2Fview%3Fregion%3Dus-west-2%23)

[Production Pipeline](https://isengard.amazon.com/federate?account=712827439730&role=admin&destination=codesuite%2Fcodepipeline%2Fpipelines%2FRbac-Deploy-Production%2Fview%3Fregion%3Dus-west-2%23)

## Deploying non-standard branches

Occasionally we are making big changes and want to do some staging testing before merging it into develop, this is possible but not currently automated. Below are the steps you will need to take to deploy any branch or commit hash, examples will include staging but this can be used to roll production forward/backwards to a specific commit as well.

* Make sure your branch is up to date with develop, you won't want to overwrite someone elses changes and break something!
* Navigate to the CodeBuild job that creates a source package for deployment [RBAC-Deploy-Source](https://isengard.amazon.com/federate?account=059023621032&role=admin&destination=codesuite%2Fcodebuild%2Fhome%3Fregion%3Dus-west-2%23)
* Click Start Build in the top left corner
* `Source version - optional Info` will be prepopulated, change this to the branch or commit id you want to deploy
* Click Start in the top conner
* Done! Once you start this build it will trigger the pipeline mentioned above. You will need to follow this pipeline as it does run the tests, ect and may fail if your tests are not passing.