package e2e

import (
	"testing"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/stretchr/testify/suite"
)

func Test_ExtensionReviewsSuite(t *testing.T) {
	s := &ExtensionReviewsSuite{}
	suite.Run(t, s)
}

type ExtensionReviewsSuite struct {
	Suite
	ExtensionReviews rbacrpc.ExtensionReviews // Service Twitp client
}

func (s *ExtensionReviewsSuite) SetupTest() {
	s.Suite.SetupTest()

	httpClient := &httpClientWithCartmanToken{CartmanToken: "fake-cartman-token", Client: s.HTTPClient}
	s.ExtensionReviews = rbacrpc.NewExtensionReviewsProtobufClient(e2eServiceAddr, httpClient)
}

func (s *ExtensionReviewsSuite) Test_SetStateInReview_ThenApprove() {
	extID := "fff"
	extVersion := "0.0.1"

	// Set in review by a user
	_, err := s.ExtensionReviews.SetStateInReview(s.Ctx, &rbacrpc.SetStateInReviewRequest{
		UserTwitchId:     "123",
		ExtensionId:      extID,
		ExtensionVersion: extVersion,
		TestChannel:      "tothemario",
		Notes:            "Test stuff",
	})
	s.NoError(err)

	// Admin approves
	_, err = s.ExtensionReviews.SetStateApproved(s.AdminCtx, &rbacrpc.SetStateReviewerRequest{
		ExtensionId:       extID,
		ExtensionVersion:  extVersion,
		ReviewReasonCodes: []string{"1.1", "6.2.2"},
		ReviewReason:      "Stuff happens",
	})
	s.NoError(err)

	// Check review logs
	ext, err := s.ExtensionReviews.GetExtension(s.AdminCtx, &rbacrpc.ExtensionVersionID{Id: extID, Version: extVersion})
	s.NoError(err)

	logs := ext.TransitionLogs // ExtensionReviewLog
	s.Len(logs, 2)
}
