import { Secret } from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
import { PROD_ACCOUNT_ID } from './consts';

export class CommonStack extends cdk.Stack {
  public pdmsSecret: Secret;
  constructor(scope: cdk.Construct, id: string, props: cdk.StackProps) {
    super(scope, id, props);

    const prod = props.env!.account === PROD_ACCOUNT_ID;
    this.pdmsSecret = new Secret(this, 'PdmsSecret', {
      secretName: 'devsite/rbac/' + (prod ? 'production' : 'staging') + '/pdms_api_key',
      generateSecretString: {
        excludePunctuation: true,
      }
    });
  }
}
