package main

import (
        "fmt"
        "context"
		"github.com/aws/aws-lambda-go/lambda"
		"net/http"
	"os"
	"strings"
)

type MyEvent struct {
        Name string `json:"name"`
}

func HandleRequest(ctx context.Context, name MyEvent) (string, error) {
		url := os.Getenv("RBAC_URL")
		apiKey := os.Getenv("RBAC_API_KEY")

		request := strings.NewReader(fmt.Sprintf("{\"ApiKey\": \"%v\"}", apiKey))
		result, err := http.Post(url, "application/json", request)

		if err != nil {
			return "nil", err
		}
        return fmt.Sprintf("%v", result), nil
}

func main() {
        lambda.Start(HandleRequest)
}
