package errorutil

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestFilterFilename(t *testing.T) {
	for _, testCase := range []struct {
		name     string
		filename string

		expected string
	}{
		{
			name:     "gopath",
			filename: "/Users/kevipike/dev/go/src/code.justin.tv/devrel/devsite-rbac/rpc/rbacrpcserver/onboard_company.go",
			expected: "/rpc/rbacrpcserver/onboard_company.go",
		}, {
			name:     "twirp",
			filename: "/Users/kevipike/dev/go/src/code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc/rbacrpc.twirp.go",
			expected: "",
		}, {
			name:     "goroot",
			filename: "/usr/local/Cellar/go/1.12/libexec/src/net/http/server.go",
			expected: "",
		}, {
			name:     "gomodule?",
			filename: "github.com/rs/cors/cors.go",
			expected: "",
		},
	} {
		t.Run(testCase.name, func(t *testing.T) {
			f := StackTraceFormatter{}
			actual := f.filterFilename(testCase.filename)
			require.Equal(t, testCase.expected, actual)
		})
	}
}
