package logstatter

import (
	"log"
	"time"

	"github.com/cactus/go-statsd-client/statsd"
)

// A LogStatter implements Statter but logs the stats in stdout
type LogStatter struct {
	*statsd.NoopClient // all methods are noop by default
}

// TimingDuration overrides the noop implementation, shows the stat in the console with the timings.
// This is useful to see the calls to the API and DB in the console when running locally.
func (s *LogStatter) TimingDuration(stat string, delta time.Duration, rate float32) error {
	log.Printf("statsd: %s (%s)\n", stat, delta.Round(time.Millisecond).String())
	return nil
}
