package middleware

import (
	"net/http"

	"github.com/rs/cors"
)

func CORS(environment string) func(http.Handler) http.Handler {
	viennaURLOld := "https://vienna-staging.internal.justin.tv"
	viennaURLNew := "https://staging.devsite-vienna.xarth.tv"
	viennaV2Cloudfront := "https://d318c4bj3zhce9.cloudfront.net"
	viennaV2Xarth := "https://vienna.xarth.tv"

	if environment == "production" {
		viennaURLOld = "https://vienna.internal.justin.tv"
		viennaURLNew = "https://devsite-vienna.xarth.tv"
	}

	return cors.New(cors.Options{
		AllowedOrigins: []string{"http://localhost:3000", viennaV2Xarth, viennaURLOld, viennaURLNew, viennaV2Cloudfront},
		AllowedHeaders: []string{"*"},
		AllowedMethods: []string{"POST"},
	}).Handler
}
