package middleware

import (
	"net/http"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/logx"
)

// InterceptPanics intercepts panics and logs them as errors (should show up in Rollbar).
// It does not write an HTTP response because that is supposedly done by the Twirp handler.
func InterceptPanics(h http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		defer func() {
			if p := recover(); p != nil {
				logx.Error(r.Context(), errx.Wrap(errx.New(p), "panic intercepted"))
			}
		}()
		h.ServeHTTP(w, r)
	})
}
