package middleware

import (
	"net/http"

	"code.justin.tv/sse/malachai/pkg/s2s/callee"
)

//go:generate counterfeiter code.justin.tv/sse/malachai/pkg/s2s/callee.ClientAPI
//go:generate counterfeiter net/http.Handler
func S2S(calleeClient callee.ClientAPI) func(http.Handler) http.Handler {
	return func(h http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			// health is a health check and should not be protected
			// requests with authorization header come from vienna
			// and will not have s2s headers.
			if r.URL.Path == "/health" || r.Header.Get(authorizationHeader) != "" {
				h.ServeHTTP(w, r)
				return
			}

			calleeClient.CapabilitiesInjectorMiddleware(h).ServeHTTP(w, r)
		})
	}
}
